VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.UserControl ArmCombobox 
   ClientHeight    =   600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3048
   MaskColor       =   &H00808080&
   ScaleHeight     =   600
   ScaleWidth      =   3048
   Begin VB.CommandButton cmd_Combo 
      DisabledPicture =   "A_CMBX.ctx":0000
      Height          =   280
      Left            =   2040
      Picture         =   "A_CMBX.ctx":00FA
      Style           =   1  'Graphical
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   120
      UseMaskColor    =   -1  'True
      Width           =   250
   End
   Begin MSComctlLib.ImageCombo Combo 
      Height          =   300
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   2652
      _ExtentX        =   4678
      _ExtentY        =   529
      _Version        =   393216
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   8.4
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
End
Attribute VB_Name = "ArmCombobox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Version 2.0
Option Explicit

Private Const SEP = ""                  'standard armstrong separator
Private Const PROP_TWIP_PIX = 14.95       'Conversion
Private Const CB_SETDROPPEDWIDTH    As Long = &H160
Private Const CB_SHOWDROPDOWN       As Long = &H14F
Private Const CB_GETDROPPEDSTATE    As Long = &H157
Private Const CB_GETLBTEXTLEN       As Long = &H149

'Private Const CB_GETCOMBOBOXINFO    As Long =
Private Const CB_FINDSTRING         As Long = &H14C
Private Const CB_ERR                As Long = (-1)
Private Const MM_TEXT = 1

Private Declare Function ExtTextOut Lib "gdi32" Alias "ExtTextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal y As Long, ByVal wOptions As Long, ByVal lpRect As Any, ByVal lpString As String, ByVal nCount As Long, lpDx As Long) As Long
Private Declare Function GetTextExtentPoint32 Lib "gdi32" Alias "GetTextExtentPoint32A" (ByVal hdc As Long, ByVal lpsz As String, ByVal cbString As Long, lpSize As POINTAPI) As Long
Private Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Private Declare Function SetMapMode Lib "gdi32" (ByVal hdc As Long, ByVal nMapMode As Long) As Long
Private Declare Function GetComboBoxInfo Lib "user32" (ByVal hwndCombo As Long, pcbi As Any) As Long


Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, _
  ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Private Type POINTAPI
    X As Long
    y As Long
End Type

Private Type RECT
  left As Long
  top As Long
  right As Long
  bottom As Long
End Type

Private Type COMBOBOXINFO
  cbSize As Long
  rcItem As RECT
  rcButton As RECT
  stateButton As Long
  hwndCombo As Long
  hwndItem As Long
  hwndList As Long
End Type

Dim mo_Db As ARMSYSCOMLib.ArmDb
Dim mo_Trace As Object

'if this was created by component or passed by ArmDB property from framework
Dim mb_InternalConnection As Boolean

'colection of combo items
Dim mo_ComboItems As Collection
Dim mo_SaveSelectedItem As Object
'change of SelectedItem was done internaly or not
Dim mb_InternalChange As Boolean
'this variable disable tracing of procedures when internal loop is running
Dim mb_InternalLoop As Boolean
'incremental searching which work normaly only on first character
Dim md_LastType As Double
Dim ms_IncText As String
'request string for loading data into comboboxes
Dim ms_Request As String
'active cursor
Dim ml_ActiveCursor As Long
'combobox is loaded or not
Dim mb_FullLoaded As Boolean
'number of columns which will be displayed in item description
Dim mi_DisplayColumnsCount As Integer
'column field names
Dim ma_ColumnNames() As String
'number of items loaded in one block from SQL server
Dim ml_BlockRowCount As Long
'separator, which will separate columns in item description
Dim ms_DisplayColumnSeparator As String
'will add blank item as first item of combo list
Dim mb_FirstBlankItem As Boolean
'this string will be added to search string
Dim ms_SearchPrefix As String
'connect parameters
Dim ms_Server As String
Dim ms_Db As String
Dim ms_User As String
Dim ms_Pwd As String
Dim ms_App As String

Public Event ComboItemSelected()
Public Event ComboDropDown()
Public Event ComboBeforeDropDown()
Public Event ComboValidate(Cancel As Boolean)
Public Event ComboScroll()


'main ArmSysCom object, if you pass this property, object should be connected to db
'when calling Execute or Load
Public Property Set ArmDb(ByVal lo_Db As ARMSYSCOMLib.ArmDb)
  
  'do not accept external instance of ArmDb when already internal instance exists
  If Not mb_InternalConnection Then
    Set mo_Db = lo_Db
  End If
End Property

Public Property Get ArmDb() As ARMSYSCOMLib.ArmDb

  Set ArmDb = mo_Db
End Property

Public Property Set ArmTrace(ByVal lo_Trace As Object)

  Set mo_Trace = lo_Trace
End Property

Public Property Get ArmTrace() As Object

  Set ArmTrace = mo_Trace
End Property

Public Sub SetFocus()

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SetFocus")
#End If

    Combo.SetFocus
    
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SetFocus")
#End If
End Sub

'connect string separated by armstrong separator
Property Let ConnectString(as_Value As String)
Dim la_Params() As String

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ConnectString_Let", "as_Value=" & as_Value)
#End If

  If (as_Value <> "") Then
    la_Params = Split(as_Value, SEP, 5)
    ms_Server = la_Params(0)
    ms_Db = la_Params(1)
    ms_User = la_Params(2)
    ms_Pwd = la_Params(3)
    If UBound(la_Params) >= 4 Then
      ms_App = la_Params(4)
    Else
      ms_App = "ArmCombobox"
    End If
  Else
    ms_Server = ""
    ms_Db = ""
    ms_User = ""
    ms_Pwd = ""
  End If
  
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ConnectString_Let")
#End If
  Exit Property
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:ConnectString_Let", "as_Value=" & as_Value)
#End If
End Property

Public Property Get Connected() As Boolean

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Connected_Get")
#End If
  
  Connected = False
  If Not (mo_Db Is Nothing) Then
    Connected = mo_Db.IsConnected
  End If
  
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Connected_Get")
#End If
End Property

Public Sub Load_A_COM()

On Error GoTo ErrorHandler

  ReDim ma_ColumnNames(1)

  mb_InternalChange = False
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Load_A_Com")
#End If
  
  Combo.Locked = True
  Set mo_ComboItems = New Collection
  Set mo_SaveSelectedItem = Nothing
  Call ResetCombo
  ms_SearchPrefix = ""

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Load_A_Com")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Load_A_Com")
#End If
End Sub

'standard armstrong initialization method
Public Sub Unload_A_COM()

On Error GoTo ErrorHandler:
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Unload_A_Com")
#End If
  
  Call ResetCombo
  If Connected And mb_InternalConnection Then
    mo_Db.Disconnect
  End If
  Set mo_Db = Nothing
  Set mo_ComboItems = Nothing

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Unload_A_Com")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Unload_A_COM")
#End If
End Sub

Public Property Let Columns(al_Value As Long)
  If al_Value > 0 Then
    ReDim ma_ColumnNames(al_Value - 1)
  End If
End Property

Public Property Get Columns() As Long
  'Columns = UBound(ma_ColumnNames) + 1
End Property


Public Property Let Locked(ab_Value As Boolean)
  Combo.Locked = ab_Value
End Property

Public Property Get Locked() As Boolean
  Locked = Combo.Locked
End Property

Public Property Let Text(as_Value As String)
  If Not Combo.Locked Then Combo.Text = as_Value
End Property

Public Property Get Text() As String
  Text = Combo.Text
End Property

Public Property Let DroppedWith(al_Value As Long)
Dim ll_Width As Long
  ll_Width = ScaleX(al_Value, vbTwips, vbPixels)
  Call SendMessage(Combo.hwnd, CB_SETDROPPEDWIDTH, ll_Width, 0)
End Property

Public Function AutoDroppedWidth() As Boolean
Dim ll_DC As Long, ll_PrevMapMode As Long
Dim TextSize As POINTAPI
Dim lu_ComboInfo As COMBOBOXINFO
Dim ll_MaxWidth As Long, ll_Index As Long, ll_TextWidth As Long
Dim ls_Text As String
Dim ll_Result As Long

    'Call SendMessage(Combo.hwnd, CB_GETCOMBOBOXINFO, 0, lu_ComboInfo)
   ' lu_ComboInfo.cbSize = 64
   ' Call GetComboBoxInfo(Combo.hwnd, lu_ComboInfo)
    'Get the window'zs device context
    ll_DC = GetWindowDC(cmd_Combo.hwnd)
    ll_MaxWidth = 0
    ' Set the mapping mode to pixels
    'll_PrevMapMode = SetMapMode(ll_DC, MM_TEXT)

 'For ll_Index = 1 To Combo.ComboItems.Count
 '   ll_TextWidth = SendMessage(Combo.hwnd, CB_GETLBTEXTLEN, _
 '                         ll_Index - 1, ByVal 0)

 '   If (ll_TextWidth > ll_MaxWidth) Then
 '       ls_Text = Combo.ComboItems(ll_Index)
 '       ll_MaxWidth = ll_TextWidth
 '   End If
 'Next ll_Index

    For ll_Index = 1 To Combo.ComboItems.Count
    
      ll_Result = GetTextExtentPoint32(ll_DC, Combo.ComboItems(ll_Index).Text, Len(Combo.ComboItems(ll_Index).Text), TextSize)
      If TextSize.X > ll_MaxWidth Then
        ll_MaxWidth = TextSize.X
      End If
    Next
    ' Set the mapping mode back to what it was
    'll_PrevMapMode = SetMapMode(ll_DC, ll_PrevMapMode)
    ll_Result = ReleaseDC(cmd_Combo.hwnd, ll_DC)
    ll_MaxWidth = ScaleX(ll_MaxWidth, vbPoints, vbPixels)
    Call SendMessage(Combo.hwnd, CB_SETDROPPEDWIDTH, ll_MaxWidth, 0)
End Function
'add item to combo list and to internal collection, select it if needed
Public Function AddItem(ByVal av_Data As Variant, Optional ab_Select As Boolean = False) As ArmComboItem
Dim lo_ComboItem As New ArmComboItem
Dim li_Index As Integer

On Error GoTo ErrorHandler:
#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(True, "ArmCombo:AddItem", "ab_Select=" & ab_Select)
#End If
  
  Set lo_ComboItem.Combo = Me
  
  If Not IsArray(av_Data) Then
    av_Data = Array(av_Data)
  End If
  'reserve space for data
  Call lo_ComboItem.SetDataSize(UBound(av_Data) + 1)
  
  For li_Index = 0 To UBound(av_Data)
    Call lo_ComboItem.SetData(li_Index, av_Data(li_Index))
  Next
  'add to combo list and internal collection
  Call mo_ComboItems.Add(lo_ComboItem)
  Call Combo.ComboItems.Add(, , lo_ComboItem.DisplayText)
  
  'select this item if needed
  If ab_Select Then Set SelectedItem = lo_ComboItem
  Set AddItem = lo_ComboItem
  
#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(False, "ArmCombo:AddItem")
#End If
  Exit Function
ErrorHandler:
  Set AddItem = Nothing
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:AddItem", "ab_Select=" & ab_Select)
#End If
End Function

'delete and item with index al_Index from combobox
Public Function DeleteItemIndex(al_Index As Long) As Boolean

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:DeleteItemIndex")
#End If
  
  If (al_Index > 0) And (al_Index <= Count) Then
    'if we want to delete item which is actually selected we must clear text first
    If GetIndex() = al_Index - 1 Then Combo.Text = ""
    Call mo_ComboItems.Remove(al_Index)
    Call Combo.ComboItems.Remove(al_Index)
    DeleteItemIndex = True
  Else
    DeleteItemIndex = False
  End If
  
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:DeleteItemIndex")
#End If
End Function

'delete and item with key av_Key from combobox
Public Function DeleteItemKey(av_Key As Variant) As Boolean
Dim ll_Index As Long

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:DeleteItemKey")
#End If
  
  DeleteItemKey = False
  For ll_Index = 1 To Count
    If CStr(av_Key) = CStr(mo_ComboItems(ll_Index).Key) Then
      DeleteItemKey = DeleteItemIndex(ll_Index)
      Exit For
    End If
  Next

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:DeleteItemKey")
#End If
End Function

'get or set selected item in combobox
Public Property Get SelectedItem() As ArmComboItem

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SelectedItem_Get")
#End If
  
  If GetIndex < 0 Then
    Set SelectedItem = Nothing
  Else
    Set SelectedItem = mo_ComboItems(GetIndex + 1)
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SelectedItem_Get", "SelectedItem=" & (SelectedItem Is Nothing))
#End If
End Property

Public Property Set SelectedItem(ByVal vNewValue As ArmComboItem)
Dim ll_Index As Long

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SelectedItem_Set")
#End If
  
  DoEvents
  Call SetInternalChange(True)
  Call SetIndex(-1)
  
  For ll_Index = 1 To mo_ComboItems.Count
    If mo_ComboItems(ll_Index) Is vNewValue Then
      Call SetIndex(ll_Index - 1)
      Exit For
    End If
  Next
  DoEvents
  Call SetInternalChange(False)

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SelectedItem_Set")
#End If
  Exit Property
ErrorHandler:
  Call SetInternalChange(False)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:SelectedItem_Set", "ll_Index=" & ll_Index)
#End If
End Property

'return number of items loaded into combobox
Public Property Get Count() As Long
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Count_Get")
#End If
  
  Count = Combo.ComboItems.Count

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Count_Get", "Result=" & Combo.ComboItems.Count)
#End If
End Property

'get access to all items in combobox
Public Property Get ComboItems(ll_Index As Long) As ArmComboItem
On Error GoTo ErrorHandler

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ComboItems_Get", "ll_Index=" & ll_Index)
#End If
  
  Set ComboItems = Nothing
  If ll_Index > 0 And ll_Index <= mo_ComboItems.Count Then
    Set ComboItems = mo_ComboItems(ll_Index)
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ComboItems_Get")
#End If
  Exit Property
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:ComboItems_Get")
#End If
End Property

'set new request into combobox.Clear it if not already done
Property Let Request(as_Text As String)

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Request_Let", "as_Text=" & as_Text)
#End If
  
  Call ResetActiveRequest
  ms_Request = as_Text

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Request_Let")
#End If
  Exit Property
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Request_Let")
#End If
End Property

Property Get Request() As String
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Request_Get")
#End If
  
  Request = ms_Request

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Request_Get", "Result=" & ms_Request)
#End If
End Property
'set number of columns which will be displayed in description separated by DisplayColumnSeparator
'default is 1
Property Let DisplayColumnsCount(ai_Count As Integer)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:DisplayColumnsCount_Let", "ai_Count=" & ai_Count)
#End If
  
  If ai_Count > 0 Then
    mi_DisplayColumnsCount = ai_Count
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:DisplayColumnsCount_Let")
#End If
End Property

Property Get DisplayColumnsCount() As Integer
#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(True, "ArmCombo:DisplayColumnsCount_Get")
#End If
  
  DisplayColumnsCount = mi_DisplayColumnsCount

#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(False, "ArmCombo:DisplayColumnsCount_Get", "Result=" & mi_DisplayColumnsCount)
#End If
End Property
'separator for item description, if it should display more than one column default is space
Property Let DisplayColumnSeparator(as_Str As String)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:DisplayColumnSeparator_Let", , "as_Str=" & as_Str)
#End If
  
  ms_DisplayColumnSeparator = as_Str

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:DisplayColumnSeparator_Let")
#End If
End Property

Property Get DisplayColumnSeparator() As String
#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(True, "ArmCombo:DisplayColumnSeparator_Get")
#End If
  
  DisplayColumnSeparator = ms_DisplayColumnSeparator

#If CompDebugAC Then
  If Not mb_InternalLoop Then Call mo_Trace.WriteTraceProc(False, "ArmCombo:DisplayColumnSeparator_Get", "Result=" & ms_DisplayColumnSeparator)
#End If
End Property

'separator for item description, if it should display more than one column default is space
Property Let SearchPrefix(as_Str As String)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SearchPrefix_Let", , "as_Str=" & as_Str)
#End If
  
  ms_SearchPrefix = as_Str

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SearchPrefix_Let")
#End If
End Property

'whetever first item of combobox should be blank or not
Property Let FirstBlankItem(ab_Blank As Boolean)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:FirstBlankItem_Let", "ab_Blank=" & ab_Blank)
#End If
  
  mb_FirstBlankItem = ab_Blank

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:FirstBlankItem_Let")
#End If
End Property

Property Get FirstBlankItem() As Boolean
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:FirstBlankItem_Get")
#End If
  
  FirstBlankItem = mb_FirstBlankItem

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:FirstBlankItem_Get", "Result=" & mb_FirstBlankItem)
#End If
End Property

'enable/disable combobox
Public Property Let Enabled(ByVal ab_NewValue As Boolean)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Enabled_Let", "ab_NewValue=" & ab_NewValue)
#End If
  
  Combo.Enabled = ab_NewValue
  cmd_Combo.Enabled = ab_NewValue

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Enabled_Let")
#End If
End Property

Public Property Get Enabled() As Boolean
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Enabled_Get")
#End If
  
  Enabled = Combo.Enabled

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Enabled_Get", "Result=" & Combo.Enabled)
#End If
End Property

Public Property Get Font() As StdFont
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Font_Get")
#End If
  
  Set Font = Combo.Font

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Font_Get")
#End If
End Property

'clear combobox and internal collection, reset active request
Public Sub Clear()
  
On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Clear")
#End If

  Call SetInternalChange(True)

  Call Combo.ComboItems.Clear
  Call ClearCollection(mo_ComboItems)
  Set mo_SaveSelectedItem = Nothing
  mb_FullLoaded = False
  Call SetIndex(-1)
  DoEvents
  Call SetInternalChange(False)

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Clear")
#End If
  Exit Sub
ErrorHandler:
  Call SetInternalChange(False)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Clear")
#End If
End Sub
'search and select item in list according data and value
Public Function SearchItem(av_Data As Variant, Optional av_Column As Variant = 0, Optional al_DefaultIndex As Long = -1, Optional ab_Select As Boolean = True) As Boolean
Dim ll_Index As Long
Dim ls_Data As String
Dim lb_Result As Boolean
Dim li_ColumnIndex As Integer

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SearchItem")
#End If
  
  lb_Result = False
  li_ColumnIndex = GetColumnIndex(av_Column)
  
  If IsArray(ma_ColumnNames) Then
    If (li_ColumnIndex >= 0) And (li_ColumnIndex <= UBound(ma_ColumnNames)) Then
      ls_Data = CStr(av_Data)
      
      For ll_Index = 1 To mo_ComboItems.Count
        If StrComp(CStr(mo_ComboItems(ll_Index).GetData(li_ColumnIndex)), ls_Data, vbTextCompare) = 0 Then
          If ab_Select Then Call SetIndex(ll_Index - 1)
          lb_Result = True
          Exit For
        End If
      Next
      
      If Not lb_Result Then
        If ab_Select Then
          If al_DefaultIndex >= 0 And al_DefaultIndex < mo_ComboItems.Count Then
            Call SetIndex(al_DefaultIndex)
          Else
            Call SetIndex(-1)
          End If
        End If
      End If
    End If
  End If
  SearchItem = lb_Result

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SearchItem", "Result=" & lb_Result)
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:SearchItem", "av_Data=" & av_Data, _
  "li_ColumnIndex=" & li_ColumnIndex, "al_DefaultIndex=" & al_DefaultIndex)
#End If
End Function

Public Function GetItemData(av_ID As Variant, av_Column As Variant) As Variant
Dim ll_Index As Long
Dim lo_ComboItem As ArmComboItem
Dim li_ColumnIndex As Integer

  
  If Count = 0 Then Load
  li_ColumnIndex = GetColumnIndex(av_Column)
  If (li_ColumnIndex >= 0) And (li_ColumnIndex <= UBound(ma_ColumnNames)) Then
    For Each lo_ComboItem In mo_ComboItems
      If StrComp(CStr(lo_ComboItem.Key), CStr(av_ID)) = 0 Then
        GetItemData = lo_ComboItem.GetData(li_ColumnIndex)
        Exit For
      End If
    Next
  End If
End Function

'generic method to clear collection
Private Sub ClearCollection(lo_Collection As Collection)

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ClearCollection")
#End If
  
  If Not (lo_Collection Is Nothing) Then
    While lo_Collection.Count > 0
      Call lo_Collection.Remove(1)
    Wend
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ClearCollection")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:ClearCollection")
#End If
End Sub

'fetch data into combobox list
Private Function FetchAll() As Boolean
Dim lb_Result As Boolean
Dim lv_Key As Variant

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:FetchAll")
#End If
  
  lb_Result = False
  Call SetInternalChange(True)
  Call SetMousePointer(False)

  If Not Connected Then
    If Not OpenConnection(ms_Server, ms_Db, ms_User, ms_Pwd, ms_App) Then
      'Call MsgBox("Open connection failed.")
#If CompDebugAC Then
      Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmCombo:FetchAll", _
        "ms_Server=" & ms_Server, _
        "ms_Db=" & ms_Db, "ms_User=" & ms_User, "ms_Pwd=" & ms_Pwd)
#End If
    End If
  End If
  
  If Connected And (Not mb_FullLoaded) And (mi_DisplayColumnsCount > 0) And (ms_Request <> "") Then
    If SelectedItem Is Nothing Then
      lv_Key = Empty
    Else
      lv_Key = SelectedItem.Key
    End If
    Call ResetActiveRequest
    ml_ActiveCursor = mo_Db.OpenSQL(ms_Request)
    
    'there is an error exeucting SQL statement
    If ml_ActiveCursor = 0 Then
      Call Clear
      mb_FullLoaded = True
      lb_Result = False
      
#If CompDebugAC Then
      Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmCombo:FetchAll", "mb_FullLoaded=" & _
        mb_FullLoaded, "ms_Request=" & ms_Request)
#End If

    Else
      lb_Result = FillCombo
      mb_FullLoaded = True
      Call mo_Db.Close(ml_ActiveCursor)
      ml_ActiveCursor = 0
      If Not IsEmpty(lv_Key) Then
        Call SearchItem(lv_Key)
      End If
    End If
  End If
  Call SetMousePointer(True)
  FetchAll = lb_Result
  DoEvents
  Call SetInternalChange(False)

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:FetchAll", "Result=" & lb_Result)
#End If
  Exit Function
ErrorHandler:
  Call SetMousePointer(True)
  Call SetInternalChange(False)
  FetchAll = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:FetchAll", "mb_FullLoaded=" & _
  mb_FullLoaded, "ms_Request=" & ms_Request, "ml_ActiveCursor=" & ml_ActiveCursor)
#End If
End Function

'fill combo list (add items) from active cursor
Private Function FillCombo() As Boolean
Dim ll_RowIndex As Long, ll_ColIndex As Long
Dim lo_ArmCmbItem As ArmComboItem

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:FillCombo")
#End If
  
  mb_InternalLoop = True
  Call Clear
  
  If mo_Db.FieldCount(ml_ActiveCursor) > 0 Then
  
    ReDim ma_ColumnNames(mo_Db.FieldCount(ml_ActiveCursor) - 1)
    For ll_ColIndex = 0 To UBound(ma_ColumnNames)
      ma_ColumnNames(ll_ColIndex) = mo_Db.GetFieldName(ml_ActiveCursor, ll_ColIndex)
    Next
  
    If mb_FirstBlankItem Then Call AddItem(Empty)
    For ll_RowIndex = 0 To mo_Db.RowCount(ml_ActiveCursor) - 1
      Set lo_ArmCmbItem = AddItem(mo_Db.GetRowAt(ml_ActiveCursor, ll_RowIndex))
    Next
  End If
  mb_InternalLoop = False
  FillCombo = True

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:FillCombo", "ll_RowIndex=" & ll_RowIndex)
#End If
  Exit Function
ErrorHandler:
  FillCombo = False
  mb_InternalLoop = False
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:FillCombo", "ll_RowIndex=" & _
  ll_RowIndex, "ml_ActiveCursor=" & ml_ActiveCursor)
#End If
End Function

'load combobox immediately don't wait for user to dropdown it
Public Function Load() As Boolean
Dim lb_Result As Boolean

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Load")
#End If
  
  Call ResetActiveRequest
  lb_Result = FetchAll()
  Load = lb_Result

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Load", "Result=" & lb_Result)
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Load")
#End If
End Function

'open conection and create own instance of ArmDB if it was not passed through property
Private Function OpenConnection(as_Server As String, as_Db As String, as_User As String, _
    as_Pwd As String, as_App As String) As Boolean
Dim lb_Result As Boolean

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:OpenConnection", "as_Server=" & as_Server, _
  "as_Db=" & as_Db, "as_User=" & as_User)
#End If
  
  If Connected Then
    lb_Result = False
  Else
    mb_InternalConnection = True
    If mo_Db Is Nothing Then
      Set mo_Db = New ARMSYSCOMLib.ArmDb
    End If

    If (as_Server <> "") And (as_Db <> "") And (as_User <> "") Then
        lb_Result = mo_Db.Connect(as_Server, as_Db, as_User, as_Pwd, as_App)
    End If
  End If
  OpenConnection = lb_Result
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:OpenConnection", "Result=" & lb_Result)
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:OpenConnection")
#End If
End Function

'close connection if connection was created with OpenConnection method and
Private Sub CloseConnection()

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:CloseConnection")
#End If
  
  If Connected Then
    Call ResetActiveRequest
    Call mo_Db.Disconnect
    mb_InternalConnection = False
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:CloseConnection")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:CloseConnection")
#End If
End Sub

'reset combobox to initial state
Private Sub ResetCombo()

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ResetCombo")
#End If
  
  ms_Request = ""
  DisplayColumnsCount = 1
  ml_BlockRowCount = 100
  ms_DisplayColumnSeparator = " "
  Call Clear
  Call ResetActiveRequest
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ResetCombo")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:ResetCombo")
#End If
End Sub

'close active request and initialize variables
Private Sub ResetActiveRequest()
  
On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ResetActiveRequest")
#End If
  
  If Connected Then
    If ml_ActiveCursor <> 0 Then Call mo_Db.Close(ml_ActiveCursor)
  End If
  ml_ActiveCursor = 0
  mb_FullLoaded = False
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ResetActiveRequest")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:ResetActiveRequest")
#End If
End Sub

'event - combo changed transform to event ComboItemSelected
Private Sub Combo_Change()
  If Not mb_InternalChange Then
#If CompDebugAC Then
    Call mo_Trace.WriteTraceProc(True, "ArmCombo:Combo_Change")
#End If
    
    Set mo_SaveSelectedItem = Combo.SelectedItem
    Combo.Refresh
    DoEvents
    RaiseEvent ComboItemSelected

#If CompDebugAC Then
    Call mo_Trace.WriteTraceProc(False, "ArmCombo:Combo_Change")
#End If
  End If
End Sub

'event combo clicked transform to event ComboItemSelected
Private Sub Combo_Click()
  
  If Not mb_InternalChange Then
#If CompDebugAC Then
    Call mo_Trace.WriteTraceProc(True, "ArmCombo:ComboItemSelected")
#End If
    
    Set mo_SaveSelectedItem = Combo.SelectedItem
    Combo.Refresh
    DoEvents
    RaiseEvent ComboItemSelected

#If CompDebugAC Then
    Call mo_Trace.WriteTraceProc(False, "ArmCombo:ComboItemSelected")
#End If
  End If
End Sub

Private Sub cmd_Combo_Click()
  Call MakeSureListDropDown
  DoEvents
End Sub

Private Sub Combo_DropDown()

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Combo_DropDown")
#End If
  
  Call SetInternalChange(True)
  Combo.SetFocus
  RaiseEvent ComboBeforeDropDown
  If Not mb_FullLoaded Then
    Call FetchAll
  End If
  RaiseEvent ComboDropDown
  DoEvents
  Call SetInternalChange(False)

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Combo_DropDown")
#End If
  Exit Sub
ErrorHandler:
  Call SetInternalChange(False)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Combo_DropDown")
#End If
End Sub

Private Sub MakeSureListDropDown()
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:MakeSureListDropDown")
#End If

  If (SendMessage(Combo.hwnd, CB_GETDROPPEDSTATE, 0&, ByVal 0&) = 0) Then
       Call SendMessage(Combo.hwnd, CB_SHOWDROPDOWN, True, ByVal 0&)
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:MakeSureListDropDown")
#End If
End Sub

'implement incremental search - because standard combobox allow to search only for first
'character typed
Private Sub Combo_KeyPress(KeyAscii As Integer)
Dim lo_ComboItem As ComboItem
Dim lb_DoSearch As Boolean

On Error GoTo ErrorHandler
  RaiseEvent ComboBeforeDropDown
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Combo_KeyPress", "KeyAscii=" & KeyAscii)
#End If
  
  If Combo.Locked Then
    If Not mb_FullLoaded Then
      Call FetchAll
    End If
    Call SetInternalChange(True)
    'if user not pressed key more than one second, erase search text and begin new search
    If (Timer - md_LastType > 1) Then
      ms_IncText = ms_SearchPrefix
    End If
    
    lb_DoSearch = False
    ' Handle special case KeyAscii values
    Select Case KeyAscii
    ' --Enter key, clear search string and do NO search
    Case vbKeyReturn
      ms_IncText = ms_SearchPrefix
    ' --BackSpace key, clear last entry and do search
    Case vbKeyBack
      If (Len(ms_IncText) > 0) Then
        ms_IncText = left$(ms_IncText, Len(ms_IncText) - 1)
        lb_DoSearch = True
      End If
    ' --Added KeyAscii value, add to entry and do search
    Case Is >= vbKeySpace
        ms_IncText = ms_IncText & Chr$(KeyAscii)
        lb_DoSearch = True
    End Select
    
    If lb_DoSearch Then
      ' Find the string
      'look for all items, if found add character to search string and select item in combo
      For Each lo_ComboItem In Combo.ComboItems
        If StrComp(ms_IncText, left(lo_ComboItem.Text, Len(ms_IncText)), vbTextCompare) = 0 Then
          Call SetIndex(lo_ComboItem.Index - 1)
          RaiseEvent ComboItemSelected
          Exit For
        End If
      Next
      Call MakeSureListDropDown
    End If
    'update last type timer
    md_LastType = Timer
    'do not send key to combo
    KeyAscii = 0
    DoEvents
    Call SetInternalChange(False)
  End If
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Combo_KeyPress", "lb_DoSearch=" & lb_DoSearch)
#End If
  Exit Sub
ErrorHandler:
  Call SetInternalChange(False)
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:Combo_KeyPress", "ms_IncText=" & ms_IncText, "KeyAscii=" & KeyAscii)
#End If
End Sub

'when combobox scrolled
Private Sub Combo_Scroll()
  RaiseEvent ComboScroll
End Sub

'when combobox validated send event
Private Sub Combo_Validate(Cancel As Boolean)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:Combo_Validate", "Cancel=" & Cancel)
#End If
  
  RaiseEvent ComboValidate(Cancel)

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:Combo_Validate")
#End If
End Sub

Private Sub UserControl_ExitFocus()

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:ExitFocus")
#End If

  Call SetInternalChange(True)
  If Not (Combo.SelectedItem Is mo_SaveSelectedItem) Then
    Set Combo.SelectedItem = mo_SaveSelectedItem
  End If
  DoEvents
  Call SetInternalChange(False)
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:ExitFocus")
#End If
  Exit Sub
ErrorHandler:
  Call SetInternalChange(False)
End Sub

'resize combo control with user control
Private Sub UserControl_Resize()

  Combo.left = 0
  Combo.top = 0
  UserControl.Height = Combo.Height
  Combo.Width = UserControl.Width
  cmd_Combo.top = PROP_TWIP_PIX * 2
  cmd_Combo.left = UserControl.Width - cmd_Combo.Width - PROP_TWIP_PIX * 2
End Sub

'get current selected item index
Public Function GetIndex() As Long
Dim lo_Item As ComboItem

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:GetIndex", "Combo.SelectedItem=" & (Combo.SelectedItem Is Nothing))
#End If
  
  Set lo_Item = Combo.SelectedItem
  If lo_Item Is Nothing Then
    GetIndex = -1
  Else
    GetIndex = lo_Item.Index - 1
  End If
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:GetIndex")
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:GetIndex")
#End If
End Function

'set item with index al_index as selected
Private Sub SetIndex(al_Index As Long)

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SetIndex", "al_Index=" & al_Index)
#End If
  
  DoEvents
  If al_Index < 0 Then
    Set Combo.SelectedItem = Nothing
    If Combo.Locked Then Combo.Text = ""
  Else
    Combo.ComboItems(al_Index + 1).Selected = True
  End If
  Call Combo.Refresh
  Set mo_SaveSelectedItem = Combo.SelectedItem
  DoEvents

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SetIndex")
#End If
  Exit Sub
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmCombo:SetIndex", "al_Index=" & al_Index)
#End If
End Sub

'get column index according its index or column name
Private Function GetColumnIndex(av_Column As Variant) As Integer
Dim li_Index As Integer
Dim ls_Name As String

On Error GoTo ErrorHandler
#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:GetColumnIndex")
#End If
  
  GetColumnIndex = -1
  If IsNumeric(av_Column) Then
    GetColumnIndex = CInt(av_Column)
  Else
    ls_Name = CStr(av_Column)
    For li_Index = 0 To UBound(ma_ColumnNames)
      If StrComp(ls_Name, ma_ColumnNames(li_Index), vbTextCompare) = 0 Then
        GetColumnIndex = li_Index
        Exit For
      End If
    Next
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:GetColumnIndex", "Result=" & GetColumnIndex)
#End If
  Exit Function
ErrorHandler:
#If CompDebug Then
  Call mo_Trace.WriteTraceError("ArmGrid:GetColumn")
#End If
End Function

'**************************************************************************************************************
'turn of on mouse pointer sand hour glass, use counter
Private Static Sub SetMousePointer(lb_Enable As Boolean)
Dim li_Count As Integer
Dim li_OldPointer As Integer

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SetMousePointer")
#End If
  
  If lb_Enable Then
    If li_Count > 0 Then li_Count = li_Count - 1
    If li_Count <= 0 Then
      'set back old state
      Screen.MousePointer = li_OldPointer
    End If
  Else
    li_Count = li_Count + 1
    'remember state of pointer before first change
    If li_Count = 1 Then li_OldPointer = Screen.MousePointer
    Screen.MousePointer = vbHourglass
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SetMousePointer")
#End If
End Sub

'**************************************************************************************************************
'turn of on mouse pointer sand hour glass, use counter
Private Static Sub SetInternalChange(lb_Enable As Boolean)
Dim li_Count As Integer

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(True, "ArmCombo:SetInternalChange")
#End If
  
  If lb_Enable Then
    li_Count = li_Count + 1
    mb_InternalChange = True
  Else
    If li_Count > 0 Then li_Count = li_Count - 1
    If li_Count <= 0 Then
      mb_InternalChange = False
    End If
  End If

#If CompDebugAC Then
  Call mo_Trace.WriteTraceProc(False, "ArmCombo:SetInternalChange", "mb_InternalChange=" & mb_InternalChange)
#End If
End Sub

