VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.UserControl ToolbarControl 
   Alignable       =   -1  'True
   Appearance      =   0  'Flat
   BackColor       =   &H80000010&
   BackStyle       =   0  'Transparent
   ClientHeight    =   675
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   12120
   FillColor       =   &H00FFFFFF&
   ForeColor       =   &H00FFFFFF&
   MaskColor       =   &H00FFFFFF&
   ScaleHeight     =   675
   ScaleWidth      =   12120
   ToolboxBitmap   =   "ArmToolbar.ctx":0000
   Begin MSComctlLib.Toolbar Toolbar 
      Align           =   1  'Align Top
      Height          =   660
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   12120
      _ExtentX        =   21378
      _ExtentY        =   1164
      ButtonWidth     =   1402
      ButtonHeight    =   1058
      AllowCustomize  =   0   'False
      _Version        =   393216
      OLEDropMode     =   1
   End
   Begin MSComctlLib.ImageList mo_ilsIconLanguage 
      Left            =   6000
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList mo_ilsIcon 
      Left            =   600
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   393216
   End
   Begin MSComctlLib.ImageCombo mo_imgcboLanguage 
      Height          =   330
      Left            =   2160
      TabIndex        =   1
      Top             =   120
      Visible         =   0   'False
      Width           =   615
      _ExtentX        =   1085
      _ExtentY        =   582
      _Version        =   393216
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      Text            =   "ImageCombo"
   End
End
Attribute VB_Name = "ToolbarControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Private ms_ToolbarString        As String  ' string for one toolbar AZZGjjHccIkkJIILOOMBB
Private ms_ToolbarInfoString    As String  ' string for one toolbar key e.g. 0010AAAABBBCCC1CCCFFGG0020hhhjjj1EEEFFFRRR...
Private ms_Face                 As String  ' displayed face
Private ms_ToolbarKey           As String  ' displayed toolbarkey
Private ms_ApplicationName      As String  ' application name in database
Private mi_UserCode             As Integer ' user code in database
Private mo_colToolbarInfoString As New Collection  ' collection (create from ms_ToolbarInfoString) of toolbarkeys items, which have faces items e.g. mo_colToolbarInfoString.item("001").item("0") return ms_ToolbarString for toolbarkey="001" face = "0"
Private mo_colToolbar           As New clsIconInfoCollection  ' collection (create from ms_ToolbarString without languages prefix) of displayed icons in toolbar
Private mo_colLanguage          As New clsIconInfoCollection  ' collection of language icons, if languages are defined in ToolbarString, only these languages, else all languages
Private mo_colIcon              As New clsIconInfoCollection  ' collection of all toolbar icons, load from resource/dll file
Private mb_MaintenanceMode      As Boolean                    ' Toolbar for run-time (false) or toolbar for maintenance application (true)

' languages variables
Private ms_LanguageDefault      As String  ' public property Language, default language for user and application(selected by loggin in aplication)
Private ms_LanguageMaster       As String  ' master language for application
Private ms_LanguageSelected     As String  ' selected language
'Private ms_LanguageAvailable    As String  ' list of available languages
Private ms_LanguageAuthTrans    As String  ' list of languages for authorized translation

' special icon
Private ms_IconLanguage         As String  ' icon for language combo
Private ms_IconSpecial          As String  ' icon which change role if user has rights
Private ms_IconInvisible        As String  ' if user has no translation rights these icons are invisible

' toolbar info size, align ...
Private mi_Width As Integer

'Constants
Private Const ms_Delimiter         As String = ""  ' delimiter for toolbar keys in ms_ToolbarInfoString
Private Const ms_DelimiterSub      As String = ""  ' delimiter in Toolbar string for one ToolbarKey
Private Const ms_DelimiterLang     As String = "/"  ' delimiter in Toolbar string authorized translation languages and special icons
Private Const ms_DefaultLanguage   As String = "E"  ' default language for toolbar
Private Const ms_DefaultFace       As String = "0"  ' default face
Private Const ms_DefaultToolbarKey As String = "001"  ' default toolbar key
Private Const ms_UpperCharStart    As String = "A"  ' first upper char
Private Const ms_UpperCharEnd      As String = "Z"  ' last upper char
Private Const ms_LowerCharStart    As String = "a"  ' first lower char
Private Const ms_LowerCharEnd      As String = "z"  ' last lower char
Private Const ml_InternalError     As Long = 10000  ' number for internal error
Private Const ms_IconLangPrefix    As String = "L"  ' name prexif in icons collection for languages icons(image combo flag) in toolbar (no in language combo !!!)
Private Const CB_SHOWDROPDOWN = &H14F
' Automatic Icons from table Security and connection parameters
Private mo_ArmDb As ArmDb
Private mb_Connected As Boolean ' status if ArmDB is connected or not
Private Const SEP = ""        ' standard armstrong separator

'connect parameters
Private ms_Server As String
Private ms_Db As String
Private ms_User As String
Private ms_Pwd As String
Private ms_App As String
'component created the connection itself internally
Private mb_InternalConnection As Boolean

Public Event Action(ByVal as_Role As String, as_Language As String)  ' user control event
Public Event RoleChanged(ByVal as_Role As String, as_Key As String)  ' user control event

Public Event MouseDown(Button As Integer, Shift As Integer, X As Single, y As Single)

Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, _
  ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Public Property Set ArmDb(ByVal lo_Db As ARMSYSCOMLib.ArmDb)
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:ArmDb_Set")
'#End If
  
  Set mo_ArmDb = lo_Db
  mb_Connected = Not (lo_Db Is Nothing)

'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:ArmDb_Set")
'#End If
End Property

'set and get reference to ArmDB component (should be used for DBF access, because only one instance can access
'DBF file.
Public Property Get ArmDb() As ARMSYSCOMLib.ArmDb
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:ArmDb_Get")
'#End If
  
  Set ArmDb = mo_ArmDb

'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:ArmDb_Get")
'#End If
End Property

Public Property Get IsConnected() As Boolean

On Error GoTo ErrorHandler
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:IsConnected_Get")
'#End If
  
  IsConnected = False
  If Not (mo_ArmDb Is Nothing) Then
    IsConnected = mo_ArmDb.IsConnected
  End If
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:IsConnected_Get")
'#End If
  Exit Property
ErrorHandler:
'#If CompDebug Then
'    Call mo_Trace.WriteTraceError("ArmToolbar:IsConnected_Get")
'#End If
  IsConnected = mb_Connected
End Property

' Connection parameters in case component shold create connection itself
Public Property Let ConnectString(as_Value As String)
Dim la_Params() As String

On Error GoTo ErrorHandler
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:ConnectString_Let")
'#End If
  
  If (as_Value <> "") Then
    la_Params = Split(as_Value, SEP, 5)
    ms_Server = la_Params(0)
    ms_Db = la_Params(1)
    ms_User = la_Params(2)
    ms_Pwd = la_Params(3)
    If UBound(la_Params) >= 4 Then
      ms_App = la_Params(4)
    Else
      ms_App = "ArmToolbar"
    End If
  Else
    ms_Server = ""
    ms_Db = ""
    ms_User = ""
    ms_Pwd = ""
  End If

'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:ConnectString_Let")
'#End If
  Exit Property
ErrorHandler:
'  #If CompDebugTV Then
'    Call mo_Trace.WriteTraceError("ArmToolbar:ConnectString_Let", "as_Value=" & as_Value)
'  #End If
End Property

' Open conection and create own instance of ArmDB if it was not passed through property
Private Function OpenConnection(as_Server As String, as_Db As String, as_User As String, _
    as_Pwd As String, as_App As String) As Boolean
Dim lb_Result As Boolean

On Error GoTo ErrorHandler
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:OpenConnection")
'#End If
 
  lb_Result = False
  If IsConnected Then
    lb_Result = False
  Else
    mb_InternalConnection = True
    If mo_ArmDb Is Nothing Then
      Set mo_ArmDb = New ARMSYSCOMLib.ArmDb
    End If

    If (as_Server <> "") And (as_Db <> "") And (as_User <> "") Then
        lb_Result = mo_ArmDb.Connect(as_Server, as_Db, as_User, as_Pwd, as_App)
'        If Not lb_Result Then
'          #If CompDebug Then
'            Call mo_Trace.WriteTraceSQLError(mo_Db, "ArmToolbar:OpenConnection", "as_Server=" & as_Server, _
'            "as_Db=" & as_Db, "as_User=" & as_User)
'          #End If
'        End If
    End If
    mb_Connected = lb_Result
  End If
  OpenConnection = lb_Result
  
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:OpenConnection")
'#End If
  Exit Function
ErrorHandler:
  OpenConnection = False
'  #If CompDebugTV Then
'    Call mo_Trace.WriteTraceError("ArmToolbar:OpenConnection", "as_Server=" & as_Server, _
'    "as_Db=" & as_Db, "as_User=" & as_User)
'  #End If
End Function

'close connection if connection was created with OpenConnection method and
Private Sub CloseConnection()

 On Error GoTo ErrorHandler
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(True, "ArmToolbar:CloseConnection")
'#End If
  
  If IsConnected Then
    Call mo_ArmDb.Disconnect
    mb_InternalConnection = False
  End If
  
'#If CompDebugTV Then
'  Call mo_Trace.WriteTraceProc(False, "ArmToolbar:CloseConnection")
'#End If
  Exit Sub
ErrorHandler:
'  #If CompDebugTV Then
'    Call mo_Trace.WriteTraceError("ArmToolbar:CloseConnection")
'  #End If
End Sub
 
' Name :        property Get MaintenanceMode
' Parameters:
' Description:  Return property mb_MaintenanceMode
' Return value: mb_MaintenanceMode

Public Property Get MaintenanceMode() As Boolean
   MaintenanceMode = mb_MaintenanceMode
End Property

' Name :        property Let MaintenanceMode
' Parameters:   ab_MaintenanceMode - false (run-time mode), true (maintenance mode)
' Description:  Setting of property mb_MaintenanceMode
' Return value:

Public Property Let MaintenanceMode(ab_MaintenanceMode As Boolean)
   mb_MaintenanceMode = ab_MaintenanceMode
End Property

' Name :        property Get Language
' Parameters:
' Description:  Return property language
' Return value: selected language for toolbar

Public Property Get Language() As String
   Language = ms_LanguageSelected
End Property

' Name :        property Let Language
' Parameters:   as_Language - selected language for toolbar
' Description:  Setting default and selected language for toolbar
' Return value:

Public Property Let Language(as_Language As String)
   ms_LanguageDefault = as_Language
   ms_LanguageSelected = as_Language
End Property

' Name :        property Get LanguageMaster
' Parameters:
' Description:  Return property LanguageMaster
' Return value: selected LanguageMaster for toolbar

Private Property Get LanguageMaster() As String
   LanguageMaster = ms_LanguageMaster
End Property

' Name :        property Let LanguageMaster
' Parameters:   as_LanguageMaster - set LanguageMaster
' Description:  Setting LanguageMaster for toolbar
' Return value:

Private Property Let LanguageMaster(as_LanguageMaster As String)
   ms_LanguageMaster = as_LanguageMaster
   If Language = "" Then
      Language = ms_LanguageMaster
   End If
End Property

' Name :        property Get LanguageAuthTrans
' Parameters:
' Description:  Return property LanguageAuthTrans
' Return value: selected LanguageAuthTrans for toolbar

Private Property Get LanguageAuthTrans() As String
   LanguageAuthTrans = ms_LanguageAuthTrans
End Property

' Name :        property Let LanguageAuthTrans
' Parameters:   as_LanguageAuthTrans - set LanguageAuthTrans
' Description:  Setting LanguageAuthTrans for toolbar
' Return value:

Private Property Let LanguageAuthTrans(as_LanguageAuthTrans As String)
   ms_LanguageAuthTrans = as_LanguageAuthTrans
End Property

' Name :        property Get IconLanguage
' Parameters:
' Description:  Return property IconLanguage
' Return value: selected IconLanguage for toolbar

Private Property Get IconLanguage() As String
   IconLanguage = ms_IconLanguage
End Property

' Name :        property Let IconLanguage
' Parameters:   as_IconLanguage - set IconLanguage
' Description:  Setting IconLanguage for toolbar
' Return value:

Private Property Let IconLanguage(as_IconLanguage As String)
   ms_IconLanguage = as_IconLanguage
End Property

' Name :        property Get IconSpecial
' Parameters:
' Description:  Return property IconSpecial
' Return value: selected IconSpecial for toolbar

Private Property Get IconSpecial() As String
   IconSpecial = ms_IconSpecial
End Property

' Name :        property Let IconSpecial
' Parameters:   as_IconSpecial - set IconSpecial
' Description:  Setting IconSpecial for toolbar
' Return value:

Private Property Let IconSpecial(as_IconSpecial As String)
   ms_IconSpecial = as_IconSpecial
End Property

' Name :        property Get IconInvisible
' Parameters:
' Description:  Return property IconInvisible
' Return value: selected IconInvisible for toolbar

Private Property Get IconInvisible() As String
   IconInvisible = ms_IconInvisible
End Property

' Name :        property Let IconInvisible
' Parameters:   as_IconInvisible - set IconInvisible
' Description:  Setting IconInvisible for toolbar
' Return value:

Private Property Let IconInvisible(as_IconInvisible As String)
   ms_IconInvisible = as_IconInvisible
End Property

' Name :        property Get ToolbarWidth
' Parameters:
' Description:  Return property Width
' Return value: Width for toolbar

Private Property Get ToolbarWidth() As Integer
   ToolbarWidth = mi_Width
End Property

' Name :        property Let ToolbarWidth
' Parameters:   as_IconInvisible - set Width
' Description:  Setting Width for toolbar
' Return value:

Private Property Let ToolbarWidth(ai_Width As Integer)
   mi_Width = ai_Width
End Property



' Name :        property Get Face
' Parameters:
' Description:  return property face
' Return value: ms_Face

Private Property Get Face() As String
   Face = ms_Face
End Property

' Name :        property Let Face
' Parameters:   as_Face - setting face for toolbar
' Description:  Setting face for toolbar, if none, then default face
' Return value:

Private Property Let Face(as_Face As String)
   If (as_Face = "") Then
      ms_Face = ms_DefaultFace
   Else
      ms_Face = as_Face
   End If
End Property

' Name :        property Get ToolbarKey
' Parameters:
' Description:  return property ToolbarKey
' Return value: ms_ToolbarKey

Private Property Get ToolbarKey() As String
   ToolbarKey = ms_ToolbarKey
End Property

' Name :        property Let ToolbarKey
' Parameters:   as_ToolbarKey - setting ToolbarKey for toolbar
' Description:  Setting ToolbarKey for toolbar, if none, then default ToolbarKey
' Return value:

Public Property Let ToolbarKey(as_ToolbarKey As String)
   If (as_ToolbarKey = "") Then
      ms_ToolbarKey = ms_DefaultToolbarKey
   Else
      ms_ToolbarKey = as_ToolbarKey
   End If
End Property

' Name :        property Get ApplicationName
' Parameters:
' Description:  return property ApplicationName
' Return value: ms_ApplicationName

Private Property Get ApplicationName() As String
   ApplicationName = ms_ApplicationName
End Property

' Name :        property Let ApplicationName
' Parameters:   ab_ApplicationName - module name
' Description:  Setting of property ms_ApplicationName
' Return value:

Private Property Let ApplicationName(as_ApplicationName As String)
   ms_ApplicationName = as_ApplicationName
End Property

' Name :        property Get UserCode
' Parameters:
' Description:  return property UserCode
' Return value: mi_UserCode

Private Property Get UserCode() As Integer
   UserCode = mi_UserCode
End Property

' Name :        property Let UserCode
' Parameters:   ai_UserCode - user code
' Description:  Setting of property mi_UserCode
' Return value:

Private Property Let UserCode(ai_UserCode As Integer)
   mi_UserCode = ai_UserCode
End Property

' Name :        property Let ButtonsString
' Parameters:   as_ButtonsString - string for one toolbar with/without language prefix
' Description:  Setting ToolbarString for toolbar only in desing time.
'               Display toolbar (function ShowToolbar)
' Return value:

Public Property Let ButtonsString(ByVal as_ButtonsString As String)
   If Ambient.UserMode And Not MaintenanceMode Then
      Err.Raise 382, , "Let/Set of Property ButtonsString not supported at run time."
   Else
      If MaintenanceMode Then
         Load_A_COM
         MaintenanceMode = True
      Else
         Load_A_COM
      End If
      
      ToolbarString = as_ButtonsString
   End If
End Property

' Name :        property Get ButtonsString
' Parameters:
' Description:  return property ButtonsString
' Return value: ms_ButtonsString

Public Property Get ButtonsString() As String
Dim ls_ButtonsString As String
Dim lo_ToolbarItem As New clsIconInfo

   If Not (mo_colToolbar Is Nothing) Then
      For li_Position = Asc(ms_UpperCharStart) To Asc(ms_LowerCharEnd)
         Set lo_ToolbarItem = mo_colToolbar.ItemPosition(Chr(li_Position))
         If Not (lo_ToolbarItem Is Nothing) Then
            ls_ButtonsString = ls_ButtonsString + lo_ToolbarItem.Position + lo_ToolbarItem.Name + lo_ToolbarItem.Role
         End If
      Next
   End If
   ButtonsString = ls_ButtonsString
End Property

' Name :        property Get ToolbarString
' Parameters:
' Description:  return property ToolbarString
' Return value: ms_ToolbarString

Private Property Get ToolbarString() As String
   ToolbarString = ms_ToolbarString
End Property

' Name :        property Let ToolbarString
' Parameters:   as_ToolbarString - string for one toolbar with/without language prefix
' Description:  Setting ToolbarString for toolbar.
'               If exists language prefix sets selected language and available languages for toolbar/user
'               Fill mo_colToolbar collection for toolbar
'               Display toolbar (function ShowToolbar)
' Return value:

Private Property Let ToolbarString(ByVal as_ToolbarString As String)
   Dim lo_arrToolbarString() As String
   Dim ls_ToolbarString As String
   
On Error GoTo ErrorHandler:

 
   
   ms_ToolbarString = as_ToolbarString
             
   ls_ToolbarString = ms_ToolbarString
   
   Set mo_colToolbar = New clsIconInfoCollection
   
   While Len(ls_ToolbarString) > 2
      mo_colToolbar.Add Mid(ls_ToolbarString, 2, 1), , , Mid(ls_ToolbarString, 3, 1), Mid(ls_ToolbarString, 1, 1)
      
      ls_ToolbarString = Right(ls_ToolbarString, Len(ls_ToolbarString) - 3)
       
   Wend
   
   If Not (ShowToolbar()) Then
      GoTo ErrorHandler
   End If
         
   Exit Property
   
ErrorHandler:
   
'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
End Property

' Name :        property Get ToolbarInfoString
' Parameters:
' Description:  return property ToolbarInfoString
' Return value: ms_ToolbarInfoString

Private Property Get ToolbarInfoString() As String
   ToolbarInfoString = ms_ToolbarInfoString
End Property

' Name :        property Let ToolbarInfoString
' Parameters:   as_ToolbarInfoString - string for toolbars with toolbar keys and faces
' Description:  Create mo_colToolbarInfoString collection for as_ToolbarString
'               Split string on substrings, which are delimited with ms_Delimiter (string for one toolbarkey)
'               Split every substring on substring, which are elimited with face number (string for one face) = ms_ToolbarString
'               Add every substring (ToolbarString in mo_colToolbarInfoString)
' Return value:
 
Private Property Let ToolbarInfoString(as_ToolbarInfoString As String)
   Dim lo_arrToolbarInfoString() As String
   Dim lo_arrToolbarFaceString() As String
   Dim lo_arrToolbarFaceStringItem(0 To 2) As String
   Dim lo_arrToolbarString() As String
   Dim ls_ToolbarKey As String
   Dim ls_Face As String
   Dim ls_ToolbarFaceString As String
   Dim lo_colToolbarFaceString As Collection
   Dim li_Index As Integer
   Dim ls_LangString As String
   
   
   lo_arrToolbarInfoString = Split(as_ToolbarInfoString, ms_Delimiter, -1, vbTextCompare)
   For Each ls_ToolbarInfoStringItem In lo_arrToolbarInfoString
   
      ls_ToolbarKey = Mid(ls_ToolbarInfoStringItem, 1, 3)
      ls_ToolbarInfoStringItem = Mid(ls_ToolbarInfoStringItem, 4, Len(ls_ToolbarInfoStringItem))
      
      If (ls_ToolbarKey = ToolbarKey) Then
      
         Set lo_colToolbarFaceString = New Collection
         ms_ToolbarInfoString = ls_ToolbarInfoStringItem
         ls_ToolbarFaceString = Empty
         ls_FaceKey = Empty
         
         
         ls_LangString = Mid(ms_ToolbarInfoString, 1, InStr(ms_ToolbarInfoString, ms_DelimiterSub) - 1)
         If (Len(ls_LangString) > 1) And Not (InStr(2, ls_LangString, Mid(ls_LangString, 1, 1)) = 0) Then
            LanguageMaster = Mid(ls_LangString, 1, 1)
            
            LoadIconLang Mid(ls_LangString, 2)
         Else
            Err.Raise ml_InternalError, , "Either master language isn't defined or no available language is defined"
         End If
         
         ls_ToolbarInfoStringItem = Mid(ms_ToolbarInfoString, InStr(ms_ToolbarInfoString, ms_DelimiterSub) + 1, Len(ms_ToolbarInfoString))
         
         li_Index = 0
         lo_arrToolbarFaceString = Split(ls_ToolbarInfoStringItem, ms_DelimiterSub, -1, vbTextCompare)
         
         For Each ls_ToolbarFaceStringItem In lo_arrToolbarFaceString
            If (li_Index Mod 3) = 0 Then
               ls_Face = Mid(ls_ToolbarFaceStringItem, 1, 1)
               lo_arrToolbarFaceStringItem(0) = Mid(ls_ToolbarFaceStringItem, 2, Len(ls_ToolbarFaceStringItem) - 1)
            Else
               lo_arrToolbarFaceStringItem(li_Index Mod 3) = ls_ToolbarFaceStringItem
            End If
            
            If (li_Index Mod 3) = 2 Then
               lo_colToolbarFaceString.Add Item:=lo_arrToolbarFaceStringItem, Key:=ls_Face
            End If
            
            li_Index = li_Index + 1
         Next
         mo_colToolbarInfoString.Add Item:=lo_colToolbarFaceString, Key:=ls_ToolbarKey
         
         Exit For
      End If
   
   Next
   

End Property

' Name :        function DisplayFace
' Parameters:   as_Face - face, whom toolbar have to be displayed
' Description:  Setting ToolbarString for entry face from mo_colToolbarInfoString collection.
'               Display toolbar.
' Return value: true/false (No error/ error)

Public Function DisplayFace(as_Face As String) As Boolean

On Error GoTo ErrorHandler:

   Face = as_Face
   ToolbarWidth = mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(0)
   If Not (mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1) = "") Then
      IconLanguage = Mid(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), 1, 1)
      If Not (InStr(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), ms_DelimiterLang) = 0) Then
          LanguageAuthTrans = Mid(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), 2, InStr(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), ms_DelimiterLang) - 2)
          IconSpecial = Mid(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), InStr(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), ms_DelimiterLang) + 1, 1)
          IconInvisible = Mid(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), InStr(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1), ms_DelimiterLang) + 2, Len(mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(1)) - 3 - Len(LanguageAuthTrans))
      End If
   End If
   ToolbarString = mo_colToolbarInfoString.Item(ToolbarKey).Item(Face)(2)
   
   DisplayFace = True
   Exit Function

ErrorHandler:
   
'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
    
   DisplayFace = False

End Function

' Name :        function SetDBParameters
' Parameters:   ai_UserCode  - user code
'               as_ApplicationName - application name
'               as_ToolbarKey - toolbar key
' Description:  Select ToolbarInfoString from database.
'               Set ToolbarInfoString.
'               Set ToolbarKey.
' Return value: true/false (No error/ error)

Public Function SetDBParameters(ai_UserCode As Integer, as_ApplicationName As String, _
         as_ToolbarKey As String) As Boolean
         
Dim ll_HStmt As Long
Dim ls_Req As String
Dim ls_Action As String
         
On Error GoTo ErrorHandler:
        
  'try to open connection if component is not connected
   If Not IsConnected Then
      If Not OpenConnection(ms_Server, ms_Db, ms_User, ms_Pwd, ms_App) Then
         Err.Raise ml_InternalError, , "Open connection failed."
      End If
   End If

   UserCode = ai_UserCode
   ApplicationName = as_ApplicationName
   
   ls_Req = "SELECT Toolbar_Info FROM Toolbars_Users " _
            + " WHERE User_Code = " + CStr(UserCode) + " AND " _
            + " Application_Name = '" + ApplicationName + "' "
            
   ll_HStmt = mo_ArmDb.OpenSQL(ls_Req, -1)
   If ll_HStmt = 0 Then
       Debug.Print "No rows"
       GoTo ErrorHandler
   ElseIf ll_HStmt > 1 Then
       Debug.Print "Too many rows"
       GoTo ErrorHandler
   End If

   ToolbarKey = as_ToolbarKey
   ToolbarInfoString = mo_ArmDb.GetFieldsAt(ll_HStmt, 0, "Toolbar_Info")
      
   mo_ArmDb.Close ll_HStmt
   
   SetDBParameters = True
   
   Exit Function
   
ErrorHandler:
   mo_ArmDb.Close ll_HStmt
   
'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
    
   SetDBParameters = False
End Function

' Name :        function SetToolbarInfoStringParameters
' Parameters:   as_ToolbarInfoString  - ToolbarInfoString
'               as_ToolbarKey - toolbar key
' Description:  Set ToolbarInfoString.
'               Set ToolbarKey.
' Return value: true/false (No error/ error)

Public Function SetToolbarInfoStringParameters(as_ToolbarInfoString As String, _
                  as_ToolbarKey As String, Optional as_Face As String = "") As Boolean
         
On Error GoTo ErrorHandler:
        
   
   ToolbarKey = as_ToolbarKey
   ToolbarInfoString = as_ToolbarInfoString
   If as_Face <> "" Then Call DisplayFace(as_Face)
   SetToolbarInfoStringParameters = True
   
   Exit Function
   
ErrorHandler:
    SetToolbarInfoStringParameters = False
End Function

' Name :        function ShowToolbar
' Parameters:
' Description:  Create and fill toolbar control.
'               Information for toolbar control are in mo_colToolbar.
' Return value: true/false (No error/ error)

Private Function ShowToolbar() As Boolean

   Dim lo_IconInfoItem As clsIconInfo
   Dim li_LastPosition As Integer
   Dim lo_imgIcon As ListImage
   Dim lo_btnIcon As Button
   Dim lo_cboItem As ComboItem
   Dim ls_ImageName As String
    
On Error GoTo ErrorHandler:

   Toolbar.Buttons.Clear
   mo_imgcboLanguage.ComboItems.Clear
   mo_imgcboLanguage.Visible = False
    
   Set Toolbar.ImageList = Nothing
   Set mo_imgcboLanguage.ImageList = Nothing
    
   mo_ilsIcon.ListImages.Clear
   mo_ilsIconLanguage.ListImages.Clear
    
   For Each lo_IconInfoItem In mo_colIcon.Items
      Set lo_imgIcon = mo_ilsIcon.ListImages.Add(, lo_IconInfoItem.Name, LoadIconFromFile(lo_IconInfoItem.Code))
   Next
   
   ' icons for langage
   For Each lo_IconInfoLanguageItem In mo_colLanguage.Items
       Set lo_imgIcon = mo_ilsIcon.ListImages.Add(, ms_IconLangPrefix + lo_IconInfoLanguageItem.Name, LoadIconFromFile(lo_IconInfoLanguageItem.Code))
   Next

   Toolbar.ImageList = mo_ilsIcon
    
   If Not (mo_colToolbar.GetLastPosition = "") Then
      For li_Position = Asc(ms_UpperCharStart) To Asc(mo_colToolbar.GetLastPosition)
          If Not (mo_colToolbar.ItemPosition(Chr(li_Position)) Is Nothing) Then
              
              Set lo_IconInfoItem = mo_colToolbar.ItemPosition(Chr(li_Position))
                 
              If (lo_IconInfoItem.Name = IconLanguage) Then
                 For Each lo_IconInfoLanguageItem In mo_colLanguage.Items
                     Set lo_imgIcon = mo_ilsIconLanguage.ListImages.Add(, lo_IconInfoLanguageItem.Name, LoadIconFromFile(lo_IconInfoLanguageItem.Code))
                 Next
                  
                 mo_imgcboLanguage.ImageList = mo_ilsIconLanguage
                 
                 For Each lo_IconInfoLanguageItem In mo_colLanguage.Items
                    Set lo_cboItem = mo_imgcboLanguage.ComboItems.Add(, lo_IconInfoLanguageItem.Name, , lo_IconInfoLanguageItem.Name)
                    If (lo_IconInfoLanguageItem.Name = ms_Language) Then
                       mo_imgcboLanguage.ComboItems(lo_IconInfoLanguageItem.Name).Selected = True
                    End If
                 Next
                               
                 Set lo_btnIcon = Toolbar.Buttons.Add(, lo_IconInfoItem.Name, , tbrDefault, ms_IconLangPrefix + Language)
                 
                
              ElseIf lo_IconInfoItem.Name = IconSpecial _
                       And (InStr(LanguageAuthTrans, Language) = 0) And Not (Language = LanguageMaster) _
                       And (Not (MaintenanceMode)) Then
                 Set lo_btnIcon = Toolbar.Buttons.Add(, lo_IconInfoItem.Name, , tbrDefault, lo_IconInfoItem.Name)
                 lo_btnIcon.Enabled = False
              ElseIf Not (InStr(IconInvisible, lo_IconInfoItem.Name) = 0) _
                    And Not (Language = LanguageMaster) _
                    And Not (MaintenanceMode) Then
                 Set lo_btnIcon = Toolbar.Buttons.Add(, lo_IconInfoItem.Name, , tbrDefault, lo_IconInfoItem.Name)
                 lo_btnIcon.Enabled = False
              Else
                 Set lo_btnIcon = Toolbar.Buttons.Add(, lo_IconInfoItem.Name, , tbrDefault, lo_IconInfoItem.Name)
              End If
              
              lo_btnIcon.ToolTipText = mo_colIcon.Item(lo_IconInfoItem.Name).Description
              lo_btnIcon.Description = lo_btnIcon.ToolTipText
              
               If MaintenanceMode Then
                  lo_btnIcon.ToolTipText = lo_btnIcon.ToolTipText + " Role:" + lo_IconInfoItem.Role
                  lo_btnIcon.Caption = lo_IconInfoItem.Role
               End If
                      
          Else
             Set lo_btnIcon = Toolbar.Buttons.Add(, , , tbrPlaceholder)
             lo_btnIcon.Width = Toolbar.ButtonWidth
          End If
      Next
   End If
    
   If MaintenanceMode Then
      If Toolbar.ButtonWidth <= ToolbarWidth Then
         If Toolbar.Buttons.Count = 0 Then
            Set lo_btnIcon = Toolbar.Buttons.Add(, , , tbrPlaceholder)
            lo_btnIcon.Width = Toolbar.ButtonWidth
         End If
         While ((Toolbar.Buttons.Item(Toolbar.Buttons.Count).Left + 2 * Toolbar.ButtonWidth) <= ToolbarWidth)
            Set lo_btnIcon = Toolbar.Buttons.Add(, , , tbrPlaceholder)
            lo_btnIcon.Width = Toolbar.ButtonWidth
         Wend
      End If
   End If
    
   Select Case Toolbar.Align
   Case vbAlignTop, vbAlignBottom
      Width = ToolbarWidth
   Case vbAlignLeft, vbAlignRight
      Height = ToolbarWidth
   End Select
   
   ShowToolbar = True
   Exit Function
    
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   ShowToolbar = False

End Function

' Name :        function LoadIconFromFile
' Parameters:   li_IconIndex - index of icon
' Description:  Load picture from external file
' Return value: Picture

Private Function LoadIconFromFile(li_IconIndex As Integer) As Picture
  Set LoadIconFromFile = LoadResPicture(li_IconIndex, vbResIcon)
End Function

' Name :        function LoadIcon
' Parameters:
' Description:  Fill mo_colIcon collection with all available icons for toolbar
' Return value: true/false (No error/ error)

Private Function LoadIcon() As Boolean
   
On Error GoTo ErrorHandler:
   
   Set mo_colIcon = New clsIconInfoCollection
   
   
    mo_colIcon.Add "A", 101, "Add", "A"
    mo_colIcon.Add "B", 102, "Update", "B"
    mo_colIcon.Add "C", 103, "Delete", "C"
    mo_colIcon.Add "D", 105, "Print", "D"
    mo_colIcon.Add "E", 106, "Audit", "E"
    mo_colIcon.Add "F", 107, "Refresh", "F"
    mo_colIcon.Add "G", 111, "Excel", "G"
    mo_colIcon.Add "H", 129, "Valid", "H"
    mo_colIcon.Add "I", 115, "Undo", "I"
    mo_colIcon.Add "J", 126, "OpLT", "J"
    mo_colIcon.Add "K", 125, "OpGT", "K"
    mo_colIcon.Add "L", 116, "Execute", "L"
    mo_colIcon.Add "M", 104, "Find", "M"
    mo_colIcon.Add "N", 130, "View", "N"
    mo_colIcon.Add "O", 118, "Restore", "O"
    mo_colIcon.Add "P", 117, "Save", "P"
    mo_colIcon.Add "Q", 109, "Language", "Q"
    mo_colIcon.Add "R", 113, "ToolBox", "R"
    mo_colIcon.Add "S", 131, "Help", "S"
    mo_colIcon.Add "T", 132, "Quit", "T"
    mo_colIcon.Add "U", 108, "Media", "U"
    mo_colIcon.Add "V", 112, "Memo", "V"
    mo_colIcon.Add "X", 141, "Previous", "X"
    mo_colIcon.Add "Y", 142, "Next", "Y"
    mo_colIcon.Add "Z", 119, "New", "Z"
    mo_colIcon.Add "a", 144, "Share", "a"
    mo_colIcon.Add "b", 114, "Copy", "b"
   
   LoadIcon = True
   Exit Function

ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   LoadIcon = False
   
End Function

' Name :        function LoadIconLang
' Parameters:   Optional as_LangList - list af available languages
' Description:  Fill mo_colLanguage collection with all available language(as_LangList) for toolbar.
'               If as_LangList is empty then all language
' Return value: true/false (No error/ error)

Private Function LoadIconLang(Optional as_LangList As String) As Boolean

   Dim ls_Lang As String
   
On Error GoTo ErrorHandler:
   
   Set mo_colLanguage = New clsIconInfoCollection
  
   If Not (as_LangList = "") Then
      For i = 1 To Len(as_LangList)
         ls_Lang = Mid(as_LangList, i, 1)
         Select Case ls_Lang
         Case "G"
            mo_colLanguage.Add "G", 134, "G"
         Case "S"
            mo_colLanguage.Add "S", 135, "S"
         Case "F"
            mo_colLanguage.Add "F", 136, "F"
         Case "E"
            mo_colLanguage.Add "E", 137, "E"
         Case "I"
            mo_colLanguage.Add "I", 138, "I"
         Case "D"
            mo_colLanguage.Add "D", 139, "D"
         Case "R"
            mo_colLanguage.Add "R", 140, "R"
         End Select
      Next i
   Else
      mo_colLanguage.Add "G", 134, "G"
      mo_colLanguage.Add "S", 135, "S"
      mo_colLanguage.Add "F", 136, "F"
      mo_colLanguage.Add "E", 137, "E"
      mo_colLanguage.Add "I", 138, "I"
      mo_colLanguage.Add "D", 139, "D"
      mo_colLanguage.Add "R", 140, "R"
   End If
   
   LoadIconLang = True
   Exit Function

ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   LoadIconLang = False
   
End Function

' Name :        Function Load_A_COM
' Parameters:
' Description:  Load icons and languages.
'               Set default values.
' Return value:

Public Function Load_A_COM()
   
On Error GoTo ErrorHandler:
   
   LoadIcon
   LoadIconLang
   
   Language = ms_DefaultLanguage
   ToolbarKey = ms_DefaultToolbarKey
   Face = ms_DefaultFace
   MaintenanceMode = False
   mb_InternalConnection = False
 
   Load_A_COM = True
   
   Exit Function
   
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   Load_A_COM = False
   
End Function

' Name :        Function Unload_A_COM
' Parameters:
' Description:  Free and cleare all controls and collections.
' Return value:

Public Function Unload_A_COM() As Boolean

On Error GoTo ErrorHandler:

   If mb_InternalConnection Then
      Call CloseConnection
   End If
   Set mo_ArmDb = Nothing
   
   Set mo_colIcon = Nothing
   Set mo_colLanguage = Nothing
   
   Toolbar.Buttons.Clear
   mo_imgcboLanguage.ComboItems.Clear
   mo_imgcboLanguage.Visible = False
    
   Set Toolbar.ImageList = Nothing
   Set mo_imgcboLanguage.ImageList = Nothing
    
   mo_ilsIcon.ListImages.Clear
   mo_ilsIconLanguage.ListImages.Clear

   Set mo_colToolbarInfoString = Nothing
   Set mo_colToolbar = Nothing
   
   Unload_A_COM = True
   
   Exit Function
   
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   Unload_A_COM = False
End Function

Private Sub mo_imgcboLanguage_Click()
   Language = mo_imgcboLanguage.SelectedItem.Key
   mo_imgcboLanguage.Visible = False
   ShowToolbar
End Sub

Private Sub mo_imgcboLanguage_Dropdown()
   For Each lo_cboItem In mo_imgcboLanguage.ComboItems
      If lo_cboItem.Key = Language Then
         lo_cboItem.Selected = True
         mo_imgcboLanguage.SetFocus
         Exit For
      End If
   Next
End Sub

Private Sub mo_imgcboLanguage_LostFocus()
   mo_imgcboLanguage.Visible = False
End Sub

' Name :        event sub Toolbar_ButtonClick
' Parameters:   Button
' Description:  In run-time mode Raise event action with parameter Role for clicking button.
' Return value:

Private Sub Toolbar_ButtonClick(ByVal Button As MSComctlLib.Button)
   Dim ls_Role As String
   Dim ls_NewRole As String
   
   If Not MaintenanceMode Then
      If (Button.Key = IconLanguage) Then
         With mo_imgcboLanguage
             .Width = 900
             .Top = Toolbar.Buttons(Button.Key).Top
             .Left = Toolbar.Buttons(Button.Key).Left
             .Visible = True
         End With
         Call SendMessage(mo_imgcboLanguage.hwnd, CB_SHOWDROPDOWN, True, ByVal 0&)

      End If
      
      ls_Role = mo_colToolbar.Item(Button.Key).Role
      RaiseEvent Action(ls_Role, Language)
   Else
      If Not (mo_colToolbar.Item(Button.Key) Is Nothing) Then
         ls_NewRole = InputBox("Set new role for icon:", "Setting role", mo_colToolbar.Item(Button.Key).Role)
         
         If Len(ls_NewRole) = 1 Then
            If (Asc(ls_NewRole) >= Asc("A") And Asc(ls_NewRole) <= Asc("Z") Or _
                Asc(ls_NewRole) >= Asc("a") And Asc(ls_NewRole) <= Asc("z")) Then
               mo_colToolbar.Item(Button.Key).Role = ls_NewRole
               Button.Caption = ls_NewRole
               RaiseEvent RoleChanged(ls_NewRole, Button.Key)
            End If
         End If
      End If
   End If
      
End Sub

Public Function AddToolbarIcon(as_Name As String, as_x As Single _
               , Optional ab_SetDefaultRole As Boolean = True) As Boolean
   Dim ls_Position As String
   Dim lo_IconInfoItem As New clsIconInfo
   Dim lo_btnButton As Button
   Dim ls_Role As String
   
On Error GoTo ErrorHandler:
          
   ' Add is allowed only in MaintenanceMode
   If Not MaintenanceMode Then
      AddToolbarIcon = False
      Exit Function
   End If
   
   For Each lo_btnButton In Toolbar.Buttons
      If (lo_btnButton.Left < as_x) And ((lo_btnButton.Left + lo_btnButton.Width) > as_x) Then
         If (lo_btnButton.Style = tbrPlaceholder) Then
            If Asc(ms_UpperCharEnd) = (Asc(ms_UpperCharStart) + Fix(as_x / lo_btnButton.Width)) Then
               ls_Position = ms_LowerCharStart
            ElseIf Asc(ms_UpperCharStart) <= (Asc(ms_UpperCharStart) + Fix(as_x / lo_btnButton.Width)) _
                  And (Asc(ms_UpperCharStart) + Fix(as_x / lo_btnButton.Width)) < Asc(ms_UpperCharEnd) Then
               ls_Position = Chr(Asc(ms_UpperCharStart) + Fix(as_x / lo_btnButton.Width))
            ElseIf Asc(ms_LowerCharStart) <= (Asc(ms_LowerCharStart) + Fix(as_x / lo_btnButton.Width)) _
                  And (Asc(ms_LowerCharStart) + Fix(as_x / lo_btnButton.Width)) < Asc(ms_LowerCharEnd) Then
               ls_Position = Chr(Asc(ms_LowerCharStart) + Fix(as_x / lo_btnButton.Width))
            End If
            Exit For
         End If
      End If
   Next

   If ls_Position = "" Then
      GoTo ErrorHandler:
   End If
   
   If mo_colToolbar.ItemPosition(ls_Position) Is Nothing Then
      If Not (mo_colToolbar.Item(as_Name) Is Nothing) Then
         ls_Role = mo_colToolbar.Item(as_Name).Role
      End If
      If ab_SetDefaultRole Or ls_Role = "" Then
         ls_Role = mo_colIcon.Item(as_Name).Role
      End If
      If Not (mo_colToolbar.Item(as_Name) Is Nothing) Then
         If mo_colToolbar.Remove(as_Name) Then
            mo_colToolbar.Add as_Name, , , ls_Role, ls_Position
         End If
      Else
         mo_colToolbar.Add as_Name, , , ls_Role, ls_Position
      End If
   End If
   
   If Not (ShowToolbar()) Then
      GoTo ErrorHandler
   End If
   
   AddToolbarIcon = True
   
   Exit Function
   
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   AddToolbarIcon = False
End Function

Public Function Remove(as_Name As String) As Boolean
   
On Error GoTo ErrorHandler:
             
   ' Remove is allowed only in MaintenanceMode
   If Not MaintenanceMode Then
      Remove = False
      Exit Function
   End If
             
   Remove = mo_colToolbar.Remove(as_Name)
   
   If Not (ShowToolbar()) Then
      GoTo ErrorHandler
   End If
   
   Exit Function
   
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   Remove = False
End Function

Public Function HitTest(as_x As Single) As Button
   Dim lo_btnButton As Button
   
On Error GoTo ErrorHandler:
          
   ' HitTest is allowed only in MaintenanceMode
   If Not MaintenanceMode Then
      Set HitTest = Nothing
      Exit Function
   End If
   
   For Each lo_btnButton In Toolbar.Buttons
      If (lo_btnButton.Left < as_x) And ((lo_btnButton.Left + lo_btnButton.Width) > as_x) Then
         If (lo_btnButton.Style = tbrDefault) Then
            Set HitTest = lo_btnButton
            Exit Function
         End If
      End If
   Next
   
   Set HitTest = Nothing
   
   Exit Function
   
ErrorHandler:

'   If Err.Number <> 0 Then
'      MsgBox "Error number: " + CStr(Err.Number) _
'       + Chr(13) + "Module: " + Err.Source + ", " + Name _
'       + Chr(13) + "Description:" + Err.Description, vbCritical
'   End If
   
   Set HitTest = Nothing
End Function

Private Sub Toolbar_MouseMove(Button As Integer, Shift As Integer, X As Single, y As Single)
Dim ls_Key As String
   If MaintenanceMode And Button = vbLeftButton Then
      RaiseEvent MouseDown(Button, Shift, X, y)
   End If
End Sub

Private Sub UserControl_Resize()
   If Not MaintenanceMode Then
      Select Case UserControl.Extender.Align
      Case vbAlignNone
         If Width < Height Then
            Toolbar.Align = vbAlignRight
            Width = Toolbar.Width
         Else
            Toolbar.Align = vbAlignTop
            Height = Toolbar.Height
         End If
      Case vbAlignTop
         Toolbar.Align = vbAlignTop
         Height = Toolbar.Height
      Case vbAlignBottom
         Toolbar.Align = vbAlignBottom
         Height = Toolbar.Height
      Case vbAlignLeft
         Toolbar.Align = vbAlignLeft
         Width = Toolbar.Width
      Case vbAlignRight
         Toolbar.Align = vbAlignRight
         Width = Toolbar.Width
      End Select
   Else
      ToolbarWidth = Toolbar.Width
      ShowToolbar
   End If
End Sub
