Attribute VB_Name = "WUS_OraSend"
Option Explicit

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
  (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal NSIZE As Long, ByVal lpFileName As String) As Long

'july /09: oracle error not clearly idenfyed

'definir un acces  la base par A_syscom
'va instancier un objet Armdb de connexion  que l'on refrence dans les ref. du projet
Global mDb As New ArmDB
Global mDbErr As New ArmDB
Global mo_Connection As ADODB.Connection
Global mb_UnicodeProvider As Boolean

'Connection pararameters
Dim ms_ServerName As String
Dim ms_Database As String
Dim ms_Login As String
Dim ms_Password As String

Dim ms_DstConnectionString As String

Private Const CH_LDELIMIT = ""
Private Const C_QUOTE As String = "'"
Private Const C_APPLI As String = "WUS_SQLSend "
Private Const C_ERRORRAISE As Long = 50000
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_DATASET_OK As Long = 30

Dim ms_Oracle() As TOracle
Type TOracle
    TableName As String
    ActionType As String
    Lang_Col As Long
    Parm_Nb As Long
    Request As String
End Type

Dim ms_SQL() As TSQL
Type TSQL
    TableName As String
    ActionType As String
    Lang_Col As Long
    Parm_Nb As Long
    Request As String
End Type

Dim ms_Process() As TProcess
Type TProcess
    Oracle As String
    Master As String
    Master_Req As String
    Transact As String
    Trans_Req As String
    Key_Array As String
    Except_Array As String
End Type

Dim ms_Msg As String

Public Sub Main()
Dim ll_Idx As Long
Dim ll_Idx2 As Long
Dim ls_Req As String
Dim lc_Cursor As Long

On Error GoTo Err_Main

GetDBParm

'SQL connection
ms_Msg = C_APPLI & "SQL connection failure"
If Not mDb.Connect(ms_ServerName, ms_Database, ms_Login, ms_Password) Then Err.Raise C_ERRORRAISE, "Main", ms_Msg
If Not mDbErr.Connect(ms_ServerName, ms_Database, ms_Login, ms_Password) Then MsgBox "erreur"

'Did the first batch end normally ?
If Exclusive_Lock Then
    ms_Msg = C_APPLI & " last run ended ABNORMALLY. Check log and update A_Process_Exclusive table."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'Alocate Exclusive process
If Not Exclusive_Alloc Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to allocate exclusif process. Check log and update A_Process_Exclusive table."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If
'Check process status: should be = New dataset created (CFG_value =30)
If Process_Status <> C_DATASET_OK Then
    ms_Msg = C_APPLI & " ABNORMAL end: Status in A_Config <> 'New dataset created' (CFG_value =30)."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'Update process status to: Data sending (CFG_value =40)
If Not ProcessStatus_Update(40, C_APPLI & " Data transferring.") Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to update A_Config at 'Data sending' (CFG_value =40)."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'Open Oracle connection
ms_Msg = "Oracle connection failure"
Set mo_Connection = OrcOpenConn(ms_DstConnectionString, mb_UnicodeProvider)

WriteLog C_APPLI & "Oracle transfert beginning."

'Oracle request array filling
If Not Array_Oracle Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to get Oracle target files."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If


'SQL request array filling
If Not Array_SQL Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to get SQL target files."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'SQL request array filling
If Not Array_Process Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to build requests array."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'Data transfer
If Not Staging_Process Then
    ms_Msg = C_APPLI & " ABNORMAL end: in data transfer."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'Update process status to: Ready to start (CFG_value =10)
If Not ProcessStatus_Update(10, "Ready to start.") Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to update A_Config at 'Ready to start' (CFG_value =10)."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'De-allocate exclusif process
If Not Exclusive_UnAlloc Then
    ms_Msg = C_APPLI & " ABNORMAL end: Impossible to de-allocate exclusif process. Check log and update A_Process_Exclusive table."
    WriteLog ms_Msg
    
    GoTo Batch_End
End If

'SQL
WriteLog C_APPLI & "normal end"

Batch_End:
    BatchEnd
    Exit Sub

Err_Main:
    WriteLog ms_Msg
    mDb.Close lc_Cursor
End Sub

Public Sub UploadSQLError(ByRef ao_Armdb As Object, ByRef ao_ArmdbErr As Object, ByVal as_Procedure As String)
Dim ls_Req As String, lStr As String, lNumber As Long, lDesc As String

Const C_ERR_FATAL_MSG As String = "A fatal error occured, the application will be terminated. Please report error to IT support team" & vbCrLf & "Error : "
Const C_ERR_REPORT As String = "Please, report this to IT application support"


lNumber = Err.Number
lDesc = Err.Description

On Error GoTo onError

If ao_Armdb.LastErrorCode = 0 Then
    If lNumber <> 0 Then
        'error runtime
        as_Procedure = "VB runtime : " & as_Procedure
        ls_Req = "EXEC Error_Log_Insert '" & App.EXEName & "', '" & App.Major & "." & App.Minor & "." & App.Revision & "', '" _
            & Replace(as_Procedure, "'", "''") & "', '" & lNumber & "','" & lDesc & "'"
        If Not ao_ArmdbErr.ExecuteSQL(ls_Req) Then
            Debug.Print "Impossible to insert in Error log  "
        End If
    Else
        Debug.Print "Call to UploadSQLError not relevant : " & as_Procedure
        Exit Sub
    End If
Else
    'In case of armsyscom failure
    If IsEmpty(ao_Armdb.SQLErrorCodes) Then Err.Raise C_ERRORRAISE, "UploadSQLError", "Fatal error in armsyscom : SQlErrorCodes is empty although LastErrorCode = " & ao_Armdb.LastErrorCode
    If IsEmpty(ao_Armdb.SQLErrorMessages) Then Err.Raise C_ERRORRAISE, "UploadSQLError", "Fatal error in armsyscom : SQLErrorMessages is empty although LastErrorCode = " & ao_Armdb.LastErrorCode
    
    
    Dim lErrMsg As Variant, lErrCode As Variant
    Dim lIdx As Long, lCount As Long, lCount2 As Long
        
    lStr = as_Procedure & " -->"
        
    '  On contourne le bug  l'aide de variables locales, le bug empche d'accder au lment du variant mais pas au variant lui mme
    lErrCode = ao_Armdb.SQLErrorCodes
    lErrMsg = ao_Armdb.SQLErrorMessages
        
    lCount = UBound(lErrCode)
    lCount2 = UBound(lErrMsg)
         
    'If not it may cause a runtime error (index out of bound)
    If lCount = lCount2 Then
        For lIdx = 0 To lCount
            lStr = lStr & "Err : " & lErrCode(lIdx) & ", " & lErrMsg(lIdx)
        Next
    Else
            lStr = lStr & "Errs : " & Join(lErrCode, ", ") & vbCrLf & "Msg : " & Join(lErrMsg, vbCrLf) & vbCrLf & C_ERR_REPORT
    End If
        
    WriteLog lStr

End If
    
Exit Sub

onError:
    ao_Armdb.Disconnect
    MsgBox C_ERR_FATAL_MSG & lNumber & ", " & lDesc, vbCritical
        
    End
End Sub

Private Sub BatchEnd()

mDb.Disconnect
mDbErr.Disconnect

'Oracle
Set mo_Connection = Nothing

End Sub

Private Sub WriteLog(aLog As String)
Dim lReq As String
Const C_REQ As String = "ZLOG_ins2 '$Appli$','$Log$',0"

On Error GoTo Err_WriteLog

lReq = Replace(C_REQ, "$Appli$", C_APPLI)
lReq = Replace(lReq, "$Log$", Replace(aLog, "'", "''"))

mDb.ExecuteSQL (lReq)
Exit Sub

Err_WriteLog:
End Sub

Private Sub GetDBParm()

ms_ServerName = ReadIniFile("APP_LOGIN", "SERVER", "")
ms_Database = ReadIniFile("APP_LOGIN", "DATABASE", "")
ms_Login = ReadIniFile("APP_LOGIN", "USER_NAME", "")
ms_Password = ReadIniFile("APP_LOGIN", "PASSWORD", "")
    
ms_DstConnectionString = ReadIniFile("APP_LOGIN", "DST_CONN", "")

End Sub

Private Function ReadIniFile(as_Section As String, as_Key As String, as_Default As String) As String
Dim ls_Value As String
Dim ll_Length As Long

ls_Value = Space(1024)
ll_Length = GetPrivateProfileString(as_Section, as_Key, as_Default, ls_Value, Len(ls_Value) - 1, App.Path & "\DBConnect.ini")
ls_Value = Left(ls_Value, ll_Length)
ReadIniFile = ls_Value

End Function

' open connection to oracle
Private Function OrcOpenConn(ByVal as_dstConnection As String, ByRef ab_supportUnicode As Boolean) As ADODB.Connection
    Dim mo_Connection As New ADODB.Connection
    
'Call mo_Connection.Open("Provider=oraoledb.oracle.1;Data Source =" + as_dbName + ";User ID=" & as_login & ";Password=" & as_password)
'Call mo_Connection.Open("Provider=sqloledb;Data Source =" + as_dbName + ";User ID=" & as_login & ";Password=" & as_password)


Call mo_Connection.Open(as_dstConnection)


ab_supportUnicode = True

Set OrcOpenConn = mo_Connection

End Function

Private Function GetOrcParameter(ByVal ao_conn As ADODB.Connection, ByVal as_param As String) As String
Dim lo_rs As ADODB.Recordset
Dim ll_rows As Long

Set lo_rs = ao_conn.Execute("SELECT VALUE from NLS_DATABASE_PARAMETERS WHERE PARAMETER='" & as_param & "'", ll_rows)
If ll_rows <> 0 Then
    GetOrcParameter = lo_rs.Fields("VALUE")
End If

Call lo_rs.Close
Set lo_rs = Nothing
    
End Function

Private Function iConv(ByVal as_str As Variant) As String
Dim ls_char As String
Dim ls_ret As String
Dim ll_i As Long

For ll_i = 1 To Len(as_str)
    ls_char = Mid(as_str, ll_i, 1)
    If AscW(ls_char) > 128 Then
        ls_char = Hex(AscW(ls_char))
        While Len(ls_char) < 4
            ls_char = "0" & ls_char
        Wend
        ls_ret = ls_ret & "\" & ls_char
    Else
        ls_ret = ls_ret & ls_char
    End If
Next
iConv = ls_ret

End Function

Private Function IsUnicode(ByVal as_charset As String) As Boolean
IsUnicode = False

Select Case as_charset
    Case "UTF8", "UTF16", "AL16UTF8", "AL16UTF16", "AL32UTF8", "AL32UTF16", "AL32UTF32"
        IsUnicode = True
End Select

End Function

Private Function Oracle_DateConvert(as_Date As Date) As String
Dim ls_Date As String

On Error GoTo Err_OracleDate
ms_Msg = "Oracle date convertion failure for: " & as_Date

Oracle_DateConvert = ""
ls_Date = DatePart("d", as_Date) & "/"
ls_Date = ls_Date & DatePart("m", as_Date) & "/"
ls_Date = ls_Date & DatePart("yyyy", as_Date)

Oracle_DateConvert = ls_Date
Exit Function

Err_OracleDate:
    WriteLog ms_Msg
End Function

Private Function Oracle_Execute(as_Connection As ADODB.Connection, as_Req As String) As Boolean

On Error GoTo Err_OracleExec
Oracle_Execute = False

as_Connection.BeginTrans

'Insert into Oracle
ms_Msg = "ABNORMAL end: Oracle Execute failure for "
Call as_Connection.Execute(as_Req)

' COMMIT UPDATE STATEMENT
Call as_Connection.CommitTrans

Oracle_Execute = True
Exit Function

Err_OracleExec:

    as_Connection.RollbackTrans

    UploadSQLError mDb, mDbErr, ms_Msg & as_Req
End Function

Private Function Exclusive_Lock() As Boolean
Dim ls_Req As String
Dim lc_Data As Long

On Error GoTo Err_ExcLock

Exclusive_Lock = True

ls_Req = "select APE_WhoUse from A_Process_Exclusive where APE_ProcessKey = 'WUS_Batch' and APE_InUse ='0'"

'Retrieve data
lc_Data = mDb.OpenSQL(ls_Req)

If lc_Data <= 0 Or mDb.RowCount(lc_Data) <> 1 Then Exit Function
    
If UCase(mDb.GetFields(lc_Data, 0)) <> "" Then Exit Function

Exclusive_Lock = False
mDb.Close lc_Data
Exit Function

Err_ExcLock:
    UploadSQLError mDb, mDbErr, ls_Req
End Function

Private Function Oracle_Req(ByRef ac_Data As Long, ByRef ao_connection As ADODB.Connection, ByVal as_Table As String, ByVal as_Action As String) As Boolean
Dim ls_Req As String
Dim ll_Count As Long, ll_Idx As Long, ll_Lang As Long, ll_Loop As Long

On Error GoTo Err_OraReq
Oracle_Req = False

'Oracle array Reading
ll_Count = UBound(ms_Oracle)
For ll_Idx = 0 To ll_Count - 1
    If UCase(ms_Oracle(ll_Idx).TableName) = UCase(as_Table) And UCase(ms_Oracle(ll_Idx).ActionType) = UCase(as_Action) Then
        ls_Req = ms_Oracle(ll_Idx).Request
        ll_Lang = ms_Oracle(ll_Idx).Lang_Col
        ll_Loop = ms_Oracle(ll_Idx).Parm_Nb
        
        Exit For
    End If
Next

'Parameter replacements
For ll_Idx = 0 To ll_Loop
    'Unicode page Convertion
    If InStr(1, ls_Req, "$N" & Format(ll_Idx, "00") & "$", vbTextCompare) > 0 Then
        Select Case UCase(mDb.GetFields(ac_Data, ll_Lang))
            Case "RU": ls_Req = Replace(ls_Req, "$N" & Format(ll_Idx, "00") & "$", ConvertCodePageFromAnsi(Replace(mDb.GetFields(ac_Data, ll_Idx), "'", "''"), 1251))
            Case "PL": ls_Req = Replace(ls_Req, "$N" & Format(ll_Idx, "00") & "$", ConvertCodePageFromAnsi(Replace(mDb.GetFields(ac_Data, ll_Idx), "'", "''"), 1250))
            Case Else: ls_Req = Replace(ls_Req, "$N" & Format(ll_Idx, "00") & "$", ConvertCodePageFromAnsi(Replace(mDb.GetFields(ac_Data, ll_Idx), "'", "''"), 1252))
        End Select
    End If
    'Date replacement (Oracle format)
    If InStr(1, ls_Req, "$D" & Format(ll_Idx, "00") & "$", vbTextCompare) > 0 Then
        ls_Req = Replace(ls_Req, "$D" & Format(ll_Idx, "00") & "$", Oracle_DateConvert(mDb.GetFields(ac_Data, ll_Idx)))
    End If
    'Other replacements
    ls_Req = Replace(ls_Req, "$" & Format(ll_Idx, "00") & "$", Replace(mDb.GetFields(ac_Data, ll_Idx), "'", "''"))
Next

'Execute Oracle request
If Oracle_Execute(ao_connection, ls_Req) Then Oracle_Req = True
'Call Oracle_Execute(ao_connection, ls_Req)
'Oracle_Req = True

Exit Function

Err_OraReq:
    UploadSQLError mDb, mDbErr, ls_Req & ms_Msg
End Function


Private Function Array_Oracle() As Boolean
Dim ls_Req As String
Dim lc_Data As Long, ll_Idx As Long, ll_Count As Long
Const C_REQ = "exec WUS_SQLOracle_sel 'ORA'"

Array_Oracle = False
On Error GoTo Err_OraArray

ls_Req = C_REQ
lc_Data = mDb.OpenSQL(ls_Req)
ll_Count = mDb.RowCount(lc_Data)

'Error handling
If lc_Data = 0 Then
    WriteLog "ABNORMAL end: " & ls_Req & " not executed"
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If
If ll_Count = 0 Then
    WriteLog "ABNORMAL end: " & ls_Req & ": no record found."
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If

'Filling array
ReDim ms_Oracle(ll_Count)
Dim lt_Oracle As TOracle
For ll_Idx = 0 To ll_Count - 1
    lt_Oracle.TableName = mDb.GetFields(lc_Data, 0)
    lt_Oracle.ActionType = mDb.GetFields(lc_Data, 1)
    lt_Oracle.Lang_Col = mDb.GetFields(lc_Data, 2)
    lt_Oracle.Parm_Nb = mDb.GetFields(lc_Data, 3)
    lt_Oracle.Request = mDb.GetFields(lc_Data, 4)
    
    ms_Oracle(ll_Idx) = lt_Oracle
    
    mDb.Next (lc_Data)
Next

Array_Oracle = True
mDb.Close (lc_Data)
Exit Function

Err_OraArray:
    UploadSQLError mDb, mDbErr, ls_Req & ms_Msg
End Function

Private Function Array_SQL() As Boolean
Dim ls_Req As String
Dim lc_Data As Long, ll_Idx As Long, ll_Count As Long
Const C_REQ = "exec WUS_SQLOracle_sel 'SQL'"

Array_SQL = False
On Error GoTo Err_OraArray

ls_Req = C_REQ
lc_Data = mDb.OpenSQL(ls_Req)
ll_Count = mDb.RowCount(lc_Data)

'Error handling
If lc_Data = 0 Then
    WriteLog "ABNORMAL end: " & ls_Req & " not executed"
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If
If ll_Count = 0 Then
    WriteLog "ABNORMAL end: " & ls_Req & ": no record found."
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If

'Filling array
ReDim ms_SQL(ll_Count)
Dim lt_SQL As TSQL
For ll_Idx = 0 To ll_Count - 1
    lt_SQL.TableName = mDb.GetFields(lc_Data, 0)
    lt_SQL.ActionType = mDb.GetFields(lc_Data, 1)
    lt_SQL.Lang_Col = mDb.GetFields(lc_Data, 2)
    lt_SQL.Parm_Nb = mDb.GetFields(lc_Data, 3)
    lt_SQL.Request = mDb.GetFields(lc_Data, 4)
    
    ms_SQL(ll_Idx) = lt_SQL
    
    mDb.Next (lc_Data)
Next

Array_SQL = True
mDb.Close (lc_Data)
Exit Function

Err_OraArray:
    UploadSQLError mDb, mDbErr, ls_Req & ms_Msg
End Function

Private Function SQL_Req(ByRef ac_Data As Long, ByVal as_Table As String, ByVal as_Action As String, ab_RowsExpected As Boolean) As Boolean
Dim ls_Req As String
Dim ll_Count As Long, ll_Idx As Long, ll_Lang As Long, ll_Loop As Long
Dim lc_Data As Long

On Error GoTo Err_SQLReq
SQL_Req = False

'Oracle array Reading
ll_Count = UBound(ms_SQL)
For ll_Idx = 0 To ll_Count - 1
    If UCase(ms_SQL(ll_Idx).TableName) = UCase(as_Table) And UCase(ms_SQL(ll_Idx).ActionType) = UCase(as_Action) Then
        ls_Req = ms_SQL(ll_Idx).Request
        ll_Lang = ms_SQL(ll_Idx).Lang_Col
        ll_Loop = ms_SQL(ll_Idx).Parm_Nb
        
        Exit For
    End If
Next

'SQL Parameter replacements
For ll_Idx = 0 To ll_Loop
    'Date replacement (SQL format)
    If InStr(1, ls_Req, "$D" & Format(ll_Idx, "00") & "$", vbTextCompare) > 0 Then
        ls_Req = Replace(ls_Req, "$D" & Format(ll_Idx, "00") & "$", SQL_DateConvert(mDb.GetFields(ac_Data, ll_Idx)))
    End If
    'Other replacements
    ls_Req = Replace(ls_Req, "$" & Format(ll_Idx, "00") & "$", Replace(mDb.GetFields(ac_Data, ll_Idx), "'", "''"))
Next

lc_Data = mDb.OpenSQL(ls_Req)
If lc_Data <= 0 Then
    WriteLog "ABNORMAL end: " & ls_Req & " not executed."
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If
If mDb.SQLRowsAffected <= 0 And ab_RowsExpected Then
    WriteLog "ABNORMAL end: " & ls_Req & " no row affected."
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If

SQL_Req = True
If Not mDb.Close(lc_Data) Then Exit Function
Exit Function

Err_SQLReq:
    'Update July/09 begin
    WriteLog "**** An error has been posted in Error_log file. Check and forward level 2 if needed."
    'Update July/09 end
    UploadSQLError mDb, mDbErr, ls_Req & ms_Msg
End Function

Private Function Array_Process() As Boolean
Dim ls_Req As String
Dim lc_Data As Long, ll_Idx As Long, ll_Count As Long
Const C_REQ = "exec WUS_MasterProcess_lst"

Array_Process = False
On Error GoTo Err_ProcessArray

ls_Req = C_REQ
lc_Data = mDb.OpenSQL(C_REQ)
ll_Count = mDb.RowCount(lc_Data)

'Error handling
If lc_Data = 0 Then
    WriteLog ls_Req & " not executed"
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If
If ll_Count = 0 Then
    WriteLog ls_Req & ": no record found."
    
    Err.Raise C_ERRORRAISE, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & ms_Msg
End If

'Filling array
ReDim ms_Process(ll_Count)
Dim lt_Process As TProcess
For ll_Idx = 0 To ll_Count - 1
    lt_Process.Oracle = mDb.GetFields(lc_Data, 1)
    lt_Process.Master = mDb.GetFields(lc_Data, 2)
    lt_Process.Master_Req = mDb.GetFields(lc_Data, 3)
    lt_Process.Transact = mDb.GetFields(lc_Data, 4)
    lt_Process.Trans_Req = mDb.GetFields(lc_Data, 5)
    lt_Process.Key_Array = mDb.GetFields(lc_Data, 6)
    lt_Process.Except_Array = mDb.GetFields(lc_Data, 7)
    
    ms_Process(ll_Idx) = lt_Process
    mDb.Next (lc_Data)
Next

Array_Process = True
mDb.Close (lc_Data)
Exit Function

Err_ProcessArray:
    UploadSQLError mDb, mDbErr, ls_Req & ms_Msg
End Function
'

Private Function SQL_DateConvert(as_Date As Date) As String
Dim ls_Date As String

On Error GoTo Err_OracleDate
ms_Msg = "Oracle date convertion failure for: " & as_Date

SQL_DateConvert = ""
ls_Date = DatePart("m", as_Date) & "/"
ls_Date = ls_Date & DatePart("d", as_Date) & "/"
ls_Date = ls_Date & DatePart("yyyy", as_Date)

SQL_DateConvert = ls_Date
Exit Function

Err_OracleDate:
    WriteLog ms_Msg
End Function

Function CreateArray(ByRef as_array() As String) As Variant
Dim lv_Array As Variant
Dim ll_Index As Long

ReDim lv_Array(UBound(as_array))
For ll_Index = 0 To UBound(lv_Array)
         lv_Array(ll_Index) = as_array(ll_Index)
Next
CreateArray = lv_Array
End Function

Private Function Staging_Process() As Boolean
Dim ll_Idx As Long, ll_Idx2 As Long, ll_Count As Long
Dim lc_New As Long, lc_Master As Long, lc_Result As Long
Dim ls_Req As String
Dim lb_OracleFailure As Boolean

On Error GoTo Err_Locator

Staging_Process = False
ms_Msg = "Staging_Process failure."

'Array process reading
ll_Count = UBound(ms_Process)
For ll_Idx = 0 To ll_Count - 1
    'TO DO manage errors
    
    ' keep in memory if an oracle request fails
    lb_OracleFailure = False
    
    'open cursor with new data
    ls_Req = ms_Process(ll_Idx).Trans_Req
    lc_New = mDb.OpenSQL(ls_Req)
    If lc_New > 0 And mDb.RowCount(lc_New) > 0 Then
        'open cursor with existing data
        ls_Req = ms_Process(ll_Idx).Master_Req
        lc_Master = mDb.OpenSQL(ls_Req)
        
        'Compare the 2 cursors
        Dim ls_Key() As String, ls_Except()  As String
        ls_Key = Split(ms_Process(ll_Idx).Key_Array, "")
        ls_Except = Split(ms_Process(ll_Idx).Except_Array, "")
        
        lc_Result = mDb.CompareCursorsMem(lc_Master, lc_New, _
            CreateArray(ls_Key), "Tran_type", CreateArray(ls_Except))
  
        'Problem in cursors comparing
        If lc_Result = 0 Then
            lb_OracleFailure = True
            WriteLog C_APPLI & "ABNORMAL CompareCursors: " & ms_Process(ll_Idx).Master_Req & "/" & ms_Process(ll_Idx).Trans_Req
        End If
        
        If mDb.RowCount(lc_Result) <> 0 And lc_Result > 0 Then
            WriteLog mDb.RowCount(lc_Result) & " records to process for: " & ms_Process(ll_Idx).Oracle
            
            'Read result cursor
            For ll_Idx2 = 0 To mDb.RowCount(lc_Result) - 1
            'TO DO Manage errors
            'for each row test status
            '1) Convert to oracle
            '2) Update MAster file
                Select Case mDb.GetFields(lc_Result, "Tran_type")
                Case "D"
                    If Oracle_Req(lc_Result, mo_Connection, ms_Process(ll_Idx).Oracle, "D") Then
                        Call SQL_Req(lc_Result, ms_Process(ll_Idx).Master, "D", True)
                    Else
                        lb_OracleFailure = True
                    End If
                Case "U"
                    If Oracle_Req(lc_Result, mo_Connection, ms_Process(ll_Idx).Oracle, "D") Then
                        If SQL_Req(lc_Result, ms_Process(ll_Idx).Master, "D", True) Then
                            If Oracle_Req(lc_Result, mo_Connection, ms_Process(ll_Idx).Oracle, "A") Then
                                Call SQL_Req(lc_Result, ms_Process(ll_Idx).Master, "A", True)
                            End If
                        End If
                    Else
                        lb_OracleFailure = True
                    End If
                Case "A"
                    If Oracle_Req(lc_Result, mo_Connection, ms_Process(ll_Idx).Oracle, "A") Then
                        Call SQL_Req(lc_Result, ms_Process(ll_Idx).Master, "A", True)
                    Else
                        lb_OracleFailure = True
                    End If
                End Select
                
                'new read
                mDb.Next (lc_Result)
            Next
        End If
        
        'Clear transaction file only one time per table
        Call SQL_Req(lc_Result, ms_Process(ll_Idx).Transact, "D", False)
        
        'Free memory
        mDb.Close (lc_Result)
        mDb.Close (lc_Master)
    End If
    
    'Free memory
    mDb.Close (lc_New)
Next

'if oracle fails ==> prevent next WF_Build to run.
If lb_OracleFailure = False Then Staging_Process = True

If mDb.CursorCount <> 0 Then WriteLog "Cursor count not correct"
Exit Function

Err_Locator:
    WriteLog ms_Msg
    mDb.Close (lc_Result)
End Function

Private Function Exclusive_Alloc() As Boolean
Dim ls_Req As String
Const C_REQ = "update  A_Process_Exclusive set APE_InUse = '1', APE_WhoUse = '$Who$', APE_Date =getdate() where APE_ProcessKey = 'WUS_Batch'"

On Error GoTo Err_Exclusif

Exclusive_Alloc = False

ls_Req = C_REQ
ls_Req = Replace(ls_Req, "$Who$", ms_Login)

'Update possible ?
If Not mDb.ExecuteSQL(ls_Req) Or mDb.SQLRowsAffected <> 1 Then
    Err.Raise C_ERRORRAISE, "Exclusive_Alloc", "Impossible to allocate exclusif process."
End If

'Process runnable
Exclusive_Alloc = True
Exit Function

Err_Exclusif:
    UploadSQLError mDb, mDbErr, ls_Req
End Function

Private Function Exclusive_UnAlloc() As Boolean
Dim ls_Req As String
Const C_REQ = "update  A_Process_Exclusive set APE_InUse = '0', APE_WhoUse = '', APE_Date =null where APE_ProcessKey = 'WUS_Batch'"

On Error GoTo Err_Exclusif

Exclusive_UnAlloc = False

ls_Req = C_REQ

'Update possible ?
If Not mDb.ExecuteSQL(ls_Req) Or mDb.SQLRowsAffected <> 1 Then
    Err.Raise C_ERRORRAISE, "Exclusive_UnAlloc", "Impossible to de-allocate exclusif process."
End If

'Process runnable
Exclusive_UnAlloc = True
Exit Function

Err_Exclusif:
    UploadSQLError mDb, mDbErr, ls_Req
End Function

Private Function Process_Status() As Long

Dim ls_Req As String
Dim lc_Data As Long

On Error GoTo Err_Process_Status

Process_Status = 0

ls_Req = "EXEC A_Config_sel 'WUS_Batch'"
'Retrieve data
lc_Data = mDb.OpenSQL(ls_Req)

If lc_Data <= 0 Or mDb.RowCount(lc_Data) <> 1 Then Exit Function
    
Process_Status = CInt(mDb.GetFields(lc_Data, 0))

mDb.Close lc_Data
Exit Function

Err_Process_Status:
    UploadSQLError mDb, mDbErr, ls_Req
End Function

Private Function ProcessStatus_Update(ByVal as_Status As Long, ByVal as_Info As String) As Boolean
Dim ls_Req As String
Dim lc_Data As Long
Const C_REQ As String = "A_Config_upd 'WUS_Batch','$Value$','$Info$'"

On Error GoTo Err_Process_StatusUpd

ProcessStatus_Update = False

ls_Req = C_REQ
ls_Req = Replace(ls_Req, "$Value$", as_Status)
ls_Req = Replace(ls_Req, "$Info$", as_Info)

'Retrieve data
lc_Data = mDb.OpenSQL(ls_Req)

If lc_Data <= 0 Or mDb.SQLRowsAffected <> 1 Then Exit Function
    
ProcessStatus_Update = True

mDb.Close lc_Data
Exit Function

Err_Process_StatusUpd:
    UploadSQLError mDb, mDbErr, ls_Req
End Function


