VERSION 5.00
Begin VB.UserControl MediaBlobConfig 
   ClientHeight    =   8100
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15885
   ScaleHeight     =   8100
   ScaleWidth      =   15885
   Begin VB.Frame frm_detail 
      Height          =   7095
      Left            =   150
      TabIndex        =   0
      Top             =   765
      Width           =   14550
      Begin VB.TextBox txt_WMB_Name 
         Height          =   345
         Left            =   1035
         MaxLength       =   50
         TabIndex        =   35
         Tag             =   "WMB_Name"
         Text            =   "WMB_Name"
         Top             =   750
         Width           =   7305
      End
      Begin VB.Frame frm_mtnc 
         Height          =   1230
         Left            =   105
         TabIndex        =   16
         Top             =   4515
         Width           =   7770
         Begin VB.CheckBox chk_Drop_Flag 
            Caption         =   "Drop_Flag"
            Enabled         =   0   'False
            Height          =   390
            Left            =   5820
            TabIndex        =   22
            Tag             =   "Drop_Flag"
            Top             =   240
            Width           =   1770
         End
         Begin VB.TextBox txt_Drop_Date 
            Enabled         =   0   'False
            Height          =   345
            Left            =   5880
            TabIndex        =   21
            Tag             =   "Drop_Date"
            Text            =   "Drop_Date"
            Top             =   675
            Width           =   1725
         End
         Begin VB.TextBox txt_Z_last_update_date 
            Enabled         =   0   'False
            Height          =   345
            Left            =   3885
            TabIndex        =   20
            Tag             =   "Z_last_update_date"
            Text            =   "Z_last_update_date"
            Top             =   690
            Width           =   1725
         End
         Begin VB.TextBox txt_Z_creation_date 
            Enabled         =   0   'False
            Height          =   345
            Left            =   3885
            TabIndex        =   19
            Tag             =   "Z_creation_date"
            Text            =   "Z_creation_date"
            Top             =   255
            Width           =   1725
         End
         Begin VB.TextBox txt_Z_last_upd_user 
            Enabled         =   0   'False
            Height          =   345
            Left            =   1590
            TabIndex        =   18
            Tag             =   "Z_last_upd_user"
            Text            =   "Z_last_upd_user"
            Top             =   675
            Width           =   2070
         End
         Begin VB.TextBox txt_Z_creator 
            Enabled         =   0   'False
            Height          =   345
            Left            =   1590
            TabIndex        =   17
            Tag             =   "Z_creator"
            Text            =   "Z_creator"
            Top             =   255
            Width           =   2070
         End
         Begin VB.Label lbl_labels 
            Caption         =   "Last upd user:"
            Height          =   255
            Index           =   1
            Left            =   180
            TabIndex        =   24
            Top             =   735
            Width           =   1260
         End
         Begin VB.Label lbl_labels 
            Caption         =   "Creator:"
            Height          =   255
            Index           =   0
            Left            =   180
            TabIndex        =   23
            Top             =   270
            Width           =   1260
         End
      End
      Begin VB.TextBox txt_Z_order 
         Height          =   345
         Left            =   3060
         Locked          =   -1  'True
         MaxLength       =   3
         TabIndex        =   15
         Tag             =   "Z_order"
         Text            =   "Z_order"
         Top             =   270
         Width           =   705
      End
      Begin VB.TextBox txt_WMB_DestHost 
         Height          =   345
         Left            =   1035
         MaxLength       =   150
         TabIndex        =   14
         Tag             =   "WMB_DestHost"
         Text            =   "WMB_DestHost"
         Top             =   1230
         Width           =   1725
      End
      Begin VB.TextBox txt_WMB_Comment 
         Height          =   1650
         Left            =   1035
         MaxLength       =   150
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   13
         Tag             =   "WMB_Comment"
         Text            =   "MediaBlobConfig.ctx":0000
         Top             =   2670
         Width           =   13185
      End
      Begin VB.TextBox txt_WMB_FTP_Pass 
         Height          =   345
         Left            =   12480
         MaxLength       =   50
         TabIndex        =   12
         Tag             =   "WMB_FTP_Pass"
         Text            =   "WMB_FTP_Pass"
         Top             =   1230
         Width           =   1725
      End
      Begin VB.TextBox txt_WMB_FTP_User 
         Height          =   345
         Left            =   9420
         MaxLength       =   50
         TabIndex        =   11
         Tag             =   "WMB_FTP_User"
         Text            =   "WMB_FTP_User"
         Top             =   1230
         Width           =   1725
      End
      Begin VB.TextBox txt_WMB_Port 
         Height          =   345
         Left            =   4650
         Locked          =   -1  'True
         TabIndex        =   10
         Tag             =   "WMB_Port"
         Text            =   "WMB_Port"
         Top             =   1230
         Width           =   945
      End
      Begin Tools.ArmCombobox cbo_WMB_Protocol 
         Height          =   345
         Left            =   2970
         TabIndex        =   9
         Tag             =   "WMB_Protocol"
         Top             =   1230
         Width           =   1470
         _ExtentX        =   2593
         _ExtentY        =   609
      End
      Begin VB.CheckBox chk_WMB_TransferSubfolders 
         Caption         =   "WMB_TransferSubfolders"
         Height          =   390
         Left            =   8700
         TabIndex        =   8
         Tag             =   "WMB_TransferSubfolders"
         Top             =   2190
         Width           =   2895
      End
      Begin VB.CheckBox chk_WMB_FTP_Active 
         Caption         =   "WMB_FTP_Active"
         Height          =   390
         Left            =   6630
         TabIndex        =   7
         Tag             =   "WMB_FTP_Active"
         Top             =   225
         Width           =   1710
      End
      Begin VB.TextBox txt_WMB_DestFolder 
         Height          =   345
         Left            =   1035
         MaxLength       =   150
         TabIndex        =   6
         Tag             =   "WMB_DestFolder"
         Text            =   "WMB_DestFolder"
         Top             =   1710
         Width           =   7305
      End
      Begin VB.TextBox txt_WMB_LocalFolder 
         Height          =   345
         Left            =   1035
         Locked          =   -1  'True
         MaxLength       =   150
         TabIndex        =   5
         Tag             =   "WMB_LocalFolder"
         Text            =   "WMB_LocalFolder"
         Top             =   2190
         Width           =   7305
      End
      Begin VB.TextBox txt_WMB_Last_Success_Transfer 
         Height          =   345
         Left            =   12495
         TabIndex        =   4
         Tag             =   "WMB_Last_Success_Transfer"
         Text            =   "WMB_Last_Success_Transfer"
         Top             =   270
         Width           =   1725
      End
      Begin VB.TextBox txt_WMB_Type 
         Height          =   345
         Left            =   1035
         Locked          =   -1  'True
         TabIndex        =   3
         TabStop         =   0   'False
         Tag             =   "WMB_Type"
         Text            =   "WMB_Type"
         Top             =   270
         Width           =   1125
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Comment:"
         Height          =   255
         Index           =   11
         Left            =   105
         TabIndex        =   34
         Top             =   2655
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Order:"
         Height          =   255
         Index           =   10
         Left            =   2430
         TabIndex        =   33
         Top             =   360
         Width           =   615
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Password:"
         Height          =   255
         Index           =   9
         Left            =   11475
         TabIndex        =   32
         Top             =   1320
         Width           =   840
      End
      Begin VB.Label lbl_labels 
         Caption         =   "User:"
         Height          =   255
         Index           =   8
         Left            =   8700
         TabIndex        =   31
         Top             =   1320
         Width           =   660
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Host:"
         Height          =   255
         Index           =   7
         Left            =   105
         TabIndex        =   30
         Top             =   1305
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Local folder:"
         Height          =   255
         Index           =   6
         Left            =   105
         TabIndex        =   29
         Top             =   2220
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Dest folder:"
         Height          =   255
         Index           =   5
         Left            =   105
         TabIndex        =   28
         Top             =   1725
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Name:"
         Height          =   255
         Index           =   4
         Left            =   105
         TabIndex        =   27
         Top             =   810
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Last_Success_Transfer:"
         Height          =   255
         Index           =   3
         Left            =   10590
         TabIndex        =   26
         Top             =   360
         Width           =   1860
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Type:"
         Height          =   255
         Index           =   2
         Left            =   105
         TabIndex        =   25
         Top             =   330
         Width           =   915
      End
   End
   Begin Tools.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   2
      Top             =   90
      Width           =   15390
      _ExtentX        =   27146
      _ExtentY        =   1217
   End
   Begin Tools.ArmGrid grd_lst 
      Height          =   6225
      Left            =   195
      TabIndex        =   1
      Top             =   855
      Width           =   6855
      _ExtentX        =   12091
      _ExtentY        =   10980
   End
End
Attribute VB_Name = "MediaBlobConfig"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SCREEN_NAME As String = "MediaBlobConfig"
Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Const C_TOOLBARFACE_ITEM_LST As String = "0"
Private Const C_TOOLBARFACE_ITEM_MTNC As String = "1"
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "2"
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private mb_EventRunning As Boolean
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal _
    hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, _
    lParam As Any) As Long
Const EM_LINEFROMCHAR = &HC9


Private mb_Initialized As Boolean
Private mo_Db As ArmDb
Private ms_Language_Code As String
Dim mu_ActiveMode As ArmScreenMode

Private ml_U_Code As Long
Private ml_iconc As Long

Public Event Quit()
Private Enum ArmScreenMode
  smMain
  smUpdate
  smView
End Enum


Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo errHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
errHandler:
'    Call errorHandler("LockScreen")
End Sub


Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property


Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight - 2220)
    Call Resize
End Sub

Property Let Language_Code(AString As String)
On Error GoTo errHandler

  ms_Language_Code = AString
  Exit Property
errHandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo errHandler

  ml_U_Code = al_U_Code
  Exit Property
errHandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo errHandler
  
  Set mo_Db = lo_Db
  Exit Property
errHandler:
  Call ErrorHandler("ArmDb.Set")
End Property


Public Sub Load_A_Com()
    
On Error GoTo errHandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    
    mb_EventRunning = True
    
    Dim lo_Control As Object
    Dim lo_ToolTip As Object
    
      For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_Com
        End Select
      Next
    
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 3, null, null, $id$"
    ' init toolbar
    Dim ll_Cursor As Long
    'Call tlb_main.SetToolbarInfoStringParameters("001EESFGIDRW09953QE/BACAAABBBCCCHLLQTT", "001")
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", 2988))
    If Not tlb_main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), "339") Then
        MsgBox ("Toolbar not initialised! (2988)")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' init grig
    grd_lst.AllowExcelExport = True
    grd_lst.Title = "Media Blob Config folders"
    
    
    If Not grd_lst.SetColumns(Array( _
                Join(Array("WMB_Type", 0, 1, "WMB_Type", "#"), SEP) _
                , Join(Array("WMB_Name", 2000, 0, "WMB_Name", "Name"), SEP) _
                , Join(Array("WMB_FTP_Active", 300, 0, "WMB_FTP_Active", "FTP_Active"), SEP) _
                , Join(Array("WMB_Last_Success_Transfer", 1000, 0, "WMB_Last_Success_Transfer", "Last transfer"), SEP) _
                , Join(Array("WMB_LocalFolder", 1500, 0, "WMB_LocalFolder", "Local"), SEP) _
                , Join(Array("WMB_DestFolder", 3000, 0, "WMB_DestFolder", "Destination", "String"), SEP) _
                , Join(Array("WMB_DestHost", 1000, 0, "WMB_DestHost", "Host", "String"), SEP) _
                , Join(Array("WMB_TransferSubfolders", 200, 0, "WMB_TransferSubfolders", "Subfolders", "String"), SEP) _
                )) Then
        MsgBox ("Grid not initialized!")
    End If
    
    If Not grd_lst.Load("EXEC WUS_MediaBlob_Config_lst", True) Then
        MsgBox ("Grid not loaded (WUS_MediaBlob_Config_lst)!")
    End If
    
    ' cbo protocols
    cbo_WMB_Protocol.AddItem (Array("FTP", "ftp", "22"))
    cbo_WMB_Protocol.AddItem (Array("SFTP", "sftp", "21"))
    cbo_WMB_Protocol.AddItem (Array("HTTP", "http", "80"))
    cbo_WMB_Protocol.AddItem (Array("SHTTP", "shttp", "8080"))
    
    
    Call EnableControl(txt_WMB_Type, False)
    Call EnableControl(txt_Z_order, False)
    Call EnableControl(txt_WMB_LocalFolder, False)
    Call EnableControl(txt_Z_creator, False)
    Call EnableControl(txt_Z_creation_date, False)
    Call EnableControl(txt_Z_last_upd_user, False)
    Call EnableControl(txt_Z_last_update_date, False)
    Call EnableControl(chk_Drop_Flag, False)
    Call EnableControl(txt_Drop_Date, False)
    Call UpdateUI(ArmScreenMode.smMain)
    
    mb_EventRunning = False
    
    Exit Sub
    
errHandler:
    
    Call ErrorHandler("Load_A_COM")
    
End Sub

Private Sub UpdateUI(ByVal au_Mode As ArmScreenMode)
On Error GoTo errHandler

    ' set active face
    mu_ActiveMode = au_Mode
    tlb_main.Redraw = False

    ' apply face
    Dim lo_ctrl As Object

    ' hide all frames
    frm_detail.Visible = False
    grd_lst.Visible = False

    ' we have clean screen we can display proper controls
    Select Case mu_ActiveMode
        Case smMain
            grd_lst.Visible = True
    
            Call tlb_main.DisplayFace(C_TOOLBARFACE_ITEM_LST)
        Case smUpdate
            ' we are in Update section
            frm_detail.Visible = True
            

            Call EnableControl(txt_WMB_Last_Success_Transfer, True)
            Call EnableControl(chk_WMB_FTP_Active, True)
            Call EnableControl(txt_WMB_Name, True)
            Call EnableControl(txt_WMB_DestHost, True)
            Call EnableControl(cbo_WMB_Protocol, True)
            Call EnableControl(txt_WMB_Port, True)
            Call EnableControl(txt_WMB_FTP_User, True)
            Call EnableControl(txt_WMB_FTP_Pass, True)
            Call EnableControl(txt_WMB_DestFolder, True)
            Call EnableControl(chk_WMB_TransferSubfolders, True)
            Call EnableControl(txt_WMB_Comment, True)
            Call EnableControl(txt_WMB_FTP_Pass, True)
            Call EnableControl(txt_WMB_FTP_Pass, True)
            Call EnableControl(txt_WMB_FTP_Pass, True)
            Call EnableControl(txt_WMB_FTP_Pass, True)
            
            Call tlb_main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
        Case smView
            ' we are in PreView section
            frm_detail.Visible = True
            
            Call EnableControl(txt_WMB_Last_Success_Transfer, False)
            Call EnableControl(chk_WMB_FTP_Active, False)
            Call EnableControl(txt_WMB_Name, False)
            Call EnableControl(txt_WMB_DestHost, False)
            Call EnableControl(cbo_WMB_Protocol, False)
            Call EnableControl(txt_WMB_Port, False)
            Call EnableControl(txt_WMB_FTP_User, False)
            Call EnableControl(txt_WMB_FTP_Pass, False)
            Call EnableControl(txt_WMB_DestFolder, False)
            Call EnableControl(chk_WMB_TransferSubfolders, False)
            Call EnableControl(txt_WMB_Comment, False)
            Call EnableControl(txt_WMB_FTP_Pass, False)
            Call EnableControl(txt_WMB_FTP_Pass, False)
            Call EnableControl(txt_WMB_FTP_Pass, False)
            Call EnableControl(txt_WMB_FTP_Pass, False)
            
            Call tlb_main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
        Case Else
            Debug.Assert (False)
    End Select
    
    ' to display face immidiatelly
    tlb_main.Redraw = True
    UserControl.Refresh
    Exit Sub
errHandler:
    Call ErrorHandler("UpdateUI()")
End Sub

Private Function Item_LoadDB(ByVal al_WMB_Type As Long) As Long
On Error GoTo errHandler

Const C_REQ = "WUS_MediaBlob_Config_sel $WMB_Type$"
    Dim ll_retVal As Long
    ll_retVal = OpenSQLSafe(mo_Db, Replace(C_REQ, "$WMB_Type$", al_WMB_Type))
        
    ml_iconc = mo_Db.GetFields(ll_retVal, "iConcurrency")

    Item_LoadDB = ll_retVal
    Exit Function
errHandler:
    Call ErrorHandler("Item_LoadDB()")
End Function

Private Function Item_UpdateDB(ByVal al_WMB_Type As Long) As Boolean
On Error GoTo errHandler
Const C_REQ = "WUS_MediaBlob_Config_upd $WMB_Type$, $WMB_Name$, $WMB_FTP_Active$, $WMB_Last_Success_Transfer$, $WMB_DestFolder$, $WMB_DestHost$, $WMB_TransferSubfolders$, $WMB_Protocol$, $WMB_Port$, $WMB_FTP_User$, $WMB_FTP_Pass$, $WMB_Comment$, $Z_order$, $U_Code$, $iConcurrency$"

    Dim ls_req As String
    ls_req = Replace(C_REQ, "$WMB_Type$", al_WMB_Type, , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_Name$", SqlStr(txt_WMB_Name.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_FTP_Active$", SqlStr(IIf(chk_WMB_FTP_Active.value = vbChecked, "X", "")), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_Last_Success_Transfer$", SqlDate(txt_WMB_Last_Success_Transfer.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_DestFolder$", SqlStr(txt_WMB_DestFolder.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_DestHost$", SqlStr(txt_WMB_DestHost.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_TransferSubfolders$", SqlStr(IIf(chk_WMB_TransferSubfolders.value = vbChecked, "X", "")), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_Protocol$", SqlStr(cbo_WMB_Protocol.SelectedItem.Key), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_Port$", SQLNum(txt_WMB_Port.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_FTP_User$", SqlStr(txt_WMB_FTP_User.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_FTP_Pass$", SqlStr(txt_WMB_FTP_Pass.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$WMB_Comment$", SqlStr(txt_WMB_Comment.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Z_order$", SQLNum(txt_Z_order.Text), , , vbTextCompare)
    ls_req = Replace(ls_req, "$U_Code$", ml_U_Code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$iConcurrency$", ml_iconc, , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Item_UpdateDB = True
    Exit Function
errHandler:
    Call ErrorHandler("Item_LoadDB()")
End Function


Private Sub Item_Load(ByVal al_Cursor As Long)
On Error GoTo errHandler
    Dim lo_Control As Control
    For Each lo_Control In Controls
        If lo_Control.Tag <> "" Then
            Select Case UCase(TypeName(lo_Control))
            Case "ARMCOMBOBOX"
                Call lo_Control.SearchItem(mo_Db.GetFields(al_Cursor, lo_Control.Tag))
            Case "ARMPICKER"
            Case "TOOLBARCONTROL"
            Case "ARMGRID"
            Case "ARMTREEVIEW"
            Case "ARMCHECKVIEW"
            Case "A_CALOCX"
            Case "TOOLBR"
            Case "TEXTBOX"
                lo_Control.Text = mo_Db.GetFields(al_Cursor, lo_Control.Tag)
            Case "CHECKBOX"
                lo_Control.value = IIf(mo_Db.GetFields(al_Cursor, lo_Control.Tag) = "", vbUnchecked, vbChecked)
            End Select
        End If
    Next
    Exit Sub
errHandler:
    Call ErrorHandler("Item_Load()")
End Sub

Private Sub Item_Clear()
On Error GoTo errHandler
    Dim lo_Control As Control
    For Each lo_Control In Controls
        If lo_Control.Tag <> "" Then
            Select Case UCase(TypeName(lo_Control))
            Case "ARMCOMBOBOX"
                Set lo_Control.SelectedItem = Nothing
            Case "ARMPICKER"
            Case "TOOLBARCONTROL"
            Case "ARMGRID"
            Case "ARMTREEVIEW"
            Case "ARMCHECKVIEW"
            Case "A_CALOCX"
            Case "TOOLBR"
            Case "TEXTBOX"
                lo_Control.Text = ""
            Case "CHECKBOX"
                lo_Control.value = vbUnchecked
            End Select
        End If
    Next
    Exit Sub
errHandler:
    Call ErrorHandler("Item_Load()")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
'    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, UserControl.Name & "." & UserControl.Ambient.DisplayName & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo errHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
errHandler:
    Call ErrorHandler(Extender.Name & ".GetDbError()")
End Function


Public Sub Unload_A_Com()
    
On Error GoTo errHandler
    mb_Initialized = False
    
    Dim lo_Control As Object

    For Each lo_Control In Controls
      Select Case UCase(TypeName(lo_Control))
      Case "ARMCOMBOBOX"
        Call lo_Control.Unload_A_Com
      Case "ARMPICKER"
        Call lo_Control.Unload_A_Com
      Case "TOOLBARCONTROL"
        Call lo_Control.Unload_A_Com
      Case "ARMGRID"
        Call lo_Control.Unload_A_Com
      Case "ARMTREEVIEW"
        Call lo_Control.Unload_A_Com
      Case "ARMCHECKVIEW"
        Call lo_Control.Unload_A_Com
      Case "TOOLBR"
        Call lo_Control.Unload_A_Com
      End Select
    Next
    Exit Sub
    
errHandler:
    
    Call ErrorHandler("UnLoad_A_Com")
    
End Sub


Private Sub Resize()
On Error GoTo errHandler
    Const SPACE As Long = 20
    Call tlb_main.Move(0, 0, UserControl.Extender.Width - SPACE, tlb_main.Height)
    
    Call grd_lst.Move(0, tlb_main.Top + tlb_main.Height + SPACE, tlb_main.Width)
    grd_lst.Height = UserControl.Extender.Height - grd_lst.Top - SPACE
    
    Call frm_detail.Move(grd_lst.Left, grd_lst.Top, grd_lst.Width, grd_lst.Height)
    
    Exit Sub
errHandler:
    Call ErrorHandler("Resize")
End Sub

Private Sub cbo_WMB_Protocol_ComboItemSelected()
On Error GoTo errHandler
    If mb_EventRunning Then Exit Sub
    txt_WMB_Port.Text = cbo_WMB_Protocol.SelectedItem.GetData(2)
    Exit Sub
errHandler:
    Call ErrorMessage("grd_lst_ItemSelected")
End Sub

Private Sub grd_lst_ItemSelected()
On Error GoTo errHandler
    mb_EventRunning = True
    Call Item_InitView(grd_lst.SelectedKey(0)(0))
    mb_EventRunning = False
    Exit Sub
errHandler:
    mb_EventRunning = False
    Call ErrorMessage("grd_lst_ItemSelected")
End Sub

Private Sub Item_InitView(ByVal al_WMB_Type As Long)
On Error GoTo errHandler
    Call Item_Clear
    Call UpdateUI(smView)
    Dim ll_Cursor As Long
    ll_Cursor = Item_LoadDB(al_WMB_Type)
    Call Item_Load(ll_Cursor)
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Sub
errHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorMessage("Item_InitView")
End Sub

Private Sub Item_InitUpdate(ByVal al_WMB_Type As Long)
On Error GoTo errHandler
    Call Item_Clear
    Call UpdateUI(smUpdate)
    Dim ll_Cursor As Long
    ll_Cursor = Item_LoadDB(al_WMB_Type)
    Call Item_Load(ll_Cursor)
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Sub
errHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorMessage("Item_InitUpdate")
End Sub

Private Function Item_Update() As Boolean
On Error GoTo errHandler
    Item_Update = False
    If Not Item_Check() Then
        Exit Function
    End If
    
    Call Item_UpdateDB(CLng(txt_WMB_Type.Text))
    
    Call UpdateGridAfterAction(grd_lst, "Upd", CLng(txt_WMB_Type.Text))
    
    Item_Update = True
    Exit Function
errHandler:
    Call ErrorMessage("Item_Update")
End Function

Private Function Item_Check() As Boolean
On Error GoTo errHandler
    Item_Check = False

    If Not IsNumeric(txt_WMB_Type.Text) Then
        Call MsgBox("Missing type!")
        Exit Function
    End If
    
    If Len(Trim(txt_WMB_Name.Text)) = 0 Then
        Call MsgBox("Missing Name!")
        Exit Function
    End If
    
    If Len(Trim(txt_WMB_Last_Success_Transfer.Text)) = 0 Then
        Call MsgBox("Missing Last Success Transfer!")
        Exit Function
    End If
    
    If Len(Trim(txt_WMB_FTP_User.Text)) = 0 Then
        Call MsgBox("Missing User!")
        Exit Function
    End If
    
    If Len(Trim(txt_WMB_FTP_Pass.Text)) = 0 Then
        Call MsgBox("Missing Password!")
        Exit Function
    End If
    
    If Len(Trim(txt_WMB_DestHost.Text)) = 0 Then
        Call MsgBox("Missing Dest host!")
        Exit Function
    End If
    
    If cbo_WMB_Protocol.SelectedItem Is Nothing Then
        Call MsgBox("Missing Protocol!")
        Exit Function
    End If
    
    If Not IsNumeric(txt_WMB_Port.Text) Then
        Call MsgBox("Missing Port!")
        Exit Function
    End If
    
    If Not IsDate(txt_WMB_Last_Success_Transfer.Text) Then
        Call MsgBox("Last Transfer date mus be DD/MM/YYYY!")
        Exit Function
    End If
    
    Item_Check = True
    Exit Function
errHandler:
    Call ErrorMessage("Item_Check")
End Function



Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo errHandler
    mb_EventRunning = True

    Select Case as_Role
    Case "B", "I"       ' Update, refresh detail
        If grd_lst.SelectedCount > 0 Then
            Call Item_InitUpdate(grd_lst.SelectedKey(0)(0))
        Else
            Call MsgBox("Select a row please!")
        End If
    Case "F"        ' refresh grid
        Call grd_lst.Refresh
    Case "H"
        If Item_Update Then
            UpdateUI (smMain)
        End If
    Case "T"
        If mu_ActiveMode = smMain Then
            RaiseEvent Quit
        Else
            UpdateUI (smMain)
        End If
        
    End Select

    mb_EventRunning = False
    Exit Sub
errHandler:
    mb_EventRunning = False
    Call ErrorHandler("tlb_main_action")
End Sub

Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo errHandler
    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(1, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_Db))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(2, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
errHandler:
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo errHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise 3, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        Err.Raise 1, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 4, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise 5, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

errHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

Private Sub EnableControl(ByVal ao_Control As Control, ByVal ab_Enabled As Boolean)
On Error GoTo errHandler

    Select Case UCase(TypeName(ao_Control))
        Case "FRAME", "LABEL", "MSFLEXGRID", "SHAPE", "ARMGRID", "ARMCHECKVIEW", "TABSTRIP"
            ' Do nothing !
        Case "LISTVIEW"
            ' Do nothing !
        Case "TEXTBOX"
            ao_Control.Locked = Not ab_Enabled
            ao_Control.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
            ao_Control.TabStop = ab_Enabled
        Case "OPTIONBUTTON"
            ao_Control.Enabled = ab_Enabled
        Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX", "COMMANDBUTTON", "TOOLBARCONTROL"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case Else
          Debug.Print ao_Control.Name
    End Select
  Exit Sub
errHandler:
  Call ErrorHandler("EnableControl")
End Sub


' translate string to sql format
' Params:
' as_Value (String)
' ab_EmptyNULL (Boolean = False)
Private Function SqlStr(ByVal as_Value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_Value = "" And ab_EmptyNULL Then
        SqlStr = "NULL"
    Else
        SqlStr = "'" & Replace(Left(as_Value, IIf(Len(as_Value) <= al_MaxLen, Len(as_Value), al_MaxLen)), "'", "''") & "'"
    End If
End Function

Private Function SqlDate(ByVal av_Data As String) As String
On Error GoTo errHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
errHandler:
End Function


Private Function SQLNum(ByVal as_str As String) As String
    SQLNum = Replace(as_str, ",", ".")
End Function

Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function


Private Sub UpdateGridAfterAction(ByVal ao_grid As ArmGrid, ByVal as_Action As String, ByVal av_Key As Variant)
On Error GoTo errHandler
    Dim ll_Index As Long
    Dim lo_Column As ArmColumn
    
    Select Case as_Action
    Case "Upd"
        ' search and update row in the grid
        Debug.Assert (ao_grid.Cols > 0)
        
        If Not ao_grid.SearchKey(True, av_Key) Then
            Call Err.Raise(1, "ao_grid.SearchKey", "Cannot update grid.")
        End If
        
        For ll_Index = 0 To ao_grid.Cols - 1
            Set lo_Column = ao_grid.Columns(ll_Index)
            If Not lo_Column.Key Then
                If Not lo_Column.SetData(ao_grid.Row, GetDataSrcForGrid(lo_Column)) Then
                    Call Err.Raise(1, "lo_Column.SetData", "Cannot update grid.")
                End If
            End If
        Next
    Case Else
        Debug.Assert (False)
    End Select
    Exit Sub
errHandler:
     Call ErrorHandler("UpdateGridAfterAction()")
End Sub

' when updating main grid from detail
Private Function GetDataSrcForGrid(ByVal ao_Column As ArmColumn) As String
On Error GoTo errHandler
    Select Case ao_Column.FieldName
        
        Case "WMB_Type"
            GetDataSrcForGrid = txt_WMB_Type.Text
        Case "WMB_Name"
            GetDataSrcForGrid = txt_WMB_Name.Text
        Case "WMB_FTP_Active"
            GetDataSrcForGrid = IIf(chk_WMB_FTP_Active.value = vbChecked, "X", "")
        Case "WMB_Last_Success_Transfer"
            GetDataSrcForGrid = txt_WMB_Last_Success_Transfer.Text
        Case "WMB_LocalFolder"
            GetDataSrcForGrid = txt_WMB_LocalFolder.Text
        Case "WMB_DestFolder"
            GetDataSrcForGrid = txt_WMB_DestFolder.Text
        Case "WMB_DestHost"
            GetDataSrcForGrid = txt_WMB_DestHost.Text
        Case "WMB_TransferSubfolders"
            GetDataSrcForGrid = IIf(chk_WMB_TransferSubfolders.value = vbChecked, "X", "")
    End Select
    
    Exit Function
errHandler:
     Call ErrorHandler("GetDataSrcForGrid()")
End Function


