VERSION 5.00
Begin VB.UserControl IVPermis 
   ClientHeight    =   10335
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   13560
   ScaleHeight     =   10335
   ScaleWidth      =   13560
   Begin VB.Frame fra_item 
      Height          =   7815
      Left            =   3240
      TabIndex        =   8
      Top             =   2400
      Visible         =   0   'False
      Width           =   10215
      Begin VB.CommandButton btn_cancelupd 
         Caption         =   "Cancel"
         Height          =   375
         Left            =   9240
         TabIndex        =   25
         Top             =   840
         Width           =   735
      End
      Begin VB.CommandButton btn_Upd 
         Caption         =   "Validate"
         Height          =   375
         Left            =   9240
         TabIndex        =   13
         Top             =   360
         Width           =   735
      End
      Begin VB.CommandButton btn_DelFromTmpList 
         Caption         =   "Delete Selected Rows"
         Height          =   615
         Left            =   9480
         TabIndex        =   16
         Top             =   2160
         Width           =   1335
      End
      Begin VB.CommandButton btn_AddToTmpGrid 
         Caption         =   "<--- Add to the temporary list --->"
         Height          =   495
         Left            =   2880
         Picture         =   "IVPermis.ctx":0000
         TabIndex        =   14
         Top             =   1440
         Width           =   3735
      End
      Begin VB.CommandButton btn_AddTmpListToDB 
         Caption         =   "Validate"
         Height          =   495
         Left            =   3000
         TabIndex        =   17
         Top             =   5160
         Width           =   1455
      End
      Begin VB.CommandButton btn_cancel 
         Caption         =   "Cancel"
         Height          =   495
         Left            =   5040
         TabIndex        =   18
         Top             =   5160
         Width           =   1455
      End
      Begin Tools.ArmGrid grd_TmpList 
         Height          =   2655
         Left            =   120
         TabIndex        =   15
         Top             =   2160
         Width           =   9255
         _ExtentX        =   16325
         _ExtentY        =   4683
      End
      Begin VB.OptionButton opt_rights 
         Caption         =   "UPD"
         Height          =   195
         Index           =   1
         Left            =   8520
         TabIndex        =   12
         Top             =   840
         Width           =   855
      End
      Begin VB.OptionButton opt_rights 
         Caption         =   "VIEW"
         Height          =   195
         Index           =   0
         Left            =   7440
         TabIndex        =   11
         Top             =   840
         Width           =   1335
      End
      Begin Tools.ArmCombobox cbo_uauthcode 
         Height          =   345
         Left            =   3840
         TabIndex        =   10
         Top             =   720
         Width           =   3375
         _ExtentX        =   4260
         _ExtentY        =   609
      End
      Begin Tools.ArmCombobox cbo_ucode 
         Height          =   345
         Left            =   240
         TabIndex        =   9
         Top             =   720
         Width           =   3375
         _ExtentX        =   5741
         _ExtentY        =   609
      End
      Begin VB.Label lbl_labels 
         Alignment       =   2  'Center
         Caption         =   "U_Rights"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   7320
         TabIndex        =   21
         Top             =   480
         Width           =   1935
      End
      Begin VB.Label lbl_labels 
         Caption         =   "U_Authorized_Code"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   3840
         TabIndex        =   20
         Top             =   480
         Width           =   1935
      End
      Begin VB.Label lbl_labels 
         Caption         =   "U_Code"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   19
         Top             =   480
         Width           =   1575
      End
   End
   Begin VB.Frame fra_filter 
      Height          =   10215
      Left            =   120
      TabIndex        =   6
      Top             =   0
      Visible         =   0   'False
      Width           =   3015
      Begin VB.CommandButton btn_TVReLoad 
         Height          =   615
         Left            =   2280
         Style           =   1  'Graphical
         TabIndex        =   22
         TabStop         =   0   'False
         Tag             =   "cmd_TVReLoad"
         Top             =   960
         Width           =   615
      End
      Begin Tools.ArmCombobox cbo_views 
         Height          =   345
         Left            =   120
         TabIndex        =   1
         Top             =   480
         Width           =   2775
         _ExtentX        =   4895
         _ExtentY        =   609
      End
      Begin Tools.ArmTreeView tv_filter 
         Height          =   6975
         Left            =   120
         TabIndex        =   7
         TabStop         =   0   'False
         Top             =   960
         Width           =   2775
         _ExtentX        =   4895
         _ExtentY        =   12303
      End
   End
   Begin VB.Frame fra_list 
      Height          =   8535
      Left            =   3240
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   10215
      Begin VB.CommandButton btn_exit 
         Caption         =   "Quit"
         Height          =   495
         Left            =   9000
         TabIndex        =   24
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton btn_ListReload 
         Height          =   615
         Left            =   5520
         Style           =   1  'Graphical
         TabIndex        =   23
         TabStop         =   0   'False
         Tag             =   "cmd_TVReLoad"
         Top             =   240
         Width           =   615
      End
      Begin VB.CommandButton btn_AddNew 
         Caption         =   "Add"
         Height          =   495
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton btn_Update 
         Caption         =   "Update"
         Height          =   495
         Left            =   1440
         TabIndex        =   3
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton btn_DelFromDB 
         Caption         =   "Delete"
         Height          =   495
         Left            =   2640
         TabIndex        =   4
         Top             =   240
         Width           =   975
      End
      Begin Tools.ArmGrid grd_list 
         Height          =   6855
         Left            =   120
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   1080
         Width           =   9975
         _ExtentX        =   17595
         _ExtentY        =   12091
      End
   End
End
Attribute VB_Name = "IVPermis"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event Quit()

Private Const SCREEN_NAME As String = "IVPO_Permis"
Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Type TTreeViewInfo
    Levels As Long
    NodeRequest() As String
    GridRequest() As String
    ExcelRequest() As String
    CountRequest() As String
    FindRequest() As String
    Images() As Integer
    SelectedImages() As Integer
    TreeViewCode As String
    Loaded As Boolean
End Type

Private mTreeViewInfos() As TTreeViewInfo

#If LIVE Then
Private mo_Db As Object
Private mo_DbErr As Object
#Else
Private mo_Db As ArmDb
Private mo_DbErr As ArmDb
#End If

Private mb_Initialized As Boolean
Private ms_LoginName As String
Private ms_Language_Code As String

Dim current_displayed_node          As String

Const RIGHTS_UPD As String = "UPD"
Const RIGHTS_VIEW As String = "VIEW"


#If LIVE Then
Public Property Set Db(ByRef aDb As Object)
#Else
Public Property Set Db(ByRef aDb As ArmDb)
#End If
    Set mo_Db = aDb
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Public Property Let LoginName(ByVal aLoginName As String)
    ms_LoginName = aLoginName
End Property

Public Property Let Language_Code(ByVal aLanguage_Code As String)
    ms_Language_Code = aLanguage_Code
End Property

Private Sub InitCtrlSize()
On Error GoTo errHandler

    Const HSPACE As Long = 100
    Const VSPACE As Long = 100
    Call fra_filter.Move(HSPACE, VSPACE, 3015, UserControl.Height - (VSPACE * 2))
    tv_filter.Height = fra_filter.Height - tv_filter.top - VSPACE
    
    Call fra_item.Move(HSPACE, VSPACE, UserControl.Width - (HSPACE * 2), UserControl.Height - (VSPACE * 2))
    
    Dim lBuffer As Long
    lBuffer = tv_filter.left + fra_filter.Width + HSPACE
    Call fra_list.Move(lBuffer, VSPACE, UserControl.Width - lBuffer - HSPACE, UserControl.Height - (VSPACE * 2))
    grd_list.Height = fra_list.Height - grd_list.top - VSPACE
    grd_list.Width = fra_list.Width - grd_list.left - HSPACE
    
    Exit Sub

errHandler:
    Call ErrorHandler("InitCtrlSize")
End Sub


Private Sub ChangeSizeFraItemFraList()

On Error GoTo errHandler

    Const HSPACE As Long = 100
    Const VSPACE As Long = 100
    
    Dim lBuffer As Long
    
    lBuffer = tv_filter.left + fra_filter.Width + HSPACE
    Call fra_list.Move(lBuffer, VSPACE, UserControl.Width - lBuffer - HSPACE, UserControl.Height - 1575 - (VSPACE * 2))
    grd_list.Height = fra_list.Height - grd_list.top - VSPACE
    grd_list.Width = fra_list.Width - grd_list.left - HSPACE
    
    Call fra_item.Move(lBuffer, VSPACE + fra_list.Height, UserControl.Width - lBuffer - HSPACE, UserControl.Height - fra_list.Height - (VSPACE * 2))
        
    Exit Sub
    
errHandler:
    Call ErrorHandler("ChangeSizeFraItemFraList")
End Sub
Public Sub Load_A_COM()

On Error GoTo errHandler

    If mb_Initialized Then Exit Sub

    fra_filter.Visible = False
    fra_list.Visible = False
    fra_item.Visible = False
    
    Call InitCtrlSize
       
    'Treeview
    Set tv_filter.ArmDb = mo_Db
    tv_filter.Language = ms_Language_Code
    tv_filter.AllowCheckboxes = False
    tv_filter.UseImages = False
    tv_filter.Load_A_COM
    
    ' Initializing the view combo
    Set cbo_views.ArmDb = mo_Db
    Call cbo_views.Load_A_COM
    Call cbo_views.Clear
    cbo_views.FirstBlankItem = False
    cbo_views.Request = "exec TreeView_View_t_lst '" & SCREEN_NAME & "'," & "'" & ms_Language_Code & "'"
    cbo_views.Load
    If cbo_views.Count = 0 Then
        Debug.Print "No views"
        Exit Sub
    End If
    
    Dim lIdx As Long, lcount As Long
    lcount = cbo_views.Count - 1
    ReDim mTreeViewInfos(lcount)
    For lIdx = 0 To lcount
        mTreeViewInfos(lIdx).Loaded = False
        mTreeViewInfos(lIdx).TreeViewCode = cbo_views.ComboItems(lIdx + 1).Key
    Next
    cbo_views.SearchItem "X", "TV_Default", 0
    
    'Grid List
    Set grd_list.ArmDb = mo_Db
    grd_list.Load_A_COM
    grd_list.AllowExcelExport = False
    grd_list.ExportTitles = True
    grd_list.MultiSelect = True
    grd_list.UnBound = False
    grd_list.Font.Size = 8
    
    Dim lColumns As Variant
    ReDim lColumns(6)
    lColumns(0) = Join(Array("U_Code", 1300, 0, "U_Code", "#U_Code"), SEP)
    lColumns(1) = Join(Array("U_Name", 1600, 0, "U_Name", "#U_Name"), SEP)
    lColumns(2) = Join(Array("U_Dpt", 1400, 0, "U_Dpt", "#U_Dpt"), SEP)
    lColumns(3) = Join(Array("U_AuthCode", 1300, 0, "U_AuthCode", "#U_AuthCode"), SEP)
    lColumns(4) = Join(Array("U_AuthName", 1600, 0, "U_AuthName", "#U_AuthName"), SEP)
    lColumns(5) = Join(Array("U_AuthDpt", 1400, 0, "U_AuthDpt", "#U_AuthDpt"), SEP)
    lColumns(6) = Join(Array("U_Rights", 1000, 0, "U_Rights", "#U_Rights"), SEP)
    
    If Not grd_list.SetColumns(lColumns) Then
        Debug.Print "grd_list.SetColumns error"
        Call Unload_A_COM
        End
    End If
    
    'Temporary Grid
    Set grd_TmpList.ArmDb = mo_Db
    grd_TmpList.Load_A_COM
    grd_TmpList.AllowExcelExport = False
    grd_TmpList.ExportTitles = True
    grd_TmpList.MultiSelect = True
    grd_TmpList.UnBound = False
    grd_TmpList.Font.Size = 8
    
    ReDim lColumns(4)
    lColumns(0) = Join(Array("U_Code", 1300, 1, "U_Code", "#U_Code"), SEP)
    lColumns(1) = Join(Array("U_Name", 2100, 0, "U_Name", "#U_Name"), SEP)
    lColumns(2) = Join(Array("U_AuthCode", 1300, 1, "U_AuthCode", "#U_AuthCode"), SEP)
    lColumns(3) = Join(Array("U_AuthName", 2100, 0, "U_AuthName", "#U_AuthName"), SEP)
    lColumns(4) = Join(Array("U_Rights", 1000, 1, "U_Rights", "#U_Rights"), SEP)
    
    If Not grd_TmpList.SetColumns(lColumns) Then
        Debug.Print "grd_list.SetColumns error"
        Call Unload_A_COM
        End
    End If
    
    'U_Code Combobox
    Set cbo_ucode.ArmDb = mo_Db
    Call cbo_ucode.Load_A_COM
    cbo_ucode.FirstBlankItem = False
    cbo_ucode.Request = "SELECT GSU.U_Code, LTRIM(GP.P_Name) + ' ' + GP.P_First_Name " & _
                        "FROM dbo.GEN_Systems_Users GSU INNER JOIN dbo.GEN_People GP ON GSU.P_Code = GP.P_Code " & _
                        "ORDER BY LTRIM(GP.P_Name)"
    cbo_ucode.Visible = True
    
    'U_Authorized_Code Combobox
    Set cbo_uauthcode.ArmDb = mo_Db
    Call cbo_uauthcode.Load_A_COM
    cbo_uauthcode.FirstBlankItem = False
    cbo_uauthcode.Request = "SELECT GSU.U_Code, LTRIM(GP.P_Name) + ' ' + GP.P_First_Name " & _
                        "FROM dbo.GEN_Systems_Users GSU INNER JOIN dbo.GEN_People GP ON GSU.P_Code = GP.P_Code " & _
                        "ORDER BY LTRIM(GP.P_Name)"
    cbo_uauthcode.Visible = True
    
    'U_Rights Option
    opt_rights(0).Value = True
    
    
    btn_TVReLoad.Visible = False
    btn_TVReLoad.Picture = LoadResPicture(61, vbResIcon)

    btn_ListReload.Visible = False
    btn_ListReload.Picture = LoadResPicture(61, vbResIcon)
    
    fra_filter.Visible = True
    fra_list.Visible = True
    
    mb_Initialized = True

    
    Exit Sub
    
errHandler:
    Call ErrorHandler("Load_A_COM")
End Sub

Private Sub Item_AddToTmpList()

On Error GoTo errHandler

    If grd_TmpList.SearchKey(True, Array(CStr(cbo_ucode.SelectedItem.Key), CStr(cbo_uauthcode.SelectedItem.Key), IIf(opt_rights(0).Value, RIGHTS_VIEW, RIGHTS_UPD))) Then
        Debug.Print "Data already exists !"
        Exit Sub
    End If
    
    If Not grd_TmpList.AddLine(Array(CStr(cbo_ucode.SelectedItem.Key), cbo_ucode.SelectedItem.DisplayText, CStr(cbo_uauthcode.SelectedItem.Key), cbo_uauthcode.SelectedItem.DisplayText, IIf(opt_rights(0).Value, RIGHTS_VIEW, RIGHTS_UPD))) Then
        Debug.Print "unable to add a new line"
    End If
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("Item_AddToTmpList")
End Sub

Private Sub ClearFraItem()
    
On Error GoTo errHandler
    
    Set cbo_ucode.SelectedItem = Nothing
    Set cbo_uauthcode.SelectedItem = Nothing
    opt_rights(0).Value = True
    grd_TmpList.ClearGrid

    Exit Sub
    
errHandler:
    Call ErrorHandler("ClearFraItem")
End Sub

Private Sub btn_AddNew_Click()
On Error GoTo errHandler
    
    Call AddNew
    
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub

Private Sub AddNew()

On Error GoTo errHandler
    
    Call ClearFraItem
    Call Setup_FraItem(True)
    fra_item.Visible = True
    cbo_ucode.SetFocus
        
    Exit Sub
    
errHandler:
    Call ErrorHandler("AddNew")
End Sub


Private Sub Setup_FraItem(ByVal ab_Action As Boolean) 'True = Add , False = Update
    
On Error GoTo errHandler
    
    cbo_ucode.Enabled = ab_Action
    cbo_uauthcode.Enabled = ab_Action
    
    btn_AddToTmpGrid.Visible = ab_Action
    grd_TmpList.Visible = ab_Action
    btn_AddTmpListToDB.Visible = ab_Action
    btn_cancel.Visible = ab_Action
    btn_DelFromTmpList.Visible = ab_Action
    btn_Upd.Visible = Not ab_Action
    btn_cancelupd.Visible = Not ab_Action
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("Setup_FraItem")
End Sub
Private Sub AddTmpListToDB()

On Error GoTo errHandler

    Const DB_INS_REQUEST As String = "exec IVPO_Permis_Ins $u_code$, $u_authcode$, '$u_rights$'"
    
    Dim ls_req As String
    Dim lIdx As Long, lcount As Long
    
    lcount = grd_TmpList.Rows - 1
    If lcount < 0 Then Exit Sub
    
    For lIdx = 0 To lcount
        ls_req = Replace(DB_INS_REQUEST, "$u_code$", grd_TmpList.Data(lIdx, 0))
        ls_req = Replace(ls_req, "$u_authcode$", grd_TmpList.Data(lIdx, 2))
        ls_req = Replace(ls_req, "$u_rights$", grd_TmpList.Data(lIdx, 4))
        If Not mo_Db.ExecuteSQL(ls_req) Then
            If mo_Db.SQLErrorCodes(0) = 2627 Then
                MsgBox "The line with U_code = " & grd_TmpList.Data(lIdx, 0) & " and U_AuthCode = " & grd_TmpList.Data(lIdx, 2) & " cannot be inserted." & vbCrLf & "It is already in the table." & vbCrLf & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
            Else
                MsgBox "Enable to insert the line with U_code = " & grd_TmpList.Data(lIdx, 0) & " and U_AuthCode = " & grd_TmpList.Data(lIdx, 2) & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
            End If
        End If
    Next
    fra_item.Visible = False
    btn_TVReLoad.Visible = True
    btn_ListReload.Visible = True
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("AddTmpListToDB")
End Sub

Private Sub btn_AddTmpListToDB_Click()
On Error GoTo errHandler
    
    Call AddTmpListToDB
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub

Private Sub btn_AddToTmpGrid_Click()

On Error GoTo errHandler
    
    Call AddToTmpGrid
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub
Private Sub AddToTmpGrid()

On Error GoTo errHandler

    If cbo_ucode.Text = "" Then
        MsgBox "You must select a U_Code!", vbInformation, "Missing parameter"
        cbo_ucode.SetFocus
        Exit Sub
    End If
    
    If cbo_uauthcode.Text = "" Then
        MsgBox "You must select a U_Authorized_Code!", vbInformation, "Missing parameter"
        cbo_uauthcode.SetFocus
        Exit Sub
    End If
    Call Item_AddToTmpList
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("AddToTmpGrid")
End Sub


Private Sub btn_cancel_Click()
    Call CancelAddToDB
End Sub
Private Sub CancelAddToDB()
    fra_item.Visible = False
End Sub

Private Sub btn_cancelupd_Click()
    Call CancelUPD
End Sub

Private Sub CancelUPD()
    Call InitCtrlSize
    fra_item.Visible = False
    fra_list.Enabled = True
    fra_filter.Enabled = True
End Sub


Private Sub btn_DelFromDB_Click()
    Call DeleteFromDB
End Sub
Private Sub DeleteFromDB()
On Error GoTo errHandler
    Const DB_DEL_REQUEST As String = "exec IVPO_Permis_Del $u_code$, $u_authcode$"
    
    Dim ls_req As String
    Dim lIdx As Long, lcount As Long
    
    lcount = grd_list.SelectedCount - 1
    If lcount < 0 Then Exit Sub
    
    If MsgBox(MsgText(1010, ms_Language_Code, "#Attention, voulez vous vraiment supprimer toutes les donnes slectionnes ?"), vbYesNo) = vbYes Then
        Dim NbLineDel As Long
        NbLineDel = 0
        For lIdx = 0 To lcount
            ls_req = Replace(DB_DEL_REQUEST, "$u_code$", grd_list.SelectedLine(lIdx - NbLineDel, 0))
            ls_req = Replace(ls_req, "$u_authcode$", grd_list.SelectedLine(lIdx - NbLineDel, 3))
            If Not mo_Db.ExecuteSQL(ls_req) Then
                MsgBox "Enable to delete the line with U_code = " & grd_list.SelectedLine(lIdx - NbLineDel, 0) & " and U_AuthCode = " & grd_list.SelectedLine(lIdx - NbLineDel, 3) & vbCrLf & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
            Else
                grd_list.DeleteLine (grd_list.SelectedKey(lIdx))
                NbLineDel = NbLineDel + 1
            End If
        Next
        btn_TVReLoad.Visible = True
    End If
    grd_list.DeselectRow
    
    Exit Sub

errHandler:
    Call ErrorHandler("DeleteFromDB")
End Sub

Private Sub btn_DelFromTmpList_Click()

On Error GoTo errHandler

    Call DelFromTmpList
    
    Exit Sub
    
errHandler:
    Call MsgErrorHandler
End Sub


Private Sub btn_exit_Click()
    RaiseEvent Quit
End Sub

Private Sub btn_ListReload_Click()
    grd_list.Refresh
    btn_ListReload.Visible = False
End Sub

Private Sub btn_TVReLoad_Click()

On Error GoTo errHandler
    Call LoadTreeView(tv_filter, GetTreeViewInfo(mTreeViewInfos, SCREEN_NAME, cbo_views.SelectedItem.Key), grd_list)
    btn_TVReLoad.Visible = False
    btn_ListReload.Visible = False
    current_displayed_node = ""
    tv_filter.Visible = True

    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub

Private Sub btn_Upd_Click()

On Error GoTo errHandler
    
    Call Upd
    
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub

Private Sub btn_update_Click()
On Error GoTo errHandler:
    
    Call Update
    
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub
Private Sub Update()
On Error GoTo errHandler
    Dim lcount As Integer

    lcount = grd_list.SelectedCount - 1
    If lcount < 0 Then Exit Sub

    fra_filter.Enabled = False
    fra_list.Enabled = False
    Call ClearFraItem
    Call Setup_FraItem(False)
    Call ChangeSizeFraItemFraList
    
    
    cbo_ucode.Enabled = False
    cbo_uauthcode.Enabled = False
               
    cbo_ucode.Locked = False
    cbo_ucode.Text = grd_list.SelectedLine(0, 1)
    cbo_ucode.Locked = True
    
    cbo_uauthcode.Locked = False
    cbo_uauthcode.Text = grd_list.SelectedLine(0, 4)
    cbo_uauthcode.Locked = True
    
    fra_item.Visible = True
    
    If grd_list.SelectedLine(0, 6) = RIGHTS_VIEW Then
        opt_rights(0) = True
        opt_rights(0).SetFocus
    Else
        opt_rights(1) = True
        opt_rights(1).SetFocus
    End If
    
    Exit Sub

errHandler:
    Call ErrorHandler("Update")
End Sub

Private Sub Upd()

On Error GoTo errHandler
    
    Call UpdNowDB
    Call InitCtrlSize
    fra_item.Visible = False
    fra_list.Enabled = True
    fra_filter.Enabled = True

    Exit Sub

errHandler:
    Call ErrorHandler("Upd")
End Sub
Private Sub UpdNowDB()

On Error GoTo errHandler
    
    Const DB_UPD_REQUEST As String = "exec IVPO_Permis_upd $u_code$, $u_authcode$, '$u_rights$'"
    
    If IIf(opt_rights(0).Value, RIGHTS_VIEW, RIGHTS_UPD) = grd_list.SelectedLine(0, 6) Then Exit Sub
    
    Dim ls_req As String
    ls_req = Replace(DB_UPD_REQUEST, "$u_code$", grd_list.SelectedLine(0, 0))
    ls_req = Replace(ls_req, "$u_authcode$", grd_list.SelectedLine(0, 3))
    ls_req = Replace(ls_req, "$u_rights$", IIf(opt_rights(0).Value, RIGHTS_VIEW, RIGHTS_UPD))
    
    If Not mo_Db.ExecuteSQL(ls_req) Then
        MsgBox "Enable to update the line." & vbCrLf & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
        Exit Sub
    End If
    grd_list.SelectedLine(0, 6) = IIf(opt_rights(0).Value, RIGHTS_VIEW, RIGHTS_UPD)
    btn_TVReLoad.Visible = True

    Exit Sub

errHandler:
    Call ErrorHandler("UpdNowDB")
End Sub
Private Sub cbo_Views_ComboItemSelected()
On Error GoTo errHandler
    
    If Not cbo_views.SelectedItem Is Nothing Then
        Call LoadTreeView(tv_filter, GetTreeViewInfo(mTreeViewInfos, SCREEN_NAME, cbo_views.SelectedItem.Key), grd_list)
        btn_TVReLoad.Visible = False
        btn_ListReload.Visible = False
        current_displayed_node = ""
    End If
    
    Exit Sub

errHandler:
    Call MsgErrorHandler
End Sub

Public Sub Unload_A_COM()

On Error GoTo errHandler
    
    If Not mb_Initialized Then Exit Sub
    
    tv_filter.Unload_A_COM
    cbo_views.Unload_A_COM
    grd_list.Unload_A_COM
    
    cbo_ucode.Unload_A_COM
    cbo_uauthcode.Unload_A_COM
    grd_TmpList.Unload_A_COM
    
    mb_Initialized = False
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("Unload_A_COM")
End Sub

Private Function GetTreeViewInfo(ByRef aTVInfos() As TTreeViewInfo, ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo

On Error GoTo errHandler
    
    Dim lIdx As Long, lcount As Long
    Dim lTreeView As TTreeViewInfo, lFound As Boolean
    
    ' Search in the array
    lcount = UBound(aTVInfos)
    lFound = False
    For lIdx = 0 To lcount
        If aTVInfos(lIdx).TreeViewCode = aTVCode Then
            aTVInfos(lIdx).Loaded = False
            If Not aTVInfos(lIdx).Loaded Then
                aTVInfos(lIdx) = GetTreeViewInfoFromDB(AScreenName, aTVCode)
            End If
            lTreeView = aTVInfos(lIdx)
            lFound = True
            Exit For
        End If
    Next
    
    If Not lFound Then
        'ERROR
    End If
    
    GetTreeViewInfo = lTreeView
    
    Exit Function
    
errHandler:
    Call ErrorHandler("GetTreeViewInfo")
End Function

Private Function LoadTreeView(ByRef aTV As ArmTreeView, ByRef aTreeViewInfo As TTreeViewInfo, Optional ByRef aGrid As ArmGrid = Nothing) As Boolean

On Error GoTo errHandler
    
    aTV.Clear
    ' Clearing the associated grid
    If Not aGrid Is Nothing Then
        aGrid.Requests = ""
        Call aGrid.ClearGrid
    End If

    aTV.Levels = aTreeViewInfo.Levels
    aTV.StartDemandLevel = 1
    aTV.SelectedImages = aTreeViewInfo.SelectedImages
    aTV.Images = aTreeViewInfo.Images
    aTV.NodeRequests = aTreeViewInfo.NodeRequest
    aTV.GridRequests = aTreeViewInfo.GridRequest
    aTV.FindRequests = aTreeViewInfo.FindRequest
    aTV.CountRequests = aTreeViewInfo.CountRequest
    
    If Not aTV.LoadTree(LoadTypeChildsDemand) Then
        'ERROR
        LoadTreeView = False
    End If
    
    Exit Function
    
errHandler:
    Call ErrorHandler("LoadTreeView")
End Function

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

Private Function GetTreeViewInfoFromDB(ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo

On Error GoTo errHandler

    Dim lTreeView As TTreeViewInfo
    Dim lRequest As String
    Dim lCurs As Long, lIdx As Long, lcount As Long
        
    ' Get the data from the DB
    lRequest = "EXEC Treeview_Parameters_lst '" & AScreenName & "', '" & aTVCode & "'"
    lCurs = mo_Db.OpenSQL(lRequest)
    
    lcount = mo_Db.RowCount(lCurs) - 1
    
    If lcount = -1 Then
        Debug.Print "ERROR GetTreeViewInfoFromDB"
    End If
    
    ReDim lTreeView.NodeRequest(lcount)
    ReDim lTreeView.GridRequest(lcount)
    ReDim lTreeView.ExcelRequest(lcount)
    ReDim lTreeView.FindRequest(lcount)
    ReDim lTreeView.CountRequest(lcount)
    ReDim lTreeView.Images(lcount)
    ReDim lTreeView.SelectedImages(lcount)
    
    Dim lLevel As Long
    For lIdx = 0 To lcount
        lLevel = mo_Db.GetFields(lCurs, "TV_Level")
        lTreeView.NodeRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_NodeRequest")
        lTreeView.GridRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_GridRequest")
        lTreeView.ExcelRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_ExcelRequest")
        lTreeView.FindRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_FindRequest")
        lTreeView.CountRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_CountRequest")
        lTreeView.Images(lLevel) = mo_Db.GetFields(lCurs, "TV_Images")
        lTreeView.SelectedImages(lLevel) = mo_Db.GetFields(lCurs, "TV_SelectedImages")
        mo_Db.Next (lCurs)
    Next
    
    lTreeView.TreeViewCode = aTVCode
    lTreeView.Levels = lcount + 1
    lTreeView.Loaded = True
    GetTreeViewInfoFromDB = lTreeView
    
    mo_Db.Close (lCurs)
    
    Exit Function
    
errHandler:
    Call ErrorHandler("GetTreeViewInfoFromDB")
End Function

#If LIVE Then
Private Sub DeleteFromGrid(ao_grid As Object)
#Else
Private Sub DeleteFromGrid(ao_grid As ArmGrid)
#End If
    
On Error GoTo errHandler
    
    Dim lIdx As Long, lcount As Long
    lcount = ao_grid.SelectedCount - 1
    If lcount < 0 Then Exit Sub
    
    Dim lKeys As Variant
    lKeys = ao_grid.MultiSelectedKey
    For lIdx = 0 To lcount
        ao_grid.DeleteLine (lKeys(lIdx))
    Next
    ao_grid.DeselectRow
    
    Exit Sub
    
errHandler:
    Call ErrorHandler("DeleteFromGrid")
End Sub
Private Function MsgText(aID As Long, aLang As String, ByVal aDefault As String) As String

On Error GoTo errHandler

    Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID)
    lRequest = Replace(lRequest, "$lang$", aLang)
    
    Dim lData As Long
    lData = mo_Db.OpenSQL(lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    MsgText = lBuffer
    
    Exit Function
    
errHandler:
    Call ErrorHandler("MsgText")
End Function

Private Sub DelFromTmpList()

On Error GoTo errHandler

    If MsgBox(MsgText(1010, ms_Language_Code, "#Attention, voulez vous vraiment supprimer toutes les donnes slectionnes ?"), vbYesNo) = vbYes Then
        Call DeleteFromGrid(grd_TmpList)
    End If
    
    Exit Sub

errHandler:
    Call ErrorHandler("DelFromTmpList")
End Sub

Private Sub tv_filter_NodeClick(ByVal Node As MSComctlLib.Node)

On Error GoTo errHandler

    If Node Is Nothing Then Exit Sub
    
    If Node.FullPath = current_displayed_node Then Exit Sub

    Screen.MousePointer = vbHourglass
    
    btn_ListReload.Visible = False
    
    grd_list.Requests = ""
    Call grd_list.ClearGrid

    grd_list.Requests = tv_filter.SelectedNodeRequest
    
    If grd_list.Execute = False Then
        Debug.Print "PB Grid"
    End If

    current_displayed_node = tv_filter.SelectedItem.FullPath
    
    Screen.MousePointer = 0
    
    Exit Sub
    
errHandler:
    Call MsgErrorHandler
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, UserControl.Name & "." & UserControl.Ambient.DisplayName & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Private Sub MsgErrorHandler()
    Dim ls_Msg As String
    ' STEP 1 - Log info into database
    ' TODO
    ls_Msg = "Error n" & Err.Number & ", " & Err.Description & " occured into " & Err.Source
    Debug.Print ls_Msg & vbCrLf
    
    ' STEP 2 - Free ressources
    If Not mo_Db Is Nothing Then
        mo_Db.Disconnect
        Set mo_Db = Nothing
    End If
    
    ' STEP 3 - Display info for user
    ls_Msg = "The application couldn't start because of unexpected error, please contact IT"
    Call MsgBox(ls_Msg, vbCritical + vbOKOnly, App.ProductName)
    ' Exit from application
    End
End Sub

