VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.UserControl DailyChkMan 
   ClientHeight    =   11490
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   16140
   ScaleHeight     =   11490
   ScaleWidth      =   16140
   Begin Tools.ArmCombobox cbo_CharsetMain 
      Height          =   345
      Left            =   2400
      TabIndex        =   28
      Top             =   4470
      Width           =   3345
      _ExtentX        =   5900
      _ExtentY        =   609
   End
   Begin VB.CommandButton btnRefreshTask 
      Caption         =   "Refresh Task"
      Height          =   375
      Left            =   3840
      TabIndex        =   18
      Top             =   120
      Width           =   2295
   End
   Begin VB.Frame fraComment 
      Caption         =   "Support Comment"
      Height          =   2415
      Left            =   6960
      TabIndex        =   5
      Top             =   4680
      Visible         =   0   'False
      Width           =   2295
      Begin VB.CommandButton btnOk 
         Caption         =   "Ok"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   1920
         Width           =   975
      End
      Begin VB.CommandButton btnCancel 
         Caption         =   "Cancel"
         Height          =   375
         Left            =   1200
         TabIndex        =   7
         Top             =   1920
         Width           =   975
      End
      Begin VB.TextBox txtComment 
         Height          =   1575
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   6
         Top             =   240
         Width           =   2055
      End
   End
   Begin VB.CommandButton btnExecuteSel 
      Caption         =   "Execute Selected"
      Height          =   375
      Left            =   2280
      TabIndex        =   3
      Top             =   120
      Width           =   1935
   End
   Begin VB.CommandButton btnComment 
      Caption         =   "Comment"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7320
      TabIndex        =   2
      Top             =   4200
      Width           =   1935
   End
   Begin VB.TextBox txtExplanation 
      Height          =   1095
      Left            =   180
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   2970
      Width           =   9015
   End
   Begin VB.CommandButton btnExecute 
      Caption         =   "Execute All"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1935
   End
   Begin VB.CommandButton btnGraph 
      Caption         =   "Show Graph"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7320
      TabIndex        =   4
      Top             =   120
      Width           =   1935
   End
   Begin VB.CommandButton btnHistoricalData 
      Caption         =   "Historical data"
      Height          =   375
      Left            =   5160
      TabIndex        =   13
      Top             =   120
      Width           =   1935
   End
   Begin VB.Frame fraGraph 
      Caption         =   "Error Graph - last 60 days"
      Height          =   5175
      Left            =   8040
      TabIndex        =   9
      Top             =   5640
      Visible         =   0   'False
      Width           =   7215
      Begin VB.CommandButton btnClose 
         Caption         =   "Close"
         Height          =   375
         Left            =   6120
         TabIndex        =   11
         Top             =   4680
         Width           =   975
      End
      Begin MSChart20Lib.MSChart chrGraph1 
         Height          =   2175
         Left            =   120
         OleObjectBlob   =   "DailyChkMan.ctx":0000
         TabIndex        =   10
         Top             =   1320
         Width           =   6975
      End
   End
   Begin Tools.ArmGrid grdResult 
      Height          =   2415
      Left            =   240
      TabIndex        =   27
      Top             =   5040
      Width           =   6645
      _ExtentX        =   11721
      _ExtentY        =   4260
   End
   Begin VB.Frame fraHistory 
      Caption         =   "Historical Data"
      Height          =   6855
      Left            =   2880
      TabIndex        =   12
      Top             =   2400
      Visible         =   0   'False
      Width           =   13335
      Begin Tools.A_calocx calTill 
         Height          =   375
         Left            =   3480
         TabIndex        =   25
         Top             =   840
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   661
      End
      Begin Tools.A_calocx calSince 
         Height          =   345
         Left            =   1080
         TabIndex        =   24
         Top             =   840
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   609
      End
      Begin Tools.ArmCombobox cbo_CharsetHistory 
         Height          =   345
         Left            =   6030
         TabIndex        =   21
         Top             =   870
         Width           =   2805
         _ExtentX        =   4948
         _ExtentY        =   609
      End
      Begin VB.CommandButton btnHistoryClose 
         Caption         =   "Close"
         Height          =   375
         Left            =   5880
         TabIndex        =   17
         Top             =   5400
         Width           =   1815
      End
      Begin VB.CommandButton btnRefreshData 
         Caption         =   "Refresh  Data"
         Height          =   375
         Left            =   9120
         TabIndex        =   16
         Top             =   960
         Width           =   1815
      End
      Begin Tools.ArmGrid grdRequestHistory 
         Height          =   1095
         Left            =   240
         TabIndex        =   22
         Top             =   1560
         Width           =   7455
         _ExtentX        =   13150
         _ExtentY        =   1931
      End
      Begin Tools.ArmGrid grdResultHistory 
         Height          =   2415
         Left            =   240
         TabIndex        =   23
         Top             =   2880
         Width           =   7455
         _ExtentX        =   13150
         _ExtentY        =   4260
      End
      Begin Tools.ArmCombobox cboRequestDesc 
         Height          =   345
         Left            =   360
         TabIndex        =   26
         Top             =   360
         Width           =   7335
         _ExtentX        =   12938
         _ExtentY        =   609
      End
      Begin VB.Label Label2 
         Caption         =   "Charset"
         Height          =   255
         Left            =   5400
         TabIndex        =   20
         Top             =   960
         Width           =   735
      End
      Begin VB.Label lblTill 
         Caption         =   "Till"
         Height          =   255
         Left            =   3120
         TabIndex        =   15
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblSince 
         Caption         =   "Since"
         Height          =   255
         Left            =   360
         TabIndex        =   14
         Top             =   960
         Width           =   495
      End
   End
   Begin Tools.ArmGrid grdRequest 
      Height          =   2265
      Left            =   150
      TabIndex        =   29
      Top             =   600
      Width           =   9105
      _ExtentX        =   16060
      _ExtentY        =   3995
   End
   Begin VB.Label Label1 
      Caption         =   "Charset"
      Height          =   255
      Left            =   360
      TabIndex        =   19
      Top             =   4560
      Width           =   735
   End
End
Attribute VB_Name = "DailyChkMan"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

Option Explicit

Public Event Quit()

Private Type uHash
    'mb_Previous As Boolean
    mb_Ready As Boolean
    ml_Key As Long
    mc_Cursor As Long
    ml_ResultCount As Long
End Type

#If LIVE = 1 Then
Private mo_Db As Object         ' ArmSysCom Library object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb         ' ArmSysCom Library object
#End If

Private mao_RequestHash() As uHash
Private mao_RequestHistoryHash() As uHash
Private ml_UserCode As Long
Private ms_LoginName As String
Private ms_LanguageCode As String
Private mab_ControlsStatus() As Boolean
Private ml_Key_Of_Displayed_Log As Long
Private mb_Initialized As Boolean

Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SPACE As Long = 100           ' user control padding
Private Const GRID_SPACE As Long = 250      ' space between real width of ArmGrid and sum of cols

' resource bitmap local id
Private Const RES_CLOCK As Integer = 1
Private Const RES_CHECK As Integer = 2
Private Const RES_CROSS As Integer = 3
Private Const RES_ERROR As Integer = 4

Private Enum ArmErr
  SQLCnxFailure = vbObjectError + 1            ' Unable to connect to SQL source
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
  InvalidArgument = vbObjectError + 4          ' One argument has a wrong value. The argument and the condition broken are written into the description of the error
  PropertyNotSet = vbObjectError + 5           ' One property has not been set when load_a_com has been called, so the component cannot be initialized
  SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
  SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
  SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
  DrivingError = vbObjectError + 7
End Enum

' User code used in logs
Public Property Let U_Code(ByVal al_UserCode As Long)
    ml_UserCode = al_UserCode
End Property

' User code used in logs
Public Property Get U_Code() As Long
    U_Code = ml_UserCode
End Property


Public Property Let LoginName(ByVal as_LoginName As String)
    ms_LoginName = as_LoginName
End Property

' User code used in logs
Public Property Get LoginName() As String
    LoginName = ms_LoginName
End Property






' database controler property
#If LIVE = 1 Then
Public Property Set ArmDb(ByRef ao_Db As Object)
#Else
Public Property Set ArmDb(ByRef ao_Db As ARMSYSCOMLib.ArmDb)
#End If

On Error GoTo errHandler

    If Not mo_Db Is Nothing Then Err.Raise ArmErr.CPTAlreadyInitialized
    If ao_Db Is Nothing Then Err.Raise ArmErr.InvalidArgument
    
    Set mo_Db = ao_Db
    
    Exit Property
errHandler:
    Call ErrorHandler("ArmDb(Set)")
End Property

Public Property Get Language_Code() As String

    Language_Code = ms_LanguageCode
End Property

Public Property Let Language_Code(ByVal ls_NewValue As String)

    ms_LanguageCode = ls_NewValue
    calSince.Language = ls_NewValue
    calTill.Language = ls_NewValue
    

End Property
Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

' init user control
Public Sub Load_A_Com()

On Error GoTo errHandler

    If Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized
    If mo_Db Is Nothing Then Err.Raise ArmErr.PropertyNotSet, "", "mo_Db"
    If ms_LanguageCode = "" Then Err.Raise ArmErr.PropertyNotSet, "", "ms_Language_code"

    SafeRedim mao_RequestHash, 0
    SafeRedim mao_RequestHistoryHash, 0
    Debug.Assert (Not mo_Db Is Nothing)
    ' load request grid
    grdRequest.Load_A_Com
    Set grdRequest.ArmDb = mo_Db
    
    grdRequest.Title = "Task"
    grdRequest.MultiSelect = False
    
    ' setup columns
    grdRequest.SetColumns (Array( _
        Join(Array("dcr_code", 0, 1, "dcr_code", "code"), SEP), _
        Join(Array("dcr_request", 0, 0, "dcr_request", "dcr_request"), SEP), _
        Join(Array("dcr_explanation", 0, 0, "dcr_explanation", "dcr_explanation"), SEP), _
        Join(Array("status", 500, 0, "status", "", "BITMAP"), SEP), _
        Join(Array("dcr_desc", 6000, 0, "dcr_desc", "Description"), SEP), _
        Join(Array("LastRunOn", 1000, 0, "LastRunOn", "Last run on"), SEP)))
        'Join(Array("LastRunBy", 1000, 0, "LastRunBy", "Last run by"), SEP)))
    
    ' load result grid
    grdResult.Load_A_Com
    grdResult.Title = "Task's Result"
    Set grdResult.ArmDb = mo_Db
    ml_Key_Of_Displayed_Log = -1
    
    
    calSince.reinit_cal
    ' set since date to 5 days ago
    calSince.date_courte = Format(DateTime.DateAdd("d", -5, Now), "dd\/mm\/yyyy")
    
    calTill.reinit_cal
    ' set till date to today
    calTill.date_courte = Format(Date, "dd\/mm\/yyyy")
    
    Set grdRequestHistory.ArmDb = mo_Db
    grdRequestHistory.Load_A_Com
    grdRequestHistory.Title = "Task history"
    
    '"select dcl_code, dcr_status, dcl_date, u_code, dcl_type from daily_check_log"
    grdRequestHistory.SetColumns (Array( _
        Join(Array("dcl_code", 0, 1, "dcl_code", "code"), SEP), _
        Join(Array("status", 500, 0, "status", "", "BITMAP"), SEP), _
        Join(Array("dcl_date", 2000, 0, "dcl_date", "Date"), SEP), _
        Join(Array("u_login_name", 2000, 0, "u_login_name", "User Name"), SEP), _
        Join(Array("dcl_type", 700, 0, "dcl_type", "Type"), SEP), _
        Join(Array("Number_Errors", 2000, 0, "Number_Errors", "Number_Errors"), SEP)))

    
    Set grdResultHistory.ArmDb = mo_Db
    grdResultHistory.Load_A_Com
    Set cboRequestDesc.ArmDb = mo_Db
    cboRequestDesc.Load_A_Com
    cboRequestDesc.FirstBlankItem = False
    cboRequestDesc.Request = "SELECT dcr_code, dcr_desc FROM daily_check_request " & _
                    "WHERE dcr_enabled = 1 ORDER BY dcr_order ASC, dcr_desc"

    
    cboRequestDesc.Load
    
    
    FirstLoad
    
    grdResult.Font.Name = "Arial"
    cbo_CharsetMain.Load_A_Com
    Call cbo_CharsetMain.AddItem(Array(1, "Western Europe", 0, 1033), True)
    Call cbo_CharsetMain.AddItem(Array(2, "Eastern Europe", 238, 1045), False)
    Call cbo_CharsetMain.AddItem(Array(3, "Russian", 204, 1049), False)
    
    
    cbo_CharsetHistory.Load_A_Com
    Call cbo_CharsetHistory.AddItem(Array(1, "Western Europe", 0, 1033), True)
    Call cbo_CharsetHistory.AddItem(Array(2, "Eastern Europe", 238, 1045), False)
    Call cbo_CharsetHistory.AddItem(Array(3, "Russian", 204, 1049), False)
    
    
    grdRequest.AllowExcelExport = True
    grdRequestHistory.AllowExcelExport = True
    grdResult.AllowExcelExport = True
    grdResultHistory.AllowExcelExport = True
    
    mb_Initialized = True
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.Load_A_Com")
End Sub

' Allows the caller to know if the component has already been initialized
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

' load previous results
Private Sub FirstLoad()
On Error GoTo errHandler
    ' load task to result grid
    Const C_REQUEST As String = "SELECT  dcr.dcr_code, dcr.dcr_desc, dcr.dcr_explanation, dcr.dcr_request," & vbCrLf & _
                                "        status = CASE" & vbCrLf & _
                                "                WHEN dcr.dcr_status IS NULL THEN NULL" & vbCrLf & _
                                "                WHEN dcr.dcr_status = 0 THEN 'DCM-CHECK'" & vbCrLf & _
                                "                WHEN dcr.dcr_status = -1 THEN 'DCM-CLOCK'" & vbCrLf & _
                                "                WHEN dcr.dcr_status = -2 THEN 'DCM-ERROR'" & vbCrLf & _
                                "                WHEN dcr.dcr_status > 0 THEN 'DCM-CROSS'" & vbCrLf & _
                                "              END," & vbCrLf & _
                                "        Max (DCL.DCL_Date) 'LastRunOn', DCR.dcr_order" & vbCrLf & _
                                "    FROM daily_check_request dcr" & vbCrLf & _
                                "    LEFT OUTER JOIN Daily_Check_Log DCL ON DCL.DCR_Code = DCR.DCR_Code" & vbCrLf & _
                                "    Where dcr.dcr_enabled = 1" & vbCrLf & _
                                "    GROUP BY DCR.dcr_code, DCR.dcr_desc, dcr.dcr_explanation, dcr.dcr_request, dcr.dcr_status, DCR.dcr_order" & vbCrLf & _
                                "    ORDER BY dcr.dcr_order ASC, dcr_desc" & vbCrLf

    
    grdRequest.Load C_REQUEST, True


    SafeRedim mao_RequestHash, grdRequest.Rows
    ' update arrray for each task
    Dim ll_RowIdx As Long
    For ll_RowIdx = 0 To grdRequest.Rows - 1
        ' Retrieving request for task
        mao_RequestHash(ll_RowIdx).mb_Ready = False
        mao_RequestHash(ll_RowIdx).ml_Key = grdRequest.Data(ll_RowIdx, "dcr_code")
        'mao_RequestHash(ll_RowIdx).mb_Previous = True
    Next ll_RowIdx
        
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.FirstLoad")
End Sub

' Unloading variables, child controls
Public Sub Unload_A_Com()
On Error GoTo errHandler
    CloseAllCursors mao_RequestHash
    CloseAllCursors mao_RequestHistoryHash
    grdResult.Unload_A_Com
    grdRequest.Unload_A_Com
    grdResultHistory.Unload_A_Com
    grdRequestHistory.Unload_A_Com
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.Unload_A_Com")
End Sub

' Return cursor by key
Private Function FindObjectByKey(ByRef aao_PomHash() As uHash, ByVal al_Key As Long) As Long
On Error GoTo errHandler
    Dim ll_Idx As Long
    ' seach in array
    For ll_Idx = LBound(aao_PomHash) To UBound(aao_PomHash)
        ' and when key is matching then return array index
        If aao_PomHash(ll_Idx).ml_Key = al_Key Then
            FindObjectByKey = ll_Idx
            Exit Function
        End If
    Next ll_Idx
    FindObjectByKey = -1
    Exit Function
errHandler:
    Call ErrorHandler("DailyCheckMan.FindObjectByKey")
End Function

'close and mark cursor in hash array a not ready for display in result grid
Private Sub ReleaseLogCursor(ByRef aao_PomHash() As uHash, ByVal al_Index As Long)

On Error GoTo errHandler
    ' relase cursor
    If aao_PomHash(al_Index).mb_Ready Then
        mo_Db.Close aao_PomHash(al_Index).mc_Cursor
        aao_PomHash(al_Index).mb_Ready = False
    End If
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.ReleaseLogCursor")
End Sub

' retrieve log from database
Private Sub RetrieveLog(ByVal al_Index As Long)
On Error GoTo errHandler
    
        
    Call ReleaseLogCursor(mao_RequestHash, al_Index)
    ' get data from db
    
    mao_RequestHash(al_Index).mc_Cursor = OpenSQLSafe(mo_Db, _
        "SELECT dcld.dcd_code AS dcd_code, dcld.support_comment AS support_comment, dcld.dcd_record, " & _
              "dcl.dcl_columns AS dcl_columns " & _
        "FROM daily_check_log dcl " & _
        "INNER JOIN (SELECT MAX(dcl_date) AS dcl_date FROM daily_check_log WHERE dcr_code = " & mao_RequestHash(al_Index).ml_Key & ") AS tmp ON (dcl.dcl_date = tmp.dcl_date AND dcl.dcr_code = " & mao_RequestHash(al_Index).ml_Key & ")" & _
        "INNER JOIN daily_check_log_detail dcld ON dcld.dcl_code = dcl.dcl_code")
    
    mao_RequestHash(al_Index).mb_Ready = True
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.RetrieveLog")
End Sub

' retrieve history log from database
Private Sub RetrieveHistoryLog(ByVal al_Index As Long)
On Error GoTo errHandler
    
        
    Call ReleaseLogCursor(mao_RequestHistoryHash, al_Index)
    ' get data from db
    
    mao_RequestHistoryHash(al_Index).mc_Cursor = OpenSQLSafe(mo_Db, _
        "SELECT dcld.dcd_code AS dcd_code, ISNULL(gsu.u_login_name, dcld.u_code_comment) AS u_login_name, dcld.dcd_date_comment AS dcd_date_comment, dcld.support_comment AS support_comment, dcld.dcd_record, dcl.dcl_columns AS dcl_columns " & _
        "FROM daily_check_log dcl INNER JOIN daily_check_log_detail dcld ON dcld.dcl_code = dcl.dcl_code " & _
        "LEFT JOIN GEN_Systems_Users gsu ON gsu.u_code = dcld.u_code_comment " & _
        "WHERE dcl.dcl_code = " & mao_RequestHistoryHash(al_Index).ml_Key)
    
    mao_RequestHistoryHash(al_Index).mb_Ready = True
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.RetrieveHistoryLog")
End Sub


' cancel and hide comment frame
Private Sub btnCancel_Click()
    ' enable control's previous status
    EnableControls
    grdResult.Width = Width - SPACE * 2
    fraComment.Visible = False
End Sub

Private Sub btnClose_Click()
On Error GoTo errHandler

    'EnableControls
    fraGraph.Visible = False
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.BtnClose_Click")
End Sub

' show comment frame
Private Sub btnComment_Click()
On Error GoTo errHandler
    If grdResult.SelectedCount = 1 Then
      ' retrieve support comment and insert it to textbox
      txtComment.Text = grdResult.SelectedLine(0, "support_comment")
      ' disable controls
      DisableControls
      grdResult.Width = grdResult.Width - fraComment.Width - SPACE
      fraComment.Visible = True
    End If
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.btnComment_Click")
End Sub

Private Sub btnExecuteSel_Click()
On Error GoTo errHandler

    
    Screen.MousePointer = vbHourglass
    UserControl.Enabled = False
    btnExecuteSel.Caption = "Processing..."
    
    ' First execute or reexecute of selected task
    Dim lc_TempCursor As Long
    Dim ll_RowCount As Long
    Dim ll_RowIdx As Long
    ' Reexecute of selected task
    If Not grdRequest.Rows = 0 And grdRequest.SelectedCount = 1 Then
        
        Dim ll_Index As Integer
        ' find index of selected row
        ll_Index = FindObjectByKey(mao_RequestHash, (grdRequest.SelectedKey(0)(0)))
        
        ' execute request again
        
        ' setup "processing" bitmap icon
        SetStatus mao_RequestHash(ll_Index).ml_Key, RES_CLOCK
        
        Dim lb_ProcessNext As Long
        lb_ProcessNext = True

        ' execute and store cursor in array
        lc_TempCursor = mo_Db.OpenSQL(grdRequest.SelectedLine(0, "dcr_request"))
        
        grdRequest.SelectedLine(0, "LastRunOn") = Now
        grdRequest.SelectedLine(0, "LastRunBy") = ms_LoginName
        
        If lc_TempCursor <= 0 Then
            SetStatus mao_RequestHash(ll_Index).ml_Key, RES_ERROR
            lb_ProcessNext = False
        End If

        If lb_ProcessNext Then
        
            ' log result to database
            LogResult lc_TempCursor, mao_RequestHash(ll_Index).ml_Key, True
            
            ' set right bitmap icon depends on result (count of rows)
            ll_RowCount = mo_Db.RowCount(lc_TempCursor)
            mao_RequestHash(ll_RowIdx).ml_ResultCount = ll_RowCount
            'mao_RequestHash(ll_RowIdx).mb_Previous = False
            SetStatus mao_RequestHash(ll_Index).ml_Key, IIf(ll_RowCount = 0, RES_CHECK, RES_CROSS), ll_RowCount
            
            ' close cursor
            mo_Db.Close lc_TempCursor
            
            ' retrieve data from
            RetrieveLog ll_Index
            ml_Key_Of_Displayed_Log = mao_RequestHash(ll_Index).ml_Key
            ' and fill result grid with data
            Call FillResultGrid(mao_RequestHash(ll_Index).mc_Cursor, grdRequest.SelectedLine(0, "dcr_desc"))
        End If
    End If
    
    'btnExecuteSel.Enabled = True
    btnExecuteSel.Caption = "Execute Selected"
    UserControl.Enabled = True
    Screen.MousePointer = vbDefault
    
    Exit Sub
errHandler:
    If lc_TempCursor <> 0 Then mo_Db.Close lc_TempCursor
    btnExecuteSel.Caption = "Execute Selected"
    UserControl.Enabled = True
    Screen.MousePointer = vbDefault

    Call ErrorMessage("DailyCheckMan.btnExecuteSel_Click")
End Sub

Private Sub btnGraph_Click()
Dim lc_PomCursor As Long, ll_Row As Long, ll_Value As Long
Dim ll_Key As Long
Const NUM_OF_DAYS As Long = 90

 On Error GoTo errHandler
    
    
    If IsEmpty(grdRequest.SelectedKey(0)) Then Exit Sub
    
    'DisableControls
    
    fraGraph.Visible = True
    fraGraph.ZOrder
    
    chrGraph1.Move SPACE, SPACE * 3, fraGraph.Width - SPACE * 2, fraGraph.Height - SPACE * 5
    
    ll_Key = grdRequest.SelectedKey(0)(0)

    fraGraph.Caption = "Error Graph - last 60 days [" & grdRequest.SelectedLine(0, "DCR_Desc") & "]"

    ' retieve statistic from db (days ago, status)
    lc_PomCursor = OpenSQLSafe(mo_Db, _
        "SELECT DATEDIFF (day, dcl_date, GETDATE()) as days, MAX(dcl.dcr_status) AS dcr_status " & _
        "FROM daily_check_log dcl " & _
        "WHERE dcl.dcr_code = " & ll_Key & " AND DATEDIFF (day, dcl_date, GETDATE()) < " & NUM_OF_DAYS & " " & _
        "GROUP BY DATEDIFF (day, dcl_date, GETDATE())")

    ' init chart 1 (0 .. 59)
    chrGraph1.RandomFill = False
    chrGraph1.chartType = VtChChartType2dLine
    chrGraph1.ColumnCount = 1
    'chrGraph1.Plot.Axis(VtChAxisIdX).AxisGrid.MajorPen.VtColor.Set 160, 160, 160
    'chrGraph1.Plot.Axis(VtChAxisIdY).AxisGrid.MajorPen.VtColor.Set 160, 160, 160
    chrGraph1.Plot.Axis(VtChAxisIdY).AxisTitle = "No. of Errors"
    chrGraph1.RowCount = NUM_OF_DAYS
    
    For ll_Row = 0 To NUM_OF_DAYS - 1
      chrGraph1.Column = 1
      chrGraph1.RowLabel = CStr(Date - ll_Row)
      chrGraph1.Row = ll_Row + 1
      
      If mo_Db.Find(lc_PomCursor, "days", ll_Row) >= 0 Then
        ll_Value = mo_Db.GetFields(lc_PomCursor, "dcr_status")
        chrGraph1.Data = IIf(ll_Value >= 0, ll_Value, 0)
      Else
        chrGraph1.Data = 0
      End If
    Next
    
    mo_Db.Close lc_PomCursor
    Exit Sub
errHandler:
    If lc_PomCursor <> 0 Then mo_Db.Close lc_PomCursor
    Call ErrorMessage("DailyCheckMan.btnExecuteSel_Click")
End Sub

Private Sub btnHistoricalData_Click()
On Error GoTo errHandler
    'DisableControls
    ClearHistoryGrids
    If grdRequest.SelectedCount > 0 Then
      Call cboRequestDesc.SearchItem(grdRequest.SelectedLine(0, "DCR_Code"))
    End If
    fraHistory.Visible = True
    fraHistory.ZOrder

    Exit Sub
errHandler:
     Call ErrorMessage("DailyChkMan.btnHistoricalData_Click")
End Sub

Private Sub btnHistoryClose_Click()
On Error GoTo errHandler
    'EnableControls
    fraHistory.Visible = False
    Exit Sub
errHandler:
     Call ErrorMessage("DailyChkMan.btnHistoryClose_Click")
End Sub

' setup support comment
Private Sub btnOk_Click()
Dim ll_Idx As Long

On Error GoTo errHandler
    EnableControls
    grdResult.Width = Width - SPACE * 2
    fraComment.Visible = False
    ' store comment to grid
    grdResult.SelectedLine(0, "support_comment") = txtComment.Text
    ' and to database
    Call ExecuteSQLSafe(mo_Db, "UPDATE daily_check_log_detail SET u_code_comment = " & ml_UserCode & ", support_comment = '" & SqlStr(txtComment.Text) & "', dcd_date_comment = GETDATE() WHERE dcd_code = " & grdResult.SelectedLine(0, "dcd_code"), 1)
    ' now we must close cursor with result for this request because if reloaded comement seems to be lost
    ll_Idx = FindObjectByKey(mao_RequestHash, ml_Key_Of_Displayed_Log)
    If ll_Idx >= 0 Then Call ReleaseLogCursor(mao_RequestHash, ll_Idx)
    
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.BtnOk_Click")
End Sub

' clear history grids
Private Sub ClearHistoryGrids()
On Error GoTo errHandler
    
    grdRequestHistory.ClearGrid
    grdResultHistory.ResetGrid
    CloseAllCursors mao_RequestHistoryHash
    Exit Sub
errHandler:
     Call ErrorHandler("DailyChkMan.ClearHistoryGrids")
End Sub


Private Sub btnRefreshData_Click()
On Error GoTo errHandler
    If Not cboRequestDesc.SelectedItem Is Nothing Then
        
        Screen.MousePointer = vbHourglass
        UserControl.Enabled = False
        
        ' clear history grids
        ClearHistoryGrids
        Dim ls_SQL As String
        ls_SQL = "SELECT " & _
                    "status = CASE WHEN dcl.dcr_status IS NULL THEN NULL " & _
                    "WHEN dcl.dcr_status = 0 THEN 'DCM-CHECK' " & _
                    "WHEN dcl.dcr_status = -1 THEN 'DCM-CLOCK' " & _
                    "WHEN dcl.dcr_status = -2 THEN 'DCM-ERROR' " & _
                    "WHEN dcl.dcr_status > 0 THEN 'DCM-CROSS' END, " & _
                    "dcl.dcl_code, dcl.dcl_date, ISNULL(gsu.u_login_name, dcl.u_code) AS u_login_name, dcl.dcl_type, " & _
                        "(SELECT count(dcl1.dcl_code) " & _
                        "FROM daily_check_log dcl1 INNER JOIN daily_check_log_detail dcld ON dcld.dcl_code = dcl1.dcl_code " & _
                        "LEFT JOIN GEN_Systems_Users gsu ON gsu.u_code = dcld.u_code_comment " & _
                        "WHERE dcl1.dcl_code = dcl.dcl_code) 'Number_Errors' " & _
                    "FROM daily_check_log dcl " & _
                    "LEFT JOIN GEN_Systems_Users gsu ON gsu.u_code = dcl.u_code " & _
                    "WHERE dcl.dcr_code = " & cboRequestDesc.SelectedItem.Key & " AND " & _
                    "dcl.dcl_date >= " & SQLDateTime(calSince.date_dt) & " AND " & _
                    "dcl.dcl_date <= " & SQLDateTime(DateTime.DateAdd("d", "1", calTill.date_dt)) & _
                    " ORDER BY DCL.DCL_Date DESC"

        If Not grdRequestHistory.Load(ls_SQL, True) Then
            Err.Raise ArmErr.SQLFailure, Err.Source, "Loading data to history request grid failed"
        End If
    
        CloseAllCursors mao_RequestHistoryHash
        
        SafeRedim mao_RequestHistoryHash, grdRequestHistory.Rows
        
        Dim ll_RowIdx As Long, lc_TempCursor As Long ', ls_Request As String, ls_Explanation As String
        ' for each row update hash array
        For ll_RowIdx = 0 To grdRequestHistory.Rows - 1
            mao_RequestHistoryHash(ll_RowIdx).mb_Ready = False
            mao_RequestHistoryHash(ll_RowIdx).ml_Key = grdRequestHistory.Data(ll_RowIdx, "dcl_code")
        Next
        UserControl.Enabled = True
        Screen.MousePointer = vbDefault
    End If
    Exit Sub
errHandler:
    UserControl.Enabled = True
    Screen.MousePointer = vbDefault
     Call ErrorMessage("DailyChkMan.btnRefreshData_Click")
End Sub

Private Sub btnRefreshTask_Click()
    Call FirstLoad
End Sub

Private Sub calSince_datechangee()
    grdRequestHistory.ClearGrid
    grdResultHistory.ClearGrid
End Sub

Private Sub calTill_datechangee()
    grdRequestHistory.ClearGrid
    grdResultHistory.ClearGrid
End Sub

Private Sub cbo_CharsetHistory_ComboItemSelected()
    grdResultHistory.codepage = cbo_CharsetHistory.SelectedItem.GetData(2)
    grdResultHistory.LocalID = cbo_CharsetHistory.SelectedItem.GetData(3)
    grdResultHistory.Font.Charset = cbo_CharsetHistory.SelectedItem.GetData(2)

End Sub

Private Sub cbo_CharsetMain_ComboItemSelected()
    grdResult.codepage = cbo_CharsetMain.SelectedItem.GetData(2)
    grdResult.LocalID = cbo_CharsetMain.SelectedItem.GetData(3)
    grdResult.Font.Charset = cbo_CharsetMain.SelectedItem.GetData(2)
    
End Sub

Private Sub cboRequestDesc_ComboItemSelected()
On Error GoTo errHandler

    grdRequestHistory.ClearGrid
    grdResultHistory.ClearGrid
    
    Exit Sub
errHandler:
     Call ErrorMessage("DailyChkMan.cboRequestDesc_ComboItemSelected")

End Sub

' When double click in request grid then fill result grid
Private Sub grdRequest_ItemSelected()

On Error GoTo errHandler
   ' if exactly one is selected then fill grid with data
    If Not grdRequest.Rows = 0 And grdRequest.SelectedCount = 1 Then
        Dim ll_Idx As Long
        ll_Idx = FindObjectByKey(mao_RequestHash, (grdRequest.SelectedKey(0)(0)))
        
        Debug.Assert ll_Idx >= 0
        
        If Not mao_RequestHash(ll_Idx).mb_Ready Then
            RetrieveLog ll_Idx
        End If
        ml_Key_Of_Displayed_Log = mao_RequestHash(ll_Idx).ml_Key
        Call FillResultGrid(mao_RequestHash(ll_Idx).mc_Cursor, grdRequest.SelectedLine(0, "dcr_desc"))
    End If
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.DblClick")
End Sub

' When selection change in request grid then fill result grid
'Private Sub grdRequest_SelChange()
   Private Sub grdRequest_Click()
   ' if exactly one is selected then fill grid with data
   If Not grdRequest.Rows = 0 And grdRequest.SelectedCount = 1 Then
        ' update explanation text box
        txtExplanation.Text = grdRequest.SelectedLine(0, "dcr_explanation")
        btnGraph.Enabled = True
    Else
        txtExplanation.Text = ""
        btnGraph.Enabled = False
    End If
    grdResult.ResetGrid
    
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.SelChange")
End Sub

' Set bitmap status
Private Sub SetStatus(ByVal al_Key As Long, ai_Type As Integer, Optional ByVal al_ResultCount As Long = 0)
On Error GoTo errHandler
    Dim ll_Idx As Long
    For ll_Idx = 0 To grdRequest.Rows - 1
        If grdRequest.Data(ll_Idx, "dcr_code") = al_Key Then
            grdRequest.Data(ll_Idx, "status") = Choose(ai_Type, "DCM-CLOCK", "DCM-CHECK", "DCM-CROSS", "DCM-ERROR")
            DoEvents
            Call ExecuteSQLSafe(mo_Db, "update daily_check_request set dcr_status = " & Choose(ai_Type, -1, 0, al_ResultCount, -2) & " where dcr_code = " & al_Key, 1)
            Exit Sub
        End If
    Next ll_Idx
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.SetStatus")
End Sub

Private Sub btnExecute_Click()
On Error GoTo errHandler
    
    
    Screen.MousePointer = vbHourglass
    UserControl.Enabled = False
    
    
    btnExecute.Caption = "Processing..."
    
    grdResult.ResetGrid
    'grdResult.Title = "Task's Result"

    ' we're adding data manuly
    grdResult.UnBound = True
        
    ' First execute
    'Dim lc_TempCursor As Long
    ' Fill datagrid with name of task and SQL request
    'grdRequest.Load "SELECT dcr_code AS dcr_code, dcr_desc as dcr_desc, dcr_explanation AS dcr_explanation, dcr_request AS dcr_request FROM daily_check_request WHERE dcr_enabled = 1 ORDER BY dcr_order ASC", True
    Call ExecuteSQLSafe(mo_Db, "UPDATE daily_check_request SET dcr_status = -1 WHERE dcr_enabled = 1")
    
    CloseAllCursors mao_RequestHash
    If grdRequest.Rows = 0 Then
        btnExecute.Caption = "Execute All"
        Exit Sub
    End If
    
    SafeRedim mao_RequestHash, grdRequest.Rows
    ' Execute each task
    Dim ll_RowIdx As Long, lc_TempCursor As Long ', ls_Request As String, ls_Explanation As String
    For ll_RowIdx = 0 To grdRequest.Rows - 1
        ' Retrieving request for task
        mao_RequestHash(ll_RowIdx).mb_Ready = False
        mao_RequestHash(ll_RowIdx).ml_Key = grdRequest.Data(ll_RowIdx, "dcr_code")
        'mao_RequestHash(ll_RowIdx).mb_Previous = False
        ' Executing request and store cursor in global array
        SetStatus mao_RequestHash(ll_RowIdx).ml_Key, RES_CLOCK
        
        Dim ll_RowCount As Long
        
        Dim lb_ProcessNext As Long
        lb_ProcessNext = True
        lc_TempCursor = mo_Db.OpenSQL(grdRequest.Data(ll_RowIdx, "dcr_request"))
        grdRequest.Data(ll_RowIdx, "LastRunOn") = Now
        grdRequest.Data(ll_RowIdx, "LastRunBy") = ms_LoginName

        If lc_TempCursor = 0 Then
            SetStatus mao_RequestHash(ll_RowIdx).ml_Key, RES_ERROR
            lb_ProcessNext = False
        End If

        If lb_ProcessNext Then
            ' get result row count
            ll_RowCount = mo_Db.RowCount(lc_TempCursor)
            mao_RequestHash(ll_RowIdx).ml_ResultCount = ll_RowCount
            
            ' log result data and execution status
            LogResult lc_TempCursor, mao_RequestHash(ll_RowIdx).ml_Key, False
            mo_Db.Close lc_TempCursor
            lc_TempCursor = 0
            ' set right bitmap pic
            SetStatus mao_RequestHash(ll_RowIdx).ml_Key, IIf(ll_RowCount = 0, RES_CHECK, RES_CROSS), ll_RowCount
        End If
        DoEvents
    Next
    btnExecute.Caption = "Execute All"
    
    Screen.MousePointer = vbDefault
    UserControl.Enabled = True
    Call MsgBox("Execution finished.")
    
    Exit Sub
errHandler:
    If lc_TempCursor <> 0 Then mo_Db.Close lc_TempCursor
    Screen.MousePointer = vbDefault
    UserControl.Enabled = True

    Call ErrorMessage("DailyCheckMan.btnExecute_Click")
End Sub


Private Function LogResult(ByVal ac_Cursor As Long, ByVal al_Key As Long, ByVal ab_ReExecution) As Boolean
On Error GoTo errHandler
    
    Dim ll_RowCount As Long, ll_ColCount As Long
    ll_RowCount = mo_Db.RowCount(ac_Cursor)
    ll_ColCount = mo_Db.FieldCount(ac_Cursor)
    
    ' retrieve new id
    Dim ls_ID As String
    ls_ID = mo_Db.SQLNextID("DCM_LOG")
    If ls_ID = "" Then
        Err.Raise vbObjectError + 514, Err.Source, "SQLNextID failed for DCM_LOG"
    End If

    
    Dim ll_Idx As Long, ll_Idx2 As Long
    Dim ls_TempBuffer As String
    
    ls_TempBuffer = ""

    For ll_Idx = 0 To ll_ColCount - 1
        ls_TempBuffer = ls_TempBuffer & IIf(ll_Idx = 0, "", SEP) & mo_Db.GetFieldName(ac_Cursor, ll_Idx)
    Next ll_Idx
    
    ' log result
    Call ExecuteSQLSafe(mo_Db, "INSERT INTO daily_check_log (dcl_code, u_code, dcl_date, dcr_code, dcr_status, dcl_type, dcl_columns)" & _
                     "VALUES (" & ls_ID & "," & ml_UserCode & ",getdate()," & al_Key & "," & ll_RowCount & ",'" & IIf(ab_ReExecution, "R", "B") & "', '" & SqlStr(ls_TempBuffer) & "')", 1)
    
    
    'get all rows from result cursor and write it to log_detail
    For ll_Idx2 = 0 To ll_RowCount - 1
        ls_TempBuffer = ""
        For ll_Idx = 0 To ll_ColCount - 1
            ls_TempBuffer = ls_TempBuffer & IIf(ll_Idx = 0, "", SEP) & mo_Db.GetFieldsAt(ac_Cursor, ll_Idx2, ll_Idx)
        Next ll_Idx
        
        
        ' retrieve new id
        Dim ls_IDDetail As String
        ls_IDDetail = mo_Db.SQLNextID("DCM_LOG_DETAIL")
        If ls_IDDetail = "" Then
            Err.Raise vbObjectError + 514, Err.Source, "SQLNextID failed for DCM_LOG_DETAIL"
        End If

        ' insert row
        Call ExecuteSQLSafe(mo_Db, "INSERT INTO daily_check_log_detail (dcd_code, dcl_code, u_code_comment, support_comment, dcd_date_comment, dcd_record)" & _
            "VALUES (" & ls_IDDetail & ", " & ls_ID & ", NULL, NULL, NULL, '" & SqlStr(ls_TempBuffer) & "')", 1)
    Next ll_Idx2
    Exit Function
errHandler:
    Call ErrorHandler("DailyCheckMan.LogResult")
End Function

' Fill grid with data from result of request sql
Private Function FillResultGrid(ByVal ac_Cursor As Long, ByVal as_Title As String) As Boolean
Dim las_Columns() As String

On Error GoTo errHandler
    FillResultGrid = True
    
    btnComment.Enabled = False
    grdResult.ResetGrid
    grdResult.Title = as_Title

    ' we're adding data manuly
    grdResult.UnBound = True
    Dim ll_RowCount As Long, ll_ColCount As Long, lColWidth
    ll_RowCount = mo_Db.RowCount(ac_Cursor)
    
    ' if we don't have any data then keep result grid clear
    If ll_RowCount = 0 Then
        FillResultGrid = False
        Exit Function
    End If
    
    Dim las_Data() As String, las_Fields() As String
    
    ' get data from record column and split them
    las_Data = Split(mo_Db.GetFieldsAt(ac_Cursor, 0, "dcd_record"), SEP, -1, vbTextCompare)
    
    ' get data from columns column and split them
    las_Columns = Split(mo_Db.GetFieldsAt(ac_Cursor, 0, "dcl_columns"), SEP, -1, vbTextCompare)
    
    ll_ColCount = UBound(las_Data) + 3
    
    
    ' count column width from column count and width of result grid, min 500
    lColWidth = IIf((grdResult.Width - GRID_SPACE) / (ll_ColCount - 1) < 500, 500, (grdResult.Width - GRID_SPACE) / (ll_ColCount - 1))
    ReDim lao_Columns(ll_ColCount - 1)
    
    lao_Columns(0) = Join(Array("dcd_code", 0, 1, "dcd_code", "code"), SEP)
    lao_Columns(1) = Join(Array("support_comment", lColWidth, 0, "support_comment", "Support Comment"), SEP)

    Dim ll_Idx As Long, ll_Idx2 As Long
    Dim lao_Field(5) As Variant
    
    ' setup columns
    For ll_Idx = 2 To ll_ColCount - 1
        lao_Field(0) = las_Columns(ll_Idx - 2)
        lao_Field(1) = lColWidth
        lao_Field(2) = 0
        lao_Field(3) = las_Columns(ll_Idx - 2)
        lao_Field(4) = las_Columns(ll_Idx - 2)
        lao_Field(5) = "String"
        lao_Columns(ll_Idx) = Join(lao_Field, SEP)
    Next ll_Idx
    
    ' set columns in result grid
    grdResult.SetColumns (lao_Columns)
    
    ' retrieve data from cursor and add to result grid
    
    grdResult.Rows = ll_RowCount
    For ll_Idx = 0 To ll_RowCount - 1
        las_Data = Split(mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "dcd_record"), SEP, -1, vbTextCompare)
    
        grdResult.Data(ll_Idx, "dcd_code") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "dcd_code")
        grdResult.Data(ll_Idx, "support_comment") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "support_comment")
        
        For ll_Idx2 = LBound(las_Data) To UBound(las_Data)
            grdResult.Data(ll_Idx, ll_Idx2 + 2) = las_Data(ll_Idx2)
        Next ll_Idx2
    Next ll_Idx

    Exit Function
errHandler:
    btnComment.Enabled = True
    Call ErrorHandler("DailyCheckMan.FillResultGrid")
End Function

' Fill history result grid with history log detail's data
Private Function FillHistoryResultGrid(ByVal ac_Cursor As Long) As Boolean
Dim las_Columns() As String

On Error GoTo errHandler
    FillHistoryResultGrid = False
    
    grdResultHistory.ResetGrid
    grdResultHistory.Title = "Task history's Result"

    ' we're adding data manuly
    grdResultHistory.UnBound = True
    Dim ll_RowCount As Long, ll_ColCount As Long, lColWidth
    ll_RowCount = mo_Db.RowCount(ac_Cursor)
    
    ' if we don't have any data then keep result grid clear
    If ll_RowCount = 0 Then
        Exit Function
    End If
    
    Dim las_Data() As String, las_Fields() As String
    
    ' get data from record column and split them
    las_Data = Split(mo_Db.GetFieldsAt(ac_Cursor, 0, "dcd_record"), SEP, -1, vbTextCompare)
    
    ' get data from columns column and split them
    las_Columns = Split(mo_Db.GetFieldsAt(ac_Cursor, 0, "dcl_columns"), SEP, -1, vbTextCompare)
    
    ll_ColCount = UBound(las_Data) + 4
    
    
    ' count column width from column count and width of result grid, min 500
    lColWidth = IIf((grdResult.Width - GRID_SPACE) / (ll_ColCount - 1) < 500, 500, (grdResultHistory.Width - GRID_SPACE) / (ll_ColCount - 1))
    ReDim lao_Columns(ll_ColCount - 1)
    
    lao_Columns(0) = Join(Array("dcd_code", 0, 1, "dcd_code", "code"), SEP)
    lao_Columns(1) = Join(Array("u_login_name", 1000, 0, "u_login_name", "Support User"), SEP)
    lao_Columns(2) = Join(Array("dcd_date_comment", 1700, 0, "dcd_date_comment", "Support Date"), SEP)
    lao_Columns(3) = Join(Array("support_comment", 2000, 0, "support_comment", "Support Comment"), SEP)

    Dim ll_Idx As Long, ll_Idx2 As Long
    Dim lao_Field(5) As Variant
    
    ' setup columns
    For ll_Idx = 4 To ll_ColCount - 1
        lao_Field(0) = las_Columns(ll_Idx - 4)
        lao_Field(1) = lColWidth
        lao_Field(2) = 0
        lao_Field(3) = las_Columns(ll_Idx - 4)
        lao_Field(4) = las_Columns(ll_Idx - 4)
        lao_Field(5) = "String"
        lao_Columns(ll_Idx) = Join(lao_Field, SEP)
    Next ll_Idx
    
    ' set columns in result grid
    grdResultHistory.SetColumns (lao_Columns)
    
    ' retrieve data from cursor and add to result grid
    
    grdResultHistory.Rows = ll_RowCount
    For ll_Idx = 0 To ll_RowCount - 1
        las_Data = Split(mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "dcd_record"), SEP, -1, vbTextCompare)
    
        grdResultHistory.Data(ll_Idx, "dcd_code") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "dcd_code")
        grdResultHistory.Data(ll_Idx, "u_login_name") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "u_login_name")
        grdResultHistory.Data(ll_Idx, "dcd_date_comment") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "dcd_date_comment")
        grdResultHistory.Data(ll_Idx, "support_comment") = mo_Db.GetFieldsAt(ac_Cursor, ll_Idx, "support_comment")
        
        For ll_Idx2 = LBound(las_Data) To UBound(las_Data)
            grdResultHistory.Data(ll_Idx, ll_Idx2 + 4) = las_Data(ll_Idx2)
        Next ll_Idx2
    Next ll_Idx
    
    FillHistoryResultGrid = True

    Exit Function
errHandler:
    Call ErrorHandler("DailyCheckMan.FillHistoryResultGrid")
End Function


Private Sub grdRequestHistory_Click()
    grdResultHistory.ClearGrid
End Sub

'when item selected (double click) fill history result grid with data
Private Sub grdRequestHistory_ItemSelected()
   ' if exactly one is selected then fill grid with data
    If Not grdRequestHistory.Rows = 0 And grdRequestHistory.SelectedCount = 1 Then
        Dim ll_Idx As Long
        ll_Idx = FindObjectByKey(mao_RequestHistoryHash, (grdRequestHistory.SelectedKey(0)(0)))
        
        Debug.Assert ll_Idx >= 0
        
        If Not mao_RequestHistoryHash(ll_Idx).mb_Ready Then
            RetrieveHistoryLog ll_Idx
        End If
        Call FillHistoryResultGrid(mao_RequestHistoryHash(ll_Idx).mc_Cursor)
    End If
    Exit Sub

End Sub

Private Sub grdResult_SelChange()
On Error GoTo errHandler
    ' if exactly one is selected then enable comment button
   If Not grdResult.Rows = 0 And grdResult.SelectedCount = 1 Then
        btnComment.Enabled = True
    Else
        btnComment.Enabled = False
    End If
    Exit Sub
errHandler:
    Call ErrorMessage("DailyCheckMan.SelChange")
End Sub


' Auto resize of child controls to client area
Public Sub Resize()
On Error GoTo errHandler
    Dim li_PomSize1 As Integer, li_PomSize3 As Integer, li_PomSize4 As Integer
    li_PomSize1 = (Width - SPACE * 3) / 4
    li_PomSize4 = (Height - SPACE * 6 - btnExecute.Height - btnComment.Height) / 6
    
    ' buttons
    btnExecute.Move SPACE, SPACE
    btnExecuteSel.Move SPACE * 2 + btnExecute.Left + btnExecute.Width, SPACE
    btnRefreshTask.Move SPACE * 2 + btnExecuteSel.Width + btnExecuteSel.Left, SPACE
    
    
    btnHistoricalData.Move Width - SPACE - btnHistoricalData.Width, SPACE
    btnGraph.Move btnHistoricalData.Left - SPACE * 2 - btnGraph.Width, SPACE
    btnComment.Move Width - SPACE - btnComment.Width, SPACE * 4 + btnExecute.Height + li_PomSize4 * 3
    
    ' graph frame
    fraGraph.Move SPACE, SPACE, Width - SPACE * 2, Height - SPACE * 2
    chrGraph1.Move SPACE, SPACE * 3, fraGraph.Width - SPACE * 2, fraGraph.Height - SPACE * 5
    btnClose.Move fraGraph.Width - btnClose.Width - SPACE, fraGraph.Height - btnClose.Height - SPACE
    
    ' history data frame
    fraHistory.Move SPACE, SPACE, Width - SPACE * 2, Height - SPACE * 2
    cboRequestDesc.Move SPACE, SPACE * 3, fraHistory.Width - SPACE * 2
    lblSince.Move SPACE, SPACE * 4 + cboRequestDesc.Height + (calSince.Height - lblSince.Height) / 2
    calSince.Move SPACE * 2 + lblSince.Width, SPACE * 4 + cboRequestDesc.Height
    lblTill.Move SPACE * 3 + lblSince.Width + calSince.Width, SPACE * 4 + cboRequestDesc.Height + (calTill.Height - lblTill.Height) / 2
    calTill.Move SPACE * 4 + lblSince.Width + calSince.Width + lblTill.Width, SPACE * 4 + cboRequestDesc.Height
    
    label2.Top = lblTill.Top
    cbo_CharsetHistory.Top = calSince.Top
    
    btnRefreshData.Move fraHistory.Width - SPACE - btnRefreshData.Width, SPACE * 4 + cboRequestDesc.Height
    li_PomSize3 = (fraHistory.Height - SPACE * 8 - cboRequestDesc.Height - calTill.Height - btnHistoryClose.Height) / 8
    
    grdRequestHistory.Move SPACE, SPACE * 5 + cboRequestDesc.Height + calTill.Height, fraHistory.Width - SPACE * 2, li_PomSize3 * 3
    
    grdResultHistory.Move SPACE, SPACE * 6 + cboRequestDesc.Height + calTill.Height + li_PomSize3 * 3, fraHistory.Width - SPACE * 2, li_PomSize3 * 5
    btnHistoryClose.Move fraHistory.Width - SPACE - btnHistoryClose.Width, fraHistory.Height - SPACE - btnHistoryClose.Height
    
    ' support comment frame
    fraComment.Move SPACE * 2 + li_PomSize1 * 3, SPACE * 5 + btnExecute.Height + btnComment.Height + li_PomSize4 * 3, li_PomSize1, li_PomSize4 * 3
    txtComment.Move SPACE, SPACE * 3, fraComment.Width - 2 * SPACE, fraComment.Height - 5 * SPACE - btnOk.Height
    btnOk.Move SPACE, fraComment.Height - 1 * SPACE - btnOk.Height, (fraComment.Width - 3 * SPACE) / 2
    btnCancel.Move SPACE * 2 + btnOk.Width, fraComment.Height - 1 * SPACE - btnOk.Height, (fraComment.Width - 3 * SPACE) / 2
    
    ' resize request grid
    grdRequest.Move SPACE, SPACE * 2 + btnExecute.Height, Width - SPACE * 2, li_PomSize4 * 2
    ' resize explanation text box
    txtExplanation.Move SPACE, SPACE * 3 + btnExecute.Height + li_PomSize4 * 2, Width - SPACE * 2, li_PomSize4
    ' resize result grid
    grdResult.Move SPACE, SPACE * 5 + btnExecute.Height + btnComment.Height + li_PomSize4 * 3, Width - SPACE * 2 - IIf(fraComment.Visible, li_PomSize1 + SPACE, 0), li_PomSize4 * 3
    label1.Move grdResult.Left, grdResult.Top - label1.Height - SPACE
    cbo_CharsetMain.Move label1.Left + label1.Width + SPACE, grdResult.Top - cbo_CharsetMain.Height - SPACE
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.Resize")
End Sub

' Store enable status and disable for each control
Private Sub DisableControls()
    ReDim mab_ControlsStatus(7) As Boolean
   
    mab_ControlsStatus(0) = btnExecute.Enabled
    mab_ControlsStatus(1) = btnExecuteSel.Enabled
    mab_ControlsStatus(2) = btnGraph.Enabled
    mab_ControlsStatus(3) = btnComment.Enabled
    mab_ControlsStatus(4) = grdRequest.Enabled
    mab_ControlsStatus(5) = grdResult.Enabled
    mab_ControlsStatus(6) = txtExplanation.Enabled
    mab_ControlsStatus(7) = btnHistoricalData.Enabled
    
    btnExecute.Enabled = False
    btnExecuteSel.Enabled = False
    btnGraph.Enabled = False
    btnComment.Enabled = False
    grdRequest.Enabled = False
    grdResult.Enabled = False
    txtExplanation.Enabled = False
    btnHistoricalData.Enabled = False
End Sub

' reset controls enable status
Private Sub EnableControls()
    btnExecute.Enabled = mab_ControlsStatus(0)
    btnExecuteSel.Enabled = mab_ControlsStatus(1)
    btnGraph.Enabled = mab_ControlsStatus(2)
    btnComment.Enabled = mab_ControlsStatus(3)
    grdRequest.Enabled = mab_ControlsStatus(4)
    grdResult.Enabled = mab_ControlsStatus(5)
    txtExplanation.Enabled = mab_ControlsStatus(6)
    btnHistoricalData.Enabled = mab_ControlsStatus(7)
End Sub


' close all open cursors
Private Sub CloseAllCursors(ByRef aao_PomHash() As uHash)
On Error GoTo errHandler
    Dim ll_Idx As Long
    ' for each cursor in array
    For ll_Idx = LBound(aao_PomHash) To UBound(aao_PomHash)
        ' close it
        Call ReleaseLogCursor(aao_PomHash, ll_Idx)
    Next ll_Idx
    Exit Sub
errHandler:
    Call ErrorHandler("DailyCheckMan.CloseAllCursors")
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    'MsgBox "Error no. " & Err.Number & ": " & as_Fct & " - " & Err.Description, , Err.Source
    Err.Raise Err.Number, as_Fct & SEP1 & Err.Source, Err.Description, Err.HelpFile, Err.HelpContext
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Call MsgBox(Err.Description & " - " & as_Fct & SEP1 & Err.Source, , "Daily Check Manager")
End Sub

' tranlate date to sql format
Private Function SQLDateTime(ad_Date As Date) As String
On Error GoTo errHandler
  If ad_Date = 0 Then
    SQLDateTime = "Null"
  Else
    SQLDateTime = "{ ts '" & Format(ad_Date, "yyyy-mm-dd hh:mm:ss") & "'}"
  End If

    Exit Function
errHandler:
     Call ErrorHandler("DailyChkMan.SQLDateTime")
End Function

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal mo_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal mo_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo errHandler

    Dim lc_Data As Long
    lc_Data = mo_Db.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(mo_Db.SQLErrorCodes, SEP2) & SEP1 & Join(mo_Db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If mo_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & mo_Db.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

errHandler:
    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal mo_Db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal mo_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo errHandler

    ' First execute the request
    If Not mo_Db.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(mo_Db.SQLErrorCodes, SEP2) & SEP1 & Join(mo_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If mo_Db.SQLRowsAffected <> al_RowAffectedCount Then
            Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & mo_Db.SQLRowsAffected
        End If
    End If

    Exit Sub

errHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function SqlStr(ByVal as_Str As String) As String
    SqlStr = Replace(as_Str, "'", "''")
End Function


Private Sub SafeRedim(ByRef aav_Array() As uHash, ByVal al_Size As Long)
On Error GoTo errHandler
    If al_Size = 0 Then
      ReDim aav_Array(-1 To -1)
    Else
      ReDim aav_Array(al_Size - 1)
    End If
    Exit Sub
errHandler:
     Call ErrorHandler("DailyChkMan.SafeRedim")
End Sub


