VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "ComDlg32.OCX"
Begin VB.UserControl SPATemplateManager 
   ClientHeight    =   7395
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   11175
   ScaleHeight     =   7395
   ScaleWidth      =   11175
   Begin VB.Frame fra_Detail 
      Height          =   5640
      Left            =   240
      TabIndex        =   0
      Top             =   2280
      Width           =   9495
      Begin VB.Frame fra_Item 
         Height          =   5295
         Left            =   75
         TabIndex        =   10
         Top             =   150
         Width           =   7650
         Begin VB.TextBox txt_SpokenLanguage 
            Height          =   345
            Left            =   2940
            TabIndex        =   23
            Top             =   480
            Width           =   615
         End
         Begin VB.TextBox txt_Description 
            Height          =   330
            Left            =   105
            MaxLength       =   80
            TabIndex        =   3
            Top             =   1200
            Width           =   7290
         End
         Begin VB.TextBox txt_Subject 
            Height          =   330
            Left            =   120
            MaxLength       =   80
            TabIndex        =   4
            Top             =   1860
            Width           =   7290
         End
         Begin VB.TextBox txt_Body 
            Height          =   1530
            Left            =   75
            MaxLength       =   2000
            MultiLine       =   -1  'True
            TabIndex        =   5
            Top             =   2565
            Width           =   7350
         End
         Begin VB.TextBox txt_Template 
            Height          =   330
            Left            =   75
            MaxLength       =   255
            TabIndex        =   6
            Top             =   4470
            Width           =   6750
         End
         Begin VB.CommandButton cmd_SelectTemplate 
            Caption         =   "..."
            Height          =   345
            Left            =   6915
            TabIndex        =   7
            Top             =   4455
            Width           =   510
         End
         Begin MSComDlg.CommonDialog dlg_Open 
            Left            =   4530
            Top             =   270
            _ExtentX        =   847
            _ExtentY        =   847
            _Version        =   393216
            Filter          =   "*.xlm"
         End
         Begin Project1.ArmCombobox cbo_Language 
            Height          =   345
            Left            =   105
            TabIndex        =   1
            Top             =   480
            Width           =   2655
            _ExtentX        =   4683
            _ExtentY        =   609
         End
         Begin Project1.ArmCombobox cbo_Country 
            Height          =   345
            Left            =   5355
            TabIndex        =   2
            Top             =   540
            Width           =   1995
            _ExtentX        =   3519
            _ExtentY        =   609
         End
         Begin VB.Label Label7 
            Caption         =   "Spoken language"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Left            =   2880
            TabIndex        =   22
            Top             =   195
            Width           =   2055
         End
         Begin VB.Label Label2 
            Caption         =   "Country"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Left            =   5355
            TabIndex        =   16
            Top             =   255
            Width           =   2055
         End
         Begin VB.Label Label1 
            Caption         =   "Language"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Left            =   75
            TabIndex        =   15
            Top             =   180
            Width           =   2055
         End
         Begin VB.Label Label3 
            Caption         =   "Description"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Left            =   90
            TabIndex        =   14
            Top             =   825
            Width           =   2055
         End
         Begin VB.Label Label4 
            Caption         =   "Email subject"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Left            =   120
            TabIndex        =   13
            Top             =   1560
            Width           =   2055
         End
         Begin VB.Label Label5 
            Caption         =   "Email body"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   238
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   270
            Left            =   90
            TabIndex        =   12
            Top             =   2235
            Width           =   1050
         End
         Begin VB.Label Label6 
            Caption         =   "Template"
            Height          =   270
            Left            =   90
            TabIndex        =   11
            Top             =   4185
            Width           =   1050
         End
      End
      Begin VB.CommandButton cmd_Cancel 
         Caption         =   "Cancel"
         Height          =   435
         Left            =   7950
         TabIndex        =   9
         Top             =   735
         Width           =   1380
      End
      Begin VB.CommandButton cmd_OK 
         Caption         =   "OK"
         Height          =   435
         Left            =   7950
         TabIndex        =   8
         Top             =   225
         Width           =   1380
      End
   End
   Begin VB.Frame fra_Main 
      Height          =   7125
      Left            =   90
      TabIndex        =   17
      Top             =   90
      Width           =   10860
      Begin VB.CommandButton cmd_copySelected 
         Caption         =   "Copy selected"
         Height          =   525
         Left            =   8730
         TabIndex        =   28
         Top             =   720
         Width           =   1995
      End
      Begin VB.CommandButton btn_downloadAll 
         Caption         =   "Download All"
         Height          =   690
         Left            =   8730
         TabIndex        =   27
         Top             =   3690
         Width           =   1995
      End
      Begin VB.CommandButton cmd_add_reporting 
         Caption         =   "Insert reporting template"
         Height          =   690
         Left            =   8775
         TabIndex        =   26
         Top             =   6165
         Width           =   1995
      End
      Begin VB.CommandButton cmd_Download 
         Caption         =   "Download template"
         Height          =   690
         Left            =   8730
         TabIndex        =   25
         Top             =   2940
         Width           =   1995
      End
      Begin VB.CommandButton cmd_Replace 
         Caption         =   "Replace template"
         Height          =   690
         Left            =   8745
         TabIndex        =   24
         Top             =   4425
         Width           =   1995
      End
      Begin VB.CommandButton cmd_Add 
         Caption         =   "Insert template"
         Height          =   525
         Left            =   8730
         TabIndex        =   20
         Top             =   150
         Width           =   1995
      End
      Begin VB.CommandButton cmd_Delete 
         Caption         =   "Drop template"
         Height          =   525
         Left            =   8745
         TabIndex        =   19
         Top             =   1920
         Width           =   1995
      End
      Begin VB.CommandButton cmd_Update 
         Caption         =   "Update template"
         Height          =   525
         Left            =   8760
         TabIndex        =   18
         Top             =   1320
         Width           =   1995
      End
      Begin Project1.ArmGrid grd_Templates 
         Height          =   4995
         Left            =   105
         TabIndex        =   21
         Top             =   165
         Width           =   8535
         _ExtentX        =   15055
         _ExtentY        =   8811
      End
   End
End
Attribute VB_Name = "SPATemplateManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

#If LIVE Then
    Private mo_Db                   As Object
#Else
    Private mo_Db                   As ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

Const C_ERRORRAISE As Long = 3000
Const C_PROCESSNAME As String = "SPA_TEMPLATE_MAN" '
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301     ' detected row with same unique id
End Enum

Private Enum ArmScreenMode
    smRefreshOnly
    smMain
    smAdd
    smUpdate
    smDelete
    smView
    smAddItem
    smUpdateItem
    smDeleteItem
    smViewItem
    smReplace
End Enum

Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private ml_U_code As Long
Private mb_Initialized As Boolean
Private ml_SPDTZ_Id As Long
Private ml_SPTD_Code As Long
Private me_Mode As ArmScreenMode

Public Function Load_A_Com() As Boolean
On Error GoTo ErrHandler
    
    If mb_Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized, "Load_A_COM", "Component already initialized"

    If mo_Db Is Nothing Then Err.Raise ArmErr.PropertyNotSet, "ArmDb", "Property not set"
    If ml_U_code = 0 Then Err.Raise ArmErr.PropertyNotSet, "U_Code", "Property not set"
    
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    fra_Detail.Visible = False
    
    Set cbo_Country.ArmDb = mo_Db
    Call cbo_Country.Load_A_Com
    cbo_Country.Request = "SELECT CT_Code,CT_Desc FROM countries WHERE Language_Code='E' AND Drop_Flag=''"
    
    Set cbo_Language.ArmDb = mo_Db
    Call cbo_Language.Load_A_Com
    cbo_Language.Request = "SELECT Language_Code,Language_Desc FROM language WHERE Language_Validity='Y' ORDER BY Language_Desc"

    Set grd_Templates.ArmDb = mo_Db
    Call grd_Templates.Load_A_Com
    grd_Templates.MultiSelect = False
    grd_Templates.AllowExcelExport = True
    grd_Templates.Title = "SPA templates"
    
    Call grd_Templates.SetColumns(Array( _
      "SPTD_Code4001SPTD_CodeSPTD_Code", _
      "SPDTZ_Id4000SPDTZ_IdSPTDZ_Code", _
      "Language_Code00Language_CodeLanguage_Code", _
      "Language_Desc10000Language_DescLanguage", _
      "Spoken_Language5000Spoken_LanguageSpoken lang.", _
      "CT_Code00CT_CodeCT_Code", _
      "CT_Desc12000CT_DescCountry", _
      "SPTD_Description20000SPTD_DescriptionDescription", _
      "VDate_Start10000VDate_StartStart date", _
      "VDate_End10000VDate_EndEnd date"))
    
    Call grd_Templates.Load( _
        "SELECT SPTD.SPTD_Code,SPTD.SPDTZ_Id,SPTD.Spoken_Language,SPTD.Language_Code,LG.Language_Desc," & _
        "SPTD.CT_Code,CT.CT_Desc,SPTD.SPTD_Description,VDate_Start,VDate_End " & _
        "FROM SPA_DocumentTemplate SPTD " & _
        "INNER JOIN countries CT ON (SPTD.CT_Code=CT.CT_Code AND CT.Language_Code='E') " & _
        "INNER JOIN language LG ON (SPTD.Language_Code=LG.Language_Code) " & _
        "WHERE " & _
        "(SPTD.VDate_Start < GetDate()) AND ( (SPTD.VDate_End IS NULL) OR (GetDate()<SPTD.VDate_End+1) ) OR " & _
        "(SPTD.VDate_Start > GetDate()) " & _
        "ORDER BY CT.CT_Desc,SPTD.Spoken_Language", False)
    me_Mode = smMain
    Call Resize
    mb_Initialized = True
    
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_COM", True)
    End
End Function

Public Function Unload_A_Com() As Boolean
On Error GoTo ErrHandler

    Call grd_Templates.Unload_A_Com
    Set mo_FSO = Nothing
    
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_COM")
End Function

#If LIVE Then
Public Property Set Db(ByRef aDb As Object)
#Else
Public Property Set Db(ByRef aDb As ArmDb)
#End If
    Set mo_Db = aDb
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Public Property Let U_Code(al_U_Code As Long)
    ml_U_code = al_U_Code
End Property

Private Sub Item_Clear()
On Error GoTo ErrHandler

    ml_SPTD_Code = 0
    ml_SPDTZ_Id = 0
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Clear")
End Sub

Private Sub Item_Load(ByVal al_SPTD_Code As Long)
On Error GoTo ErrHandler

    Dim ll_Cursor As Long

    ll_Cursor = OpenSQLSafe(mo_Db, _
        "SELECT SPTD.SPTD_Code,SPTD.Spoken_Language,SPTD.SPDTZ_Id,SPTD.SPTD_Description,SPTD.SPTD_Subject," & _
        "SPTD.SPTD_Body,SPTD.CT_Code,CT.CT_Desc,SPTD.Language_Code,LG.Language_Desc " & _
        "FROM SPA_DocumentTemplate SPTD " & _
        "INNER JOIN countries CT ON (SPTD.CT_Code=CT.CT_Code AND CT.Language_Code='E') " & _
        "INNER JOIN language LG ON (SPTD.Language_Code=LG.Language_Code) " & _
        "WHERE SPTD_Code=" & al_SPTD_Code, 1)
    
    Call cbo_Language.AddItem(Array(mo_Db.GetFields(ll_Cursor, "Language_Code"), mo_Db.GetFields(ll_Cursor, "Language_Desc")), True)
    Call cbo_Country.AddItem(Array(mo_Db.GetFields(ll_Cursor, "CT_Code"), mo_Db.GetFields(ll_Cursor, "CT_Desc")), True)
    
    txt_SpokenLanguage.Text = mo_Db.GetFields(ll_Cursor, "Spoken_Language")
    txt_Description.Text = mo_Db.GetFields(ll_Cursor, "SPTD_Description")
    txt_Subject.Text = mo_Db.GetFields(ll_Cursor, "SPTD_Subject")
    txt_Body.Text = mo_Db.GetFields(ll_Cursor, "SPTD_Body")
    ml_SPDTZ_Id = mo_Db.GetFields(ll_Cursor, "SPDTZ_Id")
    ml_SPTD_Code = mo_Db.GetFields(ll_Cursor, "SPTD_Code")
    Call mo_Db.Close(ll_Cursor)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Load param:al_SPTD_Code=" & al_SPTD_Code)
End Sub

Private Function Item_Save()
On Error GoTo ErrHandler

    Item_Save = False
    Select Case me_Mode
        Case smAdd
            Item_Save = Item_Add
        Case smUpdate
            Item_Save = Item_Update
        Case smDelete
            If MsgBox("Are you sure to drop template ?", vbYesNo) = vbYes Then
                Item_Save = Item_Delete
            End If
        Case smReplace
            Item_Save = Item_Replace
    End Select

    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Save")
End Function

Private Function CheckMandatoryFields() As Boolean
On Error GoTo ErrHandler
    
    CheckMandatoryFields = False
    
    If cbo_Country.SelectedItem Is Nothing Then
        MsgBox "Please, enter country"
        Exit Function
    End If
    
    If cbo_Language.SelectedItem Is Nothing Then
        MsgBox "Please, enter language"
        Exit Function
    End If
    
    If Trim(txt_SpokenLanguage.Text) = "" Then
        MsgBox "Please, enter spoken language"
        Exit Function
    End If
    
    If Trim(txt_Description.Text) = "" Then
        MsgBox "Please, enter description"
        Exit Function
    End If

    If Trim(txt_Subject.Text) = "" Then
        MsgBox "Please, enter subject"
        Exit Function
    End If

    If Trim(txt_Body.Text) = "" Then
        MsgBox "Please, enter body"
        Exit Function
    End If
    
    If (me_Mode = smAdd) Or (me_Mode = smReplace) Then
        If Trim(txt_Template.Text) = "" Then
            MsgBox "Please, enter template file"
            Exit Function
        End If
    End If
    CheckMandatoryFields = True

    Exit Function
ErrHandler:
    Call ErrorHandler("CheckMandatoryFields")
End Function

Private Function Item_Add() As Boolean
On Error GoTo ErrHandler
    
    Item_Add = False
    
    If Not CheckMandatoryFields Then Exit Function
    If Not me_Mode = smUpdate Then
        If ExistsTemplate Then
            If MsgBox("Template for this Country, Language and Spoken Language already exists in database. Do you want to continue?", vbQuestion Or vbYesNo) = vbNo Then
            Exit Function
            End If
        End If
    End If
    
    Call InsertTemplateDoc(Now, Null)
'    Call InsertTemplateZip(txt_Template.Text)
    Item_Add = True
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Add")
End Function

Private Sub InsertTemplateDoc(ByVal av_VDate_Start As Variant, ByVal av_VDate_End As Variant)
On Error GoTo ErrHandler

    Dim ls_Request As String
    
    If Not IsNumeric(txt_Template.Text) Then
    
        Call InsertTemplateZip(txt_Template.Text)
    Else
        ml_SPDTZ_Id = CLng(txt_Template.Text)
    End If
    
    ml_SPTD_Code = Val(mo_Db.SQLNextID("SPA_DocumentTemplate"))
    If ml_SPTD_Code = 0 Then
        Err.Raise ArmErr.CompFncFailed, "SQLNextID", "Function SQLNextID failed for SPA_DocumentTemplate"
    End If
        
    ls_Request = _
    "INSERT INTO SPA_DocumentTemplate (SPTD_Code,Spoken_Language,Language_Code,CT_Code,VDate_Start,VDate_End," & _
    "SPDTZ_Id,SPTD_Description,SPTD_Subject,SPTD_Body," & _
    "Z_creation,Z_creator,Z_last_upd,Z_last_upd_user,iConcurrency,Drop_Flag,Drop_Date) VALUES " & _
    "($SPTD_Code$,$Spoken_Language$,$Language_Code$,$CT_Code$,$VDate_Start$,$VDate_End$," & _
    "$SPDTZ_Id$,$SPTD_Description$,$SPTD_Subject$,$SPTD_Body$," & _
    "getdate(),$Z_creator$,getdate(),$Z_last_upd_user$,1,'',NULL)"
    
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Code$", ml_SPTD_Code)
    ls_Request = ReplacePlaceHolder(ls_Request, "$Spoken_Language$", SQLStr(txt_SpokenLanguage))
    ls_Request = ReplacePlaceHolder(ls_Request, "$Language_Code$", SQLStr(cbo_Language.SelectedItem.Key))
    ls_Request = ReplacePlaceHolder(ls_Request, "$CT_Code$", SQLStr(cbo_Country.SelectedItem.Key))
    ls_Request = ReplacePlaceHolder(ls_Request, "$VDate_Start$", SqlDate(av_VDate_Start))
    ls_Request = ReplacePlaceHolder(ls_Request, "$VDate_End$", SqlDate(av_VDate_End))
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPDTZ_Id$", ml_SPDTZ_Id)
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Description$", SQLStr(txt_Description.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Subject$", SQLStr(txt_Subject.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Body$", SQLStr(txt_Body.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$Z_creator$", ml_U_code)
    ls_Request = ReplacePlaceHolder(ls_Request, "$Z_last_upd_user$", ml_U_code)
    
    Call ExecuteSQLSafe(mo_Db, ls_Request)
    Exit Sub
ErrHandler:
    Call ErrorHandler("InsertTemplateDoc")
End Sub

Private Sub InsertTemplateZip(ByVal as_fileName As String)
On Error GoTo ErrHandler

    Dim ls_Request As String
    Dim ls_TmpZipFile As String
    Dim ls_TmpXmlFile As String
    Dim ls_Pict1File As String
    Dim ls_Pict2File As String
    
    Dim ls_TmpPath As String
'    Dim ll_Idx As Long
    Dim mo_Zip As New ArmZip
    
    ml_SPDTZ_Id = Val(mo_Db.SQLNextID("SPA_DocumentTemplateZip"))
    If ml_SPDTZ_Id = 0 Then
        Err.Raise ArmErr.CompFncFailed, "SQLNextID", "Function SQLNextID failed for SPA_DocumentTemplateZip"
    End If
    
'    ll_Idx = InStrRev(txt_Template.Text, "\")
'    If ll_Idx < 1 Then
'        Err.Raise ArmErr.CompFncFailed, "InStrRev", "Function didn't find path in: " & txt_Template.Text
'    End If
'    ls_Path = Left(txt_Template.Text, ll_Idx)
    
    
    ls_TmpPath = App.Path & "\Temp"
    If Not mo_FSO.FolderExists(ls_TmpPath) Then
        mo_FSO.CreateFolder (ls_TmpPath)
    End If
    
    ls_TmpZipFile = ls_TmpPath & "\template.zip"
    If mo_FSO.FileExists(ls_TmpZipFile) Then
        Call mo_FSO.DeleteFile(ls_TmpZipFile)
    End If
    
    ls_TmpXmlFile = ls_TmpPath & "\SPATmp.xml"
    If mo_FSO.FileExists(ls_TmpXmlFile) Then
        Call mo_FSO.DeleteFile(ls_TmpXmlFile)
    End If
    
    ' JN 3.7.2009
    ls_Pict1File = ls_TmpPath & "\SPAPic1.jpg"
    If mo_FSO.FileExists(ls_Pict1File) Then
        Call mo_FSO.DeleteFile(ls_Pict1File)
    End If
    
    ls_Pict2File = ls_TmpPath & "\SPAPic2.jpg"
    If mo_FSO.FileExists(ls_Pict2File) Then
        Call mo_FSO.DeleteFile(ls_Pict2File)
    End If
    
    ' extract path from filepath. must not be in the root
    Dim ls_path As String
    Dim ll_pos As Long
    
    ll_pos = InStrRev(as_fileName, "\", , vbTextCompare)
    If ll_pos = 0 Then
        Call Err.Raise(100, "", "Input path is no valid or a root path specified.")
    End If
    
    ls_path = Left(as_fileName, ll_pos - 1)
    
    
    Call mo_FSO.CopyFile(as_fileName, ls_TmpXmlFile)
    Call mo_FSO.CopyFile(ls_path & "\SPAPic1.jpg", ls_Pict1File)
    Call mo_FSO.CopyFile(ls_path & "\SPAPic2.jpg", ls_Pict2File)
    
    If Not mo_Zip.CompressFile(ls_TmpPath & "\SPA*.*", ls_TmpZipFile, 9, False) Then
'    If Not mo_Zip.CompressFile(ls_TmpXmlFile, ls_TmpZipFile, 9, False) Then
        Err.Raise ArmErr.CompFncFailed, "CompressFile", "Function failed for CompressFile " & ls_TmpXmlFile & " to: " & ls_TmpZipFile
    End If
    
'    Call MsgBox("Zip was created, now you must manually insert SPAPic1.jpg and SPAPic2.jpg into " & ls_TmpZipFile & " and click OK")
    
    ls_Request = "INSERT INTO SPA_DocumentTemplateZip (SPDTZ_Id,SPDTZ_Zip) VALUES ($SPDTZ_Id$,?)"
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPDTZ_Id$", ml_SPDTZ_Id)
    If Not mo_Db.FileToBlobSQL(ls_Request, ls_TmpZipFile, 9) Then
        Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", "Function failed for upload " & ls_TmpZipFile
    End If
    
    Call mo_FSO.DeleteFile(ls_TmpPath & "\*.*")
    Exit Sub
ErrHandler:
    Call ErrorHandler("InsertTemplateZip")
End Sub

Private Sub UpdateTemplateDoc(ByVal av_VDate_End As Variant)
On Error GoTo ErrHandler

    Dim ls_Request As String
    
    ls_Request = _
    "UPDATE SPA_DocumentTemplate SET " & _
        "SPTD_Description=$SPTD_Description$," & _
        "SPTD_Subject=$SPTD_Subject$," & _
        "SPTD_Body=$SPTD_Body$," & _
        "VDate_End=$VDate_End$," & _
        "Z_last_upd=getdate()," & _
        "Z_last_upd_user = $Z_last_upd_user$ " & _
    "WHERE SPTD_Code = $SPTD_Code$"
    
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Description$", SQLStr(txt_Description.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Subject$", SQLStr(txt_Subject.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Body$", SQLStr(txt_Body.Text))
    ls_Request = ReplacePlaceHolder(ls_Request, "$VDate_End$", SqlDate(av_VDate_End))
    ls_Request = ReplacePlaceHolder(ls_Request, "$Z_last_upd_user$", ml_U_code)
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Code$", ml_SPTD_Code)
    Call ExecuteSQLSafe(mo_Db, ls_Request, 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateTemplateDoc")
End Sub

Private Sub UpdateRPTZip(ByVal as_fileName As String, ByVal as_FileKey As String)
On Error GoTo ErrHandler

    Dim ls_Request As String
    Dim ls_TmpZipFile As String
    Dim ls_TmpXmlFile As String
    Dim ls_TmpPath As String
    Dim mo_Zip As New ArmZip
    Dim ls_Pict1File As String
    Dim ls_Pict2File As String
    
    ls_TmpPath = App.Path & "\Temp"
    If Not mo_FSO.FolderExists(ls_TmpPath) Then
        mo_FSO.CreateFolder (ls_TmpPath)
    End If
    
    ls_TmpZipFile = ls_TmpPath & "\template.zip"
    If mo_FSO.FileExists(ls_TmpZipFile) Then
        Call mo_FSO.DeleteFile(ls_TmpZipFile)
    End If
    
    ls_TmpXmlFile = ls_TmpPath & "\RPTTmp.xml"
    If mo_FSO.FileExists(ls_TmpXmlFile) Then
        Call mo_FSO.DeleteFile(ls_TmpXmlFile)
    End If
    
    ' JN 3.7.2009
    ls_Pict1File = ls_TmpPath & "\CAP_RPT_SALESPic1.jpg"
    If mo_FSO.FileExists(ls_Pict1File) Then
        Call mo_FSO.DeleteFile(ls_Pict1File)
    End If
    
    ls_Pict2File = ls_TmpPath & "\CAP_RPT_SALESPic2.jpg"
    If mo_FSO.FileExists(ls_Pict2File) Then
        Call mo_FSO.DeleteFile(ls_Pict2File)
    End If
    
    ' extract path from filepath. must not be in the root
    Dim ls_path As String
    Dim ll_pos As Long
    
    ll_pos = InStrRev(as_fileName, "\", , vbTextCompare)
    If ll_pos = 0 Then
        Call Err.Raise(100, "", "Input path is no valid or a root path specified.")
    End If
    
    ls_path = Left(as_fileName, ll_pos - 1)
    
    
    Call mo_FSO.CopyFile(as_fileName, ls_TmpXmlFile)
    Call mo_FSO.CopyFile(ls_path & "\CAP_RPT_SALESPic1.jpg", ls_Pict1File)
    Call mo_FSO.CopyFile(ls_path & "\CAP_RPT_SALESPic2.jpg", ls_Pict2File)
    
    If Not mo_Zip.CompressFile(ls_TmpPath & "\*.*", ls_TmpZipFile, 9, False) Then
'    If Not mo_Zip.CompressFile(ls_TmpXmlFile, ls_TmpZipFile, 9, False) Then
        Err.Raise ArmErr.CompFncFailed, "CompressFile", "Function failed for CompressFile " & ls_TmpXmlFile & " to: " & ls_TmpZipFile
    End If
    
'    Call MsgBox("Zip was created, now you must manually insert SPAPic1.jpg and SPAPic2.jpg into " & ls_TmpZipFile & " and click OK")
    
    ' check if A_File record with key exists
    Dim ll_Cursor As Long
    ll_Cursor = OpenSQLSafe(mo_Db, "SELECT F_Version FROM A_Files WHERE F_File_key='" & as_FileKey & "'")
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        ls_Request = "UPDATE A_Files SET F_Active=1, F_Data_File=? WHERE F_File_key='$F_File_Key$'"
    Else
        ls_Request = "INSERT INTO A_Files ( F_File_Key, F_Data_File, F_Info, F_Version, F_Active, F_Type ) VALUES('$F_File_Key$', ?, 'Template for Capture reporting', '1.0', 1, 'ZIP')"
    End If
    
    ls_Request = ReplacePlaceHolder(ls_Request, "$F_File_Key$", as_FileKey)
    
    If Not mo_Db.FileToBlobSQL(ls_Request, ls_TmpZipFile, 9) Then
        Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", "Function failed for upload " & ls_TmpZipFile
    End If
    
    Call mo_FSO.DeleteFile(ls_TmpPath & "\*.*")
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateRPTZip")
End Sub

Private Sub UpdateTemplateZip(ByVal as_fileName As String)
On Error GoTo ErrHandler

    Dim ls_Request As String
    Dim ls_TmpZipFile As String
    Dim ls_TmpXmlFile As String
    Dim ls_TmpPath As String
    Dim mo_Zip As New ArmZip
    Dim ls_Pict1File As String
    Dim ls_Pict2File As String
    
    ls_TmpPath = App.Path & "\Temp"
    If Not mo_FSO.FolderExists(ls_TmpPath) Then
        mo_FSO.CreateFolder (ls_TmpPath)
    End If
    
    ls_TmpZipFile = ls_TmpPath & "\template.zip"
    If mo_FSO.FileExists(ls_TmpZipFile) Then
        Call mo_FSO.DeleteFile(ls_TmpZipFile)
    End If
    
    ls_TmpXmlFile = ls_TmpPath & "\SPATmp.xml"
    If mo_FSO.FileExists(ls_TmpXmlFile) Then
        Call mo_FSO.DeleteFile(ls_TmpXmlFile)
    End If
    
    ' JN 3.7.2009
    ls_Pict1File = ls_TmpPath & "\SPAPic1.jpg"
    If mo_FSO.FileExists(ls_Pict1File) Then
        Call mo_FSO.DeleteFile(ls_Pict1File)
    End If
    
    ls_Pict2File = ls_TmpPath & "\SPAPic2.jpg"
    If mo_FSO.FileExists(ls_Pict2File) Then
        Call mo_FSO.DeleteFile(ls_Pict2File)
    End If
    
    ' extract path from filepath. must not be in the root
    Dim ls_path As String
    Dim ll_pos As Long
    
    ll_pos = InStrRev(as_fileName, "\", , vbTextCompare)
    If ll_pos = 0 Then
        Call Err.Raise(100, "", "Input path is no valid or a root path specified.")
    End If
    
    ls_path = Left(as_fileName, ll_pos - 1)
    
    
    Call mo_FSO.CopyFile(as_fileName, ls_TmpXmlFile)
    Call mo_FSO.CopyFile(ls_path & "\SPAPic1.jpg", ls_Pict1File)
    Call mo_FSO.CopyFile(ls_path & "\SPAPic2.jpg", ls_Pict2File)
    
    If Not mo_Zip.CompressFile(ls_TmpPath & "\SPA*.*", ls_TmpZipFile, 9, False) Then
'    If Not mo_Zip.CompressFile(ls_TmpXmlFile, ls_TmpZipFile, 9, False) Then
        Err.Raise ArmErr.CompFncFailed, "CompressFile", "Function failed for CompressFile " & ls_TmpXmlFile & " to: " & ls_TmpZipFile
    End If
    
'    Call MsgBox("Zip was created, now you must manually insert SPAPic1.jpg and SPAPic2.jpg into " & ls_TmpZipFile & " and click OK")
    
    ls_Request = "UPDATE SPA_DocumentTemplateZip SET SPDTZ_Zip=? WHERE SPDTZ_Id=$SPDTZ_Id$"
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPDTZ_Id$", ml_SPDTZ_Id)
    
    If Not mo_Db.FileToBlobSQL(ls_Request, ls_TmpZipFile, 9) Then
        Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", "Function failed for upload " & ls_TmpZipFile
    End If
    
    Call mo_FSO.DeleteFile(ls_TmpPath & "\*.*")
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateTemplateZip")
End Sub


Private Sub DeleteTemplateDoc()
On Error GoTo ErrHandler

    Dim ls_Request As String
    
    ls_Request = _
    "UPDATE SPA_DocumentTemplate SET " & _
        "Drop_Flag='X'," & _
        "Drop_Date=getdate()," & _
        "VDate_End=getdate()," & _
        "Z_last_upd=getdate()," & _
        "Z_last_upd_user = $Z_last_upd_user$ " & _
    "WHERE SPTD_Code = $SPTD_Code$"

    ls_Request = ReplacePlaceHolder(ls_Request, "$Z_last_upd_user$", ml_U_code)
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Code$", ml_SPTD_Code)
    Call ExecuteSQLSafe(mo_Db, ls_Request, 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler("DeleteTemplate")
End Sub

Private Function Item_Update() As Boolean
On Error GoTo ErrHandler

    Dim ls_Request As String

    Item_Update = False

    If Not CheckMandatoryFields Then Exit Function
    
    If Trim(txt_Template.Text) = "" Then
        Call UpdateTemplateDoc(Null)
    Else
        Call DeleteTemplateDoc
        Call InsertTemplateDoc(Now + 1, Null)
    End If
    
    Item_Update = True
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Update")
End Function

Private Function Item_Delete() As Boolean
On Error GoTo ErrHandler

    Call DeleteTemplateDoc
    Item_Delete = True
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Delete")
End Function

Private Function Item_Replace() As Boolean
On Error GoTo ErrHandler

    Dim ls_Request As String
    Dim ls_ZipFile As String
    Dim ls_TmpFile As String
    Dim mo_Zip As New ArmZip
    Dim ll_Idx As Long
    Dim ls_path As String

    Item_Replace = False
    
    If Not CheckMandatoryFields Then Exit Function

    Call UpdateTemplateZip(txt_Template.Text)
    ls_Request = _
    "update SPA_DocumentTemplate set " & _
        "Z_last_upd=getdate()," & _
        "Z_last_upd_user = $Z_last_upd_user$ " & _
    "Where SPTD_Code = $SPTD_Code$"

    ls_Request = ReplacePlaceHolder(ls_Request, "$Z_last_upd_user$", ml_U_code)
    ls_Request = ReplacePlaceHolder(ls_Request, "$SPTD_Code$", ml_SPTD_Code)
    Call ExecuteSQLSafe(mo_Db, ls_Request, 1)
    
    Item_Replace = True

    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Replace")
End Function

Private Sub Item_Download(ByVal al_SPDTZ_Id As Long, Optional ByVal as_folderName As String = "")
On Error GoTo ErrHandler

    Dim ls_Request As String
    Dim ls_TmpZipFile As String
    Dim ls_TmpXmlFile As String
    Dim ls_TmpPath As String
    Dim mo_Zip As New ArmZip
    
    dlg_Open.Filter = "XML Template (*.xml)|*.xml"
    dlg_Open.DialogTitle = "Save template"
    dlg_Open.FileName = as_folderName
    If as_folderName = "" Then
        dlg_Open.ShowSave
    End If
    
    If dlg_Open.FileName <> "" Then
        ls_Request = "SELECT SPDTZ_Zip FROM SPA_DocumentTemplateZip WHERE SPDTZ_Id=$SPDTZ_Id$"
        ls_Request = ReplacePlaceHolder(ls_Request, "$SPDTZ_Id$", al_SPDTZ_Id)
        
    
        ls_TmpPath = App.Path & "\Temp"
        If Not mo_FSO.FolderExists(ls_TmpPath) Then
            mo_FSO.CreateFolder (ls_TmpPath)
        End If
        
        ls_TmpZipFile = ls_TmpPath & "\template.zip"
        If mo_FSO.FileExists(ls_TmpZipFile) Then
            Call mo_FSO.DeleteFile(ls_TmpZipFile)
        End If
        
        ls_TmpXmlFile = ls_TmpPath & "\SPATmp.xml"
        If mo_FSO.FileExists(ls_TmpXmlFile) Then
            Call mo_FSO.DeleteFile(ls_TmpXmlFile)
        End If
        
        If Not mo_Db.BlobToFileSQL(ls_Request, ls_TmpZipFile, True, False) Then
            Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "Function failed for download " & ls_TmpZipFile
        End If
        
        If Not mo_Zip.DecompressFile(ls_TmpZipFile, ls_TmpPath, False, True) Then
            Err.Raise ArmErr.CompFncFailed, "DecompressFile", "Function failed for DecompressFile " & ls_TmpZipFile & " to: " & ls_TmpXmlFile
        End If
        
        If as_folderName = "" Then
        
            Call mo_FSO.CopyFile(ls_TmpXmlFile, dlg_Open.FileName)
            Call mo_FSO.DeleteFile(ls_TmpPath & "\*.*")
        Else
            ' copy complete folder
            Call mo_FSO.CopyFolder(ls_TmpPath, as_folderName)
'            Call mo_FSO.DeleteFile(as_folderName & "\template.zip")
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Download param:al_SPTD_Code" & al_SPDTZ_Id)
End Sub

Private Sub Item_AddInit()
On Error GoTo ErrHandler

    me_Mode = smAdd
    Call ClearForm(UserControl.Controls, fra_Item)
    Call SetEnabled(fra_Item, True)
    Call EnableControlsReplace(True)
    Call Item_DisplayDetail(True)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_AddInit")
End Sub

Private Sub Item_CopyInit(ByVal al_SPTD_Code As Long)
On Error GoTo ErrHandler

    me_Mode = smAdd
    Call ClearForm(UserControl.Controls, fra_Item)
    Call SetEnabled(fra_Item, True)
    Call EnableControlsReplace(True)
    Call Item_Load(al_SPTD_Code)
    Call Item_DisplayDetail(True)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateInit param:al_SPTD_Code=" & al_SPTD_Code)
End Sub

Private Sub Item_UpdateInit(ByVal al_SPTD_Code As Long)
On Error GoTo ErrHandler

    If grd_Templates.SelectedLine(0, "VDate_End") <> 0 Then
        Call MsgBox("Cannot update already closed template")
        Exit Sub
    End If

    me_Mode = smUpdate
    Call ClearForm(UserControl.Controls, fra_Item)
    Call SetEnabled(fra_Item, True)
    Call EnableControlsReplace(True)
    Call EnableControlsUpdate(False)
    Call Item_Load(al_SPTD_Code)
    Call Item_DisplayDetail(True)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateInit param:al_SPTD_Code=" & al_SPTD_Code)
End Sub

Private Sub Item_DeleteInit(ByVal al_SPTD_Code As Long)
On Error GoTo ErrHandler

    If grd_Templates.SelectedLine(0, "VDate_End") <> 0 Then
        Call MsgBox("Cannot update already closed template")
        Exit Sub
    End If
    
    me_Mode = smDelete
    Call ClearForm(UserControl.Controls, fra_Item)
    Call SetEnabled(fra_Item, False)
    Call Item_Load(al_SPTD_Code)
    Call Item_DisplayDetail(True)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_DeleteInit param:al_SPTD_Code=" & al_SPTD_Code)
End Sub

Private Sub Item_ReplaceInit(ByVal al_SPTD_Code As Long)
On Error GoTo ErrHandler

    If grd_Templates.SelectedLine(0, "VDate_End") <> 0 Then
        Call MsgBox("Cannot update already closed template")
        Exit Sub
    End If
    
    me_Mode = smReplace
    Call ClearForm(UserControl.Controls, fra_Item)
    Call SetEnabled(fra_Item, True)
    Call EnableControlsReplace(False)
    Call Item_Load(al_SPTD_Code)
    Call Item_DisplayDetail(True)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_ReplaceInit param:al_SPTD_Code" & al_SPTD_Code)
End Sub

Private Function ExistsTemplate() As Boolean
On Error GoTo ErrHandler

    Dim ll_Idx As Long
    
    ExistsTemplate = False
    For ll_Idx = 0 To grd_Templates.Rows - 1
        If grd_Templates.Data(ll_Idx, "Language_Code") = GetComboKey(cbo_Language) And _
            (StrComp(Trim(grd_Templates.Data(ll_Idx, "Spoken_Language")), Trim(txt_SpokenLanguage.Text), vbTextCompare) = 0) And _
            grd_Templates.Data(ll_Idx, "CT_Code") = GetComboKey(cbo_Country) Then
            ExistsTemplate = True
            Exit Function
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler("ExistsTemplate")
End Function

Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
On Error GoTo ErrHandler
    
    HasContainer = False
    Dim lControl As Control
 
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend
 
NotFound:
    Set lControl = Nothing
    HasContainer = False

    Exit Function
ErrHandler:
    Call ErrorHandler("HasContainer")
End Function
 

Private Function IsSub(ByVal av_Name As Object, ByRef aav_Names As Variant)
On Error GoTo ErrHandler
    
    IsSub = False
    
    Dim ll_Idx As Long
    For ll_Idx = LBound(aav_Names) To UBound(aav_Names)
    
        If av_Name Is aav_Names(ll_Idx) Then
            IsSub = True
            Exit Function
        End If
    Next ll_Idx
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsSub")
End Function


' Clear values for each control to not initiliazed
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object, Optional ByRef aav_Except As Variant)
On Error GoTo ErrHandler
 
    'mb_internal = True
 
    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Dim lb_Process As Boolean
        lb_Process = True
        Set lControl = aControls.Item(lIdx)
        If Not IsMissing(aav_Except) Then
            If IsSub(lControl, aav_Except) Then
                lb_Process = False
            End If
        End If
        If HasContainer(lControl, aContainer) And lb_Process Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
'                    Set lControl.SelectedItem = Nothing
                    Call lControl.Clear
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.Value = vbUnchecked
                Case "ARMCHECKVIEW"
                    lControl.Init
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
 
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case "OPTIONBUTTON"
                    lControl.Value = False
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "TOOLBARCONTROL", "LINE"
                
                Case "ARMPICKER"
                    Call lControl.Clear
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
 
        Set lControl = Nothing
    Next
 
   ' mb_internal = False
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearForm")
End Sub

Private Sub SetEnabled(ByVal ao_Container As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    
    Dim lo_ctrl As Object
    For Each lo_ctrl In UserControl.Controls
        If HasContainer(lo_ctrl, ao_Container) Then
            Call SetEnabledCtrl(lo_ctrl, ab_Value)
        End If
    Next
    
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
        
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_Value
            ao_ctrl.BackColor = IIf(ab_Value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX", "IMAGECOMBO"
            ao_ctrl.Enabled = ab_Value
        Case "ARMPICKER"
            ao_ctrl.Enabled = ab_Value
        Case "ARMGRID"
        End Select
    
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabledCtrl()")
End Sub

Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
On Error GoTo ErrHandler

    Static ls_ErrDesc As String
    Static ls_ErrSource As String
    Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateError")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String, Optional ByVal ab_ShowMsgbox As Boolean = False)
    Dim ll_oldMP As MousePointerConstants
    Dim ls_Message As String
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    ls_Message = App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & "."
    Call LogMessage(ls_Message, "E", False)
    If ab_ShowMsgbox Then MsgBox ls_Message
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
    
    Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_code))
    ls_req = Replace(ls_req, "$APP$", Left(Trim(SQLStr(App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)), 50))
    ls_req = Replace(ls_req, "$MSG$", right(Trim(SQLStr(as_logMsg)), 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(C_PROCESSNAME & ".LogMessage - " & Err.Number & ": " & Err.Description)
End Sub

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
'    Debug.Print 1 / 0
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function
ErrHandler:
    ao_DB.Close (lc_Data)
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

Private Function ReplaceCursorPlaceHolder(ByVal as_Request As String, ByVal ac_Cursor As Long) As String
On Error GoTo ErrHandler
    
    Dim ll_Idx As Long
    
    For ll_Idx = 0 To mo_Db.FieldCount(ac_Cursor) - 1
        as_Request = ReplacePlaceHolder(as_Request, "$" & mo_Db.GetFieldName(ac_Cursor, ll_Idx) & "$", mo_Db.GetFields(ac_Cursor, ll_Idx))
    Next
    ReplaceCursorPlaceHolder = as_Request
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCursorPlaceHolder")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function

Private Function SQLStr(ByVal as_Str As String) As String
On Error GoTo ErrHandler
    
    SQLStr = "'" & Replace(as_Str, "'", "''") & "'"
    
    Exit Function
ErrHandler:
    Call ErrorHandler("SQLStr, parameter:as_Str=" & as_Str)
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDate")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler
    
    GetComboKey = ""
    If Not ao_Combo.SelectedItem Is Nothing Then
        GetComboKey = ao_Combo.SelectedItem.Key
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & "GetComboKey")
End Function



Private Sub cmd_add_reporting_Click()
On Error GoTo ErrHandler
    
    dlg_Open.Filter = "XML Template (*.xml)|*.xml"
    dlg_Open.DialogTitle = "Save template"
    Call dlg_Open.ShowOpen
    If dlg_Open.FileName = "" Then Exit Sub

    Screen.MousePointer = vbHourglass
    
    Call UpdateRPTZip(dlg_Open.FileName, "CAP_RPT_SALES_2")
    Screen.MousePointer = vbDefault
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_add_reporting_Click")
End Sub

Private Sub cmd_Cancel_Click()
On Error GoTo ErrHandler

    Screen.MousePointer = vbHourglass
    Call Item_DisplayDetail(False)
    me_Mode = smMain
    Screen.MousePointer = vbDefault

    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Cancel_Click")
End Sub

Private Sub cmd_copySelected_Click()
On Error GoTo ErrHandler
    
    If grd_Templates.SelectedCount <> 1 Then
        MsgBox "Please, select row"
    Else
        Screen.MousePointer = vbHourglass
        Call Item_CopyInit(grd_Templates.CurrentKey(0))
        Screen.MousePointer = vbDefault
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_copySelected_Click")
End Sub

Private Sub cmd_Download_Click()
On Error GoTo ErrHandler
    
    If grd_Templates.SelectedCount <> 1 Then
        MsgBox "Please, select row"
    Else
        Screen.MousePointer = vbHourglass
        Call Item_Download(grd_Templates.CurrentLine("SPDTZ_Id"))
        Screen.MousePointer = vbDefault
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Download_Click")
End Sub

Private Sub btn_downloadAll_Click()
On Error GoTo ErrHandler
    
    If MsgBox("Do you want to download all templates?", vbYesNo, "Download all templates") <> vbYes Then
        Exit Sub
    End If
    
    Screen.MousePointer = vbHourglass
    
    Dim ll_i As Long
    For ll_i = 0 To grd_Templates.Rows - 1
        Call Item_Download(grd_Templates.Data(ll_i, "SPDTZ_Id"), App.Path & "\Download\" & grd_Templates.Data(ll_i, "SPDTZ_Id"))
    Next
    
    Screen.MousePointer = vbDefault
    Exit Sub
ErrHandler:
    Call ErrorMessage("btn_downloadAll_Click")
End Sub

Private Sub cmd_OK_Click()
On Error GoTo ErrHandler

    Screen.MousePointer = vbHourglass
    If Item_Save Then
        Call Item_DisplayDetail(False)
        Call grd_Templates.Refresh
        me_Mode = smMain
    End If
    Screen.MousePointer = vbDefault
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_OK_Click")
End Sub

Private Sub cmd_Replace_Click()
On Error GoTo ErrHandler
    
    If grd_Templates.SelectedCount <> 1 Then
        MsgBox "Please, select row"
    Else
        Screen.MousePointer = vbHourglass
        Call Item_ReplaceInit(grd_Templates.CurrentKey(0))
        Screen.MousePointer = vbDefault
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Replace_Click")
End Sub

Private Sub cmd_SelectTemplate_Click()
On Error GoTo ErrHandler
    
    dlg_Open.Filter = "XML Template (*.xml)|*.xml"
    dlg_Open.DialogTitle = "Select template"
    dlg_Open.ShowOpen
    If dlg_Open.FileName <> "" Then txt_Template.Text = dlg_Open.FileName
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_SelectTemplate_Click")
End Sub

Private Sub cmd_Add_Click()
On Error GoTo ErrHandler
    
    Screen.MousePointer = vbHourglass
    Call Item_AddInit
    Screen.MousePointer = vbDefault
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Add_Click")
End Sub

Private Sub cmd_Update_Click()
On Error GoTo ErrHandler
    
    If grd_Templates.SelectedCount <> 1 Then
        MsgBox "Please, select row"
    Else
        Screen.MousePointer = vbHourglass
        Call Item_UpdateInit(grd_Templates.CurrentKey(0))
        Screen.MousePointer = vbDefault
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Update_Click")
End Sub

Private Sub cmd_Delete_Click()
On Error GoTo ErrHandler
    
    If grd_Templates.SelectedCount <> 1 Then
        MsgBox "Please, select row"
    Else
        Screen.MousePointer = vbHourglass
        Call Item_DeleteInit(grd_Templates.CurrentKey(0))
        Screen.MousePointer = vbDefault
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_Delete_Click")
End Sub

Private Sub Item_DisplayDetail(ByVal ab_Show As Boolean)
On Error GoTo ErrHandler

    If ab_Show Then
        fra_Detail.Visible = True
        fra_Detail.ZOrder
    Else
        fra_Detail.Visible = False
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_DisplayDetail, parameter:ab_Show=" & ab_Show)
End Sub

Public Sub Resize()
On Error GoTo ErrHandler

    Call fra_Main.Move(0, 0, UserControl.Width, UserControl.Height)
    Call grd_Templates.Move(100, 200, grd_Templates.Width, fra_Main.Height - 300)
    Call fra_Detail.Move(0, 0, UserControl.Width, UserControl.Height)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Resize")
End Sub
    
Private Sub grd_Templates_ItemSelected()
On Error GoTo ErrHandler
    
    Call cmd_Update_Click
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("grd_Templates_ItemSelected")
End Sub

Private Sub EnableControlsUpdate(ByVal ab_Enable As Boolean)
On Error GoTo ErrHandler
    
    cbo_Language.Enabled = ab_Enable
    txt_SpokenLanguage.Enabled = ab_Enable
    cbo_Country.Enabled = ab_Enable

    Exit Sub
ErrHandler:
    Call ErrorHandler("EnableControlsUpdate")
End Sub

Private Sub EnableControlsReplace(ByVal ab_Enable As Boolean)
On Error GoTo ErrHandler
    
    cbo_Language.Enabled = ab_Enable
    txt_SpokenLanguage.Enabled = ab_Enable
    cbo_Country.Enabled = ab_Enable
    txt_Description.Enabled = ab_Enable
    txt_Subject.Enabled = ab_Enable
    txt_Body.Enabled = ab_Enable

    Exit Sub
ErrHandler:
    Call ErrorHandler("EnableControlsReplace")
End Sub

Private Sub txt_SpokenLanguage_LostFocus()
On Error GoTo ErrHandler
    
    txt_SpokenLanguage.Text = UCase(Trim(Left(txt_SpokenLanguage.Text, 2)))
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("txt_SpokenLanguage_LostFocus")
End Sub

