VERSION 5.00
Object = "{3A6F7F80-45E5-11D4-AC3E-ADBCE8B30410}#1.0#0"; "VSRpt7.ocx"
Object = "{A8561640-E93C-11D3-AC3B-CE6078F7B616}#1.0#0"; "VSPRINT7.ocx"
Begin VB.UserControl SPA_PDF 
   ClientHeight    =   5880
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8310
   ScaleHeight     =   5880
   ScaleWidth      =   8310
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   5000
      Left            =   270
      Top             =   585
   End
   Begin VSPrinter7LibCtl.VSPrinter vsp_Printer 
      Height          =   510
      Left            =   945
      TabIndex        =   2
      Top             =   555
      Visible         =   0   'False
      Width           =   585
      _cx             =   1032
      _cy             =   900
      Appearance      =   1
      BorderStyle     =   1
      Enabled         =   -1  'True
      MousePointer    =   0
      BackColor       =   -2147483643
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty HdrFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   14.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      _ConvInfo       =   1
      AutoRTF         =   -1  'True
      Preview         =   -1  'True
      DefaultDevice   =   0   'False
      PhysicalPage    =   -1  'True
      AbortWindow     =   -1  'True
      AbortWindowPos  =   0
      AbortCaption    =   "Printing..."
      AbortTextButton =   "Cancel"
      AbortTextDevice =   "on the %s on %s"
      AbortTextPage   =   "Now printing Page %d of"
      FileName        =   ""
      MarginLeft      =   1440
      MarginTop       =   1440
      MarginRight     =   1440
      MarginBottom    =   1440
      MarginHeader    =   0
      MarginFooter    =   0
      IndentLeft      =   0
      IndentRight     =   0
      IndentFirst     =   0
      IndentTab       =   720
      SpaceBefore     =   0
      SpaceAfter      =   0
      LineSpacing     =   100
      Columns         =   1
      ColumnSpacing   =   180
      ShowGuides      =   2
      LargeChangeHorz =   300
      LargeChangeVert =   300
      SmallChangeHorz =   30
      SmallChangeVert =   30
      Track           =   0   'False
      ProportionalBars=   -1  'True
      Zoom            =   -1.78094390026714
      ZoomMode        =   3
      ZoomMax         =   400
      ZoomMin         =   10
      ZoomStep        =   25
      EmptyColor      =   -2147483636
      TextColor       =   0
      HdrColor        =   0
      BrushColor      =   0
      BrushStyle      =   0
      PenColor        =   0
      PenStyle        =   0
      PenWidth        =   0
      PageBorder      =   0
      Header          =   ""
      Footer          =   ""
      TableSep        =   "|;"
      TableBorder     =   7
      TablePen        =   0
      TablePenLR      =   0
      TablePenTB      =   0
      NavBar          =   3
      NavBarColor     =   -2147483633
      ExportFormat    =   0
      URL             =   ""
      Navigation      =   3
      NavBarMenuText  =   "Whole &Page|Page &Width|&Two Pages|Thumb&nail"
   End
   Begin VB.CommandButton cmd_Pause 
      Caption         =   "Pause"
      Height          =   495
      Left            =   6255
      TabIndex        =   0
      Top             =   45
      Width           =   1920
   End
   Begin Project1.ArmGrid grd_Report 
      Height          =   4455
      Left            =   45
      TabIndex        =   4
      Top             =   1275
      Width           =   8220
      _ExtentX        =   14499
      _ExtentY        =   7858
   End
   Begin VB.Label lbl_Interval 
      Height          =   270
      Left            =   45
      TabIndex        =   5
      Top             =   945
      Width           =   3390
   End
   Begin VB.Label lbl_Working 
      Height          =   285
      Left            =   60
      TabIndex        =   3
      Top             =   570
      Width           =   8130
   End
   Begin VSREPORTLibCtl.VSReport vsr_Report 
      Left            =   105
      Top             =   5010
      _rv             =   700
      _rx             =   43125069
      ReportName      =   ""
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      OnOpen          =   ""
      OnClose         =   ""
      OnNoData        =   ""
      OnPage          =   ""
      OnError         =   ""
      MaxPages        =   0
      DoEvents        =   -1  'True
      BeginProperty Layout {8F5A70A3-B6D3-11D3-9A1F-800A5BACB530} 
         Width           =   0
         MarginLeft      =   1440
         MarginTop       =   1440
         MarginRight     =   1440
         MarginBottom    =   1440
         Columns         =   1
         ColumnLayout    =   0
         Orientation     =   0
         PageHeader      =   0
         PageFooter      =   0
         PictureAlign    =   7
         PictureShow     =   1
         PaperSize       =   0
      EndProperty
      BeginProperty DataSource {8F5A70A1-B6D3-11D3-9A1F-800A5BACB530} 
         ConnectionString=   ""
         RecordSource    =   ""
         Filter          =   ""
         MaxRecords      =   0
      EndProperty
      GroupCount      =   0
      SectionCount    =   5
      BeginProperty Section0 {E5849A61-ADD9-11D3-BDEB-000000000000} 
         Name            =   "Detail"
         Visible         =   0   'False
         Height          =   0
         CanGrow         =   -1  'True
         CanShrink       =   0   'False
         KeepTogether    =   -1  'True
         ForcePageBreak  =   0
         BackColor       =   16777215
         Repeat          =   0   'False
         OnFormat        =   ""
         OnPrint         =   ""
      EndProperty
      BeginProperty Section1 {E5849A61-ADD9-11D3-BDEB-000000000000} 
         Name            =   "Header"
         Visible         =   0   'False
         Height          =   0
         CanGrow         =   -1  'True
         CanShrink       =   0   'False
         KeepTogether    =   -1  'True
         ForcePageBreak  =   0
         BackColor       =   16777215
         Repeat          =   0   'False
         OnFormat        =   ""
         OnPrint         =   ""
      EndProperty
      BeginProperty Section2 {E5849A61-ADD9-11D3-BDEB-000000000000} 
         Name            =   "Footer"
         Visible         =   0   'False
         Height          =   0
         CanGrow         =   -1  'True
         CanShrink       =   0   'False
         KeepTogether    =   -1  'True
         ForcePageBreak  =   0
         BackColor       =   16777215
         Repeat          =   0   'False
         OnFormat        =   ""
         OnPrint         =   ""
      EndProperty
      BeginProperty Section3 {E5849A61-ADD9-11D3-BDEB-000000000000} 
         Name            =   "Page Header"
         Visible         =   0   'False
         Height          =   0
         CanGrow         =   -1  'True
         CanShrink       =   0   'False
         KeepTogether    =   -1  'True
         ForcePageBreak  =   0
         BackColor       =   16777215
         Repeat          =   0   'False
         OnFormat        =   ""
         OnPrint         =   ""
      EndProperty
      BeginProperty Section4 {E5849A61-ADD9-11D3-BDEB-000000000000} 
         Name            =   "Page Footer"
         Visible         =   0   'False
         Height          =   0
         CanGrow         =   -1  'True
         CanShrink       =   0   'False
         KeepTogether    =   -1  'True
         ForcePageBreak  =   0
         BackColor       =   16777215
         Repeat          =   0   'False
         OnFormat        =   ""
         OnPrint         =   ""
      EndProperty
      FieldCount      =   0
   End
   Begin VB.Label lbl_Info 
      Alignment       =   2  'Center
      Caption         =   "Batch to send SPA PDF emails"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000040C0&
      Height          =   285
      Index           =   1
      Left            =   90
      TabIndex        =   1
      Top             =   120
      Width           =   5535
   End
End
Attribute VB_Name = "SPA_PDF"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'what is new
' 1.1.4 Added support for SPA Linked Email (JN)

#If LIVE Then
    Private mo_Db                   As Object
#Else
    Private mo_Db                   As ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

Const C_ERRORRAISE As Long = 3000
Const C_PROCESSNAME As String = "SPA_PDF_BATCH" ' for heartbeat

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private ml_U_code As Long
Private mb_Initialized As Boolean
Private m_machineName As String
Private m_heartbeatTimer As Long
Private mb_Paused As Boolean
Private ms_PDFDevice As String
Private ms_TemplatesDir As String
Private ms_AttachmentsDir As String
Private ms_TempPrintFile As String

Private ml_Interval As Long
Private mo_HeartBeat As HeartBeat

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler
    
    grd_Report.Title = "Report"
    
    Call grd_Report.Load_A_COM
    grd_Report.MultiSelect = False
    grd_Report.AllowExcelExport = True
    Call grd_Report.SetColumns(Array( _
      "Time17000Time", _
      "Type5000Type", _
      "Message70000MessageString"))
    
    Dim lb_AdobePrinterFound As Boolean
    Dim ll_Idx As Long
    
    If mb_Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized, "Load_A_COM", "Component already initialized"

    If mo_Db Is Nothing Then Err.Raise ArmErr.PropertyNotSet, "ArmDb", "Property not set"
    If ml_U_code = 0 Then Err.Raise ArmErr.PropertyNotSet, "U_Code", "Property not set"
    If ms_PDFDevice = "" Then Err.Raise ArmErr.PropertyNotSet, "PDFDevice", "Property not set"
    If ms_TempPrintFile = "" Then Err.Raise ArmErr.PropertyNotSet, "TempPrintFile", "Property not set"
    
    
    lb_AdobePrinterFound = False
    
    For ll_Idx = 0 To Printers.Count - 1
        If Printers(ll_Idx).DeviceName = ms_PDFDevice Then
            lb_AdobePrinterFound = True
            'Set Printer = Printers(ll_Idx)
            Exit For
        End If
    Next ll_Idx
    
    
    If Not lb_AdobePrinterFound Then
        Err.Raise ArmErr.CompFncFailed, "PDFDevice", "The printer '" & ms_PDFDevice & "' must be install. The program can not generate PDF without this printer. The program will be terminated."
    End If
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    Dim loNetObject As Object
    Set loNetObject = CreateObject("WScript.Network")
    m_machineName = right(loNetObject.ComputerName, 50)
    Set loNetObject = Nothing
     
    ms_AttachmentsDir = App.Path & "\Attachments\"
    If Not mo_FSO.FolderExists(ms_AttachmentsDir) Then
        Call mo_FSO.CreateFolder(ms_AttachmentsDir)
    End If
    ms_TemplatesDir = App.Path & "\Templates\"
    If Not mo_FSO.FolderExists(ms_TemplatesDir) Then
        Call mo_FSO.CreateFolder(ms_TemplatesDir)
    End If
    
    Set mo_HeartBeat = New HeartBeat
    Call HeartbeatStart
    Call LogMessage(C_PROCESSNAME & " started")
    mb_Initialized = True
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_COM", True)
    End
End Function

Public Function UnLoad_A_COM() As Boolean
On Error GoTo ErrHandler

    Call HeartbeatStop
    Set mo_HeartBeat = Nothing
    Call LogMessage(C_PROCESSNAME & " shutdown")
    Call grd_Report.UnLoad_A_COM
    Set mo_FSO = Nothing
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_COM")
End Function

#If LIVE Then
Public Property Set Db(ByRef aDb As Object)
#Else
Public Property Set Db(ByRef aDb As ArmDb)
#End If
    Set mo_Db = aDb
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Public Property Let U_Code(al_U_Code As Long)
    ml_U_code = al_U_Code
End Property

Public Property Let Interval(al_IntervalMin As Long)
    ml_Interval = al_IntervalMin
End Property

Public Property Get TempPrintFile() As String
    TempPrintFile = ms_TempPrintFile
End Property

Public Property Let TempPrintFile(ByVal as_TempPrintFile As String)
    ms_TempPrintFile = as_TempPrintFile
End Property


Public Property Let PDFDevice(as_PDFDevice As String)
    ms_PDFDevice = as_PDFDevice
End Property

Private Sub HeartbeatStart()
On Error GoTo ErrHandler

    Call mo_HeartBeat.HeartBeatConfig(mo_Db, C_PROCESSNAME)

    If mo_HeartBeat.HeartbeatTimer > 0 Then
        ' chck if other instance is running
        If Not mo_HeartBeat.HeartbeatTest(mo_Db, C_PROCESSNAME) Then
            ' exit app
            Err.Raise ArmErr.CompFncFailed, "HeartBeatConfig", "Another instance is running for process: " & C_PROCESSNAME
            End
        End If
        
        Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, True)
        lbl_Interval.Caption = "Interval: " & CLng(mo_HeartBeat.HeartbeatTimer / 60) & " minutes"
    Else
        Err.Raise ArmErr.CompFncFailed, "HeartBeatConfig", "Heartbeat not configured properly for process: " & C_PROCESSNAME
    End If
    Timer1.Interval = 5000
    Timer1.Enabled = True
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".HeartbeatStart")
End Sub

Private Sub HeartbeatStop()
On Error GoTo ErrHandler

    Timer1.Enabled = False
    Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, False)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".HeartbeatStop")
End Sub

Private Function SendMail(ByVal as_Addresses_To As String, ByVal as_Subject As String, ByVal as_Message As String, ByVal as_Attachment As String) As Long
On Error GoTo ErrHandler

    Dim lo_MailClient   As MailClient
    Dim ll_Idx               As Long
    Dim ls_Path As String, ls_FileName As String
    Dim ll_retVal As Long

    SendMail = -1

    ll_Idx = InStrRev(as_Attachment, "\")
    If ll_Idx > 0 Then
        ls_Path = Left(as_Attachment, ll_Idx - 1)
        ls_FileName = Mid(as_Attachment, ll_Idx + 1)
    Else
        ls_Path = ""
        ls_FileName = as_Attachment
    End If
    ' init MailClient
    Set lo_MailClient = New MailClient
    Set lo_MailClient.ArmDb = mo_Db
    lo_MailClient.U_Code = ml_U_code
    lo_MailClient.Load_A_COM

    ' set account which will be used by MailClient
    ' all emails have from address automatically set to SPA Approval account
    Call lo_MailClient.SetActiveMailBox("SPA Approval")

    ll_Idx = lo_MailClient.AddEmail(as_Subject, as_Message, False, Now, "")
    Call lo_MailClient.AddEmailAddress(ll_Idx, as_Addresses_To, etEmailTo)
    Call lo_MailClient.AddAttachment(ll_Idx, ls_Path, ls_FileName)
    ll_retVal = lo_MailClient.SendEmail(ll_Idx)

    ' Unload MailClient
    lo_MailClient.UnLoad_A_COM
    Set lo_MailClient = Nothing
    
    SendMail = ll_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SendMail")
End Function



Private Sub Timer1_Timer()
On Error GoTo ErrHandler

    If mb_Paused Then
        Timer1.Enabled = False
        Exit Sub
    End If

    If mo_HeartBeat.HeartbeatTimer = 0 Then
        Exit Sub
    End If
    
    Screen.MousePointer = vbHourglass
    ' update heartbeat
    If mo_HeartBeat.HeartBeatHit(mo_Db, C_PROCESSNAME) Then
        Timer1.Enabled = False
        cmd_Pause.Enabled = False
        
        lbl_Working.Caption = "SPA - Start: " & Now
        Call Process
        lbl_Working.Caption = "Timer Waiting. Last checked: " & Now
        
        cmd_Pause.Enabled = True
        Timer1.Enabled = True
    End If
    Screen.MousePointer = vbDefault

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Timer1_Timer")
    lbl_Working.Caption = "Error detected"
    cmd_Pause.Enabled = True
    Timer1.Enabled = True
    Screen.MousePointer = vbDefault
End Sub

Private Sub cmd_Pause_Click()
On Error GoTo ErrHandler
    
    If mb_Paused Then
        mb_Paused = False
        cmd_Pause.Caption = "Pause"
        lbl_Working.Caption = "Timer Waiting"
        Call HeartbeatStart
        Call LogMessage(C_PROCESSNAME & " continue running")
    Else
        mb_Paused = True
        cmd_Pause.Caption = "Continue"
        lbl_Working.Caption = "Stop by user - waiting user to press continue."
        Call HeartbeatStop
        Call LogMessage(C_PROCESSNAME & " paused")
    End If
        
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Pause_Click")
    mb_Paused = True
    cmd_Pause.Caption = "Continue"
    lbl_Working.Caption = "Stop by user - waiting user to press continue."
    Timer1.Enabled = False
End Sub


Private Function DownloadTemplate(ByVal as_DownloadFolder As String, ByVal al_SPDTZ_Id As Long) As String
On Error GoTo ErrHandler
    
Const REQ_TEMPLATE_DOWNLOAD As String = "EXEC SPA_DocumentTemplateZip_sel $SPDTZ_ID$"
    
    Dim ls_ret  As String
    Dim ls_Request As String
    ls_ret = ""
    
    Dim ls_zipFile As String
    ls_zipFile = as_DownloadFolder & al_SPDTZ_Id
    
    ls_Request = ReplacePlaceHolder(REQ_TEMPLATE_DOWNLOAD, "$SPDTZ_ID$", al_SPDTZ_Id)
    If mo_Db.BlobToFileSQL(ls_Request, ls_zipFile, True, False) Then
    
        If mo_Db.DecompressFile(ls_zipFile, ls_zipFile & ".DIR\", True, True) Then
            ls_ret = ls_zipFile & ".DIR\" & "SPATmp.xml"
            
            If Not mo_FSO.FileExists(ls_ret) Then
                Err.Raise ArmErr.CompFncFailed, "FileExists", "Template not found: " & ls_ret
            End If
        Else
            Err.Raise ArmErr.CompFncFailed, "DecompressFile", "Template decompress failed: " & ls_zipFile
        End If
    Else
        Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "Template download failed: " & ls_Request
    End If
    
    DownloadTemplate = ls_ret
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".DownloadTemplate")
End Function

Private Sub Process()
On Error GoTo ErrHandler

Const REQ_SPA_DOCUMENT_TO_SEND_LST = "exec SPA_Document_To_Send_lst"
    
    Dim lc_Cursor As Long
    Dim lo_ArmVSPrint As ArmVSPRint
    
    lc_Cursor = OpenSQLSafe(mo_Db, REQ_SPA_DOCUMENT_TO_SEND_LST)
    If mo_Db.RowCount(lc_Cursor) > 0 Then
    
        Call LogMessage("SPA to send detected. Count: " & mo_Db.RowCount(lc_Cursor))
        
        Set lo_ArmVSPrint = New ArmVSPRint
        Set lo_ArmVSPrint.VSPrinterRef = vsp_Printer
        Set lo_ArmVSPrint.VSReportRef = vsr_Report
        lo_ArmVSPrint.TempPrintFile = ms_TempPrintFile
        Call lo_ArmVSPrint.Load_A_COM
        
        Call mo_Db.First(lc_Cursor)
        Do While Not mo_Db.EOF(lc_Cursor)
        
            Call PrintAndSendPDF(lo_ArmVSPrint, lc_Cursor)
            Call mo_Db.Next(lc_Cursor)
        Loop
        Call lo_ArmVSPrint.UnLoad_A_COM
        Set lo_ArmVSPrint = Nothing
    End If
    Call mo_Db.Close(lc_Cursor)
    Exit Sub
ErrHandler:
    Call mo_Db.Close(lc_Cursor)
    Call ErrorHandler(Extender.Name & ".Process")
End Sub

Private Function PrintAndSendPDF(ByVal ao_ArmVSPrint As ArmVSPRint, ByVal ac_Cursor As Long) As Boolean
On Error GoTo ErrHandler

Const REQ_SPA_DOCUMENT_UPD = "exec SPA_Document_upd $SPD_ID$, $EML_CODE$"
    
Dim ls_Template As String
Dim ls_Subject As String, ls_Attachment As String, ls_Body As String, ls_Email As String
Dim ls_Request As String, ls_SPD_Id As String, ls_SPA_Id As String
Dim ll_CodePage As Long

    PrintAndSendPDF = False
    ls_SPD_Id = mo_Db.GetFields(ac_Cursor, "SPD_ID")
    ls_SPA_Id = mo_Db.GetFields(ac_Cursor, "SPA_ID")
    ls_Email = mo_Db.GetFields(ac_Cursor, "email")
    ls_Subject = ReplaceCursorPlaceHolder(mo_Db.GetFields(ac_Cursor, "SPTD_Subject"), ac_Cursor)
    ls_Body = ReplaceCursorPlaceHolder(mo_Db.GetFields(ac_Cursor, "SPTD_Body"), ac_Cursor)
    ls_Attachment = ms_AttachmentsDir & "SPA" & ls_SPA_Id & ".PDF"
    
    ls_Template = DownloadTemplate(ms_TemplatesDir, mo_Db.GetFields(ac_Cursor, "SPDTZ_Id"))
    Call ao_ArmVSPrint.LoadTemplate(ls_Template, "SPA")
    ao_ArmVSPrint.SerializedString = mo_Db.GetFields(ac_Cursor, "SRZ_FIELDS")
    
    ll_CodePage = GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(ac_Cursor, "Language_Code"))
    ao_ArmVSPrint.Charset = GetCharSetFromCodePage(ll_CodePage)
    ao_ArmVSPrint.FontName = "Arial"
    
    Call ao_ArmVSPrint.PrintPreview
    
    ' print preview to PDF file
    If ao_ArmVSPrint.PrintToFile(ms_PDFDevice, ls_Attachment) Then
        ' send email
        Dim ll_EML_Code As Long
        ll_EML_Code = SendMail(ls_Email, ls_Subject, ls_Body, ls_Attachment)
        Call mo_FSO.DeleteFile(ls_Attachment)
        ' mark document as sent
        If ll_EML_Code <> -1 Then
            ls_Request = ReplacePlaceHolder(REQ_SPA_DOCUMENT_UPD, "$SPD_ID$", SQLStr(ls_SPD_Id))
            ls_Request = ReplacePlaceHolder(ls_Request, "$EML_CODE$", ll_EML_Code)
            Call ExecuteSQLSafe(mo_Db, ls_Request, 1)
            Call LogMessage("SPA: " & ls_SPA_Id & " document: " & ls_SPD_Id & " sent to " & ls_Email)
            PrintAndSendPDF = True
        End If
    Else
        Err.Raise ArmErr.CompFncFailed, "PrintToFile", "Device '" & ms_PDFDevice & "' failed print to file: " & ls_Attachment
    End If
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".PrintAndSendPDF SPD_Id=" & ls_SPD_Id)
End Function

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_CodePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_CodePage = CLng(mo_Db.GetFields(ll_Cursor, "Code_Page"))
    Call mo_Db.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_CodePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

    Call grd_Report.Move(0, lbl_Interval.Top + lbl_Interval.Height, UserControl.Width, UserControl.Height - (lbl_Interval.Top + lbl_Interval.Height))
    Exit Sub
ErrHandler:
End Sub

Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String, Optional ByVal ab_ShowMsgbox As Boolean = False)
    Dim ll_oldMP As MousePointerConstants
    Dim ls_Message As String
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    ls_Message = App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & "."
    Call LogMessage(ls_Message, "E", False)
    If ab_ShowMsgbox Then MsgBox ls_Message
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    Call AddMessageToGrid(as_logMsg, as_logType)
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_code))
    ls_req = Replace(ls_req, "$APP$", Left(Trim(SQLStr(App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)), 50))
    ls_req = Replace(ls_req, "$MSG$", right(Trim(SQLStr(as_logMsg)), 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(C_PROCESSNAME & ".LogMessage - " & Err.Number & ": " & Err.Description)

End Sub

Private Sub AddMessageToGrid(ByVal as_Message As String, Optional ByVal as_logType As String = "I")
On Error GoTo ErrHandler
    
    If grd_Report.Rows = 0 Then
        Call grd_Report.AddLine(Array(Now, as_logType, as_Message))
    Else
        Call grd_Report.InsertLine(0, Array(Now, as_logType, as_Message))
    End If
    
    If as_logType = "E" Then
        grd_Report.LineColor(0) = vbRed
    End If
        
    If grd_Report.Rows > 1000 Then
        grd_Report.Row = grd_Report.Rows - 1
        Call grd_Report.DeleteLine
        grd_Report.Row = 0
    End If
    Exit Sub
ErrHandler:
End Sub
' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
'    Debug.Print 1 / 0
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:
    ao_DB.Close (lc_Data)
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")

End Function

' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

Private Function ReplaceCursorPlaceHolder(ByVal as_Request As String, ByVal ac_Cursor As Long) As String
On Error GoTo ErrHandler
    Dim ll_Idx As Long
    
    
    For ll_Idx = 0 To mo_Db.FieldCount(ac_Cursor) - 1
        as_Request = ReplacePlaceHolder(as_Request, "$" & mo_Db.GetFieldName(ac_Cursor, ll_Idx) & "$", mo_Db.GetFields(ac_Cursor, ll_Idx))
    Next
    ReplaceCursorPlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCursorPlaceHolder")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function

Private Function SQLStr(ByVal as_str As String) As String
    SQLStr = "'" & Replace(as_str, "'", "''") & "'"
End Function

