﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using System.ServiceProcess;


namespace MMG_Service
{
    [RunInstaller(true)]
    public partial class MMG_ServiceInstaller : Installer
    {
        private ServiceInstaller mMMG_ServiceInstaller;
        private ServiceProcessInstaller mProcessInstaller;
        
        public MMG_ServiceInstaller()
        {
            InitializeComponent();

            mProcessInstaller = new ServiceProcessInstaller();
            mMMG_ServiceInstaller = new ServiceInstaller();

//            base.Committed += new InstallEventHandler(MMG_SrvcInstaller_Committed);

            mProcessInstaller.Account = ServiceAccount.LocalSystem;

            mMMG_ServiceInstaller.StartType = ServiceStartMode.Manual;
            mMMG_ServiceInstaller.ServiceName = "MMG_Service";
            mMMG_ServiceInstaller.Description = "Armstrong service to upload 'full' blobs for Media manager.";

            Installers.Add(mMMG_ServiceInstaller);
            Installers.Add(mProcessInstaller);
        }
        void MMG_SrvcInstaller_Committed(object sender, InstallEventArgs e)
        {
            ServiceController controller = new ServiceController(mMMG_ServiceInstaller.ServiceName);

            // start the service
            try
            {
                controller.Start();
            }
            catch (Exception ex)
            {
                String source = "MMG_Service Installer";
                String log = "Application";
                if (!System.Diagnostics.EventLog.SourceExists(source))
                {
                    System.Diagnostics.EventLog.CreateEventSource(source, log);
                }

                System.Diagnostics.EventLog eLog = new System.Diagnostics.EventLog();
                eLog.Source = source;

                eLog.WriteEntry(@"The service could not be started. Please start the service manually. Error: " + ex.Message, System.Diagnostics.EventLogEntryType.Error);
            }
        }
    }
}
