﻿using System;
using System.Threading;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using System.Runtime.InteropServices;
using System.IO;

namespace MMG_Service
{
    public partial class MMG_Service : ServiceBase
    {
        [DllImport("Kernel32.dll")] public static extern bool Beep(UInt32 frequency, UInt32 duration);
        const string SCREEN_NAME = "MMG service";
        const string HB_NAME = "MMG_Service";

#if ENV_LOCAL
        const string C_SERVER = "localhost";
        const string C_DB = "LOCAL_SIFYB2";
        const string C_USER = "sa";
        const string C_PASS = "alfa";
#endif

#if ENV_DEV
        const string C_SERVER = "UXBDB020\APOLLOD";
        const string C_DB = "SIFYB2";
        const string C_USER = "jnagy";
        const string C_PASS = "jnagy"; 
#endif

#if ENV_TEST
        const string C_SERVER = "UXBDB020\APOLLOT";
        const string C_DB = "SIFYB2";
        const string C_USER = "capture";
        const string C_PASS = "c"; 
#endif

#if ENV_LIVE
        const string C_SERVER = "UKDC-CAPPRD1.apollo.local";
        const string C_DB = "SIFYB2";
        const string C_USER = "batchabp";
        const string C_PASS = "art3m1s";
#endif

        const string    C_A_CONFIG_PATH     = "MMG_ServiceDir";
        const string    C_A_CONFIG_INTERVAL = "MMG_WaitTime";
        const string    C_ERROR_FILES       = "Bad_Files";

        string                      ms_BLOBPath = "";                      // path to directory where to search for pdf files
        static string               ms_errorFile = "";
        private static Mutex        mo_mutex = null;
        Timer                       mo_timer = null;
        public static ARMSYSCOMLib.ArmDB   mo_armDB = null;
        CArmHeartBeat               mo_heartBeat = new CArmHeartBeat();


        public MMG_Service()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            try
            {
                LogToFile("Starting ....");
                // create armsyscom
                if (mo_armDB == null)
                {
                    try
                    {
                        mo_armDB = new ARMSYSCOMLib.ArmDB();
                    }
                    catch (Exception ex)
                    {
                        LogToFile("ArmSysCOM not present!!");
                        LogToFile(ex.StackTrace);
                        LogToFile(ex.Message);
                    }

                }
                if (mo_armDB == null) return;

                if (mo_timer == null)
                {
                    mo_mutex = new Mutex(true);
                    // 30sec for the first time to let system to boot
                    mo_timer = new Timer(new TimerCallback(mo_timer_Elapsed), mo_mutex, 30000, 30000);
                }
                else
                {
                    if (mo_mutex == null)
                    {
                        LogToFile("Cannot get mutex");
                    }
                    // get mutex
                    mo_mutex.WaitOne();
                }

                // reset BLOB_Path
                ms_BLOBPath = "";
                mo_timer.Change(30000, 30000);

                // timer can start
                mo_mutex.ReleaseMutex();
            }
            catch (Exception ex)
            {
                LogToFile(ex.StackTrace);
                LogToFile(ex.Message);
                LogToFile("Started with errors!!!");
            }
        }

        protected override void OnStop()
        {
            try
            {
                if (mo_mutex == null) return;
                if (mo_timer == null) return;

                // wait until timer finish his job
                mo_mutex.WaitOne();

                if (mo_heartBeat.Enabled) mo_heartBeat.HeartBeatEnable(HB_NAME, false);
                if (mo_timer != null)
                {
                    mo_timer.Change(Timeout.Infinite, Timeout.Infinite);
                    ms_BLOBPath = "";
                    LogError("Service stopped.", "E");
                }
            }
            catch (Exception ex)
            {
                LogToFile(ex.StackTrace);
                LogToFile(ex.Message);
                LogToFile("Stopped with errors!!!");
            }
            finally
            {
                DisconnectSQL();
                mo_mutex.ReleaseMutex();
            }
        }

        void mo_timer_Elapsed(Object _config)
        {
            try
            {
                if (!mo_mutex.WaitOne(0,true)) return;      // wait 0 ms else return probably job is too long

                if (ms_BLOBPath == "")
                {
                    // read A_Config entries
                    ms_BLOBPath = Get_A_Config(C_A_CONFIG_PATH).Trim();

                    if (ms_BLOBPath.Length > 2)
                    {
                        // check if path exists or cteate it
                        if (!System.IO.Directory.Exists(ms_BLOBPath + "\\" + C_ERROR_FILES))
                        {
                            Directory.CreateDirectory(ms_BLOBPath + "\\" + C_ERROR_FILES);
                        }
                        ms_errorFile = ms_BLOBPath + "\\" + C_ERROR_FILES + "\\logfile.txt";

                        double _timerInterval = System.Double.Parse(Get_A_Config(C_A_CONFIG_INTERVAL));
                        mo_timer.Change(0,(int)(_timerInterval * 1000));

                        LogError("BLOB path configured:" + ms_BLOBPath, "I");
//                        AddToLog(ms_BLOBPath);

                        // configure heartbeat
                        if (mo_heartBeat.HeartBeatConfig(HB_NAME))
                        {
                            if (mo_heartBeat.HeartbeatTest(HB_NAME))
                            {
                                mo_heartBeat.HeartBeatEnable(HB_NAME, true);
                            }
                            else
                            {
                                LogError("HeartBeat test failed!", "E");
//                                AddToLog("HeartBeat test failed!");
                            }
                        }
                        else
                        {
                            LogError("HeartBeat config failed!", "E");
//                            AddToLog("HeartBeat config failed!");
                        }
                    }
                    else
                    {
                        LogError("Wrong config value for " + C_A_CONFIG_PATH + ".", "E");
//                        AddToLog("Wrong config value for " + C_A_CONFIG_PATH + ".");
                        // disconnect and wait nex 30 sec for good a_config value
                        DisconnectSQL();
                        ms_BLOBPath = "";
                    }
                }

                if (ms_BLOBPath != "")
                {
                    if (mo_heartBeat.Enabled) mo_heartBeat.HeartBeatHit(HB_NAME);

                    // do upload
                    if (UploadFiles())
                    {
                        // we are sql connected and there are some changes done to a directory
                        //beepTime();
                    }
                }
            }
            catch (Exception ex)
            {
                LogMessage(ex, "E");
            }
            finally
            {
                if (mo_armDB.IsConnected != 0)
                {
                    DisconnectSQL();
                }
            }
            // must be ouside of finally, otherwise call fail
            mo_mutex.ReleaseMutex();
        }

        public static void beepTime()
        {
            Beep(700, 200);
            System.Threading.Thread.Sleep(300);
        }
        private static bool ConnectSQL(string _server, string _database, string _user, string _password)
        {
            if (mo_armDB == null)
            {
                MMG_Service.LogToFile("Connect failed! Armsyscom no present!");
                return false;
            }
            if (mo_armDB.Connect(_server, _database, _user, _password, "MMG service") == 0)
            {
                return false;
            }

            return true;
        }

        private static void DisconnectSQL()
        {
            if (mo_armDB != null) mo_armDB.Disconnect();
        }

        public static int OpenSQLSafe(string as_Request)
        {
            if (mo_armDB.IsConnected == 0)
            {
                if (!ConnectSQL(C_SERVER, C_DB, C_USER, C_PASS))
                {
                    throw new System.Data.DataException("CURSOR NOT OPENED: " + as_Request);
                }
            }

            int lc_Data;
            lc_Data = mo_armDB.OpenSQL(as_Request, -1, -1);
            if( lc_Data == 0)
            {
                throw new System.Data.DataException("SQL ERROR: " + ConcatSQLErrors());
            }

            return lc_Data;
        }
        public static void ExecuteSQLSafe(string as_Request)
        {
            if (mo_armDB.IsConnected == 0)
            {
                if (!ConnectSQL(C_SERVER, C_DB, C_USER, C_PASS))
                {
                    throw new System.Data.DataException("REQUEST NOT EXECUTED: " + as_Request);
                }
            }

            // First execute the request
            if ( mo_armDB.ExecuteSQL(as_Request) == 0) 
            {
                throw new System.Data.DataException("SQL ERROR: " + ConcatSQLErrors());
            }
        }
        private void ExecuteSQLSafeFile(string as_Request, FileInfo ao_fileToMove)
        {
            if (mo_armDB.IsConnected == 0)
            {
                if (!ConnectSQL(C_SERVER, C_DB, C_USER, C_PASS))
                {
                    throw new System.Data.DataException("FILE NOT PROCESSED: " + as_Request);
                }
            }

            // First execute the request
            if (mo_armDB.ExecuteSQL(as_Request) == 0)
            {
                string ls_err = "SQL ERROR: " + ConcatSQLErrors();
                MoveFileToBadFiles(ao_fileToMove);
                throw new System.Data.DataException(ls_err);
            }
        }

        private static string sqlStr(string _str, int _maxLen)
        {
            if (_maxLen < _str.Length) _str = _str.Substring(0, _maxLen);
            return "'" + _str.Replace("'", "''") + "'";
        }
        private string Get_A_Config(string as_Key)
        {
            int ll_Curs = 0;
            string ls_req;
            string ls_retVal = "";

            try
            {
                ls_req = "select cfg_value from A_config where cfg_Key ='" + as_Key.ToUpper() + "'";
                ll_Curs = OpenSQLSafe(ls_req);

                if (mo_armDB.get_RowCount(ll_Curs) > 0)
                {
                    object _param = 0;
                    ls_retVal = (string)mo_armDB.GetFields(ll_Curs, ref _param);
                }
            }
            finally
            {
                if(ll_Curs > 0 ) mo_armDB.Close (ll_Curs);
                ll_Curs = 0;
            }

            return ls_retVal;
        }

        // logs message to database
        public static void LogMessage(Exception e, string as_logType)
        {
            LogError(e.StackTrace + " : " + e.Message, as_logType);
        }
        private static void LogError(string as_logMsg, string as_logType)
        {
            if (mo_armDB.IsConnected == 0)
            {
                if (!ConnectSQL(C_SERVER, C_DB, C_USER, C_PASS))
                {
                    // log into file
                    MMG_Service.LogToFile(as_logMsg);
                    return;
                }
            }

            const string LOG_REQUEST = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$";

            string ls_req = LOG_REQUEST.Replace("$UCODE$", "0");
            ls_req = ls_req.Replace("$LOGTYPE$", sqlStr(as_logType, 1));
            ls_req = ls_req.Replace("$MSG$", sqlStr(as_logMsg, 4000));
            ls_req = ls_req.Replace("$APP$", sqlStr(System.Reflection.Assembly.GetExecutingAssembly().GetName().Name + " " +
                                                    System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString(), 50));

            if (mo_armDB.ExecuteSQL(ls_req) == 0)
            {
                // log into file
                MMG_Service.LogToFile("SQL ERROR: " + ConcatSQLErrors());
            }
        }
        public static void LogToFile(string _message)
        {
            if (ms_errorFile == "")
            {
                MMG_Service.AddToLog(_message);
                return;
            }

            StreamWriter log;

            if (!File.Exists(ms_errorFile))
            {
                log = new StreamWriter(ms_errorFile);
            }
            else
            {
                log = File.AppendText(ms_errorFile);
            }

            // Write to the file:
            log.WriteLine(DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToShortTimeString() + ": " + _message);

            // Close the stream:
            log.Close();
        }
        private static string ConcatSQLErrors()
        {
            string ls_ret = "";
            if (mo_armDB.SQLErrorMessages.Equals(null)) return ls_ret;

            Object arrObj = mo_armDB.SQLErrorCodes;
            Object[] av_arrL = (Object[])arrObj;
            arrObj = mo_armDB.SQLErrorMessages;
            Object[] av_arrS = (Object[])arrObj;

            Debug.Assert(av_arrS.Length == av_arrL.Length);
            for (long _i = 0; _i < av_arrL.Length; _i++)
            {
                if (ls_ret != "") ls_ret = ls_ret + ", ";
                ls_ret = ls_ret + av_arrL[_i].ToString() + ":" + av_arrS[_i];
            }

            return ls_ret;
        }

        private bool UploadFiles()
        {
            bool _retVal = false;
            DirectoryInfo lo_folder = new DirectoryInfo(ms_BLOBPath);
            FileInfo[] lo_Files = lo_folder.GetFiles("*.*",SearchOption.TopDirectoryOnly);

            foreach( FileInfo lo_File in lo_Files)
            {
                _retVal = _retVal | SendToSql(lo_File);
            }
            return _retVal;
        }

        private bool SendToSql(FileInfo ao_file)
        {
            const string C_REQ_INS = "EXEC Media_Zip_ins $ZipCode$, ?";
            const string C_REQ_INS_LNK = "EXEC Media_BlobLink_ins '$MD_Code$', $ZipCode$, '$Type$', 0, 0";

            string[] lsa_pieces;
            Debug.Assert (ao_file != null);
    
            if( FileInUse(ao_file.FullName) ) return false;
    
            // FILE FORMAT PR_[PRP_ID]_[TBL_INDEX]_[PRP_STATUS]_[login]_[PC_NAME].PDF
            lsa_pieces = ao_file.Name.Split( '_');
            Debug.Assert (lsa_pieces.Length  >= 3);

            if (lsa_pieces.Length < 3)
            {
                MoveFileToBadFiles(ao_file);
                return false;
            }
    
            // here we will need sql connection
            if (mo_armDB.IsConnected == 0)
            {
                if (!ConnectSQL(C_SERVER, C_DB, C_USER, C_PASS)) return false;
            }
    
            string ls_req_ins = "";

            ls_req_ins = C_REQ_INS.Replace("$ZipCode$", lsa_pieces[1]);
    
            if(mo_armDB.FileToBlobSQL(ls_req_ins, ao_file.FullName, 0, 0) == 0 )
            {
                string ls_err = "SQL BLOB ERROR (" + ao_file.FullName + "): " + ConcatSQLErrors();
                MoveFileToBadFiles(ao_file);
                throw new System.Data.DataException(ls_err);
            }

            // Create link
            ls_req_ins = C_REQ_INS_LNK.Replace("$ZipCode$", lsa_pieces[1]);
            ls_req_ins = ls_req_ins.Replace("$MD_Code$", lsa_pieces[0]);
            ls_req_ins = ls_req_ins.Replace("$Type$", lsa_pieces[2]);

            ExecuteSQLSafeFile(ls_req_ins,ao_file );

            // delete file
            ao_file.Delete();

            return true;
        }

        private void MoveFileToBadFiles(FileInfo ao_file)
        {
            string _origoName = ao_file.Name;
            string _newName = ao_file.Name;
            int _counter = 0;
            while (System.IO.File.Exists(ms_BLOBPath + "\\" + C_ERROR_FILES + "\\" + _newName))
            {
                _counter++;
                _newName = ao_file.Name.Substring(0, ao_file.Name.Length - ao_file.Extension.Length) + "_" + _counter + ao_file.Extension;
            }

            ao_file.MoveTo(ms_BLOBPath + "\\" + C_ERROR_FILES + "\\" + _newName);
            LogError(_origoName + " moved to " + ao_file.FullName + ".", "E");
        }

        public static void AddToLog(string message)
        {
            String source = "MMG_Service";
            String log = "Media mamanger Log";
            if (!System.Diagnostics.EventLog.SourceExists(source))
            {
                System.Diagnostics.EventLog.CreateEventSource(source, log);
            }

            System.Diagnostics.EventLog eLog = new System.Diagnostics.EventLog();
            eLog.Source = source;

            eLog.WriteEntry(message);

        }

        bool FileInUse(string path)
        {
            try
            {
                //Just opening the file as open/create
                using (FileStream fs = new FileStream(path, FileMode.OpenOrCreate))
                {
                    //If required we can check for read/write by using fs.CanRead or fs.CanWrite
                }
                return false;
            }
            catch
            {
                return true;
            }
        }

        private string Join(string[] _array, string _glue)
        {
            string _retVal = "@";

            foreach( string _part in _array)
            {
                if( _retVal == "@" ) _retVal = _part;
                else _retVal += _glue + _part;
            }

            return _retVal;
        }
    }
}
