﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MMG_Service
{
    class CArmHeartBeat
    {
        int m_heartbeatTimer;
        bool m_heartbeatEnabled;
        String m_machineName;
        DateTime md_last_time;

        public CArmHeartBeat()
        {
            m_heartbeatEnabled = false;
        }
        
        // Get Heartbeat Enabled
        public bool Enabled
        {
            get{ return m_heartbeatEnabled; }
        }

        // Get HeartbeatTimer value
        public long HeartbeatTimer
        {
            get{ return m_heartbeatTimer; }
        }

        public bool HeartbeatTest(string as_processName )
        {
            if (!m_heartbeatEnabled) return false;

            const string C_REQ = "EXEC A_Heartbeat_test '$PROCESSNAME$'";
            bool lb_retVal = false;

            string ls_req = C_REQ.Replace( "$PROCESSNAME$", as_processName);
            int ll_Cursor = MMG_Service.OpenSQLSafe(ls_req);

            object _param = "diff";
            int ll_diff = (int)MMG_Service.mo_armDB.GetFields(ll_Cursor, ref _param);

            _param = "HB_checkin_date";
            lb_retVal = ((DateTime)MMG_Service.mo_armDB.GetFields(ll_Cursor, ref _param)) == new DateTime(1899, 12,30,0,0,0,0);     //12/30/1899 12:00:00 AM

            _param = "HB_CFG_check"; 
            int ll_check = (int)MMG_Service.mo_armDB.GetFields(ll_Cursor, ref _param);

            MMG_Service.mo_armDB.Close(ll_Cursor);

            if((!lb_retVal) && (ll_diff > ll_check))
            {
                // it seems that other batch is crashed or is paused
                // log it as error and contune with this instance
                // Call LogMessage("Detected second instance.", "E")
                lb_retVal = true;
            }            

            return lb_retVal;
        }

        public bool HeartBeatConfig(string as_processName)
        {
            const string C_REQ = "EXEC A_Heartbeat_CFG '$PROCESSNAME$'";
            m_machineName = System.Environment.MachineName;

            string ls_req = C_REQ.Replace( "$PROCESSNAME$", as_processName);
            int ll_Cursor = MMG_Service.OpenSQLSafe(ls_req);

            if (MMG_Service.mo_armDB.get_RowCount(ll_Cursor) == 1)
            {
                object _param = "HB_CFG_timer";
                m_heartbeatTimer = (int)MMG_Service.mo_armDB.GetFields(ll_Cursor, ref _param);
                m_heartbeatEnabled = true;

                MMG_Service.mo_armDB.Close(ll_Cursor);
                return true;
            }else{
                m_heartbeatTimer = 0;
                m_heartbeatEnabled = false;
                MMG_Service.mo_armDB.Close(ll_Cursor);
                return false;
            }
        }

        public bool HeartBeatHit(string as_processName)
        {
            if (!m_heartbeatEnabled) return false;

            const string C_REQ = "EXEC A_Heartbeat_update '$PROCESSNAME$'";

            if (md_last_time.AddSeconds(m_heartbeatTimer) < DateTime.Now)
            {
                md_last_time = DateTime.Now;

                // update heartbeat
                string ls_req = C_REQ.Replace( "$PROCESSNAME$", as_processName );
                MMG_Service.ExecuteSQLSafe(ls_req);
                
                return true;
            }
            return false;
        }

        public void HeartBeatEnable(string as_processName, bool ab_Enable)
        {
            if (!m_heartbeatEnabled) return;

            try
            {
            const string C_REQ = "EXEC A_Heartbeat_set '$PROCESSNAME$', '$MACHINE$', '$APPPATH$', '$VER$', '$RUNNING$'";

            System.Reflection.Assembly _assembly = System.Reflection.Assembly.GetExecutingAssembly();
            System.Reflection.AssemblyName assemblyName = _assembly.GetName();

            string ls_req = C_REQ.Replace("$PROCESSNAME$", as_processName);
            ls_req = ls_req.Replace("$MACHINE$", m_machineName);
            ls_req = ls_req.Replace("$APPPATH$", _assembly.Location);
            ls_req = ls_req.Replace("$VER$", assemblyName.Version.ToString(2));
            ls_req = ls_req.Replace("$RUNNING$", ab_Enable ? "X" : "");

            MMG_Service.ExecuteSQLSafe(ls_req);
            }
            catch (Exception ex)
            {
                MMG_Service.LogMessage(ex, "E");
            }
        }
    }
}
