VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SvcXMLParam"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

#If LIVE = 1 Then
Private mo_XML As Object
#Else
Private mo_XML As MSXML2.DOMDocument
#End If

#If LIVE = 1 Then
Private Property Get PARAMS() As Object
#Else
Private Property Get PARAMS() As MSXML2.IXMLDOMElement
#End If
On Error GoTo errorHandler
    If mo_XML Is Nothing Then
        Set mo_XML = CreateObject("MSXML2.DOMDocument")
#If LIVE = 1 Then
        Dim lo_elem As Object
#Else
        Dim lo_elem As IXMLDOMElement
#End If
        
        Set lo_elem = mo_XML.createElement("PARAMS")
        Call mo_XML.appendChild(lo_elem)
        Call lo_elem.setAttribute("type", "struct")
    End If
    Set PARAMS = mo_XML.firstChild
    Exit Property
errorHandler:
    Call errorHandler("SvcXMLParam.Get PARAMS")
End Property


Public Function AddStruct(ByVal as_structName As String) As Boolean
On Error GoTo errorHandler
    If AppendElement(PARAMS, as_structName, Array(Array("type", "struct"))) Is Nothing Then
        AddStruct = False
    Else
        AddStruct = True
    End If
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.AddStruct")
End Function

Public Function AddTable(ByVal as_tableName As String)
On Error GoTo errorHandler
#If LIVE = 1 Then
    Dim lo_newTable As Object
#Else
    Dim lo_newTable As MSXML2.IXMLDOMElement
#End If
    Set lo_newTable = AppendElement(PARAMS, as_tableName, Array(Array("type", "table")))
    If lo_newTable Is Nothing Then
        AddTable = False
    Else
        ' add <ROWS> element
        Call AppendElement(lo_newTable, "ROWS")
        AddTable = True
    End If
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.AddTable")
End Function

' add parameter to structure
Public Function AddParameter(ByVal as_structName As String, ByVal as_paramName As String, ByVal as_paramValue As String) As Boolean
On Error GoTo errorHandler
    AddParameter = False
#If LIVE = 1 Then
    Dim lo_structNode As Object
    Dim lo_newNode As Object
#Else
    Dim lo_structNode As MSXML2.IXMLDOMElement
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    If as_structName <> "" Then Set lo_structNode = PARAMS.selectSingleNode(as_structName)
    If lo_structNode Is Nothing Then Set lo_structNode = PARAMS
    Debug.Assert (lo_structNode.Attributes.getNamedItem("type").Text = "struct")
    Set lo_newNode = AppendElement(lo_structNode, as_paramName)
    If Not lo_newNode Is Nothing Then
        lo_newNode.Text = as_paramValue
        AddParameter = True
    End If
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.AddParameter")
End Function

Public Function AddTableRow(ByVal as_tableName As String, ByRef aoa_cols As Variant) As Boolean
On Error GoTo errorHandler
    AddTableRow = False
#If LIVE = 1 Then
    Dim lo_tableNode As Object
    Dim lo_rowsNode As Object
    Dim lo_newRowNode As Object
    Dim lo_newNode As Object
#Else
    Dim lo_tableNode As MSXML2.IXMLDOMElement
    Dim lo_rowsNode As MSXML2.IXMLDOMElement
    Dim lo_newRowNode As MSXML2.IXMLDOMElement
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    
    Set lo_tableNode = PARAMS.getElementsByTagName(as_tableName).Item(0)
    Debug.Assert (lo_tableNode.Attributes.getNamedItem("type").Text = "table")
    
    Set lo_rowsNode = lo_tableNode.getElementsByTagName("ROWS").Item(0)
    Set lo_newRowNode = AppendElement(lo_rowsNode, "ROW")
    
    If IsArray(aoa_cols) Then
        Dim ll_i As Long
        For ll_i = LBound(aoa_cols) To UBound(aoa_cols)
            If IsArray(aoa_cols(ll_i)) Then
                Set lo_newNode = AppendElement(lo_newRowNode, aoa_cols(ll_i)(LBound(aoa_cols(ll_i))))
                lo_newNode.Text = aoa_cols(ll_i)(UBound(aoa_cols(ll_i)))
            End If
        Next
    End If
    
    AddTableRow = True
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.AddTableRow")
End Function

Public Function LoadFromURL(ByVal as_url As String)
On Error GoTo errorHandler
    LoadFromURL = False
#If LIVE = 1 Then
    Dim lo_XML As Object
    Dim lo_Node As Object
    Dim lo_ParentNode As Object
#Else
    Dim lo_XML As MSXML2.DOMDocument
    Dim lo_node As MSXML2.IXMLDOMNode
    Dim lo_parentNode As MSXML2.IXMLDOMNode
#End If
    
    Set lo_XML = CreateObject("MSXML2.DOMDocument")
    lo_XML.async = False
    If lo_XML.Load(as_url) Then
        Set lo_parentNode = PARAMS
        ' copy all child nodes from PARAMS under current PARAMS
        Dim lo_srcPARAMS As MSXML2.IXMLDOMNode
        Set lo_srcPARAMS = lo_XML.selectSingleNode("PARAMS")
        If Not lo_srcPARAMS Is Nothing Then
            For Each lo_node In lo_srcPARAMS.childNodes
                Call lo_parentNode.appendChild(lo_node.cloneNode(True))
            Next
            LoadFromURL = True
        End If
    End If
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.LoadFromURL")
End Function

Public Property Get SerializedXML() As String
On Error GoTo errorHandler
    SerializedXML = mo_XML.xml
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.SerializedXML")
End Property
Private Function AppendElement(ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_name As String, Optional ByRef aoa_attributes As Variant = Empty) As MSXML2.IXMLDOMNode
On Error GoTo errorHandler
    Set AppendElement = Nothing
    
#If LIVE = 1 Then
    Dim lo_newNode As Object
#Else
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    Set lo_newNode = mo_XML.createElement(as_name)
    
    If IsArray(aoa_attributes) Then
        Dim ll_i As Long
        For ll_i = LBound(aoa_attributes) To UBound(aoa_attributes)
            If IsArray(aoa_attributes(ll_i)) Then
                Call lo_newNode.setAttribute(aoa_attributes(ll_i)(LBound(aoa_attributes(ll_i))), aoa_attributes(ll_i)(UBound(aoa_attributes(ll_i))))
            End If
        Next
    End If
    Set AppendElement = ao_parentNode.appendChild(lo_newNode)
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.AppendElement")
End Function

' check if header is HTTP/1.1 200 OK
Public Function CheckHTTPResponse(ByVal as_header As String) As Boolean
On Error GoTo errorHandler
    Dim lsa_headerArr() As String
    CheckHTTPResponse = False
    
    lsa_headerArr = Split(as_header, vbCrLf, 2, vbTextCompare)
    
    If IsArray(lsa_headerArr) Then
        Dim lsa_responseTokens() As String
        lsa_responseTokens = Split(lsa_headerArr(LBound(lsa_headerArr)), " ", 3, vbTextCompare)
        Select Case lsa_responseTokens(LBound(lsa_responseTokens) + 1)
            Case "200"      ' OK
                CheckHTTPResponse = True
            Case "301"      ' Moved Permanently
            Case "302"      ' Found
            Case "304"      ' Not Modified
            Case "307"      ' Temporary Redirect
            Case "400"      ' Bad Request
            Case "401"      ' Unauthorized
            Case "403"      ' Forbidden
            Case "404"      ' Not Found
            Case "410"      ' Gone
            Case "500"      ' Internal Server Error
            Case "501"      ' Not Implemented
        
        End Select

    End If
    
    
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.CheckHTTPResponse")
End Function

Public Function HTTPHeaderValue(ByVal as_header As String, ByVal as_headerVal As String) As String
On Error GoTo errorHandler
    Dim lsa_headerArr() As String
    Dim ll_i As Long
    HTTPHeaderValue = ""
    
    lsa_headerArr = Split(as_header, vbCrLf, , vbTextCompare)
    
    For ll_i = LBound(lsa_headerArr) + 1 To UBound(lsa_headerArr)
        Dim lsa_tokens() As String
        lsa_tokens = Split(lsa_headerArr(ll_i), ": ", , vbTextCompare)
        If IsArray(lsa_tokens) Then
            If UBound(lsa_tokens) > 0 Then
                If lsa_tokens(LBound(lsa_tokens)) = as_headerVal Then
                    HTTPHeaderValue = lsa_tokens(UBound(lsa_tokens))
                    Exit For
                End If
            End If
        End If
    Next

    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.HTTPHeaderValue")
End Function

Public Function TestContentType(ByVal as_header As String, ByVal as_contentType As String) As Boolean
On Error GoTo errorHandler
    Dim lsa_valueArr() As String
    TestContentType = False
    
    lsa_valueArr = Split(HTTPHeaderValue(as_header, "Content-Type"), "; ", , vbTextCompare)
    If IsArray(lsa_valueArr) Then
        If UBound(lsa_valueArr) > 0 Then
            If lsa_valueArr(LBound(lsa_valueArr)) = as_contentType Then
                TestContentType = True
            End If
        End If
    End If

    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.TestContentType")
End Function

Public Function GetXMLNodeValue(ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_nodeName As String) As String
On Error GoTo errorHandler
        GetXMLNodeValue = ""
        Dim lo_XMLItem As MSXML2.IXMLDOMNode
        Set lo_XMLItem = ao_parentNode.selectSingleNode(as_nodeName)
        If Not lo_XMLItem Is Nothing Then
            GetXMLNodeValue = lo_XMLItem.Text
        End If
    Exit Function
errorHandler:
    Call errorHandler("SvcXMLParam.GetXMLNodeValue")
End Function
' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' Standard error handler
Private Sub errorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub


