Attribute VB_Name = "Tools"
Option Explicit

Private Const CH_C = "'"
Public Const CH_LDELIMIT = ""

Public Enum DataTypeEnum
    project = 0
    action = 1
    Customer = 2
    contact = 3
    product = 4
    memo = 5
    project_search = 6
    customer_search = 7
    Contact_Search = 8
    Product_Search = 9
    Action_Search = 10
End Enum

'******** gestions des erreurs
Private mb_ErrorFound As Boolean

'******** Default values
Public Const MAX_VALUE = 100

Type DefaultValue
    ScreenName As String
    FieldName As String
    CodeValue As String
    DescValue As String
End Type

Private mi_CapMouseNumber As Integer
Private ma_CapMouseNumber() As Integer

Public gs_CaptureCountry As String
Public gs_CaptureLanguage As String



Public Function ASC_ConnectToDB(ByRef ao_Armdb As Object, ByVal as_ConnectString As String, ByRef ab_Created As Boolean) As Boolean
Dim ls_Array() As String
Dim ls_DB As String
Dim ls_UID As String
Dim ls_PWD As String
Dim ls_App As String
Dim ls_DNS As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_ConnectToDB", "as_ConnectString=" & as_ConnectString, "ab_Created=" & ab_Created
    #End If
    
    ASC_ConnectToDB = False
    ab_Created = False
    
    If TypeName(ao_Armdb) <> "Nothing" Then
        'The object has already been instanciate
        '
        'TODO: Add a test on the connection in ArmDB
        ASC_ConnectToDB = True
        GoTo Trace_End
    End If

    'The connection does'nt exist. We create it
    Set ao_Armdb = CreateObject("ARMSYSCOM.ArmDb")
    
    #If CapDebug Then
        MsgBox "cration d'une connection  la base de donne"
    #End If
    
    ao_Armdb.CacheDir = App.Path & "\cache\capture"
    ao_Armdb.CacheCheckProc = "exec cache_procedure_sel3 ?,?"
    ao_Armdb.CacheSelectProc = "exec cache_procedure_lst"
    ao_Armdb.UseCache = True
    
    ls_Array = Split(as_ConnectString, CH_LDELIMIT, -1)

    On Error Resume Next
    
    ls_DNS = ls_Array(0)
    ls_DB = ls_Array(1)
    ls_UID = ls_Array(2)
    ls_PWD = ls_Array(3)
    ls_App = ls_Array(4)

    'Connexion DNS = "tst1eabp", m_DB = "siftest"...
    If ls_DNS = "" And ls_DB = "" And ls_UID = "" And ls_PWD = "" Then
        Call ASC_SendMessage(ao_Armdb, "E", 914, "#At least one connection parameter is missing, please contact IT")
        GoTo Trace_End
    End If
    
    If ao_Armdb.Connect(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, ls_App) = 0 Then
        Call ASC_SendMessage(ao_Armdb, "E", 915, "#Unable to establish the connection to the database with this parameters. Please, check your login and password.")
        Set ao_Armdb = Nothing
        GoTo Trace_End
    End If

    ' Define the lock_timeout
    'If Not ao_Armdb.ExecuteSQL("SET LOCK_TIMEOUT 120000") Then GoTo Trace_End

    ab_Created = True
    ASC_ConnectToDB = True

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_ConnectToDB", "Result=" & ASC_ConnectToDB
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_ConnectToDB"
    CapMouseOn
End Function

Public Sub ASC_DisconnectFromDB(ByRef ao_Armdb As Object, ByVal as_UID As String, ByVal ab_Created As Boolean)
Dim ls_Request As String
Dim i As Integer

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_DisconnectFromDB", "ab_Created=" & ab_Created
    #End If
    
    If ab_Created = True Then
        ao_Armdb.UseCache = False
        #If CapDebug Then
            ' Only visible by IT
            MsgBox "destruction d'une connection  la base de donne"
            If ao_Armdb.CursorCount <> 0 Then
                MsgBox "Attention, il reste " & CStr(ao_Armdb.CursorCount) & " curseurs ouverts !!!!"
            End If
        #Else
            If ao_Armdb.CursorCount <> 0 Then
                Call ASC_SendMessage(ao_Armdb, "E", 923, "Some database access are not properly close, please contact IT. Openned cursor(s) : ", CStr(ao_Armdb.CursorCount))
                ls_Request = "EXEC ZLog_ins2 'Capture',  '" & as_UID & ": Some database access are not properly close(Count=" & CStr(ao_Armdb.CursorCount) & ")',NULL"
                ao_Armdb.ExecuteSQL ls_Request
                For i = 0 To ao_Armdb.CursorCount - 1
                    ls_Request = "EXEC ZLog_ins2 'Capture', " & FormatSqlStringParameter("Cursor open for the request : " & CStr(ao_Armdb.SQLRequest(ao_Armdb.Cursors(i))) & ")") & ",NULL"
                    ao_Armdb.ExecuteSQL ls_Request
                Next
            End If
        #End If
        ao_Armdb.Disconnect
        Set ao_Armdb = Nothing
    Else
        Set ao_Armdb = Nothing
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_DisconnectFromDB"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_DisconnectFromDB"
    CapMouseOn
End Sub

Public Sub ListViewColumn(ByRef ao_List As ListView, AColID As Integer, AColTitle As String, AColWidth As Integer)

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ListViewColumn", "AColID=" & AColID, "AColTitle=" & AColTitle, "AColWidth=" & AColWidth
    #End If
    
    If AColID > 0 And AColID <= ao_List.ColumnHeaders.Count Then
        ao_List.ColumnHeaders(AColID).Text = AColTitle
        ao_List.ColumnHeaders(AColID).Width = AColWidth
    End If
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ListViewColumn"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ListViewColumn"
    CapMouseOn
End Sub

Public Function CorrectDate(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As Object, Optional ARequired As Boolean = False) As String

Dim ai_ErrorMessage As Integer
Dim FormatedDate  As String
Dim as_DftErrorMessage As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectDate", "ARequired=" & ARequired
    #End If
    
    CorrectDate = ""
    ai_ErrorMessage = 0
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.date_courte = "" Then
            ai_ErrorMessage = 266
            as_DftErrorMessage = "Missing Data in compulsory field"

        ElseIf Not IsDate(AField.date_courte) Then
            ai_ErrorMessage = 267
            as_DftErrorMessage = "Invalid data"
        End If
    'If Field is not required
    Else
        If AField.date_courte <> "" Then
            If Not IsDate(AField.date_courte) Then
                ai_ErrorMessage = 267
                as_DftErrorMessage = "Invalid data"
            End If
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ai_ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ai_ErrorMessage, as_DftErrorMessage)
        AField.SetFocus
    Else
' BEGIN MSEDLAK IS THIS NOT A BUG? IT DON'T WORKS ON WRONG DATE TIME LOCALE SETTING
        FormatedDate = IIf(AField.date_courte = "", "", Format$(AField.date_courte, "yyyy\-mm\-dd"))
' END 
        CorrectDate = IIf(AField.date_courte = "", "NULL", CH_C & FormatedDate & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectDate", "Result=" & CorrectDate
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectDate"
    CapMouseOn
End Function


Public Function CorrectDate2(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As Object, Optional ARequired As Boolean = False) As String

Dim ai_ErrorMessage As Integer
Dim FormatedDate  As String
Dim as_DftErrorMessage As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectDate2", "ARequired=" & ARequired
    #End If
    
    CorrectDate2 = ""
    ai_ErrorMessage = 0
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.date_courte = "" Then
            ai_ErrorMessage = 266
            as_DftErrorMessage = "Missing Data in compulsory field"

        ElseIf Not IsDate(AField.date_courte) Then
            ai_ErrorMessage = 267
            as_DftErrorMessage = "Invalid data"
        End If
    'If Field is not required
    Else
        If AField.date_courte <> "" Then
            If Not IsDate(AField.date_courte) Then
                ai_ErrorMessage = 267
                as_DftErrorMessage = "Invalid data"
            End If
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ai_ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ai_ErrorMessage, as_DftErrorMessage)
        AField.SetFocus
    Else
        CorrectDate2 = IIf(AField.date_courte = "", "NULL", CH_C & AField.date_courte & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectDate2", "Result=" & CorrectDate
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectDate2"
    CapMouseOn
End Function



Public Function CorrectCodeInt(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As ArmCombobox, Optional ARequired As Boolean = False) As String
Dim ErrorMessage As Integer
Dim TheCode As String
Dim TheDesc As String
Dim ms_DftMessage As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectCodeInt", "ARequired=" & ARequired
    #End If
    
    CorrectCodeInt = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'Get the code from the combo ("" if no selection)
    TheCode = GetCodeFromCombo(AField)
    
    'Way of correcting bug of ArmSysCOM.dll ********
    TheDesc = GetTextFromCombo(AField)
    If Trim$(TheDesc) = "" Then TheCode = ""
    '***********************************************
    
    'If Field is required
    If ARequired Then
        If TheCode = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        CorrectCodeInt = IIf(TheCode = "", "NULL", TheCode)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectCodeInt", "Result=" & CorrectCodeInt
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectCodeInt"
    CapMouseOn
End Function

Public Function CorrectCodeStr(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As ArmCombobox, Optional ARequired As Boolean = False) As String

Dim ErrorMessage As Integer
Dim TheCode As String
Dim ms_DftMessage As String
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectCodeStr", "ARequired=" & ARequired
    #End If
    
    CorrectCodeStr = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'Get the code from the combo ("" if no selection)
    TheCode = GetCodeFromCombo(AField)
    
    'If Field is required
    If ARequired Then
        If TheCode = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        CorrectCodeStr = IIf(TheCode = "", "NULL", CH_C & TheCode & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectCodeStr", "Result=" & CorrectCodeStr
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectCodeStr"
    CapMouseOn
End Function

Public Function CorrectKeyStr(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As A_SrchTxt, Optional ARequired As Boolean = False) As String
Dim ErrorMessage As Integer
Dim ms_DftMessage As String

Dim TheCode As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectKeyStr", "ARequired=" & ARequired
    #End If
    
    CorrectKeyStr = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'Get the code from the SrchTxt ("" if no selection)
    TheCode = AField.Key1
    
    'If Field is required
    If ARequired Then
        If TheCode = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        CorrectKeyStr = IIf(TheCode = "", "NULL", CH_C & TheCode & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectKeyStr", "Result=" & CorrectKeyStr
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectKeyStr"
    CapMouseOn
End Function

Public Function CorrectCboPrd(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As Object, Optional ARequired As Boolean = False) As String

Dim ErrorMessage As Integer
Dim ms_DftMessage As String

Dim TheCode As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectCboPrd", "ARequired=" & ARequired
    #End If
    
    CorrectCboPrd = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'Get the code from the SrchTxt ("" if no selection)
    TheCode = AField.SelectedItemCode
    
    'If Field is required
    If ARequired Then
        If TheCode = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"

        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        CorrectCboPrd = IIf(TheCode = "", "NULL", CH_C & TheCode & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectCboPrd", "Result=" & CorrectCboPrd
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectCboPrd"
    CapMouseOn
End Function

Public Function CorrectInt(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As TextBox, Optional ARequired As Boolean = False, Optional APositiveOnly As Boolean = True) As String
Dim ErrorMessage As Integer
Dim ms_DftMessage As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectInt", "ARequired=" & ARequired, "APositiveOnly=" & APositiveOnly
    #End If
    
    CorrectInt = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.Text = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        ElseIf Not IsInteger(AField.Text) Then
            ErrorMessage = 267
            ms_DftMessage = "#Invalid data"
        ElseIf CInt(AField.Text) < 0 And APositiveOnly Then
            ErrorMessage = 272
            ms_DftMessage = "#Negative value not allowed"
        End If
    'If Field is not required
    Else
        If AField.Text <> "" Then
            If Not IsInteger(AField.Text) Then
                ErrorMessage = 267
                ms_DftMessage = "#Invalid data"
            ElseIf CInt(AField.Text) < 0 And APositiveOnly Then
                ErrorMessage = 272
                ms_DftMessage = "#Negative value not allowed"
            End If
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        CorrectInt = IIf(AField.Text = "", "NULL", AField.Text)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectInt", "Result=" & CorrectInt
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectInt"
    CapMouseOn
End Function

Public Function CorrectDec(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As TextBox, Optional ARequired As Boolean = False, Optional APositiveOnly As Boolean = True, Optional ab_NoZero As Boolean = False) As String
Dim ErrorMessage As Integer
Dim ms_DftMessage As String


    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectDec", "ARequired=" & ARequired, "APositiveOnly=" & APositiveOnly
    #End If
    
    CorrectDec = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.Text = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        ElseIf Not isNumeric(AField.Text) Then
            ErrorMessage = 267
            ms_DftMessage = "#Invalid data"
        ElseIf CDbl(AField.Text) < 0 And APositiveOnly Then
            ErrorMessage = 272
            ms_DftMessage = "#Negative value not allowed"
        End If
    'If Field is not required
    Else
        If AField.Text <> "" Then
            If Not isNumeric(AField.Text) Then
                ErrorMessage = 267
                ms_DftMessage = "#Invalid data"
            ElseIf CDbl(AField.Text) < 0 And APositiveOnly Then
                ErrorMessage = 272
                ms_DftMessage = "#Negative value not allowed"
            End If
        End If
    End If
    
    If ab_NoZero = True And AField = "0" Then
        ErrorMessage = 273
        ms_DftMessage = "#Zero not allowed"
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        AField.SetFocus
    Else
        'Transformation
        CorrectDec = IIf(AField.Text = "", "NULL", AField.Text)
        CorrectDec = Replace(CorrectDec, ",", ".")
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectDec", "Result=" & CorrectDec
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectDec"
    CapMouseOn
End Function

Public Function CorrectBool(ByRef AField As CheckBox, Optional ACheckedValue As String = "X", Optional AUncheckedValue As String = "") As String
Dim ErrorMessage As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectBool", "ACheckedValue=" & ACheckedValue, "AUncheckedValue=" & AUncheckedValue
    #End If
    
    CorrectBool = ""
        
    If AField.value = Checked Then
        CorrectBool = CH_C & ACheckedValue & CH_C
    Else
        CorrectBool = CH_C & AUncheckedValue & CH_C
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectBool", "Result=" & CorrectBool
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectBool"
    CapMouseOn
End Function

Public Function CorrectString(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As TextBox, Optional ARequired As Boolean = False) As String
Dim ErrorMessage As Integer
Dim ms_DftMessage As String
Dim TheString As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectString", "ARequired=" & ARequired
    #End If
    
    CorrectString = ""
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.Text = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        End If
    End If
    
    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        If AField.Visible Then AField.SetFocus
    Else
        If AField.Text = "" Then
            CorrectString = "NULL"
        Else
            CorrectString = FormatSqlStringParameter(AField.Text)
        End If
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectString", "Result=" & CorrectString
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectString"
    CapMouseOn
End Function

Private Function IsEMail(AString As String) As Boolean
Dim Pos1 As Integer
Dim Pos2 As Integer

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:IsEMail", "AString=" & AString
    #End If
    
    Pos1 = InStr(1, AString, "@")
    If Not Pos1 > 1 Then
        IsEMail = False
    Else
        Pos2 = InStr(Pos1, AString, ".")
        If Not Pos2 > 1 Then
            IsEMail = False
        ElseIf Pos2 = Pos1 + 1 Then
            IsEMail = False
        ElseIf Pos2 = Len(AString) Then
            IsEMail = False
        Else
            IsEMail = True
        End If
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:IsEMail", "Result=" & IsEMail
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:IsEMail"
    CapMouseOn
End Function

Public Function CorrectEMail(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef AField As TextBox, Optional ARequired As Boolean = False) As String
Dim ErrorMessage As Integer
Dim ms_DftMessage As String
Dim TheString As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CorrectEMail", "ARequired=" & ARequired
    #End If
    
    CorrectEMail = ""
    
    
    'If previous error found
    If mb_ErrorFound Then GoTo Trace_End
    
    'If Field is required
    If ARequired Then
        If AField.Text = "" Then
            ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        ElseIf Not IsEMail(AField.Text) Then
            ErrorMessage = 269
            ms_DftMessage = "#Email invalid"
        End If
    ElseIf AField.Text <> "" Then
        If Not IsEMail(AField.Text) Then
            ErrorMessage = 269
            ms_DftMessage = "#Email invalid"
        End If
    End If

    'An error was found
    mb_ErrorFound = ErrorMessage <> 0
    If mb_ErrorFound Then
        Call ASC_SendMessage(ao_Armdb, as_Language, ErrorMessage, ms_DftMessage)
        If AField.Visible Then AField.SetFocus
    Else
        TheString = Replace(AField.Text, "'", "''")
        CorrectEMail = IIf(TheString = "", "NULL", CH_C & TheString & CH_C)
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CorrectEMail", "Result=" & CorrectEMail
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CorrectEMail"
    CapMouseOn
    
End Function

Public Function ErrorFound() As Boolean

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ErrorFound"
    #End If
    
    ErrorFound = mb_ErrorFound

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ErrorFound", "Result=" & ErrorFound
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ErrorFound"
    CapMouseOn
End Function

Public Sub ErrorOFF()
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ErrorOFF"
    #End If
    
    mb_ErrorFound = False

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ErrorOFF"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ErrorOFF"
    CapMouseOn
End Sub

Public Sub ErrorON()
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ErrorON"
    #End If
    
    mb_ErrorFound = True

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ErrorON"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ErrorON"
    CapMouseOn
End Sub

Private Function IsInteger(ByVal AInteger As Variant) As Boolean
Dim TheString As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:IsInteger", "AInteger=" & AInteger
    #End If
    
    TheString = Format$(AInteger)

    If InStr(1, ".", TheString) > 0 Then
        IsInteger = False
    ElseIf InStr(1, ",", TheString) > 0 Then
        IsInteger = False
    ElseIf Not isNumeric(AInteger) Then
        IsInteger = False
    Else
        IsInteger = True
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:IsInteger", "Result=" & IsInteger
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:IsInteger"
    CapMouseOn
End Function

Public Function ConnectionStringValidation(ByVal as_ConnectString As String) As String
'Valide la chaine de connexion et renvoi UID
Dim ls_DNS As String
Dim ls_DB As String
Dim ls_UID As String
Dim ls_PWD As String
Dim ls_APPL As String
Dim lt_CstValues As New Type_CstValues
Dim ls_connectdata

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ConnectionStringValidation", "as_ConnectString=" & as_ConnectString
    #End If
    
    ConnectionStringValidation = ""
    
    If Not Trim$(as_ConnectString) = "" Then
        ls_connectdata = Split(as_ConnectString, CH_LDELIMIT)
        ls_DNS = ls_connectdata(0)
        ls_DB = ls_connectdata(1)
        ls_UID = ls_connectdata(2)
        ls_PWD = ls_connectdata(3)
    End If

    'Validation chane de connexion
    If (ls_DNS = "" Or ls_DB = "" Or ls_UID = "" Or ls_PWD = "") Then
        MsgBox "#Unable to establish the connection to the database with this parameters. Please, check your login and password."
        GoTo Trace_End
    End If
    
    ConnectionStringValidation = ls_UID

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ConnectionStringValidation", "Result=" & ConnectionStringValidation
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ConnectionStringValidation"
    CapMouseOn
End Function

Public Function ASC_RecordExec(ByRef ao_Armdb As Object, ByVal as_Request As String, ByRef as_ResultCode As String, Optional ab_TestResult As Boolean = True) As Boolean
Dim ll_Cursor As Long
Dim ls_Result As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_RecordExec", "as_Request=" & as_Request
    #End If
    
    ASC_RecordExec = False
    as_ResultCode = ""
    
    'Execute the request
    ll_Cursor = ao_Armdb.OpenSQL(as_Request)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_RecordExec", "as_Request = " & as_Request
        GoTo Trace_End
    End If
    
    ls_Result = ao_Armdb.GetFields(ll_Cursor, 0)
    If ls_Result = "" Then GoTo Trace_End
    
    as_ResultCode = ls_Result 'Error
    If ab_TestResult Then
        If Not isNumeric(ls_Result) Then GoTo Trace_End
        If CDbl(ls_Result) < 0 Then GoTo Trace_End
    End If
    
    ASC_RecordExec = True
    
Trace_End:
    ao_Armdb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_RecordExec", "Result=" & ASC_RecordExec, "as_ResultCode=" & as_ResultCode
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ao_Armdb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_RecordExec"
    CapMouseOn
End Function

Public Function GetCodeFromCombo(ACombo As ArmCombobox) As String
Dim TheValue As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:GetCodeFromCombo"
    #End If
    
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        TheValue = ACombo.SelectedItem.Key
        GetCodeFromCombo = TheValue
    Else
        GetCodeFromCombo = ""
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:GetCodeFromCombo", "Result=" & GetCodeFromCombo
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:GetCodeFromCombo"
    CapMouseOn
End Function

Public Function GetTextFromCombo(ByRef ACombo As ArmCombobox) As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:GetTextFromCombo"
    #End If
    
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        GetTextFromCombo = ACombo.SelectedItem.DisplayText
    Else
        GetTextFromCombo = ""
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:GetTextFromCombo", "Result=" & GetTextFromCombo
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:GetTextFromCombo"
    CapMouseOn
End Function

Public Function GetBUGroupFromCombo(ACombo As ArmCombobox) As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:GetBUGroupFromCombo"
    #End If
    
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        GetBUGroupFromCombo = ACombo.SelectedItem.GetData(2)
    Else
        GetBUGroupFromCombo = ""
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:GetBUGroupFromCombo", "Result=" & GetBUGroupFromCombo
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:GetBUGroupFromCombo"
    CapMouseOn
End Function

Public Function GetScreenDefaultValues(ByRef ao_Armdb As Object, ByVal as_UID As String, as_Language As String, AScreenName As String, ByRef aa_DefaultValues() As DefaultValue) As Integer
Dim ll_Cursor As Long
Dim ls_Request As String
Dim ll_Count As Long
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:GetScreenDefaultValues", "as_UID=" & as_UID, "as_Language=" & as_Language, "AScreenName=" & AScreenName
    #End If
    
    ls_Request = "exec Cap_DefaultValue_t_lst '" & AScreenName & "', '" & as_UID & "', '" & as_Language & "'"
    ll_Cursor = ao_Armdb.OpenSQL(ls_Request, -1)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:GetScreenDefaultValues", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    ll_Count = 0
    Do While Not ao_Armdb.EOF(ll_Cursor)
        If ll_Count < MAX_VALUE Then
            aa_DefaultValues(ll_Count).ScreenName = ao_Armdb.GetFields(ll_Cursor, "DFT_ScreenName")
            aa_DefaultValues(ll_Count).FieldName = ao_Armdb.GetFields(ll_Cursor, "DFT_FieldName")
            aa_DefaultValues(ll_Count).CodeValue = ao_Armdb.GetFields(ll_Cursor, "DFT_code")
            aa_DefaultValues(ll_Count).DescValue = ao_Armdb.GetFields(ll_Cursor, "DFT_desc")
            ll_Count = ll_Count + 1
            End If
        ao_Armdb.Next ll_Cursor
    Loop
    
    GetScreenDefaultValues = ll_Count

Trace_End:
    ao_Armdb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:GetScreenDefaultValues", "Result=" & GetScreenDefaultValues
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ao_Armdb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:GetScreenDefaultValues"
    CapMouseOn
End Function

Public Sub DisplayScreenDefaultValues(ByRef ao_Controls As Object, ByRef aa_DefaultValues() As DefaultValue, ByVal al_DefaultValuesCount As Long)
Dim i As Integer
Dim TheControl As Control
Dim TheControlName As String
Dim ll_Index As Long

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:DisplayScreenDefaultValues"
    #End If
    
    For i = 0 To al_DefaultValuesCount - 1
        TheControlName = aa_DefaultValues(i).FieldName
        Set TheControl = Nothing
        On Error Resume Next
        
        Set TheControl = ao_Controls(TheControlName)
        
        If TheControl Is Nothing Then
            For ll_Index = 0 To ao_Controls.Count - 1
                If UCase(ao_Controls(ll_Index).Tag) = UCase(TheControlName) Then
                    Set TheControl = ao_Controls(ll_Index)
                End If
            Next
        End If
        On Error GoTo Trace_Err
        If Not TheControl Is Nothing Then
            Select Case LCase(TypeName(TheControl))
                Case "armcombobox"
                    'Cas ComboBox
                    If Trim$(aa_DefaultValues(i).CodeValue) <> "" Then
                        TheControl.Clear
                        TheControl.AddItem Array(aa_DefaultValues(i).CodeValue, aa_DefaultValues(i).DescValue), True
                    End If
                Case "textbox"
                    'Cas TextBox
                    TheControl.Text = aa_DefaultValues(i).DescValue
            End Select
        End If
    Next i

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:DisplayScreenDefaultValues"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:DisplayScreenDefaultValues"
    CapMouseOn
End Sub

Public Sub CapMouseOff(Optional ab_Restore = False)
Dim ll_Size As Long

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CapMouseOff", "ab_Restore=" & ab_Restore
    #End If

    If ab_Restore = True Then
        ll_Size = UBound(ma_CapMouseNumber)
        mi_CapMouseNumber = ma_CapMouseNumber(ll_Size)
        ReDim Preserve ma_CapMouseNumber(ll_Size - 1)
    Else
        mi_CapMouseNumber = mi_CapMouseNumber + 1
    End If
    Screen.MousePointer = vbHourglass

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CapMouseOff"
    #End If
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CapMouseOff"

End Sub

Public Sub CapMouseOn(Optional ab_Saved = False)
Dim ll_Size As Long

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:CapMouseOn", "ab_Saved=" & ab_Saved
    #End If

    If ab_Saved = True Then
        On Error Resume Next
        ll_Size = 0
        ll_Size = UBound(ma_CapMouseNumber)
        ll_Size = ll_Size + 1
        ReDim Preserve ma_CapMouseNumber(ll_Size)
        ma_CapMouseNumber(ll_Size) = mi_CapMouseNumber
        mi_CapMouseNumber = 1
    End If
    
    mi_CapMouseNumber = IIf(mi_CapMouseNumber < 1, 0, mi_CapMouseNumber - 1)
    If mi_CapMouseNumber = 0 Then
        Screen.MousePointer = vbDefault
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:CapMouseOn"
    #End If
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:CapMouseOn"

End Sub

' Apply default value on a screen
Public Sub ControlsEnable(ByRef lo_Controls As Variant, ByRef lo_Container As Object, ByVal ab_Enabled As Boolean)
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ControlsEnable", "ab_Enabled=" & ab_Enabled
    #End If
    
    CapMouseOff
    
    Dim ll_Index As Long, li_Idx As Long, li_Count As Integer
    Dim lo_Control As Control
    For ll_Index = 0 To lo_Controls.Count - 1
        Set lo_Control = lo_Controls(ll_Index)
        If HasContainer(lo_Control, lo_Container) Then
            Select Case TypeName(lo_Control)
                Case "A_ckvSR", "ArmCheckView"
                Case Else
                    On Error GoTo continue
                    lo_Control.Enabled = ab_Enabled
continue:
                    On Error GoTo Trace_Err
                End Select
        End If
    Next

Trace_End:
    CapMouseOn
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ControlsEnable"
    #End If
    Exit Sub

Trace_Err:
    CapMouseOn
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ControlsEnable"

End Sub

' Use by Control Clear and ControlsEnable
Private Function HasContainer(ByRef lo_Control As Control, ByRef lo_Container As Object) As Boolean
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:HasContainer", "lo_Control=" & lo_Control.Name & ", lo_Container=" & lo_Container.Name
    #End If
        
    Dim ll_Index As Long
    Dim lo_Object As Object

    HasContainer = False
    While Not (lo_Control Is Nothing)
        On Error GoTo NotFound
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            GoTo Trace_End
        End If
        Set lo_Control = lo_Control.Container
    Wend

NotFound:
    HasContainer = False

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:HasContainer", "Result=" & HasContainer
    #End If
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:HasContainer"

End Function

Public Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal ALanguage As String) As String
    Dim ls_Request As String, lCurs As Long
    ls_Request = "SELECT Code_Page FROM Language WHERE Language_Code = '" & ALanguage & "'"
    lCurs = ao_Armdb.OpenSQL(ls_Request)
    Dim lCodePage As String
    lCodePage = ao_Armdb.GetFields(lCurs, "Code_Page")
    ao_Armdb.Close (lCurs)
    GetCodePageFromLanguage = lCodePage
End Function

' Load the labels of a containers
Public Sub LoadLabels(ByRef ao_Armdb As Object, ByRef ao_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)
Dim lc_Labels As Long       ' The cursor of the labels
Dim lc_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lBuffer As String
Dim lCaption As Variant
Dim lCurs As Long
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:LoadLabels", "as_ScreenName=" & as_ScreenName, "as_Language=" & as_Language
    #End If
    
    Call Cap_ChangeCharset(ao_Container, GetCodePageFromLanguage(ao_Armdb, as_Language))
    ls_Request = "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'"
    lc_Labels = ao_Armdb.OpenSQL(ls_Request, -1)
    
    If lc_Labels = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:LoadLabels", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", ao_Container.Tag, , 1)
        If li_Label >= 0 Then
            ao_Container.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
            Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                Dim lo_Tbs As Object
                Set lo_Tbs = lc_Control ' Cast for use of intellisense
                li_Count = lo_Tbs.Tabs.Count
                For li_Idx = 1 To li_Count
                    If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                        If li_Label >= 0 Then
                            lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Next
                Set lo_Tbs = Nothing
            
            Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                Dim lo_ListView As Object
                Set lo_ListView = lc_Control
                li_Count = lo_ListView.ColumnHeaders.Count
                For li_Idx = 1 To li_Count
                    If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                        If li_Label >= 0 Then
                            lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Next
                Set lo_ListView = Nothing
        
            Case UCase("TextBox")  ' Component is a textbox
                Dim lo_TextBox As Object
                Set lo_TextBox = lc_Control
                If lo_TextBox.Tag <> "" Then
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_TextBox.Tag, , 1)
                    If li_Label >= 0 Then
                        lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                End If
                Set lo_TextBox = Nothing
            
            Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
      


                If lc_Control.Tag <> "" Then
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lc_Control.Tag, , 1)
                    If li_Label >= 0 Then
                        lc_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                End If
                
            Case ("LISTBOX")
                If left(lc_Control.Tag, 4) = "SSTR" Then
                    lBuffer = right(lc_Control.Tag, Len(lc_Control.Tag) - 4)
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lBuffer, , 1)
                    If li_Label >= 0 Then
                        lBuffer = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        For Each lCaption In Split(lBuffer, CH_LDELIMIT)
                            lc_Control.AddItem lCaption
                        Next
                    End If
                End If
        End Select
    Next
    
    
Trace_End:
    ao_Armdb.Close lc_Labels
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:LoadLabels"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    ao_Armdb.Close lc_Labels
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:LoadLabels"
    CapMouseOn
      
End Sub

' Get an error message
Private Function ASC_MsgText(ByRef ao_Armdb As Object, ByVal as_LG_Code As String, ByVal ai_MsgID As Integer, Optional ByVal as_MsgDefault As String = "")
Dim lc_Msg As Long
Dim ls_msg As String, ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_MsgText", "LG_Code=" & as_LG_Code & ", ai_MsgID=" & ai_MsgID & ", as_MsgDefault=" & as_MsgDefault
    #End If
    CapMouseOff
    
    ls_Request = "SELECT Message_Text FROM Error_Message WHERE Language_Code = '" & as_LG_Code & "' AND MsgID = " & ai_MsgID
    lc_Msg = ao_Armdb.OpenSQL(ls_Request)
    If lc_Msg = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_MsgText", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    ls_msg = ao_Armdb.GetFields(lc_Msg, "MESSAGE_TEXT")
    
Trace_End:
    Call ao_Armdb.Close(lc_Msg)
    ASC_MsgText = IIf(Len(ls_msg) <> 0, ls_msg, as_MsgDefault)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_MsgText", "Result=" & ASC_MsgText
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_MsgText = ""
    Call ao_Armdb.Close(lc_Msg)
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_MsgText"
    CapMouseOn
End Function

' Display an error message
Public Function ASC_SendMessage(ByRef ao_Armdb As Object, ByVal as_LG_Code As String, ByVal ai_MsgCode As Integer, ByVal as_MsgDefault As String, Optional ByVal as_MsgCxt As String = "", Optional Buttons As VbMsgBoxStyle = vbOKOnly, Optional ByVal Title As String) As VbMsgBoxResult
Dim ls_Message As String
Dim ll_Mouse As Long
Dim lo_Return As VbMsgBoxResult

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_SendMessage", "LG_Code=" & as_LG_Code & ", ai_MsgCode=" & ai_MsgCode & ", as_MsgDefault=" & as_MsgDefault & ", as_MsgCxt=" & as_MsgCxt & ", VbMsgBoxStyle=" & "" & ", Title=" & Title
    #End If
    CapMouseOff
    
    If ao_Armdb Is Nothing Then
        ls_Message = as_MsgDefault
    Else
        If ao_Armdb.IsConnected = False Then
            ls_Message = as_MsgDefault
        Else
            ls_Message = ASC_MsgText(ao_Armdb, as_LG_Code, ai_MsgCode, as_MsgDefault)
        End If
    End If
    ls_Message = ls_Message & vbCrLf & Trim(as_MsgCxt)
        
    If Title = "" Then Title = "Capture Online"
    lo_Return = MsgBox(ls_Message, Buttons, Title)
    
    ASC_SendMessage = lo_Return

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_SendMessage", "Result=" & ASC_SendMessage
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_SendMessage = vbAbort
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_SendMessage"
    CapMouseOn
End Function

Public Sub SelectStrField(ByRef ao_field As Object)
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:SelectStrField", "ao_Field=" & ao_field.Name
    #End If
    CapMouseOff
    
    ao_field.SelStart = 0
    ao_field.SelLength = Len(ao_field.Text)
    'Call ao_Field.SetFocus
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:SelectStrField"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:SelectStrField"
    CapMouseOn
End Sub

Public Function FormatSqlStringParameter(ByVal as_Str As String) As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:FormatSqlStringParameter", "as_Str=" & as_Str
    #End If
    CapMouseOff
    
    FormatSqlStringParameter = CH_C & Replace(as_Str, CH_C, CH_C & CH_C) & CH_C
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:FormatSqlStringParameter", "Result=" & FormatSqlStringParameter
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:FormatSqlStringParameter"
    CapMouseOn
End Function

Private Sub Cap_ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As String = "")
Dim lc_Control As Control   ' A control of the container
Dim ls_Charset As String
    
    On Error Resume Next
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ChangeCharset"
    #End If
    CapMouseOff


    ' Check here for the charset
    ' Check if the default value is the polish charset. If so, then apply
    Dim ls_DefaultCharset As String
    ls_DefaultCharset = GetCharSetFromCodePage(GetDefaultConfigCode("Capture_Cfg", "Charset"))
    
    
    If ls_DefaultCharset <> "238" Then
    If aCodePage = "" Then
            ls_Charset = ls_DefaultCharset
    Else
        ls_Charset = GetCharSetFromCodePage(aCodePage)
    End If
    Else
        ls_Charset = ls_DefaultCharset
    End If
    
    If ls_Charset <> "" Then
        For Each lc_Control In ao_Container
            Select Case UCase(TypeName(lc_Control))
            Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
                  "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
                  "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
                lc_Control.Font.Name = "Arial"
                lc_Control.Font.Charset = ls_Charset
            Case "A_SEEK", "A_SRCHTXT"
                lc_Control.Charset = ls_Charset
            End Select
        Next
    End If
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ChangeCharset"
    #End If
    CapMouseOn
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ChangeCharset"
    CapMouseOn
End Sub

' Format a date to DD/MM/YYYY format
Public Function Cap_FormatDate(ByVal av_Date As Variant) As String
Dim ld_Date As Date
Dim ls_Date As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:Cap_FormatDate", "av_Date=" & av_Date
    #End If
    CapMouseOff

    ls_Date = ""
    If IsDate(av_Date) Then
        ld_Date = CDate(av_Date)
        If ld_Date <> 0 Then
          'this will not work with some international settings... to be sure I set "/" hardcoded
          'ls_Date = Format(ld_Date, "dd/mm/yyyy")
          ls_Date = Format(ld_Date, "dd") & "/" & Format(ld_Date, "mm") & "/" & Format(ld_Date, "yyyy")
        End If
    End If
    
    Cap_FormatDate = ls_Date
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:Cap_FormatDate", "Result=" & Cap_FormatDate
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:Cap_FormatDate"
    CapMouseOn
End Function

Public Function ASC_BeginTransaction(ByRef ao_Armdb As Object, Optional ByVal as_Name As String = "") As Boolean
Dim ll_Cursor As Long
Dim ls_Request As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_BeginTransaction"
    #End If
    
    ASC_BeginTransaction = False
    
    ls_Request = "BEGIN TRAN " & as_Name
    
    'Execute the request
    If Not ao_Armdb.ExecuteSQL(ls_Request) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_BeginTransaction", "ls_Request = " & ls_Request
        GoTo Trace_End
    End If
    
    ASC_BeginTransaction = True
            
Trace_End:
    'ao_ArmDB.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_BeginTransaction"
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    'ao_ArmDB.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_BeginTransaction"
    CapMouseOn
End Function

Public Function ASC_CommitTransaction(ByRef ao_Armdb As Object, Optional ByVal as_Name As String = "") As Boolean
Dim ll_Cursor As Long
Dim ls_Request As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_CommitTransaction"
    #End If
    
    ASC_CommitTransaction = False
    
    ls_Request = "COMMIT TRAN " & as_Name
    
    'Execute the request
    If Not ao_Armdb.ExecuteSQL(ls_Request) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_CommitTransaction", "ls_Request = " & ls_Request
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction = True
            
Trace_End:
    'ao_ArmDB.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_CommitTransaction"
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    'ao_ArmDB.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_CommitTransaction"
    CapMouseOn
End Function

Public Function ASC_RollBackTransaction(ByRef ao_Armdb As Object, Optional ByVal as_Name As String = "") As Boolean
Dim ll_Cursor As Long
Dim ls_Request As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_RollBackTransaction"
    #End If
    
    ASC_RollBackTransaction = False
    
    ls_Request = "ROLLBACK TRAN " & as_Name
    
    'Execute the request
    If Not ao_Armdb.ExecuteSQL(ls_Request) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_RollBackTransaction", "ls_Request = " & ls_Request
        GoTo Trace_End
    End If
    
    ASC_RollBackTransaction = True
            
Trace_End:
    'ao_ArmDB.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_RollBackTransaction"
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    'ao_ArmDB.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_RollBackTransaction"
    CapMouseOn
End Function
