Attribute VB_Name = "mprint"
Option Explicit

Private Declare Function GetDeviceCaps Lib "gdi32" _
       (ByVal hdc As Long, ByVal nIndex As Long) As Long

' Constants for nIndex argument of GetDeviceCaps
Private Const HORZRES = 8
Private Const VERTRES = 10
Private Const LOGPIXELSX = 88
Private Const LOGPIXELSY = 90
Private Const PHYSICALWIDTH = 110
Private Const PHYSICALHEIGHT = 111
Private Const PHYSICALOFFSETX = 112
Private Const PHYSICALOFFSETY = 113

Private ml_marginLR   As Single
Private ml_marginTB    As Single
Private ml_printAreaHorz    As Single
Private ml_printAreaVert    As Single
Private ml_physWidth    As Single
Private ml_physHeight   As Single



' resolution of the pri nter
Const mi_Scalewidth = 3000
Const mi_ScaleHeight = 3000
' margin between the left verticale line of a cell and where the value of field is printed
Const mi_CellMargin = 5

Public Enum TOrientation
    Portrait = 1
    LandScape = 2
End Enum

' msng_ScreenToPrinter est la taille estim en nombre de pixel du label lbl_ForPrinter d'une colonne sur l'imprimante (pour une page en landscape divise en 145 colonnes)
Dim msng_ScreenToPrinter As Single

'height of the current font if you use the API of this module to change the font
Dim mi_FontHeight As Integer
Dim mi_TableLineHeight As Integer
Dim mi_LCurrPaper As Integer

Public Type TCell
    x As Single
    y As Single
    Width As Single
    Height As Single
    Label As String
    DataField As String
End Type

Public Sub QryPrintGrid(li_Landscape As Integer, li_CtrTitle As Integer, ls_Title1 As String, ls_Title2 As String, lo_Grid As MSFlexGridLib.MSFlexGrid, lc)

Dim i As Integer
Dim li_HRecord As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

InitPrinter li_Landscape

li_HRecord = 0

For i = 0 To lo_Grid.Rows - 1
    If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        Printer.NewPage
    End If
    If Printer.CurrentY = 0 Then
        SetBold -1
        Printer.Font.Size = 12
        Printer.Print Date;
' Modif for N. PLUTA ==> display all characters of the title even on 2 lines
        SetFontSize 12
        Printer.Print Tab(li_CtrTitle);
        If Len(ls_Title1) < 50 Then
            Printer.Print ls_Title1
        Else
            Printer.Print Mid(ls_Title1, 1, 50)
            Printer.Print Mid(ls_Title1, 51, 50)
            Printer.Print Mid(ls_Title1, 101, 50)
        End If
        SetFontSize 12
        Printer.Print Tab(mi_LCurrPaper - 10);
        Printer.Print "Page " & Printer.Page
        Printer.Print ""
        Printer.Print ""
        Printer.Print ls_Title2
        Printer.Print ""
       
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        li_HRecord = Printer.CurrentY

        SetBold 0
    End If
    lo_Grid.Row = i
    ExDoLine mi_LCurrPaper, lo_Grid, lc
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc

End Sub

Public Sub PrintArmGrid(ByRef av_columns As Variant, ByRef av_colWidths As Variant, ByVal as_caption As String, ByVal as_category As String, ByVal li_Landscape As Integer, ByVal li_CtrTitle As Integer)

Debug.Assert (IsArray(av_columns))
Debug.Assert (IsArray(av_colWidths))
Debug.Assert (UBound(av_columns, 1) = UBound(av_colWidths, 1))

Dim i As Integer
Dim li_HRecord As Integer
'Dim li_LPaper As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

Call InitPrinter(li_Landscape)

li_HRecord = 0

For i = 0 To av_columns(0).Grid.Rows - 1
    If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
        Call DrawBox(li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15)
        Printer.NewPage
    End If
    If Printer.CurrentY = 0 Then
        Call SetBold(True)
        Printer.Font.Size = 12
        Printer.Print Date;
        Call SetFontSize(24)
        Printer.Print Tab(li_CtrTitle);
        Printer.Print as_caption;
        Call SetFontSize(12)
        Printer.Print Tab(mi_LCurrPaper - 5);
        Printer.Print Printer.Page
        Printer.Print ""
        Printer.Print ""
        Printer.Print as_category
        Printer.Print ""
       
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        li_HRecord = Printer.CurrentY
        Call DoArmGridLine(mi_LCurrPaper, av_columns, av_colWidths, -1)
        li_HRecord = Printer.CurrentY - li_HRecord

        Call DrawBox(li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15)
        Call SetBold(False)
    End If
    Call DoArmGridLine(mi_LCurrPaper, av_columns, av_colWidths, i)
Next i
Call DrawBox(li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15)
Printer.EndDoc

End Sub

Public Sub PrintGrid(li_Landscape As Integer, li_CtrTitle As Integer, lc)

Dim i As Integer
Dim li_HRecord As Integer
'Dim li_LPaper As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

InitPrinter li_Landscape

li_HRecord = 0
'If li_Landscape = 1 Then
'    li_LPaper = 100
'    mi_LCurrPaper = 100
'Else
'    If Printer.PaperSize = 1 Then
'        li_LPaper = 135
'        mi_LCurrPaper = 135
'    Else
'        li_LPaper = 145
'        mi_LCurrPaper = 145
'    End If
'End If

For i = 1 To Screen.ActiveForm.Grid.Rows - 1
    If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        Printer.NewPage
    End If
    If Printer.CurrentY = 0 Then
        SetBold -1
        Printer.Font.Size = 12
        Printer.Print Date;
        SetFontSize 24
        Printer.Print Tab(li_CtrTitle);
        Printer.Print Screen.ActiveForm.Caption;
        SetFontSize 12
        Printer.Print Tab(mi_LCurrPaper - 5);
        Printer.Print Printer.Page
        Printer.Print ""
        Printer.Print ""
        Printer.Print Screen.ActiveForm.lbl_Category.Caption
        Printer.Print ""
       
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        li_HRecord = Printer.CurrentY
        Screen.ActiveForm.Grid.Row = 0
        DoLine mi_LCurrPaper, lc
        li_HRecord = Printer.CurrentY - li_HRecord

        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        SetBold 0
    End If
    Screen.ActiveForm.Grid.Row = i
    DoLine mi_LCurrPaper, lc
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc

End Sub


Public Function HeightText(ByVal ls_Field As String, ByVal li_StartColn As Integer, ByVal li_EndColn As Integer) As Double

Dim li_Numchar As Integer
Dim c As String
'Dim i As Integer

'Dim li_NbreLine As Integer
Dim XPos    As Double
Dim YPos    As Double

YPos = 0
XPos = li_StartColn
'li_NbreLine = 1
For li_Numchar = 1 To Len(ls_Field)
    c = Mid(ls_Field, li_Numchar, 1)
    If Asc(c) <> 10 And Asc(c) <> 13 Then
        If (XPos + Printer.TextWidth(c)) > (li_EndColn - mi_CellMargin) Then
            'Printer.Print ""
            YPos = YPos + Printer.TextHeight(c)
            XPos = li_StartColn
            'li_NbreLine = li_NbreLine + 1
        End If
        'Printer.Print c;
        XPos = XPos + Printer.TextWidth(c)
    Else
        If Asc(c) = 13 Then
            'Printer.Print ""
            YPos = YPos + Printer.TextHeight("")
           ' Printer.CurrentX = li_StartColn
            XPos = li_StartColn
        '    li_NbreLine = li_NbreLine + 1
        End If
    End If
Next li_Numchar
HeightText = YPos

End Function

Public Sub PrintField(ByVal ls_Label As String, ByVal ls_Field As String)
Const ALIGN As Integer = 28

SetBold OK
Printer.Print TruncField(ls_Label, ALIGN) & " : ";
SetBold KO
Printer.CurrentX = ((ALIGN + 1) * (mi_Scalewidth / mi_LCurrPaper))
Printer.Print ls_Field

End Sub

Public Sub ExPrintField(ByVal li_LabelLeft As Integer, ByVal ls_Label As String, ByVal li_LabelSize As Integer, ByVal ls_Field As String, ByVal li_FieldSize As Integer)
Dim li_XStartLine  As Integer
Dim li_YStartLine As Integer
Dim li_XEnd As Integer
SetBold OK
Printer.CurrentX = ((li_LabelLeft + 1) * (mi_Scalewidth / mi_LCurrPaper))
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
Printer.Print TruncField(ls_Label, li_LabelSize);
'DrawBox ((li_LabelLeft + 1) * (mi_Scalewidth / mi_LCurrPaper)), li_YStartLine, ((li_LabelLeft + li_LabelSize + 1) * (mi_Scalewidth / mi_LCurrPaper)), li_YStartLine + Printer.TextHeight(ls_label), 1
SetBold KO
Printer.CurrentX = ((li_LabelLeft + li_LabelSize + 1) * (mi_Scalewidth / mi_LCurrPaper))
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
Printer.Print TruncField(ls_Field, li_FieldSize);
li_XEnd = ((li_LabelLeft + li_LabelSize + li_FieldSize + 1) * (mi_Scalewidth / mi_LCurrPaper))
If li_XEnd >= mi_Scalewidth Then
    li_XEnd = mi_Scalewidth - 1
End If
'DrawBox ((li_LabelLeft + li_LabelSize + 1) * (mi_Scalewidth / mi_LCurrPaper)), li_YStartLine, li_XEnd, li_YStartLine + Printer.TextHeight(ls_Field), 1
End Sub

Public Sub ExPrintGrid(li_Landscape As Integer, li_CtrTitle As Integer, ls_Title1 As String, ls_Title2 As String, lo_Grid As MSFlexGridLib.MSFlexGrid, lc)

Dim i As Integer
Dim li_HRecord As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer


InitPrinter li_Landscape

li_HRecord = 0

For i = 1 To lo_Grid.Rows - 1
    If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        Printer.NewPage
    End If
    If Printer.CurrentY = 0 Then
        SetBold -1
        Printer.Font.Size = 12
        Printer.Print Date;
        SetFontSize 24
        Printer.Print Tab(li_CtrTitle);
'        Printer.Print Screen.ActiveForm.Caption;
        Printer.Print ls_Title1
        SetFontSize 12
        Printer.Print Tab(mi_LCurrPaper - 5);
        Printer.Print Printer.Page
        Printer.Print ""
        Printer.Print ""
'        Printer.Print Screen.ActiveForm.lbl_category.Caption
        Printer.Print ls_Title2
        Printer.Print ""
       
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        li_HRecord = Printer.CurrentY
'        Screen.ActiveForm.Grid.Row = 0
        lo_Grid.Row = 0
        ExDoLine mi_LCurrPaper, lo_Grid, lc
        li_HRecord = Printer.CurrentY - li_HRecord

        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        SetBold 0
    End If
    lo_Grid.Row = i
'    Screen.ActiveForm.Grid.Row = i
    ExDoLine mi_LCurrPaper, lo_Grid, lc
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc

End Sub


Public Sub DoLine(li_LPaper As Integer, lc)

Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim li_NbreColn As Integer
Dim li_NbreRow  As Integer
Dim Xdeb As Integer
Dim Xfin As Integer
Dim li_XStartLine As Integer
Dim li_YStartLine As Integer


lb_Multiline = KO
li_Gap = 0
li_NbreColn = 0
For i = 0 To UBound(lc, 1)
    li_NbreColn = li_NbreColn + lc(i)
Next i
li_NbreRow = li_NbreColn / li_LPaper
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        If li_Gap + lc(i) > li_LPaper Then
            Printer.Print ""
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        Screen.ActiveForm.Grid.Col = i
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
        Printer.Print TruncField(Screen.ActiveForm.Grid.Text, lc(i));
 '       Printer.Print TruncField("ABCDEFGHIJKLMNOPQRSTUVABCDEFGHIJKLMNOPQRSTUV", LC(i));
        DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1
        li_Gap = li_Gap + lc(i)
    End If
Next i
Printer.Print ""
If lb_Multiline And Screen.ActiveForm.Grid.Row <> 0 And Printer.CurrentY <> 0 Then
    DrawBox li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
End If

End Sub

Public Sub DoLineQuotation(li_LPaper As Integer, lo_Grid As MSFlexGridLib.MSFlexGrid, lc, li_FontSizeCell As Integer, li_FontSizeInterLine As Integer)

Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim li_NbreColn As Integer
Dim li_NbreRow  As Integer
Dim Xdeb As Integer
Dim Xfin As Integer
Dim li_XStartLine As Integer
Dim li_YStartLine As Integer

Dim lsgn_PrinterHeightInterLine As Single
Dim lsgn_PrinterHeightCell As Single

lb_Multiline = KO
SetFontSize li_FontSizeInterLine
lsgn_PrinterHeightInterLine = Printer.TextHeight("")
SetFontSize li_FontSizeCell
lsgn_PrinterHeightCell = Printer.TextHeight("")

SetFontSize li_FontSizeCell

lb_Multiline = KO
li_Gap = 0
li_NbreColn = 0
For i = 0 To UBound(lc, 1)
    li_NbreColn = li_NbreColn + lc(i)
Next i
li_NbreRow = li_NbreColn / li_LPaper
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        If li_Gap + lc(i) > li_LPaper Then
            SetFontSize li_FontSizeInterLine
            Printer.Print ""
            SetFontSize li_FontSizeCell
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        lo_Grid.Col = i
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
        Printer.Print TruncField(lo_Grid.Text, lc(i));
 '       Printer.Print TruncField("ABCDEFGHIJKLMNOPQRSTUVABCDEFGHIJKLMNOPQRSTUV", LC(i));
        DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + lsgn_PrinterHeightInterLine - 10, 1
        li_Gap = li_Gap + lc(i)
    End If
Next i
SetFontSize li_FontSizeInterLine
Printer.Print ""
SetFontSize li_FontSizeCell

If lb_Multiline And Screen.ActiveForm.Grid.Row <> 0 And Printer.CurrentY <> 0 Then
    DrawBox li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
End If

End Sub


Private Sub ExDoLine(li_LPaper As Integer, lo_Grid As MSFlexGridLib.MSFlexGrid, lc)

Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim li_NbreColn As Integer
Dim li_NbreRow  As Integer
Dim Xdeb As Integer
Dim Xfin As Integer
Dim li_XStartLine As Integer
Dim li_YStartLine As Integer


lb_Multiline = KO
li_Gap = 0
li_NbreColn = 0
For i = 0 To UBound(lc, 1)
    li_NbreColn = li_NbreColn + lc(i)
Next i
li_NbreRow = li_NbreColn / li_LPaper
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        If li_Gap + lc(i) > li_LPaper Then
            Printer.Print ""
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
'        Screen.ActiveForm.Grid.Col = i
        lo_Grid.Col = i
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
'        Printer.Print TruncField(Screen.ActiveForm.Grid.Text, LC(i));
        Printer.Print TruncField(lo_Grid.Text, lc(i));
        DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1
        li_Gap = li_Gap + lc(i)
    End If
Next i
Printer.Print ""
'If lb_Multiline And Screen.ActiveForm.Grid.Row <> 0 And Printer.CurrentY <> 0 Then
If lb_Multiline And lo_Grid.Row <> 0 And Printer.CurrentY <> 0 Then
    DrawBox li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
End If

End Sub


Public Sub DoLineWordWarp(li_LPaper As Integer, lc)
'doesn't support multiligne row of data
Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim j As Integer
Dim li_NbreColn As Integer
Dim li_NbreRow  As Integer
Dim Xdeb As Integer
Dim Xfin As Integer
Dim li_XStartLine As Integer
Dim li_YStartLine As Integer
Dim li_NbreLine As Integer
Dim li_MaxLine As Integer
Dim li_MaxCurrLine As Integer

lb_Multiline = KO
li_Gap = 0
li_NbreColn = 0
For i = 0 To UBound(lc, 1)
    li_NbreColn = li_NbreColn + lc(i)
Next i
li_NbreRow = li_NbreColn / li_LPaper
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
li_MaxLine = 1
li_MaxCurrLine = 1
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        If li_Gap + lc(i) > li_LPaper Then
            ' if we are in this case it's an error this is not supported for the draw of the grid
            For j = 1 To li_MaxCurrLine
                Printer.Print ""
                li_MaxCurrLine = 1
            Next j
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        Screen.ActiveForm.Grid.Col = i
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
        li_NbreLine = PrintCellMultiLine(Screen.ActiveForm.Grid.Text, Printer.CurrentX, Xfin)
        If li_NbreLine > li_MaxLine Then
            li_MaxLine = li_NbreLine
        End If
        If li_NbreLine > li_MaxCurrLine Then
            li_MaxCurrLine = li_NbreLine
        End If
'        DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1
        li_Gap = li_Gap + lc(i)
    End If
Next i
li_Gap = 0
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight * li_MaxLine - 10, 1
        li_Gap = li_Gap + lc(i)
    End If
Next i
For j = 1 To li_MaxLine
    Printer.Print ""
Next j
If lb_Multiline And Screen.ActiveForm.Grid.Row <> 0 And Printer.CurrentY <> 0 Then
    DrawBox li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
End If

End Sub

Public Sub DoLineWordWarpQuotation(li_LPaper As Integer, lc, li_FontSizeCell As Integer, li_FontSizeInterLine As Integer)
'doesn't support multiligne row of data
Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim j As Integer
Dim li_NbreColn As Integer
Dim li_NbreRow  As Integer
Dim Xdeb As Integer
Dim Xfin As Integer
Dim li_XStartLine As Integer
Dim li_YStartLine As Integer
Dim li_NbreLine As Integer
Dim li_MaxLine As Integer
Dim li_MaxCurrLine As Integer

Dim lsgn_PrinterHeightInterLine As Single
Dim lsgn_PrinterHeightCell As Single

lb_Multiline = KO
SetFontSize li_FontSizeInterLine
lsgn_PrinterHeightInterLine = Printer.TextHeight("")
SetFontSize li_FontSizeCell
lsgn_PrinterHeightCell = Printer.TextHeight("")

li_Gap = 0
li_NbreColn = 0
For i = 0 To UBound(lc, 1)
    li_NbreColn = li_NbreColn + lc(i)
Next i
li_NbreRow = li_NbreColn / li_LPaper
li_XStartLine = Printer.CurrentX
li_YStartLine = Printer.CurrentY
li_MaxLine = 1
li_MaxCurrLine = 1

SetFontSize li_FontSizeCell
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        If li_Gap + lc(i) > li_LPaper Then
            ' if we are in this case it's an error this is not supported for the draw of the grid
            For j = 1 To li_MaxCurrLine - 1
                SetFontSize li_FontSizeCell
                Printer.Print ""
                li_MaxCurrLine = 1
            Next j
            SetFontSize li_FontSizeInterLine
            Printer.Print ""
            SetFontSize li_FontSizeCell
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        Screen.ActiveForm.Grid.Col = i
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
        li_NbreLine = PrintCellMultiLine(Screen.ActiveForm.Grid.Text, Printer.CurrentX, Xfin)
        If li_NbreLine > li_MaxLine Then
            li_MaxLine = li_NbreLine
        End If
        If li_NbreLine > li_MaxCurrLine Then
            li_MaxCurrLine = li_NbreLine
        End If
        li_Gap = li_Gap + lc(i)
    End If
Next i
li_Gap = 0
For i = 0 To UBound(lc, 1)
    If lc(i) <> 0 Then
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + lc(i)))
        If li_MaxLine > 1 Then
            DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + lsgn_PrinterHeightInterLine + lsgn_PrinterHeightCell * (li_MaxLine - 1) - 10, 1
        Else
            DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + lsgn_PrinterHeightInterLine - 10, 1
        End If
        li_Gap = li_Gap + lc(i)
    End If
Next i
For j = 1 To li_MaxLine - 1
    SetFontSize li_FontSizeCell
    Printer.Print ""
Next j
SetFontSize li_FontSizeInterLine
Printer.Print ""
SetFontSize li_FontSizeCell
If lb_Multiline And Screen.ActiveForm.Grid.Row <> 0 And Printer.CurrentY <> 0 Then
    DrawBox li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
End If

End Sub


Public Sub PrintGridWithTotal(li_Landscape As Integer, li_CtrTitle As Integer, lc, LCTotal)
' we work in 2 pass, we first print all normal data then in a second pass we print all total data
Dim i As Integer
Dim li_HRecord As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

InitPrinter li_Landscape
li_HRecord = 0
For i = 1 To Screen.ActiveForm.Grid.Rows - 1
    Screen.ActiveForm.Grid.Row = i
    Screen.ActiveForm.Grid.Col = UBound(lc, 1)
    If right(Screen.ActiveForm.Grid.Text, 2) <> "13" Then
        If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
            DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
            Printer.NewPage
        End If
        If (Printer.CurrentY = 0) Then
                Printer.Font.Bold = -1
                Printer.Font.Size = 12
                Printer.Print Date;
                SetFontSize 24
                Printer.Print Tab(li_CtrTitle);
                Printer.Print Screen.ActiveForm.Caption;
                SetFontSize 12
                Printer.Print Tab(mi_LCurrPaper - 5);
                Printer.Print Printer.Page
                Printer.Print ""
                Printer.Print ""
                Printer.Print Screen.ActiveForm.lbl_Category.Caption
                Printer.Print ""
               
                li_XStartTable = Printer.CurrentX
                li_YStartTable = Printer.CurrentY
                li_HRecord = Printer.CurrentY
                Screen.ActiveForm.Grid.Row = 0
                DoLine mi_LCurrPaper, lc
    
                li_HRecord = Printer.CurrentY - li_HRecord
                DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
                Printer.Font.Bold = 0
        End If
        Screen.ActiveForm.Grid.Row = i
        Screen.ActiveForm.Grid.Col = UBound(lc, 1)
        DoLine mi_LCurrPaper, lc
    End If
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc

' total part
InitPrinter li_Landscape

li_HRecord = 0

For i = 1 To Screen.ActiveForm.Grid.Rows - 1
    Screen.ActiveForm.Grid.Row = i
    Screen.ActiveForm.Grid.Col = UBound(lc, 1)
    If right(Screen.ActiveForm.Grid.Text, 2) = "13" Then

        If Printer.CurrentY > (mi_ScaleHeight - li_HRecord) Then
            DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
            Printer.NewPage
        End If
    
        If (Printer.CurrentY = 0) Then
            Printer.Font.Bold = -1
            Printer.Font.Size = 12
            Printer.Print Date;
            SetFontSize 24
            Printer.Print Tab(li_CtrTitle);
            Printer.Print "Total " & Screen.ActiveForm.Caption;
            SetFontSize 12
            Printer.Print Tab(mi_LCurrPaper - 5);
            Printer.Print Printer.Page
            Printer.Print ""
            Printer.Print ""
            Printer.Print Screen.ActiveForm.lbl_Category.Caption
            Printer.Print ""
           
            li_XStartTable = Printer.CurrentX
            li_YStartTable = Printer.CurrentY
            li_HRecord = Printer.CurrentY
            Screen.ActiveForm.Grid.Row = 0
            DoLine mi_LCurrPaper, LCTotal
            li_HRecord = Printer.CurrentY - li_HRecord
            DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
            Printer.Font.Bold = 0
        End If
        Screen.ActiveForm.Grid.Row = i
        Screen.ActiveForm.Grid.Col = UBound(lc, 1)
        DoLine mi_LCurrPaper, LCTotal
    End If
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc


End Sub

' al_row  = -1 means print column header
Private Sub DoArmGridLine(li_LPaper As Integer, ByRef av_columns As Variant, ByRef av_colWidths As Variant, ByVal al_row As Long)
Debug.Assert (UBound(av_columns) = UBound(av_colWidths))

    Dim li_Gap As Integer
    Dim lb_Multiline As Boolean
    Dim i As Integer
    Dim Xdeb As Integer
    Dim Xfin As Integer
    Dim li_XStartLine As Integer
    Dim li_YStartLine As Integer

    lb_Multiline = KO
    li_Gap = 0
    li_XStartLine = Printer.CurrentX
    li_YStartLine = Printer.CurrentY
    For i = LBound(av_columns) To UBound(av_columns, 1)
        If li_Gap + av_colWidths(i) > li_LPaper Then
            Printer.Print ""
            li_Gap = 0
            lb_Multiline = OK
        End If
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + av_colWidths(i)))
        
        Printer.CurrentX = (mi_Scalewidth / li_LPaper * li_Gap) + mi_CellMargin
        If al_row = -1 Then
            Printer.Print TruncField(av_columns(i).Title, av_colWidths(i));
        Else
            Printer.Print TruncField(av_columns(i).GetData(al_row), av_colWidths(i));
        End If
        
        Call DrawBox(Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1)
        li_Gap = li_Gap + av_colWidths(i)
    Next i
    Printer.Print ""
    If lb_Multiline And al_row <> -1 And Printer.CurrentY <> 0 Then
        Call DrawBox(li_XStartLine, li_YStartLine - 10, mi_Scalewidth, Printer.CurrentY - 10, 15)
    End If

End Sub

Public Sub DCPrintLine(ms_Print, li_LPaper As Integer, LNb As Integer, ByVal lb_SmallLine As Boolean)
' this is the modificated procedure that print DC load plan information
' with now a grid and with field truncated to the cell size
Dim li_Gap As Integer
Dim lb_Multiline As Boolean
Dim i As Integer
Dim Xdeb As Integer
Dim Xfin As Integer

Printer.CurrentX = mi_CellMargin
lb_Multiline = KO
li_Gap = 0


Select Case gs_TableName
Case "DC_Customer"
    Printer.Font.Italic = 0
       For i = 0 To 11
        If li_Gap + Array(75, 22, 22, 4, 17, 12, 12, 12, 78, 12, 15, 120)(i) > li_LPaper Then   ' task286 JUNA correction 12 to 22
            Printer.Print ""
            Printer.Font.Italic = -1
            li_Gap = 0
            lb_Multiline = OK
            If lb_SmallLine = OK Then
                DrawLine Printer.CurrentX, Printer.CurrentY - 10, 3000, Printer.CurrentY - 10, 1
            End If
            Printer.CurrentX = 5
        End If

        Printer.CurrentX = ((mi_Scalewidth / li_LPaper) * li_Gap) + mi_CellMargin
        Printer.Print TruncField(ms_Print(i, LNb), Array(75, 22, 22, 4, 17, 12, 12, 12, 78, 15, 15, 120)(i));       ' task286 JUNA correction 12 to 22
        ' Printer.Print ms_Print(i, LNb);
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + Array(75, 22, 22, 4, 17, 12, 12, 12, 78, 15, 15, 120)(i)))      ' task286 JUNA correction 12 to 22
        If lb_SmallLine = OK Then
            If lb_Multiline = OK Then
                DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight * 2 - 40, 1
            Else
                DrawBox Xdeb, Printer.CurrentY - 40, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1
            End If
        End If
        li_Gap = li_Gap + Array(75, 22, 22, 4, 17, 12, 12, 12, 78, 15, 15, 120)(i)      ' task286 JUNA correction 12 to 22
        
    Next i
Case Else
    Printer.Font.Italic = 0
    For i = 0 To 11
        If li_Gap + Array(20, 15, 15, 50, 4, 10, 12, 19, 30, 90, 15, 10)(i) > li_LPaper Then
            Printer.Print ""
            Printer.Font.Italic = -1
            li_Gap = 0
            lb_Multiline = OK
            If lb_SmallLine = OK Then
                DrawLine Printer.CurrentX, Printer.CurrentY - 10, 3000, Printer.CurrentY - 10, 1
            End If
            Printer.CurrentX = 5
        End If

        Printer.CurrentX = ((mi_Scalewidth / li_LPaper) * li_Gap) + mi_CellMargin
        Printer.Print TruncField(ms_Print(i, LNb), Array(20, 15, 15, 50, 4, 10, 12, 19, 30, 90, 15, 10)(i));
        ' Printer.Print ms_Print(i, LNb);
        Xdeb = (li_Gap * (mi_Scalewidth / li_LPaper))
        Xfin = ((mi_Scalewidth / li_LPaper) * (li_Gap + Array(20, 15, 15, 50, 4, 10, 12, 19, 30, 90, 15, 10)(i)))
        If lb_SmallLine = OK Then
            If lb_Multiline = OK Then
                DrawBox Xdeb, Printer.CurrentY - 10, Xfin, Printer.CurrentY + mi_FontHeight * 2 - 40, 1
            Else
                DrawBox Xdeb, Printer.CurrentY - 40, Xfin, Printer.CurrentY + mi_FontHeight - 10, 1
            End If
        End If
        li_Gap = li_Gap + Array(20, 15, 15, 50, 4, 10, 12, 19, 30, 90, 15, 10)(i)
        
    Next i
End Select
If lb_Multiline And Printer.CurrentY <> 0 Then
'    Printer.CurrentX = 10
    Printer.CurrentX = mi_CellMargin
End If
End Sub

Public Sub DCCustomerLayout(ByRef llp_pos() As TCell)
    Const C_CUSTN1 As Long = 0
    Const C_Order_Number As Long = 1
    Const C_Ship_To_Address As Long = 2
    Const C_Shipment_Number As Long = 3
    Const C_Trailer_Number As Long = 4
    Const C_COS_Contact As Long = 5
    Const C_Quantity As Long = 6
    Const C_EQ_Code As Long = 7
    Const C_Load_Planned_Starting_Time As Long = 8
    Const C_Delivery_Date As Long = 9
    Const C_Container_Number As Long = 10
    Const C_Stand_Trailer As Long = 11
    Const C_Remark As Long = 12
    Const C_Delivery_Number As Long = 13
    
    ReDim llp_pos(13) As TCell
    
    Dim ll_col1 As Single
    Dim ll_col2 As Single
    Dim ll_col3 As Single
    ll_col1 = 0.025
    ll_col3 = ml_printAreaHorz - 20
    ll_col2 = ll_col3 - 27
    
    Dim ll_rowH As Single
    ll_rowH = 1.2
    
    Dim ll_col1w As Single
    Dim ll_col2w As Single
    Dim ll_col3w As Single
    ll_col1w = ll_col2 - ll_col1
    ll_col2w = ll_col3 - ll_col2
    ll_col3w = ml_printAreaHorz - ll_col3
    
    
    Printer.Font.Bold = True

    llp_pos(C_CUSTN1).x = ll_col1                       ' customer
    llp_pos(C_CUSTN1).y = 0 * ll_rowH
    llp_pos(C_CUSTN1).Height = ll_rowH
    llp_pos(C_CUSTN1).DataField = "CUSTN1"
    llp_pos(C_CUSTN1).Label = "Customer"
    llp_pos(C_CUSTN1).Width = ll_col1w - Printer.TextWidth(llp_pos(C_CUSTN1).Label & ":  ")
    
    llp_pos(C_Order_Number).x = ll_col2                 ' Order_Number
    llp_pos(C_Order_Number).y = 0 * ll_rowH
    llp_pos(C_Order_Number).Height = ll_rowH
    llp_pos(C_Order_Number).DataField = "Order_Number"
    llp_pos(C_Order_Number).Label = "Order n"
    llp_pos(C_Order_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Order_Number).Label & ":  ")
    
    llp_pos(C_Shipment_Number).x = ll_col2              ' Shipment_Number
    llp_pos(C_Shipment_Number).y = 1 * ll_rowH
    llp_pos(C_Shipment_Number).Height = ll_rowH
    llp_pos(C_Shipment_Number).DataField = "Shipment_Number"
    llp_pos(C_Shipment_Number).Label = "Shipment n"
    llp_pos(C_Shipment_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Shipment_Number).Label & ":  ")
    
    llp_pos(C_Ship_To_Address).x = ll_col1              ' Ship_To_Address
    llp_pos(C_Ship_To_Address).y = 1 * ll_rowH
    llp_pos(C_Ship_To_Address).Height = ll_rowH
    llp_pos(C_Ship_To_Address).DataField = "Ship_To_Address"
    llp_pos(C_Ship_To_Address).Label = "Ship to address"
    llp_pos(C_Ship_To_Address).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Ship_To_Address).Label & ":  ")
    
    llp_pos(C_Stand_Trailer).x = ll_col3                ' Stand_Trailer
    llp_pos(C_Stand_Trailer).y = 3 * ll_rowH
    llp_pos(C_Stand_Trailer).Height = ll_rowH
    llp_pos(C_Stand_Trailer).DataField = "Stand_Trailer"
    llp_pos(C_Stand_Trailer).Label = "ST"
    llp_pos(C_Stand_Trailer).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Stand_Trailer).Label & ":  ")
    
    llp_pos(C_Quantity).x = ll_col1 + 40        ' Quantity
    llp_pos(C_Quantity).y = 2 * ll_rowH
    llp_pos(C_Quantity).Height = ll_rowH
    llp_pos(C_Quantity).DataField = "Quantity"
    llp_pos(C_Quantity).Label = "Quantity"
    llp_pos(C_Quantity).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Quantity).Label & ":  ")
    
    
    llp_pos(C_Container_Number).x = ll_col2             ' Container_Number
    llp_pos(C_Container_Number).y = 3 * ll_rowH
    llp_pos(C_Container_Number).Height = ll_rowH
    llp_pos(C_Container_Number).DataField = "Container_Number"
    llp_pos(C_Container_Number).Label = "Cont"
    llp_pos(C_Container_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Container_Number).Label & ":  ")
    
    llp_pos(C_Trailer_Number).x = ll_col3               ' Trailer_Number
    llp_pos(C_Trailer_Number).y = 1 * ll_rowH
    llp_pos(C_Trailer_Number).Height = ll_rowH
    llp_pos(C_Trailer_Number).DataField = "Trailer_Number"
    llp_pos(C_Trailer_Number).Label = "Trailer n"
    llp_pos(C_Trailer_Number).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Trailer_Number).Label & ":  ")
    
    llp_pos(C_EQ_Code).x = ll_col3                      ' EQ_Code
    llp_pos(C_EQ_Code).y = 2 * ll_rowH
    llp_pos(C_EQ_Code).Height = ll_rowH
    llp_pos(C_EQ_Code).DataField = "EQ_Code"
    llp_pos(C_EQ_Code).Label = "Equip"
    llp_pos(C_EQ_Code).Width = ll_col3w - Printer.TextWidth(llp_pos(C_EQ_Code).Label & ":  ")
    
    llp_pos(C_Remark).x = ll_col1                       ' Remark
    llp_pos(C_Remark).y = 4 * ll_rowH
    llp_pos(C_Remark).Height = ll_rowH
    llp_pos(C_Remark).DataField = "Remark"
    llp_pos(C_Remark).Label = "Remarks"
    llp_pos(C_Remark).Width = ml_printAreaHorz - ll_col1 - Printer.TextWidth(llp_pos(C_Remark).Label & ":  ")
    
    llp_pos(C_COS_Contact).x = ll_col1                  ' COS_Contact
    llp_pos(C_COS_Contact).y = 2 * ll_rowH
    llp_pos(C_COS_Contact).Height = ll_rowH
    llp_pos(C_COS_Contact).DataField = "COS_Contact"
    llp_pos(C_COS_Contact).Label = "COS Contact"
    llp_pos(C_COS_Contact).Width = ll_col1w - Printer.TextWidth(llp_pos(C_COS_Contact).Label & ":  ")
    
    llp_pos(C_Delivery_Date).x = ll_col1   ' delivery date
    llp_pos(C_Delivery_Date).y = 3 * ll_rowH
    llp_pos(C_Delivery_Date).Height = ll_rowH
    llp_pos(C_Delivery_Date).DataField = "Delivery_Date"
    llp_pos(C_Delivery_Date).Label = "Delivery date"
    llp_pos(C_Delivery_Date).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Delivery_Date).Label & ":  ")
    
    llp_pos(C_Load_Planned_Starting_Time).x = ll_col1 + 40   ' Load_Planned_Starting_Time
    llp_pos(C_Load_Planned_Starting_Time).y = 3 * ll_rowH
    llp_pos(C_Load_Planned_Starting_Time).Height = ll_rowH
    llp_pos(C_Load_Planned_Starting_Time).DataField = "Load_Planned_Starting_Time"
    llp_pos(C_Load_Planned_Starting_Time).Label = "Start"
    llp_pos(C_Load_Planned_Starting_Time).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Load_Planned_Starting_Time).Label & ":  ")
    
    llp_pos(C_Delivery_Number).x = ll_col2   ' Delivery Number
    llp_pos(C_Delivery_Number).y = 2 * ll_rowH
    llp_pos(C_Delivery_Number).Height = ll_rowH
    llp_pos(C_Delivery_Number).DataField = "Delivery_number"
    llp_pos(C_Delivery_Number).Label = "Delivery n"
    llp_pos(C_Delivery_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Delivery_Number).Label & ":  ")



End Sub

Public Sub DCIntercompanyLayout(ByRef llp_pos() As TCell)

    Const C_CUSTN1 As Long = 0
    Const C_Order_Number As Long = 1
    Const C_Ship_To_Address As Long = 2
    Const C_Shipment_Number As Long = 3
    Const C_Trailer_Number As Long = 4
    Const C_COS_Contact As Long = 5
    Const C_Quantity As Long = 6
    Const C_EQ_Code As Long = 7
'    Const C_Load_Planned_Starting_Time As Long = 8
    Const C_Delivery_Date As Long = 8
    Const C_Container_Number As Long = 9
    Const C_Stand_Trailer As Long = 10
    Const C_Remark As Long = 11
    Const C_Delivery_Number As Long = 12

    ReDim llp_pos(12) As TCell

    Dim ll_col1 As Single
    Dim ll_col2 As Single
    Dim ll_col3 As Single
    ll_col1 = 0.025
    ll_col3 = ml_printAreaHorz - 20
    ll_col2 = ll_col3 - 27
    
    Dim ll_rowH As Single
    ll_rowH = 1.2
    
    Dim ll_col1w As Single
    Dim ll_col2w As Single
    Dim ll_col3w As Single
    ll_col1w = ll_col2 - ll_col1
    ll_col2w = ll_col3 - ll_col2
    ll_col3w = ml_printAreaHorz - ll_col3
    
    
    Printer.Font.Bold = True
    llp_pos(C_CUSTN1).x = ll_col1                 ' customer
    llp_pos(C_CUSTN1).y = 0 * ll_rowH
    llp_pos(C_CUSTN1).Height = ll_rowH
    llp_pos(C_CUSTN1).DataField = "CUSTN1"
    llp_pos(C_CUSTN1).Label = "Customer"
    llp_pos(C_CUSTN1).Width = ll_col1w - Printer.TextWidth(llp_pos(C_CUSTN1).Label & ":  ")
    
    
    llp_pos(C_Order_Number).x = ll_col2          ' Order_Number
    llp_pos(C_Order_Number).y = 0 * ll_rowH
    llp_pos(C_Order_Number).Height = ll_rowH
    llp_pos(C_Order_Number).DataField = "Order_Number"
    llp_pos(C_Order_Number).Label = "Order n"
    llp_pos(C_Order_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Order_Number).Label & ":  ")
    
    
    llp_pos(C_Shipment_Number).x = ll_col2       ' Shipment_Number
    llp_pos(C_Shipment_Number).y = 1 * ll_rowH
    llp_pos(C_Shipment_Number).Height = ll_rowH
    llp_pos(C_Shipment_Number).DataField = "Shipment_Number"
    llp_pos(C_Shipment_Number).Label = "Shipment n"
    llp_pos(C_Shipment_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Shipment_Number).Label & ":  ")
    
    
    llp_pos(C_Ship_To_Address).x = ll_col1       ' Ship_To_Address
    llp_pos(C_Ship_To_Address).y = 1 * ll_rowH
    llp_pos(C_Ship_To_Address).Height = ll_rowH
    llp_pos(C_Ship_To_Address).DataField = "Ship_To_Address"
    llp_pos(C_Ship_To_Address).Label = "Ship to address"
    llp_pos(C_Ship_To_Address).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Ship_To_Address).Label & ":  ")
    
    
    llp_pos(C_Stand_Trailer).x = ll_col3         ' Stand_Trailer
    llp_pos(C_Stand_Trailer).y = 3 * ll_rowH
    llp_pos(C_Stand_Trailer).Height = ll_rowH
    llp_pos(C_Stand_Trailer).DataField = "Stand_Trailer"
    llp_pos(C_Stand_Trailer).Label = "ST"
    llp_pos(C_Stand_Trailer).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Stand_Trailer).Label & ":  ")
    
    
    llp_pos(C_Quantity).x = ll_col1 + 40       ' Quantity
    llp_pos(C_Quantity).y = 2 * ll_rowH
    llp_pos(C_Quantity).Height = ll_rowH
    llp_pos(C_Quantity).DataField = "Quantity"
    llp_pos(C_Quantity).Label = "Quantity"
    llp_pos(C_Quantity).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Quantity).Label & ":  ")
    
    
    llp_pos(C_Container_Number).x = ll_col2      ' Container_Number
    llp_pos(C_Container_Number).y = 3 * ll_rowH
    llp_pos(C_Container_Number).Height = ll_rowH
    llp_pos(C_Container_Number).DataField = "Container_Number"
    llp_pos(C_Container_Number).Label = "Cont"
    llp_pos(C_Container_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Container_Number).Label & ":  ")
    
    
    llp_pos(C_Trailer_Number).x = ll_col3        ' Trailer_Number
    llp_pos(C_Trailer_Number).y = 1 * ll_rowH
    llp_pos(C_Trailer_Number).Height = ll_rowH
    llp_pos(C_Trailer_Number).DataField = "Trailer_Number"
    llp_pos(C_Trailer_Number).Label = "Trailer n"
    llp_pos(C_Trailer_Number).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Trailer_Number).Label & ":  ")
    
    
    llp_pos(C_EQ_Code).x = ll_col3               ' EQ_Code
    llp_pos(C_EQ_Code).y = 2 * ll_rowH
    llp_pos(C_EQ_Code).Height = ll_rowH
    llp_pos(C_EQ_Code).DataField = "EQ_Code"
    llp_pos(C_EQ_Code).Label = "Equip"
    llp_pos(C_EQ_Code).Width = ll_col3w - Printer.TextWidth(llp_pos(C_EQ_Code).Label & ":  ")
    
    
    llp_pos(C_Remark).x = ll_col1                ' Remark
    llp_pos(C_Remark).y = 4 * ll_rowH
    llp_pos(C_Remark).Height = ll_rowH
    llp_pos(C_Remark).DataField = "Remark"
    llp_pos(C_Remark).Label = "Remarks"
    llp_pos(C_Remark).Width = ml_printAreaHorz - ll_col1 - Printer.TextWidth(llp_pos(C_Remark).Label & ":  ")
    
    llp_pos(C_COS_Contact).x = ll_col1           ' COS_Contact
    llp_pos(C_COS_Contact).y = 2 * ll_rowH
    llp_pos(C_COS_Contact).Height = ll_rowH
    llp_pos(C_COS_Contact).DataField = "COS_Contact"
    llp_pos(C_COS_Contact).Label = "COS Contact"
    llp_pos(C_COS_Contact).Width = ll_col1w - Printer.TextWidth(llp_pos(C_COS_Contact).Label & ":  ")
    
    
    llp_pos(C_Delivery_Date).x = ll_col1     ' Load_Planned_Starting_Time
    llp_pos(C_Delivery_Date).y = 3 * ll_rowH
    llp_pos(C_Delivery_Date).Height = ll_rowH
    llp_pos(C_Delivery_Date).DataField = "Delivery_Date"
    llp_pos(C_Delivery_Date).Label = "Delivery date"
    llp_pos(C_Delivery_Date).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Delivery_Date).Label & ":  ")
    
    llp_pos(C_Delivery_Number).x = ll_col2     ' Delivery Number
    llp_pos(C_Delivery_Number).y = 2 * ll_rowH
    llp_pos(C_Delivery_Number).Height = ll_rowH
    llp_pos(C_Delivery_Number).DataField = "Delivery_number"
    llp_pos(C_Delivery_Number).Label = "Delivery n"
    llp_pos(C_Delivery_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Delivery_Number).Label & ":  ")
    
    
End Sub

Public Sub DCReceiptsLayout(ByRef llp_pos() As TCell)

    Const C_CUSTN1 As Long = 0
    Const C_Order_Number As Long = 1
    Const C_Ship_To_Address As Long = 2
    Const C_Shipment_Number As Long = 3
    Const C_Trailer_Number As Long = 4
    Const C_COS_Contact As Long = 5
    Const C_Quantity As Long = 6
    Const C_EQ_Code As Long = 7
'    Const C_Load_Planned_Starting_Time As Long = 8
    Const C_Delivery_Date As Long = 8
    Const C_Container_Number As Long = 9
    Const C_Stand_Trailer As Long = 10
    Const C_Remark As Long = 11
    
    ReDim llp_pos(11) As TCell

    Dim ll_col1 As Single
    Dim ll_col2 As Single
    Dim ll_col3 As Single
    ll_col1 = 0.025
    ll_col3 = ml_printAreaHorz - 20
    ll_col2 = ll_col3 - 27
    
    Dim ll_rowH As Single
    ll_rowH = 1.2
    
    Dim ll_col1w As Single
    Dim ll_col2w As Single
    Dim ll_col3w As Single
    ll_col1w = ll_col2 - ll_col1
    ll_col2w = ll_col3 - ll_col2
    ll_col3w = ml_printAreaHorz - ll_col3
    
    
    Printer.Font.Bold = True
    llp_pos(C_CUSTN1).x = ll_col1                 ' customer
    llp_pos(C_CUSTN1).y = 0 * ll_rowH
    llp_pos(C_CUSTN1).Height = ll_rowH
    llp_pos(C_CUSTN1).DataField = "CUSTN1"
    llp_pos(C_CUSTN1).Label = "Customer"
    llp_pos(C_CUSTN1).Width = ll_col1w - Printer.TextWidth(llp_pos(C_CUSTN1).Label & ":  ")
    
    
    llp_pos(C_Order_Number).x = ll_col2          ' Order_Number
    llp_pos(C_Order_Number).y = 0 * ll_rowH
    llp_pos(C_Order_Number).Height = ll_rowH
    llp_pos(C_Order_Number).DataField = "Order_Number"
    llp_pos(C_Order_Number).Label = "Order n"
    llp_pos(C_Order_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Order_Number).Label & ":  ")
    
    
    llp_pos(C_Shipment_Number).x = ll_col2       ' Shipment_Number
    llp_pos(C_Shipment_Number).y = 1 * ll_rowH
    llp_pos(C_Shipment_Number).Height = ll_rowH
    llp_pos(C_Shipment_Number).DataField = "Shipment_Number"
    llp_pos(C_Shipment_Number).Label = "Shipment n"
    llp_pos(C_Shipment_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Shipment_Number).Label & ":  ")
    
    
    llp_pos(C_Ship_To_Address).x = ll_col1       ' Ship_To_Address
    llp_pos(C_Ship_To_Address).y = 1 * ll_rowH
    llp_pos(C_Ship_To_Address).Height = ll_rowH
    llp_pos(C_Ship_To_Address).DataField = "Ship_To_Address"
    llp_pos(C_Ship_To_Address).Label = "Ship to address"
    llp_pos(C_Ship_To_Address).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Ship_To_Address).Label & ":  ")
    
    
    llp_pos(C_Stand_Trailer).x = ll_col3         ' Stand_Trailer
    llp_pos(C_Stand_Trailer).y = 3 * ll_rowH
    llp_pos(C_Stand_Trailer).Height = ll_rowH
    llp_pos(C_Stand_Trailer).DataField = "Stand_Trailer"
    llp_pos(C_Stand_Trailer).Label = "ST"
    llp_pos(C_Stand_Trailer).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Stand_Trailer).Label & ":  ")
    
    
    llp_pos(C_Quantity).x = ll_col2              ' Quantity
    llp_pos(C_Quantity).y = 2 * ll_rowH
    llp_pos(C_Quantity).Height = ll_rowH
    llp_pos(C_Quantity).DataField = "Quantity"
    llp_pos(C_Quantity).Label = "Quantity"
    llp_pos(C_Quantity).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Quantity).Label & ":  ")
    
    
    llp_pos(C_Container_Number).x = ll_col2      ' Container_Number
    llp_pos(C_Container_Number).y = 3 * ll_rowH
    llp_pos(C_Container_Number).Height = ll_rowH
    llp_pos(C_Container_Number).DataField = "Container_Number"
    llp_pos(C_Container_Number).Label = "Cont"
    llp_pos(C_Container_Number).Width = ll_col2w - Printer.TextWidth(llp_pos(C_Container_Number).Label & ":  ")
    
    
    llp_pos(C_Trailer_Number).x = ll_col3        ' Trailer_Number
    llp_pos(C_Trailer_Number).y = 1 * ll_rowH
    llp_pos(C_Trailer_Number).Height = ll_rowH
    llp_pos(C_Trailer_Number).DataField = "Trailer_Number"
    llp_pos(C_Trailer_Number).Label = "Trailer n"
    llp_pos(C_Trailer_Number).Width = ll_col3w - Printer.TextWidth(llp_pos(C_Trailer_Number).Label & ":  ")
    
    
    llp_pos(C_EQ_Code).x = ll_col3               ' EQ_Code
    llp_pos(C_EQ_Code).y = 2 * ll_rowH
    llp_pos(C_EQ_Code).Height = ll_rowH
    llp_pos(C_EQ_Code).DataField = "EQ_Code"
    llp_pos(C_EQ_Code).Label = "Equip"
    llp_pos(C_EQ_Code).Width = ll_col3w - Printer.TextWidth(llp_pos(C_EQ_Code).Label & ":  ")
    
    
    llp_pos(C_Remark).x = ll_col1                ' Remark
    llp_pos(C_Remark).y = 4 * ll_rowH
    llp_pos(C_Remark).Height = ll_rowH
    llp_pos(C_Remark).DataField = "Remark"
    llp_pos(C_Remark).Label = "Remarks"
    llp_pos(C_Remark).Width = ml_printAreaHorz - ll_col1 - Printer.TextWidth(llp_pos(C_Remark).Label & ":  ")
    
    llp_pos(C_COS_Contact).x = ll_col1           ' COS_Contact
    llp_pos(C_COS_Contact).y = 2 * ll_rowH
    llp_pos(C_COS_Contact).Height = ll_rowH
    llp_pos(C_COS_Contact).DataField = "COS_Contact"
    llp_pos(C_COS_Contact).Label = "COS Contact"
    llp_pos(C_COS_Contact).Width = ll_col1w - Printer.TextWidth(llp_pos(C_COS_Contact).Label & ":  ")
    
    
    llp_pos(C_Delivery_Date).x = ll_col1     ' Load_Planned_Starting_Time
    llp_pos(C_Delivery_Date).y = 3 * ll_rowH
    llp_pos(C_Delivery_Date).Height = ll_rowH
    llp_pos(C_Delivery_Date).DataField = "Delivery_Date"
    llp_pos(C_Delivery_Date).Label = "Delivery date"
    llp_pos(C_Delivery_Date).Width = ll_col1w - Printer.TextWidth(llp_pos(C_Delivery_Date).Label & ":  ")
    
End Sub

Public Sub DCShipPrint(ms_Print, ByVal lb_SmallLine As Boolean, ByVal as_plant As String, ByVal as_shipDate As String)
   
Dim i As Integer

'Dim li_LPaper As Integer
Dim ls_NewCarrier As String
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer


InitPrinter 2
' numbers of line printed for a line of data
mi_TableLineHeight = 0

ls_NewCarrier = ms_Print(13, 1)

For i = 1 To (UBound(ms_Print, 2) - 1)
    ' if the next data doesn't fit in this page we change the page
    If (ms_Print(13, i) = ls_NewCarrier) And (Printer.CurrentY > (mi_ScaleHeight - (mi_TableLineHeight * 2))) Then
        DrawBox li_XStartTable, li_YStartTable - 40, mi_Scalewidth, Printer.CurrentY - 40, 15
        Printer.NewPage
    End If
    ' if the carrier change
    If ms_Print(13, i) <> ls_NewCarrier Then
        DrawBox li_XStartTable, li_YStartTable - 40, mi_Scalewidth, Printer.CurrentY - 40, 15
        Printer.NewPage
    End If
    ls_NewCarrier = ms_Print(13, i)
    If Printer.CurrentY = 0 Then
        ' we print the header of the page
        Printer.Font.Italic = 0
        SetBold -1
        SetFontSize 12
        Printer.Print Date;
        Printer.Print " - ";
        Printer.Print Time
        SetFontSize 36
        Printer.Print "ARMSTRONG"
        SetFontSize 24
        If gs_TableName = "DC_Receipts" Then
            Printer.Print "RECEIPT LIST OF " & as_plant & " PLANT";
        Else
            Printer.Print "SHIPMENT LIST OF " & as_plant & " PLANT";
        End If
        SetFontSize 12
        Printer.Print Tab(mi_LCurrPaper - 15);
        Printer.Print Printer.Page
        Printer.Print ""
        SetFontSize 18
        If gs_TableName <> "DC_Receipts" Then
            Printer.Print "Shipping date : " & as_shipDate;
            Printer.Print ""
            Printer.Print "Carrier company : " & ms_Print(12, i)
        Else
            Printer.Print "Receiving date : " & as_shipDate;
            Printer.Print ""
        End If
        Printer.Print ""
        SetFontSize 12
        Printer.Print ""
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        DCPrintLine ms_Print, mi_LCurrPaper, 0, lb_SmallLine
        Printer.Print ""
        Printer.Print ""
        DrawLine Printer.CurrentX, Printer.CurrentY - 40, Printer.CurrentX + 3000, Printer.CurrentY - 40, 15
        SetBold 0
    End If
        mi_TableLineHeight = Printer.CurrentY
        DCPrintLine ms_Print, mi_LCurrPaper, i, lb_SmallLine
'        mi_TableLineHeight = Printer.CurrentY - mi_TableLineHeight
        Printer.Print ""
        Printer.Print ""
        mi_TableLineHeight = Printer.CurrentY - mi_TableLineHeight

        DrawLine Printer.CurrentX, Printer.CurrentY - 40, 3000, Printer.CurrentY - 40, 15
Next i
'fin:

DrawBox li_XStartTable, li_YStartTable - 40, mi_Scalewidth, Printer.CurrentY - 40, 15
Printer.EndDoc

End Sub


Public Sub DCShipPrint2(ByRef ao_db As ArmDb, ByVal al_Cursor, ByRef alp_pos() As TCell, ByVal as_plantTitle As String, ByVal as_shippnigDateTitle As String)
   
    If Not ao_db.First(al_Cursor) Then
        Exit Sub
    End If
    
    Dim ld_printDate As Date
    ld_printDate = Date
    

    Dim ls_oldCarrier As String

    ls_oldCarrier = ""

    While Not ao_db.EOF(al_Cursor)
        
        If ls_oldCarrier <> ao_db.GetFields(al_Cursor, "CARRIER_Code") Then
            If ls_oldCarrier <> "" Then
                ' move to another page
                Printer.NewPage
                Printer.CurrentY = ml_marginTB
            Else
                Printer.CurrentY = ml_marginTB
            End If
            Call DCPrintHeader(as_plantTitle, as_shippnigDateTitle, ao_db.GetFields(al_Cursor, "CARRIER_Name"), ld_printDate)
            
            ls_oldCarrier = ao_db.GetFields(al_Cursor, "CARRIER_Code")
            
        ElseIf DCTicketHeight(ao_db, al_Cursor, alp_pos) + Printer.CurrentY > Printer.ScaleHeight Then
        
            Printer.NewPage
            Printer.CurrentY = ml_marginTB
            
            Call DCPrintHeader(as_plantTitle, as_shippnigDateTitle, ao_db.GetFields(al_Cursor, "CARRIER_Name"), ld_printDate)
        
        End If

        Call DCPrintTicket(ao_db, al_Cursor, alp_pos)
        
        Call DrawLine(ml_marginLR, Printer.CurrentY, ml_marginLR + ml_printAreaHorz, Printer.CurrentY, 10)
        
        Call ao_db.Next(al_Cursor)
    Wend
'fin:

'DrawBox li_XStartTable, li_YStartTable - 40, mi_Scalewidth, Printer.CurrentY - 40, 15
Printer.EndDoc

End Sub



Public Sub InitPrinter(ByVal li_Landscape As Integer)
Dim Xlast As Integer
Dim Ylast As Integer

' init paper orientation
' 2 means landscape
On Error Resume Next
Printer.Orientation = li_Landscape
If li_Landscape = 1 Then
    mi_LCurrPaper = 100
    msng_ScreenToPrinter = 108.48
Else
    If Printer.PaperSize = 1 Then
        mi_LCurrPaper = 135
        msng_ScreenToPrinter = 108.48
    Else
        mi_LCurrPaper = 145
        msng_ScreenToPrinter = 108.48
    End If
End If

' init resolution
Printer.Scale (0, 0)-(mi_Scalewidth, mi_ScaleHeight)
SetFontName "Arial"
SetFontSize 12

End Sub


Public Sub InitPrinter2(ByVal li_Landscape As PrinterObjectConstants)
Dim Xlast As Integer
Dim Ylast As Integer

' init paper orientation
' 2 means landscape
On Error Resume Next

Printer.ScaleMode = ScaleModeConstants.vbTwips ' cm

Printer.Orientation = li_Landscape

If li_Landscape = 1 Then
    mi_LCurrPaper = 100
    msng_ScreenToPrinter = 108.48
Else
    If Printer.PaperSize = 1 Then
        mi_LCurrPaper = 135
        msng_ScreenToPrinter = 108.48
    Else
        mi_LCurrPaper = 145
        msng_ScreenToPrinter = 108.48
    End If
End If

SetFontName "Arial"
SetFontSize 12

End Sub

Public Sub RecalcMargins(ByVal al_to As ScaleModeConstants)
On Error GoTo errhandler

Dim ll_dpiX As Long, ll_dpiY As Long

    ll_dpiX = GetDeviceCaps(Printer.hdc, LOGPIXELSX)
    ll_dpiY = GetDeviceCaps(Printer.hdc, LOGPIXELSY)

    ml_marginLR = Printer.ScaleX(GetDeviceCaps(Printer.hdc, PHYSICALOFFSETX) / ll_dpiX, ScaleModeConstants.vbInches, al_to)
    ml_marginTB = Printer.ScaleY(GetDeviceCaps(Printer.hdc, PHYSICALOFFSETY) / ll_dpiY, ScaleModeConstants.vbInches, al_to)
    ml_printAreaHorz = Printer.ScaleX(GetDeviceCaps(Printer.hdc, HORZRES) / ll_dpiX, ScaleModeConstants.vbInches, al_to)
    ml_printAreaVert = Printer.ScaleY(GetDeviceCaps(Printer.hdc, VERTRES) / ll_dpiY, ScaleModeConstants.vbInches, al_to)
    ml_physWidth = Printer.ScaleX(GetDeviceCaps(Printer.hdc, PHYSICALWIDTH) / ll_dpiX, ScaleModeConstants.vbInches, al_to)
    ml_physHeight = Printer.ScaleY(GetDeviceCaps(Printer.hdc, PHYSICALHEIGHT) / ll_dpiY, ScaleModeConstants.vbInches, al_to)
    
    If ml_marginLR < Printer.ScaleX(0.01, ScaleModeConstants.vbInches, al_to) Then
        
        ' undefined margin proalby PDF printer
        Debug.Print (Printer.DeviceName)
        
        ' setup defautl margins
        ml_marginLR = Printer.ScaleX(0.5, ScaleModeConstants.vbInches, al_to)
        ml_marginTB = Printer.ScaleY(0.5, ScaleModeConstants.vbInches, al_to)
        ml_printAreaHorz = ml_physWidth - 2 * ml_marginLR
        ml_printAreaVert = ml_physHeight - 2 * ml_marginTB
    
    Else
        ' if it is a real printer we print to whole printable area -> no margins
        ml_marginLR = 0
        ml_marginTB = 0
    End If
    Exit Sub
errhandler:
End Sub

Public Sub PrintBold(ByVal ls_Field As String)
' print a text in bold
Printer.Font.Bold = OK
Printer.Print ls_Field;
Printer.Font.Bold = KO
End Sub

Public Sub DrawLine(ByVal li_X1 As Integer, ByVal li_Y1 As Integer, ByVal li_X2 As Integer, ByVal li_Y2 As Integer, ByVal li_size As Integer)
' print a line with a specified size
Dim Xlast As Integer
Dim Ylast As Integer

    Xlast = Printer.CurrentX
    Ylast = Printer.CurrentY
    Printer.DrawWidth = li_size
    Printer.Line (li_X1, li_Y1)-(li_X2, li_Y2)
    Printer.DrawWidth = 1
    Printer.CurrentX = Xlast
    Printer.CurrentY = Ylast
End Sub

Function PrintCellMultiLine(ByVal ls_Field As String, ByVal li_StartColn As Integer, ByVal li_EndColn As Integer) As Integer

Dim li_Numchar As Integer
Dim c As String
'Dim i As Integer
Dim li_Ylast As Integer
Dim li_NbreLine As Integer

li_NbreLine = 1
li_Ylast = Printer.CurrentY
For li_Numchar = 1 To Len(ls_Field)
    'If Printer.CurrentX > (li_EndColn - msng_ScreenToPrinter) Then
    '    Printer.Print ""
    '    Printer.CurrentX = li_StartColn
    '    li_NbreLine = li_NbreLine + 1
    'End If
    c = Mid(ls_Field, li_Numchar, 1)
    If Asc(c) <> 10 And Asc(c) <> 13 Then
        If (Printer.CurrentX + Printer.TextWidth(c)) > (li_EndColn - mi_CellMargin) Then
            Printer.Print ""
            Printer.CurrentX = li_StartColn
            li_NbreLine = li_NbreLine + 1
        End If
        Printer.Print c;
    Else
        If Asc(c) = 10 Then
            Printer.Print ""
            Printer.CurrentX = li_StartColn
            li_NbreLine = li_NbreLine + 1
        End If
    End If
Next li_Numchar
Printer.CurrentY = li_Ylast
PrintCellMultiLine = li_NbreLine

End Function

Function PrintCellMultiLine2(ByVal as_Data As String, ByVal al_cellWidth As Long) As Single

    Dim li_Numchar As Integer
    Dim c As String
    
    Dim ll_oldX As Single
    Dim ll_startC As Long
    Dim ll_currentWidth As Single
    Dim ll_height As Single

    ll_currentWidth = 0
    ll_height = 0
    ll_startC = 1
    
    ll_oldX = Printer.CurrentX

    For li_Numchar = 1 To Len(as_Data)
        
        c = Mid(as_Data, li_Numchar, 1)
        
        If Asc(c) <> 10 And Asc(c) <> 13 Then
            
            ll_currentWidth = ll_currentWidth + Printer.TextWidth(c)
            
            If ll_currentWidth > al_cellWidth Then
            
                Printer.Print Mid(as_Data, ll_startC, li_Numchar - ll_startC + 1)
                Printer.CurrentX = ll_oldX
                
                ll_height = ll_height + Printer.TextHeight(Mid(as_Data, ll_startC, li_Numchar - ll_startC + 1))
                ll_currentWidth = 0
                ll_startC = li_Numchar + 1
                
            End If
            
        ElseIf Asc(c) = 13 Then
                
            Printer.Print Mid(as_Data, ll_startC, li_Numchar - ll_startC)
            Printer.CurrentX = ll_oldX
            
            ll_height = ll_height + Printer.TextHeight(Mid(as_Data, ll_startC, li_Numchar - ll_startC))
            ll_currentWidth = 0
            ll_startC = li_Numchar + 2
        
        End If
    Next li_Numchar
    
    If ll_startC < Len(as_Data) Or ll_height = 0 Then
        ll_height = ll_height + Printer.TextHeight(Mid(as_Data, ll_startC, Len(as_Data) - ll_startC + 1))
        Printer.Print (Mid(as_Data, ll_startC, Len(as_Data) - ll_startC + 1))
    End If

    
    PrintCellMultiLine2 = ll_height

End Function

Function HeightCellMultiLine(ByVal as_Data As String, ByVal al_cellWidth As Long) As Single

    Dim li_Numchar As Integer
    Dim c As String
    Dim ll_startC As Long
    Dim ll_currentWidth As Single
    Dim ll_height As Single

    ll_currentWidth = 0
    ll_height = 0
    ll_startC = 1
    
    For li_Numchar = 1 To Len(as_Data)
    
        c = Mid(as_Data, li_Numchar, 1)
        
        If Asc(c) <> 10 And Asc(c) <> 13 Then
            
            ll_currentWidth = ll_currentWidth + Printer.TextWidth(c)
            
            If ll_currentWidth > al_cellWidth Then
            
                ll_height = ll_height + Printer.TextHeight(Mid(as_Data, ll_startC, li_Numchar - ll_startC + 1))
                ll_currentWidth = 0
                ll_startC = li_Numchar + 1
                
            End If
        
        End If
    Next li_Numchar
    
    If ll_height = 0 Then
        ll_height = Printer.TextHeight(as_Data)
    End If

    HeightCellMultiLine = ll_height

End Function



Public Sub DrawBox(ByVal li_X1 As Integer, ByVal li_Y1 As Integer, ByVal li_X2 As Integer, ByVal li_Y2 As Integer, ByVal li_size As Integer)
' draw a box with a specified size
Dim Xlast As Integer
Dim Ylast As Integer

    Xlast = Printer.CurrentX
    Ylast = Printer.CurrentY
    Printer.DrawWidth = li_size
    
    Printer.Line (li_X1, li_Y1)-(li_X1, li_Y2)
    Printer.Line (li_X1, li_Y2)-(li_X2, li_Y2)
    Printer.Line (li_X2, li_Y2)-(li_X2, li_Y1)
    Printer.Line (li_X2, li_Y1)-(li_X1, li_Y1)
    
    Printer.DrawWidth = 1
    Printer.CurrentX = Xlast
    Printer.CurrentY = Ylast
End Sub


Public Sub SetFontName(ByVal ls_Name As String)
Dim Xlast As Integer
Dim Ylast As Integer

'Change the printer font
Printer.Font.Name = ls_Name
'calcul the new height of the font in the printer scale
Xlast = Printer.CurrentX
Ylast = Printer.CurrentY
Printer.Print ""
mi_FontHeight = Printer.CurrentY - Ylast
Printer.CurrentX = Xlast
Printer.CurrentY = Ylast
'change the font of the label used to calcul the size of a text
'frmMain.Lbl_ForPrinter.Font.Name = ls_Name

End Sub

Public Sub SetBold(ByVal lb_Flag As Boolean)

'Change the printer font
Printer.Font.Bold = lb_Flag

'change the font of the label used to calcul the size of a text
'frmMain.Lbl_ForPrinter.Font.Bold = lb_Flag

End Sub
Public Sub SetFontSize(ByVal li_size As Integer)
Dim Xlast As Integer
Dim Ylast As Integer

'Change the printer font size
Printer.Font.Size = li_size
'calcul the new height of the font in the printer scale
Xlast = Printer.CurrentX
Ylast = Printer.CurrentY
Printer.Print ""
mi_FontHeight = Printer.CurrentY - Ylast
Printer.CurrentX = Xlast
Printer.CurrentY = Ylast
'frmMain.Lbl_ForPrinter.Font.Size = li_size

End Sub

Function TruncField(ByVal ls_Field As String, ByVal li_Long As Integer) As String
Dim ls_TempField As String

' mi_ScreenToPrinter est la taille estim en nombre de pixel du label lbl_ForPrinter d'une colonne sur l'imprimante (pour une page en landscape divise en 145 colonnes)
If li_Long = 0 Then
    TruncField = ""
Else
'    FrmMain.Lbl_ForPrinter.Caption = ls_Field
'    '(mi_Scalewidth / mi_LCurrPaper)
'    While FrmMain.Lbl_ForPrinter.Width > ((msng_ScreenToPrinter * li_Long) - msng_ScreenToPrinter / (mi_Scalewidth / mi_LCurrPaper) * mi_CellMargin)
'        FrmMain.Lbl_ForPrinter.Caption = Left(FrmMain.Lbl_ForPrinter.Caption, Len(FrmMain.Lbl_ForPrinter.Caption) - 1)
'    Wend
'    TruncField = FrmMain.Lbl_ForPrinter.Caption
    ls_TempField = ls_Field
    While (Printer.TextWidth(ls_TempField) > ((mi_Scalewidth / mi_LCurrPaper) * li_Long - 2 * mi_CellMargin)) And (Len(ls_TempField) > 0)
        ls_TempField = Left(ls_TempField, Len(ls_TempField) - 1)
    Wend
    TruncField = ls_TempField
End If

End Function

Public Sub PrintMultiLine(ByVal ls_Field As String)
Dim li_Numchar As Integer
Dim c As String
Dim i As Integer
For li_Numchar = 1 To Len(ls_Field)
    If Printer.CurrentX > (mi_Scalewidth - 104) Then
        Printer.Print ""
    End If
    c = Mid(ls_Field, li_Numchar, 1)
    If Asc(c) <> 10 Then
        Printer.Print c;
    End If
Next li_Numchar
Printer.Print ""

End Sub

Public Sub PrintGridWordWarp(li_Landscape As Integer, li_CtrTitle As Integer, lc)

Dim i As Integer
Dim li_HRecord As Integer
'Dim li_LPaper As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer
'Dim li_NbreLine As Integer
Dim li_Cell As Integer
Dim li_TempHRecord As Integer


InitPrinter li_Landscape

li_HRecord = 0
'If li_Landscape = 1 Then
'    li_LPaper = 100
'Else
'    If Printer.PaperSize = 1 Then
'        li_LPaper = 135
'    Else
'        li_LPaper = 145
'    End If
'End If

For i = 1 To Screen.ActiveForm.Grid.Rows - 1
    Screen.ActiveForm.Grid.Row = i
    
    li_HRecord = 0
    'calculate an estimation of number of line needed for printing this row of data
    For li_Cell = 0 To UBound(lc, 1)
        If lc(li_Cell) <> 0 Then
            Screen.ActiveForm.Grid.Col = li_Cell
            li_TempHRecord = Len(Screen.ActiveForm.Grid.Text) / lc(li_Cell)
            If Len(Screen.ActiveForm.Grid.Text) Mod lc(li_Cell) <> 0 Then
                        li_TempHRecord = li_TempHRecord + 1
            End If
            If li_HRecord < li_TempHRecord Then
                li_HRecord = li_TempHRecord
            End If
        End If
    Next li_Cell
    
    If Printer.CurrentY > (mi_ScaleHeight - li_HRecord * mi_FontHeight) Then
        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        Printer.NewPage
    End If
    If Printer.CurrentY = 0 Then
        SetBold -1
        Printer.Font.Size = 12
        Printer.Print Date;
        SetFontSize 24
        Printer.Print Tab(li_CtrTitle);
        Printer.Print Screen.ActiveForm.Caption;
        SetFontSize 12
        Printer.Print Tab(mi_LCurrPaper - 5);
        Printer.Print Printer.Page
        Printer.Print ""
        Printer.Print ""
        Printer.Print Screen.ActiveForm.lbl_Category.Caption
        Printer.Print ""
       
        li_XStartTable = Printer.CurrentX
        li_YStartTable = Printer.CurrentY
        li_HRecord = Printer.CurrentY
        Screen.ActiveForm.Grid.Row = 0
        DoLine mi_LCurrPaper, lc
        li_HRecord = Printer.CurrentY - li_HRecord

        DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
        SetBold 0
    End If
    Screen.ActiveForm.Grid.Row = i
    DoLineWordWarp mi_LCurrPaper, lc
Next i
DrawBox li_XStartTable, li_YStartTable - 10, mi_Scalewidth, Printer.CurrentY - 10, 15
Printer.EndDoc

End Sub
Private Sub DCPrintHeader(ByVal as_plantTitle As String, ByVal as_shippnigDateTitle As String, ByVal as_carrierName As String, ByVal ad_printDate As Date)

        ' we print the header of the page
        
        ' line 1
        Printer.Font.Italic = False
        Call SetBold(True)
        Call SetFontSize(12)
        Printer.CurrentX = ml_marginLR
        Printer.Print ad_printDate;
        Printer.Print " - ";
        Printer.Print Time
        
        'line 2
        SetFontSize 36
        Printer.CurrentX = ml_marginLR
        Printer.Print "ARMSTRONG"
        
        ' line 3
        Printer.CurrentX = ml_marginLR
        SetFontSize 24
        Printer.Print as_plantTitle;
        
        ' page nb
        SetFontSize 12
        Printer.CurrentX = ml_printAreaHorz + ml_marginLR - Printer.TextWidth(" " & Printer.Page)
        Printer.Print Printer.Page
        Printer.Print ""
        
        ' line 4
        SetFontSize 18
        Printer.CurrentX = ml_marginLR
        Printer.Print as_shippnigDateTitle
        
        If as_carrierName <> "" Then
            ' line 5
            Printer.CurrentX = ml_marginLR
            Printer.Print "Carrier company : " & as_carrierName
        End If
        
        SetFontSize 12
        Printer.Print ""
        Call DrawLine(ml_marginLR, Printer.CurrentY, ml_marginLR + ml_printAreaHorz, Printer.CurrentY, 10)
        
'        Printer.CurrentY = Printer.CurrentY + 0.15
        
        Call SetBold(False)

End Sub



Private Sub DCPrintTicket(ByRef ao_db As ArmDb, ByVal al_Cursor As Long, ByRef alp_pos() As TCell)
On Error GoTo errhandler
    
    Printer.Font.Italic = 0
    
    Dim ll_i As Long
    Dim ll_Y As Single
    Dim ll_maxY As Single
    Dim ll_printedheight As Single
    Dim ll_k As Long
    Dim llp_pos() As TCell
    
    llp_pos = alp_pos
    
    ll_maxY = Printer.CurrentY
    ll_Y = Printer.CurrentY
    
    Printer.FillColor = vbYellow
    
    For ll_i = LBound(llp_pos) To UBound(llp_pos)
    
        Printer.CurrentX = llp_pos(ll_i).x + ml_marginLR
        Printer.CurrentY = ll_Y + llp_pos(ll_i).y
        
        Printer.Font.Bold = True
        Printer.Print llp_pos(ll_i).Label & ": ";
        
        Printer.Font.Bold = False
        ll_printedheight = PrintCellMultiLine2(ao_db.GetFields(al_Cursor, llp_pos(ll_i).DataField), llp_pos(ll_i).Width - 0.5)
        
        ' if the text was more thant the space reserved for the field we will have to move other lines down
        If ll_printedheight > llp_pos(ll_i).Height Then
            For ll_k = ll_i + 1 To UBound(llp_pos)
                If llp_pos(ll_k).y > llp_pos(ll_i).y Then
                    llp_pos(ll_k).y = llp_pos(ll_k).y + (ll_printedheight - llp_pos(ll_i).Height)
                End If
            Next
        End If
        
        If ll_Y + llp_pos(ll_i).y + ll_printedheight > ll_maxY Then ll_maxY = ll_Y + llp_pos(ll_i).y + ll_printedheight
    Next
    
    Dim ls_tranIdent As String
    ls_tranIdent = ao_db.GetFields(al_Cursor, "MASTER_TRANS_code") & "/" & ao_db.GetFields(al_Cursor, "TRANS_order")
    
    Printer.FontSize = Printer.FontSize - 2
    Printer.CurrentX = ml_printAreaHorz + ml_marginLR - Printer.TextWidth(ls_tranIdent)
    Printer.CurrentY = ll_Y + 0.25
    Printer.Print ls_tranIdent
    
    Printer.FontSize = Printer.FontSize + 2
    Printer.CurrentY = ll_maxY + 0.5
    
    
    Exit Sub
errhandler:
    Call MsgBox(Err.Description, vbCritical, "DCPrintTicket")
End Sub

Private Function DCTicketHeight(ByRef ao_db As ArmDb, ByVal al_Cursor As Long, ByRef alp_pos() As TCell) As Long

On Error GoTo errhandler
    DCTicketHeight = 0
    
    Dim ll_height As Single
    ll_height = 0
    Printer.Font.Italic = False
    
    Dim ll_currentY As Single
    
    Dim ll_i As Long
    For ll_i = LBound(alp_pos) To UBound(alp_pos)
    
        Printer.Font.Bold = True
        ll_currentY = alp_pos(ll_i).y + Printer.TextHeight(alp_pos(ll_i).Label)
        
        If ll_height < ll_currentY Then
            ll_height = ll_currentY
        End If
        
        Printer.Font.Bold = False
        ll_currentY = alp_pos(ll_i).y + HeightCellMultiLine(ao_db.GetFields(al_Cursor, alp_pos(ll_i).DataField), alp_pos(ll_i).Width)
        
        If ll_height < ll_currentY Then
            ll_height = ll_currentY
        End If
        
    Next
    
    DCTicketHeight = ll_height
    Exit Function
errhandler:
    Call MsgBox(Err.Description, vbCritical, "DCTicketHeight")
End Function


