Attribute VB_Name = "Globals"
Option Explicit

Const SCREEN_NAME As String = "DSW"

    Global C_SERVER As String   '= "UXBDB011"
    Global C_DB As String       '= "sifyb2"
    Global C_USER As String
    Global C_AUTOUPGRADE As Boolean
    
    
Public Const C_SAP_LOGIN As String = "NXT"
Public Const C_SAP_PASSW As String = "ous42pri"

Public Const MONEY_FORMAT_PRECISE As String = "###0.00"   ' 16.4. JN - fix to display 4 deciml places
Public Const DOUBLE_QUOTE As String = """"
Public Const ONE_SPACE As String = " "

Global gs_Action As String
Global gs_TableName As String
Global gs_Date As String

Public Const CH_LDELIMIT = ""
Public Const SEP = ""
Public Const SEP1 As String = ""
Public Const SEP2 As String = ""

Public Const CL_COLOR_ENABLED As Long = &H80000005
Public Const CL_COLOR_DISABLED As Long = &H8000000F
Public Const CL_COLOR_LOCKED As Long = &H80000018

Public Const OK As Boolean = -1
Public Const KO As Boolean = 0
Global gb_Return As Boolean

Public Sub MouseOn()
'------------------------------------------------------------------
' Name : MouseOn
'
' Purpose : Turn the mouse pointer to arrow
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
    Screen.MousePointer = 0
End Sub

Public Sub MouseOff()
'------------------------------------------------------------------
' Name : MouseOff
'
' Purpose : Turn the mouse pointer to busy
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
    Screen.MousePointer = 11
End Sub


Public Function StringToDate(ls_Date As String) As Date
    StringToDate = DateSerial(Mid(ls_Date, 7, 4), Mid(ls_Date, 4, 2), Mid(ls_Date, 1, 2))
End Function

Public Function DateToString(ld_Date As Date) As String
    DateToString = Format(Day(ld_Date), "00") & "/" & Format(Month(ld_Date), "00") & "/" & Format(Year(ld_Date), "0000")
End Function

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************

Public Function SqlStr(ByVal as_value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_value = "" And ab_EmptyNULL Then
        SqlStr = "NULL"
    Else
        SqlStr = "'" & Replace(Left(as_value, IIf(Len(as_value) <= al_MaxLen, Len(as_value), al_MaxLen)), "'", "''") & "'"
    End If
End Function

Public Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo errhandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
errhandler:
    Call errorHandler("SqlDate")
End Function

Public Function SQLNum(ByVal as_str As String) As String
    If as_str = "" Then
        SQLNum = "NULL"
    Else
        SQLNum = Replace(as_str, ",", ".")
    End If
End Function


Public Function SqlInt(ByVal as_Double As String, Optional ByVal as_ifEmpty As String = "NULL") As String
On Error GoTo errhandler
    If as_Double = "" Then
        SqlInt = as_ifEmpty
    Else
        SqlInt = Str(CLng(as_Double))
    End If
    Exit Function
errhandler:
    Call errorHandler(".SQLInt")
End Function

Public Function SqlDouble(ByVal as_Double As String, Optional ByVal as_ifEmpty As String = "0") As String
On Error GoTo errhandler
    If as_Double = "" Then
        SqlDouble = as_ifEmpty
    Else
        SqlDouble = Str(CDbl(as_Double))
    End If
    Exit Function
errhandler:
    Call errorHandler(".SQLDouble")
End Function

' safe retieving selected item from combobox
Public Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo errhandler
    If ao_Combobox.SelectedItem Is Nothing Then
        SQLComboBoxValue = as_DefaultValue
    Else
        If IsEmpty(ao_Combobox.SelectedItem.Key) Then
            SQLComboBoxValue = as_DefaultValue
        Else
            SQLComboBoxValue = IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText)
        End If
    End If
    Exit Function
errhandler:
    Call errorHandler(".SQLComboBoxValue")
End Function

Public Function SQLDateTime(ad_Date As Date) As String
On Error GoTo errhandler
  If ad_Date = 0 Then
    SQLDateTime = "Null"
  Else
    SQLDateTime = "{ ts '" & Format(ad_Date, "yyyy-mm-dd hh:mm:ss") & "'}"
  End If
    Exit Function
errhandler:
     Call errorHandler(".SQLDateTime")
End Function
' ************************************************************************************

' display standard error message


' Standard error handler
Public Sub errorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, "Global" & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

' logs message to database
#If LIVE = 1 Then
    Public Sub LogMessage(ByVal ao_db As Object, ByVal al_U_Code As Long, ByVal as_ScreenName As String, ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ByVal ab_ExitOnException As Boolean = True)
#Else
    Public Sub LogMessage(ByVal ao_db As ARMSYSCOMLib.ArmDb, ByVal al_U_Code As Long, ByVal as_ScreenName As String, ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ByVal ab_ExitOnException As Boolean = True)
#End If
On Error GoTo errhandler
    
Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    
Dim ls_req As String
Dim ll_Cursor As Long
Dim ls_Source As String, ls_Msg As String
  
  ls_Source = as_ScreenName & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
  
  ls_req = Replace(LOG_REQUEST, "$UCODE$", SQLNum(al_U_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LOGTYPE$", SqlStr(as_logType), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MSG$", SqlStr(Trim(as_logMsg), 4000), , , vbTextCompare)
  ls_req = Replace(ls_req, "$APP$", SqlStr(Trim(ls_Source), 50), , , vbTextCompare)
  
  Call ExecuteSQLSafe(ao_db, ls_req)
  Exit Sub
errhandler:
  If ab_ExitOnException Then
    Call MsgBox("A fatal error occured. Unable to log error into database, the application will be closed. Please report the following message to your IT support: " & vbCrLf & _
      as_logMsg & " - " & ls_Source & "LogMessage exception " & Err.Number & "-" & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
  Else
    Call ao_db.Disconnect
  End If
End Sub

Public Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo errhandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
errhandler:
    Call errorHandler("Global" & ".GetDbError()")
End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If ENV = LIVE Then
Public Sub ExecuteSQLSafe(ByVal ao_db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Public Sub ExecuteSQLSafe(ByVal ao_db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo errhandler

    ' First execute the request
    If Not ao_db.ExecuteSQL(as_Request) Then
        Err.Raise 666, "SQL : " & as_Request, Join(ao_db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 667, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_db.SQLRowsAffected
            Else
                Err.Raise 668, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_db.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

errhandler:
    Call errorHandler("ExecuteSQLSafe")
End Sub


Public Function OpenSQLSafe(ByVal ao_db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo errhandler
    Dim lc_Data As Long
    lc_Data = ao_db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Err.Raise 666, "SQL : " & as_Request, Join(ao_db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise 669, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_db.RowCount(lc_Data)
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
errhandler:
    Call errorHandler("OpenSQLSafe")
End Function

Public Function CheckNumericValue(ls_Text As String) As Boolean

Dim i As Integer
Dim ls_char As String
Dim lb_First As Boolean

CheckNumericValue = KO
lb_First = KO
For i = 1 To Len(ls_Text)
    ls_char = Mid(ls_Text, i, 1)
    If Not IsNumeric(ls_char) Then
        If ls_char = "." Then
            If lb_First Then
                Exit Function
            Else
                lb_First = OK
            End If
        Else
            Exit Function
        End If
    End If
Next i
CheckNumericValue = OK

End Function

Public Function SendMessage(ai_MsgCode As Integer, as_MsgDefault As String, as_LanguageCode As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly, Optional Title, Optional lb_Use_NCS_ODBC As Boolean = False) As VbMsgBoxResult
'------------------------------------------------------------------
' Name : SendMessage
'
' Purpose : Read the message in the database with MsgText and
'           ask/say to the user. If the message does'nt exist in the
'           database, the default message is used
'
' Parameters :
'       ai_MsgCode          Code of the message to find in the
'                               database
'       as_MsgDefault       Default Message to use if we can't
'                               find in the database
'       as_LanguageCode     The language to use for the text
'       Buttons (Optional)  Indicates the buttons to use
'       Title (Optional)    Indicates the Title to use
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return :
'       The button used to quit the message box
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
Dim ll_Mouse As Long
Dim lo_Return As VbMsgBoxResult

    Dim gs_message  As String
    gs_message = "" 'MsgText(ai_MsgCode, as_LanguageCode, lb_Use_NCS_ODBC)
    If gs_message = "" Then
        gs_message = as_MsgDefault
    End If
    
    'We read the actual status of the mouse pointer
    ll_Mouse = Screen.MousePointer
    
    'Turn the mouse pointer to arrow
    MouseOn
    
    If IsMissing(Title) Then
        lo_Return = MsgBox(gs_message, Buttons)
    Else
        lo_Return = MsgBox(gs_message, Buttons, Title)
    End If
    
    'Turn the mouse pointer to the old status
    If ll_Mouse = 11 Then
        MouseOff
    End If

    SendMessage = lo_Return

End Function


'-------------------------------------------------------------
Public Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal ALanguage As String) As String
    Dim ls_Request As String, lCurs As Long
    ls_Request = "SELECT Code_Page FROM Language WHERE Language_Code = '" & ALanguage & "'"
    lCurs = ao_Armdb.OpenSQL(ls_Request)
    Dim lCodePage As String
    lCodePage = ao_Armdb.GetFields(lCurs, "Code_Page")
    ao_Armdb.Close (lCurs)
    GetCodePageFromLanguage = lCodePage
End Function

'convert code page into charset integer
Public Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

    On Error GoTo Trace_Err

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
Trace_Err:
End Function



Public Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo errhandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

errhandler:
    Call errorHandler("ChangeCharset")
End Sub

Public Function NegativeSymbol() As String
    NegativeSymbol = Mid(Format("-1", "0"), 1, 1)
End Function

Public Function IsNumericValue(as_Text As String, Optional ab_IntegerOnly As Boolean = False) As Boolean
Dim i As Integer
Dim ls_DecimalSeparator As String
Dim lb_First As Boolean
Dim li_Begin As Integer
Dim li_End As Integer

    On Error GoTo IsNumericValue_Err
    
    ls_DecimalSeparator = DecimalSeparator
    If Left(as_Text, 1) = NegativeSymbol Or Left(as_Text, 1) = "-" Then
        li_Begin = 2
    Else
        li_Begin = 1
    End If
    If right(as_Text, 1) = NegativeSymbol Or right(as_Text, 1) = "-" Then
        li_End = Len(as_Text) - 1
    Else
        li_End = Len(as_Text)
    End If
    
    IsNumericValue = False
    If ab_IntegerOnly = True Then
        lb_First = True
    Else
        lb_First = False
    End If
    Dim ls_char As String
    For i = li_Begin To li_End
        ls_char = Mid(as_Text, i, 1)
        If Not IsNumeric(ls_char) Then
            If (ls_char = "." Or ls_char = ls_DecimalSeparator) And Not lb_First Then
                lb_First = True
            Else
                Exit Function
            End If
        End If
    Next i
    IsNumericValue = True

    Exit Function

IsNumericValue_Err:

End Function


Public Function FormatD2(olddate As Date) As String

FormatD2 = Format(Day(olddate), "00") _
    & "/" & Format(Month(olddate), "00") _
    & "/" & Format(Year(olddate), "0000")

End Function


Public Function ListFindItem(out_List As ListBox, ls_Text As String) As Integer

Dim li_Count As Integer

ListFindItem = -1
For li_Count = out_List.ListCount - 1 To 0 Step -1
    If out_List.List(li_Count) = ls_Text Then
        ListFindItem = li_Count
        Exit Function
    End If
Next li_Count

End Function

Public Sub SafeRedimPreserve(ByRef av_Array As Variant, ByVal al_Dim As Long)
On Error GoTo errhandler

    If al_Dim < 0 Then
        ReDim av_Array(-1 To -1)
        Exit Sub
    End If
    
    If IsArray(av_Array) Then
        If SafeUbound(av_Array) >= 0 Then
            ReDim Preserve av_Array(al_Dim)
        Else
            ReDim av_Array(al_Dim)
        End If
    Else
        ReDim av_Array(al_Dim)
    End If
    Exit Sub
errhandler:
    Call Err.Raise(Err.Number, "SafeRedimPreserve" & "" & Err.Source, Err.Description)
End Sub

Public Function SafeUbound(ByRef av_Array As Variant) As Long
On Error GoTo errhandler

    SafeUbound = UBound(av_Array)
    Exit Function
errhandler:
    'If error is something other than "Subscript out of range", then display the error
    If Err.Number <> 9 Then Err.Raise Err.Number, Err.Source, Err.Description
    SafeUbound = -1
End Function

Public Function GetCodeFromCombo(ACombo As ArmCombobox) As String
Dim TheValue As String

    On Error GoTo Trace_Err
'    CapMouseOff
'    #If CapDebug Then
'        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:GetCodeFromCombo"
'    #End If
    
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        TheValue = ACombo.SelectedItem.Key
        GetCodeFromCombo = TheValue
    Else
        GetCodeFromCombo = ""
    End If

'Trace_End:
'    #If CapDebug Then
'        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:GetCodeFromCombo", "Result=" & GetCodeFromCombo
'    #End If
'    CapMouseOn
    Exit Function
    
Trace_Err:
'    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:GetCodeFromCombo"
'    CapMouseOn
End Function

Function DeleteFile(ByRef ao_FSO As Object, ByVal f As String) As Boolean
On Error GoTo deletefile_er:
   DeleteFile = False
   ao_FSO.DeleteFile f, True
   DeleteFile = True
   Exit Function
deletefile_er:
   Select Case Err.Number:
   Case 53:
   Case Else: MsgBox "Process was unable to delete file f"
   End Select
End Function

Public Function DecimalSeparator() As String
    DecimalSeparator = Mid(Format("0", "0.0"), 2, 1)
End Function


' Get an error message
Private Function ASC_MsgText(ByRef ao_Armdb As Object, ByVal as_LG_Code As String, ByVal ai_MsgID As Integer, Optional ByVal as_MsgDefault As String = "")
Dim lc_Msg As Long
Dim ls_Msg As String, ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_MsgText", "LG_Code=" & as_LG_Code & ", ai_MsgID=" & ai_MsgID & ", as_MsgDefault=" & as_MsgDefault
    #End If
    MouseOff
    
    ls_Request = "SELECT Message_Text FROM Error_Message WHERE Language_Code = '" & as_LG_Code & "' AND MsgID = " & ai_MsgID
    lc_Msg = ao_Armdb.OpenSQL(ls_Request)
    If lc_Msg = 0 Then
'        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_MsgText", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    ls_Msg = ao_Armdb.GetFields(lc_Msg, "MESSAGE_TEXT")
    
Trace_End:
    Call ao_Armdb.Close(lc_Msg)
    ASC_MsgText = IIf(Len(ls_Msg) <> 0, ls_Msg, as_MsgDefault)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_MsgText", "Result=" & ASC_MsgText
    #End If
    MouseOn
    Exit Function
    
Trace_Err:
    ASC_MsgText = ""
    Call ao_Armdb.Close(lc_Msg)
'    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_MsgText"
    MouseOn
End Function


' Display an error message
Public Function ASC_SendMessage(ByRef ao_Armdb As Object, ByVal as_LG_Code As String, ByVal ai_MsgCode As Integer, ByVal as_MsgDefault As String, Optional ByVal as_MsgCxt As String = "", Optional Buttons As VbMsgBoxStyle = vbOKOnly, Optional ByVal Title As String) As VbMsgBoxResult
Dim ls_Message As String
Dim ll_Mouse As Long
Dim lo_Return As VbMsgBoxResult

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_SendMessage", "LG_Code=" & as_LG_Code & ", ai_MsgCode=" & ai_MsgCode & ", as_MsgDefault=" & as_MsgDefault & ", as_MsgCxt=" & as_MsgCxt & ", VbMsgBoxStyle=" & "" & ", Title=" & Title
    #End If
    MouseOff
    
    If ao_Armdb Is Nothing Then
        ls_Message = as_MsgDefault
    Else
        If ao_Armdb.IsConnected = False Then
            ls_Message = as_MsgDefault
        Else
            ls_Message = ASC_MsgText(ao_Armdb, as_LG_Code, ai_MsgCode, as_MsgDefault)
        End If
    End If
    ls_Message = ls_Message & vbCrLf & Trim(as_MsgCxt)
        
    If Title = "" Then Title = "Capture Online"
    lo_Return = MsgBox(ls_Message, Buttons, Title)
    
    ASC_SendMessage = lo_Return

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_SendMessage", "Result=" & ASC_SendMessage
    #End If
    MouseOn
    Exit Function
    
Trace_Err:
    ASC_SendMessage = vbAbort
'    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_SendMessage"
    MouseOn
End Function

Function GetValueLine(ByVal ls_CommandLine As String) As Variant
'------------------------------------------------------------------
' Name : GetValueLine
'
' Purpose : Return an array of each value in the string (command line)
'           It's support double quote and spaces.
'
' Parameters :
'       ls_String           Command line to convert into array
'
' Return :
'       An array of arguments of the command line
'
' review : Jan/07/2000 by AD (To Rewrite)
'------------------------------------------------------------------
  
Dim c As String
Dim lb_InQuote As Boolean
Dim lb_NewCmdLine As Boolean
Dim lb_InArg As Boolean
Dim i As Long
Dim li_NumArgs As Integer
Dim la_Arguments()

    'Create an empty Array
    ReDim la_Arguments(0)
    
    'There are no argument
    li_NumArgs = 0
    lb_InArg = KO
    
    'Go thru command line one character
    'at a time.
    For i = 1 To Len(ls_CommandLine)
        c = Mid(ls_CommandLine, i, 1)
      
        If lb_InQuote = OK And c = DOUBLE_QUOTE Then
            lb_InQuote = KO
        Else
            If lb_InQuote = KO And c = DOUBLE_QUOTE Then lb_InQuote = OK
        End If
        
        'If we have a space and we are not beetween lb_InQuotes, We begin a new argument
        If (c = ONE_SPACE And lb_InQuote = KO) Then lb_NewCmdLine = OK

        'Test for space or tab
        If lb_NewCmdLine = KO Then
            'It's not a new argument
            
            'Test if we was already in an argument
            If lb_InArg = KO Then
                'a New argument begins

                'Make array of the correct size
                li_NumArgs = li_NumArgs + 1
                ReDim Preserve la_Arguments(li_NumArgs)
                'Now, We are in an argument
                lb_InArg = OK
            End If
         
            'Concatenate character to current argument if it's not a lb_InQuote
            If c <> DOUBLE_QUOTE Then la_Arguments(li_NumArgs) = la_Arguments(li_NumArgs) & c
        Else
            'We have ended the last argument
            lb_InArg = KO
            lb_NewCmdLine = KO
        End If
    Next i
    
    'Returns Array
    GetValueLine = la_Arguments()

End Function


Public Function SetComboItemValue(ByRef ao_cbo As ArmCombobox, ByVal as_Key As String) As Boolean
On Error GoTo errorHandler
    SetComboItemValue = True
    If Not ao_cbo.SearchItem(as_Key) Then
        Call ao_cbo.Load
        SetComboItemValue = ao_cbo.SearchItem(as_Key)
    End If
    Exit Function
errorHandler:
    Call errorHandler(".SetComboItemValue")
End Function


Public Function GetCboKey(ByRef ao_cbo As ArmCombobox) As String
On Error GoTo errhandler
    GetCboKey = ""
    If Not ao_cbo.SelectedItem Is Nothing Then
        GetCboKey = ao_cbo.SelectedItem.Key
    End If
    Exit Function
errhandler:
     Call errorHandler("GetCboKey()")
End Function

Public Function GetCboValue(ByRef ao_cbo As ArmCombobox, ByVal av_field As Variant, Optional ByVal as_DefaultValue As String = "") As String
On Error GoTo errhandler
    GetCboValue = as_DefaultValue
    If Not ao_cbo.SelectedItem Is Nothing Then
    
        Dim ls_retVal As String
        ls_retVal = ao_cbo.GetItemData(ao_cbo.SelectedItem.Key, av_field)
        
        If ls_retVal <> "" Then
            GetCboValue = ls_retVal
        End If
    
    End If
    Exit Function
errhandler:
     Call errorHandler("GetCboValue()")
End Function


