VERSION 5.00
Begin VB.Form FilterDlg 
   Caption         =   "Filter selection"
   ClientHeight    =   1620
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   1620
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btn_cancel 
      Caption         =   "Cancel"
      Height          =   390
      Left            =   2850
      TabIndex        =   5
      Tag             =   "btn_cancel"
      Top             =   1125
      Width           =   810
   End
   Begin VB.CommandButton btn_ok 
      Caption         =   "OK"
      Height          =   390
      Left            =   3795
      TabIndex        =   4
      Tag             =   "btn_ok"
      Top             =   1125
      Width           =   810
   End
   Begin DSWMGR.ArmCombobox cbo_operator 
      Height          =   345
      Left            =   1395
      TabIndex        =   3
      Top             =   150
      Width           =   3210
      _ExtentX        =   5662
      _ExtentY        =   609
   End
   Begin VB.TextBox txt_filter 
      Height          =   300
      Left            =   1395
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   630
      Width           =   3210
   End
   Begin VB.Label lbl_label 
      Caption         =   "Operator"
      Height          =   270
      Index           =   1
      Left            =   135
      TabIndex        =   2
      Tag             =   "lbl_operator"
      Top             =   225
      Width           =   720
   End
   Begin VB.Label lbl_label 
      Caption         =   "Filter"
      Height          =   270
      Index           =   0
      Left            =   135
      TabIndex        =   0
      Tag             =   "lbl_filter"
      Top             =   645
      Width           =   720
   End
End
Attribute VB_Name = "FilterDlg"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const SCREEN_NAME As String = "DSW_Filter"

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private ml_U_Code As Long
Private ms_Language_Code As String

Private ms_filterValue As String
Private ms_SQLfilterCond As String

Public Property Get FilterValue() As String
    FilterValue = ms_filterValue
End Property

Public Property Let FilterValue(ByVal as_value As String)
    ms_filterValue = as_value
End Property

Public Property Get SQLCondition() As String
    SQLCondition = ms_SQLfilterCond
End Property

Public Property Let SQLCondition(ByVal as_value As String)
    ms_SQLfilterCond = as_value
End Property

Property Let Language_Code(AString As String)
On Error GoTo errhandler

  ms_Language_Code = AString
  Exit Property
errhandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo errhandler

  ml_U_Code = al_U_Code
  Exit Property
errhandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo errhandler
  
  Set mo_Db = lo_Db
  Exit Property
errhandler:
  Call errorHandler("ArmDb.Set")
End Property


Public Sub Load_A_COM()
    
On Error GoTo errhandler

    Dim lo_Control As Object
    Dim lo_ToolTip As Object
    
      For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
      Next
    
    cbo_operator.FirstBlankItem = False
    cbo_operator.Request = "select '$val$%' AS OP_Code, 'Begins' AS OP_Desc" & vbCrLf & _
                            "Union select '%$val$%' AS OP_Code, 'Contains' AS OP_Desc" & vbCrLf & _
                            "Union select '%$val$' AS OP_Code, 'Ends' AS OP_Desc"
    
    Call LoadLabels(Me.Controls, SCREEN_NAME, ms_Language_Code)
    
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    txt_filter.Text = ms_filterValue
    
    Call cbo_operator.Load
    If ms_SQLfilterCond <> "" Then
        If Not SetComboItemValue(cbo_operator, ms_SQLfilterCond) Then
            Set cbo_operator.SelectedItem = cbo_operator.ComboItems(1)
        End If
    Else
        Set cbo_operator.SelectedItem = cbo_operator.ComboItems(1)
    End If
    
    Exit Sub
    
errhandler:
    Call errorHandler("Load_A_COM")
    
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo errhandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control

    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        Me.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)
    lLabels = 0

    Exit Sub

errhandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call errorHandler(Me.Name & ".LoadLabels")
End Sub

Private Sub btn_cancel_Click()
    ms_filterValue = ""
    ms_SQLfilterCond = ""
    Call Me.Hide
End Sub

Private Sub btn_ok_Click()
    If txt_filter.Text = "" Then
        Call MsgBox("Plese enter customer name or key (3 chars minimum)", vbCritical)
        Exit Sub
    End If
    
    If GetCboKey(cbo_operator) = "" Then
        Call MsgBox("Plese select filter operation", vbCritical)
        Exit Sub
    End If
    
    ms_filterValue = txt_filter.Text
    ms_SQLfilterCond = GetCboKey(cbo_operator)
    Call Me.Hide
End Sub


