VERSION 5.00
Begin VB.UserControl mailProcessor 
   ClientHeight    =   4245
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   11115
   ScaleHeight     =   4245
   ScaleWidth      =   11115
   Begin Project1.ArmGrid grd_stats 
      Height          =   2895
      Left            =   30
      TabIndex        =   5
      Top             =   1230
      Width           =   11025
      _ExtentX        =   19447
      _ExtentY        =   5106
   End
   Begin VB.CommandButton Cmd_Reload 
      Caption         =   "Reload Mailboxes"
      Height          =   375
      Left            =   7920
      TabIndex        =   4
      Top             =   660
      Width           =   1575
   End
   Begin VB.Timer HeartBeatTimer 
      Enabled         =   0   'False
      Interval        =   10000
      Left            =   5880
      Top             =   720
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   9600
      TabIndex        =   2
      Top             =   660
      Width           =   1455
   End
   Begin VB.CommandButton cmd_Pause 
      Caption         =   "Pause"
      Height          =   375
      Left            =   90
      TabIndex        =   1
      Top             =   660
      Width           =   1455
   End
   Begin VB.CommandButton cmd_Play 
      Caption         =   "Play"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1590
      TabIndex        =   0
      Top             =   660
      Width           =   1455
   End
   Begin VB.Label lbl_Task 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Actual task :"
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   10965
   End
End
Attribute VB_Name = "mailProcessor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'what is new
' 2.2.7 Support for SPA linked emails (JN)

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Declare Function GetTempPath Lib "Kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetLocaleInfo Lib "Kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_MODULE_NAME As String = "MailProccesor"      ' module name used in log table
Private Const C_PROCESSNAME As String = "MAILPROCESSOR" ' for heartbeat
Private Const C_LOGTXTMAX As Long = 10 * 1024               ' 10 kb of text to display

Private Const SCREEN_NAME As String = "MailProccesor"
Private Const LOCALE_USER_DEFAULT = &H400

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const C_ERRORRAISE As Long = 2500

' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Private Enum ArmSysType
  DBTYPE_EMPTY = 0
  DBTYPE_I4 = 3
  DBTYPE_R4 = 4
  DBTYPE_R8 = 5
  DBTYPE_DATE = 7
  DBTYPE_BSTR = 8 '- UNICODE string
  DBTYPE_BOOL = 11
  DBTYPE_STR = 129
  DBTYPE_BMP = 999
End Enum
' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
Public TenantID                         As String
Public AppID                            As String

Private ms_Server                       As String
Private ms_Database                     As String
Private ms_Pass                         As String
Private ms_User                         As String

'Mail Status const
Private Const EML_MAILSTATUS_NEW = "N"
Private Const EML_MAILSTATUS_DELETED = "D"
Private Const EML_MAILSTATUS_PROCESSED = "P"
Private Const EML_MAILSTATUS_BLACKLISTED = "B"
Private Const EML_MAILSTATUS_SPAM = "S"
Private Const EML_MAILSTATUS_FAILED = "F"
Private Const EML_MAILSTATUS_INVALID = "I"

'Mail Attachment Storage type
Private Const EML_ATTSTORAGE_DIRECTORY = "D"
Private Const EML_ATTSTORAGE_SQLDATABASE = "S"
Private Const EML_ATTSTORAGE_IGNORE = "I"

'Mail Type consts
Private Const EML_MAILTYPE_DEFAULT = "D"
Private Const EML_MAILTYPE_REPLY = "R"
Private Const EML_MAILTYPE_FORWARD = "F"

'MailBox Type
Private Const EML_MAILBOX_INBOX = "I"
Private Const EML_MAILBOX_OUTBOX = "O"

' common global variables
Private mb_Active                       As Boolean
Private ms_LanguageCode                 As String   ' Language code
Private mb_Initialized                  As Boolean  ' Initialized user control flag
Private ms_LoginName                    As String   ' login name
Private ml_U_Code                       As Long     ' User code
Private ml_LogEX                        As Long     ' Create extended log   JN 3.8.2007

Dim mva_spamArray                       As Variant  ' SPAM definitions Array
                                    
'Dim ms_NotesPath                        As String
Dim ms_MailAttachmentPath               As String   ' Temporary attachment path
Dim ms_DefaultCharset                   As String   ' define default charset

Dim mva_placeHolders()                  As Variant  ' array of defined placeholders

Const IDSM_ITM_STATE = 11                           ' Constantes du composant de mail
Const IDSM_ITM_RAW_HEADERS = 21
Const IDSM_STATE_READ = 0
Const IDSM_STATE_UNREAD = -1
Const IDSM_ITM_TO = 1
Const IDSM_ITM_CC = 2

' HeartBeat support >>
Dim mo_HeartBeat            As HeartBeat
Private Const mb_IgnoreHeartBeatForDebbuging As Boolean = True
' <<

Dim ml_OneUser                          As Long     ' Nombre de mails envoys  seulement un utilisateur

' ArmNotes
' Dim mo_Notes As ArmNotes
Private WithEvents mo_Exchange As ArmGraph  ' ArmExchange
Attribute mo_Exchange.VB_VarHelpID = -1

' sets of sql result count types
Private Enum ArmSQLResultType
    ArmSQLExactOne                      ' 1..1
    ArmSQLMaxOne                        ' 0..1
    ArmSQLAtLeastOne                    ' 1..N
    ArmSQLAny                           ' 0..N
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Dim mo_FSO As Object                ' filesystem object

Private Enum emlEmailType
    etEmailTo = 1
    etEmailCopyTo = 2
    etEmailBlindCopyTo = 3
    etEmailFrom = 4
End Enum

Private Enum emlSendEmailStatus
    sesOK = 1
    sesFailed = 2
    sesInvalid = 3
End Enum

Private Type MailBoxDefinition
    EAC_Code As String
    EAC_Desc As String
    Name As String
    Password As String
    KeyFileName As String
    Certificate As String
    MailFile As String
    Location As String
    EMailAddress As String
    Application As String
    DirectoryInbox As String
    StorageInbox As String
    DirectoryOutbox As String
    StorageOutbox As String
    ScanEnabled As String
    CheckInterval As Long
End Type

Private Type MailBoxInfo
    EAC_Code As String
    LastInboxCheck As Date
    LastOutboxCheck As Date
    InboxChecks As Long
    EmailsReceivedOk As Long
    EmailsReceivedErr As Long
    OutboxChecks As Long
    EmailsSentOk As Long
    EmailsSentErr As Long
End Type

Private Type AttachmentInfo
    EAI_Code As String
    EAT_Code As String
    FileName As String
    GeneratedName As String
End Type

Private mo_MailBox() As MailBoxDefinition
Private mo_MailBoxInfo() As MailBoxInfo
Private mi_MailBoxCount As Integer

' *************************************** CONTROL MEMBERS ******************************************

' **************************************************************************************************
' *********************************** PUBLIC CONTROL EVENTS ****************************************
' **************************************************************************************************
Public Event quit()
Public Event OnReadEmail(ByRef ao_EmailData As MailData)
Public Event OnSendEmail(ByRef ao_EmailData As MailData)
Public Event OnAddToLog(ByRef as_msg As String, ByRef as_Type As String)

' *********************************** PUBLIC CONTROL EVENTS ****************************************


' **************************************************************************************************
' ********************************* PUBLIC CONTROL PROPERTIES **************************************
' **************************************************************************************************
' database controler property
' Params:
' ao_db (ARMSYSCOMLib.ArmDb) - ArmSysCom instance
#If LIVE Then
Public Property Set Db(ByRef ao_Db As Object)
#Else
Public Property Set Db(ByRef ao_Db As ARMSYSCOMLib.ArmDb)
#End If

On Error GoTo ErrHandler
    If Not mo_Db Is Nothing Then Err.Raise ArmErr.CPTAlreadyInitialized
    If ao_Db Is Nothing Then Err.Raise ArmErr.InvalidArgument
    
    Set mo_Db = ao_Db
    
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LoginName(Let)")
End Property

' User code used in logs
Public Property Let U_Code(ByVal al_UserCode As Long)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ml_U_Code = al_UserCode
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

' Setting language code
Public Property Let Language_Code(ByVal as_newValue As String)
On Error GoTo ErrHandler
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_newValue) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_LanguageCode = as_newValue
    
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".Language_Code")
End Property

Public Property Let DefaultCharset(ByVal as_newValue As String)
On Error GoTo ErrHandler
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_DefaultCharset = as_newValue
    
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".DefaultCharset")
End Property

' Set Extended log
Public Property Let LogEx(ByVal al_logEx As Long)
On Error GoTo ErrHandler
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ml_LogEX = al_logEx
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".LogEx")
End Property

Public Property Let Server(ByVal as_Server As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Server = as_Server
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Server(Let)")
End Property

Public Property Let Database(ByVal as_Database As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Database = as_Database
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Database(Let)")
End Property

Public Property Let Pass(ByVal as_Pass As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Pass = as_Pass
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Pass(Let)")
End Property

Public Property Let User(ByVal as_User As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_User = as_User
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".User(Let)")
End Property

' ********************************* PUBLIC CONTROL PROPERTIES **************************************


' **************************************************************************************************
' ******************************* PUBLIC USER CONTROL METHODS **************************************
' **************************************************************************************************
' initialize user control
Public Function Load_A_COM()
Dim ls_Text As String

    On Error GoTo ErrHandler
    Load_A_COM = False
    
    lbl_Task = "Actual task:Initialization"
        
    If mb_Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized
    If mo_Db Is Nothing Then Err.Raise ArmErr.PropertyNotSet, "ArmDb not initialized"
    If ms_LanguageCode = "" Then Err.Raise ArmErr.PropertyNotSet, "LanguageCode not initialized"
    If ml_U_Code = 0 Then Err.Raise ArmErr.PropertyNotSet, "UserCode not initialized"
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ' init placeholders array
    ReDim mva_placeHolders(0) As Variant        ' at least one atom is required
    mva_placeHolders(0) = Array("CHARSET", Empty)    ' charset of email
        
    ms_MailAttachmentPath = App.Path & "\Temp"
        
    Call AddToLog(C_MODULE_NAME & " " & App.Major & "." & App.Minor & "." & App.Revision & " started..." & vbCrLf, "I")
   
    DefineSpam
    Call AddToLog("Spam defined:" & Join(mva_spamArray, ", "), "I")
    
    ' ArmNotes
    'Set mo_Notes = New ArmNotes
    'Set mo_Exchange = New ArmExchange
    Set mo_Exchange = New ArmGraph
    Call mo_Exchange.Load_A_COM
    mo_Exchange.TenantID = TenantID
    mo_Exchange.ApplicationID = AppID
    'mo_Notes.SwitchIDExe = ms_NotesPath & "\LNSwitchID.Exe" ' Must be in the notes directory !

    ' Load MailBox info to Check
    DefineMailBoxes
    Call AddToLogEx("Mail boxes loaded" & vbCrLf, "I")
    
    ' Define stats grid
    Call grd_stats.Load_A_COM
    grd_stats.UnBound = True
    
    Call grd_stats.SetColumns(Array( _
      Join(Array("EAC_Code", 850, 1, "EAC_Code", "EAC Code"), SEP) _
    , Join(Array("Email", 2350, 0, "Email", "Email"), SEP) _
    , Join(Array("Enabled", 700, 0, "Enabled", "Enabled", "String", "", "Center"), SEP) _
    , Join(Array("LastInboxCheck", 1200, 0, "LastInboxCheck", "LastCheck(I)", "Number", "", "Left"), SEP) _
    , Join(Array("InboxChecks", 800, 0, "InboxChecks", "Checks(I)", "Number", "", "Left"), SEP) _
    , Join(Array("ReceivedOK", 700, 0, "ReceivedOK", "Rec. Ok", "Number", "", "Left"), SEP) _
    , Join(Array("ReceivedErr", 700, 0, "ReceivedErr", "Rec. Err", "Number", "", "Left"), SEP) _
    , Join(Array("LastOutboxCheck", 1200, 0, "LastOutboxCheck", "LastCheck(O)", "Number", "", "Left"), SEP) _
    , Join(Array("OutboxChecks", 850, 0, "OutboxChecks", "Checks(O)", "Number", "", "Left"), SEP) _
    , Join(Array("SentOK", 650, 0, "SentOK", "SentOK", "Number", "", "Left"), SEP) _
    , Join(Array("SentErr", 700, 0, "SentErr", "SentErr", "Number", "", "Left"), SEP) _
    ))

    grd_stats.Rows = mi_MailBoxCount
    grd_stats.Title = "Start date:" & Format(Now, "yyyy-mm-dd hh:mm")

    ReDim mo_MailBoxInfo(-1 To -1)

    Call UpdateStats
        
    ' Heart Beat settings
    Set mo_HeartBeat = New HeartBeat
    
    If mo_HeartBeat.HeartBeatConfig(mo_Db, C_PROCESSNAME) = True Then
        ' chck if other instance is running
        If Not mo_HeartBeat.HeartbeatTest(mo_Db, C_PROCESSNAME) Then
            ' exit app
            If mb_IgnoreHeartBeatForDebbuging = False Then
                Call MsgBox("Another instance is running !")
                Call mo_Db.Disconnect
                End
            Else
                Call MsgBox("Heartbeat test ignored! Debbuging mode active.")
            End If
        End If
        
        Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, True)
        HeartBeatTimer.Enabled = True
    Else
        Call AddToLog("Mail Processor HeartBeat configuration error", "E")
    End If
    
    mb_Active = True    'MailProcessor control is active (if =False => Paused)
    
    mb_Initialized = True

    Load_A_COM = True
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Load_A_Com")
End Function

Private Sub UpdateStats()
On Error GoTo ErrHandler

    Dim ll_Idx As Long
    Dim ll_MailBoxInfoIdx As Long
    
    For ll_Idx = 0 To mi_MailBoxCount - 1
        grd_stats.Data(ll_Idx, "EAC_Code") = mo_MailBox(ll_Idx).EAC_Code
        grd_stats.Data(ll_Idx, "Email") = mo_MailBox(ll_Idx).EMailAddress
        grd_stats.Data(ll_Idx, "Enabled") = mo_MailBox(ll_Idx).ScanEnabled
        
        ll_MailBoxInfoIdx = GetMailBoxInfoIndex(ll_Idx)
        grd_stats.Data(ll_Idx, "LastInboxCheck") = Format(mo_MailBoxInfo(ll_MailBoxInfoIdx).LastInboxCheck, "yy-mm-dd hh:mm")
        grd_stats.Data(ll_Idx, "InboxChecks") = mo_MailBoxInfo(ll_MailBoxInfoIdx).InboxChecks
        grd_stats.Data(ll_Idx, "ReceivedOK") = mo_MailBoxInfo(ll_MailBoxInfoIdx).EmailsReceivedOk
        grd_stats.Data(ll_Idx, "ReceivedErr") = mo_MailBoxInfo(ll_MailBoxInfoIdx).EmailsReceivedErr
        
        grd_stats.Data(ll_Idx, "LastOutboxCheck") = Format(mo_MailBoxInfo(ll_MailBoxInfoIdx).LastOutboxCheck, "yy-mm-dd hh:mm")
        grd_stats.Data(ll_Idx, "OutboxChecks") = mo_MailBoxInfo(ll_MailBoxInfoIdx).OutboxChecks
        grd_stats.Data(ll_Idx, "SentOK") = mo_MailBoxInfo(ll_MailBoxInfoIdx).EmailsSentOk
        grd_stats.Data(ll_Idx, "SentErr") = mo_MailBoxInfo(ll_MailBoxInfoIdx).EmailsSentErr

        If grd_stats.Data(ll_Idx, "ReceivedErr") > 0 Then
            grd_stats.LineColor(ll_Idx) = vbRed
        End If
        If grd_stats.Data(ll_Idx, "SentErr") > 0 Then
            grd_stats.LineColor(ll_Idx) = vbRed
        End If
    Next
    Exit Sub
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateStats")
End Sub

' uninitialize user control
Public Sub Unload_A_COM()
On Error GoTo ErrHandler
    Call AddToLog("Mail Processor shutdown..." & vbCrLf, "I")

    Call grd_stats.Unload_A_COM

    If (CheckConnection(mo_Db) = True) Then
        Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, False)
    End If

    mb_Initialized = False

' DEBUG
    Debug.Assert (mo_Db.CursorCount = 0)
    
    Set mo_Db = Nothing
    Set mo_FSO = Nothing
    
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".Unload_A_COM")
End Sub
' ******************************* PUBLIC USER CONTROL METHODS **************************************


' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************


' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_errDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_errDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_errDescription & " - " & ls_ErrSource
    
    If ll_errNumber <> 0 Then
        RaiseEvent OnAddToLog(ls_Msg, as_logType)
    Else
        RaiseEvent OnAddToLog(as_logMsg, as_logType)
    End If
        
    ls_req = Replace(LOG_REQUEST, "$UCODE$", CStr(ml_U_Code), , , vbTextCompare)
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), , , vbTextCompare)
    ls_req = Replace(ls_req, "$MSG$", SQLStr(Left(Trim(ls_Msg), 4000)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$APP$", SQLStr(Left(Trim(ls_Source), 50)), , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be closed. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
End Sub


' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Public Function CheckConnection(ByVal ao_Db As Object) As Boolean
#Else
Public Function CheckConnection(ByVal ao_Db As ARMSYSCOMLib.ArmDb) As Boolean
#End If
Dim lc_Data As Long
On Error GoTo ErrHandler

    lc_Data = OpenSQLSafe(ao_Db, "SELECT GetDate()")
    ao_Db.Close (lc_Data)
    CheckConnection = True
    Exit Function
ErrHandler:
    mo_Db.Disconnect
    
    If Not mo_Db.Connect(ms_Server, ms_Database, ms_User, ms_Pass, "MailObserver") Then
        Call AddToLog("Connection to db lost.", "E")
    Else
        CheckConnection = True
        Exit Function
    End If
    
    CheckConnection = False
End Function

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support")
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support")
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    If mo_Db.LastErrorCode <> 3903 Then
        mo_Db.Disconnect
        Set mo_Db = Nothing
        Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support")
        End
    Else
        Err.Number = ll_errNumber
        Err.Source = ls_ErrSrc
        Err.Description = ls_ErrDesc
    
        RollbackTran = True
    
    End If
End Function

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

Public Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 0, Optional ByVal ab_LogError As Boolean = True) As String
On Error GoTo ErrHandler
    
    If as_str = "NULL" Then
        SQLStr = "NULL"
    Else
        If al_MaxLen > 0 Then
            as_str = Trim(as_str)
            If Len(as_str) > al_MaxLen Then
                If ab_LogError Then
                    Call LogMessage("Value trimmed (" & al_MaxLen & ") '" & as_str & "' to '" & Left(as_str, al_MaxLen) & "'")
                End If
                as_str = Left(as_str, al_MaxLen)
            End If
        End If
        SQLStr = "'" & Replace(as_str, "'", "''") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SQLStr as_Str=" & as_str)
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function

' **************************** DB-ACCESS FUNCTIONS ***********************************

' *******************************************************************************
' ************************ DISK IO FUNCTIONS ************************************
' *******************************************************************************
' create directory if not exist
Private Function CreateDirStruct(ByVal strPath As String, ByVal ao_FSO As Object) As Boolean

On Error GoTo Create_Dir_Struct_Errors
    Dim intIndex    As Integer
    Dim strTmpPath  As String
    
    If Len(Trim$(strPath)) = 0 Then
        ' if we specify wrong path it is error
        CreateDirStruct = False
        Exit Function
    End If
    
    If right$(strPath, 1) <> "\" Then strPath = strPath & "\"
    intIndex = 0
    
    Do
        ' get the next path chunk
        intIndex = InStr(intIndex + 1, strPath, "\")
        
        If intIndex > 0 Then
            strTmpPath = Left$(strPath, intIndex - 1)
        Else
            Exit Do
        End If
        
        ' see if this folder exists
        If Not ao_FSO.FolderExists(strTmpPath) Then
            ' Create this folder.
            ' If there is an error, it will be trapped bellow
            ao_FSO.CreateFolder strTmpPath
            intIndex = 1
        End If
    Loop
    CreateDirStruct = True
    Exit Function

Create_Dir_Struct_Errors:
    Call ErrorHandler(Extender.Name & ".CreateDirStruct()")
End Function

' delete files one by one
Private Function DeleteFiles(ByVal as_Path As String, ByVal as_pattern As String, ao_FSO As Object) As Boolean
  
On Error GoTo KillFiles_Errors
  
    Dim lo_Files    As Object
    Dim lo_folder   As Object
    Dim lo_File     As Object


    Set lo_folder = ao_FSO.GetFolder(as_Path)
    Set lo_Files = lo_folder.Files

    For Each lo_File In lo_Files
        If lo_File.Name Like as_pattern Then Call DeleteFile(lo_File)
    Next
    
    Set lo_File = Nothing
    Set lo_Files = Nothing
    Set lo_folder = Nothing
    
    DeleteFiles = True
    Exit Function
    
KillFiles_Errors:
    ' free resources
    If Not lo_File Is Nothing Then Set lo_File = Nothing
    If Not lo_Files Is Nothing Then Set lo_Files = Nothing
    If Not lo_folder Is Nothing Then Set lo_folder = Nothing
    
    Call ErrorHandler(Extender.Name & ".DeleteFiles()")
End Function

' function will delete file
' if file cannot be deleted, function return false and log event
Private Function DeleteFile(ByVal ao_File As Object) As Boolean
On Error GoTo KillFile_Errors
    Debug.Assert (Not ao_File Is Nothing)
    ao_File.Delete (True)
    DeleteFile = True
    Exit Function
KillFile_Errors:
    Call ErrorHandler(Extender.Name & ".DeleteFile()")
End Function
' ************************ DISK IO FUNCTIONS ************************************


' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************

' Log information
Private Sub AddToLog(ByVal as_Operation As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
Dim ll_errNumber As Long
Dim ls_errDescription As String, ls_ErrSource As String

ll_errNumber = Err.Number
ls_errDescription = Err.Description
ls_ErrSource = Err.Source
        
    On Error GoTo ErrHandler
   
    If as_logType <> "D" Then
        
        Err.Number = ll_errNumber
        Err.Description = ls_errDescription
        Err.Source = ls_ErrSource
        
        Call LogMessage(as_Operation, as_logType, ab_ExitOnException)
        
    End If
            
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
    Exit Sub

ErrHandler:
    RaiseEvent OnAddToLog("Unable to create log." & SEP1 & Err.Number & " : " & Err.Description & " - " & Err.Source, "E")
    RaiseEvent OnAddToLog("Current error: " & SEP1 & ll_errNumber & " : " & ls_errDescription & " - " & ls_ErrSource, "E")
End Sub

' used for debuging
Private Sub AddToLogEx(ByVal as_Operation As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
Dim ll_errNumber As Long
Dim ls_errDescription As String, ls_ErrSource As String

ll_errNumber = Err.Number
ls_errDescription = Err.Description
ls_ErrSource = Err.Source

    On Error GoTo ErrHandler
    
    If ml_LogEX > 0 Then
        RaiseEvent OnAddToLog(vbTab & "Debug Info:" & as_Operation, as_logType)
    End If
    
    If ml_LogEX > 1 Then
        Err.Number = ll_errNumber
        Err.Description = ls_errDescription
        Err.Source = ls_ErrSource
        
        Call LogMessage(as_Operation, as_logType, ab_ExitOnException)
    End If
        
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
    
    Exit Sub

ErrHandler:
    RaiseEvent OnAddToLog("Unable to create log." & SEP1 & Err.Number & " : " & Err.Description & " - " & Err.Source, "E")
    RaiseEvent OnAddToLog("Current error: " & SEP1 & ll_errNumber & " : " & ls_errDescription & " - " & ls_ErrSource, "E")
End Sub

' Generate new email based on setting in database
Private Function OutgoingEmailProcessing(ByVal al_AccIdx As Long, ByVal al_CursorMailBox As Long, ByVal al_Pos As Long) As emlSendEmailStatus

Const C_REQ_FILE As String = "INSERT INTO SPA_LinkedEmailZip VALUES($SPA_EML_ZIP_ID$, ?)"
Const C_REQ As String = "SPA_LinkedEmail_ins $SPA_EML_ID$, $SPA_ID$, $SPA_EML_ZIP_ID$, $EML_Subject$, $EML_SenderEmailAddress$, $EML_To$, $EML_SenderName$, $EML_Attachements$, $EML_CreationTime$, $Z_Creator$"
 
Dim ls_Operation            As String  ' Current operation description
Dim ls_Body                 As Variant  ' Email content
Dim ls_path                 As String   ' path to NSF file used to send email
Dim ls_From                 As String   ' EMail from address
Dim ls_DestTo               As String   ' List of email addresses - To
Dim ls_DestCopy             As String   ' List of email addresses - Cc
Dim ll_Cursor               As Long     ' Attachment info cursor
Dim ls_EML_Code             As String
Dim ls_EML_Subject          As String
Dim lv_OutgoingPath         As Variant
Dim ls_Storage              As String
Dim ls_Directory            As String
Dim ls_Name                 As String
Dim ls_StoredName           As String
Dim ls_EAT_Code             As String
Dim li_Idx                  As Integer
Dim la_AttachmentInfo()     As AttachmentInfo
Dim lo_folder               As Object
Dim lb_IsHTML               As Boolean
Dim lb_RetValue             As Boolean
Dim ls_Charset              As String

    On Error GoTo ErrHandler
    
    OutgoingEmailProcessing = emlSendEmailStatus.sesOK   ' success
    
    If al_Pos < 0 And al_Pos > mo_Db.RowCount(al_CursorMailBox) - 1 Then
        Err.Raise ArmErr.InvalidValue, "RowCount", "Row index out of range:" & al_Pos
    End If
    
    ls_EML_Code = mo_Db.GetFieldsAt(al_CursorMailBox, al_Pos, "EML_Code")
    ls_EML_Subject = mo_Db.GetFieldsAt(al_CursorMailBox, al_Pos, "EML_Subject")
    ls_Charset = mo_Db.GetFieldsAt(al_CursorMailBox, al_Pos, "EML_Charset")

    ls_Operation = "One new outgoing mail found. Mail EML_Code: " & ls_EML_Code & " " & Date & " " & Time & "  "
    Call AddToLogEx(ls_Operation, "I")
           
    ls_DestTo = GetEmailAddress(ls_EML_Code, emlEmailType.etEmailTo)
    ls_DestCopy = GetEmailAddress(ls_EML_Code, emlEmailType.etEmailCopyTo)
    
    lb_IsHTML = False
    ls_Body = GetEmailBody(ls_EML_Code, lb_IsHTML)
    
    ll_Cursor = OpenSQLSafe(mo_Db, "EXEC EML_AttachmentInfo_lst " & ls_EML_Code)
    
    ReDim la_AttachmentInfo(-1 To -1)
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        
        ReDim la_AttachmentInfo(mo_Db.RowCount(ll_Cursor) - 1)
    
        li_Idx = 0
        
        ' clear outgoing emails attachments folder
        lv_OutgoingPath = ms_MailAttachmentPath
        
        If Not mo_FSO.FolderExists(lv_OutgoingPath) Then
            If Not CreateDirStruct(ms_MailAttachmentPath, mo_FSO) Then
                Call Err.Raise(CompFncFailed, "OutgoingEmailsProcessing", "Folder for outgoing email attachment does not exist and cannot be created.(" & lv_OutgoingPath & ")")
            End If
        End If
        
        Set lo_folder = mo_FSO.GetFolder(lv_OutgoingPath)
        Call mo_FSO.DeleteFile(lv_OutgoingPath & "\*.*", True)
        
         ' Extract attachments
        mo_Db.First (ll_Cursor)
    
        While Not mo_Db.EOF(ll_Cursor)
        
            ls_Storage = mo_Db.GetFields(ll_Cursor, "EAI_Storage")
            ls_Directory = mo_Db.GetFields(ll_Cursor, "EAI_Directory")
            ls_Name = mo_Db.GetFields(ll_Cursor, "EAI_Name")
            ls_StoredName = mo_Db.GetFields(ll_Cursor, "EAI_StoredName")
            ls_EAT_Code = mo_Db.GetFields(ll_Cursor, "EAT_Code")
        
            If ls_Storage <> EML_ATTSTORAGE_IGNORE Then
                   
                If ls_Storage = EML_ATTSTORAGE_SQLDATABASE Then
                    'get attachments from database and save them into outgoing directory
                    If Not mo_Db.BlobToFileSQL("SELECT EAT_Data FROM EML_Attachment WHERE EAT_Code=" & ls_EAT_Code, lv_OutgoingPath & "\" & ls_Name, True) Then
                         Err.Raise ArmErr.SQLFailure, "BlobToFileSQL", "Error reading file from blob! File: " & lv_OutgoingPath & "\" & ls_Name
                    End If

                ElseIf ls_Storage = EML_ATTSTORAGE_DIRECTORY Then
                    'copy attachments into outgoing directory
                    Call mo_FSO.CopyFile(ls_Directory & ls_StoredName, lv_OutgoingPath & "\" & ls_Name)
                End If
                
                la_AttachmentInfo(li_Idx).FileName = lv_OutgoingPath & "\" & ls_Name
                la_AttachmentInfo(li_Idx).GeneratedName = ls_Name                       ' for outgoing attachement
            End If
            
            li_Idx = li_Idx + 1
            mo_Db.Next (ll_Cursor)
        Wend
        
    End If
    
    mo_Db.Close (ll_Cursor)
    ll_Cursor = 0
    
#If LIVE = 0 Then
    If IsAllowedDestAddress(ls_DestTo) = False Or IsAllowedDestAddress(ls_DestCopy) = False Then
        Call AddToLog("Email To address or CopyTo address is not allowed. EML_Code:" & ls_EML_Code, "E")
        OutgoingEmailProcessing = emlSendEmailStatus.sesInvalid
        Exit Function
    End If
#End If
    
    If CheckEmailParameters(ls_DestTo, ls_EML_Subject) = True Then
        
        ' check if it is email linked to SPA
        Dim ll_SPA_ID As Long
        Dim ls_SPA_EML_ID As String
        Dim ls_SPA_EML_ZIP_ID As String
        Dim ls_eml_file As String
        ls_eml_file = ""
        ll_SPA_ID = IsSPALinkedMail(ls_EML_Code)
        If ll_SPA_ID <> -1 Then
            ' manage to save email into SPA linked emails after sending
            ls_SPA_EML_ID = mo_Db.SQLNextID("SPA_LinkedEmail")
            If ls_SPA_EML_ID = "" Then
                Err.Raise ArmErr.CompFncFailed, "mo_Db.SQLNextID", "SQLNextID failed for: SPA_LinkedEmail"
            End If
            
            ls_SPA_EML_ZIP_ID = mo_Db.SQLNextID("SPA_LinkedEmailZip")
            If ls_SPA_EML_ZIP_ID = "" Then
                Err.Raise ArmErr.CompFncFailed, "mo_Db.SQLNextID", "SQLNextID failed for: SPA_LinkedEmailZip"
            End If
            
            ls_eml_file = ms_MailAttachmentPath & "\SPA_Email_" & ls_SPA_EML_ZIP_ID & ".msg"
        End If
        
        On Error Resume Next
        lb_RetValue = SendMail(ls_EML_Code, ls_DestTo, ls_DestCopy, mo_MailBox(al_AccIdx).DirectoryOutbox, mo_MailBox(al_AccIdx).Name, _
                               la_AttachmentInfo(), mo_MailBox(al_AccIdx).Password, ls_EML_Subject, ls_Body, ls_Charset, mo_MailBox(al_AccIdx).KeyFileName, _
                               mo_MailBox(al_AccIdx).Certificate, mo_MailBox(al_AccIdx).MailFile, mo_MailBox(al_AccIdx).Location, lb_IsHTML, ls_eml_file)
        
        On Error GoTo ErrHandler
            
        If lb_RetValue = True Then
            Call AddToLogEx("Email sent success.", "I")
            ' put saved email into SPA linked emails
            If ll_SPA_ID <> -1 Then
                If mo_FSO.FileExists(ls_eml_file) Then
                    'Insert the file
                    Dim ls_req As String
                    ls_req = ReplacePlaceHolder(C_REQ_FILE, "$SPA_EML_ZIP_ID$", ls_SPA_EML_ZIP_ID)
                
                    If Not mo_Db.FileToBlobSQL(ls_req, ls_eml_file, 9) Then
                        Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", mo_Db.LastErrorMessage & " Error writing blob: " & ls_req & " File: " & ls_eml_file
                    End If
                
                    ' insert record
                    ls_req = ReplacePlaceHolder(C_REQ, "$Z_Creator$", ml_U_Code)
                    ls_req = ReplacePlaceHolder(ls_req, "$SPA_EML_ID$", ls_SPA_EML_ID)
                    ls_req = ReplacePlaceHolder(ls_req, "$SPA_ID$", ll_SPA_ID)
                    ls_req = ReplacePlaceHolder(ls_req, "$SPA_EML_ZIP_ID$", ls_SPA_EML_ZIP_ID)
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_Subject$", SQLStr(ls_EML_Subject, 150))
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_SenderEmailAddress$", SQLStr(mo_MailBox(al_AccIdx).Name, 150))
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_To$", SQLStr(ls_DestTo, 150))
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_SenderName$", SQLStr(mo_MailBox(al_AccIdx).Name, 150))
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_Attachements$", UBound(la_AttachmentInfo) + 1)
                    ls_req = ReplacePlaceHolder(ls_req, "$EML_CreationTime$", SqlDate(Now()))
                    Call ExecuteSQLSafe(mo_Db, ls_req)
                Else
                    ' the email item was not saved
                    Call AddToLog("SPA Linked email was not saved( SPA:" & ll_SPA_ID & " EML_Code:" & ls_EML_Code, "E")
                End If

            End If
        Else
            OutgoingEmailProcessing = emlSendEmailStatus.sesFailed   ' Fail
        End If
    Else
        Call AddToLog("Email parameters not valid. EML_Code:" & ls_EML_Code, "E")
        OutgoingEmailProcessing = emlSendEmailStatus.sesInvalid   ' Invalid email
    End If

    Exit Function

ErrHandler:
    OutgoingEmailProcessing = emlSendEmailStatus.sesFailed  ' Fail
    
    UpdateError (True)
    
    If ll_Cursor > 0 Then
        mo_Db.Close (ll_Cursor)
        ll_Cursor = 0
    End If
    
    UpdateError (False)
    
    ls_Operation = Extender.Name & ".OutgoingEmailsProcessing Error. EML_Code:" & ls_EML_Code & ",EAC_Code:" & mo_MailBox(al_AccIdx).EAC_Code
    Call AddToLog(ls_Operation, "E")
    Call ErrorHandler(Extender.Name & ".OutgoingEmailsProcessing")
End Function
Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function
Private Function IsSPALinkedMail(ByVal as_EML_Code As String) As Long
Const C_REQ As String = "EXEC EML_Mail_Is_SPA_chk $EML_CODE$"
On Error GoTo ErrHandler
    IsSPALinkedMail = -1
    Dim ll_Cursor As Long
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$EML_CODE$", as_EML_Code, , , vbTextCompare))
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        ' yes the email is linked to SPA
        IsSPALinkedMail = mo_Db.GetFields(ll_Cursor, "SPA_Id")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".IsSPALinkedMail")
End Function

Private Function CheckEmailParameters(ByVal as_DestTo As String, ByVal as_Subject As String)
On Error GoTo ErrHandler

    If as_DestTo = "" Then
        Call AddToLog("Empty destination email address.", "E")
        CheckEmailParameters = False
        Exit Function
    End If
    
    If as_Subject = "" Then
        Call AddToLog("Empty Subject of email to be send.", "E")
        CheckEmailParameters = False
        Exit Function
    End If
    
    CheckEmailParameters = True
    Exit Function
    
ErrHandler:
    CheckEmailParameters = False
    Call ErrorHandler(Extender.Name & ".CheckEmailParameters")
End Function

Private Function GetAccountIndex(ByVal as_EAC_Code As String)
Dim li_Idx As Integer

On Error GoTo ErrHandler
    
    GetAccountIndex = -1
    
    For li_Idx = 0 To UBound(mo_MailBox) - 1
        If mo_MailBox(li_Idx).EAC_Code = as_EAC_Code Then
            GetAccountIndex = li_Idx
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetAccountIndex()")
End Function

Private Function IsEmailBlackListed(ByVal as_EAC_Code As String, ByVal as_EmailAddress As String)

Const BL_REQ As String = "EXEC EML_BlackList_IsBlacklisted $EAC_Code$,$EBL_Address$"

On Error GoTo ErrHandler
Dim lsReq       As String
Dim ll_Cursor   As Long
    
    IsEmailBlackListed = False
      
    lsReq = Replace(BL_REQ, "$EAC_Code$", as_EAC_Code, , , vbTextCompare)
    lsReq = Replace(lsReq, "$EBL_Address$", SQLStr(as_EmailAddress), , , vbTextCompare)
    
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        IsEmailBlackListed = True
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Function
   
ErrHandler:
    IsEmailBlackListed = False
    
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".IsEmailBlackListed()")
End Function


' Send email according to parameters
Private Function SendMail(ByVal as_EML_Code As String, ByVal as_DestTo As String, ByVal as_DestCopy As String, ByVal as_Path As String, ByVal as_From As String, _
                          ByRef as_Attachment() As AttachmentInfo, ByVal as_Password As String, ByVal as_Subject As Variant, ByVal as_Body As Variant, ByVal as_Charset As String, ByVal as_SendAsAccount As String, _
                          ByVal as_CertificateExpChecked As String, ByVal as_MailFile As String, ByVal as_MailLocation As String, ByVal ab_IsHtml As Boolean, ByVal as_saveAsPath As String) As Boolean
                          
Dim li_Idx          As Integer
Dim ls_FileSource   As String
Dim lo_Mail         As ArmGraphMail
Dim ls_Operation    As String
    
Dim lb_retVal As Boolean

    On Error GoTo ErrHandler
  
    SendMail = True
  
    Set lo_Mail = New ArmGraphMail
    Call lo_Mail.Load_A_COM
           
    lo_Mail.Subject = as_Subject
    If ab_IsHtml = True Then
        lo_Mail.HTMLBody = as_Body
        lo_Mail.HTMLCharset = as_Charset
    Else
        lo_Mail.Body = as_Body
    End If
    
    lo_Mail.SetTextAddrTo as_DestTo
    lo_Mail.SetTextAddrCc as_DestCopy
    
    'lo_Mail.SendFromLocation = as_MailLocation
    'lo_Mail.SendAsAccount = as_From
    
    ' add attachments
    If UBound(as_Attachment) <> -1 Then
        For li_Idx = 0 To UBound(as_Attachment)
            If as_Attachment(li_Idx).FileName <> "" Then
                ls_FileSource = as_Attachment(li_Idx).FileName
                If mo_FSO.FileExists(ls_FileSource) Then
                    Call AddToLogEx("lo_Mail.AddAttachment:" & ls_FileSource, "I")
                    
                    Dim lo_att As ArmGraphMailAttachment
                    Set lo_att = New ArmGraphMailAttachment
                    lo_att.Load_A_COM
            
                    lo_att.Name = as_Attachment(li_Idx).GeneratedName
                    lo_att.LocalPath = ls_FileSource
                    lo_att.IsInline = False
    
                    lb_retVal = lo_Mail.AddAttachment(lo_att)
                    
                    'lb_retVal = lo_Mail.AddAttachment(ls_FileSource)
                    Call AddToLogEx("lo_Mail.AddAttachment: returned " & IIf(lb_retVal, "TRUE", "FALSE"), "I")
                    
                    Set lo_att = Nothing
                End If
            End If
        Next
    End If
        
    Call AddToLogEx("mo_Exchange.SendMail", "I")
    mo_Exchange.SaveMessageOnSend = True
    If Not mo_Exchange.SendMail(lo_Mail, as_saveAsPath) Then
        Call Err.Raise(CompFncFailed, "mo_Exchange.SendMail", "Unable to send the mail: EML_Code =" & as_EML_Code)
    End If
    Call AddToLogEx("mo_Exchange.SendMail: returned TRUE", "I")
       
    Call lo_Mail.Unload_A_COM
    Set lo_Mail = Nothing
    
    Exit Function
    
ErrHandler:
    SendMail = False
    Set lo_Mail = Nothing
        
    ls_Operation = "Error during SendMail: EML_Code = " & as_EML_Code
    Call AddToLog(ls_Operation, "E")
    
    Call ErrorHandler(Extender.Name & ".SendMail")
End Function

Private Function IsAllowedDestAddress(ByVal as_Emails As String)
Const ALLOWED_EMAILS As String = "TMasson@armstrongceilings.com," & _
                                "lsauvage@armstrongceilings.com," & _
                                "JTrovo@armstrongceilings.com," & _
                                "PDemeulenaere@armstrongceilings.com," & _
                                "ETORTILLON@armstrongceilings.com," & _
                                "DEales@armstrongceilings.com," & _
                                "LScott@armstrongceilings.com," & _
                                "walter@estimate.sk,nagy@estimate.sk,juliusn@qniom.com,julius.nagy@qniom.com,info@qniom.com," & _
                                "sedlak@estimate.sk,info@estimate.sk," & _
                                "ABPAPP1@armstrongceilings.com," & _
                                "ABPAPP2@armstrongceilings.com," & _
                                "ABPAPP3@armstrongceilings.com," & _
                                "ABPITS@armstrongceilings.com," & _
                                "ABPREQ@armstrongceilings.com," & _
                                "cblevins@armstrongceilings.com," & _
                                "asaeed@armstrongceilings.com," & _
                                "FBrenchley@armstrongceilings.com,EVasilieva@armstrongceilings.com,MSalt@armstrongceilings.com," & _
                                "OKarkhanin@armstrongceilings.com,sfronina@armstrongceilings.com,SYakunin@ armstrongceilings.com"

On Error GoTo ErrHandler

Dim la_Emails() As String
Dim ll_Idx      As Long

    IsAllowedDestAddress = True
    
    la_Emails = Split(as_Emails, ",")
    
    For ll_Idx = 0 To UBound(la_Emails)
        If InStr(1, UCase(ALLOWED_EMAILS), UCase(la_Emails(ll_Idx)), vbTextCompare) <= 0 Then
            IsAllowedDestAddress = False
            Exit Function
        End If
    Next
    
    Exit Function
ErrHandler:
    IsAllowedDestAddress = False
    Call ErrorHandler(Extender.Name & ".IsAllowedDestAddress")
End Function

' Define the list of Mailboxes which should be checked by MailScanner
Private Sub DefineMailBoxes()
Dim ll_Cursor   As Long
Dim li_Idx      As Integer
Dim ld_MailBoxInfo As Dictionary 'required by ArmExchange
On Error GoTo ErrHandler
      
    ' Get all active mailboxes
    ll_Cursor = OpenSQLSafe(mo_Db, "EXEC EML_GetMailBoxes_lst3 Null,Null")
    
    mi_MailBoxCount = mo_Db.RowCount(ll_Cursor)
    Set ld_MailBoxInfo = Nothing
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
    
        Set ld_MailBoxInfo = New Dictionary
        ld_MailBoxInfo.CompareMode = TextCompare
        
        ReDim mo_MailBox(mo_Db.RowCount(ll_Cursor) - 1)
        li_Idx = 0
            
        While Not mo_Db.EOF(ll_Cursor)
            mo_MailBox(li_Idx).EAC_Code = mo_Db.GetFields(ll_Cursor, "EAC_Code")
            mo_MailBox(li_Idx).EAC_Desc = mo_Db.GetFields(ll_Cursor, "EAC_Desc")
            mo_MailBox(li_Idx).Application = mo_Db.GetFields(ll_Cursor, "EAC_Application")
            mo_MailBox(li_Idx).Name = mo_Db.GetFields(ll_Cursor, "EAC_Name")
            mo_MailBox(li_Idx).Password = mo_Db.GetFields(ll_Cursor, "EAC_Password")
            mo_MailBox(li_Idx).KeyFileName = mo_Db.GetFields(ll_Cursor, "EAC_KeyFileName")
            mo_MailBox(li_Idx).Certificate = mo_Db.GetFields(ll_Cursor, "EAC_CertificateExpChecked")
            mo_MailBox(li_Idx).MailFile = mo_Db.GetFields(ll_Cursor, "EAC_MailFile")
            mo_MailBox(li_Idx).Location = mo_Db.GetFields(ll_Cursor, "EAC_Location")
            mo_MailBox(li_Idx).EMailAddress = mo_Db.GetFields(ll_Cursor, "EAC_EMailAddress")
            mo_MailBox(li_Idx).DirectoryInbox = mo_Db.GetFields(ll_Cursor, "EAC_DirectoryInbox")
            mo_MailBox(li_Idx).StorageInbox = mo_Db.GetFields(ll_Cursor, "EAC_StorageInbox")
            mo_MailBox(li_Idx).DirectoryOutbox = mo_Db.GetFields(ll_Cursor, "EAC_DirectoryOutbox")
            mo_MailBox(li_Idx).StorageOutbox = mo_Db.GetFields(ll_Cursor, "EAC_StorageOutbox")
            mo_MailBox(li_Idx).ScanEnabled = mo_Db.GetFields(ll_Cursor, "EAC_ScanEnabled")
            mo_MailBox(li_Idx).CheckInterval = mo_Db.GetFields(ll_Cursor, "EAC_CheckInterval")
            
            If mo_MailBox(li_Idx).EMailAddress <> "" Then
                If ld_MailBoxInfo.Exists(mo_MailBox(li_Idx).EMailAddress) = False Then
                    Call ld_MailBoxInfo.Add(mo_MailBox(li_Idx).EMailAddress, mo_MailBox(li_Idx).Location)
                End If
            End If
            
            li_Idx = li_Idx + 1
            Call mo_Db.Next(ll_Cursor)
        Wend
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    'mo_Exchange.MailBoxFolderInfo = ld_MailBoxInfo
    Exit Sub

ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".DefineMailBoxes")
End Sub

' Check account for new emails
'Private Function CheckMailBox(ByVal al_MailBoxIdx As Long, ByVal al_MailIdx As Long) As Boolean
Private Function CheckMailBox(ByVal al_MailBoxIdx As Long, ByVal lo_Mail As ArmGraphMail) As Boolean

On Error GoTo ErrHandler

Const REQ_MAIL_INS As String = "exec EML_Mail_ins $EML_Code$,$EAC_Code$,'$EML_Mailbox$','$EML_MailStatus$','$EML_MailType$',$EML_MailLink$,$EML_Subject$,$EML_Charset$,$EML_AppStatus$,$EML_DateReceived$,$EML_DateToSend$,$EML_DateSent$,$Z_Creator$"

Dim ls_req              As String
Dim ls_To               As String   ' List of email addresses "To"
Dim ls_CC               As String   ' List of email addresses "Cc"
Dim ls_BCC              As String   ' List of email addresses "Bcc"
Dim ls_From             As String   ' List of email addresses "From"
Dim ls_Message          As Variant   ' Content of message
Dim ls_HTMLMessage      As Variant
Dim lb_IsHTML           As Boolean
Dim ls_Subject          As Variant
Dim ls_EML_Code         As String
Dim ll_EMC_Code         As Long
Dim ls_HTMLCharset      As String
Dim ls_StatusForNeEmail As String

Dim lv_IncomingPath     As Variant
Dim ls_Operation        As String
Dim lo_folder           As Object
Dim ls_SafeFileName     As String
Dim lb_InTransaction    As Boolean
Dim la_AttachmentInfo() As AttachmentInfo
Dim lb_AttachmentsCopied As Boolean
Dim lb_retVal           As Boolean

Dim lo_MailData         As MailData

#If LIVE = 1 Then
'Dim lo_InboxFolder      As Object
Dim lo_InboxFolder      As ArmGraphMailbox
#Else
'Dim lo_InboxFolder      As outlook.MAPIFolder
Dim lo_InboxFolder      As ArmGraphMailbox
#End If


    CheckMailBox = True
    lb_InTransaction = False
    lb_AttachmentsCopied = False

    Dim lv_AttachedName As Variant, ll_Index As Long
    
    DoEvents

    ' Read email
    'Call AddToLogEx("mo_Exchange.ReadMail:" & "olFolderInbox" & " Nb:" & al_MailIdx, "I")
    'Set lo_InboxFolder = mo_Exchange.GetMailboxFolder(mo_MailBox(al_MailBoxIdx).Location, "Inbox")
    Set lo_InboxFolder = mo_Exchange.GetMailboxFolder("Inbox")
    
    
'    If lo_Mail Is Nothing Then
    If Not mo_Exchange.ReadMail(lo_Mail) Then
      'error during open database.
      'ls_Operation = "Error during ReadMail : " & mo_MailBox(al_MailBoxIdx).Location & "," & mo_MailBox(al_MailBoxIdx).MailFile & "," & mo_MailBox(al_MailBoxIdx).Password
      'Err.Raise ArmErr.CPTNotInitialized, "Error during ReadMail : " & mo_MailBox(al_MailBoxIdx).Location & "," & mo_MailBox(al_MailBoxIdx).MailFile & "," & mo_MailBox(al_MailBoxIdx).Password
      Err.Raise ArmErr.CPTNotInitialized, "Error during ReadMail : " & lo_Mail.URL
    ElseIf lo_Mail.IsReportItem = True Then
        Call AddToLogEx("mo_Exchange.ReadMail: Report item deleted.", "I")
        Set lo_Mail = Nothing
    Else
        Call AddToLogEx("mo_Exchange.ReadMail:returned OK", "I")
        ' Extract attachments
        lv_IncomingPath = ms_MailAttachmentPath
        If Not mo_FSO.FolderExists(lv_IncomingPath) Then
            If Not CreateDirStruct(lv_IncomingPath, mo_FSO) Then
                Call Err.Raise(CompFncFailed, "CheckMailBox", "Folder for incoming email attachment does not exist and cannot be created. (" & lv_IncomingPath & ")")
            End If
        End If
        
        Set lo_folder = mo_FSO.GetFolder(lv_IncomingPath)
        Call mo_FSO.DeleteFile(lv_IncomingPath & "\*.*", True)
        
        For ll_Index = 1 To lo_Mail.Attachments.Count
            Call AddToLogEx("Start to process attachement Nb:" & ll_Index, "I")
            lv_AttachedName = lo_Mail.Attachments(ll_Index).Name
            Call AddToLogEx("Orig name:" & lv_AttachedName, "I")
            'todo
            'Text1.Text = ConvertCodePageFromUnicode(lv_IncomingPath & "\" & lv_AttachedName, 1251)
            Dim l1 As Integer
            For l1 = 1 To Len(lv_AttachedName)
               ls_SafeFileName = ls_SafeFileName + Chr(Asc(Mid(lv_AttachedName, l1, 1)))
            Next
            
             If (InStr(1, ls_SafeFileName, "?") > 0) Then
                If Len(ConvertCodePageFromUnicode(lv_AttachedName, 1251)) > 0 Then
                    ls_SafeFileName = ConvertCodePageFromUnicode(lv_AttachedName, 1251)
                Else
                    ls_SafeFileName = ConvertCodePageFromUnicode(lv_AttachedName, 1250)
                End If
             Else
                ls_SafeFileName = lv_AttachedName
             End If
            ls_SafeFileName = Replace(ls_SafeFileName, "?", "_")
             
            Call AddToLogEx("lo_Mail.GetAttachment:" & lv_AttachedName & " to:" & lv_IncomingPath & "\" & ls_SafeFileName, "I")
            'lb_retVal = lo_Mail.GetAttachment(ll_Index, lv_IncomingPath & "\" & ls_SafeFileName)
            lb_retVal = lo_Mail.Attachments(ll_Index).Save(lv_IncomingPath & "\" & ls_SafeFileName)
            Call AddToLogEx("lo_Mail.GetAttachment: returned " & IIf(lb_retVal, "TRUE", "FALSE"), "I")
            
        Next

        ls_To = lo_Mail.GetTextAddrTo
        ls_CC = lo_Mail.GetTextAddrCc
        ls_BCC = lo_Mail.GetTextAddrBcc
        ls_From = lo_Mail.GetTextAddrFrom
        
        ls_Subject = lo_Mail.Subject
        ls_Message = lo_Mail.Body
        
        lb_IsHTML = False
        ls_HTMLMessage = ""
        ls_HTMLCharset = ""
        If lo_Mail.HTMLBody <> "" Then
            ls_HTMLMessage = lo_Mail.HTMLBody
            ls_HTMLCharset = lo_Mail.HTMLCharset
            lb_IsHTML = True
        End If
        
        ls_From = ExtractEMailAddress(ls_From)
        ls_StatusForNeEmail = GetStatusForNewMail(mo_MailBox(al_MailBoxIdx).EAC_Code, ls_Subject, ls_From)
                   
        ls_EML_Code = mo_Db.SQLNextID("EML_Mail")
        ll_EMC_Code = mo_Db.SQLNextID("EML_Content")
        
        ' Insert into EML_Attachment
        lb_AttachmentsCopied = InsertAttachmentFile(ls_EML_Code, mo_MailBox(al_MailBoxIdx).StorageInbox, mo_MailBox(al_MailBoxIdx).DirectoryInbox, lo_folder, la_AttachmentInfo)
                        
        'begin transaction...
        BeginTran ("EML_Mail")
        lb_InTransaction = True
        
        ' Insert into EML_Mail
        
        ls_req = Replace(REQ_MAIL_INS, "$EML_Code$", ls_EML_Code, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EAC_Code$", mo_MailBox(al_MailBoxIdx).EAC_Code, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_Mailbox$", EML_MAILBOX_INBOX, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_MailStatus$", ls_StatusForNeEmail, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_MailType$", EML_MAILTYPE_DEFAULT, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_MailLink$", "Null", , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_Subject$", SQLStr(ls_Subject), , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_Charset$", SQLStr(ls_HTMLCharset), , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_AppStatus$", "Null", , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_DateReceived$", SqlDate(Now), , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_DateToSend$", "Null", , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_DateSent$", "Null", , , vbTextCompare)
        ls_req = Replace(ls_req, "$Z_Creator$", ml_U_Code, , , vbTextCompare)
        
        Call ExecuteSQLSafe(mo_Db, ls_req)
        
        ' Insert into EML_AttachmentInfo
        Call InsertAttachmentInfo(ls_EML_Code, mo_MailBox(al_MailBoxIdx).StorageInbox, mo_MailBox(al_MailBoxIdx).DirectoryInbox, lo_folder, la_AttachmentInfo)
                            
        ' Insert into EML_Address
        ls_To = InsertEmailAddress(ls_EML_Code, ls_To, emlEmailType.etEmailTo)
        ls_CC = InsertEmailAddress(ls_EML_Code, ls_CC, emlEmailType.etEmailCopyTo)
        ls_BCC = InsertEmailAddress(ls_EML_Code, ls_BCC, emlEmailType.etEmailBlindCopyTo)
        ls_From = InsertEmailAddress(ls_EML_Code, ls_From, emlEmailType.etEmailFrom)
          
        ' Insert into EML_Content
        Call InsertEmailContent(ll_EMC_Code, ls_EML_Code, ls_Message, ls_HTMLMessage, lb_IsHTML)
                                
        CommitTran ("EML_Mail")
        lb_InTransaction = False
        lb_AttachmentsCopied = False
                                          
        '24.4.2011 mw
        Call AddToLogEx("mo_Exchange.MoveMail(""Processed"")", "I")
        'If mo_Exchange.MoveMail(lo_Mail.MailItem, mo_MailBox(al_MailBoxIdx).Location, "Processed") = False Then
        If mo_Exchange.MoveMail(lo_Mail, "Processed") = False Then
            Call Err.Raise(CompFncFailed, "CheckMailBox", "Cannot move mail into processed folder for mailbox:" & mo_MailBox(al_MailBoxIdx).Location)
        End If
        Call AddToLogEx("mo_Exchange.MoveMail: returned TRUE", "I")
        
        lo_Mail.Unload_A_COM
        Set lo_Mail = Nothing
        
        'Raise OnReadMail Event
        Set lo_MailData = New MailData
        lo_MailData.EML_Code = ls_EML_Code
        lo_MailData.EAC_Code = mo_MailBox(al_MailBoxIdx).EAC_Code
        lo_MailData.EAC_Desc = mo_MailBox(al_MailBoxIdx).EAC_Desc
        lo_MailData.EML_Code = ls_EML_Code
        lo_MailData.EML_Body = ls_Message
        lo_MailData.EML_HTMLBody = ls_HTMLMessage
        lo_MailData.bIsHTML = lb_IsHTML
        lo_MailData.EML_Subject = ls_Subject
        lo_MailData.EML_Addresses_To = ls_To
        lo_MailData.EML_Addresses_Cc = ls_CC
        lo_MailData.EML_Addresses_From = ls_From
        lo_MailData.EML_Attachments = lo_folder
        
        RaiseEvent OnReadEmail(lo_MailData)
        Set lo_MailData = Nothing
        
    End If
    
    Exit Function
    
ErrHandler:
 
    Call UpdateError(True)
    
    CheckMailBox = False
    
    Set lo_MailData = Nothing
    
    If Not lo_Mail Is Nothing Then
        lo_Mail.Unload_A_COM
        Set lo_Mail = Nothing
    End If
        
    If lb_InTransaction = True Then
        Call RollbackTran("EML_Mail")
        lb_InTransaction = False
    End If
    
    ' delete attachments
    If lb_AttachmentsCopied = True Then
        Call DeleteAttachmentFile(mo_MailBox(al_MailBoxIdx).StorageInbox, la_AttachmentInfo)
    End If
                
    Call UpdateError(False)
    
    If Err.Number <> 0 Then
        ls_Operation = "Error during CheckMailBox: EAC_Code = " & mo_MailBox(al_MailBoxIdx).EAC_Code
        Call AddToLog(ls_Operation, "E")
    End If

    Call ErrorHandler(Extender.Name & ".CheckMailBox")

End Function

Private Sub InsertEmailContent(ByVal al_EMC_Code As Long, ByVal as_EML_Code As String, ByVal as_Message As String, ByVal as_HTMLMessage As String, ByVal ab_IsHtml As Boolean)
On Error GoTo ErrHandler

Const REQ_CONTENT_INS As String = "INSERT INTO EML_Content (EMC_Code,EML_Code,EML_Content,EML_HTMLContent) VALUES ($EMC_Code$,$EML_Code$, $EML_Content$, $EML_HTMLContent$)"

Dim ls_req              As String

    If as_Message <> "" Or as_HTMLMessage <> "" Then
        
        ls_req = Replace(REQ_CONTENT_INS, "$EMC_Code$", SqlDbl(al_EMC_Code), , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_Code$", as_EML_Code, , , vbTextCompare)
        ls_req = Replace(ls_req, "$EML_Content$", "N" & SQLStr(as_Message), , , vbTextCompare)
        
        If ab_IsHtml = True Then
            ls_req = Replace(ls_req, "$EML_HTMLContent$", "N" & SQLStr(as_HTMLMessage), , , vbTextCompare)
        Else
            ls_req = Replace(ls_req, "$EML_HTMLContent$", "Null", , , vbTextCompare)
        End If
        
        Call ExecuteSQLSafe(mo_Db, ls_req)
    End If
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InsertEmailContent")
End Sub

Private Function InsertAttachmentFile(ByVal as_EML_Code As String, ByVal as_StorageInbox As String, ByVal as_DirectoryInbox As String, ByRef ao_Folder As Object, ByRef aa_AttachmentInfo() As AttachmentInfo) As Boolean
On Error GoTo ErrHandler

Const REQ_ATT_DATA_INS As String = "INSERT INTO EML_Attachment (EAT_Code,EAT_Data) VALUES ($EAT_Code$,?)"

Dim ls_req              As String
Dim lo_File             As Object
Dim ll_Idx2             As Long
Dim ls_EAT_Code         As String

    InsertAttachmentFile = False
    
    If as_StorageInbox = EML_ATTSTORAGE_SQLDATABASE Or as_StorageInbox = EML_ATTSTORAGE_DIRECTORY Then
        ll_Idx2 = 0
        ReDim aa_AttachmentInfo(ao_Folder.Files.Count)
        For Each lo_File In ao_Folder.Files
        
            If as_StorageInbox = EML_ATTSTORAGE_SQLDATABASE Then
                    
                    ls_EAT_Code = mo_Db.SQLNextID("EML_Attachment")
                     
                    ls_req = Replace(REQ_ATT_DATA_INS, "$EAT_Code$", ls_EAT_Code, , , vbTextCompare)
        
                    If Not mo_Db.FileToBlobSQL(ls_req, lo_File.Path, 9) Then
                        Err.Raise ArmErr.SQLFailure, "FileToBlobSQL", "Error writing blob: " & ls_req & " File: " & lo_File.Path
                    End If
                    
                    aa_AttachmentInfo(ll_Idx2).EAT_Code = ls_EAT_Code
                  
            ElseIf as_StorageInbox = EML_ATTSTORAGE_DIRECTORY Then
                
                Call AddToLogEx("Standard loop:lo_File.Copy:" & as_DirectoryInbox & "\C" & as_EML_Code, "I")
                Call lo_File.Copy(as_DirectoryInbox & "\C" & as_EML_Code & "-" & ll_Idx2)
                aa_AttachmentInfo(ll_Idx2).FileName = as_DirectoryInbox & "\C" & as_EML_Code & "-" & ll_Idx2
            
            End If
            
            aa_AttachmentInfo(ll_Idx2).EAI_Code = mo_Db.SQLNextID("EML_AttachmentInfo")
           
            ll_Idx2 = ll_Idx2 + 1
        Next
        
        ' in case that there are any attachments and Storage=EML_ATTSTORAGE_DIRECTORY at this point they
        ' are copied already into final folder, this is made in advance because
        ' the rest of mail processing is in transaction and copying files could
        ' be a long lasting operation
        InsertAttachmentFile = True
        
    End If
    Exit Function
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InsertAttachmentFile")
End Function

Private Sub DeleteAttachmentFile(ByVal as_StorageInbox As String, ByRef aa_AttachmentInfo() As AttachmentInfo)
On Error GoTo ErrHandler
  
Dim ll_Idx2             As Long
Dim ls_req              As String

    If as_StorageInbox = EML_ATTSTORAGE_DIRECTORY Then
        For ll_Idx2 = 0 To UBound(aa_AttachmentInfo)
            If aa_AttachmentInfo(ll_Idx2).FileName <> "" Then
                Call mo_FSO.DeleteFile(aa_AttachmentInfo(ll_Idx2).FileName, True)
            End If
        Next
    ElseIf as_StorageInbox = EML_ATTSTORAGE_SQLDATABASE Then
        ls_req = "DELETE FROM EML_Attachment WHERE EAT_Code IN ("
        For ll_Idx2 = 0 To UBound(aa_AttachmentInfo)
            If aa_AttachmentInfo(ll_Idx2).EAT_Code <> "" Then
                ls_req = ls_req & aa_AttachmentInfo(ll_Idx2).EAT_Code
            End If
            If ll_Idx2 < UBound(aa_AttachmentInfo) Then
                ls_req = ls_req & ","
            End If
        Next
        ls_req = ls_req & ")"
        Call ExecuteSQLSafe(mo_Db, ls_req)
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".DeleteAttachmentFile")
End Sub

Private Sub InsertAttachmentInfo(ByVal as_EML_Code As String, ByVal as_StorageInbox As String, ByVal as_DirectoryInbox As String, ByRef ao_Folder As Object, ByRef aa_AttachmentInfo() As AttachmentInfo)
On Error GoTo ErrHandler

Const REQ_ATT_INFO_INS As String = "exec EML_AttachmentInfo_ins $EAI_Code$,$EAT_Code$,$EML_Code$,'$EAI_Storage$','$EAI_Directory$','$EAI_Name$','$EAI_StoredName$',$Z_Creator$"

Dim ls_req              As String
Dim lo_File             As Object
Dim ll_Idx2             As Long
Dim ls_EAT_Code         As String
Dim ls_EAI_StoredName   As String

    If as_StorageInbox = EML_ATTSTORAGE_SQLDATABASE Or as_StorageInbox = EML_ATTSTORAGE_DIRECTORY Then
        ll_Idx2 = 0
        For Each lo_File In ao_Folder.Files
                                                  
            If as_StorageInbox = EML_ATTSTORAGE_DIRECTORY Then
                ' store into directory
                ls_EAT_Code = "Null"
                ls_EAI_StoredName = "C" & as_EML_Code & "-" & ll_Idx2
            ElseIf as_StorageInbox = EML_ATTSTORAGE_SQLDATABASE Then
                ls_EAT_Code = aa_AttachmentInfo(ll_Idx2).EAT_Code
                ls_EAI_StoredName = ""
            End If
                
            ls_req = Replace(REQ_ATT_INFO_INS, "$EAI_Code$", aa_AttachmentInfo(ll_Idx2).EAI_Code, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EAT_Code$", ls_EAT_Code, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EML_Code$", as_EML_Code, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EAI_Storage$", as_StorageInbox, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EAI_Directory$", as_DirectoryInbox, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EAI_Name$", lo_File.Name, , , vbTextCompare)
            ls_req = Replace(ls_req, "$EAI_StoredName$", ls_EAI_StoredName, , , vbTextCompare)
            ls_req = Replace(ls_req, "$Z_Creator$", ml_U_Code, , , vbTextCompare)
                                        
            Call ExecuteSQLSafe(mo_Db, ls_req)
          
            ll_Idx2 = ll_Idx2 + 1
        Next
    End If
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".InsertAttachmentInfo")
End Sub

' do some extra check after template is created
Private Function InsertEmailAddress(ByVal as_code As String, ByVal as_EmailAddresses As String, ByVal ae_Type As emlEmailType) As String
Const INS_REQ As String = "exec EML_Address_ins $CODE$,'$TYPE$',$ORDER$,$ADDRESS$,$UCODE$,$CREATOR$"
Dim li_UCode As Integer
Dim ls_UCode As String
Dim lv_addressArray As Variant
Dim ls_Address As Variant
Dim ls_req As String
Dim li_Idx As Integer
Dim ls_EmailType As String
Dim ls_ArmstrongEmail As String
Dim ls_CorrectedEmailAddresses As String

On Error GoTo ErrHandler
    
    InsertEmailAddress = as_EmailAddresses
    ls_CorrectedEmailAddresses = ""
    
    as_EmailAddresses = Replace(as_EmailAddresses, ",", ";")
    lv_addressArray = Split(as_EmailAddresses, ";")
    
    li_Idx = 1
    
    For Each ls_Address In lv_addressArray
    
        ls_Address = Trim(ls_Address)
        If Left(ls_Address, 1) = "'" Then
            ls_Address = right(ls_Address, Len(ls_Address) - 1)
        End If
        If right(ls_Address, 1) = "'" Then
            ls_Address = Left(ls_Address, Len(ls_Address) - 1)
        End If
        
        If CheckNormalEmailFormat(ls_Address) = False Then
'            ls_Address = mo_Exchange.GetSMTPEmailAddressFromName(ls_Address)
        End If
        
        li_UCode = GetUCodeForAddress(ls_Address)
        If li_UCode > 0 Then
            ls_UCode = CStr(li_UCode)
        Else
            If CheckNormalEmailFormat(ls_Address) = False Then
                'mw 21.07.2009 - try to locate email by name and surname
                'this should work if we receive email address in Lotus Notes Format
                ls_ArmstrongEmail = ls_Address
                li_UCode = GetUCodeAndClassicEmailForAddress(ls_ArmstrongEmail)
                If li_UCode > 0 Then
                    ls_UCode = CStr(li_UCode)
                    ls_Address = ls_ArmstrongEmail
                Else
                    ls_UCode = "Null"
                End If
            
            Else
                ls_UCode = "Null"
            End If
        End If
        
        Select Case ae_Type
        Case emlEmailType.etEmailTo
            ls_EmailType = "T"
        Case emlEmailType.etEmailCopyTo
            ls_EmailType = "C"
        Case emlEmailType.etEmailBlindCopyTo
            ls_EmailType = "B"
        Case emlEmailType.etEmailFrom
            ls_EmailType = "F"
        End Select
        
        ls_req = Replace(INS_REQ, "$CODE$", as_code, , , vbTextCompare)
        ls_req = Replace(ls_req, "$TYPE$", ls_EmailType, , , vbTextCompare)
        ls_req = Replace(ls_req, "$ORDER$", li_Idx, , , vbTextCompare)
        ls_req = Replace(ls_req, "$ADDRESS$", SQLStr(ls_Address), , vbTextCompare)
        ls_req = Replace(ls_req, "$UCODE$", ls_UCode, , vbTextCompare)
        ls_req = Replace(ls_req, "$CREATOR$", ml_U_Code, , , vbTextCompare)
        
        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        
        If ls_CorrectedEmailAddresses = "" Then
            ls_CorrectedEmailAddresses = ls_Address
        Else
            ls_CorrectedEmailAddresses = ls_CorrectedEmailAddresses & "," & ls_Address
        End If
        
        li_Idx = li_Idx + 1
    Next
   
    InsertEmailAddress = ls_CorrectedEmailAddresses
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InsertEmailAddress")
End Function

Private Function CheckNormalEmailFormat(ByVal as_EmailCheck As String) As Boolean
On Error GoTo ErrHandler

Dim lb_CK As Boolean
Dim ls_DomainType As String
Const sInvalidChars As String = "!#$%^&*()=+{}[]|\;:'/?>,< "
Dim ll_Index As Long

    lb_CK = Not InStr(1, as_EmailCheck, Chr(34)) > 0 'Check to see if there is a double quote
    If Not lb_CK Then GoTo ExitFunction
    
    lb_CK = Not InStr(1, as_EmailCheck, "..") > 0 'Check to see if there are consecutive dots
    If Not lb_CK Then GoTo ExitFunction
    
    ' Check for invalid characters.
    If Len(as_EmailCheck) > Len(sInvalidChars) Then
        For ll_Index = 1 To Len(sInvalidChars)
            If InStr(as_EmailCheck, Mid(sInvalidChars, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    Else
        For ll_Index = 1 To Len(as_EmailCheck)
            If InStr(sInvalidChars, Mid(as_EmailCheck, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    End If
    
    If InStr(1, as_EmailCheck, "@") > 1 Then 'Check for an @ symbol
        lb_CK = Len(Left(as_EmailCheck, InStr(1, as_EmailCheck, "@") - 1)) > 0
    Else
        lb_CK = False
    End If
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "@"))
    lb_CK = Not InStr(1, as_EmailCheck, "@") > 0 'Check to see if there are too many @'s
    If Not lb_CK Then GoTo ExitFunction
    
    If InStr(1, as_EmailCheck, ".") = 0 Then
        lb_CK = False
        GoTo ExitFunction
    End If
    
    ls_DomainType = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "."))
    lb_CK = Len(ls_DomainType) > 0 And InStr(1, as_EmailCheck, ".") < Len(as_EmailCheck)
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - Len(ls_DomainType) - 1)
    Do Until InStr(1, as_EmailCheck, ".") <= 1
        If Len(as_EmailCheck) >= InStr(1, as_EmailCheck, ".") Then
            as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - (InStr(1, as_EmailCheck, ".") - 1))
        Else
            lb_CK = False
            GoTo ExitFunction
        End If
    Loop
    If as_EmailCheck = "." Or Len(as_EmailCheck) = 0 Then lb_CK = False
    
ExitFunction:
    CheckNormalEmailFormat = lb_CK
    Exit Function
    
ErrHandler:
    CheckNormalEmailFormat = False
    Call ErrorHandler("CheckNormalEmailFormat")
End Function

' Get email addresses for specific email message
Private Function GetEmailAddress(ByVal as_code As String, ByVal ae_Type As emlEmailType)
Const LST_REQ As String = "exec EML_EmailAddress_lst $CODE$,'$TYPE$'"
Dim ls_req As String
Dim li_Idx As Integer
Dim ll_Cursor As Long
Dim ls_EmailType As String

On Error GoTo ErrHandler
    GetEmailAddress = ""
    
    Select Case ae_Type
    Case emlEmailType.etEmailTo
        ls_EmailType = "T"
    Case emlEmailType.etEmailCopyTo
        ls_EmailType = "C"
    Case emlEmailType.etEmailBlindCopyTo
        ls_EmailType = "B"
    Case emlEmailType.etEmailFrom
        ls_EmailType = "F"
    End Select
    
    ls_req = Replace(LST_REQ, "$CODE$", as_code)
    ls_req = Replace(ls_req, "$TYPE$", ls_EmailType)
        
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    While Not mo_Db.EOF(ll_Cursor)
        GetEmailAddress = GetEmailAddress & mo_Db.GetFields(ll_Cursor, "EAD_Name")
        mo_Db.Next (ll_Cursor)
        If (Not mo_Db.EOF(ll_Cursor)) Then
            GetEmailAddress = GetEmailAddress & ","
        End If
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
   
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".GetEmailAddress")
End Function

' Get email addresses for specific email message
Private Function GetEmailBody(ByVal as_code As String, ByRef as_IsHTML As Boolean)
Const GET_REQ As String = "SELECT EML_Content,EML_HTMLContent,IsNULL(EML_HTMLContent,'NoHTML') as IsHTML FROM EML_Content WHERE EML_Code =$CODE$"
Dim ls_req As String
Dim li_Idx As Integer
Dim ll_Cursor As Long

On Error GoTo ErrHandler
    GetEmailBody = ""
    
    ls_req = Replace(GET_REQ, "$CODE$", as_code)
        
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        If mo_Db.GetFields(ll_Cursor, "IsHTML") = "NoHTML" Then
            GetEmailBody = mo_Db.GetFields(ll_Cursor, "EML_Content")
            as_IsHTML = False
        Else
            GetEmailBody = mo_Db.GetFields(ll_Cursor, "EML_HTMLContent")
            as_IsHTML = True
        End If
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
   
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".GetEmailBody")
End Function

' Try to find U_Code for an email address
Private Function GetUCodeAndClassicEmailForAddress(ByRef as_address As String) As Integer
Const GET_UCODE_REQ As String = "SELECT TOP 1 SU.U_Code,SU.U_Email_Armstrong FROM GEN_Systems_Users SU" _
          & " INNER JOIN GEN_People PE ON PE.P_Code = SU.P_Code" _
          & " WHERE PE.P_First_Name = $FIRST_NAME$ AND PE.P_Name=$LAST_NAME$"
          
Const GET_UCODE_REQ_2 As String = "SELECT TOP 1 SU.U_Code,SU.U_Email_Armstrong FROM GEN_Systems_Users SU" _
          & " INNER JOIN GEN_People PE ON PE.P_Code = SU.P_Code" _
          & " WHERE PE.P_First_Name = $FIRST_NAME$ AND PE.P_Name=$LAST_NAME$ AND PE.P_Middle_Initial=$MIDDLE_NAME$"
          
Dim ll_Cursor As Long
Dim ls_req As String
Dim ls_Address As String
Dim ll_Idx  As Long
Dim ll_Idx2 As Long
Dim ls_FirstName As String
Dim ls_LastName As String
Dim ls_MiddleName As String

On Error GoTo ErrHandler

    GetUCodeAndClassicEmailForAddress = 0
    
    ls_FirstName = ""
    ls_LastName = ""
    ls_MiddleName = ""
    ls_Address = Trim(as_address)
    
    ll_Idx = InStrRev(ls_Address, " ", , vbTextCompare)
    If ll_Idx > 0 Then
        ls_FirstName = Trim(Left(ls_Address, ll_Idx))
        
        ll_Idx2 = InStr(1, ls_FirstName, " ", vbTextCompare)
        If ll_Idx2 > 0 Then
            ls_MiddleName = Trim(right(ls_FirstName, Len(ls_FirstName) - ll_Idx2))
            ls_FirstName = Trim(Left(ls_FirstName, ll_Idx2))
        End If
        
        ls_LastName = Trim(right(ls_Address, Len(ls_Address) - ll_Idx))
    End If
        
    If ls_FirstName = "" Or ls_LastName = "" Then
        Exit Function
    End If
    
    If ls_MiddleName = "" Then
        ls_req = GET_UCODE_REQ
    Else
        ls_req = GET_UCODE_REQ_2
    End If

    ls_req = Replace(ls_req, "$FIRST_NAME$", SQLStr(Trim(ls_FirstName)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$LAST_NAME$", SQLStr(Trim(ls_LastName)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$MIDDLE_NAME$", SQLStr(Trim(ls_MiddleName)), , , vbTextCompare)

    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetUCodeAndClassicEmailForAddress = Val(mo_Db.GetFields(ll_Cursor, "U_Code"))
        as_address = mo_Db.GetFields(ll_Cursor, "U_Email_Armstrong")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
ErrHandler:

    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
        
    Call ErrorHandler(Extender.Name & ".GetUCodeAndClassicEmailForAddress")
End Function

' Try to find U_Code for an email address
Private Function GetUCodeForAddress(ByVal as_address As String) As Integer
Const GET_UCODE_REQ As String = "SELECT TOP 1 SU.U_Code FROM GEN_Systems_Users SU" _
          & " WHERE SU.U_Email_Armstrong=$EMAIL$ OR SU.U_email_others=$EMAIL$"
          
Dim ll_Cursor As Long
Dim ls_req As String
    
On Error GoTo ErrHandler
    GetUCodeForAddress = 0
    
    ls_req = Replace(GET_UCODE_REQ, "$EMAIL$", SQLStr(as_address), , , vbTextCompare)

    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetUCodeForAddress = Val(mo_Db.GetFields(ll_Cursor, "U_Code"))
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
        
    Call ErrorHandler(Extender.Name & ".GetUCodeForAddress")
End Function


' Extract email address from info received from Lotus Notes
Private Function ExtractEMailAddress(ByVal psAddress As String) As String
Dim i As Integer
On Error GoTo ErrHandler

    i = InStr(1, psAddress, "<")
    If i <> 0 Then
        psAddress = right(psAddress, Len(psAddress) - i)
    End If
    
    i = InStr(1, psAddress, ">")
    If i <> 0 Then
        psAddress = Left(psAddress, i - 1)
    End If
    
    ExtractEMailAddress = psAddress
        
    Exit Function
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExtractEMailAddress")
End Function

' Get Code of next email which is waiting to be sent
Private Function GetOutgoingEmails() As Long
On Error GoTo ErrHandler
   
Dim ll_Cursor As Long

    ' select all outgoing emails for all accounts
    ll_Cursor = OpenSQLSafe(mo_Db, "EXEC EML_GetOutgoingEmails_lst")
    If mo_Db.RowCount(ll_Cursor) <= 0 Then
        mo_Db.Close (ll_Cursor)
        ll_Cursor = 0
    End If
    
    GetOutgoingEmails = ll_Cursor
    Exit Function

ErrHandler:

    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    GetOutgoingEmails = 0
    Call ErrorHandler(Extender.Name & ".GetOutgoingEmails")

End Function

' Update Mail Status
Private Sub UpdateMailStatus(ByVal as_EML_Code As String, ByVal as_MailStatus As String)

Const UPD_REQ As String = "UPDATE EML_Mail SET EML_MailStatus=$EML_MailStatus$,EML_DateSent=$EML_DateSent$ WHERE EML_Code=$EML_Code$"

On Error GoTo ErrHandler
Dim ls_req       As String
Dim ls_DateSent  As String
    
    If as_MailStatus = EML_MAILSTATUS_PROCESSED Then
        ls_DateSent = SqlDate(Now)
    Else
        ls_DateSent = "Null"
    End If
        
    ls_req = Replace(UPD_REQ, "$EML_MailStatus$", SQLStr(as_MailStatus))
    ls_req = Replace(ls_req, "$EML_DateSent$", ls_DateSent)
    ls_req = Replace(ls_req, "$EML_Code$", as_EML_Code)
        
    Call ExecuteSQLSafe(mo_Db, ls_req)
    Exit Sub
   
ErrHandler:

    Call AddToLog("Unable to update the mail status to " & as_MailStatus & " for email:" & as_EML_Code, "E")   ' extra information log
    Call ErrorHandler(Extender.Name & ".UpdateMailStatus")
End Sub

Private Sub DefineSpam()
On Error GoTo ErrHandler
        
Dim sSQL        As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long     ' Recordset contenant le rsultat final

On Error GoTo ErrHandler
    
    sSQL = "EXEC A_Config_sel 'EML_SPAM'"
    ll_Cursor = OpenSQLSafe(mo_Db, sSQL)
    
    If Not mo_Db.EOF(ll_Cursor) Then
        mva_spamArray = Split(mo_Db.GetFields(ll_Cursor, "CFG_Value"), SEP)
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    If Not IsArray(mva_spamArray) Then
        mva_spamArray = Array()
    End If
    Exit Sub
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".DefineSpam")
End Sub

' use global variable mva_spamArray
Private Function GetStatusForNewMail(ByVal as_EAC_Code As String, ByVal as_Subject As String, ByVal as_fromAddress As String) As String
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mva_spamArray))
    Dim ls_spam As Variant
    Dim ls_retVal As String
    ls_retVal = EML_MAILSTATUS_NEW                     ' New

    For Each ls_spam In mva_spamArray
        If InStr(1, as_Subject, ls_spam) > 0 Then
            ls_retVal = EML_MAILSTATUS_SPAM            ' Spam
            Call AddToLogEx("Spam detected. Email Status set to Spam: " & as_fromAddress, "I")
            Exit For
        End If
    Next
    
    ' check if email is blacklisted
    If ls_retVal = EML_MAILSTATUS_NEW And IsEmailBlackListed(as_EAC_Code, as_fromAddress) = True Then
        ls_retVal = EML_MAILSTATUS_BLACKLISTED
        Call AddToLogEx("Email Status set to Blacklisted: " & as_fromAddress, "I")
    End If
    
    GetStatusForNewMail = ls_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetStatusForNewMail")
End Function

Private Function OutgoingEmailExist(ByVal ll_CursorOutMails As Long, ByVal al_Idx As Long)
Dim ll_Cursor As Long

On Error GoTo ErrHandler

    OutgoingEmailExist = False
    
    If ll_CursorOutMails > 0 Then
        ll_Cursor = mo_Db.Filter(ll_CursorOutMails, "EAC_Code", "=", mo_MailBox(al_Idx).EAC_Code)
        
        If mo_Db.RowCount(ll_Cursor) > 0 Then
            OutgoingEmailExist = True
        End If
        mo_Db.Close (ll_Cursor)
        ll_Cursor = 0
    End If
    
    Exit Function
ErrHandler:

    If ll_Cursor > 0 Then
        mo_Db.Close (ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".OutgoingEmailExist")
End Function

Private Function ScanInBox(ByVal al_Idx As Long) As Boolean
On Error GoTo ErrHandler

Dim ll_MailBoxInfoIndex As Long
Dim ll_Idx              As Long
Dim ll_NbMsg            As Long      ' Number of new emails in this mailbox
Dim ll_CheckedIdx       As Long
Dim ls_Operation        As String
Dim lb_Result           As Boolean
Dim le_Result           As emlSendEmailStatus
Dim lo_Mail             As ArmGraphMail
Dim lo_inbox            As ArmGraphMailbox

    ll_MailBoxInfoIndex = GetMailBoxInfoIndex(al_Idx)

    If mo_MailBox(al_Idx).ScanEnabled = "X" And DateDiff("n", GetLastCheck(al_Idx), Now) > mo_MailBox(al_Idx).CheckInterval Then
        ' Proccess incoming emails
        lbl_Task = "Actual task: Scanning Inbox for " & mo_MailBox(al_Idx).Location
        
        ' Check active mailbox
        ' Get the count of items
        Call AddToLogEx("mo_Exchange.GetMailCount:" & mo_MailBox(al_Idx).Location, "I")
'        ll_NbMsg = mo_Exchange.GetMailCount(mo_MailBox(al_Idx).Location)
        ll_NbMsg = mo_Exchange.GetMailCount()
        Call AddToLogEx("mo_Exchange.GetMailCount returned:" & ll_NbMsg, "I")
        
        ll_CheckedIdx = 0
        Set lo_inbox = mo_Exchange.GetMailboxFolder("Inbox")
        
        For ll_Idx = 0 To ll_NbMsg - 1
        
            On Error Resume Next
            Set lo_Mail = lo_inbox.GetMail(ll_Idx)
            'lb_Result = CheckMailBox(al_Idx, ll_CheckedIdx)
            lb_Result = CheckMailBox(al_Idx, lo_Mail)
            
            On Error GoTo ErrHandler
            
            If lb_Result = True Then
                              
                  mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsReceivedOk = mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsReceivedOk + 1
            Else
                  mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsReceivedErr = mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsReceivedErr + 1
                  
                  'if email is still in inbox, try to read next one
                  ll_CheckedIdx = ll_CheckedIdx + 1
            End If
            
        Next ll_Idx
            
        mo_MailBoxInfo(ll_MailBoxInfoIndex).LastInboxCheck = Now
        mo_MailBoxInfo(ll_MailBoxInfoIndex).InboxChecks = mo_MailBoxInfo(ll_MailBoxInfoIndex).InboxChecks + 1
    End If
    
    ScanInBox = True
    Exit Function
    
ErrHandler:
    ScanInBox = False
    
    ls_Operation = "Error during ScanInBox for Account EAC_Code=:" & mo_MailBox(al_Idx).EAC_Code
    Call AddToLog(ls_Operation, "E")
    
    Call ErrorHandler(Extender.Name & ".ScanInBox")
End Function

Private Function ScanOutBox(ByVal al_Idx As Long, ByVal ll_CursorOutMails As Long) As Boolean
On Error GoTo ErrHandler

Dim ll_CursorOutMailBox As Long
Dim ll_MailBoxInfoIndex As Long
Dim ll_Idx              As Long
Dim ll_NbMsg            As Long      ' Number of new emails in this mailbox
Dim ll_CheckedIdx  As Long
Dim ls_Operation        As String
Dim lb_Result           As Boolean
Dim le_Result           As emlSendEmailStatus

    ll_MailBoxInfoIndex = GetMailBoxInfoIndex(al_Idx)
  
    ' Process outgoing emails
    lbl_Task = "Actual task: Scanning SQL Server"
        
    ll_CursorOutMailBox = mo_Db.Filter(ll_CursorOutMails, "EAC_Code", "=", mo_MailBox(al_Idx).EAC_Code)
    
    mo_Db.First (ll_CursorOutMailBox)
    
    While Not mo_Db.EOF(ll_CursorOutMailBox)
        DoEvents
        
        On Error Resume Next
        le_Result = OutgoingEmailProcessing(al_Idx, ll_CursorOutMailBox, mo_Db.Position(ll_CursorOutMailBox))
        On Error GoTo ErrHandler
        
        If le_Result = emlSendEmailStatus.sesOK Then
            Call UpdateMailStatus(mo_Db.GetFields(ll_CursorOutMailBox, "EML_Code"), EML_MAILSTATUS_PROCESSED)
            mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentOk = mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentOk + 1
        ElseIf le_Result = emlSendEmailStatus.sesFailed Then
            Call UpdateMailStatus(mo_Db.GetFields(ll_CursorOutMailBox, "EML_Code"), EML_MAILSTATUS_FAILED)
            mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentErr = mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentErr + 1
        Else
            Call UpdateMailStatus(mo_Db.GetFields(ll_CursorOutMailBox, "EML_Code"), EML_MAILSTATUS_INVALID)
            mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentErr = mo_MailBoxInfo(ll_MailBoxInfoIndex).EmailsSentErr + 1
        End If
        
        Call mo_Db.Next(ll_CursorOutMailBox)
    Wend
    
    mo_Db.Close (ll_CursorOutMailBox)

    mo_MailBoxInfo(ll_MailBoxInfoIndex).LastOutboxCheck = Now
    mo_MailBoxInfo(ll_MailBoxInfoIndex).OutboxChecks = mo_MailBoxInfo(ll_MailBoxInfoIndex).OutboxChecks + 1
    
    ScanOutBox = True
    Exit Function
    
ErrHandler:
    ScanOutBox = False
    
    ls_Operation = "Error during ScanOutBox for Account EAC_Code=:" & mo_MailBox(al_Idx).EAC_Code
    Call AddToLog(ls_Operation, "E")
    
    Call ErrorHandler(Extender.Name & ".ScanOutBox")
End Function

Private Function GetMailBoxInfoIndex(ByVal al_MailBoxIdx As Long) As Integer
On Error GoTo ErrHandler

Dim ll_MailBoxArrayNewSize  As Long
Dim ll_Idx                  As Long

    If UBound(mo_MailBoxInfo) <> -1 Then
        ll_Idx = 0
        While ll_Idx < UBound(mo_MailBoxInfo)
            If mo_MailBoxInfo(ll_Idx).EAC_Code = mo_MailBox(al_MailBoxIdx).EAC_Code Then
                GetMailBoxInfoIndex = ll_Idx
                Exit Function
            End If
            ll_Idx = ll_Idx + 1
        Wend
        ll_MailBoxArrayNewSize = UBound(mo_MailBoxInfo) + 1
    Else
        ReDim mo_MailBoxInfo(1)
        ll_MailBoxArrayNewSize = 1
    End If
    
    'the MailBoxInfo for this MailBox does not exist
    
    ReDim Preserve mo_MailBoxInfo(ll_MailBoxArrayNewSize)
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).EAC_Code = mo_MailBox(al_MailBoxIdx).EAC_Code
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).LastInboxCheck = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).LastOutboxCheck = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).EmailsReceivedErr = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).EmailsReceivedOk = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).EmailsSentErr = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).EmailsSentOk = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).InboxChecks = 0
    mo_MailBoxInfo(ll_MailBoxArrayNewSize - 1).OutboxChecks = 0
    
    GetMailBoxInfoIndex = ll_MailBoxArrayNewSize - 1
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetMailBoxInfoIndex")
End Function

Private Function GetLastCheck(ByVal al_MailBoxIdx As Long) As Date
On Error GoTo ErrHandler

Dim ll_Idx As Long

    If UBound(mo_MailBoxInfo) <> -1 Then
        ll_Idx = 0
        While ll_Idx < UBound(mo_MailBoxInfo)
            If mo_MailBoxInfo(ll_Idx).EAC_Code = mo_MailBox(al_MailBoxIdx).EAC_Code Then
                GetLastCheck = mo_MailBoxInfo(ll_Idx).LastInboxCheck
                Exit Function
            End If
            ll_Idx = ll_Idx + 1
        Wend
    End If
    
    'this MailBox is processed first time
    GetLastCheck = 0
    Exit Function
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetLastCheck")
End Function


' **************************** FRAMEWORK FUNCTIONS ***********************************


' ************************************************************************************
' ************************** EVENT HANDLER FUNCTIONS *********************************
' ************************************************************************************

Private Sub Cmd_Reload_Click()
On Error GoTo ErrHandler

    ' Load MailBox info to Check
    DefineMailBoxes
    Call AddToLogEx("Mail boxes loaded" & vbCrLf, "I")
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Cmd_Reload_Click")
End Sub

Private Sub cmdClose_Click()
    RaiseEvent quit
End Sub

Private Sub cmd_Pause_Click()
On Error GoTo ErrHandler

    mb_Active = False
    cmd_Pause.Enabled = False
    cmd_Play.Enabled = True

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Pause_Click")
End Sub

Private Sub cmd_Play_Click()
On Error GoTo ErrHandler

    mb_Active = True
    cmd_Pause.Enabled = True
    cmd_Play.Enabled = False

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Play_Click")
End Sub

Private Sub HeartBeatTimer_Timer()
On Error GoTo ErrHandler
    If CheckConnection(mo_Db) = True Then
        Call mo_HeartBeat.HeartBeatHit(mo_Db, C_PROCESSNAME)
    End If
    Exit Sub
ErrHandler:
    Call AddToLog("Error during HeartBeatTimer event.", "E")
End Sub

'Check and process incoming and outgoing emails
Public Sub ProcessMails(ByVal ad_nextTimer As Double)

On Error GoTo ErrHandler

Dim ls_EML_Code          As String   ' EML_Code of email to send
Dim ls_EAC_Code          As String   ' EAC_Code of email to send
Dim ls_Subject           As String   ' Subject of Email
Dim ll_Idx                  As Long
Dim ll_CursorOutMails       As Long
Dim ls_Operation As String
Dim lo_MailData         As MailData

    'check if this user control is active or paused
    If mb_Active = False Then
        Exit Sub
    End If
    
    cmdClose.Enabled = False
    Cmd_Reload.Enabled = False
    
    ll_Idx = 0
    
    'get all outgoing emails to process
    ll_CursorOutMails = GetOutgoingEmails()
    
    While ll_Idx < mi_MailBoxCount
        
        DoEvents
        
        If (mo_MailBox(ll_Idx).ScanEnabled = "X" And (DateDiff("n", GetLastCheck(ll_Idx), Now) > mo_MailBox(ll_Idx).CheckInterval Or _
            OutgoingEmailExist(ll_CursorOutMails, ll_Idx) = True)) Then
            
            ' Check if Mailbox is available
            Call AddToLogEx("mo_Exchange.OpenDatabase:" & mo_MailBox(ll_Idx).EMailAddress, "I")
             'If Not mo_Exchange.OpenDatabase(mo_MailBox(ll_Idx).Location, mo_MailBox(ll_Idx).MailFile, mo_MailBox(ll_Idx).Password) Then
             If Not mo_Exchange.OpenDatabase(mo_MailBox(ll_Idx).Location, mo_MailBox(ll_Idx).Password) Then
                'error during open database.
                ls_Operation = "Error during OpenDatabase. Check if mailbox has Inbox, Outbox and Processed folders: " & mo_MailBox(ll_Idx).Location
                Call AddToLog(ls_Operation, "E")
            Else
                Call AddToLogEx("mo_Exchange.OpenDatabase:returned TRUE", "I")
                
                On Error Resume Next
                Call ScanInBox(ll_Idx)
                Call ScanOutBox(ll_Idx, ll_CursorOutMails)
                On Error GoTo ErrHandler
                                                                                             
                Call AddToLogEx("mo_Exchange.CloseDatabase", "I")
                mo_Exchange.CloseDatabase
                Call AddToLogEx("mo_Exchange.CloseDatabase: OK", "I")

            End If
        End If
        
        ll_Idx = ll_Idx + 1

    Wend

    If ll_CursorOutMails > 0 Then
        mo_Db.Close (ll_CursorOutMails)
        ll_CursorOutMails = 0
    End If
    
    Call UpdateStats
    
    Cmd_Reload.Enabled = True
    cmdClose.Enabled = True
    
    lbl_Task = "Actual task: Waiting for next timer event at " & Format(ad_nextTimer, "hh:mm:ss") & "."

    Exit Sub
    
ErrHandler:

    UpdateError (True)
    
    If HeartBeatTimer.Enabled = False Then
        HeartBeatTimer.Enabled = True
    End If
        
    cmdClose.Enabled = True
    Cmd_Reload.Enabled = True
    
    If ll_CursorOutMails > 0 Then
        mo_Db.Close (ll_CursorOutMails)
        ll_CursorOutMails = 0
    End If
    
    UpdateError (False)
    
    ls_Operation = "Error during ProcessMails."
    Call AddToLog(ls_Operation, "E")

End Sub


' ************************** EVENT HANDLER FUNCTIONS *********************************
Private Sub mo_Exchange_ArmGraphError(ll_errNr As Long, ls_ErrSource As String, ls_ErrDesc As String, ls_fnc As String)
    Call AddToLog(ls_fnc & ": Error " & ll_errNr & "," & ls_ErrSource & "," & ls_ErrDesc, IIf(ll_errNr = ArmGraphError.InformationalError, "I", "E"))
End Sub
