VERSION 5.00
Begin VB.UserControl mailObserver 
   ClientHeight    =   7620
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   11130
   ScaleHeight     =   7620
   ScaleWidth      =   11130
   Begin VB.CommandButton cmd_RestartPlugins 
      Caption         =   "Restart Plugins"
      Height          =   375
      Left            =   7920
      TabIndex        =   1
      Top             =   3120
      Width           =   3135
   End
   Begin VB.Timer tmr_Check 
      Interval        =   10000
      Left            =   9480
      Top             =   120
   End
   Begin Project1.mailProcessor usc_mailProcessor 
      Height          =   6495
      Left            =   0
      TabIndex        =   0
      Top             =   3480
      Width           =   11055
      _ExtentX        =   19500
      _ExtentY        =   11456
   End
   Begin Project1.ArmGrid grd_log 
      Height          =   2895
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   10935
      _ExtentX        =   19288
      _ExtentY        =   5106
   End
End
Attribute VB_Name = "mailObserver"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2

Private Const C_MODULE_NAME As String = "MailObserver"      ' module name used in log table
Private Const SCREEN_NAME As String = "MailObserver"
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MAXROWS As Long = 1000               ' max 1000 rows in grid


#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Public TenantID                         As String
Public AppID                            As String

Private ms_Server                       As String
Private ms_Database                     As String
Private ms_Pass                         As String
Private ms_User                         As String
Private mb_Initialized                  As Boolean  ' Initialized user control flag
Private ml_U_Code                       As Long     ' User code

Private mo_Tools As DPC_Tools

' **************************************************************************************************
' *********************************** PUBLIC CONTROL EVENTS ****************************************
' **************************************************************************************************
Public Event quit()
' *********************************** PUBLIC CONTROL EVENTS ****************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Private Enum ArmSysType
  DBTYPE_EMPTY = 0
  DBTYPE_I4 = 3
  DBTYPE_R4 = 4
  DBTYPE_R8 = 5
  DBTYPE_DATE = 7
  DBTYPE_BSTR = 8 '- UNICODE string
  DBTYPE_BOOL = 11
  DBTYPE_STR = 129
  DBTYPE_BMP = 999
End Enum
' *************************************** USER DEFINED ERRORS **************************************


' **************************************************************************************************
' ********************************* EVENTS CONSUMERS **************************************
' **************************************************************************************************

Public WithEvents mo_SPA_Plugin As SPA_Plugin
Attribute mo_SPA_Plugin.VB_VarHelpID = -1
Public WithEvents mo_TMT_Plugin As TMT_Plugin 'mmmm
Attribute mo_TMT_Plugin.VB_VarHelpID = -1
Public WithEvents mo_DPC_Plugin As DPC_Plugin
Attribute mo_DPC_Plugin.VB_VarHelpID = -1

Private Sub cmd_RestartPlugins_Click()
    On Error GoTo ErrHandler
        
    If tmr_Check.Enabled = False Then
        Call AddToLog("Cannot restart Plugins, Mails are currently processing, try again later.", C_MODULE_NAME, "I")
        Exit Sub
    End If
        
    tmr_Check.Enabled = False
    
    LockScreen (True)
    
    If Not mo_SPA_Plugin Is Nothing Then
        mo_SPA_Plugin.Init
        Call AddToLog("SPA Plugin restarted sucessfully.", C_MODULE_NAME, "I")
    End If
    
    'mmmm
    If Not mo_TMT_Plugin Is Nothing Then
        mo_TMT_Plugin.Init
        Call AddToLog("TMT Plugin restarted sucessfully.", C_MODULE_NAME, "I")
    End If
    
    If Not mo_DPC_Plugin Is Nothing Then
        mo_DPC_Plugin.Init
        Call AddToLog("DPC Plugin restarted sucessfully.", C_MODULE_NAME, "I")
    End If
    
    tmr_Check.Enabled = True
    
    LockScreen (False)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_RestartPlugins_Click")
End Sub

Private Sub mo_SPA_Plugin_OnAddToLog(ByRef as_msg As String, ByRef as_Type As String)
On Error GoTo ErrHandler

    Call AddToLog(as_msg, "SPA_Plugin", as_Type)
    
    Exit Sub
ErrHandler:
    Call LogMessage("Error in mo_SPA_Approval_OnAddToLog Event!", "E")
End Sub

'mmmm
Private Sub mo_TMT_Plugin_OnAddToLog(as_msg As String, as_Type As String)
On Error GoTo ErrHandler

    Call AddToLog(as_msg, "TMT_Plugin", as_Type)

    Exit Sub
ErrHandler:
    Call LogMessage("Error in mo_TMT_OnAddToLog Event!", "E")
End Sub

Private Sub mo_DPC_Plugin_OnAddToLog(as_msg As String, as_Type As String)
On Error GoTo ErrHandler

    Call AddToLog(as_msg, "DPC_Plugin", as_Type)

    Exit Sub
ErrHandler:
    Call LogMessage("Error in mo_DPC_OnAddToLog Event!", "E")
End Sub

Private Sub usc_mailProcessor_OnReadEmail(ByRef ao_EmailData As MailData)
On Error GoTo ErrHandler
    
    If ao_EmailData.EAC_Desc = "SPA Approval" Then
        Call mo_SPA_Plugin.ProcessOnReadMail(ao_EmailData)
    End If
           
    Exit Sub
ErrHandler:
    Call LogMessage("Error in OnReadEmail Event!", "E")
End Sub

Private Sub usc_mailProcessor_OnSendEmail(ao_EmailData As MailData)
On Error GoTo ErrHandler
    
    Call mo_SPA_Plugin.ProcessOnSendMail(ao_EmailData)
    
    Exit Sub
ErrHandler:
    Call LogMessage("Error in OnSendEmail Event!", "E")
End Sub


Private Sub usc_mailProcessor_OnAddToLog(ByRef as_msg As String, ByRef as_Type As String)
On Error GoTo ErrHandler
    
    Call AddToLog(as_msg, "MailProcessor", as_Type)
    Exit Sub
ErrHandler:
    Call LogMessage("Error in usc_mailProcessor_OnAddToLog Event!", "E")
End Sub

Private Sub usc_mailProcessor_quit()
    tmr_Check.Enabled = False
    RaiseEvent quit
End Sub



' ********************************* EVENTS CONSUMERS **************************************

Private Sub tmr_Check_Timer()
On Error GoTo ErrHandler

Dim ls_Operation As String

    If mb_Initialized = False Then
    tmr_Check.Enabled = False
        Exit Sub
    End If

    tmr_Check.Enabled = False

    'process incomming and outgoing emails
    If (usc_mailProcessor.CheckConnection(mo_Db) = True) Then
    
        Call usc_mailProcessor.ProcessMails(Now() + tmr_Check.Interval / 86400000)
    
        'process plugins (remainders)
        Call mo_SPA_Plugin.ProcessTasks
    
        'mmmmm
'        Call mo_TMT_Plugin.ProcessTasks
        
        
'        Call mo_DPC_Plugin.ProcessTasks
        
    End If
    
    tmr_Check.Enabled = True
    Exit Sub
    
ErrHandler:
    Call LogMessage("Error during timer event:", "E")
    tmr_Check.Enabled = True
End Sub


' **************************************************************************************************
' ********************************* PUBLIC CONTROL PROPERTIES **************************************
' **************************************************************************************************
' database controler property
' Params:
' ao_db (ARMSYSCOMLib.ArmDb) - ArmSysCom instance
#If LIVE Then
Public Property Set Db(ByRef ao_Db As Object)
#Else
Public Property Set Db(ByRef ao_Db As ARMSYSCOMLib.ArmDb)
#End If

On Error GoTo ErrHandler
    If Not mo_Db Is Nothing Then Err.Raise ArmErr.CPTAlreadyInitialized
    If ao_Db Is Nothing Then Err.Raise ArmErr.InvalidArgument
    
    Set mo_Db = ao_Db
    
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

' User code used in logs
Public Property Let U_Code(ByVal al_UserCode As Long)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ml_U_Code = al_UserCode
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

' User code used in logs
Public Property Let Server(ByVal as_Server As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Server = as_Server
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Server(Let)")
End Property

' User code used in logs
Public Property Let Database(ByVal as_Database As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Database = as_Database
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Database(Let)")
End Property

Public Property Let Pass(ByVal as_Pass As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_Pass = as_Pass
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Pass(Let)")
End Property

Public Property Let User(ByVal as_User As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_User = as_User
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".User(Let)")
End Property
' ********************************* PUBLIC CONTROL PROPERTIES **************************************


' **************************************************************************************************
' ******************************* PUBLIC USER CONTROL METHODS **************************************
' **************************************************************************************************
' initialize user control
Public Function Load_A_COM()
On Error GoTo ErrHandler

Dim la_AccListApproval() As String
#If LIVE = 1 Then
    Dim lo_Db As Object
#Else
    Dim lo_Db As ARMSYSCOMLib.ArmDb
#End If
    
    Load_A_COM = False
    
    If mb_Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized
    
    Set mo_Tools = New DPC_Tools
    Set mo_Tools.ArmDb = mo_Db
    Call mo_Tools.Load_A_COM
  
    ' Define log grid
    Call grd_log.Load_A_COM
    grd_log.UnBound = True
    grd_log.AllowExcelExport = True
    
    Call grd_log.SetColumns(Array( _
      Join(Array("LOG_TIME", 1500, 1, "LOG_TIME", "Time"), SEP) _
    , Join(Array("LOG_SRC", 1500, 0, "LOG_SRC", "Source"), SEP) _
    , Join(Array("LOG_TYPE", 700, 0, "LOG_TYPE", "Type", "String", "", "Center"), SEP) _
    , Join(Array("LOG_MSG", 6800, 0, "LOG_MSG", "Message", "String", "", "Left"), SEP) _
    ))

    grd_log.Rows = 0
    grd_log.Title = "Log"
    
    
    'init MailProcessor
    Set usc_mailProcessor.Db = mo_Db
    usc_mailProcessor.Language_Code = "E"
    usc_mailProcessor.U_Code = ml_U_Code
    usc_mailProcessor.LoginName = "EXPLOIT"
    usc_mailProcessor.LogEx = GetLogEx(Command)  '0 - no debug info, 1 show debug info, 2 log debug info
    usc_mailProcessor.Database = ms_Database
    usc_mailProcessor.Server = ms_Server
    usc_mailProcessor.Pass = ms_Pass
    usc_mailProcessor.User = ms_User
    usc_mailProcessor.DefaultCharset = "iso-8859-1"
    usc_mailProcessor.TenantID = TenantID
    usc_mailProcessor.AppID = AppID
    Call usc_mailProcessor.Load_A_COM

    ' init SPA_Approval plugin >>
       
    Set mo_SPA_Plugin = New SPA_Plugin
    ' Create the connection for SPA Plugin
    #If LIVE = 1 Then
        Set lo_Db = CreateObject("ArmSysCOM.ArmDb")
    #Else
        Set lo_Db = New ARMSYSCOMLib.ArmDb
    #End If
    
    #If LIVE = 1 Then
        If Not lo_Db.Connect(ms_Server, ms_Database, ms_User, ms_Pass, "SPA_Plugin") Then
            Call MsgBox("SPA Plugin cannot connect to database. Server is not responding, try again later")
            Debug.Assert (False)
            End
        End If
    #Else
            If Not lo_Db.Connect(ms_Server, ms_Database, ms_User, ms_Pass, "SPA_Plugin") Then
                Call MsgBox("SPA Plugin cannot connect to database. Server is not responding, try again later")
                Debug.Assert (False)
                End
            End If
    #End If

    Set mo_SPA_Plugin.Db = lo_Db
    mo_SPA_Plugin.U_Code = ml_U_Code
    mo_SPA_Plugin.Language_Code = "E"
    ReDim la_AccListApproval(1)
    la_AccListApproval(0) = "SPA Approval"
    mo_SPA_Plugin.AccountsList = la_AccListApproval
    
    If mo_SPA_Plugin.Load_A_COM = True Then
        mo_SPA_Plugin.Init
    Else
        Call lo_Db.Disconnect
    End If
    ' init SPA_Approval plugin <<
    
    'mmmm
    Set mo_TMT_Plugin = New TMT_Plugin
    Set mo_TMT_Plugin.Db = lo_Db
    mo_TMT_Plugin.U_Code = ml_U_Code
    mo_TMT_Plugin.Language_Code = "E"
    
    If mo_TMT_Plugin.Load_A_COM = True Then
        mo_TMT_Plugin.Init
    End If
    'mmmm

    'init DPC_Plugin
    Set mo_DPC_Plugin = New DPC_Plugin
    Set mo_DPC_Plugin.Db = lo_Db
    mo_DPC_Plugin.U_Code = ml_U_Code
    mo_DPC_Plugin.Language_Code = "E"
    Set mo_DPC_Plugin.Tools = mo_Tools
    
    If mo_DPC_Plugin.Load_A_COM = True Then
        mo_DPC_Plugin.Init
    End If

    Call AddToLog("MailObserver: Loaded", C_MODULE_NAME, "I")
    
    ' Main Timer settings
    tmr_Check.Interval = Get_A_Config("ABPE_Timer_Interval")  ' in miliseconds
    tmr_Check.Enabled = True    ' start timer
    
    mb_Initialized = True

    Load_A_COM = True
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Load_A_Com")
End Function

' uninitialize user control
Public Sub Unload_A_COM()
On Error GoTo ErrHandler
    
    'Unload Mail Processor
    Call usc_mailProcessor.Unload_A_COM
       
    'Unload Plugins
    Call mo_SPA_Plugin.Unload_A_COM
    Set mo_SPA_Plugin = Nothing
    
    'TMT_Plugin
    Call mo_TMT_Plugin.Unload_A_COM
    Set mo_TMT_Plugin = Nothing
    
    'DPC_Plugin
    Call mo_DPC_Plugin.Unload_A_COM
    Set mo_DPC_Plugin = Nothing
    
    'Unload grd_log
    Call grd_log.Unload_A_COM
    
    'Other
    Set mo_Db = Nothing
    tmr_Check.Enabled = False    ' stop timer
    
    mb_Initialized = False

    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".Unload_A_COM")
End Sub

'JN 20.1.2012
Private Function GetLogEx(ByVal as_command As String) As Long
    Dim ll_i As Long
    GetLogEx = 0                ' default = 0
    Dim lsa_cmd() As String
    lsa_cmd = Split(as_command, " ")
    For ll_i = LBound(lsa_cmd) To UBound(lsa_cmd)
        Select Case UCase(lsa_cmd(ll_i))
            Case "LOGEX:1"
                GetLogEx = 1
            Case "LOGEX:2"
                GetLogEx = 2
        End Select
    Next
End Function
' ******************************* PUBLIC USER CONTROL METHODS **************************************

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, , "Error message: " & as_Fct)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_ErrDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_ErrDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_ErrDescription & " - " & ls_ErrSource
    
    Call AddToLog(ls_Msg, C_MODULE_NAME, as_logType)
    
    ls_req = Replace(LOG_REQUEST, "$UCODE$", CStr(ml_U_Code), , , vbTextCompare)
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), , , vbTextCompare)
    ls_req = Replace(ls_req, "$MSG$", SQLStr(Left(Trim(ls_Msg), 4000)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$APP$", SQLStr(Left(Trim(ls_Source), 50)), , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be closed. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub


' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support")
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support")
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    If mo_Db.LastErrorCode <> 3903 Then
        mo_Db.Disconnect
        Set mo_Db = Nothing
        Call LogMessage("A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support")
        End
    Else
        Err.Number = ll_errNumber
        Err.Source = ls_ErrSrc
        Err.Description = ls_ErrDesc
    
        RollbackTran = True
    
    End If
End Function

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

Private Function Get_A_Config(ByVal as_Key As String) As String
On Error GoTo ErrHandler

Dim ll_Curs As Long
Dim ls_req  As String

    Get_A_Config = ""
    ls_req = "select cfg_value from A_config where cfg_Key ='" & UCase(as_Key) & "'"
    
    ll_Curs = mo_Db.OpenSQL(ls_req)
    
        If ll_Curs = 0 Then
            Call AddToLog("Error executing " & ls_req & mo_Db.LastErrorCode & "  " & mo_Db.LastErrorMessage, "E")
            Exit Function
        Else
            If mo_Db.RowCount(ll_Curs) <> 1 Then
                mo_Db.Close (ll_Curs)
                Call AddToLog("Executing " & ls_req & " returned " & mo_Db.RowCount(ll_Curs) & " record(s) while one was expected", "E")
                Call ErrorHandler(C_MODULE_NAME & ".Get_A_Config")
                Exit Function
            Else
                Get_A_Config = mo_Db.GetFields(ll_Curs, 0)
                mo_Db.Close (ll_Curs)
            End If
        End If
    Exit Function
ErrHandler:
    Call AddToLog("Error in Get_A_Config! Key: " & as_Key, "E")
    Call ErrorHandler(C_MODULE_NAME & ".Get_A_Config")
End Function

Public Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 0, Optional ByVal ab_LogError As Boolean = True) As String
On Error GoTo ErrHandler
    
    If as_str = "NULL" Then
        SQLStr = "NULL"
    Else
        If al_MaxLen > 0 Then
            as_str = Trim(as_str)
            If Len(as_str) > al_MaxLen Then
                If ab_LogError Then
                    Call LogMessage("Value trimmed (" & al_MaxLen & ") '" & as_str & "' to '" & Left(as_str, al_MaxLen) & "'")
                End If
                as_str = Left(as_str, al_MaxLen)
            End If
        End If
        SQLStr = "'" & Replace(as_str, "'", "''") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SQLStr as_Str=" & as_str)
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function

' **************************** DB-ACCESS FUNCTIONS ***********************************

' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************

' Log information
Private Sub AddToLog(ByVal as_Operation As String, ByVal as_Src As String, Optional as_Type As String = "E")
Dim ll_errNumber As Long
Dim ls_ErrDescription As String, ls_ErrSource As String
Dim ls_Msg As String

ll_errNumber = Err.Number
ls_ErrDescription = Err.Description
ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Dim lv_Key As Variant
   
    Debug.Assert (grd_log.Cols > 0)
    Dim lsa_newRow() As String
    ReDim lsa_newRow(0 To grd_log.Cols - 1)
    
    Call grd_log.DeselectRow
   
    If grd_log.Rows > C_MAXROWS - 1 Then
        grd_log.FirstLine
        grd_log.DeleteLine
        grd_log.LastLine
    End If
    
    lsa_newRow(0) = Format(Now, "yyyy-mm-dd hh:mm")
    lsa_newRow(1) = as_Src
    lsa_newRow(2) = as_Type
    lsa_newRow(3) = as_Operation
    grd_log.AddLine (lsa_newRow)
    
    If (as_Type = "E") Then
        grd_log.LineColor(grd_log.Row) = vbRed
    End If
        
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    
    Exit Sub
ErrHandler:
    lsa_newRow(0) = Format(Now, "yyyy-mm-dd hh:mm")
    lsa_newRow(1) = "MailObserver"
    lsa_newRow(2) = "E"
    lsa_newRow(3) = "Unable to write into log. Err(" & Err.Number & "-" & Err.Description
    grd_log.AddLine (lsa_newRow)
    grd_log.LineColor(grd_log.Row) = vbRed
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub

' **************************** FRAMEWORK FUNCTIONS ***********************************

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub


