VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ArmGraphMail"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public URL As String
Public Id As String
Public AddrFrom As String
Private AddrTo() As String
Private AddrCc() As String
Private AddrBcc() As String
Public Subject As String
Public Body As Variant
Public HTMLCharset As String
Public HTMLBody As Variant
Public Attachments As Collection
Public IsReaded As Boolean
Public IsReportItem As Boolean

Public Sub Load_A_COM()
    Set Attachments = New Collection
    ReDim AddrTo(-1 To -1) As String
    ReDim AddrCc(-1 To -1) As String
    ReDim AddrBcc(-1 To -1) As String
    IsReportItem = False
End Sub

Public Sub Unload_A_COM()
  Set Attachments = Nothing
End Sub


Public Sub AddAddrTo(ByVal as_address As String)
    Call AddAddr(AddrTo, as_address)
End Sub

Public Sub AddAddrCc(ByVal as_address As String)
    Call AddAddr(AddrCc, as_address)
End Sub

Public Sub AddAddrBcc(ByVal as_address As String)
    Call AddAddr(AddrBcc, as_address)
End Sub

Private Sub AddAddr(ByRef dst_array() As String, ByRef as_address As String)
    
    Dim ll_count As Long
    ll_count = UBound(dst_array)
    
    If ll_count >= 0 Then
        ReDim Preserve dst_array(ll_count) As String
    Else
        ll_count = ll_count + 1
        ReDim dst_array(ll_count) As String
    End If
        
    dst_array(ll_count) = as_address
End Sub

Public Sub ReadAddrTo(ByRef scriptEngine As ScriptControl)
On Error GoTo ErrHandler
    Call ReadAddresses(scriptEngine, AddrTo, "obj.toRecipients")
    Exit Sub
ErrHandler:
End Sub

Public Sub ReadAddrCc(ByRef scriptEngine As ScriptControl)
On Error GoTo ErrHandler
    Call ReadAddresses(scriptEngine, AddrCc, "obj.ccRecipients")
    Exit Sub
ErrHandler:
End Sub

Public Sub ReadAddrBcc(ByRef scriptEngine As ScriptControl)
On Error GoTo ErrHandler
    Call ReadAddresses(scriptEngine, AddrBcc, "obj.bccRecipients")
    Exit Sub
ErrHandler:
End Sub

Private Sub ReadAddresses(ByRef scriptEngine As ScriptControl, ByRef dst_array() As String, ByRef src_array As String)
On Error GoTo ErrHandler
    Dim ll_count As Long
    
    ll_count = scriptEngine.Eval(src_array & ".length")
    
    If ll_count > 0 Then
        ReDim dst_array(ll_count - 1) As String
    Else
        ReDim dst_array(-1 To -1) As String
    End If
    
    Dim i As Long
    
    For i = 0 To ll_count - 1
        dst_array(i) = scriptEngine.Eval(src_array & "[" & i & "].emailAddress.address")
    Next
    
    
    Exit Sub
ErrHandler:
End Sub

Public Sub SetTextAddrTo(as_TextTo As String)
  Call SplitAddress(as_TextTo, AddrTo)
End Sub

Public Sub SetTextAddrCc(as_TextCc As String)
  Call SplitAddress(as_TextCc, AddrCc)
End Sub

Public Sub SetTextAddrBcc(as_TextBcc As String)
  Call SplitAddress(as_TextBcc, AddrBcc)
End Sub

Public Function GetTextAddrFrom() As String
    GetTextAddrFrom = AddrFrom
End Function

Public Function GetTextAddrTo() As String
  If IsArray(AddrTo) Then
    GetTextAddrTo = Join(AddrTo, ",")
  Else
    GetTextAddrTo = ""
  End If
End Function

Public Function GetTextAddrCc() As String
  If IsArray(AddrCc) Then
    GetTextAddrCc = Join(AddrCc, ",")
  Else
    GetTextAddrCc = ""
  End If
End Function

Public Function GetTextAddrBcc() As String
  If IsArray(AddrBcc) Then
    GetTextAddrBcc = Join(AddrBcc, ",")
  Else
    GetTextAddrBcc = ""
  End If
End Function

Private Sub SplitAddress(as_Text As String, ByRef av_Value As Variant)
Dim ll_Index As Long

  av_Value = Split(as_Text, ",")
  For ll_Index = 0 To UBound(av_Value)
    av_Value(ll_Index) = Trim(av_Value(ll_Index))
  Next
End Sub

Public Function ToJSON() As String
Dim ls_json As String
    ls_json = "{" & _
              """subject"": """ & ArmREST.JsonEscape(Subject) & """," & _
              """body"":{" & _
              """contentType"":""" & GetContentType() & """," & _
              """content"":""" & ArmREST.JsonEscape(IIf(HTMLBody = "", Body, HTMLBody)) & """" & _
              "}," & _
              """toRecipients"":" & AddrToJSON(AddrTo) & "," & _
              """ccRecipients"":" & AddrToJSON(AddrCc) & "," & _
              """bccRecipients"":" & AddrToJSON(AddrBcc) & _
              "}"
    ToJSON = ls_json
End Function

Private Function AddrToJSON(ByRef Addr() As String) As String

    Dim ls_json As String
    ls_json = "["
    
    If IsArray(Addr) Then
        Dim ll_i As Long
        For ll_i = 0 To UBound(Addr)
            If ll_i > 0 Then ls_json = ls_json & "," & vbCrLf
            ls_json = ls_json & "{ ""emailAddress"":{""address"": """ & Addr(ll_i) & """ }}"
        Next
        
    End If
    
    ls_json = ls_json & "]"
    
    AddrToJSON = ls_json
        
End Function

Private Function GetContentType() As String
    If HTMLBody <> "" Then
        GetContentType = "Html"
    Else
        GetContentType = "Text"
    End If
End Function

Public Function Save(ByVal as_userURL As String, ByVal as_Path As String) As Boolean
On Error GoTo ErrHandler
    Save = False
    
    Dim ls_json As Variant
    
    ' get content
    If Not GetWebService(as_userURL & "/messages/" & Id & "/$value?" & GetRND, ls_json) Then
        Exit Function
    End If

    'delete the file
    If FileExists(as_Path) Then
        Call Kill(as_Path)
    End If
    
    Dim fnum As Long
    fnum = FreeFile
    
    Open as_Path For Output As #fnum
    Print #fnum, ls_json
    Close #fnum

    Save = True
    Exit Function
ErrHandler:
    ArmREST.ms_Exception = Err.Description
End Function

Private Function FileExists(ByVal Fname As String) As Boolean
        FileExists = IIf(Dir(Fname) <> "", True, False)
End Function

Public Function AddAttachment(ByVal ao_Att As ArmGraphMailAttachment) As Boolean
Dim lb_Found As Boolean
Dim ll_Index As Long
  
  If ao_Att Is Nothing Then
    AddAttachment = False
  Else
    lb_Found = False
    For ll_Index = 1 To Attachments.Count
      If StrComp(ao_Att.Name, Attachments(ll_Index).Name, vbTextCompare) = 0 Then
        lb_Found = True
        Exit For
      End If
    Next
    If Not lb_Found Then
      Call Attachments.Add(ao_Att)
    End If
    AddAttachment = Not lb_Found
  End If
End Function
