VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   7395
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11085
   LinkTopic       =   "Form1"
   ScaleHeight     =   7395
   ScaleWidth      =   11085
   StartUpPosition =   3  'Windows Default
   Begin Project1.mailObserver usc_mailObserver 
      Height          =   7245
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   11055
      _ExtentX        =   19500
      _ExtentY        =   12779
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

    Const ApolloTenantID As String = "55f22949-6163-4931-ae91-aa41b0659f29"
    Const ApplicationID As String = "6d9163c5-1526-4080-acaf-e11f04b91dca"                    ' GMail App ID
    
    Private ms_ApolloTenantID As String
    Private ms_ApplicationID As String
    
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2


#If LIVE = 1 Then
    Private mo_Db As Object             'DB Connection
    Const c_Server = "UXBDB020\APOLLOD"
    Const c_Database = "SIFYB2"
    Const c_User = "batchabp"
    Const c_Pass = "art3m1s"
#Else
    Private mo_Db As ARMSYSCOMLib.ArmDb 'DB Connection
    
    Const c_Server As String = "UXBDB020\APOLLOD"
    Const c_Database As String = "SIFYB2"
    Const c_User As String = "capture"
    Const c_Pass As String = "c"
#End If

    Private ms_Server As String
    Private ms_Database As String
    Private ms_User  As String
    Private ms_Pass  As String

'Public WithEvents me_OlItems As Outlook.Items


Private Sub Form_Load()

On Error GoTo ErrHandler
    
    Dim ls_Text As String
    
    ms_ApolloTenantID = ApolloTenantID
    ms_ApplicationID = ApplicationID
    
    ms_Server = c_Server
    ms_Database = c_Database
    ms_User = c_User
    ms_Pass = c_Pass
    
    Open App.Path & "\config.txt" For Input As #1
    While Not EOF(1)
        Line Input #1, ls_Text
        Select Case GetBeforeEqual(ls_Text)
        Case "Tenant"                           ' apollo tenant
            ms_ApolloTenantID = GetAfterEqual(ls_Text)
        Case "AppID"                            ' GMail app id
            ms_ApplicationID = GetAfterEqual(ls_Text)
        Case "DBServer"                         ' database server
            ms_Server = GetAfterEqual(ls_Text)
        Case "DBName"                           ' database name
            ms_Database = GetAfterEqual(ls_Text)
        Case "DBUser"                           ' database user
            ms_User = GetAfterEqual(ls_Text)
        Case "DBPassword"                       ' database password
            ms_Pass = GetAfterEqual(ls_Text)
        End Select
    Wend
    Close #1
    
    
    ' Create the shared connection
    #If LIVE = 1 Then
        Set mo_Db = CreateObject("ArmSysCOM.ArmDb")
    #Else
        Set mo_Db = New ARMSYSCOMLib.ArmDb
    #End If
        
    If Not mo_Db.Connect(ms_Server, ms_Database, ms_User, ms_Pass, "MailObserver") Then
        Call MsgBox("Server is not responding, try again later")
        Debug.Assert (False)
        End
    End If
    
    Me.Caption = "Mail Observer v." & App.Major & "." & App.Minor & "." & App.Revision & "      " & ms_Server & " -- " & ms_Database & " -- " & ms_User
    
    Set usc_mailObserver.Db = mo_Db
    usc_mailObserver.U_Code = 1
    usc_mailObserver.Server = ms_Server
    usc_mailObserver.Database = ms_Database
    usc_mailObserver.Pass = ms_Pass
    usc_mailObserver.User = ms_User
    
    usc_mailObserver.TenantID = ms_ApolloTenantID
    usc_mailObserver.AppID = ms_ApplicationID
    
    Call usc_mailObserver.Load_A_COM
     
    Exit Sub
ErrHandler:
    Dim ls_Msg As String
    ' Display msg into debug window
    ls_Msg = "Error n" & Err.Number & ", " & Err.Description & " occured into " & Err.Source
    Debug.Print ls_Msg & vbCrLf
    
    ' STEP 2 - Free ressources
    If Not mo_Db Is Nothing Then
        mo_Db.Disconnect
        Set mo_Db = Nothing
    End If
    
    ' STEP 3 - Display info for user
    ls_Msg = "The application couldn't start because of unexpected error, please contact IT " & vbCrLf & ls_Msg
    
    Call MsgBox(ls_Msg, vbCritical + vbOKOnly, App.ProductName)
    ' Exit from application
    End
    
End Sub

Function GetBeforeEqual(ByVal psText As String) As String
Dim i As Integer
On Error GoTo ErrHandler
    
    i = InStr(1, psText, "=")
    GetBeforeEqual = Left(psText, i - 2)
    
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBeforeEqual")
End Function

' Rcupre la chaine de caractre aprs le " = " dans une chaine passe en paramtre
Function GetAfterEqual(ByVal psText As String) As String
Dim i As Integer
On Error GoTo ErrHandler
    
    i = InStr(1, psText, "=")
    GetAfterEqual = right(psText, Len(psText) - i - 1)
    If GetAfterEqual = "NULL" Then
        GetAfterEqual = ""
    End If
    
  Exit Function
ErrHandler:
  Call ErrorHandler("GetAfterEqual")
End Function


Private Sub Form_Unload(Cancel As Integer)
    Call usc_mailObserver.Unload_A_COM
    
    If Not mo_Db Is Nothing Then
        ' disconnect DB
        mo_Db.Disconnect
        Set mo_Db = Nothing
    End If
End Sub

Private Sub usc_mailObserver_quit()
    Unload Me
End Sub

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, as_Fct & SEP1 & Err.Source, Err.Description, Err.HelpFile, Err.HelpContext
End Sub

' display standard error message
' Params:
' as_Fct (String) - Error CallStack
' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String, Optional ab_Display As Boolean = True)
    'If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    'Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    
    If ab_Display Then
        Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, , "Error message: " & as_Fct)
    End If
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub
