VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_Product"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

#If ENV = LIVE Then
Private mo_Db As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private ms_Language_Code As String
Private ml_iConcurrency As Long

Public CT_Code As String
Public CURR_Code As String
Public ValidityDate As Date
Public IsTemplate As Boolean
Public IsProduction As Boolean
Public OFD_MarginS As Double
Public OFD_GTN As Double
Public OFD_MarginMin As Double

Public NoInlay As Boolean
Public NoVentilation As Boolean
Public NoLoudspeaker As Boolean
Public NoCutout As Boolean
Public NoPerforation As Boolean

Public lbl_PlantVendor As String
Public lbl_ShipPoint As String

Public COF_Id As String
Public PRD_Id As String
Public OFD_Pos As Long
Public OFD_WshDat As Date
Public OFD_ShpDat As Date
Public OFD_DelDat As Date
Public SAE_Id As Long
Public SHP_Id As Long
Public VEN_Id As String
Public OFD_IsFree As Boolean
Public OFD_PosCus As String
Public OFD_IsAsItem As Boolean

Public SAE_Name As String
Public SHP_Name As String
Public VEN_Name As String

Public CAT_Id As Long
Public PRD_IdPar As String
Public PRD_Child As Long
Public PRD_Code As String
Public PRD_CodeC As String
Public Vendor_Id As String
Public Vendor_Name As String
Public LEV_Id As Long
Public ERR_Type As eDPCErrorType
Public IMG_Id As Long
Public STA_Id As Long
Public CLS_Id1 As Long
Public CLS_Name1 As String
Public CLS_Id2 As Long
Public CLS_Name2 As String
Public CLS_Id3 As Long
Public CLS_Name3 As String
Public CLS_Id4 As Long
Public CLS_Name4 As String
Public CLS_Id5 As Long
Public CLS_Name5 As String
Public CLS_Id6 As Long
Public CLS_Name6 As String
Public CLS_Id7 As Long
Public CLS_Name7 As String
Public CLS_Id8 As Long
Public CLS_Name8 As String

Public RPL_Type As Long
Public RPL_Thick As Double
Public RPL_StdGa As Boolean
Public RPL_BevA As Double
Public RPL_BevB As Double
Public RPL_CorW As Double
Public RPL_GskDe As eDPCGasketDelivery
Public RPL_GskDeDesc As String
Public RPL_SpcDe As eDPCSpacerDelivery
Public RPL_SpcDeDesc As String
Public RPL_SpcNt As Boolean
Public RPL_PerDe As eDPCPerimeterDelivery
Public RPL_SwGap As Double
Public RPL_Plate As eDPCPlateType
Public RPL_PlCnt As Long
Public RPL_IsOut As eDPCPanelInOut
Public RPL_PBord As eDPCPerforationBorderType
Public RPL_PBordDesc As String
Public RPL_SCorr As Double

Public RPL_SBndA As Boolean
Public RPL_SBndB As Boolean
Public RPL_SUZA As Boolean
Public RPL_SUZB As Boolean
Public RPL_PU As Long
Public RPL_MQty As Long
Public RPL_CoSid As eDPCCoatingExecution
Public RPL_CoSidDesc As String
Public RPL_WghPnt As Long
Public RPL_OGroup As String
Public RPL_PGroup As String
Public RPL_AGroup As Long
Public RPL_MGroup As Long

Public RPL_DrwNr As String
Public RPL_SpcPkg As eDPCSpecialPackage
Public RPL_PkgA As Double
Public RPL_PkgB As Double
Public RPL_PkgH As Double
Public RPL_PkgWgh As Double

Public RPL_LabLng As String
Public RPL_LabLngDesc As String
Public RPL_LabTxt As String
Public RPL_PkgLogo As Long

Public RPL_AdminFact  As Double
Public RPL_ICTPFact  As Double
Public RPL_MPE2Fact As Double
Public RPL_BOMRejectFact As Double
Public RPL_BORWasteFact As Double
Public RPL_RejectOtherFact As Double

Public RPL_StdMa As Boolean
Public MAT_Id As Long
Public RPL_CoWMin As Long
Public RPL_CoWMax As Long
Public RPL_CutA As Double
Public RPL_CutB As Double
Public RPL_CoilW As Double
Public ParentRPL_CoWMin As Long
Public ParentRPL_CoWMax As Long
Public ParentRPL_CutA As Double
Public ParentRPL_CutB As Double
Public ParentRPL_CoilW As Double

Public RPL_CustDim As Long
Public RPL_MatTyp As String
Public MAT_Prefx As String
Public MAT_OrdQty As Long
Public MAT_WiStep As Long
Public MAT_MaxCut As Long
Public MAT_CoilTypeIdx As Long

Public PKG_Id As String
Public LAB_Id As String
Public PRF_Id As String

' coil code and tempoarary coil template
Public COI_Code As String
Public COI_CodeTmp As String
Public COI_SpcWgh As Double
Public COI_WasteFact As Double
Public COI_WasteQty As Long
Public COI_IsStock As Boolean

Public COA_Id As String
Public COA_Code As String
Public COA_Name As String
Public COA_Desc As String
Public COA_IsCus As Boolean
Public COA_App As eDPCCoatingApplication
Public COA_Type As eDPCCoatingType
Public COA_Mat As eDPCCoatingMaterial
Public COA_Norm As Long
Public COA_AppDesc As String
Public COA_TypeDesc As String
Public COA_MatDesc As String
Public COA_NormDesc As String
Public COA_ExName As String
Public COA_CE As Long

Public PRD_Name As String
Public PRD_Desc As String

Public MAT_Name As String
Public MAT_Desc As String
Public MAT_CE As Long

Public CAT_Name As String
Public CAT_Desc As String

Public SYS_Id As Long
Public SYS_Name As String
Public SYS_Desc As String
Public SYS_Frame As Long
Public SYS_Exec As String
Public SYS_InlayDec1 As Double
Public SYS_InlayDec2 As Double

Public IMG_IdSYS As Long

Public PKG_Code As String
Public PKG_Name As String
Public PKG_Desc As String

Public LAB_Code As String
Public LAB_Name As String
Public LAB_Desc As String

Public PRF_Code As String
Public PRF_Name As String
Public PRF_Desc As String
Public PRF_Class As String
Public PRF_FSC  As Double
Public PRF_MaxPW  As Double
Public PRF_MaxTW  As Double
Public PRF_MaxST As Double
Public PRF_MaxAT As Double
Public PRF_HoleA As Double
Public PRF_HoleB As Double
Public PRF_DivA As Double
Public PRF_DivB As Double
Public PRF_Step As Double
Public PRF_StLim As Double
Public PRF_SAMin As Double
Public PRF_SAMax As Double
Public PRF_SBMin As Double
Public PRF_IsCorrStep As Boolean
Public PRF_IsStandard As Boolean
Public IMG_IdPRF As Long
Public LEV_IdPRF As Long

Public SYS_AMin As Double
Public SYS_AMax As Double
Public SYS_BMin As Double
Public SYS_BMax As Double

Private md_RPL_ModA As Double
Private md_RPL_ModB As Double
Private md_RPL_PanA As Double
Private md_RPL_PanB As Double
Private mda_RPL_Gap(3) As Double
Private mda_SYS_GapMin(3) As Double
Private mda_SYS_GapMax(3) As Double
Private mea_SYS_AllowG(3) As eDPCSystemAllowGasket
Private mda_RPL_UBor(3) As Double
Private mda_RPL_UBoW(3) As Double
Private mda_RPL_H(3) As Double

Private mda_SYS_UnperfBorder(3) As Double

Private mba_GTT_Selected(3) As Boolean
Private mla_IMG_IdGSK(3) As Long
Private msa_GSK_Id(3) As String
Private msa_GSK_Code(3) As String
Private msa_GSK_Name(3) As String
Private msa_GSK_Desc(3) As String
Private mda_GSK_Gap(3) As Double
Private mba_GSK_IsCus(3) As Boolean
Private msa_GSK_ExName(3) As String

Private mba_GTT_Selected2(3) As Boolean
Private mla_IMG_Id2GSK(3) As Long
Private msa_GSK_Id2(3) As String
Private msa_GSK_Code2(3) As String
Private msa_GSK_Name2(3) As String
Private msa_GSK_Desc2(3) As String
Private mda_GSK_Gap2(3) As Double
Private mba_GSK_IsCus2(3) As Boolean
Private msa_GSK_ExName2(3) As String

Private mba_RPL_BVis(3) As Double
Private mba_RPL_NClo(3) As Double
Private mba_BND_CanVi(3) As Double
Private msa_BND_Id(3) As String
Private msa_BND_Name(3) As String
Private msa_BND_Desc(3) As String
Private mla_IMG_IdBND(3) As Long
Private mla_IMG_Id2BND(3) As Long
Private mla_IMG_IdVBND(3) As Long
Private mla_IMG_IdV2BND(3) As Long

Private mda_BND_UMin(3) As Double
Private mda_BND_UMax(3) As Double
Private mda_BND_S(3) As Double
Private mda_BND_H(3) As Double
Private mba_BND_IsCus(3) As Boolean
Private mba_BND_HasU(3) As Boolean
Private mba_BND_HasH(3) As Boolean
Private mba_BND_HasS(3) As Boolean

Private mda_BND_HMin1(3) As Double
Private mda_BND_HMax1(3) As Double
Private mda_BND_UMin1(3) As Double
Private mda_BND_UMax1(3) As Double
Private mda_BND_SMin1(3) As Double
Private mda_BND_SMax1(3) As Double

Private mda_BND_HMin2(3) As Double
Private mda_BND_HMax2(3) As Double
Private mda_BND_UMin2(3) As Double
Private mda_BND_UMax2(3) As Double
Private mda_BND_SMin2(3) As Double
Private mda_BND_SMax2(3) As Double
Private mda_BND_MatFct(3) As Double

Private mda_RPL_U(3) As Double
Private mda_RPL_UMin(3) As Double
Private mda_RPL_UMax(3) As Double
Private mda_RPL_S(3) As Double
Private ma_OptionalBND_Id() As Variant
Private ma_OptionalBND_Name() As Variant

Private ma_OptionalGskGap() As Variant
Private ma_OptionalGSK_Id() As Variant
Private ma_OptionalGskGap2() As Variant
Private ma_OptionalGSK_Id2() As Variant

Private ma_DefaultInlayPerfDec() As Variant

Public Cutouts As New Collection
Public Inlays As New Collection
Public OfferOptions As New Collection
Public Errors As New Collection
Public OfferPrice As New Collection
Public Files As New Collection

Public BOMs As New Collection
Public BORs As New Collection

Private mc_OfferTemplate As Long
Private mc_Error As Long
'Private mc_A_Config As Long
Private mo_TempProduct As DPC_Product
Private mo_ScreenErr As Scripting.Dictionary

Private ml_Idx As Long
Private mv_Edge As Variant
Private ma_CostCalc() As tDPC_CostCalc
Public IsCostCalcChanged As Boolean
Public IsBOMLoaded As Boolean
Public IsBORLoaded As Boolean

Private Type tDPC_CostCalc
  Code As Long
  Desc As String
  CostPCS As Double
  CostM2 As Double
  DirectSetupCost As Double
  SubSetupCost As Double
  TotSetupCost As Double
  CURR_Code As String
End Type

Private Const C_ERRORRAISE As Long = 2500

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Property Let U_Code(al_Code As Long)
On Error GoTo ErrHandler
  
  ml_U_Code = al_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Property Let Language_Code(AString As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = AString
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property

Property Get Language_Code() As String
On Error GoTo ErrHandler
  
  Language_Code = ms_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
    
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  mv_Edge = Array("C", "D", "E", "F")
  ReDim ma_OptionalBND_Id(-1 To -1)
  ReDim ma_OptionalBND_Name(-1 To -1)
  ReDim ma_OptionalGSK_Id(-1 To -1)
  ReDim ma_OptionalGskGap(-1 To -1)
  ReDim ma_OptionalGSK_Id2(-1 To -1)
  ReDim ma_OptionalGskGap2(-1 To -1)
  ReDim ma_DefaultInlayPerfDec(-1 To -1)
  ReDim ma_CostCalc(-1 To -1)
  IsCostCalcChanged = False
  IsBOMLoaded = False
  IsBORLoaded = False
  
  OFD_MarginS = 0
  OFD_GTN = 0
  OFD_MarginMin = 0
  
  Set mo_ScreenErr = New Scripting.Dictionary
  Call mo_ScreenErr.Add(eDPCScreen.psPanel, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psPerforation, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psGasket, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psPacking, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psInlay, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psCoating, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psVentilation, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psLoudspeaker, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psCutout, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psBending, eDPCErrorType.etNone)
  Call mo_ScreenErr.Add(eDPCScreen.psOption, eDPCErrorType.etNone)
  
  ml_Idx = 1
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_Com")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler
  
  mv_Edge = Empty
  ReDim ma_OptionalBND_Id(-1 To -1)
  ReDim ma_OptionalBND_Name(-1 To -1)
  ReDim ma_OptionalGSK_Id(-1 To -1)
  ReDim ma_OptionalGskGap(-1 To -1)
  ReDim ma_OptionalGSK_Id2(-1 To -1)
  ReDim ma_OptionalGskGap2(-1 To -1)
  ReDim ma_DefaultInlayPerfDec(-1 To -1)
  ReDim ma_CostCalc(-1 To -1)
  
  If mc_OfferTemplate <> 0 Then
    Call mo_Db.Close(mc_OfferTemplate)
    mc_OfferTemplate = 0
  End If
  If mc_Error <> 0 Then
    Call mo_Db.Close(mc_Error)
    mc_Error = 0
  End If
'  If mc_A_Config <> 0 Then
'    Call mo_Db.Close(mc_A_Config)
'    mc_A_Config = 0
'  End If
  Call mo_ScreenErr.RemoveAll
  Set mo_ScreenErr = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_Com")
End Sub

Public Property Set ProductTemplate(ByRef ao_Product As DPC_Product)
On Error GoTo ErrHandler
        
  Set mo_TempProduct = ao_Product
  Exit Property
ErrHandler:
  Call ErrorHandler("ProductTemplate.Set")
End Property

Public Function IsStandard() As Boolean
On Error GoTo ErrHandler
        
  IsStandard = (CAT_Id = eDPCCategory.cgMetalPanelSKU)
  Exit Function
ErrHandler:
  Call ErrorHandler("IsStandard")
End Function

Public Function IsFixed() As Boolean
On Error GoTo ErrHandler
      
  IsFixed = False
  If Not mo_TempProduct Is Nothing Then
    IsFixed = (mo_TempProduct.RPL_PanA > 0) And (mo_TempProduct.RPL_PanB > 0)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsFixed")
End Function

Public Property Let IMG_IdGSK(ByVal al_SideIdx As Long, ByVal al_IMG_IdGSK As Long)
On Error GoTo ErrHandler
  
  mla_IMG_IdGSK(al_SideIdx) = al_IMG_IdGSK
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdGSK.Let")
End Property

Public Property Get IMG_IdGSK(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_IdGSK = mla_IMG_IdGSK(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdGSK.Get")
End Property

Public Function HasPacking() As Boolean
On Error GoTo ErrHandler
  
  HasPacking = (Trim(PKG_Id) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("HasPacking")
End Function

Public Function HasLabeling() As Boolean
On Error GoTo ErrHandler
  
  HasLabeling = (Trim(LAB_Id) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("HasLabeling")
End Function

Public Function HasCoating() As Boolean
On Error GoTo ErrHandler
  
  HasCoating = (Trim(COA_Id) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("HasCoating")
End Function

Public Function HasPerforation() As Boolean
On Error GoTo ErrHandler
  
  HasPerforation = (StrComp(Trim(PRF_Id), mo_Tools.GetAConfigData("DPC_Default_PRF0"), vbTextCompare) <> 0)
  Exit Function
ErrHandler:
  Call ErrorHandler("HasPerforation")
End Function

Public Function HasInlay() As Boolean
On Error GoTo ErrHandler
  
  HasInlay = Inlays.Count > 0
  Exit Function
ErrHandler:
  Call ErrorHandler("HasInlay")
End Function

Public Function ContainInlay(ByVal ao_Inlay As DPC_Inlay) As Boolean
On Error GoTo ErrHandler
  
Dim lo_Inlay As DPC_Inlay

  ContainInlay = False
  For Each lo_Inlay In Inlays
    If (lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop) And (StrComp(ao_Inlay.INL_Id, lo_Inlay.INL_Id, vbTextCompare) = 0) Then
      ContainInlay = True
      Exit For
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("ContainInlay")
End Function

Public Function HasCutout() As Boolean
On Error GoTo ErrHandler
  
  HasCutout = GetCutoutCount > 0
  Exit Function
ErrHandler:
  Call ErrorHandler("HasCutout")
End Function

Public Function HasLoudspeaker() As Boolean
On Error GoTo ErrHandler
  
  HasLoudspeaker = GetLoudspeakerCount > 0
  Exit Function
ErrHandler:
  Call ErrorHandler("HasLoudspeaker")
End Function

Public Function HasVentilation() As Boolean
On Error GoTo ErrHandler
  
  HasVentilation = GetVentilationCount > 0
  Exit Function
ErrHandler:
  Call ErrorHandler("HasVentilation")
End Function

Public Function IsGasketOn(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  IsGasketOn = (Trim(GSK_Id(al_SideIdx)) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("IsGasketOn al_SideIdx=" & al_SideIdx)
End Function

Public Function HasGasket() As Boolean
On Error GoTo ErrHandler
Dim ll_SideIdx As Long
  
  HasGasket = False
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsGasketOn(ll_SideIdx) Then
      HasGasket = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasGasket")
End Function

Public Function IsSpacerOn(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  IsSpacerOn = (Trim(GSK_Id2(al_SideIdx)) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("IsSpacerOn al_SideIdx=" & al_SideIdx)
End Function

Public Function HasSpacer() As Boolean
On Error GoTo ErrHandler
Dim ll_SideIdx As Long
  
  HasSpacer = False
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsSpacerOn(ll_SideIdx) Then
      HasSpacer = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasSpacer")
End Function

Public Function HasBendingVisible() As Boolean
On Error GoTo ErrHandler
Dim ll_SideIdx As Long
  
  HasBendingVisible = False
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If RPL_BVis(ll_SideIdx) Then
      HasBendingVisible = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasBendingVisible")
End Function

Public Property Let GTT_Selected(ByVal al_SideIdx As Long, ByVal ab_GTT_Selected As Boolean)
On Error GoTo ErrHandler
  
  mba_GTT_Selected(al_SideIdx) = ab_GTT_Selected
  Exit Property
ErrHandler:
  Call ErrorHandler("GTT_Selected.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GTT_Selected(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  GTT_Selected = mba_GTT_Selected(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GTT_Selected.Get al_SideIdx=" & al_SideIdx)
End Property

Public Function GetGasketCount() As Long
On Error GoTo ErrHandler

Dim ll_Count As Long
Dim ll_Idx As eDPCSide

  ll_Count = 0
  For ll_Idx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsGasketOn(ll_Idx) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetGasketCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetGasketCount")
End Function

Public Function GetSpacerCount() As Long
On Error GoTo ErrHandler

Dim ll_Count As Long
Dim ll_Idx As eDPCSide

  ll_Count = 0
  For ll_Idx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsSpacerOn(ll_Idx) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetSpacerCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetSpacerCount")
End Function

Public Property Get GSK_Pos() As String
On Error GoTo ErrHandler
  
Dim ls_GSK_Pos As String
Dim ll_SideIdx As eDPCSide

  ls_GSK_Pos = ""
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsGasketOn(ll_SideIdx) Then
      If ls_GSK_Pos <> "" Then ls_GSK_Pos = ls_GSK_Pos & " "
      ls_GSK_Pos = ls_GSK_Pos & mv_Edge(ll_SideIdx)
    End If
  Next
  GSK_Pos = ls_GSK_Pos
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Pos.Get")
End Property
    
Public Property Get GSK_Pos2() As String
On Error GoTo ErrHandler
  
Dim ls_GSK_Pos2 As String
Dim ll_SideIdx As eDPCSide

  ls_GSK_Pos2 = ""
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If IsSpacerOn(ll_SideIdx) Then
      If ls_GSK_Pos2 <> "" Then ls_GSK_Pos2 = ls_GSK_Pos2 & " "
      ls_GSK_Pos2 = ls_GSK_Pos2 & mv_Edge(ll_SideIdx)
    End If
  Next
  GSK_Pos2 = ls_GSK_Pos2
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Pos2.Get")
End Property
    
Public Property Get RPL_NCloPos() As String
On Error GoTo ErrHandler
  
Dim ls_RPL_NCloPos As String
Dim ll_SideIdx As eDPCSide

  ls_RPL_NCloPos = ""
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If RPL_NClo(ll_SideIdx) Then
      If ls_RPL_NCloPos <> "" Then ls_RPL_NCloPos = ls_RPL_NCloPos & "\"
      ls_RPL_NCloPos = ls_RPL_NCloPos & mv_Edge(ll_SideIdx)
    End If
  Next
  RPL_NCloPos = ls_RPL_NCloPos
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_NCloPos.Get")
End Property
    
Public Property Get RPL_BVisPos() As String
On Error GoTo ErrHandler
  
Dim ls_RPL_BVisPos As String
Dim ll_SideIdx As eDPCSide

  ls_RPL_BVisPos = ""
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If RPL_BVis(ll_SideIdx) Then
      If ls_RPL_BVisPos <> "" Then ls_RPL_BVisPos = ls_RPL_BVisPos & "\"
      ls_RPL_BVisPos = ls_RPL_BVisPos & mv_Edge(ll_SideIdx)
    End If
  Next
  RPL_BVisPos = ls_RPL_BVisPos
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_BVisPos.Get")
End Property

'Public Function GetGasketSides(Optional ByVal as_GSK_Id As String = "") As Variant
'On Error GoTo ErrHandler
'
'Dim lv_Sides As Variant
'Dim ll_Idx As eDPCSide
'
'  ReDim lv_Sides(-1 To -1)
'  For ll_Idx = eDPCSide.esSideC To eDPCSide.esSideF
'    If (StrComp(as_GSK_Id, GSK_Id(ll_Idx), vbTextCompare) = 0) Or (as_GSK_Id = "" And IsGasketOn(ll_Idx)) Then
'      ReDim Preserve lv_Sides(UBound(lv_Sides) + 1)
'      lv_Sides(UBound(lv_Sides)) = ll_Idx
'    End If
'  Next
'  GetGasketSides = lv_Sides
'  Exit Function
'ErrHandler:
'  Call errorHandler("GetGasketSides")
'End Function
'
'Public Function GetSpacerSides(Optional ByVal as_GSK_Id2 As String = "") As Variant
'On Error GoTo ErrHandler
'
'Dim lv_Sides As Variant
'Dim ll_Idx As eDPCSide
'
'  ReDim lv_Sides(-1 To -1)
'  For ll_Idx = eDPCSide.esSideC To eDPCSide.esSideF
'    If (StrComp(as_GSK_Id2, GSK_Id2(ll_Idx), vbTextCompare) = 0) Or (as_GSK_Id2 = "" And IsSpacerOn(ll_Idx)) Then
'      ReDim Preserve lv_Sides(UBound(lv_Sides) + 1)
'      lv_Sides(UBound(lv_Sides)) = ll_Idx
'    End If
'  Next
'  GetSpacerSides = lv_Sides
'  Exit Function
'ErrHandler:
'  Call errorHandler("GetSpacerSides")
'End Function
'
Public Property Let GSK_Id(ByVal al_SideIdx As Long, ByVal al_GSK_Id As String)
On Error GoTo ErrHandler
  msa_GSK_Id(al_SideIdx) = al_GSK_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Id.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Id(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Id = msa_GSK_Id(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Id.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Code(ByVal al_SideIdx As Long, ByVal as_GSK_Code As String)
On Error GoTo ErrHandler
  msa_GSK_Code(al_SideIdx) = as_GSK_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Code.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Code(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Code = msa_GSK_Code(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Code.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Name(ByVal al_SideIdx As Long, ByVal as_GSK_Name As String)
On Error GoTo ErrHandler
  msa_GSK_Name(al_SideIdx) = as_GSK_Name
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Name.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Name(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Name = msa_GSK_Name(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Name.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Desc(ByVal al_SideIdx As Long, ByVal as_GSK_Desc As String)
On Error GoTo ErrHandler
  msa_GSK_Desc(al_SideIdx) = as_GSK_Desc
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Desc.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Desc(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Desc = msa_GSK_Desc(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Desc.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Gap(ByVal al_SideIdx As Long, ByVal ad_GSK_Gap As Double)
On Error GoTo ErrHandler
  mda_GSK_Gap(al_SideIdx) = ad_GSK_Gap
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Gap.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Gap(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  GSK_Gap = mda_GSK_Gap(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Gap.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_IsCus(ByVal al_SideIdx As Long, ByVal ab_GSK_IsCus As Boolean)
On Error GoTo ErrHandler
  
  mba_GSK_IsCus(al_SideIdx) = ab_GSK_IsCus
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_IsCus.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_IsCus(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  GSK_IsCus = mba_GSK_IsCus(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_IsCus.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_ExName(ByVal al_SideIdx As Long, ByVal as_GSK_ExName As String)
On Error GoTo ErrHandler
  msa_GSK_ExName(al_SideIdx) = as_GSK_ExName
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_ExName.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_ExName(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_ExName = msa_GSK_ExName(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_ExName.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GTT_Selected2(ByVal al_SideIdx As Long, ByVal ab_GTT_Selected As Boolean)
On Error GoTo ErrHandler
  mba_GTT_Selected2(al_SideIdx) = ab_GTT_Selected
  Exit Property
ErrHandler:
  Call ErrorHandler("GTT_Selected2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GTT_Selected2(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  GTT_Selected2 = mba_GTT_Selected2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GTT_Selected2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let IMG_Id2GSK(ByVal al_SideIdx As Long, ByVal al_IMG_IdGSK As Long)
On Error GoTo ErrHandler
  mla_IMG_Id2GSK(al_SideIdx) = al_IMG_IdGSK
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_Id2GSK.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get IMG_Id2GSK(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_Id2GSK = mla_IMG_Id2GSK(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_Id2GSK.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Id2(ByVal al_SideIdx As Long, ByVal al_GSK_Id As String)
On Error GoTo ErrHandler
  msa_GSK_Id2(al_SideIdx) = al_GSK_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Id2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Id2(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Id2 = msa_GSK_Id2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Id2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Code2(ByVal al_SideIdx As Long, ByVal as_GSK_Code As String)
On Error GoTo ErrHandler
  msa_GSK_Code2(al_SideIdx) = as_GSK_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Code2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Code2(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Code2 = msa_GSK_Code2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Code2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Name2(ByVal al_SideIdx As Long, ByVal as_GSK_Name As String)
On Error GoTo ErrHandler
  msa_GSK_Name2(al_SideIdx) = as_GSK_Name
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Name2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Name2(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Name2 = msa_GSK_Name2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Name2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Desc2(ByVal al_SideIdx As Long, ByVal as_GSK_Desc As String)
On Error GoTo ErrHandler
  msa_GSK_Desc2(al_SideIdx) = as_GSK_Desc
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Desc2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Desc2(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_Desc2 = msa_GSK_Desc2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Desc2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_Gap2(ByVal al_SideIdx As Long, ByVal ad_GSK_Gap As Double)
On Error GoTo ErrHandler
  mda_GSK_Gap2(al_SideIdx) = ad_GSK_Gap
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Gap2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_Gap2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  GSK_Gap2 = mda_GSK_Gap2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_Gap2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_IsCus2(ByVal al_SideIdx As Long, ByVal ab_GSK_IsCus As Boolean)
On Error GoTo ErrHandler
  
  mba_GSK_IsCus2(al_SideIdx) = ab_GSK_IsCus
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_IsCus2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_IsCus2(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  GSK_IsCus2 = mba_GSK_IsCus2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_IsCus2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let GSK_ExName2(ByVal al_SideIdx As Long, ByVal as_GSK_ExName As String)
On Error GoTo ErrHandler
  msa_GSK_ExName2(al_SideIdx) = as_GSK_ExName
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_ExName2.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get GSK_ExName2(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  GSK_ExName2 = msa_GSK_ExName2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("GSK_ExName2.Get al_SideIdx=" & al_SideIdx)
End Property

Public Function IsBendingOn(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  
  IsBendingOn = (Trim(BND_Id(al_SideIdx)) <> "")
  Exit Function
ErrHandler:
  Call ErrorHandler("IsBendingOn al_SideIdx=" & al_SideIdx)
End Function

Public Property Let BND_Id(ByVal al_SideIdx As Long, ByVal al_BND_Id As String)
On Error GoTo ErrHandler
  msa_BND_Id(al_SideIdx) = al_BND_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Id.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get BND_Id(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  BND_Id = msa_BND_Id(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Id.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let BND_Name(ByVal al_SideIdx As Long, ByVal as_BND_Name As String)
On Error GoTo ErrHandler
  msa_BND_Name(al_SideIdx) = as_BND_Name
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Name.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get BND_Name(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  BND_Name = msa_BND_Name(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Name.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let BND_Desc(ByVal al_SideIdx As Long, ByVal as_BND_Desc As String)
On Error GoTo ErrHandler
  msa_BND_Desc(al_SideIdx) = as_BND_Desc
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Desc.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get BND_Desc(ByVal al_SideIdx As Long) As String
On Error GoTo ErrHandler
  BND_Desc = msa_BND_Desc(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_Desc.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let IMG_IdBND(ByVal al_SideIdx As Long, ByVal al_IMG_IdBND As Long)
On Error GoTo ErrHandler
  mla_IMG_IdBND(al_SideIdx) = al_IMG_IdBND
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdBND.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get IMG_IdBND(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_IdBND = mla_IMG_IdBND(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdBND.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let IMG_Id2BND(ByVal al_SideIdx As Long, ByVal al_IMG_IdBND As Long)
On Error GoTo ErrHandler
  mla_IMG_Id2BND(al_SideIdx) = al_IMG_IdBND
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_Id2BND.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get IMG_Id2BND(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_Id2BND = mla_IMG_Id2BND(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_Id2BND.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let IMG_IdVBND(ByVal al_SideIdx As Long, ByVal al_IMG_IdBND As Long)
On Error GoTo ErrHandler
  mla_IMG_IdVBND(al_SideIdx) = al_IMG_IdBND
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdVBND.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get IMG_IdVBND(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_IdVBND = mla_IMG_IdVBND(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdVBND.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Let IMG_IdV2BND(ByVal al_SideIdx As Long, ByVal al_IMG_IdBND As Long)
On Error GoTo ErrHandler
  mla_IMG_IdV2BND(al_SideIdx) = al_IMG_IdBND
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdV2BND.Let al_SideIdx=" & al_SideIdx)
End Property

Public Property Get IMG_IdV2BND(ByVal al_SideIdx As Long) As Long
On Error GoTo ErrHandler
  IMG_IdV2BND = mla_IMG_IdV2BND(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("IMG_IdV2BND.Get al_SideIdx=" & al_SideIdx)
End Property

Public Property Get OptionalBNDCount() As Long
On Error GoTo ErrHandler

  OptionalBNDCount = UBound(ma_OptionalBND_Id) + 1
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalBNDCount.Get")
End Property

Public Property Let OptionalBND_Id(ByVal al_Idx As Long, ByVal av_BND_Id As Variant)
On Error GoTo ErrHandler

  ma_OptionalBND_Id(al_Idx) = av_BND_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalBND_Id.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalBND_Id(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalBND_Id = ma_OptionalBND_Id(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalBND_Id.Get al_Idx=" & al_Idx)
End Property

Public Property Let OptionalBND_Name(ByVal al_Idx As Long, ByVal av_BND_Name As Variant)
On Error GoTo ErrHandler

  ma_OptionalBND_Name(al_Idx) = av_BND_Name
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalBND_Name.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalBND_Name(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalBND_Name = ma_OptionalBND_Name(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalBND_Name.Get al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGSKCount() As Long
On Error GoTo ErrHandler

  OptionalGSKCount = UBound(ma_OptionalGSK_Id) + 1
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSKCount.Get")
End Property

Public Property Let OptionalGSK_Id(ByVal al_Idx As Long, ByVal av_PRD_Id As Variant)
On Error GoTo ErrHandler

  ma_OptionalGSK_Id(al_Idx) = av_PRD_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSK_Id.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGSK_Id(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalGSK_Id = ma_OptionalGSK_Id(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSK_Id.Get al_Idx=" & al_Idx)
End Property

Public Property Let OptionalGskGap(ByVal al_Idx As Long, ByVal ad_Value As Variant)
On Error GoTo ErrHandler

  ma_OptionalGskGap(al_Idx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGskGap.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGskGap(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalGskGap = ma_OptionalGskGap(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGskGap.Get al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGSK2Count() As Long
On Error GoTo ErrHandler

  OptionalGSK2Count = UBound(ma_OptionalGSK_Id2) + 1
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSK2Count.Get")
End Property

Public Property Let OptionalGSK_Id2(ByVal al_Idx As Long, ByVal av_PRD_Id As Variant)
On Error GoTo ErrHandler

  ma_OptionalGSK_Id2(al_Idx) = av_PRD_Id
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSK_Id2.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGSK_Id2(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalGSK_Id2 = ma_OptionalGSK_Id2(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGSK_Id2.Get al_Idx=" & al_Idx)
End Property

Public Property Let OptionalGskGap2(ByVal al_Idx As Long, ByVal ad_Value As Variant)
On Error GoTo ErrHandler

  ma_OptionalGskGap2(al_Idx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGskGap2.Let al_Idx=" & al_Idx)
End Property

Public Property Get OptionalGskGap2(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  OptionalGskGap2 = ma_OptionalGskGap2(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("OptionalGskGap2.Get al_Idx=" & al_Idx)
End Property

Public Property Get DefaultInlayPerfDec(ByVal al_Idx As Long) As Variant
On Error GoTo ErrHandler

  DefaultInlayPerfDec = ma_DefaultInlayPerfDec(al_Idx)
  Exit Property
ErrHandler:
  Call ErrorHandler("DefaultInlayPerfDec.Get al_Idx=" & al_Idx)
End Property

Public Property Get DefaultInlayPerfDecCount() As Long
On Error GoTo ErrHandler

  DefaultInlayPerfDecCount = UBound(ma_DefaultInlayPerfDec) + 1
  Exit Property
ErrHandler:
  Call ErrorHandler("DefaultInlayPerfDecCount.Get")
End Property

Public Sub InitInlayDec(ByRef ad_InlayDec As Double)
On Error GoTo ErrHandler

Dim ll_Idx As Long

  If HasPerforation And (RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides) Then
    ad_InlayDec = SYS_InlayDec1
    For ll_Idx = 0 To DefaultInlayPerfDecCount - 1
      If PRF_Id = ma_DefaultInlayPerfDec(ll_Idx)(0) Then
        ad_InlayDec = ma_DefaultInlayPerfDec(ll_Idx)(1)
      End If
    Next
  Else
    ad_InlayDec = SYS_InlayDec2
    For ll_Idx = 0 To DefaultInlayPerfDecCount - 1
      If PRF_Id = ma_DefaultInlayPerfDec(ll_Idx)(0) Then
        ad_InlayDec = ma_DefaultInlayPerfDec(ll_Idx)(2)
      End If
    Next
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitInlayDec.Get")
End Sub

Public Function HasOptionalGasket() As Boolean
On Error GoTo ErrHandler

Dim ll_GskIdx As Long
Dim le_SideIdx As eDPCSide
Dim lb_Found As Boolean

  HasOptionalGasket = False
  For ll_GskIdx = 0 To OptionalGSKCount - 1
    lb_Found = True
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If StrComp(GSK_Id(le_SideIdx), OptionalGSK_Id(ll_GskIdx)(le_SideIdx), vbTextCompare) <> 0 Then
        lb_Found = False
        Exit For
      End If
    Next
    If lb_Found Then
      HasOptionalGasket = True
      Exit For
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasOptionalGasket")
End Function

Public Function HasOptionalGasket2() As Boolean
On Error GoTo ErrHandler

Dim ll_GskIdx As Long
Dim le_SideIdx As eDPCSide
Dim lb_Found As Boolean

  HasOptionalGasket2 = False
  For ll_GskIdx = 0 To OptionalGSKCount - 1
    lb_Found = True
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If StrComp(GSK_Id(le_SideIdx), OptionalGSK_Id(ll_GskIdx)(le_SideIdx), vbTextCompare) <> 0 Then
        lb_Found = False
        Exit For
      End If
    Next
    If lb_Found Then
      HasOptionalGasket2 = True
      Exit For
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasOptionalGasket")
End Function

Public Function HasOptionalGap() As Boolean
On Error GoTo ErrHandler

Dim ll_GskIdx As Long
Dim le_SideIdx As eDPCSide
Dim lb_Found As Boolean

  HasOptionalGap = False
  lb_Found = False
  For ll_GskIdx = 0 To OptionalGSKCount - 1
    lb_Found = True
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If RPL_Gap(le_SideIdx) <> OptionalGskGap(ll_GskIdx)(le_SideIdx) Then
        lb_Found = False
        Exit For
      End If
    Next
    If lb_Found Then
      HasOptionalGap = True
      Exit For
    End If
  Next
  If Not lb_Found Then
    For ll_GskIdx = 0 To OptionalGSK2Count - 1
      lb_Found = True
      For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
        If RPL_Gap(le_SideIdx) <> OptionalGskGap2(ll_GskIdx)(le_SideIdx) Then
          lb_Found = False
          Exit For
        End If
      Next
      If lb_Found Then
        HasOptionalGap = True
        Exit For
      End If
    Next
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasOptionalGap")
End Function

Public Function HasDefaultGap() As Boolean
On Error GoTo ErrHandler

Dim lb_DefGap As Boolean
Dim le_SideIdx As eDPCSide
  
  lb_DefGap = False
  If Not (mo_TempProduct Is Nothing) Then
    lb_DefGap = True
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If RPL_Gap(le_SideIdx) <> mo_TempProduct.RPL_Gap(le_SideIdx) Then
        lb_DefGap = False
        Exit For
      End If
    Next
  End If
  HasDefaultGap = lb_DefGap
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultGap")
End Function

Public Function HasSystemDefaultGap() As Boolean
On Error GoTo ErrHandler

Dim le_SideIdx As eDPCSide
  
  HasSystemDefaultGap = True
  For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If (RPL_Gap(le_SideIdx) < SYS_GapMin(le_SideIdx)) Or (RPL_Gap(le_SideIdx) > SYS_GapMax(le_SideIdx)) Then
      HasSystemDefaultGap = False
      Exit For
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasSystemDefaultGap")
End Function

Public Function HasOptionalBending() As Boolean
On Error GoTo ErrHandler

Dim ll_BndIdx As Long
Dim le_SideIdx As eDPCSide
Dim lb_Found As Boolean

  HasOptionalBending = False
  For ll_BndIdx = 0 To OptionalBNDCount - 1
    lb_Found = True
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If StrComp(BND_Id(le_SideIdx), OptionalBND_Id(ll_BndIdx)(le_SideIdx), vbTextCompare) <> 0 Then
        lb_Found = False
        Exit For
      End If
    Next
    If lb_Found Then
      HasOptionalBending = True
      Exit For
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasOptionalBending")
End Function

Public Function IsDefaultBendingOn(ByVal ae_SideIdx As eDPCSide) As Boolean
On Error GoTo ErrHandler

  IsDefaultBendingOn = False
  If Not (mo_TempProduct Is Nothing) Then
    IsDefaultBendingOn = StrComp(BND_Id(ae_SideIdx), mo_TempProduct.BND_Id(ae_SideIdx), vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsDefaultBendingOn")
End Function

Public Function HasDefaultBending() As Boolean
On Error GoTo ErrHandler

Dim le_SideIdx As eDPCSide

  HasDefaultBending = LEV_Id = eDPCLevel.lvStandard
  If Not (mo_TempProduct Is Nothing) Then
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If Not IsDefaultBendingOn(le_SideIdx) Then
        Exit Function
      End If
    Next
    HasDefaultBending = True
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultBending")
End Function

Public Function IsDefaultGasketOn(ByVal ae_SideIdx As eDPCSide) As Boolean
On Error GoTo ErrHandler

  IsDefaultGasketOn = False
  If Not (mo_TempProduct Is Nothing) Then
    IsDefaultGasketOn = StrComp(GSK_Id(ae_SideIdx), mo_TempProduct.GSK_Id(ae_SideIdx), vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsDefaultGasketOn")
End Function

Public Function HasDefaultGasket() As Boolean
On Error GoTo ErrHandler

Dim le_SideIdx As eDPCSide

  HasDefaultGasket = False
  If Not (mo_TempProduct Is Nothing) Then
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If Not IsDefaultGasketOn(le_SideIdx) Then
        Exit Function
      End If
    Next
    HasDefaultGasket = True
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultBending")
End Function

Public Function IsDefaultSpacerOn(ByVal ae_SideIdx As eDPCSide) As Boolean
On Error GoTo ErrHandler

  IsDefaultSpacerOn = False
  If Not (mo_TempProduct Is Nothing) Then
    IsDefaultSpacerOn = StrComp(GSK_Id2(ae_SideIdx), mo_TempProduct.GSK_Id2(ae_SideIdx), vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsDefaultSpacerOn")
End Function

Public Function HasDefaultSpacer() As Boolean
On Error GoTo ErrHandler

Dim le_SideIdx As eDPCSide

  HasDefaultSpacer = False
  If Not (mo_TempProduct Is Nothing) Then
    For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If Not IsDefaultSpacerOn(le_SideIdx) Then
        Exit Function
      End If
    Next
    HasDefaultSpacer = True
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultSpacer")
End Function

Public Function HasDefaultCoating() As Boolean
On Error GoTo ErrHandler

  HasDefaultCoating = False
  If Not (mo_TempProduct Is Nothing) Then
    HasDefaultCoating = StrComp(COA_Id, mo_TempProduct.COA_Id, vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultCoating")
End Function

Public Function HasDefaultPacking() As Boolean
On Error GoTo ErrHandler

  HasDefaultPacking = False
  If Not (mo_TempProduct Is Nothing) Then
    HasDefaultPacking = StrComp(PKG_Id, mo_TempProduct.PKG_Id, vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultPacking")
End Function

Public Function HasDefaultPerforation() As Boolean
On Error GoTo ErrHandler

  HasDefaultPerforation = False
  If Not (mo_TempProduct Is Nothing) Then
    HasDefaultPerforation = StrComp(PRF_Id, mo_TempProduct.PRF_Id, vbTextCompare) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("HasDefaultPerforation")
End Function

Public Function HasNotchingClosed() As Boolean
On Error GoTo ErrHandler

  HasNotchingClosed = RPL_NClo(eDPCSide.esSideC) Or RPL_NClo(eDPCSide.esSideD) Or RPL_NClo(eDPCSide.esSideE) Or RPL_NClo(eDPCSide.esSideF)
  Exit Function
ErrHandler:
  Call ErrorHandler("HasNotchingClosed")
End Function

Public Function HasSideVisible() As Boolean
On Error GoTo ErrHandler

  HasSideVisible = RPL_BVis(eDPCSide.esSideC) Or RPL_BVis(eDPCSide.esSideD) Or RPL_BVis(eDPCSide.esSideE) Or RPL_BVis(eDPCSide.esSideF)
  Exit Function
ErrHandler:
  Call ErrorHandler("HasSideVisible")
End Function

Public Function IsDefaultInlay(ByVal ao_Inlay As DPC_Inlay) As Boolean
On Error GoTo ErrHandler
Dim ll_Count As Long
Dim lo_Inlay As DPC_Inlay

  IsDefaultInlay = False
  If Not mo_TempProduct Is Nothing Then
    If mo_TempProduct.ContainInlay(ao_Inlay) Then
      ll_Count = 1
      For Each lo_Inlay In Inlays
        If (StrComp(ao_Inlay.INL_Id, lo_Inlay.INL_Id, vbTextCompare) = 0) And (ao_Inlay.Idx <> lo_Inlay.Idx) Then
          ll_Count = ll_Count + 1
        End If
      Next
      IsDefaultInlay = ll_Count = 1
      Exit Function
    End If
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsDefaultInlay")
End Function

Public Property Let SYS_UnperfBorder(ByVal al_SideIdx As Long, ByVal ad_UnperfBorder As Double)
On Error GoTo ErrHandler
  mda_SYS_UnperfBorder(al_SideIdx) = ad_UnperfBorder
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_UnperfBorder.Let")
End Property

Public Property Get SYS_UnperfBorder(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  SYS_UnperfBorder = mda_SYS_UnperfBorder(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_UnperfBorder.Get")
End Property

Public Property Let RPL_UBor(ByVal al_SideIdx As Long, ByVal ad_UnperfBorder As Double)
On Error GoTo ErrHandler
  mda_RPL_UBor(al_SideIdx) = ad_UnperfBorder
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UBor.Let")
End Property

Public Property Get RPL_UBor(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_UBor = mda_RPL_UBor(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UBor.Get")
End Property

Public Property Let RPL_UBoW(ByVal al_SideIdx As Long, ByVal ad_UnperfBorder As Double)
On Error GoTo ErrHandler
  mda_RPL_UBoW(al_SideIdx) = ad_UnperfBorder
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UBoW")
End Property

Public Property Get RPL_UBoW(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_UBoW = mda_RPL_UBoW(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UBoW.Get")
End Property

Public Property Get PRF_Width() As Double
On Error GoTo ErrHandler
Dim ld_Width As Double

  ld_Width = RPL_PanB
  If RPL_UBor(eDPCSide.esSideC) > 0 Then ld_Width = ld_Width - RPL_UBor(eDPCSide.esSideC)
  If RPL_UBor(eDPCSide.esSideD) > 0 Then ld_Width = ld_Width - RPL_UBor(eDPCSide.esSideD)
  PRF_Width = ld_Width
  Exit Property
ErrHandler:
  Call ErrorHandler("PRF_Width.Get")
End Property

Public Property Let RPL_Gap(ByVal al_SideIdx As Long, ByVal ad_Gap As Double)
On Error GoTo ErrHandler
  
  mda_RPL_Gap(al_SideIdx) = ad_Gap
  Call RecalcPanelSize
  Call ResetPanelQtyPrice(PanelQty, QtyType)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_Gap.Let")
End Property

Public Property Get RPL_Gap(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_Gap = mda_RPL_Gap(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_Gap.Get")
End Property

Public Property Let SYS_GapMin(ByVal al_SideIdx As Long, ByVal ad_Gap As Double)
On Error GoTo ErrHandler
  mda_SYS_GapMin(al_SideIdx) = ad_Gap
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_GapMin.Let")
End Property

Public Property Get SYS_GapMin(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  SYS_GapMin = mda_SYS_GapMin(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_GapMin.Get")
End Property

Public Property Let SYS_GapMax(ByVal al_SideIdx As Long, ByVal ad_Gap As Double)
On Error GoTo ErrHandler
  mda_SYS_GapMax(al_SideIdx) = ad_Gap
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_GapMax.Let")
End Property

Public Property Get SYS_GapMax(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  SYS_GapMax = mda_SYS_GapMax(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_GapMax.Get")
End Property

Public Property Let SYS_AllowG(ByVal al_SideIdx As Long, ByVal ae_value As eDPCSystemAllowGasket)
On Error GoTo ErrHandler
  mea_SYS_AllowG(al_SideIdx) = ae_value
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_AllowG.Let")
End Property

Public Property Get SYS_AllowG(ByVal al_SideIdx As Long) As eDPCSystemAllowGasket
On Error GoTo ErrHandler
  SYS_AllowG = mea_SYS_AllowG(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("SYS_AllowG.Get")
End Property

Public Function IsGasketAllowed() As Boolean
On Error GoTo ErrHandler

Dim le_Side As eDPCSide

  For le_Side = eDPCSide.esSideC To eDPCSide.esSideF
    If IsGasketAllowedOn(le_Side) Then
      IsGasketAllowed = True
      Exit Function
    End If
  Next
  IsGasketAllowed = False
  Exit Function
ErrHandler:
  Call ErrorHandler("IsGasketAllowed")
End Function

Public Function IsGasketAllowedOn(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  IsGasketAllowedOn = (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sdGasket) Or _
                      (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sgGasketAndSpacer) Or _
                      (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sgGasketOrSpacer)
  Exit Function
ErrHandler:
  Call ErrorHandler("IsGasketAllowedOn")
End Function

Public Function IsSpacerAllowed() As Boolean
On Error GoTo ErrHandler

Dim le_Side As eDPCSide

  For le_Side = eDPCSide.esSideC To eDPCSide.esSideF
    If IsSpacerAllowedOn(le_Side) Then
      IsSpacerAllowed = True
      Exit Function
    End If
  Next
  IsSpacerAllowed = False
  Exit Function
ErrHandler:
  Call ErrorHandler("IsSpacerAllowed")
End Function

Public Function IsSpacerAllowedOn(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  IsSpacerAllowedOn = (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sdSpacer) Or _
                      (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sgGasketAndSpacer) Or _
                      (SYS_AllowG(al_SideIdx) = eDPCSystemAllowGasket.sgGasketOrSpacer)
  Exit Function
ErrHandler:
  Call ErrorHandler("IsSpacerAllowedOn")
End Function

Public Property Let RPL_H(ByVal al_SideIdx As Long, ByVal ad_Height As Double)
On Error GoTo ErrHandler
  
  mda_RPL_H(al_SideIdx) = ad_Height
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_H.Let")
End Property

Public Property Get RPL_H(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_H = mda_RPL_H(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_H.Get")
End Property

Public Property Get RPL_HA() As Double
On Error GoTo ErrHandler

  If RPL_H(eDPCSide.esSideC) >= RPL_H(eDPCSide.esSideD) Then
    RPL_HA = RPL_H(eDPCSide.esSideC)
  Else
    RPL_HA = RPL_H(eDPCSide.esSideD)
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_HA.Get")
End Property

Public Property Get RPL_HB() As Double
On Error GoTo ErrHandler

  If RPL_H(eDPCSide.esSideE) >= RPL_H(eDPCSide.esSideF) Then
    RPL_HB = RPL_H(eDPCSide.esSideE)
  Else
    RPL_HB = RPL_H(eDPCSide.esSideF)
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_HB.Get")
End Property

Public Property Get TotalHeight() As Double
On Error GoTo ErrHandler

Dim ll_SideIdx As Long
Dim ld_Height As Double

  ld_Height = 0
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If ld_Height < RPL_H(ll_SideIdx) Then
      ld_Height = RPL_H(ll_SideIdx)
    End If
  Next
  TotalHeight = ld_Height
  Exit Property
ErrHandler:
  Call ErrorHandler("TotalHeight.Get")
End Property

Public Property Let BND_CanVi(ByVal al_SideIdx As Long, ByVal ab_BND_CanVi As Boolean)
On Error GoTo ErrHandler
  mba_BND_CanVi(al_SideIdx) = ab_BND_CanVi
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_CanVi.Let")
End Property

Public Property Get BND_CanVi(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  BND_CanVi = mba_BND_CanVi(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_CanVi.Get")
End Property

Public Property Let RPL_BVis(ByVal al_SideIdx As Long, ByVal ab_Visib As Boolean)
On Error GoTo ErrHandler
  mba_RPL_BVis(al_SideIdx) = ab_Visib
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_BVis.Let")
End Property

Public Property Get RPL_BVis(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  RPL_BVis = mba_RPL_BVis(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_BVis.Get")
End Property

Public Property Let RPL_NClo(ByVal al_SideIdx As Long, ByVal ab_Closed As Boolean)
On Error GoTo ErrHandler
  mba_RPL_NClo(al_SideIdx) = ab_Closed
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_NClo.Let")
End Property

Public Property Get RPL_NClo(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  RPL_NClo = mba_RPL_NClo(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_NClo.Get")
End Property

Public Property Let BND_UMin(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMin(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin.Let")
End Property

Public Property Get BND_UMin(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMin = mda_BND_UMin(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin.Get")
End Property

Public Property Let BND_UMax(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMax(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax.Let")
End Property

Public Property Get BND_UMax(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMax = mda_BND_UMax(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax.Get")
End Property

Public Property Let BND_IsCus(ByVal al_SideIdx As Long, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
  mba_BND_IsCus(al_SideIdx) = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_IsCus.Let")
End Property

Public Property Get BND_IsCus(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  BND_IsCus = mba_BND_IsCus(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_IsCus.Get")
End Property

Public Property Let BND_HasH(ByVal al_SideIdx As Long, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
  mba_BND_HasH(al_SideIdx) = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasH.Let")
End Property

Public Property Get BND_HasH(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  BND_HasH = mba_BND_HasH(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasH.Get")
End Property

Public Property Let BND_HasU(ByVal al_SideIdx As Long, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
  mba_BND_HasU(al_SideIdx) = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasU.Let")
End Property

Public Property Get BND_HasU(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  BND_HasU = mba_BND_HasU(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasU.Get")
End Property

Public Property Let BND_HasS(ByVal al_SideIdx As Long, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
  mba_BND_HasS(al_SideIdx) = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasS.Let")
End Property

Public Property Get BND_HasS(ByVal al_SideIdx As Long) As Boolean
On Error GoTo ErrHandler
  BND_HasS = mba_BND_HasS(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HasS.Get")
End Property

Public Property Let BND_S(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_S(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_S.Let")
End Property

Public Property Get BND_S(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_S = mda_BND_S(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_S.Get")
End Property

Public Property Let BND_H(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_H(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_H.Let")
End Property

Public Property Get BND_H(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_H = mda_BND_H(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_H.Get")
End Property

Public Property Let BND_HMin1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_HMin1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMin1.Let")
End Property

Public Property Get BND_HMin1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_HMin1 = mda_BND_HMin1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMin1.Get")
End Property

Public Property Let BND_HMax1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_HMax1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMax1.Let")
End Property

Public Property Get BND_HMax1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_HMax1 = mda_BND_HMax1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMax1.Get")
End Property

Public Property Let BND_UMin1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMin1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin1.Let")
End Property

Public Property Get BND_UMin1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMin1 = mda_BND_UMin1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin1.Get")
End Property

Public Property Let BND_UMax1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMax1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax1.Let")
End Property

Public Property Get BND_UMax1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMax1 = mda_BND_UMax1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax1.Get")
End Property

Public Property Let BND_SMin1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_SMin1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMin1.Let")
End Property

Public Property Get BND_SMin1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_SMin1 = mda_BND_SMin1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMin1.Get")
End Property

Public Property Let BND_SMax1(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_SMax1(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMax1.Let")
End Property

Public Property Get BND_SMax1(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_SMax1 = mda_BND_SMax1(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMax1.Get")
End Property

Public Property Let BND_HMin2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_HMin2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMin2.Let")
End Property

Public Property Get BND_HMin2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_HMin2 = mda_BND_HMin2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMin2.Get")
End Property

Public Property Let BND_HMax2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_HMax2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMax2.Let")
End Property

Public Property Get BND_HMax2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_HMax2 = mda_BND_HMax2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_HMax2.Get")
End Property

Public Property Let BND_UMin2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMin2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin2.Let")
End Property

Public Property Get BND_UMin2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMin2 = mda_BND_UMin2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMin2.Get")
End Property

Public Property Let BND_UMax2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_UMax2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax2.Let")
End Property

Public Property Get BND_UMax2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_UMax2 = mda_BND_UMax2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_UMax2.Get")
End Property

Public Property Let BND_SMin2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_SMin2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMin2.Let")
End Property

Public Property Get BND_SMin2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_SMin2 = mda_BND_SMin2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMin2.Get")
End Property

Public Property Let BND_SMax2(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_SMax2(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMax2.Let")
End Property

Public Property Get BND_SMax2(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_SMax2 = mda_BND_SMax2(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_SMax2.Get")
End Property

Public Property Let BND_MatFct(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_BND_MatFct(al_SideIdx) = ad_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_MatFct.Let")
End Property

Public Property Get BND_MatFct(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  BND_MatFct = mda_BND_MatFct(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("BND_MatFct.Get")
End Property

Public Property Let RPL_U(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_RPL_U(al_SideIdx) = ad_Value
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_U.Let")
End Property

Public Property Get RPL_U(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_U = mda_RPL_U(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_U.Get")
End Property

Public Property Let RPL_UMin(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_RPL_UMin(al_SideIdx) = ad_Value
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UMin.Let")
End Property

Public Property Get RPL_UMin(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_UMin = mda_RPL_UMin(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UMin.Get")
End Property

Public Property Let RPL_UMax(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_RPL_UMax(al_SideIdx) = ad_Value
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UMax.Let")
End Property

Public Property Get RPL_UMax(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_UMax = mda_RPL_UMax(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_UMax.Get")
End Property

Public Property Let RPL_S(ByVal al_SideIdx As Long, ByVal ad_Value As Double)
On Error GoTo ErrHandler
  mda_RPL_S(al_SideIdx) = ad_Value
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_S.Let")
End Property

Public Property Get RPL_S(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  RPL_S = mda_RPL_S(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_S.Get")
End Property

Public Function IsQtyMatchingPU() As Boolean
On Error GoTo ErrHandler
  
  IsQtyMatchingPU = True
  If RPL_PU > 0 Then
    IsQtyMatchingPU = (PanelQtyPCS Mod RPL_PU) = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IsQtyMatchingPU")
End Function

Public Function GetCorrectPUQtyForPCS() As Double
On Error GoTo ErrHandler

Dim ll_QtyMod As Long
Dim ll_QtyPCS As Long

  ll_QtyPCS = PanelQtyPCS
  If RPL_PU > 0 Then
    ll_QtyMod = ll_QtyPCS Mod RPL_PU
    If ll_QtyMod > 0 Then
      ll_QtyPCS = ll_QtyPCS + (RPL_PU - ll_QtyMod)
    End If
  End If
  GetCorrectPUQtyForPCS = ll_QtyPCS
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCorrectPUQtyForPCS")
End Function

Public Function GetCorrectPUQtyForM2() As Double
On Error GoTo ErrHandler

  GetCorrectPUQtyForM2 = mo_Tools.ToQtyM2(GetCorrectPUQtyForPCS, ModuleSurface)
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCorrectPUQtyForM2")
End Function

Public Function CheckAllScreen() As Collection
On Error GoTo ErrHandler

Dim lo_ErrCol As New Collection
Dim lo_ScrCol As Collection
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psPanel)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psBending)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psPerforation)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psGasket)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psCoating)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psInlay)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psCutout)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psLoudspeaker)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psVentilation)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psPacking)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  
  Set lo_ScrCol = CheckScreen(eDPCScreen.psOption)
  Call mo_Tools.CopyCollection(lo_ScrCol, lo_ErrCol)
  Call mo_Tools.ClearCollection(lo_ScrCol)
  Set lo_ScrCol = Nothing
  Set CheckAllScreen = lo_ErrCol
  Exit Function
ErrHandler:
  Call ErrorHandler("CheckAllScreen")
End Function

Public Function CheckScreen(ByVal ae_Screen As eDPCScreen) As Collection
On Error GoTo ErrHandler

Dim lo_ErrCol As New Collection

  Select Case ae_Screen
  Case eDPCScreen.psPanel
    Call CheckRectPanel(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psBending
    Call CheckBending(lo_ErrCol)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psPerforation
    Call CheckPerforation(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psGasket
    Call CheckGasket(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psCoating
    Call CheckCoating(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psInlay
    Call CheckInlay(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psCutout
    Call CheckCutout(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psLoudspeaker
    Call CheckLoudspeaker(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psVentilation
    Call CheckVentilation(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psPacking
    Call CheckPacking(lo_ErrCol)
    Call CheckPrice(lo_ErrCol, ae_Screen)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case eDPCScreen.psOption
    Call CheckOption(lo_ErrCol)
    Call SetScreenErrorType(ae_Screen, GetErrorType(lo_ErrCol))
  Case Else
    Err.Raise ArmErr.InvalidArgument, "ae_Screen", "Invalid screen: " & ae_Screen
  End Select
  Call CopyErrorText(lo_ErrCol)
  Set lo_ErrCol = ErrorOrder(lo_ErrCol)
  If ae_Screen = eDPCScreen.psPanelSummary Then
    Set Errors = lo_ErrCol
  End If
  Set CheckScreen = lo_ErrCol
  Exit Function
ErrHandler:
  Call ErrorHandler("CheckScreen")
End Function

Private Sub CheckRectPanel(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler
Dim ll_SideIdx As Long

  
  If VEN_Id = "" Then
    Call AddCheckError(eDPCError.erMandatoryPlantVendor, ao_ErrCol, "$fieldname$", lbl_PlantVendor)
  End If
  
  If SHP_Id = 0 Then
    Call AddCheckError(eDPCError.erMandatoryShipPoint, ao_ErrCol, "$fieldname$", lbl_ShipPoint)
  End If
  
  If OFD_WshDat = 0 Then
    Call AddCheckError(eDPCError.erMandatoryWishDate, ao_ErrCol)
  End If
  
  If IsStandard Then
    If Not IsQtyMatchingPU Then
      Call AddCheckError(eDPCError.erQtyPUNotMatch, ao_ErrCol)
    End If
  End If
  
  If IsStandard And (RPL_MQty > 0) Then
    If (PanelQtyM2 > RPL_MQty) Then
      Call AddCheckError(eDPCError.erMaxOrderQty, ao_ErrCol)
    End If
  End If
  
  If RPL_ModA <= 0 Then
    Call AddCheckError(eDPCError.erMandatoryModuleA, ao_ErrCol)
  End If
  If RPL_ModB <= 0 Then
    Call AddCheckError(eDPCError.erMandatoryModuleB, ao_ErrCol)
  End If
  If RPL_PanA <= 0 Then
    Call AddCheckError(eDPCError.erMandatoryPanelA, ao_ErrCol)
  End If
  If RPL_PanB <= 0 Then
    Call AddCheckError(eDPCError.erMandatoryPanelB, ao_ErrCol)
  End If
  
  If (LEV_Id = eDPCLevel.lvCustom) Then
    If (RPL_PanA < SYS_AMin) Or (RPL_PanA > SYS_AMax) Then
      Call AddCheckError(eDPCError.erPanelALimit, ao_ErrCol, Array("$Min$", "$Max$"), Array(SYS_AMin, SYS_AMax))
    End If
    If (RPL_PanB < SYS_BMin) Or (RPL_PanB > SYS_BMax) Then
      Call AddCheckError(eDPCError.erPanelBLimit, ao_ErrCol, Array("$Min$", "$Max$"), Array(SYS_BMin, SYS_BMax))
    End If
    
    If (RPL_ModB < RPL_PanB) Or (RPL_ModA < RPL_PanA) Then
      Call AddCheckError(eDPCError.erModuleLessPanel, ao_ErrCol)
    End If
    
    If Not RPL_StdMa Then
      Call AddCheckError(eDPCError.erMaterialNotStandard, ao_ErrCol)
    End If
    
    If Not IsFixed Then
      If (RPL_ModA < RPL_ModB) Or (RPL_PanA < RPL_PanB) Then
        Call AddCheckError(eDPCError.erPanelModuleALessB, ao_ErrCol)
      End If
    
      If ((RPL_ModB - RPL_PanB) <> GapA) Then
        Call AddCheckError(eDPCError.erGapSizeInvalid, ao_ErrCol)
      End If
      If ((RPL_ModA - RPL_PanA) <> GapB) Then
        Call AddCheckError(eDPCError.erGapSizeInvalid, ao_ErrCol)
      End If
    End If
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If (RPL_Gap(ll_SideIdx) < 0) Then
        Call AddCheckError(eDPCError.erGapSizeInvalid, ao_ErrCol)
      End If
    Next
    
    If Not HasSystemDefaultGap Then
      Call AddCheckError(eDPCError.erGapSizeNotStandard, ao_ErrCol)
    End If
  End If
  
  If (PanelQtyM2 <= 0) Or (PanelQtyPCS <= 0) Then
    Call AddCheckError(eDPCError.erMandatoryQty, ao_ErrCol)
  End If
  If RPL_Thick <= 0 Then
    Call AddCheckError(eDPCError.erMandatoryThickness, ao_ErrCol)
  End If
  If MAT_Id = 0 Then
    Call AddCheckError(eDPCError.erMandatoryMaterial, ao_ErrCol)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckRectPanel")
End Sub

Public Sub CheckBending(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler
Dim ll_SideIdx As Long

  If (Not IsBendingOn(eDPCSide.esSideC)) Or (Not IsBendingOn(eDPCSide.esSideD)) Or (Not IsBendingOn(eDPCSide.esSideE)) Or (Not IsBendingOn(eDPCSide.esSideF)) Then
    Call AddCheckError(eDPCError.erMandatoryBendings, ao_ErrCol)
  End If
  
  If (LEV_Id = eDPCLevel.lvEngineered) And IsProduction Then
    If (RPL_CutA <= 0) Or (RPL_CutB <= 0) Then
      Call AddCheckError(eDPCError.erMandatoryCutAB, ao_ErrCol)
    End If
    If ((RPL_CoWMin <= 0) Or (RPL_CoWMax <= 0)) And IsProduction Then
      Call AddCheckError(eDPCError.erMandatoryCoilWMinMax, ao_ErrCol)
    End If
  End If
  
  If (Not IsStandard) And (LEV_Id <> eDPCLevel.lvEngineered) Then
    If Not HasDefaultBending Then
      If HasOptionalBending Then
        Call AddCheckError(eDPCError.erBendingOptional, ao_ErrCol)
      Else
        Call AddCheckError(eDPCError.erBendingNotDefault, ao_ErrCol)
        If Not mo_TempProduct Is Nothing Then
          If StrComp(PRD_Name, mo_TempProduct.PRD_Name, vbTextCompare) = 0 Then
            Call AddCheckError(eDPCError.erBendingPrdChangeDesc, ao_ErrCol, "$PRD_Name$", PRD_Name)
          End If
        End If
      End If
    End If
  
    If (Not RPL_SBndA) Or (Not RPL_SBndB) Then
      Call AddCheckError(eDPCError.erBendingSizeNotDefault, ao_ErrCol)
    End If
    
    'If RPL_IsOut = eDPCPanelInOut.ioUndef Then
    '  Call AddCheckError(eDPCError.erInOutMandatory, ao_ErrCol)
    'End If
  
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If RPL_BVis(ll_SideIdx) Then
        Call AddCheckError(eDPCError.erPanelSideVisible, ao_ErrCol)
        Exit For
      End If
    Next
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If RPL_NClo(ll_SideIdx) Then
        Call AddCheckError(eDPCError.erPanelNotchingClosed, ao_ErrCol)
        Exit For
      End If
    Next
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If (Not RPL_NClo(ll_SideIdx)) And RPL_BVis(ll_SideIdx) Then
        Call AddCheckError(eDPCError.erPanelNotchingWrong, ao_ErrCol)
        Exit For
      End If
    Next
    
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckBending")
End Sub


Private Sub CheckGasket(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim ll_SideIdx As Long
Dim lb_AllowGasketSpacerCombination As Boolean

  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If GTT_Selected(ll_SideIdx) And (Not IsGasketOn(ll_SideIdx)) Then
      Call AddCheckError(eDPCError.erMandatoryGasketType, ao_ErrCol)
    End If
  Next
  
  If (RPL_GskDe = eDPCGasketDelivery.gdInstalled) And (Not HasGasket) Then
      Call AddCheckError(eDPCError.erMandatoryGasketType, ao_ErrCol)
  End If
  
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If GTT_Selected2(ll_SideIdx) And (Not IsSpacerOn(ll_SideIdx)) Then
      Call AddCheckError(eDPCError.erMandatorySpacerType, ao_ErrCol)
    End If
  Next
  
  If (RPL_GskDe = eDPCGasketDelivery.gdUndef) Then
    Call AddCheckError(eDPCError.erGasketDeliveryMandatory, ao_ErrCol)
  End If
  
  If (RPL_SpcDe = eDPCSpacerDelivery.sdUndef) Then
    Call AddCheckError(eDPCError.erSpacerDeliveryMandatory, ao_ErrCol)
  End If
  
  If (Not IsStandard) Then
    lb_AllowGasketSpacerCombination = False
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If (RPL_Gap(ll_SideIdx) > 0) And (Not IsGasketOn(ll_SideIdx)) And (Not IsSpacerOn(ll_SideIdx)) Then
        Call AddCheckError(eDPCError.erGapEmpty, ao_ErrCol, "$Side$", mv_Edge(ll_SideIdx))
      End If
      
      If IsGasketOn(ll_SideIdx) And (Not IsGasketAllowedOn(ll_SideIdx)) Then
        Call AddCheckError(eDPCError.erGasketNotAllowed, ao_ErrCol, "$Side$", mv_Edge(ll_SideIdx))
      End If
      
      If IsSpacerOn(ll_SideIdx) And (Not IsSpacerAllowedOn(ll_SideIdx)) Then
        Call AddCheckError(eDPCError.erSpacerNotAllowed, ao_ErrCol, "$Side$", mv_Edge(ll_SideIdx))
      End If
      
      If (IsGasketOn(ll_SideIdx) And IsSpacerOn(ll_SideIdx)) And (SYS_AllowG(ll_SideIdx) <> eDPCSystemAllowGasket.sgGasketAndSpacer) Then
        Call AddCheckError(eDPCError.erGasketSpacerCombination, ao_ErrCol)
      End If
      
      If (SYS_AllowG(ll_SideIdx) = eDPCSystemAllowGasket.sgGasketAndSpacer) Then
        lb_AllowGasketSpacerCombination = True
      End If
    Next
    
    If (Not lb_AllowGasketSpacerCombination) And _
       ((RPL_GskDe > eDPCGasketDelivery.gdNoneGasket) And (RPL_SpcDe > eDPCSpacerDelivery.sdNoneSpacer)) Then
      Call AddCheckError(eDPCError.erGasketSpacerCombination, ao_ErrCol)
    End If
      
    If ((RPL_ModB - RPL_PanB) <> GapA) Then
      Call AddCheckError(eDPCError.erGapSizeInvalid, ao_ErrCol)
    End If

    If ((RPL_ModA - RPL_PanA) <> GapB) Then
      Call AddCheckError(eDPCError.erGapSizeInvalid, ao_ErrCol)
    End If
  
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If (RPL_Gap(ll_SideIdx) <> GSK_Gap(ll_SideIdx)) And (GSK_Gap(ll_SideIdx) <> 0) Then
        Call AddCheckError(eDPCError.erGasketSizeInvalid, ao_ErrCol)
      End If
    Next
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      If (RPL_Gap(ll_SideIdx) <> GSK_Gap2(ll_SideIdx)) And (GSK_Gap2(ll_SideIdx) <> 0) Then
        Call AddCheckError(eDPCError.erSpacerSizeInvalid, ao_ErrCol)
      End If
    Next
  
    If LEV_Id <> eDPCLevel.lvEngineered Then
      If ((RPL_SpcDe = eDPCSpacerDelivery.sdUndef) And HasSpacer) Then
        Call AddCheckError(eDPCError.erSpacerInstallPlant, ao_ErrCol)
      End If
    
      Dim ls_GSK_Id1 As String
      ls_GSK_Id1 = ""
      For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
        If ls_GSK_Id1 = "" And IsGasketOn(ll_SideIdx) Then
          ls_GSK_Id1 = GSK_Id(ll_SideIdx)
        End If
        If IsGasketOn(ll_SideIdx) Then
          If GSK_Id(ll_SideIdx) <> ls_GSK_Id1 Then
            Call AddCheckError(eDPCError.erGasketTypeDifferent, ao_ErrCol)
          End If
        End If
      Next
    
      Dim ls_GSK_Id2 As String
      ls_GSK_Id2 = ""
      For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
        If ls_GSK_Id2 = "" And IsSpacerOn(ll_SideIdx) Then
          ls_GSK_Id2 = GSK_Id2(ll_SideIdx)
        End If
        If IsSpacerOn(ll_SideIdx) Then
          If GSK_Id2(ll_SideIdx) <> ls_GSK_Id2 Then
            Call AddCheckError(eDPCError.erGasketTypeDifferent, ao_ErrCol)
          End If
        End If
      Next
      
    End If
  End If
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckGasket")
End Sub

Private Sub CheckPerforation(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

  If (Not HasPerforation) And (NoPerforation = False) Then
    Call AddCheckError(eDPCError.erPerforationMandatory, ao_ErrCol)
  ElseIf HasPerforation Then
    If PRF_MaxPW < PRF_Width Then
      Call AddCheckError(eDPCError.erPerforationWidth, ao_ErrCol)
    End If
    
    If PRF_MaxTW < RPL_CoWMin Then
      Call AddCheckError(eDPCError.erPerforationToolWidth, ao_ErrCol)
    End If
  
    If MAT_Id = Val(mo_Tools.GetAConfigData("DPC_Default_MAT1")) Then
      If (PRF_MaxST < RPL_Thick) Then
        Call AddCheckError(eDPCError.erPerforationThickness, ao_ErrCol)
      End If
    ElseIf MAT_Id = Val(mo_Tools.GetAConfigData("DPC_Default_MAT2")) Then
      If (PRF_MaxAT < RPL_Thick) Then
        Call AddCheckError(eDPCError.erPerforationThickness, ao_ErrCol)
      End If
    Else
      Call AddCheckError(eDPCError.erPerforationThickUndef, ao_ErrCol)
    End If
    
    If LEV_IdPRF = eDPCLevel.lvCustom Then
      Call AddCheckError(eDPCError.erPerforationLevel2, ao_ErrCol)
    End If
    
    If RPL_PBord = eDPCPerforationBorderType.pbUndef Then
      Call AddCheckError(eDPCError.erPerforationBorderMandatory, ao_ErrCol)
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckPerforation")
End Sub

Private Sub CheckCoating(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler
  
  If Not HasCoating Then
    Call AddCheckError(eDPCError.erCoatingMandatory, ao_ErrCol)
  End If
  
  If HasPerforation And (RPL_CoSid = eDPCCoatingExecution.ceBackSideFull) Then
    Call AddCheckError(eDPCError.erPerforationAndCorProtection, ao_ErrCol)
  End If

  If COA_IsCus Then
    Call AddCheckError(eDPCError.erCoatingCustomSelected, ao_ErrCol)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckCoating")
End Sub

Private Sub CheckInlay(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay

  If (Not HasInlay) And (NoInlay = False) Then
    Call AddCheckError(eDPCError.erInlayMandatory, ao_ErrCol)
  End If
  
  If (Not IsStandard) Then
    If HasPerforation And (Not HasInlay) Then
      Call AddCheckError(eDPCError.erInlayConsiderForPerforatedPanel, ao_ErrCol)
    End If
    
    If LEV_Id <> eDPCLevel.lvEngineered Then
      If GetInlayCount > 1 Then
        Call AddCheckError(eDPCError.erInlayMoreLayer, ao_ErrCol)
      End If
    
      If RPL_Plate Then
        Call AddCheckError(eDPCError.erTopPanelPlateSelected, ao_ErrCol)
        If RPL_PlCnt = 0 Then
          Call AddCheckError(eDPCError.erTopPanelPlateNotchRivetZero, ao_ErrCol)
        End If
      End If
    End If
  End If
  
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
      Call CheckInlayItem(ao_ErrCol, lo_Inlay)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckInlay")
End Sub

Public Sub CheckInlayItem(ByVal ao_ErrCol As Collection, ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

  If Not ao_Inlay.HasInlay Then
    Call AddCheckError(eDPCError.erInlayProductMandatory, ao_ErrCol)
  End If
  
  If LEV_Id = eDPCLevel.lvCustom Then
    If Not ao_Inlay.PIN_Std Then
      Call AddCheckError(eDPCError.erInlaySizeNotStandard, ao_ErrCol)
    End If
  
    If ao_Inlay.INL_Deliv <> ao_Inlay.PIN_Deliv Then
      Call AddCheckError(eDPCError.erInlayNotDefaultDelivery, ao_ErrCol)
    End If
    
    If ao_Inlay.INL_IsCus Then
      Call AddCheckError(eDPCError.erInlayCustomSelected, ao_ErrCol)
    End If
    
    Call CheckPriceInlay(ao_ErrCol, ao_Inlay)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckInlayItem")
End Sub

Private Sub CheckVentilation(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout

  If (Not HasVentilation) And (NoVentilation = False) Then
    Call AddCheckError(eDPCError.erVentilationMandatory, ao_ErrCol)
  End If
  For Each lo_Cutout In Cutouts
    If lo_Cutout.PCT_Type = eDPCCutoutType.eVentilation Then
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        Call CheckVentilationItem(ao_ErrCol, lo_Cutout)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckVentilation")
End Sub

Public Sub CheckVentilationItem(ByVal ao_ErrCol As Collection, ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

  Call CheckCutoutArea(ao_ErrCol, ao_Cutout)
  If Not ao_Cutout.PCT_Std Then
    Call AddCheckError(eDPCError.erVentilationNotStandard, ao_ErrCol)
  End If
  
  Call CheckPriceCutout(ao_ErrCol, ao_Cutout)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckVentilationItem")
End Sub

Private Sub CheckLoudspeaker(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
  
  If (Not HasLoudspeaker) And (NoLoudspeaker = False) Then
    Call AddCheckError(eDPCError.erLoudspeakerMandatory, ao_ErrCol)
  End If
  For Each lo_Cutout In Cutouts
    If lo_Cutout.PCT_Type = eDPCCutoutType.eLoudspeaker Then
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        Call CheckLoudspeakerItem(ao_ErrCol, lo_Cutout)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckLoudspeaker")
End Sub

Public Sub CheckLoudspeakerItem(ByVal ao_ErrCol As Collection, ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

  Call CheckCutoutArea(ao_ErrCol, ao_Cutout)
  If Not ao_Cutout.PCT_Std Then
    Call AddCheckError(eDPCError.erLoudspeakerNotStandard, ao_ErrCol)
  End If
  Call CheckPriceCutout(ao_ErrCol, ao_Cutout)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckLoudspeakerItem")
End Sub

Private Sub CheckCutout(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
    
  If (Not HasCutout) And (NoCutout = False) Then
    Call AddCheckError(eDPCError.erCutoutMandatory, ao_ErrCol)
  End If
  For Each lo_Cutout In Cutouts
    If lo_Cutout.PCT_Type = eDPCCutoutType.eCutout Then
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        Call CheckCutoutItem(ao_ErrCol, lo_Cutout)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckCutout")
End Sub

Public Sub CheckCutoutItem(ByVal ao_ErrCol As Collection, ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

  Call CheckCutoutArea(ao_ErrCol, ao_Cutout)
  Call CheckPriceCutout(ao_ErrCol, ao_Cutout)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckCutoutItem")
End Sub

Private Sub CheckCutoutArea(ByVal ao_ErrCol As Collection, ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim lo_CutoutCheck As DPC_Cutout

  If ao_Cutout.CUT_Shape = eDPCCutoutShape.eRectangular Then
    If ao_Cutout.PCT_SizeJ = 0 Then
      Call AddCheckError(eDPCError.erCutoutAreaJMandatory, ao_ErrCol)
    End If
    If ao_Cutout.PCT_SizeK = 0 Then
      Call AddCheckError(eDPCError.erCutoutAreaKMandatory, ao_ErrCol)
    End If
  ElseIf ao_Cutout.CUT_Shape = eDPCCutoutShape.eRound Then
    If ao_Cutout.PCT_SizeD = 0 Then
      Call AddCheckError(eDPCError.erCutoutAreaDMandatory, ao_ErrCol)
    End If
  Else
    Err.Raise ArmErr.InvalidArgument, "ao_Cutout.CUT_Shape", "Unknown shape code: " & ao_Cutout.CUT_Shape
  End If
  
  If (ao_Cutout.CUT_MinJ >= 0) And (ao_Cutout.Width < ao_Cutout.CUT_MinJ) Then
    Call AddCheckError(eDPCError.erCutoutAreaValueOutOfLimit, ao_ErrCol, Array("$Value$", "$Min$", "$Max$"), Array("J", ao_Cutout.CUT_MinJ, ao_Cutout.CUT_MaxJ))
  End If
  If (ao_Cutout.CUT_MaxJ > 0) And (ao_Cutout.Width > ao_Cutout.CUT_MaxJ) Then
    Call AddCheckError(eDPCError.erCutoutAreaValueOutOfLimit, ao_ErrCol, Array("$Value$", "$Min$", "$Max$"), Array("J", ao_Cutout.CUT_MinJ, ao_Cutout.CUT_MaxJ))
  End If
  If (ao_Cutout.CUT_MinK >= 0) And (ao_Cutout.Height < ao_Cutout.CUT_MinK) Then
    Call AddCheckError(eDPCError.erCutoutAreaValueOutOfLimit, ao_ErrCol, Array("$Value$", "$Min$", "$Max$"), Array("K", ao_Cutout.CUT_MinK, ao_Cutout.CUT_MaxK))
  End If
  If (ao_Cutout.CUT_MaxK > 0) And (ao_Cutout.Height > ao_Cutout.CUT_MaxK) Then
    Call AddCheckError(eDPCError.erCutoutAreaValueOutOfLimit, ao_ErrCol, Array("$Value$", "$Min$", "$Max$"), Array("K", ao_Cutout.CUT_MinK, ao_Cutout.CUT_MaxK))
  End If
  
  If ao_Cutout.right > RPL_PanA Then
    Call AddCheckError(eDPCError.erCutoutAreaOutOfPanelA, ao_ErrCol)
  End If
  If ao_Cutout.bottom > RPL_PanB Then
    Call AddCheckError(eDPCError.erCutoutAreaOutOfPanelB, ao_ErrCol)
  End If
  
  If (ao_Cutout.CUT_MinL >= 0) And (ao_Cutout.PCT_SizeL < ao_Cutout.CUT_MinL) Then
    Call AddCheckError(eDPCError.erCutoutAreaBorderMin, ao_ErrCol, Array("$Value$", "$Min$"), Array("L", ao_Cutout.CUT_MinL))
  End If
  If (ao_Cutout.CUT_MinM >= 0) And (ao_Cutout.PCT_SizeM < ao_Cutout.CUT_MinM) Then
    Call AddCheckError(eDPCError.erCutoutAreaBorderMin, ao_ErrCol, Array("$Value$", "$Min$"), Array("M", ao_Cutout.CUT_MinM))
  End If
  
  For Each lo_CutoutCheck In Cutouts
    If (lo_CutoutCheck.RowStatus <> eDPCRowStatus.rsDrop) And (ao_Cutout.Idx <> lo_CutoutCheck.Idx) Then
      If ao_Cutout.IsIntersect(lo_CutoutCheck) And (Not HasErrorID(ao_ErrCol, eDPCError.erCutoutAreaIntersect)) Then
        Call AddCheckError(eDPCError.erCutoutAreaIntersect, ao_ErrCol)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckCutoutArea")
End Sub

Private Sub CheckPacking(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

  If Not HasPacking Then
    Call AddCheckError(eDPCError.erPackingMandatory, ao_ErrCol)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckPacking")
End Sub

Private Sub CheckOption(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckOption")
End Sub

Public Sub CheckBOMItem(ByVal ao_ErrCol As Collection, ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckBOMItem")
End Sub

Public Sub CheckBORItem(ByVal ao_ErrCol As Collection, ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckBORItem")
End Sub

Private Sub CheckPrice(ByVal ao_ErrCol As Collection, ByVal ae_Screen As eDPCScreen)
On Error GoTo ErrHandler
Dim lo_Offer As DPC_OfferPos

  For Each lo_Offer In OfferPrice
    If ((lo_Offer.SCR_Id = ae_Screen) Or (ae_Screen = eDPCScreen.psPanelSummary)) And (Not lo_Offer.IsPriceFound) Then
      Select Case lo_Offer.DOF_Id
      Case eDPCOfferDetail.odPanelCost
        Call AddCheckError(eDPCError.erCostPanel, ao_ErrCol)
      Case eDPCOfferDetail.odPanelSetupChargeUnp
        If Not HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelSetupChargeUnp, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPanelSetupChargePrf
        If HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelSetupChargePrf, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPanelChangeLengthCostUnp
        If Not HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelChangeLengthUnp, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPanelChangeLengthCostPrf
        If HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelChangeLengthPrf, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPanelChangeWidthCostUnp
        If Not HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelChangeWidthUnp, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPanelChangeWidthCostPrf
        If HasPerforation Then
          Call AddCheckError(eDPCError.erCostPanelChangeWidthPrf, ao_ErrCol)
        End If
      Case eDPCOfferDetail.odPerforationCost
        Call AddCheckError(eDPCError.erCostPerforation, ao_ErrCol)
      Case eDPCOfferDetail.odGasketSurcharge
        Call AddCheckError(eDPCError.erCostSpacerGasket, ao_ErrCol)
      Case eDPCOfferDetail.odPackingCost
        Call AddCheckError(eDPCError.erCostPackaging, ao_ErrCol)
      Case eDPCOfferDetail.odInlayCost
        Call AddCheckError(eDPCError.erCostInlay, ao_ErrCol)
      Case eDPCOfferDetail.odInlaySetupCharge
        Call AddCheckError(eDPCError.erCostInlaySetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odCoatingCost
        Call AddCheckError(eDPCError.erCostCoating, ao_ErrCol)
      Case eDPCOfferDetail.odCoatingSetupCharge
        Call AddCheckError(eDPCError.erCostCoatingSetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odVentilationCost
        Call AddCheckError(eDPCError.erCostVentilation, ao_ErrCol)
      Case eDPCOfferDetail.odVentilationSetupCharge
        Call AddCheckError(eDPCError.erCostVentilationSetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odVentilationAddChangeCost
        Call AddCheckError(eDPCError.erCostVentilationAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerCost
        Call AddCheckError(eDPCError.erCostLoudspeaker, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerSetupCharge
        Call AddCheckError(eDPCError.erCostLoudspeakerSetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerAddChangeCost
        Call AddCheckError(eDPCError.erCostLoudspeakerAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutCost
        Call AddCheckError(eDPCError.erCostCutout, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutAddChangeCost
        Call AddCheckError(eDPCError.erCostCutoutAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutSetupCharge
        Call AddCheckError(eDPCError.erCostCutoutSetupChage, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutSurcharge
        Call AddCheckError(eDPCError.erCostCutoutSurcharge, ao_ErrCol)
      Case eDPCOfferDetail.odSubconstructionCost
        Call AddCheckError(eDPCError.erCostSubconstraction, ao_ErrCol)
      End Select
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckPrice")
End Sub

Private Sub CheckPriceInlay(ByVal ao_ErrCol As Collection, ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler
Dim lo_Offer As DPC_OfferPos


  For Each lo_Offer In ao_Inlay.OfferPrice
    If (Not lo_Offer.IsPriceFound) Then
      Select Case lo_Offer.DOF_Id
      Case eDPCOfferDetail.odInlayCost
        Call AddCheckError(eDPCError.erCostInlay, ao_ErrCol)
      Case eDPCOfferDetail.odInlaySetupCharge
        Call AddCheckError(eDPCError.erCostInlaySetupCharge, ao_ErrCol)
      End Select
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckPriceInlay")
End Sub

Private Sub CheckPriceCutout(ByVal ao_ErrCol As Collection, ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler
Dim lo_Offer As DPC_OfferPos


  For Each lo_Offer In ao_Cutout.OfferPrice
    If (Not lo_Offer.IsPriceFound) Then
      Select Case lo_Offer.DOF_Id
      Case eDPCOfferDetail.odVentilationCost
        Call AddCheckError(eDPCError.erCostVentilation, ao_ErrCol)
      Case eDPCOfferDetail.odVentilationSetupCharge
        Call AddCheckError(eDPCError.erCostVentilationSetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odVentilationAddChangeCost
        Call AddCheckError(eDPCError.erCostVentilationAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerCost
        Call AddCheckError(eDPCError.erCostLoudspeaker, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerSetupCharge
        Call AddCheckError(eDPCError.erCostLoudspeakerSetupCharge, ao_ErrCol)
      Case eDPCOfferDetail.odLoudspeakerAddChangeCost
        Call AddCheckError(eDPCError.erCostLoudspeakerAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutCost
        Call AddCheckError(eDPCError.erCostCutout, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutAddChangeCost
        Call AddCheckError(eDPCError.erCostCutoutAddChange, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutSetupCharge
        Call AddCheckError(eDPCError.erCostCutoutSetupChage, ao_ErrCol)
      Case eDPCOfferDetail.odCutoutSurcharge
        Call AddCheckError(eDPCError.erCostCutoutSurcharge, ao_ErrCol)
      End Select
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckPriceCutout")
End Sub

Private Function AddCheckError(ByVal ae_DPCError As eDPCError, ByVal ao_ErrCol As Collection, Optional av_PlaceHolder As Variant, Optional av_Value As Variant, Optional as_Text As String, Optional ao_Tag As Object = Nothing) As DPC_Error
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error
Dim ll_Idx As Long

  If mo_Db.Find(mc_Error, "ERR_Id", ae_DPCError) >= 0 Then
    Set lo_Error = New DPC_Error
    Set lo_Error.Tools = mo_Tools
    lo_Error.ERR_ID = ae_DPCError
    lo_Error.LEV_Id = mo_Db.GetFields(mc_Error, "LEV_Id")
    lo_Error.ERR_Type = mo_Db.GetFields(mc_Error, "ERR_Type")
    lo_Error.MsgId = mo_Db.GetFields(mc_Error, "MsgId")
    lo_Error.ERR_Ctrl = mo_Db.GetFields(mc_Error, "ERR_Ctrl")
    lo_Error.ERR_Offer = StrComp(mo_Db.GetFields(mc_Error, "ERR_Offer"), "X", vbTextCompare) = 0
    lo_Error.Message_Text = ReplaceValuePlaceholder(mo_Db.GetFields(mc_Error, "Message_Text"))
    Set lo_Error.Tag = ao_Tag
    If as_Text = "" Then
      Set lo_SavedError = GetError(ae_DPCError, ao_Tag)
      If Not lo_SavedError Is Nothing Then
        lo_Error.TXT_Text = lo_SavedError.TXT_Text
      End If
    Else
      lo_Error.TXT_Text = as_Text
    End If
    If IsArray(av_PlaceHolder) Then
      For ll_Idx = 0 To UBound(av_PlaceHolder)
        lo_Error.Message_Text = Replace(lo_Error.Message_Text, CStr(av_PlaceHolder(ll_Idx)), CStr(av_Value(ll_Idx)))
      Next
    Else
      lo_Error.Message_Text = Replace(lo_Error.Message_Text, CStr(av_PlaceHolder), CStr(av_Value))
    End If
    Call ao_ErrCol.Add(lo_Error)
    Set AddCheckError = lo_Error
  Else
    Err.Raise ArmErr.InvalidArgument, "ae_DPCError", "Unknown error/text id: " & ae_DPCError
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("AddCheckError")
End Function

Public Function IsErrorType(ByVal ao_ErrCol As Collection, ByVal al_ErrType As Long) As Boolean
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  IsErrorType = False
  For Each lo_Error In ao_ErrCol
    If lo_Error.ERR_Type = al_ErrType Then
      IsErrorType = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("IsErrorType")
End Function

Public Function HasErrorID(ByVal ao_ErrCol As Collection, ByVal al_Err_Id As Long) As Boolean
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  HasErrorID = False
  For Each lo_Error In ao_ErrCol
    If lo_Error.ERR_ID = al_Err_Id Then
      HasErrorID = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasErrorID")
End Function

'Public Function GetErrorLevel(ByVal ao_ErrCol As Collection) As Long
'On Error GoTo ErrHandler
'
'Dim lo_Error As DPC_Error
'Dim ll_ErrLevel As Long
'
'  ll_ErrLevel = eDPCLevel.lvStandard
'  For Each lo_Error In ao_ErrCol
'    If lo_Error.LEV_Id > ll_ErrLevel Then
'      ll_ErrLevel = lo_Error.LEV_Id
'    End If
'  Next
'  GetErrorLevel = ll_ErrLevel
'  Exit Function
'ErrHandler:
'  Call ErrorHandler("GetErrorLevel")
'End Function
'
Public Function GetErrorType(ByVal ao_ErrCol As Collection) As Long
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  GetErrorType = eDPCErrorType.etNone
  If IsErrorType(ao_ErrCol, eDPCErrorType.etStop) Then
    GetErrorType = eDPCErrorType.etStop
  ElseIf IsErrorType(ao_ErrCol, eDPCErrorType.etNeedApproval) Then
    GetErrorType = eDPCErrorType.etNeedApproval
  ElseIf IsErrorType(ao_ErrCol, eDPCErrorType.etInfo) Then
    GetErrorType = eDPCErrorType.etInfo
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetErrorType")
End Function

Public Function ErrorOrder(ByVal lo_ErrCol As Collection) As Collection
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim ll_ErrType As eDPCErrorType
Dim lo_ErrColOrdered As New Collection

  ll_ErrType = eDPCErrorType.etStop
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  ll_ErrType = eDPCErrorType.etNeedApproval
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  ll_ErrType = eDPCErrorType.etInfo
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  Set ErrorOrder = lo_ErrColOrdered
  Exit Function
ErrHandler:
  Call ErrorHandler("ErrorOrder")
End Function

Public Sub SetScreenErrorType(ByVal ae_Screen As eDPCScreen, ByVal ae_ErrType As eDPCErrorType)
On Error GoTo ErrHandler

  If Not mo_ScreenErr.Exists(ae_Screen) Then
    Err.Raise ArmErr.InvalidArgument, "ae_Screen", "Unknown screen: " & ae_Screen
  End If
  mo_ScreenErr.Item(ae_Screen) = ae_ErrType
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetScreenErrorType")
End Sub

Public Function GetScreenErrorType(ByVal ae_Screen As eDPCScreen) As eDPCErrorType
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim le_ErrType As eDPCErrorType

  le_ErrType = eDPCErrorType.etNone
  If ae_Screen = eDPCScreen.psPanelSummary Then
    For ll_Idx = 0 To mo_ScreenErr.Count - 1
      If mo_ScreenErr.Items(ll_Idx) > le_ErrType Then
        le_ErrType = mo_ScreenErr.Items(ll_Idx)
      End If
    Next
  Else
    If Not mo_ScreenErr.Exists(ae_Screen) Then
      Err.Raise ArmErr.InvalidArgument, "ae_Screen", "Unknown screen: " & ae_Screen
    End If
    le_ErrType = mo_ScreenErr.Item(ae_Screen)
  End If
  GetScreenErrorType = le_ErrType
  Exit Function
ErrHandler:
  Call ErrorHandler("GetScreenErrorType")
End Function

Private Function GetError(ByVal al_Err_Id As Long, ByVal ao_Tag As Object) As DPC_Error
On Error GoTo ErrHandler

Dim lo_DPC_Error As DPC_Error

  Set GetError = Nothing
  For Each lo_DPC_Error In Errors
    If (lo_DPC_Error.ERR_ID = al_Err_Id) And (lo_DPC_Error.ERR_Offer Or lo_DPC_Error.Tag Is ao_Tag) Then
      Set GetError = lo_DPC_Error
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetError")
End Function

Private Function RemoveError(ByVal al_Err_Id As Long, ByVal ao_Tag As Object) As Boolean
On Error GoTo ErrHandler

Dim ll_Idx As Long

  RemoveError = False
  For ll_Idx = 1 To Errors.Count
    If (Errors(ll_Idx).ERR_ID = al_Err_Id) And (Errors(ll_Idx).ERR_Offer Or Errors(ll_Idx).Tag Is ao_Tag) Then
      Call Errors.Remove(ll_Idx)
      RemoveError = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("RemoveError")
End Function

Public Function GetErrorText(ByVal al_Err_Id As Long, ByVal ao_Tag As Object) As String
Dim lo_DPC_Error As DPC_Error

  GetErrorText = ""
  Set lo_DPC_Error = GetError(al_Err_Id, ao_Tag)
  If Not lo_DPC_Error Is Nothing Then
    GetErrorText = lo_DPC_Error.TXT_Text
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetErrorText")
End Function

Public Sub SetErrorText(ByVal al_Err_Id As Long, ByVal as_Text As String, ByVal ao_Tag As Object)
On Error GoTo ErrHandler

Dim lo_DPC_Error As DPC_Error

  Set lo_DPC_Error = GetError(al_Err_Id, ao_Tag)
  If lo_DPC_Error Is Nothing Then
    Call AddCheckError(al_Err_Id, Errors, , , as_Text, ao_Tag)
  Else
    lo_DPC_Error.TXT_Text = as_Text
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetErrorText")
End Sub

Public Sub CopyErrorText(ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error

  For Each lo_Error In ao_ErrCollection
    Set lo_SavedError = GetError(lo_Error.ERR_ID, lo_Error.Tag)
    If Not (lo_SavedError Is Nothing) Then
      lo_Error.TXT_Text = lo_SavedError.TXT_Text
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyErrorText")
End Sub

Public Sub UpdateErrorText(ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error

  For Each lo_Error In ao_ErrCollection
    Set lo_SavedError = GetError(lo_Error.ERR_ID, lo_Error.Tag)
    If lo_SavedError Is Nothing Then
      If Trim(lo_Error.TXT_Text) <> "" Then
        Call Errors.Add(lo_Error)
      End If
    Else
      lo_SavedError.TXT_Text = lo_Error.TXT_Text
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdateErrorText")
End Sub

Public Function HasCustomInlay() As Boolean
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay

  HasCustomInlay = False
  For Each lo_Inlay In Inlays
    If lo_Inlay.INL_IsCus Then
      HasCustomInlay = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasCustomInlay")
End Function

Public Sub Load(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler
  
  Call LoadPrd(as_PRD_Id)
  Call LoadPrdCutout(as_PRD_Id)
  Call LoadPrdInlay(as_PRD_Id)
  Call LoadOptionalSystemConfig
  Call LoadPrdText(as_PRD_Id)
  'Call LoadOfferOptions(COF_Id)
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load")
End Sub

Public Sub CopyFrom(ByVal ao_DPC_Product As DPC_Product)
On Error GoTo ErrHandler

Dim ll_SideIdx As Long, ll_Idx As Long
Dim lo_CopyError As DPC_Error, lo_Error As DPC_Error
Dim lo_CopyCutout As DPC_Cutout, lo_Cutout As DPC_Cutout
Dim lo_CopyInlay As DPC_Inlay, lo_Inlay As DPC_Inlay
Dim lo_CopyOption As DPC_Option, lo_Option As DPC_Option

  PRD_Id = ao_DPC_Product.PRD_Id
  Language_Code = ao_DPC_Product.Language_Code
  CAT_Id = ao_DPC_Product.CAT_Id
  PRD_IdPar = ao_DPC_Product.PRD_IdPar
  PRD_Child = ao_DPC_Product.PRD_Child
  PRD_Code = ao_DPC_Product.PRD_Code
  PRD_CodeC = ao_DPC_Product.PRD_CodeC
  Vendor_Id = ao_DPC_Product.Vendor_Id
  Vendor_Name = ao_DPC_Product.Vendor_Name
  LEV_Id = ao_DPC_Product.LEV_Id
  IMG_Id = ao_DPC_Product.IMG_Id
  STA_Id = ao_DPC_Product.STA_Id
  CLS_Id1 = ao_DPC_Product.CLS_Id1
  CLS_Name1 = ao_DPC_Product.CLS_Name1
  CLS_Id2 = ao_DPC_Product.CLS_Id2
  CLS_Name2 = ao_DPC_Product.CLS_Name2
  CLS_Id3 = ao_DPC_Product.CLS_Id3
  CLS_Name3 = ao_DPC_Product.CLS_Name3
  CLS_Id4 = ao_DPC_Product.CLS_Id4
  CLS_Name4 = ao_DPC_Product.CLS_Name4
  CLS_Id5 = ao_DPC_Product.CLS_Id5
  CLS_Name5 = ao_DPC_Product.CLS_Name5
  CLS_Id6 = ao_DPC_Product.CLS_Id6
  CLS_Name6 = ao_DPC_Product.CLS_Name6
  CLS_Id7 = ao_DPC_Product.CLS_Id7
  CLS_Name7 = ao_DPC_Product.CLS_Name7
  CLS_Id8 = ao_DPC_Product.CLS_Id8
  CLS_Name8 = ao_DPC_Product.CLS_Name8
  
  
  SYS_Id = ao_DPC_Product.SYS_Id
  md_RPL_ModA = ao_DPC_Product.RPL_ModA
  md_RPL_ModB = ao_DPC_Product.RPL_ModB
  md_RPL_PanA = ao_DPC_Product.RPL_PanA
  md_RPL_PanB = ao_DPC_Product.RPL_PanB
  RPL_BevA = ao_DPC_Product.RPL_BevA
  RPL_BevB = ao_DPC_Product.RPL_BevB
  RPL_CorW = ao_DPC_Product.RPL_CorW
  RPL_CoWMin = ao_DPC_Product.RPL_CoWMin
  RPL_CoWMax = ao_DPC_Product.RPL_CoWMax
  RPL_CutA = ao_DPC_Product.RPL_CutA
  RPL_CutB = ao_DPC_Product.RPL_CutB
  RPL_CoilW = ao_DPC_Product.RPL_CoilW
  ParentRPL_CoWMin = ao_DPC_Product.ParentRPL_CoWMin
  ParentRPL_CoWMax = ao_DPC_Product.ParentRPL_CoWMax
  ParentRPL_CutA = ao_DPC_Product.ParentRPL_CutA
  ParentRPL_CutB = ao_DPC_Product.ParentRPL_CutB
  ParentRPL_CoilW = ao_DPC_Product.ParentRPL_CoilW
  RPL_CustDim = ao_DPC_Product.RPL_CustDim
  RPL_MatTyp = ao_DPC_Product.RPL_MatTyp
  MAT_Prefx = ao_DPC_Product.MAT_Prefx
  MAT_OrdQty = ao_DPC_Product.MAT_OrdQty
  MAT_WiStep = ao_DPC_Product.MAT_WiStep
  MAT_MaxCut = ao_DPC_Product.MAT_MaxCut
  MAT_CoilTypeIdx = ao_DPC_Product.MAT_CoilTypeIdx
  COI_Code = ao_DPC_Product.COI_Code
  COI_SpcWgh = ao_DPC_Product.COI_SpcWgh
  COI_WasteFact = ao_DPC_Product.COI_WasteFact
  COI_WasteQty = ao_DPC_Product.COI_WasteQty
  COI_IsStock = ao_DPC_Product.COI_IsStock
  
  RPL_Thick = ao_DPC_Product.RPL_Thick
  RPL_StdMa = ao_DPC_Product.RPL_StdMa
  MAT_Id = ao_DPC_Product.MAT_Id
  PKG_Id = ao_DPC_Product.PKG_Id
  LAB_Id = ao_DPC_Product.LAB_Id
  RPL_LabLng = ao_DPC_Product.RPL_LabLng
  RPL_LabLngDesc = ao_DPC_Product.RPL_LabLngDesc
  'RPL_NWgh = ao_DPC_Product.RPL_NWgh
  RPL_PU = ao_DPC_Product.RPL_PU
  RPL_MQty = ao_DPC_Product.RPL_MQty
  PRF_Id = ao_DPC_Product.PRF_Id
  RPL_SCorr = ao_DPC_Product.RPL_SCorr
  COA_Id = ao_DPC_Product.COA_Id
  COA_Code = ao_DPC_Product.COA_Code
  COA_Name = ao_DPC_Product.COA_Name
  COA_Desc = ao_DPC_Product.COA_Desc
  COA_IsCus = ao_DPC_Product.COA_IsCus
  COA_App = ao_DPC_Product.COA_App
  COA_Type = ao_DPC_Product.COA_Type
  COA_Mat = ao_DPC_Product.COA_Mat
  COA_Norm = ao_DPC_Product.COA_Norm
  COA_AppDesc = ao_DPC_Product.COA_AppDesc
  COA_TypeDesc = ao_DPC_Product.COA_TypeDesc
  COA_MatDesc = ao_DPC_Product.COA_MatDesc
  COA_NormDesc = ao_DPC_Product.COA_NormDesc
  COA_ExName = ao_DPC_Product.COA_ExName
  COA_CE = ao_DPC_Product.COA_CE
  
  RPL_CoSid = ao_DPC_Product.RPL_CoSid
  RPL_CoSidDesc = ao_DPC_Product.RPL_CoSidDesc
  RPL_StdGa = ao_DPC_Product.RPL_StdGa
  
  ' 140324 - remove copy offer attributes, because temporary product do not have it and initialized values are overwritten - cleared
  'OFD_WshDat = ao_DPC_Product.OFD_WshDat
  'OFD_ShpDat = ao_DPC_Product.OFD_ShpDat
  'OFD_DelDat = ao_DPC_Product.OFD_DelDat
  'SAE_Id = ao_DPC_Product.SAE_Id
  'SHP_Id = ao_DPC_Product.SHP_Id
  'VEN_Id = ao_DPC_Product.VEN_Id
  
  'SAE_Name = ao_DPC_Product.SAE_Name
  'SHP_Name = ao_DPC_Product.SHP_Name
  'VEN_Name = ao_DPC_Product.VEN_Name
  CURR_Code = ao_DPC_Product.CURR_Code
  
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    mda_RPL_Gap(ll_SideIdx) = ao_DPC_Product.RPL_Gap(ll_SideIdx)
    SYS_UnperfBorder(ll_SideIdx) = ao_DPC_Product.SYS_UnperfBorder(ll_SideIdx)
    SYS_GapMin(ll_SideIdx) = ao_DPC_Product.SYS_GapMin(ll_SideIdx)
    SYS_GapMax(ll_SideIdx) = ao_DPC_Product.SYS_GapMax(ll_SideIdx)
    SYS_AllowG(ll_SideIdx) = ao_DPC_Product.SYS_AllowG(ll_SideIdx)
    RPL_UBor(ll_SideIdx) = ao_DPC_Product.RPL_UBor(ll_SideIdx)
    RPL_UBoW(ll_SideIdx) = ao_DPC_Product.RPL_UBoW(ll_SideIdx)
    GTT_Selected(ll_SideIdx) = ao_DPC_Product.IsGasketOn(ll_SideIdx)
    IMG_IdGSK(ll_SideIdx) = ao_DPC_Product.IMG_IdGSK(ll_SideIdx)
    GSK_Id(ll_SideIdx) = ao_DPC_Product.GSK_Id(ll_SideIdx)
    GSK_Code(ll_SideIdx) = ao_DPC_Product.GSK_Code(ll_SideIdx)
    GSK_Name(ll_SideIdx) = ao_DPC_Product.GSK_Name(ll_SideIdx)
    GSK_Desc(ll_SideIdx) = ao_DPC_Product.GSK_Desc(ll_SideIdx)
    GSK_Gap(ll_SideIdx) = ao_DPC_Product.GSK_Gap(ll_SideIdx)
    GSK_ExName(ll_SideIdx) = ao_DPC_Product.GSK_ExName(ll_SideIdx)
    GTT_Selected2(ll_SideIdx) = ao_DPC_Product.IsSpacerOn(ll_SideIdx)
    IMG_Id2GSK(ll_SideIdx) = ao_DPC_Product.IMG_Id2GSK(ll_SideIdx)
    GSK_Id2(ll_SideIdx) = ao_DPC_Product.GSK_Id2(ll_SideIdx)
    GSK_Code2(ll_SideIdx) = ao_DPC_Product.GSK_Code2(ll_SideIdx)
    GSK_Name2(ll_SideIdx) = ao_DPC_Product.GSK_Name2(ll_SideIdx)
    GSK_Desc2(ll_SideIdx) = ao_DPC_Product.GSK_Desc2(ll_SideIdx)
    GSK_Gap2(ll_SideIdx) = ao_DPC_Product.GSK_Gap2(ll_SideIdx)
    GSK_ExName2(ll_SideIdx) = ao_DPC_Product.GSK_ExName2(ll_SideIdx)
    msa_BND_Id(ll_SideIdx) = ao_DPC_Product.BND_Id(ll_SideIdx)
    msa_BND_Name(ll_SideIdx) = ao_DPC_Product.BND_Name(ll_SideIdx)
    msa_BND_Desc(ll_SideIdx) = ao_DPC_Product.BND_Desc(ll_SideIdx)
    mla_IMG_IdBND(ll_SideIdx) = ao_DPC_Product.IMG_IdBND(ll_SideIdx)
    mla_IMG_Id2BND(ll_SideIdx) = ao_DPC_Product.IMG_Id2BND(ll_SideIdx)
    mla_IMG_IdVBND(ll_SideIdx) = ao_DPC_Product.IMG_IdVBND(ll_SideIdx)
    mla_IMG_IdV2BND(ll_SideIdx) = ao_DPC_Product.IMG_IdV2BND(ll_SideIdx)
    mba_RPL_BVis(ll_SideIdx) = ao_DPC_Product.RPL_BVis(ll_SideIdx)
    mba_RPL_NClo(ll_SideIdx) = ao_DPC_Product.RPL_NClo(ll_SideIdx)
    mba_BND_CanVi(ll_SideIdx) = ao_DPC_Product.BND_CanVi(ll_SideIdx)
    
    mda_BND_UMax(ll_SideIdx) = ao_DPC_Product.BND_UMax(ll_SideIdx)
    mda_BND_UMin(ll_SideIdx) = ao_DPC_Product.BND_UMin(ll_SideIdx)
    mda_BND_UMax1(ll_SideIdx) = ao_DPC_Product.BND_UMax1(ll_SideIdx)
    mda_BND_UMin1(ll_SideIdx) = ao_DPC_Product.BND_UMin1(ll_SideIdx)
    mda_BND_UMax2(ll_SideIdx) = ao_DPC_Product.BND_UMax2(ll_SideIdx)
    mda_BND_UMin2(ll_SideIdx) = ao_DPC_Product.BND_UMin2(ll_SideIdx)
    mda_BND_HMin1(ll_SideIdx) = ao_DPC_Product.BND_HMin1(ll_SideIdx)
    mda_BND_HMax1(ll_SideIdx) = ao_DPC_Product.BND_HMax1(ll_SideIdx)
    mda_BND_HMin2(ll_SideIdx) = ao_DPC_Product.BND_HMin2(ll_SideIdx)
    mda_BND_HMax2(ll_SideIdx) = ao_DPC_Product.BND_HMax2(ll_SideIdx)
    mda_BND_SMin1(ll_SideIdx) = ao_DPC_Product.BND_SMin1(ll_SideIdx)
    mda_BND_SMax1(ll_SideIdx) = ao_DPC_Product.BND_SMax1(ll_SideIdx)
    mda_BND_SMin2(ll_SideIdx) = ao_DPC_Product.BND_SMin2(ll_SideIdx)
    mda_BND_SMax2(ll_SideIdx) = ao_DPC_Product.BND_SMax2(ll_SideIdx)
    mda_BND_MatFct(ll_SideIdx) = ao_DPC_Product.BND_MatFct(ll_SideIdx)
    mda_BND_S(ll_SideIdx) = ao_DPC_Product.BND_S(ll_SideIdx)
    mba_BND_IsCus(ll_SideIdx) = ao_DPC_Product.BND_IsCus(ll_SideIdx)
    
    mba_BND_HasH(ll_SideIdx) = ao_DPC_Product.BND_HasH(ll_SideIdx)
    mda_BND_H(ll_SideIdx) = ao_DPC_Product.BND_H(ll_SideIdx)
    mba_BND_HasU(ll_SideIdx) = ao_DPC_Product.BND_HasU(ll_SideIdx)
    mba_BND_HasS(ll_SideIdx) = ao_DPC_Product.BND_HasS(ll_SideIdx)
    
    mda_RPL_H(ll_SideIdx) = ao_DPC_Product.RPL_H(ll_SideIdx)
    mda_RPL_U(ll_SideIdx) = ao_DPC_Product.RPL_U(ll_SideIdx)
    mda_RPL_UMin(ll_SideIdx) = ao_DPC_Product.RPL_UMin(ll_SideIdx)
    mda_RPL_UMax(ll_SideIdx) = ao_DPC_Product.RPL_UMax(ll_SideIdx)
    mda_RPL_S(ll_SideIdx) = ao_DPC_Product.RPL_S(ll_SideIdx)
  Next
  RPL_Type = ao_DPC_Product.RPL_Type
  RPL_SBndA = ao_DPC_Product.RPL_SBndA
  RPL_SBndB = ao_DPC_Product.RPL_SBndB
  RPL_SUZA = ao_DPC_Product.RPL_SUZA
  RPL_SUZB = ao_DPC_Product.RPL_SUZB
  
  PRD_Name = ao_DPC_Product.PRD_Name
  PRD_Desc = ao_DPC_Product.PRD_Desc
  MAT_Name = ao_DPC_Product.MAT_Name
  MAT_Desc = ao_DPC_Product.MAT_Desc
  MAT_CE = ao_DPC_Product.MAT_CE
  CAT_Name = ao_DPC_Product.CAT_Name
  CAT_Desc = ao_DPC_Product.CAT_Desc
  SYS_Name = ao_DPC_Product.SYS_Name
  SYS_Desc = ao_DPC_Product.SYS_Desc
  PKG_Code = ao_DPC_Product.PKG_Code
  PKG_Name = ao_DPC_Product.PKG_Name
  PKG_Desc = ao_DPC_Product.PKG_Desc
  
  LAB_Code = ao_DPC_Product.LAB_Code
  LAB_Name = ao_DPC_Product.LAB_Name
  LAB_Desc = ao_DPC_Product.LAB_Desc
  
  PRF_Code = ao_DPC_Product.PRF_Code
  PRF_Name = ao_DPC_Product.PRF_Name
  PRF_Desc = ao_DPC_Product.PRF_Desc
  PRF_Class = ao_DPC_Product.PRF_Class
  PRF_FSC = ao_DPC_Product.PRF_FSC
  PRF_MaxPW = ao_DPC_Product.PRF_MaxPW
  PRF_MaxTW = ao_DPC_Product.PRF_MaxTW
  PRF_MaxST = ao_DPC_Product.PRF_MaxST
  PRF_MaxAT = ao_DPC_Product.PRF_MaxAT
  PRF_IsCorrStep = ao_DPC_Product.PRF_IsCorrStep
  PRF_IsStandard = ao_DPC_Product.PRF_IsStandard
  
  
  PRF_HoleA = ao_DPC_Product.PRF_HoleA
  PRF_HoleB = ao_DPC_Product.PRF_HoleB
  PRF_DivA = ao_DPC_Product.PRF_DivA
  PRF_DivB = ao_DPC_Product.PRF_DivB
  PRF_Step = ao_DPC_Product.PRF_Step
  PRF_StLim = ao_DPC_Product.PRF_StLim
  PRF_SAMin = ao_DPC_Product.PRF_SAMin
  PRF_SAMax = ao_DPC_Product.PRF_SAMax
  PRF_SBMin = ao_DPC_Product.PRF_SBMin
  
  IMG_IdPRF = ao_DPC_Product.IMG_IdPRF
  IMG_IdSYS = ao_DPC_Product.IMG_IdSYS
  SYS_AMin = ao_DPC_Product.SYS_AMin
  SYS_AMax = ao_DPC_Product.SYS_AMax
  SYS_BMin = ao_DPC_Product.SYS_BMin
  SYS_BMax = ao_DPC_Product.SYS_BMax
  SYS_Exec = ao_DPC_Product.SYS_Exec
  SYS_Frame = ao_DPC_Product.SYS_Frame
  SYS_InlayDec1 = ao_DPC_Product.SYS_InlayDec1
  SYS_InlayDec2 = ao_DPC_Product.SYS_InlayDec2
  RPL_GskDe = ao_DPC_Product.RPL_GskDe
  RPL_GskDeDesc = ao_DPC_Product.RPL_GskDeDesc
  RPL_SpcDe = ao_DPC_Product.RPL_SpcDe
  RPL_SpcDeDesc = ao_DPC_Product.RPL_SpcDeDesc
  RPL_SpcNt = ao_DPC_Product.RPL_SpcNt
  RPL_PerDe = ao_DPC_Product.RPL_PerDe
  RPL_PBord = ao_DPC_Product.RPL_PBord
  RPL_PBordDesc = ao_DPC_Product.RPL_PBordDesc
  RPL_SwGap = ao_DPC_Product.RPL_SwGap
  RPL_IsOut = ao_DPC_Product.RPL_IsOut
  RPL_Plate = ao_DPC_Product.RPL_Plate
  RPL_PlCnt = ao_DPC_Product.RPL_PlCnt
  RPL_DrwNr = ao_DPC_Product.RPL_DrwNr
  RPL_SpcPkg = ao_DPC_Product.RPL_SpcPkg
  RPL_WghPnt = ao_DPC_Product.RPL_WghPnt
  RPL_OGroup = ao_DPC_Product.RPL_OGroup
  RPL_MGroup = ao_DPC_Product.RPL_MGroup
  RPL_AGroup = ao_DPC_Product.RPL_AGroup
  RPL_PGroup = ao_DPC_Product.RPL_PGroup
  RPL_AdminFact = ao_DPC_Product.RPL_AdminFact
  RPL_ICTPFact = ao_DPC_Product.RPL_ICTPFact
  RPL_MPE2Fact = ao_DPC_Product.RPL_MPE2Fact
  RPL_BOMRejectFact = ao_DPC_Product.RPL_BOMRejectFact
  RPL_BORWasteFact = ao_DPC_Product.RPL_BORWasteFact
  RPL_RejectOtherFact = ao_DPC_Product.RPL_RejectOtherFact
  
  Call mo_Tools.ClearCollection(Errors)
  For Each lo_Error In ao_DPC_Product.Errors
    Set lo_CopyError = New DPC_Error
    Set lo_CopyError.Tools = mo_Tools
    Call lo_CopyError.CopyFrom(lo_Error)
    Call Errors.Add(lo_CopyError)
  Next
  
  For Each lo_Cutout In Cutouts
    Call CutoutDrop(lo_Cutout)
  Next
  For Each lo_Cutout In ao_DPC_Product.Cutouts
    Set lo_CopyCutout = New DPC_Cutout
    Call InitCutout(lo_CopyCutout, lo_Cutout.PCT_Type, rsAdd)
    ll_Idx = lo_CopyCutout.Idx
    Call lo_CopyCutout.CopyFrom(lo_Cutout)
    lo_CopyCutout.Idx = ll_Idx
    Call Cutouts.Add(lo_CopyCutout)
  Next
  
  For Each lo_Inlay In Inlays
    Call InlayDrop(lo_Inlay)
  Next
  For Each lo_Inlay In ao_DPC_Product.Inlays
    Set lo_CopyInlay = New DPC_Inlay
    Call InitInlay(lo_CopyInlay, rsAdd)
    ll_Idx = lo_CopyInlay.Idx
    Call lo_CopyInlay.CopyFrom(lo_Inlay)
    lo_CopyInlay.Idx = ll_Idx
    Call Inlays.Add(lo_CopyInlay)
  Next
  
  If ao_DPC_Product.OptionalBNDCount = 0 Then
    ReDim ma_OptionalBND_Id(-1 To -1)
    ReDim ma_OptionalBND_Name(-1 To -1)
  Else
    ReDim ma_OptionalBND_Id(ao_DPC_Product.OptionalBNDCount - 1)
    ReDim ma_OptionalBND_Name(ao_DPC_Product.OptionalBNDCount - 1)
    For ll_Idx = 0 To ao_DPC_Product.OptionalBNDCount - 1
      ma_OptionalBND_Id(ll_Idx) = ao_DPC_Product.OptionalBND_Id(ll_Idx)
      ma_OptionalBND_Name(ll_Idx) = ao_DPC_Product.OptionalBND_Name(ll_Idx)
    Next
  End If
  If ao_DPC_Product.OptionalGSKCount = 0 Then
    ReDim ma_OptionalGSK_Id(-1 To -1)
    ReDim ma_OptionalGskGap(-1 To -1)
  Else
    ReDim ma_OptionalGSK_Id(ao_DPC_Product.OptionalGSKCount - 1)
    ReDim ma_OptionalGskGap(ao_DPC_Product.OptionalGSKCount - 1)
    For ll_Idx = 0 To ao_DPC_Product.OptionalGSKCount - 1
      ma_OptionalGSK_Id(ll_Idx) = ao_DPC_Product.OptionalGSK_Id(ll_Idx)
      ma_OptionalGskGap(ll_Idx) = ao_DPC_Product.OptionalGskGap(ll_Idx)
    Next
  End If
  If ao_DPC_Product.OptionalGSK2Count = 0 Then
    ReDim ma_OptionalGSK_Id2(-1 To -1)
    ReDim ma_OptionalGskGap2(-1 To -1)
  Else
    ReDim ma_OptionalGSK_Id2(ao_DPC_Product.OptionalGSK2Count - 1)
    ReDim ma_OptionalGskGap2(ao_DPC_Product.OptionalGSK2Count - 1)
    For ll_Idx = 0 To ao_DPC_Product.OptionalGSK2Count - 1
      ma_OptionalGSK_Id2(ll_Idx) = ao_DPC_Product.OptionalGSK_Id2(ll_Idx)
      ma_OptionalGskGap2(ll_Idx) = ao_DPC_Product.OptionalGskGap2(ll_Idx)
    Next
  End If
    If ao_DPC_Product.DefaultInlayPerfDecCount = 0 Then
    ReDim ma_DefaultInlayPerfDec(-1 To -1)
  Else
    ReDim ma_DefaultInlayPerfDec(ao_DPC_Product.DefaultInlayPerfDecCount - 1)
    For ll_Idx = 0 To ao_DPC_Product.DefaultInlayPerfDecCount - 1
      ma_DefaultInlayPerfDec(ll_Idx) = ao_DPC_Product.DefaultInlayPerfDec(ll_Idx)
    Next
  End If

  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyFrom")
End Sub

Public Sub CopyBOMFrom(ByVal ao_DPC_Product As DPC_Product)
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim lo_CopyBOM As DPC_BOM
Dim ll_Idx As Long

  For Each lo_BOM In BOMs
    Call BOMDrop(lo_BOM)
  Next
  
  For Each lo_BOM In ao_DPC_Product.BOMs
    Set lo_CopyBOM = New DPC_BOM
    Call InitBOM(lo_CopyBOM, eDPCRowStatus.rsNone)
    Call AddBOM(lo_CopyBOM)
    ll_Idx = lo_CopyBOM.Idx
    Call lo_CopyBOM.CopyFrom(lo_BOM)
    lo_CopyBOM.BOM_StlIdentNr = PRD_Code
    lo_CopyBOM.Idx = ll_Idx
  Next
  IsBOMLoaded = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyBOMFrom")
End Sub

Public Sub CopyBORFrom(ByVal ao_DPC_Product As DPC_Product)
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim lo_CopyBOR As DPC_BOR
Dim ll_Idx As Long

  For Each lo_BOR In BORs
    Call BORDrop(lo_BOR)
  Next
  
  For Each lo_BOR In ao_DPC_Product.BORs
    Set lo_CopyBOR = New DPC_BOR
    Call InitBOR(lo_CopyBOR, eDPCRowStatus.rsNone)
    Call AddBOR(lo_CopyBOR)
    ll_Idx = lo_CopyBOR.Idx
    Call lo_CopyBOR.CopyFrom(lo_BOR)
    lo_CopyBOR.BOR_AplIdentNr = PRD_Code
    lo_CopyBOR.Idx = ll_Idx
  Next
  IsBORLoaded = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyBOMFrom")
End Sub

Private Function LoadGasketSpacerId(ByVal as_PRD_CodeAMC As String) As String
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "SELECT PRD_Id FROM DPC_PrdCommon WHERE CAT_Id=$CAT_Id$ AND PRD_CodeAMC=$PRD_CodeAMC$ AND Drop_Flag=''"
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlInt(eDPCCategory.cgGasket), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeAMC$", mo_Tools.SQLStr(as_PRD_CodeAMC), , , vbTextCompare)
  LoadGasketSpacerId = mo_Tools.SelectValue(mo_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadGasketSpacerId")
End Function

Public Sub RecalcBOM(ByVal ao_DbBaeurer As Object, ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim ll_InlayIdx As Long
Dim lo_BOM As DPC_BOM
Dim lo_Inlay As DPC_Inlay
Dim ls_GSK_Id As String, ls_GSK_Id2 As String

  ll_InlayIdx = 0
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus <> eDPCRowStatus.rsDrop Then
      If lo_BOM.BOM_Categ = eDPCBOMMaterial.bcCoil Then
        Call lo_BOM.CalculateCoil(mo_Db, ao_DbBaeurer, ms_Language_Code, Me, ao_ErrCollection)
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcCoating Then
        Call lo_BOM.CalculateCoating(mo_Db, ao_DbBaeurer, ms_Language_Code, Me, ao_ErrCollection)
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcGasket Then
        ls_GSK_Id = LoadGasketSpacerId(lo_BOM.BOM_IdentNr)
        If ls_GSK_Id = "" Then
          Call mo_Tools.AddCheckError(eDPCError.erBOMMaterialCodeMissing, ms_Language_Code, ao_ErrCollection, Me, lo_BOM)
        End If
        Call lo_BOM.CalculateGasket(mo_Db, ao_DbBaeurer, ms_Language_Code, ls_GSK_Id, Me, ao_ErrCollection)
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcSpacer Then
        ls_GSK_Id2 = LoadGasketSpacerId(lo_BOM.BOM_IdentNr)
        If ls_GSK_Id2 = "" Then
          Call mo_Tools.AddCheckError(eDPCError.erBOMMaterialCodeMissing, ms_Language_Code, ao_ErrCollection, Me, lo_BOM)
        End If
        Call lo_BOM.CalculateSpacer(mo_Db, ao_DbBaeurer, ms_Language_Code, ls_GSK_Id2, Me, ao_ErrCollection)
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcInlay Then
        Set lo_Inlay = GetInlayByIndex(ll_InlayIdx)
        If Not lo_Inlay Is Nothing Then
          If lo_Inlay.PIN_Purch = eDPCInlayPurchaseType.ipOrderedSize Then
            lo_Inlay.INL_IdentNrTmp = lo_BOM.BOM_IdentNrTmp
            lo_Inlay.INL_IdentNr = DPC_BOM_NEW_IDENTNR
            lo_BOM.BOM_Export = False
            lo_BOM.BOM_ExpDat = 0
          End If
          Call lo_BOM.CalculateInlay(mo_Db, ao_DbBaeurer, ms_Language_Code, Me, lo_Inlay, ao_ErrCollection)
        End If
        ll_InlayIdx = ll_InlayIdx + 1
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcPacking Then
        ' remove packing and then recalculate from begining
        Call BOMDrop(lo_BOM)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("RecalcBOM")
End Sub

Public Sub RecalcBOR(ByVal ao_DbBaeurer As Object, ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR

  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then
      If Not lo_BOR.LoadBORTimeFromBaeurer(ao_DbBaeurer, Me) Then
        Call mo_Tools.AddCheckError(eDPCError.erBORRoutingTimeNotFound, ms_Language_Code, ao_ErrCollection, Me)
      End If
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("RecalcBOR")
End Sub
'Public Sub LoadAConfig()
'On Error GoTo ErrHandler
'
'Dim ls_Req As String
'
'  If mc_A_Config = 0 Then
'    mc_A_Config = mo_Tools.GetAConfigCursor(mo_Db, "DPC_%")
'  End If
'  Exit Sub
'ErrHandler:
'  Call ErrorHandler("LoadAConfig")
'End Sub

'Public Function GetAConfig(ByVal as_CFG_Key As String) As String
'On Error GoTo ErrHandler
'
'  GetAConfig = ""
'  If mo_Db.Find(mc_A_Config, "CFG_Key", as_CFG_Key, , 1) >= 0 Then
'    GetAConfig = mo_Db.GetFields(mc_A_Config, "CFG_Value")
'  Else
'    Err.Raise ArmErr.InvalidArgument, "as_CFG_Key", "A_Config record not found: " & as_CFG_Key
'  End If
'  Exit Function
'ErrHandler:
'  Call ErrorHandler("GetAConfig")
'End Function

Public Sub LoadError()
On Error GoTo ErrHandler

Dim ls_req As String

  If mc_Error = 0 Then
  
    ls_req = "exec DPC_Error_lst $Language_Code$"
    
    ls_req = ReplaceCommonPlaceholders(ls_req)
    mc_Error = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadError")
End Sub

Public Sub LoadPrdFile()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lo_File As DPC_File

  ls_req = "exec DPC_PrdFile_Lst $PRD_Id$, $Language_code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_File = New DPC_File
    Call InitFile(lo_File, eDPCRowStatus.rsNone)
    Call lo_File.ReadFile(mo_Db, lc_Cursor)
    Call Files.Add(lo_File)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadFile")
End Sub

Public Sub LoadBOM()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lo_BOM As DPC_BOM

  Call mo_Tools.ClearCollection(BOMs)
  ls_req = "exec DPC_BOM_Lst $PRD_Id$,$Language_Code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_BOM = New DPC_BOM
    Call InitBOM(lo_BOM, eDPCRowStatus.rsNone)
    Call AddBOM(lo_BOM)
    Call lo_BOM.ReadBOM(mo_Db, lc_Cursor)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  IsBOMLoaded = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadBOM")
End Sub

Public Sub LoadBOR()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lo_BOR As DPC_BOR

  Call mo_Tools.ClearCollection(BORs)
  ls_req = "exec DPC_BOR_Lst $PRD_Id$,$Language_Code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_BOR = New DPC_BOR
    Call InitBOR(lo_BOR, eDPCRowStatus.rsNone)
    Call lo_BOR.ReadBOR(mo_Db, lc_Cursor)
    Call AddBOR(lo_BOR)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  IsBORLoaded = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadBOR")
End Sub

Public Sub LoadCostCalc()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim ll_Idx As Long

  ls_req = "exec DPC_PrdCostCalc_lst $PRD_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) > 0 Then
    ReDim ma_CostCalc(mo_Db.RowCount(lc_Cursor) - 1)
  Else
    ReDim ma_CostCalc(-1 To -1)
  End If
  ll_Idx = 0
  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)
    ma_CostCalc(ll_Idx).Code = mo_Db.GetFields(lc_Cursor, "PCC_Code")
    ma_CostCalc(ll_Idx).Desc = mo_Db.GetFields(lc_Cursor, "RF_Desc")
    ma_CostCalc(ll_Idx).CostPCS = mo_Db.GetFields(lc_Cursor, "PCC_CostPCS")
    ma_CostCalc(ll_Idx).CostM2 = mo_Db.GetFields(lc_Cursor, "PCC_CostM2")
    ma_CostCalc(ll_Idx).DirectSetupCost = mo_Db.GetFields(lc_Cursor, "PCC_DirectSetupCost")
    ma_CostCalc(ll_Idx).SubSetupCost = mo_Db.GetFields(lc_Cursor, "PCC_SubSetupCost")
    ma_CostCalc(ll_Idx).TotSetupCost = mo_Db.GetFields(lc_Cursor, "PCC_TotSetupCost")
    ma_CostCalc(ll_Idx).CURR_Code = mo_Db.GetFields(lc_Cursor, "CURR_Code")
    Call mo_Db.Next(lc_Cursor)
    ll_Idx = ll_Idx + 1
  Wend
  Call mo_Db.Close(lc_Cursor)
  IsCostCalcChanged = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCostCalc")
End Sub

Public Sub InitOffer()
On Error GoTo ErrHandler

Dim ll_CAT_Id As Long
Dim ll_DOF_Id As Long
Dim ls_PRD_Id As String
Dim ls_PRD_Code As String

  Call LoadOfferTemplate
  Call LoadError
  Call mo_Tools.ClearCollection(OfferPrice)
  
  Call mo_Db.First(mc_OfferTemplate)
  While Not mo_Db.EOF(mc_OfferTemplate)
    ll_CAT_Id = mo_Db.GetFields(mc_OfferTemplate, "CAT_Id")
    ll_DOF_Id = mo_Db.GetFields(mc_OfferTemplate, "DOF_Id")
    ls_PRD_Id = mo_Db.GetFields(mc_OfferTemplate, "SCH_ID")
    ls_PRD_Code = mo_Db.GetFields(mc_OfferTemplate, "SCH_Code")
    If (ll_CAT_Id <> eDPCCategory.cgInlay) And _
       (ll_CAT_Id <> eDPCCategory.cgCutout) And _
       (ll_CAT_Id <> eDPCCategory.cgVentilation) And _
       (ll_CAT_Id <> eDPCCategory.cgLoudspeaker) Then
      Call CreateOfferPos(OfferPrice, mc_OfferTemplate, ls_PRD_Id, ls_PRD_Code)
    End If
    Call mo_Db.Next(mc_OfferTemplate)
  Wend
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitOffer")
End Sub

Public Function LoadWasteQty(ByVal ae_BOM_Categ As eDPCBOMMaterial, ByVal ad_Qty As Double) As Long
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_Request As String

  LoadWasteQty = 0
  ls_Request = "SELECT WAS_QtyWaste "  ' unused WAS_UseWasteFact
  ls_Request = ls_Request & "FROM DPC_BOM_Waste "
  ls_Request = ls_Request & "WHERE BOM_Categ=$BOM_Categ$ AND "
  ls_Request = ls_Request & "WAS_QtyMin < $Qty$ AND "
  ls_Request = ls_Request & "$Qty$ <= WAS_QtyMax AND "
  ls_Request = ls_Request & "Drop_Flag=''"
  
  ls_Request = Replace(ls_Request, "$BOM_Categ$", mo_Tools.SqlInt(ae_BOM_Categ), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Qty$", mo_Tools.SqlDbl(ad_Qty), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    LoadWasteQty = mo_Db.GetFields(lc_Cursor, "WAS_QtyWaste")
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadWasteQty")
End Function

Public Function LoadVendorShipPoint(ByVal as_CT_Code As String) As Boolean
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  LoadVendorShipPoint = False
  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
  If Not lo_Offer Is Nothing Then
    Call lo_Offer.LoadShipPoint(mo_Db, as_CT_Code)
    
    VEN_Id = Vendor_Id
    VEN_Name = Vendor_Name
    lo_Offer.VEN_Id = VEN_Id
    lo_Offer.VEN_Name = VEN_Name
    
    SHP_Id = lo_Offer.SHP_Id
    SHP_Name = lo_Offer.SHP_Name
    LoadVendorShipPoint = True
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadVendorShipPoint")
End Function

Public Function CreateOfferPos(ByVal ao_Collection As Collection, ByVal ac_OfferTemplate As Long, ByVal as_PRD_Id As String, ByVal as_PRD_Code As String) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = New DPC_OfferPos
  Set lo_Offer.Tools = mo_Tools
  lo_Offer.ValidManual = eDPCOfferPosValidManual.vmNone
  lo_Offer.OFD_MarginS = OFD_MarginS
  lo_Offer.OFD_GTN = OFD_GTN
  lo_Offer.OFD_MarginMin = OFD_MarginMin
  Call lo_Offer.ReadOfferPosTemp(mo_Db, ac_OfferTemplate)
  Call ao_Collection.Add(lo_Offer)
  Set CreateOfferPos = lo_Offer
  Exit Function
ErrHandler:
  Call ErrorHandler("CreateOfferPos")
End Function

Public Function GetOfferPos(ByVal ae_DOF_Id As eDPCOfferDetail, Optional ByVal as_ID As String = "") As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim le_Category As eDPCCategory
Dim lo_Inlay As DPC_Inlay

  Set GetOfferPos = Nothing
  le_Category = GetCategory(ae_DOF_Id)
  If (le_Category = eDPCCategory.cgLoudspeaker) Or (le_Category = eDPCCategory.cgVentilation) Or (le_Category = eDPCCategory.cgCutout) Then
    For Each lo_Cutout In Cutouts
      If StrComp(as_ID, lo_Cutout.PCT_Id, vbTextCompare) = 0 Then
        Set GetOfferPos = lo_Cutout.GetOfferPos(ae_DOF_Id)
      End If
    Next
  ElseIf (le_Category = eDPCCategory.cgInlay) Then
    For Each lo_Inlay In Inlays
      If StrComp(as_ID, lo_Inlay.PIN_Id, vbTextCompare) = 0 Then
        Set GetOfferPos = lo_Inlay.GetOfferPos(ae_DOF_Id)
      End If
    Next
  Else
    For Each lo_Offer In OfferPrice
      If lo_Offer.DOF_Id = ae_DOF_Id Then
        Set GetOfferPos = lo_Offer
        Exit Function
      End If
    Next
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPos")
End Function

Public Function GetOfferPosByTag(ByVal as_Tag As String) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPosByTag = Nothing
  For Each lo_Offer In OfferPrice
    If StrComp(lo_Offer.DOF_Tag, as_Tag, vbTextCompare) = 0 Then
      Set GetOfferPosByTag = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPosByTag")
End Function

Public Function GetPrice(ByVal al_DOF_Id As Long, ByVal as_PRD_Id As String) As Double
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
  
  GetPrice = 0
  Set lo_Offer = GetOfferPos(al_DOF_Id, as_PRD_Id)
  If lo_Offer Is Nothing Then
    Err.Raise ArmErr.CompFncFailed, "GetOfferPos", "Offer price not found for DOF_Id: " & al_DOF_Id & " PRD_Id=" & as_PRD_Id
  End If
  GetPrice = lo_Offer.OFD_Price
  Exit Function
ErrHandler:
  Call ErrorHandler("GetPrice")
End Function

Public Sub LoadOfferTemplate()
On Error GoTo ErrHandler

Dim ls_req As String

  If mc_OfferTemplate = 0 Then
    ls_req = "exec DPC_Offer_lst $DOF_Source$, $Language_Code$"
    ls_req = Replace(ls_req, "$DOF_Source$", mo_Tools.SqlInt(eDPCOffferDetailSource.dsProdConfigPosition), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    mc_OfferTemplate = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOfferTemplate")
End Sub

Public Sub LoadOffer(ByVal as_COF_Id As String, ByVal as_OFD_IdPar As String)
On Error GoTo ErrHandler

Dim le_DOF_Id As eDPCOfferDetail
Dim ls_PRD_Id As String
Dim lo_Offer As DPC_OfferPos
Dim ls_req As String
Dim lc_Cursor As Long

  Call ResetPanelQtyPrice(0, eDPCQtyType.qtUnknown)
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)

  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)

    le_DOF_Id = mo_Db.GetFields(lc_Cursor, "DOF_Id")
    ls_PRD_Id = mo_Db.GetFields(lc_Cursor, "PRD_ID")

    Set lo_Offer = GetOfferPos(le_DOF_Id, ls_PRD_Id)
    If Not lo_Offer Is Nothing Then
      Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
  OFD_Pos = lo_Offer.OFD_Pos
  OFD_PosCus = lo_Offer.OFD_PosCus
  PRD_CodeC = lo_Offer.PRD_CodeC
  OFD_WshDat = lo_Offer.OFD_WshDat
  OFD_ShpDat = lo_Offer.OFD_ShpDat
  OFD_DelDat = lo_Offer.OFD_DelDat
  VEN_Id = lo_Offer.VEN_Id
  SHP_Id = lo_Offer.SHP_Id
  VEN_Name = lo_Offer.VEN_Name
  SHP_Name = lo_Offer.SHP_Name
  COF_Id = lo_Offer.COF_Id
  OFD_IsFree = lo_Offer.OFD_IsFree
  OFD_IsAsItem = lo_Offer.OFD_IsAsItem
  OFD_MarginS = lo_Offer.OFD_MarginS
  OFD_GTN = lo_Offer.OFD_GTN
  OFD_MarginMin = lo_Offer.OFD_MarginMin
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOffer")
End Sub

'Public Sub ApplyOffer(ByVal ao_OfferCollection As Collection)
'On Error GoTo ErrHandler
'
'Dim le_DOF_Id As eDPCOfferDetail
'Dim ls_PRD_Id As String
'Dim lo_Offer As DPC_OfferPos
'Dim lo_OfferFound As DPC_OfferPos
'
'  Call ResetPanelQtyPrice(0, eDPCQtyType.qtUnknown)
'  For Each lo_Offer In ao_OfferCollection
'
'    le_DOF_Id = lo_Offer.DOF_Id
'    ls_PRD_Id = lo_Offer.PRD_Id
'
'    Set lo_OfferFound = GetOfferPos(le_DOF_Id, ls_PRD_Id)
'    If lo_OfferFound Is Nothing Then
'      'Err.Raise ArmErr.InvalidArgument, "GetOfferPos", "Offer detail not found DOF_Id=" & le_DOF_Id & " PRD_Id=" & ls_PRD_Id
'    Else
'      lo_OfferFound.PRD_Code = lo_Offer.PRD_Code
'      lo_OfferFound.PRD_CodeC = lo_Offer.PRD_CodeC
'      lo_OfferFound.PRD_Name = lo_Offer.PRD_Name
'      lo_OfferFound.PRD_Desc = lo_Offer.PRD_Desc
'      lo_OfferFound.LEV_Id = lo_Offer.LEV_Id
'      lo_OfferFound.OFD_Pos = lo_Offer.OFD_Pos
'      lo_OfferFound.OFD_WshDat = lo_Offer.OFD_WshDat
'      lo_OfferFound.OFD_DelDat = lo_Offer.OFD_DelDat
'      lo_OfferFound.OFD_Order = lo_Offer.OFD_Order
'      lo_OfferFound.UM_Code = lo_Offer.UM_Code
'      lo_OfferFound.OFD_Qty = lo_Offer.OFD_Qty
'      lo_OfferFound.OFD_QtyA = lo_Offer.OFD_QtyA
'      lo_OfferFound.OFD_Cost = lo_Offer.OFD_Cost
'      lo_OfferFound.OFD_CostA = lo_Offer.OFD_CostA
'      lo_OfferFound.OFD_Valid = lo_Offer.OFD_Valid
'      lo_OfferFound.OFD_Found = lo_Offer.OFD_Found
'    End If
'  Next
'
'  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
'  OFD_Pos = lo_Offer.OFD_Pos
'  OFD_WshDat = lo_Offer.OFD_WshDat
'  OFD_DelDat = lo_Offer.OFD_DelDat
'  COF_Id = lo_Offer.COF_Id
'  Exit Sub
'ErrHandler:
'  Call ErrorHandler("ApplyOffer")
'End Sub

Public Function GenerateOfferDetail() As Collection
On Error GoTo ErrHandler
Dim lo_Collection As New Collection
Dim lo_Offer As DPC_OfferPos
Dim ll_Idx As Long
Dim le_SideIdx As eDPCSide
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay
Dim ll_ItemIdx As Long
Dim ls_Side As String
Dim le_OFD_Type As eDPCPriceBookType
Dim ll_SetupCounter As Long

  If LEV_Id = eDPCLevel.lvStandard Then
    le_OFD_Type = eDPCPriceBookType.eStockMetal
  ElseIf LEV_Id = eDPCLevel.lvCustom Then
    le_OFD_Type = eDPCPriceBookType.eCustomMetal
  ElseIf LEV_Id = eDPCLevel.lvEngineered Then
    le_OFD_Type = eDPCPriceBookType.eCustomMetal
  Else
    Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
    le_OFD_Type = lo_Offer.OFD_Type
  End If
  
  For Each lo_Offer In OfferPrice
    lo_Offer.PRD_Code = ""
    lo_Offer.PRD_Code = ""
    lo_Offer.PRD_CodeC = ""
    lo_Offer.PRD_Name = Trim(lo_Offer.DOF_Name & " " & ReplaceValuePlaceholder(lo_Offer.DOF_NTemp))
    lo_Offer.PRD_Name = lo_Offer.ReplaceValuePlaceholder(lo_Offer.PRD_Name)
    lo_Offer.OFD_Order = lo_Offer.DOF_Order
    'lo_Offer.OFD_Order = ll_OFD_Order
    Select Case lo_Offer.DOF_Id
    Case eDPCOfferDetail.odPosition
      Call lo_Collection.Add(lo_Offer)
      lo_Offer.CAT_Id = CAT_Id
      lo_Offer.OFD_PosCus = OFD_PosCus
      lo_Offer.PRD_Code = PRD_Code
      lo_Offer.PRD_CodeC = PRD_CodeC
      lo_Offer.PRD_Id = PRD_Id
      lo_Offer.OFD_WshDat = OFD_WshDat
      lo_Offer.OFD_ShpDat = OFD_ShpDat
      lo_Offer.OFD_DelDat = OFD_DelDat
      lo_Offer.VEN_Id = VEN_Id
      lo_Offer.SHP_Id = SHP_Id
      lo_Offer.VEN_Name = VEN_Name
      lo_Offer.SHP_Name = SHP_Name
      lo_Offer.OFD_IsAsItem = OFD_IsAsItem
      lo_Offer.OFD_IsFree = OFD_IsFree
    Case eDPCOfferDetail.odPanelCost
      Call lo_Collection.Add(lo_Offer)
      lo_Offer.PRD_Id = PRD_Id
    Case eDPCOfferDetail.odLongSideExecution
      If Not HasDefaultBending Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odShortSideExecution
      If Not HasDefaultBending Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odNotchingClosed
      If HasNotchingClosed Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odBendingVisible
      If HasBendingVisible Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odPanelSetupChargeUnp, _
        eDPCOfferDetail.odPanelChangeLengthCostUnp, _
        eDPCOfferDetail.odPanelChangeWidthCostUnp
      If Not HasPerforation Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odPanelSetupChargePrf, _
        eDPCOfferDetail.odPanelChangeLengthCostPrf, _
        eDPCOfferDetail.odPanelChangeWidthCostPrf
      If HasPerforation Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odCoatingSetupCharge
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odCoatingCost
      lo_Offer.PRD_Id = COA_Id
      lo_Offer.PRD_Code = COA_Code
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odPerforationCost
      lo_Offer.PRD_Id = PRF_Id
      lo_Offer.PRD_Code = PRF_Code
      If HasPerforation Then
        lo_Offer.PRD_Name = lo_Offer.PRD_Name & vbCrLf & RPL_PBordDesc
        If RPL_PBord = eDPCPerforationBorderType.pbOther Then
          lo_Offer.PRD_Name = lo_Offer.PRD_Name & " "
          Dim ls_Border As String
          
          ls_Border = ""
          For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
            If ls_Border <> "" Then ls_Border = ls_Border & "/"
            If RPL_UBor(le_SideIdx) < 0 Then
              ls_Border = ls_Border & "0"
            Else
              ls_Border = ls_Border & mo_Tools.DblToScreen(RPL_UBor(le_SideIdx), 0)
            End If
          Next
           lo_Offer.PRD_Name = lo_Offer.PRD_Name & ls_Border
        End If
      Else
        lo_Offer.PRD_Name = lo_Offer.DOF_Name & " " & PRF_Name
      End If
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odGasketSurcharge
      If HasGasket Then
        ls_Side = ""
       For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
          If IsGasketOn(le_SideIdx) Then
            lo_Offer.PRD_Code = GSK_Code(le_SideIdx)
            lo_Offer.PRD_Name = GSK_Name(le_SideIdx) & "," & GSK_Desc(le_SideIdx)
            If ls_Side <> "" Then ls_Side = ls_Side & "\"
            ls_Side = ls_Side & mv_Edge(le_SideIdx)
          End If
        Next
        lo_Offer.PRD_Name = lo_Offer.PRD_Name & " " & ls_Side
      Else
        lo_Offer.PRD_Name = RPL_GskDeDesc
        lo_Offer.OFD_Valid = False
        lo_Offer.OFD_Found = 1
      End If
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odSpacerSurcharge
      If HasSpacer Then
        ls_Side = ""
        For le_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
          If IsSpacerOn(le_SideIdx) Then
            lo_Offer.PRD_Code = GSK_Code2(le_SideIdx)
            lo_Offer.PRD_Name = GSK_Name2(le_SideIdx) & "," & GSK_Desc2(le_SideIdx)
            If ls_Side <> "" Then ls_Side = ls_Side & "\"
            ls_Side = ls_Side & mv_Edge(le_SideIdx)
          End If
        Next
        lo_Offer.PRD_Name = lo_Offer.PRD_Name & " " & ls_Side
      Else
        lo_Offer.PRD_Name = RPL_SpcDeDesc
        lo_Offer.OFD_Valid = False
        lo_Offer.OFD_Found = 1
      End If
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odInlayNone
      If Not HasInlay Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odPackingCost
      If HasPacking Then
        lo_Offer.PRD_Id = PKG_Id
        lo_Offer.PRD_Code = PKG_Code
        Call lo_Collection.Add(lo_Offer)
      End If
    Case eDPCOfferDetail.odLabelingCost
      lo_Offer.PRD_Id = LAB_Id
      lo_Offer.PRD_Code = LAB_Code
      If lo_Offer.OFD_Price = 0 Then
        lo_Offer.OFD_Valid = False
      End If
      Call lo_Collection.Add(lo_Offer)
    Case eDPCOfferDetail.odOfferComment
      If GetErrorText(eDPCError.erOfferComment, Nothing) <> "" Then
        Call lo_Collection.Add(lo_Offer)
      End If
    Case Else
      If lo_Offer.DOF_IsTxt Then
        Call lo_Collection.Add(lo_Offer)
      Else
        Err.Raise ArmErr.InvalidArgument, "DOF_Id", "Undefined DOF_Id: " & lo_Offer.DOF_Id
      End If
    End Select
  Next
  
  If HasInlay Then
    ll_ItemIdx = 0
    For Each lo_Inlay In Inlays
      If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
        ll_ItemIdx = ll_ItemIdx + 1
        For Each lo_Offer In lo_Inlay.OfferPrice
          lo_Offer.PRD_Name = Trim(lo_Offer.DOF_Name & " " & ReplaceValuePlaceholder(lo_Offer.DOF_NTemp))
          lo_Offer.PRD_Name = lo_Offer.ReplaceValuePlaceholder(lo_Offer.PRD_Name)
          lo_Offer.PRD_Name = lo_Inlay.ReplaceValuePlaceholder(lo_Offer.PRD_Name)
          lo_Offer.OFD_Order = lo_Offer.DOF_Order + ll_ItemIdx
  
          Select Case lo_Offer.DOF_Id
          Case eDPCOfferDetail.odInlayCost
            lo_Offer.PRD_Code = lo_Inlay.INL_Code
            lo_Offer.PRD_Id = lo_Inlay.PIN_Id
          Case eDPCOfferDetail.odInlaySetupCharge
            lo_Offer.PRD_Id = lo_Inlay.PIN_Id
          End Select
          Call lo_Collection.Add(lo_Offer)
        Next
      End If
    Next
  Else
    
  End If
  
  ll_ItemIdx = 0
  For Each lo_Cutout In Cutouts
    If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
      ll_ItemIdx = ll_ItemIdx + 1
      For Each lo_Offer In lo_Cutout.OfferPrice
        lo_Offer.PRD_Name = Trim(lo_Offer.DOF_Name & " " & ReplaceValuePlaceholder(lo_Offer.DOF_NTemp))
        lo_Offer.PRD_Name = lo_Offer.ReplaceValuePlaceholder(lo_Offer.PRD_Name)
        lo_Offer.PRD_Name = lo_Cutout.ReplaceValuePlaceholder(lo_Offer.PRD_Name)
        lo_Offer.OFD_Order = lo_Offer.DOF_Order + ll_ItemIdx
        
        Select Case lo_Offer.DOF_Id
        Case eDPCOfferDetail.odCutoutCost, _
            eDPCOfferDetail.odVentilationCost, _
            eDPCOfferDetail.odLoudspeakerCost
          lo_Offer.PRD_Code = lo_Cutout.CUT_Code
          lo_Offer.PRD_Id = lo_Cutout.PCT_Id
        Case Else
          lo_Offer.PRD_Id = lo_Cutout.PCT_Id
        End Select
        Call lo_Collection.Add(lo_Offer)
      Next
    End If
  Next
  
  ll_SetupCounter = 1
  For Each lo_Offer In lo_Collection
    lo_Offer.COF_Id = COF_Id
    lo_Offer.OFD_Type = le_OFD_Type
    lo_Offer.ERR_Type = GetScreenErrorType(lo_Offer.SCR_Id)
    lo_Offer.LEV_Id = LEV_Id
    lo_Offer.CURR_Code = CURR_Code
    
    If (lo_Offer.DOF_Id = eDPCOfferDetail.odPosition) Or (lo_Offer.DOF_IsStp) Then
      lo_Offer.OFD_Main = eDPCOfferDetailMain.odMain
      lo_Offer.OFD_HasQty = True
      lo_Offer.OFD_HasPrice = True
      lo_Offer.OFD_HasTotal = True
    Else
      lo_Offer.OFD_Main = eDPCOfferDetailMain.odChild
      If lo_Offer.LEV_Id = eDPCLevel.lvCustom Then
        lo_Offer.OFD_HasQty = lo_Offer.DOF_IsSchg Or lo_Offer.DOF_IsStp
        lo_Offer.OFD_HasPrice = lo_Offer.DOF_IsSchg Or lo_Offer.DOF_IsStp
        lo_Offer.OFD_HasTotal = lo_Offer.DOF_IsSchg Or lo_Offer.DOF_IsStp
      Else
        lo_Offer.OFD_HasQty = False
        lo_Offer.OFD_HasPrice = False
        lo_Offer.OFD_HasTotal = False
      End If
    End If
    
    If lo_Offer.DOF_IsStp Then
      lo_Offer.OFD_Pos = OFD_Pos + ll_SetupCounter
      ll_SetupCounter = ll_SetupCounter + 1
    Else
      lo_Offer.OFD_Pos = OFD_Pos
    End If
  Next
  
  Set lo_Collection = OfferOrder(lo_Collection)
  Set GenerateOfferDetail = GenerateOfferOptions(lo_Collection)
  Exit Function
ErrHandler:
  Call ErrorHandler("GenerateOfferDetail")
End Function

Public Function OfferOrder(ByVal ao_Collection As Collection) As Collection
On Error GoTo ErrHandler

Dim ll_Idx1 As Long, ll_Idx2 As Long
Dim lo_OfferPos1 As DPC_OfferPos, lo_OfferPos2 As DPC_OfferPos

  For ll_Idx1 = 1 To ao_Collection.Count
    For ll_Idx2 = 1 To ao_Collection.Count - ll_Idx1
      Set lo_OfferPos1 = ao_Collection(ll_Idx2)
      Set lo_OfferPos2 = ao_Collection(ll_Idx2 + 1)
      If lo_OfferPos1.OFD_Order > lo_OfferPos2.OFD_Order Then
        Call ao_Collection.Remove(ll_Idx2)
        Call ao_Collection.Add(lo_OfferPos1, , , ll_Idx2)
      End If
    Next
  Next
  Set lo_OfferPos1 = Nothing
  Set lo_OfferPos2 = Nothing
  Set OfferOrder = ao_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("OfferOrder")
End Function

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
'Optional ll_ATS_Id As Long = 0, Optional ByVal al_RecIdx As Long = 0
On Error GoTo ErrHandler

Dim ll_SideIdx As Long
'Dim ll_DOFIdx As Long
Dim ll_Idx As Long
'Dim lo_Inlay As DPC_Inlay
'Dim lo_Cutout As DPC_Cutout
Dim lo_Offer As DPC_OfferPos

'  If (ll_ATS_Id = 0) Or (ll_ATS_Id = 4) Then
    as_Text = Replace(as_Text, "$PRD_Id$", PRD_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$OFD_Pos$", OFD_Pos, , , vbTextCompare)
    as_Text = Replace(as_Text, "$OFD_PosCus$", OFD_PosCus, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_Code$", PRD_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_CodeC$", PRD_CodeC, , , vbTextCompare)
    
    
    as_Text = Replace(as_Text, "$PRD_IdPar$", PRD_IdPar, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_Child$", mo_Tools.LongToScreen(PRD_Child), , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$PRD_Name$", PRD_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_Desc$", PRD_Desc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_Comment$", GetErrorText(eDPCError.erOfferComment, Nothing), , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_OfferComment$", GetErrorText(eDPCError.erOfferComment, Nothing), , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRD_InternalComment$", GetErrorText(eDPCError.erInternalComment, Nothing), , , vbTextCompare)
    
    
    as_Text = Replace(as_Text, "$LEV_Id$", LEV_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_Id$", SYS_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_ModA$", mo_Tools.DblToScreen(RPL_ModA), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_ModB$", mo_Tools.DblToScreen(RPL_ModB), , , vbTextCompare)
    as_Text = Replace(as_Text, "$PanelPerMod$", PanelPerMod, , , vbTextCompare)
  
    as_Text = Replace(as_Text, "$RPL_StdGa$", mo_Tools.BoolToScreen(RPL_StdGa), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_GapA$", mo_Tools.DblToScreen(GapA), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_GapB$", mo_Tools.DblToScreen(GapB), , , vbTextCompare)
  
    as_Text = Replace(as_Text, "$PanelSurface$", mo_Tools.DblToScreen(PanelSurface), , , vbTextCompare)
    as_Text = Replace(as_Text, "$ModuleSurface$", mo_Tools.DblToScreen(ModuleSurface), , , vbTextCompare)
    
    
    as_Text = Replace(as_Text, "$RPL_PanA$", mo_Tools.DblToScreen(RPL_PanA), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PanB$", mo_Tools.DblToScreen(RPL_PanB), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PanAG$", mo_Tools.DblToScreen(RPL_PanA + GapB / 2), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PanBG$", mo_Tools.DblToScreen(RPL_PanB + GapA / 2), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_Thick$", mo_Tools.DblToScreen(RPL_Thick), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CutA$", mo_Tools.DblToScreen(RPL_CutA), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CutB$", mo_Tools.DblToScreen(RPL_CutB), , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$RPL_CoWMin$", mo_Tools.DblToScreen(RPL_CoWMin), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CoWMax$", mo_Tools.DblToScreen(RPL_CoWMax), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CoilW$", mo_Tools.DblToScreen(RPL_CoilW), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CustDim$", mo_Tools.LongToScreen(RPL_CustDim), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_MatTyp$", RPL_MatTyp, , , vbTextCompare)
    as_Text = Replace(as_Text, "$StandardCoil$", IIf(StrComp(COI_IsStock, "X", vbTextCompare) = 0, "L", ""), , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$TotalHeight$", mo_Tools.DblToScreen(TotalHeight), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PerDe$", RPL_PerDe, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_SwGap$", mo_Tools.DblToScreen(RPL_SwGap), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CorW$", mo_Tools.DblToScreen(RPL_CorW), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PU$", RPL_PU, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_MQty$", RPL_MQty, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_NWgh$", mo_Tools.DblToScreen(RPL_NWgh), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_DrwNr$", RPL_DrwNr, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$RPL_BOMRejectFact$", mo_Tools.DblToScreen(RPL_BOMRejectFact * 100), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_BORWasteFact$", mo_Tools.DblToScreen(RPL_BORWasteFact * 100), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_RejectOtherFact$", mo_Tools.DblToScreen(RPL_RejectOtherFact * 100), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_AdminFact$", mo_Tools.DblToScreen(RPL_AdminFact * 100), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_MPE2Fact$", mo_Tools.DblToScreen(RPL_MPE2Fact * 100), , , vbTextCompare)
    
    
    as_Text = Replace(as_Text, "$RPL_OGroup$", RPL_OGroup, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_PGroup$", RPL_PGroup, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_AGroup$", mo_Tools.LongToScreen(RPL_AGroup), , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_MGroup$", mo_Tools.LongToScreen(RPL_MGroup), , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$RPL_BevA$", RPL_BevA, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_BevB$", RPL_BevB, , , vbTextCompare)
    as_Text = Replace(as_Text, "$MAT_Id$", MAT_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COI_Code$", COI_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_StdMa$", mo_Tools.BoolToScreen(RPL_StdMa), , , vbTextCompare)
    as_Text = Replace(as_Text, "$PKG_Id$", PKG_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$LAB_Id$", LAB_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRF_Id$", PRF_Id, , , vbTextCompare)
  
    as_Text = Replace(as_Text, "$COA_Id$", COA_Id, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Code$", COA_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Name$", COA_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Desc$", COA_Desc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_ExName$", COA_ExName, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$RPL_CoSid$", RPL_CoSid, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_CoSidDesc$", RPL_CoSidDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Type$", COA_Type, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_TypeDesc$", COA_TypeDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_App$", COA_App, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_AppDesc$", COA_AppDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Norm$", COA_Norm, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_NormDesc$", COA_NormDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_Mat$", COA_Mat, , , vbTextCompare)
    as_Text = Replace(as_Text, "$COA_MatDesc$", COA_MatDesc, , , vbTextCompare)
    
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      as_Text = Replace(as_Text, "$RPL_H" & mv_Edge(ll_SideIdx) & "$", mo_Tools.DblToScreen(RPL_H(ll_SideIdx)), , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_Gap" & mv_Edge(ll_SideIdx) & "$", mo_Tools.DblToScreen(RPL_Gap(ll_SideIdx)), , , vbTextCompare)
      
      If Not HasPerforation Then
        as_Text = Replace(as_Text, "$RPL_UBor" & mv_Edge(ll_SideIdx) & "$", "", , , vbTextCompare)
        as_Text = Replace(as_Text, "$RPL_UBoW" & mv_Edge(ll_SideIdx) & "$", "", , , vbTextCompare)
      Else
        If RPL_UBor(ll_SideIdx) < 0 Then
          as_Text = Replace(as_Text, "$RPL_UBor" & mv_Edge(ll_SideIdx) & "$", "overperf.", , , vbTextCompare)
        Else
          as_Text = Replace(as_Text, "$RPL_UBor" & mv_Edge(ll_SideIdx) & "$", RPL_UBor(ll_SideIdx), , , vbTextCompare)
        End If
        If RPL_UBoW(ll_SideIdx) < 0 Then
          as_Text = Replace(as_Text, "$RPL_UBoW" & mv_Edge(ll_SideIdx) & "$", "overperf.", , , vbTextCompare)
        Else
          as_Text = Replace(as_Text, "$RPL_UBoW" & mv_Edge(ll_SideIdx) & "$", RPL_UBoW(ll_SideIdx), , , vbTextCompare)
        End If
      End If
      as_Text = Replace(as_Text, "$GSK_ID" & mv_Edge(ll_SideIdx) & "$", GSK_Id(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Code" & mv_Edge(ll_SideIdx) & "$", GSK_Code(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Name" & mv_Edge(ll_SideIdx) & "$", GSK_Name(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Desc" & mv_Edge(ll_SideIdx) & "$", GSK_Desc(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Gap" & mv_Edge(ll_SideIdx) & "$", GSK_Gap(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_ExName" & mv_Edge(ll_SideIdx) & "$", GSK_ExName(ll_SideIdx), , , vbTextCompare)
      
      as_Text = Replace(as_Text, "$GSK_ID2" & mv_Edge(ll_SideIdx) & "$", GSK_Id2(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Code2" & mv_Edge(ll_SideIdx) & "$", GSK_Code2(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Name2" & mv_Edge(ll_SideIdx) & "$", GSK_Name2(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Desc2" & mv_Edge(ll_SideIdx) & "$", GSK_Desc2(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_Gap2" & mv_Edge(ll_SideIdx) & "$", GSK_Gap2(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$GSK_ExName2" & mv_Edge(ll_SideIdx) & "$", GSK_ExName2(ll_SideIdx), , , vbTextCompare)
      
      as_Text = Replace(as_Text, "$BND_Id" & mv_Edge(ll_SideIdx) & "$", BND_Id(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$BND_Name" & mv_Edge(ll_SideIdx) & "$", BND_Name(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$BND_Desc" & mv_Edge(ll_SideIdx) & "$", BND_Desc(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_BVis" & mv_Edge(ll_SideIdx) & "$", RPL_BVis(ll_SideIdx), , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_NClo" & mv_Edge(ll_SideIdx) & "$", RPL_NClo(ll_SideIdx), , , vbTextCompare)
      
      as_Text = Replace(as_Text, "$RPL_U" & mv_Edge(ll_SideIdx) & "$", mo_Tools.DblToScreen(RPL_U(ll_SideIdx)), , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_H" & mv_Edge(ll_SideIdx) & "$", mo_Tools.DblToScreen(RPL_H(ll_SideIdx)), , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_S" & mv_Edge(ll_SideIdx) & "$", mo_Tools.DblToScreen(RPL_S(ll_SideIdx)), , , vbTextCompare)
      
    Next
    
    as_Text = Replace(as_Text, "$GSK_Pos$", GSK_Pos, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_NotchingClosed$", RPL_NCloPos, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_BendingVisible$", RPL_BVisPos, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$RPL_GskDe$", RPL_GskDe, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_GskDeDesc$", RPL_GskDeDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_SpcDe$", RPL_SpcDe, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_SpcDeDesc$", RPL_SpcDeDesc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$RPL_WghPnt$", RPL_WghPnt, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$MAT_Name$", MAT_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$MAT_Desc$", MAT_Desc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CAT_Name$", CAT_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CAT_Desc$", CAT_Desc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_Name$", SYS_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_Desc$", SYS_Desc, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_Exec$", SYS_Exec, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PKG_Code$", PKG_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PKG_Name$", PKG_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PKG_Desc$", PKG_Desc, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$LAB_Code$", LAB_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$LAB_Name$", LAB_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$LAB_Desc$", LAB_Desc, , , vbTextCompare)
    
    as_Text = Replace(as_Text, "$PRF_Code$", PRF_Code, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRF_Name$", PRF_Name, , , vbTextCompare)
    as_Text = Replace(as_Text, "$PRF_Desc$", PRF_Desc, , , vbTextCompare)
    If HasPerforation Then
      as_Text = Replace(as_Text, "$RPL_PBord$", RPL_PBord, , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_PBordDesc$", RPL_PBordDesc, , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_Class$", PRF_Class, , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_FSC$", PRF_FSC, , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_HoleA$", mo_Tools.DblToScreen(PRF_HoleA), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_HoleB$", mo_Tools.DblToScreen(PRF_HoleB), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_DivA$", mo_Tools.DblToScreen(PRF_DivA), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_DivB$", mo_Tools.DblToScreen(PRF_DivB), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_Step$", mo_Tools.DblToScreen(PRF_Step), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_StLim$", mo_Tools.DblToScreen(PRF_StLim), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SAMin$", mo_Tools.DblToScreen(PRF_SAMin), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SAMax$", mo_Tools.DblToScreen(PRF_SAMax), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SBMin$", mo_Tools.DblToScreen(PRF_SBMin), , , vbTextCompare)
    Else
      as_Text = Replace(as_Text, "$RPL_PBord$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$RPL_PBordDesc$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_Class$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_FSC$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_HoleA$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_HoleB$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_DivA$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_DivB$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_Step$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_StLim$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SAMin$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SAMax$", "", , , vbTextCompare)
      as_Text = Replace(as_Text, "$PRF_SBMin$", "", , , vbTextCompare)
    End If
  
    as_Text = Replace(as_Text, "$SYS_AMin$", SYS_AMin, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_AMax$", SYS_AMax, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_BMin$", SYS_BMin, , , vbTextCompare)
    as_Text = Replace(as_Text, "$SYS_BMax$", SYS_BMax, , , vbTextCompare)
  
    as_Text = Replace(as_Text, "$PanelM2$", mo_Tools.DblToScreen(Round(RPL_PanA * RPL_PanB / 1000000, 2)), , , vbTextCompare)
    
    Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
    If lo_Offer Is Nothing Then
      as_Text = Replace(as_Text, "$PanelPriceM2_M$", "", , , vbTextCompare)
    Else
      as_Text = Replace(as_Text, "$PanelPriceM2_M$", mo_Tools.DblToScreen(lo_Offer.OFD_CostM2), , , vbTextCompare)
    End If
    
    as_Text = Replace(as_Text, "$CLS_Name1$", CLS_Name1, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name2$", CLS_Name2, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name3$", CLS_Name3, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name4$", CLS_Name4, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name5$", CLS_Name5, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name6$", CLS_Name6, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name7$", CLS_Name7, , , vbTextCompare)
    as_Text = Replace(as_Text, "$CLS_Name8$", CLS_Name8, , , vbTextCompare)
    
    For ll_Idx = 0 To UBound(ma_CostCalc)
      as_Text = Replace(as_Text, "$PCC" & ma_CostCalc(ll_Idx).Code & "_PCC_CostM2$", mo_Tools.DblToScreen(ma_CostCalc(ll_Idx).CostM2), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PCC" & ma_CostCalc(ll_Idx).Code & "_PCC_CostPCS$", mo_Tools.DblToScreen(ma_CostCalc(ll_Idx).CostPCS), , , vbTextCompare)
    
      as_Text = Replace(as_Text, "$PCC" & ma_CostCalc(ll_Idx).Code & "_PCC_DirectSetupCost$", mo_Tools.DblToScreen(ma_CostCalc(ll_Idx).DirectSetupCost), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PCC" & ma_CostCalc(ll_Idx).Code & "_PCC_SubSetupCost$", mo_Tools.DblToScreen(ma_CostCalc(ll_Idx).SubSetupCost), , , vbTextCompare)
      as_Text = Replace(as_Text, "$PCC" & ma_CostCalc(ll_Idx).Code & "_PCC_TotSetupCost$", mo_Tools.DblToScreen(ma_CostCalc(ll_Idx).TotSetupCost), , , vbTextCompare)
    Next
'  End If
  
'  If (ll_ATS_Id = 0) Or (ll_ATS_Id = 5) Then
'    If (al_RecIdx > 0) And (al_RecIdx <= Inlays.Count) Then
'      Set lo_Inlay = Inlays(al_RecIdx)
'    Else
'      Set lo_Inlay = New DPC_Inlay
'      Set lo_Inlay.Tools = mo_Tools
'    End If
'    as_Text = lo_Inlay.ReplaceValuePlaceholder(as_Text)
'    Set lo_Inlay = Nothing
'  End If
'
'  If (ll_ATS_Id = 0) Or (ll_ATS_Id = 6) Then
'    If (al_RecIdx > 0) And (al_RecIdx <= Cutouts.Count) Then
'      Set lo_Cutout = Cutouts(al_RecIdx)
'    Else
'      Set lo_Cutout = New DPC_Cutout
'      Set lo_Cutout.Tools = mo_Tools
'    End If
'    as_Text = lo_Cutout.ReplaceValuePlaceholder(as_Text)
'    Set lo_Cutout = Nothing
'  End If
  
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValuePlaceholder")
End Function


Public Sub LoadPrdCutout(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String
Dim lo_Cutout As DPC_Cutout
Dim ll_CAT_Id As Long
Dim ll_DOF_Id As Long

  ls_req = "exec DPC_PrdCut_lst $PRD_Id$, $Language_code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(ll_Cursor)
    Set lo_Cutout = New DPC_Cutout
    Call InitCutout(lo_Cutout, mo_Db.GetFields(ll_Cursor, "PCT_Type"), eDPCRowStatus.rsNone)
    lo_Cutout.PCT_Id = mo_Db.GetFields(ll_Cursor, "PCT_Id")
    lo_Cutout.PCT_Type = mo_Db.GetFields(ll_Cursor, "PCT_Type")
    lo_Cutout.PCT_Std = StrComp(mo_Db.GetFields(ll_Cursor, "PCT_Std"), "X", vbTextCompare) = 0
    lo_Cutout.CUT_Id = mo_Db.GetFields(ll_Cursor, "CUT_Id")
    lo_Cutout.CUT_Code = mo_Db.GetFields(ll_Cursor, "CUT_Code")
    lo_Cutout.CUT_Name = mo_Db.GetFields(ll_Cursor, "CUT_Name")
    lo_Cutout.CUT_Desc = mo_Db.GetFields(ll_Cursor, "CUT_Desc")
    lo_Cutout.CUT_Shape = mo_Db.GetFields(ll_Cursor, "CUT_Shape")
    lo_Cutout.IMG_Id = mo_Db.GetFields(ll_Cursor, "IMG_Id")
    lo_Cutout.IMG_IdShp = mo_Db.GetFields(ll_Cursor, "IMG_IdShp")
    lo_Cutout.PCT_SizeJ = mo_Db.GetFields(ll_Cursor, "PCT_SizeJ")
    lo_Cutout.PCT_SizeK = mo_Db.GetFields(ll_Cursor, "PCT_SizeK")
    lo_Cutout.PCT_SizeD = mo_Db.GetFields(ll_Cursor, "PCT_SizeD")
    lo_Cutout.PCT_SizeL = mo_Db.GetFields(ll_Cursor, "PCT_SizeL")
    lo_Cutout.PCT_SizeM = mo_Db.GetFields(ll_Cursor, "PCT_SizeM")
    lo_Cutout.PCT_Order = mo_Db.GetFields(ll_Cursor, "PCT_Order")
    
    lo_Cutout.CUT_MinJ = mo_Db.GetFields(ll_Cursor, "CUT_MinJ")
    lo_Cutout.CUT_MaxJ = mo_Db.GetFields(ll_Cursor, "CUT_MaxJ")
    lo_Cutout.CUT_MinK = mo_Db.GetFields(ll_Cursor, "CUT_MinK")
    lo_Cutout.CUT_MaxK = mo_Db.GetFields(ll_Cursor, "CUT_MaxK")
    lo_Cutout.CUT_MinL = mo_Db.GetFields(ll_Cursor, "CUT_MinL")
    lo_Cutout.CUT_MinM = mo_Db.GetFields(ll_Cursor, "CUT_MinM")
    Call Cutouts.Add(lo_Cutout)
    Call mo_Db.Next(ll_Cursor)
  Wend
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdCutout")
End Sub

Public Sub LoadPrdInlay(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String
Dim lo_Inlay As DPC_Inlay
Dim ll_CAT_Id As Long
Dim ll_DOF_Id As Long

  ls_req = "exec DPC_PrdInlay_lst $PRD_Id$, $Language_code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(ll_Cursor)
    Set lo_Inlay = New DPC_Inlay
    Call InitInlay(lo_Inlay, eDPCRowStatus.rsNone)
    lo_Inlay.PIN_Id = mo_Db.GetFields(ll_Cursor, "PIN_Id")
    lo_Inlay.Language_Code = Language_Code
    
    lo_Inlay.INL_Id = mo_Db.GetFields(ll_Cursor, "INL_Id")
    lo_Inlay.INL_IsCus = StrComp(mo_Db.GetFields(ll_Cursor, "INL_IsCus"), "X", vbTextCompare) = 0
    lo_Inlay.INL_Code = mo_Db.GetFields(ll_Cursor, "INL_Code")
    lo_Inlay.INL_Name = mo_Db.GetFields(ll_Cursor, "INL_Name")
    'lo_Inlay.INL_Text = GetErrorText(eDPCError.erInlayCustomSelected)
    lo_Inlay.INL_Desc = mo_Db.GetFields(ll_Cursor, "INL_Desc")
    lo_Inlay.INL_Type = mo_Db.GetFields(ll_Cursor, "INL_Type")
    lo_Inlay.INL_Vend = mo_Db.GetFields(ll_Cursor, "INL_Vend")
    lo_Inlay.INL_Deliv = mo_Db.GetFields(ll_Cursor, "INL_Deliv")
    lo_Inlay.INL_DelivDesc = mo_Db.GetFields(ll_Cursor, "INL_DelivDesc")
    lo_Inlay.INL_TypeDesc = mo_Db.GetFields(ll_Cursor, "INL_TypeDesc")
    lo_Inlay.INL_CE = mo_Db.GetFields(ll_Cursor, "INL_CE")
    lo_Inlay.PIN_Code = mo_Db.GetFields(ll_Cursor, "PIN_Code")
    lo_Inlay.PIN_Purch = mo_Db.GetFields(ll_Cursor, "PIN_Purch")
    lo_Inlay.PIN_PurchDesc = mo_Db.GetFields(ll_Cursor, "PIN_PurchDesc")
    lo_Inlay.PIN_Deliv = mo_Db.GetFields(ll_Cursor, "PIN_Deliv")
    lo_Inlay.PIN_DelivDesc = mo_Db.GetFields(ll_Cursor, "PIN_DelivDesc")
    lo_Inlay.PIN_Order = mo_Db.GetFields(ll_Cursor, "PIN_Order")
    lo_Inlay.PIN_ExName = mo_Db.GetFields(ll_Cursor, "PIN_ExName")
    lo_Inlay.PIN_CE = mo_Db.GetFields(ll_Cursor, "PIN_CE")
    
    lo_Inlay.PIN_Std = StrComp(mo_Db.GetFields(ll_Cursor, "PIN_Std"), "X", vbTextCompare) = 0
    lo_Inlay.PIN_SizeA = mo_Db.GetFields(ll_Cursor, "PIN_SizeA")
    lo_Inlay.PIN_SizeB = mo_Db.GetFields(ll_Cursor, "PIN_SizeB")
    lo_Inlay.IMG_Id = mo_Db.GetFields(ll_Cursor, "IMG_Id")
    
    Call Inlays.Add(lo_Inlay)
    Call mo_Db.Next(ll_Cursor)
  Wend
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdInlay")
End Sub

Public Sub LoadOfferOptions(ByVal as_COF_Id As String)
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String
Dim lo_Offer As DPC_OfferPos

  Call mo_Tools.ClearCollection(OfferOptions)
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$, $OFD_IsAlt$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", mo_Tools.SQLStr("X"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", mo_Tools.SqlInt(eDPCOfferDetailMain.odMain), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IsAlt$", mo_Tools.SqlInt(eDPCOfferDetailIsAlt.maOption), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(ll_Cursor)
    Set lo_Offer = New DPC_OfferPos
    Set lo_Offer.Tools = mo_Tools
    Call lo_Offer.Init(0, 0, eDPCQtyType.qtUnknown, 1, ModuleSurface)
    Call lo_Offer.ReadOfferPos(mo_Db, ll_Cursor)
    Call OfferOptions.Add(lo_Offer)
    Call mo_Db.Next(ll_Cursor)
  Wend
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOfferOptions")
End Sub

'Public Sub ReadOption(ByVal ac_Cursor As Long, ByVal ao_Option As DPC_Option)
'On Error GoTo ErrHandler
'
'    ao_Option.POP_Id = mo_Db.GetFields(ac_Cursor, "POP_Id")
'    ao_Option.SYS_Id = mo_Db.GetFields(ac_Cursor, "SYS_Id")
'    ao_Option.OPT_Id = mo_Db.GetFields(ac_Cursor, "OPT_Id")
'    ao_Option.OPT_Code = mo_Db.GetFields(ac_Cursor, "OPT_Code")
'    ao_Option.OPT_Name = mo_Db.GetFields(ac_Cursor, "OPT_Name")
'    ao_Option.OPT_Desc = mo_Db.GetFields(ac_Cursor, "OPT_Desc")
'    ao_Option.POP_QMin = mo_Db.GetFields(ac_Cursor, "POP_QMin")
'    ao_Option.POP_QMax = mo_Db.GetFields(ac_Cursor, "POP_QMax")
'    ao_Option.POP_Qty = mo_Db.GetFields(ac_Cursor, "POP_Qty")
'    ao_Option.UM_CodeC = mo_Db.GetFields(ac_Cursor, "UM_Code")
'    ao_Option.POP_Cost = mo_Db.GetFields(ac_Cursor, "POP_Cost")
'    ao_Option.CURR_Code = mo_Db.GetFields(ac_Cursor, "CURR_Code")
'  Exit Sub
'ErrHandler:
'  Call errorHandler("ReadOption")
'End Sub

Public Sub LoadPrdText(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim lo_Error As DPC_Error
Dim lo_Inlay As DPC_Inlay

  ls_req = "exec DPC_Text_lst $PRD_Id$, $Language_Code$, $COF_Id$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Error = New DPC_Error
    Set lo_Error.Tools = mo_Tools
    lo_Error.ERR_ID = mo_Db.GetFields(lc_Cursor, "ERR_Id")
    lo_Error.LEV_Id = mo_Db.GetFields(lc_Cursor, "LEV_Id")
    lo_Error.ERR_Type = mo_Db.GetFields(lc_Cursor, "ERR_Type")
    lo_Error.MsgId = mo_Db.GetFields(lc_Cursor, "MsgId")
    lo_Error.ERR_Ctrl = mo_Db.GetFields(lc_Cursor, "ERR_Ctrl")
    lo_Error.ERR_Offer = StrComp(mo_Db.GetFields(mc_Error, "ERR_Offer"), "X", vbTextCompare) = 0
    lo_Error.Message_Text = mo_Db.GetFields(lc_Cursor, "Message_Text")
    lo_Error.TXT_Tag = mo_Db.GetFields(lc_Cursor, "TXT_Tag")
    lo_Error.Language_Code = mo_Db.GetFields(lc_Cursor, "Language_Code")
    lo_Error.TXT_Text = mo_Db.GetFields(lc_Cursor, "TXT_Text")
    Call Errors.Add(lo_Error)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  
  For Each lo_Error In Errors
    If lo_Error.ERR_ID = eDPCError.erCoatingName Then
      COA_Name = GetErrorText(eDPCError.erCoatingName, Nothing)
    ElseIf lo_Error.ERR_ID = eDPCError.erCoatingDesc Then
      COA_Desc = GetErrorText(eDPCError.erCoatingDesc, Nothing)
    ElseIf lo_Error.ERR_ID = eDPCError.erInlayName Then
      For Each lo_Inlay In Inlays
        If lo_Inlay.PIN_Id = lo_Error.TXT_Tag Then
          lo_Inlay.INL_Name = lo_Error.TXT_Text
          Set lo_Error.Tag = lo_Inlay
          Exit For
        End If
      Next
    ElseIf lo_Error.ERR_ID = eDPCError.erInlayDesc Then
      For Each lo_Inlay In Inlays
        If lo_Inlay.PIN_Id = lo_Error.TXT_Tag Then
          lo_Inlay.INL_Desc = lo_Error.TXT_Text
          Set lo_Error.Tag = lo_Inlay
          Exit For
        End If
      Next
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdText")
End Sub

Public Sub InitCutout(ByVal ao_Cutout As DPC_Cutout, ByVal al_CutoutType As Long, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

Dim ll_CAT_Id As Long
Dim ll_DOF_Id As Long
Dim lo_Offer As DPC_OfferPos
    
    Set ao_Cutout.Tools = mo_Tools
    Set ao_Cutout.ArmDb = mo_Db
    Call ao_Cutout.Clear
    ao_Cutout.Language_Code = ms_Language_Code
    ml_Idx = ml_Idx + 1
    ao_Cutout.Idx = ml_Idx
    ao_Cutout.PCT_Type = al_CutoutType
    ao_Cutout.RowStatus = ae_RowStatus
    Call ao_Cutout.Load_A_COM
    Call mo_Db.First(mc_OfferTemplate)
    While Not mo_Db.EOF(mc_OfferTemplate)
      ll_CAT_Id = mo_Db.GetFields(mc_OfferTemplate, "CAT_Id")
      ll_DOF_Id = mo_Db.GetFields(mc_OfferTemplate, "DOF_Id")
      If (al_CutoutType = eDPCCutoutType.eCutout) And (ll_CAT_Id = eDPCCategory.cgCutout) Then
        Set lo_Offer = CreateOfferPos(ao_Cutout.OfferPrice, mc_OfferTemplate, ao_Cutout.PCT_Id, ao_Cutout.CUT_Code)
      ElseIf (al_CutoutType = eDPCCutoutType.eLoudspeaker) And (ll_CAT_Id = eDPCCategory.cgLoudspeaker) Then
        Set lo_Offer = CreateOfferPos(ao_Cutout.OfferPrice, mc_OfferTemplate, ao_Cutout.PCT_Id, ao_Cutout.CUT_Code)
      ElseIf (al_CutoutType = eDPCCutoutType.eVentilation) And (ll_CAT_Id = eDPCCategory.cgVentilation) Then
        Set lo_Offer = CreateOfferPos(ao_Cutout.OfferPrice, mc_OfferTemplate, ao_Cutout.PCT_Id, ao_Cutout.CUT_Code)
      End If
      Call mo_Db.Next(mc_OfferTemplate)
    Wend
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitCutout")
End Sub

Public Sub InitInlay(ByVal ao_Inlay As DPC_Inlay, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

Dim ll_CAT_Id As Long
Dim ll_DOF_Id As Long
Dim lo_Offer As DPC_OfferPos
    
    Set ao_Inlay.Tools = mo_Tools
    Set ao_Inlay.ArmDb = mo_Db
    ao_Inlay.Language_Code = ms_Language_Code
    ao_Inlay.RowStatus = ae_RowStatus
    ml_Idx = ml_Idx + 1
    ao_Inlay.Idx = ml_Idx
    Call ao_Inlay.Load_A_COM
    Call ao_Inlay.Clear
    Call ao_Inlay.CalcInlaySize(Me)
    ao_Inlay.PIN_Order = (Inlays.Count + 1)
    Call mo_Db.First(mc_OfferTemplate)
    While Not mo_Db.EOF(mc_OfferTemplate)
      ll_CAT_Id = mo_Db.GetFields(mc_OfferTemplate, "CAT_Id")
      ll_DOF_Id = mo_Db.GetFields(mc_OfferTemplate, "DOF_Id")
      If (ll_CAT_Id = eDPCCategory.cgInlay) Then
        Set lo_Offer = CreateOfferPos(ao_Inlay.OfferPrice, mc_OfferTemplate, ao_Inlay.PIN_Id, ao_Inlay.INL_Code)
      End If
      Call mo_Db.Next(mc_OfferTemplate)
    Wend
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitInlay")
End Sub

Public Sub InitOption(ByVal ao_Option As DPC_Option, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

    Set ao_Option.Tools = mo_Tools
    ao_Option.RowStatus = ae_RowStatus
    ml_Idx = ml_Idx + 1
    ao_Option.Idx = ml_Idx
    ao_Option.POP_Id = ""
    ao_Option.SYS_Id = 0
    ao_Option.OPT_Id = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitOption")
End Sub

Public Sub InitBOM(ByVal ao_BOM As DPC_BOM, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler
    
    Call ao_BOM.Clear
    Set ao_BOM.Tools = mo_Tools
    ao_BOM.RowStatus = ae_RowStatus
    ao_BOM.BOM_StlIdentNr = PRD_Code
    ml_Idx = ml_Idx + 1
    ao_BOM.Idx = ml_Idx
    'Set ao_BOM.ArmDb = mo_Db
    ao_BOM.BOM_Pos = (BOMs.Count + 1) * 10
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitBOM")
End Sub

Public Sub InitFile(ByVal ao_File As DPC_File, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler
    
    Set ao_File.Tools = mo_Tools
    ao_File.RowStatus = ae_RowStatus
    ml_Idx = ml_Idx + 1
    ao_File.Idx = ml_Idx
    Call ao_File.Clear
    ao_File.PFI_Order = (Files.Count + 1) * 10
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitFile")
End Sub

Public Sub AddBOM(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler
    
    Call BOMs.Add(ao_BOM)
  Exit Sub
ErrHandler:
  Call ErrorHandler("AddBOM")
End Sub

Public Sub InitBOR(ByVal ao_BOR As DPC_BOR, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler
    
    Call ao_BOR.Clear
    Set ao_BOR.Tools = mo_Tools
    ao_BOR.RowStatus = ae_RowStatus
    ao_BOR.BOR_AplIdentNr = PRD_Code
    ml_Idx = ml_Idx + 1
    ao_BOR.Idx = ml_Idx
    'Set ao_BOR.ArmDb = mo_Db
    ao_BOR.BOR_Pos = (BORs.Count + 1) * 10
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitBOR")
End Sub

Public Sub AddBOR(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler
    
  Call BORs.Add(ao_BOR)
  Exit Sub
ErrHandler:
  Call ErrorHandler("AddBOR")
End Sub

Public Function GetPriceMatrix() As Long
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String
  
  GetPriceMatrix = 0
  If PanelQtyM2 <= 0 Then Exit Function
  If MAT_Id = 0 Then Exit Function
  
  ls_req = "exec DPC_Price_lst3 $PRD_Id$, $MAT_Id$, $RPL_Thick$, $CT_Code$, $CURR_Code$, $VDate$, $Qty$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlInt(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Thick$", mo_Tools.SqlDbl(RPL_Thick), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$VDate$", mo_Tools.SqlDate(ValidityDate), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(PanelQtyM2), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  GetPriceMatrix = ll_Cursor
  Exit Function
ErrHandler:
  Call ErrorHandler("GetPriceMatrix")
End Function

Public Sub SetStandardPanelUZS(ByVal al_SideIdx As Long)
On Error GoTo ErrHandler

Dim lb_IsStandard As Boolean

  lb_IsStandard = False
  If ((al_SideIdx = eDPCSide.esSideC) Or (al_SideIdx = eDPCSide.esSideD)) And (RPL_SUZA) Then
    lb_IsStandard = True
  End If
  If ((al_SideIdx = eDPCSide.esSideE) Or (al_SideIdx = eDPCSide.esSideF)) And (RPL_SUZB) Then
    lb_IsStandard = True
  End If
  
  If lb_IsStandard Then
    If IsDefaultBendingOn(al_SideIdx) Then
      RPL_U(al_SideIdx) = mo_TempProduct.RPL_U(al_SideIdx)
      RPL_UMin(al_SideIdx) = mo_TempProduct.RPL_UMin(al_SideIdx)
      RPL_UMax(al_SideIdx) = mo_TempProduct.RPL_UMax(al_SideIdx)
      RPL_S(al_SideIdx) = mo_TempProduct.RPL_S(al_SideIdx)
    Else
      RPL_U(al_SideIdx) = BND_UMin(al_SideIdx)
      RPL_UMin(al_SideIdx) = BND_UMin(al_SideIdx)
      RPL_UMax(al_SideIdx) = BND_UMax(al_SideIdx)
      RPL_S(al_SideIdx) = BND_S(al_SideIdx)
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetStandardPanelUZS")
End Sub

Public Sub SetDefaultValues()
On Error GoTo ErrHandler

Dim ll_SideIdx As Long
Dim ls_Request As String
Dim ls_PRD_Id As String

  ' panel
  
  ' bending
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    If BND_Id(ll_SideIdx) = "" Then
      Call LoadBending(ll_SideIdx, mo_TempProduct.BND_Id(ll_SideIdx))
    End If
  Next
  
  ' gasket
  If (Not HasGasket) And (RPL_GskDe = eDPCGasketDelivery.gdUndef) Then
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      
      ls_Request = "exec DPC_Gasket_sel2 $GSK_Type$, $GSK_Gap$, $Language_Code$"
        
      ls_Request = Replace(ls_Request, "$GSK_Type$", mo_Tools.SqlInt(eDPCGasketType.gtGasket), , , vbTextCompare)
      ls_Request = Replace(ls_Request, "$GSK_Gap$", mo_Tools.SqlDbl(RPL_Gap(ll_SideIdx)), , , vbTextCompare)
      ls_Request = ReplaceCommonPlaceholders(ls_Request)
      ls_PRD_Id = mo_Tools.SelectValue(mo_Db, ls_Request)
      Call LoadGasket(eDPCGasketType.gtGasket, ll_SideIdx, ls_PRD_Id)
    Next
  End If
  
  If (RPL_GskDe = eDPCGasketDelivery.gdUndef) Then
    If HasGasket Then
      'RPL_GskDe = eDPCGasketDelivery.gdInstalled
      Call LoadGasketDelivery(eDPCGasketDelivery.gdInstalled)
    Else
      'RPL_GskDe = eDPCGasketDelivery.gdNoneGasket
      Call LoadGasketDelivery(eDPCGasketDelivery.gdNoneGasket)
    End If
  End If
  
  ' spacer
'  If (Not HasSpacer) And (RPL_SpcDe = eDPCSpacerDelivery.sdUndef) Then
'    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
'      ls_Request = "exec DPC_Gasket_sel2 $GSK_Type$, $GSK_Gap$, $Language_Code$"
'
'      ls_Request = Replace(ls_Request, "$GSK_Type$", mo_Tools.SqlInt(eDPCGasketType.gtSpacer), , , vbTextCompare)
'      ls_Request = Replace(ls_Request, "$GSK_Gap$", mo_Tools.SqlDbl(RPL_Gap(ll_SideIdx)), , , vbTextCompare)
'      ls_Request = ReplaceCommonPlaceholders(ls_Request)
'      ls_PRD_Id = mo_Tools.SelectValue(mo_Db, ls_Request)
'      Call LoadGasket(eDPCGasketType.gtSpacer, ll_SideIdx, ls_PRD_Id)
'    Next
'  End If
  
  If (RPL_SpcDe = eDPCSpacerDelivery.sdUndef) Then
    If HasSpacer Then
      'RPL_SpcDe = eDPCSpacerDelivery.sdInstalled
      Call LoadSpacerDelivery(eDPCSpacerDelivery.sdInstalled)
    Else
      'RPL_SpcDe = eDPCSpacerDelivery.sdNoneSpacer
      Call LoadSpacerDelivery(eDPCSpacerDelivery.sdNoneSpacer)
    End If
  End If
  
  ' perforation
  If (Not HasPerforation) And (NoPerforation = False) Then
    NoPerforation = True
  ElseIf RPL_PBord = eDPCPerforationBorderType.pbUndef Then
    RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated
  End If
  
  ' inlay
  If (Not HasInlay) And (NoInlay = False) Then
    NoInlay = True
  End If
  
  ' coating
  If (Not HasCoating) Then
    Call LoadCoating(mo_TempProduct.COA_Id)
  End If
  
  ' ventilation
  If (Not HasVentilation) And (NoVentilation = False) Then
    NoVentilation = True
  End If
  
  ' loudspeaker
  If (Not HasLoudspeaker) And (NoLoudspeaker = False) Then
    NoLoudspeaker = True
  End If
  
  ' cutout
  If (Not HasCutout) And (NoCutout = False) Then
    NoCutout = True
  End If
  
  ' option
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetDefaultValues")
End Sub

'Public Sub LoadThickness()
'On Error GoTo ErrHandler
'
'Dim ll_Cursor As Long
'Dim ls_Req As String
'
'  ls_Req = "exec DPC_PriceCrit_Thick_sel $PRD_Id$, $RPL_PanA$, $RPL_PanB$, $MAT_Id$"
'
'  ls_Req = Replace(ls_Req, "$PRD_Id$", mo_Tools.SqlStr(PRD_IdPar), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$MAT_Id$", mo_Tools.SqlInt(MAT_Id), , , vbTextCompare)
'  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Req)
'  If mo_Db.RowCount(ll_Cursor) = 1 Then
'    RPL_Thick = mo_Db.GetFields(ll_Cursor, "PCR_Thick")
'    Call LoadThicknessHeight(True, True, False)
'  Else
'    Call LoadThicknessHeight(True, True, True)
'  End If
'  Call mo_Db.Close(ll_Cursor)
'  Exit Sub
'ErrHandler:
'  Call ErrorHandler("LoadThickness")
'End Sub

Public Sub LoadDefaultThicknessHeight(ByRef ad_Thickness As Double, ByRef ad_Height As Double)
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String

  ad_Thickness = 0
  ad_Height = 0
  ls_req = "exec DPC_MatThick_sel2 $SYS_Id$,$MAT_Id$, $RPL_PanA$, $RPL_PanB$"
  
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlInt(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) > 0 Then
    ad_Height = mo_Db.GetFields(ll_Cursor, "MTH_H")
    ad_Thickness = mo_Db.GetFields(ll_Cursor, "MTH_Thick")
  End If
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadDefaultThicknessHeight")
End Sub

Public Sub LoadThicknessHeight(ByVal ab_UpdateHeightA As Boolean, ByVal ab_UpdateHeightB As Boolean, ByVal ab_LoadThickness As Boolean)
On Error GoTo ErrHandler

Dim ld_Thickness As Double
Dim ld_Height As Double

  If IsFixed And Not (mo_TempProduct Is Nothing) Then
    If ab_UpdateHeightA And RPL_SUZA Then
      RPL_H(eDPCSide.esSideC) = mo_TempProduct.RPL_H(eDPCSide.esSideC)
      RPL_H(eDPCSide.esSideD) = mo_TempProduct.RPL_H(eDPCSide.esSideD)
    End If
    If ab_UpdateHeightB And RPL_SUZB Then
      RPL_H(eDPCSide.esSideE) = mo_TempProduct.RPL_H(eDPCSide.esSideE)
      RPL_H(eDPCSide.esSideF) = mo_TempProduct.RPL_H(eDPCSide.esSideF)
    End If
    If ab_LoadThickness Then
      RPL_Thick = mo_TempProduct.RPL_Thick
    End If
  Else
    Call LoadDefaultThicknessHeight(ld_Thickness, ld_Height)
    
    If Not (mo_TempProduct Is Nothing) Then
      If mo_TempProduct.RPL_Thick > 0 Then
        ld_Thickness = mo_TempProduct.RPL_Thick
      End If
    End If
    
    If ab_UpdateHeightA And RPL_SUZA Then
      RPL_H(eDPCSide.esSideC) = ld_Height
      RPL_H(eDPCSide.esSideD) = ld_Height
    End If
    
    If ab_UpdateHeightB And RPL_SUZB Then
      If IsDefaultBendingOn(eDPCSide.esSideE) Then
        RPL_H(eDPCSide.esSideE) = mo_TempProduct.RPL_H(eDPCSide.esSideE)
      Else
        RPL_H(eDPCSide.esSideE) = BND_H(eDPCSide.esSideE)
      End If
      If IsDefaultBendingOn(eDPCSide.esSideF) Then
        RPL_H(eDPCSide.esSideF) = mo_TempProduct.RPL_H(eDPCSide.esSideF)
      Else
        RPL_H(eDPCSide.esSideF) = BND_H(eDPCSide.esSideF)
      End If
    End If
    
    If ab_LoadThickness Then
      RPL_Thick = ld_Thickness
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadThicknessHeight")
End Sub

Public Sub LoadPanelPrice()
On Error GoTo ErrHandler

Dim lo_OfferPanel As DPC_OfferPos

Dim lo_OfferSetupChargeUnp As DPC_OfferPos
Dim lo_OfferChangeAUnp As DPC_OfferPos
Dim lo_OfferChangeBUnp As DPC_OfferPos

Dim lo_OfferSetupChargePrf As DPC_OfferPos
Dim lo_OfferChangeAPrf As DPC_OfferPos
Dim lo_OfferChangeBPrf As DPC_OfferPos

  Set lo_OfferPanel = GetOfferPos(eDPCOfferDetail.odPanelCost)
  Call lo_OfferPanel.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferSetupChargeUnp = GetOfferPos(eDPCOfferDetail.odPanelSetupChargeUnp)
  Call lo_OfferSetupChargeUnp.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  Set lo_OfferChangeAUnp = GetOfferPos(eDPCOfferDetail.odPanelChangeLengthCostUnp)
  Call lo_OfferChangeAUnp.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  Set lo_OfferChangeBUnp = GetOfferPos(eDPCOfferDetail.odPanelChangeWidthCostUnp)
  Call lo_OfferChangeBUnp.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferSetupChargePrf = GetOfferPos(eDPCOfferDetail.odPanelSetupChargePrf)
  Call lo_OfferSetupChargePrf.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  Set lo_OfferChangeAPrf = GetOfferPos(eDPCOfferDetail.odPanelChangeLengthCostPrf)
  Call lo_OfferChangeAPrf.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  Set lo_OfferChangeBPrf = GetOfferPos(eDPCOfferDetail.odPanelChangeWidthCostPrf)
  Call lo_OfferChangeBPrf.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  If (RPL_PanA > 0) And (RPL_PanB > 0) And (QtyType <> eDPCQtyType.qtUnknown) Then
    If IsStandard Then
      Call LoadProductPrice(lo_OfferPanel, PRD_Id, Null, DPC_UOM_M2)
      lo_OfferSetupChargeUnp.OFD_Found = 1
      lo_OfferSetupChargeUnp.OFD_Valid = False
      lo_OfferChangeAUnp.OFD_Found = 1
      lo_OfferChangeAUnp.OFD_Valid = False
      lo_OfferChangeBUnp.OFD_Found = 1
      lo_OfferChangeBUnp.OFD_Valid = False
      
      lo_OfferSetupChargePrf.OFD_Found = 1
      lo_OfferSetupChargePrf.OFD_Valid = False
      lo_OfferChangeAPrf.OFD_Found = 1
      lo_OfferChangeAPrf.OFD_Valid = False
      lo_OfferChangeBPrf.OFD_Found = 1
      lo_OfferChangeBPrf.OFD_Valid = False
    Else
      Call LoadProductPrice(lo_OfferPanel, PRD_IdPar, Null, DPC_UOM_M2)
      
      Call LoadProductPrice(lo_OfferSetupChargeUnp, lo_OfferSetupChargeUnp.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      Call LoadProductPrice(lo_OfferChangeAUnp, lo_OfferChangeAUnp.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      Call LoadProductPrice(lo_OfferChangeBUnp, lo_OfferChangeBUnp.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      
      Call LoadProductPrice(lo_OfferSetupChargePrf, lo_OfferSetupChargePrf.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      Call LoadProductPrice(lo_OfferChangeAPrf, lo_OfferChangeAPrf.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      Call LoadProductPrice(lo_OfferChangeBPrf, lo_OfferChangeBPrf.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
      
      If HasPerforation Then
        lo_OfferSetupChargeUnp.OFD_Valid = False
        lo_OfferChangeAUnp.OFD_Valid = False
        lo_OfferChangeBUnp.OFD_Valid = False
      Else
        lo_OfferSetupChargePrf.OFD_Valid = False
        lo_OfferChangeAPrf.OFD_Valid = False
        lo_OfferChangeBPrf.OFD_Valid = False
      End If
    End If
    lo_OfferPanel.OFD_HPrice = LoadSystemHistPrice(CT_Code, SYS_Id, PRF_Class)
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPanelPrice")
End Sub

Public Sub LoadGasketPrice()
On Error GoTo ErrHandler

Dim lo_OfferGasket As DPC_OfferPos
Dim ll_GasketCnt As Long
'Dim ll_SideIdx As Long
'Dim ls_GSK_Id As String

  Set lo_OfferGasket = GetOfferPos(eDPCOfferDetail.odGasketSurcharge)
  Call lo_OfferGasket.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  ll_GasketCnt = 0
  If IsGasketOn(eDPCSide.esSideC) Then
    ll_GasketCnt = ll_GasketCnt + 1
  End If
  If IsGasketOn(eDPCSide.esSideD) Then
    ll_GasketCnt = ll_GasketCnt + 1
  End If
  If IsGasketOn(eDPCSide.esSideE) Then
    ll_GasketCnt = ll_GasketCnt + 1
  End If
  If IsGasketOn(eDPCSide.esSideF) Then
    ll_GasketCnt = ll_GasketCnt + 1
  End If
  
'  ls_GSK_Id = ""
'  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
'    If (ls_GSK_Id = "") And IsGasketOn(ll_SideIdx) Then
'      ls_GSK_Id = GSK_Id(ll_SideIdx)
'    End If
'    If IsGasketOn(ll_SideIdx) Then
'      If GSK_Id(ll_SideIdx) <> ls_GSK_Id Then
'        ls_GSK_Id = ""
'        Exit For
'      End If
'    End If
'  Next
  
  If (ll_GasketCnt = 0) Or IsStandard Or HasDefaultGasket Then
    lo_OfferGasket.OFD_Found = 1
  Else
    Call LoadProductPrice(lo_OfferGasket, lo_OfferGasket.SCH_Id, Null, DPC_UOM_M2, Null, Null, ll_GasketCnt)
  End If

  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadGasketPrice")
End Sub

Public Sub LoadSpacerPrice()
On Error GoTo ErrHandler

Dim lo_OfferSpacer As DPC_OfferPos
Dim ll_SpacerCnt As Long
'Dim ll_SideIdx As Long
'Dim ls_GSK_Id2 As String

  Set lo_OfferSpacer = GetOfferPos(eDPCOfferDetail.odSpacerSurcharge)
  Call lo_OfferSpacer.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  ll_SpacerCnt = 0
  If IsSpacerOn(eDPCSide.esSideC) Then
    ll_SpacerCnt = ll_SpacerCnt + 1
  End If
  If IsSpacerOn(eDPCSide.esSideD) Then
    ll_SpacerCnt = ll_SpacerCnt + 1
  End If
  If IsSpacerOn(eDPCSide.esSideE) Then
    ll_SpacerCnt = ll_SpacerCnt + 1
  End If
  If IsSpacerOn(eDPCSide.esSideF) Then
    ll_SpacerCnt = ll_SpacerCnt + 1
  End If

'  ls_GSK_Id2 = ""
'  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
'    If (ls_GSK_Id2 = "") And IsGasketOn(ll_SideIdx) Then
'      ls_GSK_Id2 = GSK_Id(ll_SideIdx)
'    End If
'    If IsGasketOn(ll_SideIdx) Then
'      If GSK_Id(ll_SideIdx) <> ls_GSK_Id2 Then
'        ls_GSK_Id2 = ""
'        Exit For
'      End If
'    End If
'  Next
  
  If (ll_SpacerCnt = 0) Or IsStandard Or HasDefaultSpacer Then
    lo_OfferSpacer.OFD_Found = 1
  Else
    Call LoadProductPrice(lo_OfferSpacer, lo_OfferSpacer.SCH_Id, Null, DPC_UOM_M2, Null, Null, ll_SpacerCnt)
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSpacerPrice")
End Sub

Public Sub LoadPackingPrice()
On Error GoTo ErrHandler

Dim lo_OfferPkgPrice As DPC_OfferPos

  Set lo_OfferPkgPrice = GetOfferPos(eDPCOfferDetail.odPackingCost)
  Call lo_OfferPkgPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  If HasPacking Then
    If IsStandard Or HasDefaultPacking Then
      lo_OfferPkgPrice.OFD_Found = 1
    Else
      Call LoadProductPrice(lo_OfferPkgPrice, PKG_Id, Null, DPC_UOM_M2)
    End If
  Else
    lo_OfferPkgPrice.OFD_Found = 1
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPackingPrice")
End Sub

Public Sub LoadLabelingPrice()
On Error GoTo ErrHandler

Dim lo_OfferLabPrice As DPC_OfferPos

  Set lo_OfferLabPrice = GetOfferPos(eDPCOfferDetail.odLabelingCost)
  Call lo_OfferLabPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  If HasLabeling Then
    If IsStandard Then
      lo_OfferLabPrice.OFD_Found = 1
    Else
      Call LoadProductPrice(lo_OfferLabPrice, LAB_Id, Null, DPC_UOM_PCS)
    End If
  Else
    lo_OfferLabPrice.OFD_Found = 1
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadLabelingPrice")
End Sub

Public Sub LoadPerforationPrice()
On Error GoTo ErrHandler

Dim lo_OfferPrf  As DPC_OfferPos

  Set lo_OfferPrf = GetOfferPos(eDPCOfferDetail.odPerforationCost)
  Call lo_OfferPrf.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  If HasPerforation Then
    If IsStandard Or HasDefaultPerforation Then
      lo_OfferPrf.OFD_Found = 1
    Else
      Call LoadProductPrice(lo_OfferPrf, PRF_Id, Null, DPC_UOM_M2)
    End If
  Else
    lo_OfferPrf.OFD_Found = 1
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPerforationPrice")
End Sub

Public Sub LoadInlayPrice(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim lo_OfferInlPrice As DPC_OfferPos
Dim lo_OfferInlSetupCharge As DPC_OfferPos

  Set lo_OfferInlPrice = ao_Inlay.GetOfferPos(eDPCOfferDetail.odInlayCost)
  Call lo_OfferInlPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferInlSetupCharge = ao_Inlay.GetOfferPos(eDPCOfferDetail.odInlaySetupCharge)
  Call lo_OfferInlSetupCharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  If ao_Inlay.HasInlay Then
    If IsStandard Or IsDefaultInlay(ao_Inlay) Then
      lo_OfferInlPrice.OFD_Found = 1
      lo_OfferInlSetupCharge.OFD_Found = 1
      lo_OfferInlSetupCharge.OFD_Valid = False
    Else
      Call LoadProductPrice(lo_OfferInlPrice, ao_Inlay.INL_Id, Null, DPC_UOM_M2)
      Call LoadProductPrice(lo_OfferInlSetupCharge, lo_OfferInlSetupCharge.SCH_Id, PRD_IdPar, DPC_UOM_PCS)
    End If
    lo_OfferInlPrice.OFD_HPrice = LoadInlayHistPrice(CT_Code, ao_Inlay.INL_Id)
  Else
    lo_OfferInlPrice.OFD_Found = 1
    lo_OfferInlSetupCharge.OFD_Found = 1
    lo_OfferInlSetupCharge.OFD_Valid = False
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadInlayPrice")
End Sub

Public Sub LoadCoatingPrice()
On Error GoTo ErrHandler

Dim lo_OfferCoaPrice As DPC_OfferPos
Dim lo_OfferCoaSetupCharge As DPC_OfferPos

  Set lo_OfferCoaPrice = GetOfferPos(eDPCOfferDetail.odCoatingCost)
  Call lo_OfferCoaPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferCoaSetupCharge = GetOfferPos(eDPCOfferDetail.odCoatingSetupCharge)
  Call lo_OfferCoaSetupCharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  If IsStandard Then
    lo_OfferCoaPrice.OFD_Found = 1
    lo_OfferCoaSetupCharge.OFD_Found = 1
    lo_OfferCoaSetupCharge.OFD_Valid = False
  ElseIf HasCoating Then
    Call LoadProductPrice(lo_OfferCoaPrice, COA_Id, Null, DPC_UOM_M2, , , , RPL_CoSid)
    If HasDefaultCoating Then
      lo_OfferCoaSetupCharge.OFD_Found = 1
      lo_OfferCoaSetupCharge.OFD_Valid = False
    Else
      Call LoadProductPrice(lo_OfferCoaSetupCharge, lo_OfferCoaSetupCharge.SCH_Id, PRD_IdPar, DPC_UOM_PCS, Null, Null, Null, RPL_CoSid)
    End If
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCoatingPrice")
End Sub

Public Sub LoadVentilationPrice(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim lo_OfferVntPrice As DPC_OfferPos
Dim lo_OfferVntSetupCharge As DPC_OfferPos
Dim lo_OfferVntAddChange As DPC_OfferPos

  Set lo_OfferVntPrice = ao_Cutout.GetOfferPos(eDPCOfferDetail.odVentilationCost)
  Call lo_OfferVntPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferVntSetupCharge = ao_Cutout.GetOfferPos(eDPCOfferDetail.odVentilationSetupCharge)
  Call lo_OfferVntSetupCharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  Set lo_OfferVntAddChange = ao_Cutout.GetOfferPos(eDPCOfferDetail.odVentilationAddChangeCost)
  Call lo_OfferVntAddChange.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  If (CAT_Id = eDPCCategory.cgMetalPanelSKU) Then
    lo_OfferVntPrice.OFD_Found = 1
    lo_OfferVntSetupCharge.OFD_Found = 1
    lo_OfferVntSetupCharge.OFD_Valid = False
    lo_OfferVntAddChange.OFD_Found = 1
    lo_OfferVntAddChange.OFD_Valid = False
  Else
    If ao_Cutout.CUT_Shape = eDPCCutoutShape.eRectangular Then
      Call LoadProductPrice(lo_OfferVntPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferVntSetupCharge, lo_OfferVntSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferVntAddChange, lo_OfferVntAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
    ElseIf ao_Cutout.CUT_Shape = eDPCCutoutShape.eRound Then
      Call LoadProductPrice(lo_OfferVntPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferVntSetupCharge, lo_OfferVntSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferVntAddChange, lo_OfferVntAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
    End If
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadVentilationPrice")
End Sub

Public Sub LoadLoudspeakerPrice(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim lo_OfferLspPrice As DPC_OfferPos
Dim lo_OfferLspSetupCharge As DPC_OfferPos
Dim lo_OfferLspAddChange As DPC_OfferPos

  Set lo_OfferLspPrice = ao_Cutout.GetOfferPos(eDPCOfferDetail.odLoudspeakerCost)
  Call lo_OfferLspPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferLspSetupCharge = ao_Cutout.GetOfferPos(eDPCOfferDetail.odLoudspeakerSetupCharge)
  Call lo_OfferLspSetupCharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  Set lo_OfferLspAddChange = ao_Cutout.GetOfferPos(eDPCOfferDetail.odLoudspeakerAddChangeCost)
  Call lo_OfferLspAddChange.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  If (CAT_Id = eDPCCategory.cgMetalPanelSKU) Then
    lo_OfferLspPrice.OFD_Found = 1
    lo_OfferLspSetupCharge.OFD_Found = 1
    lo_OfferLspSetupCharge.OFD_Valid = False
    lo_OfferLspAddChange.OFD_Found = 1
    lo_OfferLspAddChange.OFD_Valid = False
  Else
    If ao_Cutout.CUT_Shape = eDPCCutoutShape.eRectangular Then
      Call LoadProductPrice(lo_OfferLspPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferLspSetupCharge, lo_OfferLspSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferLspAddChange, lo_OfferLspAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
    ElseIf ao_Cutout.CUT_Shape = eDPCCutoutShape.eRound Then
      Call LoadProductPrice(lo_OfferLspPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferLspSetupCharge, lo_OfferLspSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferLspAddChange, lo_OfferLspAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
    End If
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadLoudspeakerPrice")
End Sub

Public Sub LoadCutoutPrice(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim lo_OfferCutPrice As DPC_OfferPos
Dim lo_OfferCutSurcharge As DPC_OfferPos
Dim lo_OfferCutSetupCharge As DPC_OfferPos
Dim lo_OfferCutAddChange As DPC_OfferPos

  Set lo_OfferCutPrice = ao_Cutout.GetOfferPos(eDPCOfferDetail.odCutoutCost)
  Call lo_OfferCutPrice.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  Set lo_OfferCutSurcharge = ao_Cutout.GetOfferPos(eDPCOfferDetail.odCutoutSurcharge)
  Call lo_OfferCutSurcharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  Set lo_OfferCutSetupCharge = ao_Cutout.GetOfferPos(eDPCOfferDetail.odCutoutSetupCharge)
  Call lo_OfferCutSetupCharge.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)

  Set lo_OfferCutAddChange = ao_Cutout.GetOfferPos(eDPCOfferDetail.odCutoutAddChangeCost)
  Call lo_OfferCutAddChange.Init(PanelQty, PanelQty, QtyType, RPL_PU, ModuleSurface)
  
  If (CAT_Id = eDPCCategory.cgMetalPanelSKU) Then
    lo_OfferCutPrice.OFD_Found = 1
    lo_OfferCutSetupCharge.OFD_Found = 1
    lo_OfferCutSetupCharge.OFD_Valid = False
    lo_OfferCutAddChange.OFD_Found = 1
    lo_OfferCutAddChange.OFD_Valid = False
    lo_OfferCutSurcharge.OFD_Found = 1
    lo_OfferCutSurcharge.OFD_Valid = False
  Else
    If ao_Cutout.CUT_Shape = eDPCCutoutShape.eRectangular Then
      Call LoadProductPrice(lo_OfferCutPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferCutSetupCharge, lo_OfferCutSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferCutAddChange, lo_OfferCutAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
      Call LoadProductPrice(lo_OfferCutSurcharge, lo_OfferCutSurcharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, ao_Cutout.PCT_SizeJ, ao_Cutout.PCT_SizeK, Null)
    ElseIf ao_Cutout.CUT_Shape = eDPCCutoutShape.eRound Then
      Call LoadProductPrice(lo_OfferCutPrice, ao_Cutout.CUT_Id, Null, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferCutSetupCharge, lo_OfferCutSetupCharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferCutAddChange, lo_OfferCutAddChange.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
      Call LoadProductPrice(lo_OfferCutSurcharge, lo_OfferCutSurcharge.SCH_Id, ao_Cutout.CUT_Id, DPC_UOM_PCS, Null, Null, Null, Null, Null, Null, ao_Cutout.PCT_SizeD)
    End If
  End If
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCutoutPrice")
End Sub

Public Sub LoadSystemMargin()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lo_Offer As DPC_OfferPos
Dim lo_Inlay As DPC_Inlay
Dim lo_Cutout As DPC_Cutout
Dim lc_Cursor As Long
  
  OFD_MarginS = 0
  OFD_GTN = 0
  OFD_MarginMin = 0
  'If mo_Tools.GetAConfigData("DPC_PanelCalcMargin") = "X" Then
    ls_req = "exec DPC_SysMargin_sel $CT_Code$, $Language_Code$"
    ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(lc_Cursor) = 1 Then
      OFD_MarginS = mo_Db.GetFields(lc_Cursor, "SMA_PanMargin")
      OFD_GTN = mo_Db.GetFields(lc_Cursor, "SMA_PanGTN")
      OFD_MarginMin = mo_Db.GetFields(lc_Cursor, "SMA_PanMin")
    End If
    Call mo_Db.Close(lc_Cursor)
  'End If
  
  For Each lo_Offer In OfferPrice
    lo_Offer.OFD_MarginMin = OFD_MarginMin
    lo_Offer.OFD_MarginS = OFD_MarginS
    lo_Offer.OFD_GTN = OFD_GTN
    lo_Offer.OFD_Disco = 0
    If lo_Offer.DOF_Id <> eDPCOfferDetail.odPosition Then
      Call lo_Offer.CalculateGrossSellingPrice
      'Call lo_Offer.CalculatePriceAMargin(Margin)
    End If
  Next
  
  For Each lo_Inlay In Inlays
    For Each lo_Offer In lo_Inlay.OfferPrice
      lo_Offer.OFD_MarginMin = OFD_MarginMin
      lo_Offer.OFD_MarginS = OFD_MarginS
      lo_Offer.OFD_GTN = OFD_GTN
      lo_Offer.OFD_Disco = 0
      Call lo_Offer.CalculateGrossSellingPrice
      'Call lo_Offer.CalculatePriceAMargin(Margin)
    Next
  Next
  
  For Each lo_Cutout In Cutouts
    For Each lo_Offer In lo_Cutout.OfferPrice
      lo_Offer.OFD_MarginMin = OFD_MarginMin
      lo_Offer.OFD_MarginS = OFD_MarginS
      lo_Offer.OFD_GTN = OFD_GTN
      lo_Offer.OFD_Disco = 0
      Call lo_Offer.CalculateGrossSellingPrice
      'Call lo_Offer.CalculatePriceAMargin(Margin)
    Next
  Next
  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSystemMargin")
End Sub

Private Function LoadSystemHistPrice(ByVal as_CT_Code As String, ByVal al_SYS_Id As Long, ByVal as_PRF_Class As String) As Double
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "exec DPC_HistSysPrice_sel $CT_Code$, $SYS_Id$, $PRF_Class$, $Language_Code$"
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(as_CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(al_SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRF_Class$", mo_Tools.SQLStr(as_PRF_Class), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  LoadSystemHistPrice = mo_Tools.SelectValue(mo_Db, ls_req, "HSP_Price")
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadSystemHistPrice")
End Function

Private Function LoadInlayHistPrice(ByVal as_CT_Code As String, ByVal as_INL_Id As String) As Double
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "exec DPC_HistPrdPrice_sel $CT_Code$, $PRD_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(as_CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_INL_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  LoadInlayHistPrice = mo_Tools.SelectValue(mo_Db, ls_req, "HPP_Price")
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadInlayHistPrice")
End Function

Private Function LoadProductPrice(ByVal ao_Offer As DPC_OfferPos, ByVal as_PRD_Id As String, ByVal av_PRD_IdPar As Variant, ByVal as_UM_CodeC As String, _
  Optional ByVal av_CUA_Id As Variant = Null, Optional ByVal av_IsPerf As Variant = Null, Optional ByVal av_GasketCount As Variant = Null, _
  Optional ByVal av_ColSide As Variant = Null, Optional ByVal av_CUA_J As Variant = Null, Optional ByVal av_CUA_K As Variant = Null, Optional ByVal av_CUA_D As Variant = Null) As Boolean
  
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim ld_Cost As Double

  LoadProductPrice = False
  
  If (PanelQtyPCS = 0) Or (PanelQtyM2 = 0) Or (as_PRD_Id = "") Then
    ao_Offer.OFD_Found = 0
    Exit Function
  End If
  
  ls_req = "exec DPC_CostCrit_sel2 $PRD_Id$, $VEN_Id$, $CT_Code$, $CURR_Code$, $UM_CodeC$, $VDate$,$Qty$,$UM_CodeQ$,$PRD_IdPar$,$CUA_Id$,$PanelA$,$PanelB$,$MAT_Id$,$Thick$,$PCR_IsPrf$,$PCR_GaCnt$,$PCR_CoSid$,$CUA_J$,$CUA_K$,$CUA_D$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$VEN_Id$", mo_Tools.SQLStr(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_CodeC$", mo_Tools.SQLStr(as_UM_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$VDate$", mo_Tools.SqlDate(ValidityDate), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$UM_CodeQ$", mo_Tools.SQLStr(ao_Offer.UM_CodeQ), , , vbTextCompare)
  If StrComp(ao_Offer.UM_CodeQ, DPC_UOM_M2, vbTextCompare) = 0 Then
    ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(PanelQtyM2), , , vbTextCompare)
  ElseIf StrComp(ao_Offer.UM_CodeQ, DPC_UOM_PCS, vbTextCompare) = 0 Then
    ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(PanelQtyPCS), , , vbTextCompare)
  Else
    Err.Raise ArmErr.InvalidArgument, "ao_Offer.UM_CodeQ", "Invalid Qty unit of measuere for DOF_Id: " & ao_Offer.DOF_Id & " UM_Code: " & ao_Offer.UM_CodeQ
  End If
  
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(av_PRD_IdPar), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$CUA_Id$", mo_Tools.SqlIntKey(av_CUA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PanelA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PanelB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlIntKey(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Thick$", mo_Tools.SqlDbl(RPL_Thick), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$PCR_IsPrf$", mo_Tools.SqlBool(av_IsPerf), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCR_GaCnt$", mo_Tools.SqlInt(av_GasketCount), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCR_CoSid$", mo_Tools.SqlInt(av_ColSide), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$CUA_J$", mo_Tools.SqlDbl(av_CUA_J), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CUA_K$", mo_Tools.SqlDbl(av_CUA_K), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CUA_D$", mo_Tools.SqlDbl(av_CUA_D), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ld_Cost = mo_Db.GetFields(lc_Cursor, "PRC_Cost")
    Call ao_Offer.SetCost(as_UM_CodeC, ld_Cost)
    Call ao_Offer.SetCostA(as_UM_CodeC, ld_Cost)
    Call ao_Offer.CalculateGrossSellingPrice
  End If
  ao_Offer.OFD_Found = mo_Db.RowCount(lc_Cursor)
  
  If ao_Offer.DOF_IsVal Then
    If ao_Offer.DOF_IsStp And (ao_Offer.OFD_Cost = 0) And (Not ao_Offer.DOF_IsVal0) Then
      ao_Offer.OFD_Valid = False
    Else
      ao_Offer.OFD_Valid = True
    End If
  Else
    ao_Offer.OFD_Valid = False
  End If
  
  ' in case user remove this price manually, do not show it again when reloaded price
  If ao_Offer.ValidManual = eDPCOfferPosValidManual.vmSetInvalid Then
    ao_Offer.OFD_Valid = False
  End If
  
  Call mo_Db.Close(lc_Cursor)
  LoadProductPrice = ao_Offer.IsPriceFound
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadProductPrice")
End Function

Public Sub CalcPositionPrice()
On Error GoTo ErrHandler

Dim lo_OfferPosition As DPC_OfferPos
Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay
Dim ld_Qty As Double, ld_QtyA As Double
Dim ld_Price As Double, ld_PriceA As Double, ld_HPrice As Double
Dim ld_Cost As Double, ld_CostA As Double
Dim le_ErrType As eDPCErrorType

  Set lo_OfferPosition = GetOfferPos(eDPCOfferDetail.odPosition)
  ld_Price = 0
  ld_Cost = 0
  ld_HPrice = 0
  ld_Qty = lo_OfferPosition.OFD_Qty
  
  le_ErrType = GetScreenErrorType(eDPCScreen.psPanelSummary)
  If (ld_Qty > 0) And ((le_ErrType = eDPCErrorType.etNone) Or (le_ErrType = eDPCErrorType.etInfo)) Then
    For Each lo_Offer In OfferPrice
      If (lo_Offer.DOF_Id <> eDPCOfferDetail.odPosition) Then
        If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
          ld_Price = ld_Price + lo_Offer.OFD_TotalP / ld_Qty
          ld_Cost = ld_Cost + lo_Offer.OFD_TotalC / ld_Qty
          ld_HPrice = ld_HPrice + lo_Offer.OFD_HPrice
        End If
      End If
    Next
    
    For Each lo_Inlay In Inlays
      If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
        For Each lo_Offer In lo_Inlay.OfferPrice
          If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
            ld_Price = ld_Price + lo_Offer.OFD_TotalP / ld_Qty
            ld_Cost = ld_Cost + lo_Offer.OFD_TotalC / ld_Qty
            ld_HPrice = ld_HPrice + lo_Offer.OFD_HPrice
          End If
        Next
      End If
    Next
    
    For Each lo_Cutout In Cutouts
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        For Each lo_Offer In lo_Cutout.OfferPrice
          If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
            ld_Price = ld_Price + lo_Offer.OFD_TotalP / ld_Qty
            ld_Cost = ld_Cost + lo_Offer.OFD_TotalC / ld_Qty
            ld_HPrice = ld_HPrice + lo_Offer.OFD_HPrice
          End If
        Next
      End If
    Next
  End If
  
  ld_PriceA = 0
  ld_CostA = 0
  ld_QtyA = lo_OfferPosition.OFD_QtyA
  If (ld_QtyA > 0) And ((le_ErrType = eDPCErrorType.etNone) Or (le_ErrType = eDPCErrorType.etInfo)) Then
    For Each lo_Offer In OfferPrice
      If (lo_Offer.DOF_Id <> eDPCOfferDetail.odPosition) Then
        If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
          ld_PriceA = ld_PriceA + lo_Offer.OFD_TotalPA / ld_QtyA
          ld_CostA = ld_CostA + lo_Offer.OFD_TotalCA / ld_QtyA
        End If
      End If
    Next
    
    For Each lo_Inlay In Inlays
      If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
        For Each lo_Offer In lo_Inlay.OfferPrice
          If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
            ld_PriceA = ld_PriceA + lo_Offer.OFD_TotalPA / ld_QtyA
            ld_CostA = ld_CostA + lo_Offer.OFD_TotalCA / ld_QtyA
          End If
        Next
      End If
    Next
    
    For Each lo_Cutout In Cutouts
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        For Each lo_Offer In lo_Cutout.OfferPrice
          If (lo_Offer.OFD_Valid) And (Not lo_Offer.DOF_IsStp) Then
            ld_PriceA = ld_PriceA + lo_Offer.OFD_TotalPA / ld_QtyA
            ld_CostA = ld_CostA + lo_Offer.OFD_TotalCA / ld_QtyA
          End If
        Next
      End If
    Next
  End If
  
  If OFD_IsFree Then
    lo_OfferPosition.OFD_Price = 0
  Else
    lo_OfferPosition.OFD_Price = ld_Price
  End If
  lo_OfferPosition.OFD_PriceA = ld_PriceA
  lo_OfferPosition.OFD_Cost = ld_Cost
  lo_OfferPosition.OFD_CostA = ld_CostA
  lo_OfferPosition.OFD_HPrice = ld_HPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalcPositionPrice")
End Sub

Public Sub ResetPriceFound()
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay

  For Each lo_Offer In OfferPrice
    lo_Offer.OFD_Found = 1
    lo_Offer.OFD_Valid = lo_Offer.DOF_IsVal And lo_Offer.DOF_IsVal0
  Next
  
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
      For Each lo_Offer In lo_Inlay.OfferPrice
        lo_Offer.OFD_Found = 1
        lo_Offer.OFD_Valid = lo_Offer.DOF_IsVal And lo_Offer.DOF_IsVal0
      Next
    End If
  Next
  
  For Each lo_Cutout In Cutouts
    If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
      For Each lo_Offer In lo_Cutout.OfferPrice
        lo_Offer.OFD_Found = 1
        lo_Offer.OFD_Valid = lo_Offer.DOF_IsVal And lo_Offer.DOF_IsVal0
      Next
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPriceFound")
End Sub

Public Property Get GapA() As Double
On Error GoTo ErrHandler
 
  GapA = RPL_Gap(eDPCSide.esSideC) + RPL_Gap(eDPCSide.esSideD)
  Exit Property
ErrHandler:
  Call ErrorHandler("GapA.Get")
End Property

Public Property Get GapB() As Double
On Error GoTo ErrHandler
 
  GapB = RPL_Gap(eDPCSide.esSideE) + RPL_Gap(eDPCSide.esSideF)
  Exit Property
ErrHandler:
  Call ErrorHandler("GapB.Get")
End Property

Public Function GetTotalWidth() As Double
On Error GoTo ErrHandler

Dim ld_Width As Double
  
  ld_Width = RPL_PanB
  If RPL_GskDe = eDPCGasketDelivery.gdInstalled Then
    If IsGasketOn(eDPCSide.esSideC) Then
      ld_Width = ld_Width + GSK_Gap(eDPCSide.esSideC)
    End If
    If IsGasketOn(eDPCSide.esSideD) Then
      ld_Width = ld_Width + GSK_Gap(eDPCSide.esSideD)
    End If
  ElseIf RPL_SpcDe = eDPCSpacerDelivery.sdInstalled Then
    If IsSpacerOn(eDPCSide.esSideC) Then
      ld_Width = ld_Width + GSK_Gap2(eDPCSide.esSideC)
    End If
    If IsSpacerOn(eDPCSide.esSideD) Then
      ld_Width = ld_Width + GSK_Gap2(eDPCSide.esSideD)
    End If
  End If
  GetTotalWidth = ld_Width
  Exit Function
ErrHandler:
  Call ErrorHandler("GetTotalWidth")
End Function

Public Function GetTotalLength() As Double
On Error GoTo ErrHandler

Dim ld_Length As Double
  
  ld_Length = RPL_PanA
  If RPL_GskDe = eDPCGasketDelivery.gdInstalled Then
    If IsGasketOn(eDPCSide.esSideE) Then
      ld_Length = ld_Length + GSK_Gap(eDPCSide.esSideE)
    End If
    If IsGasketOn(eDPCSide.esSideF) Then
      ld_Length = ld_Length + GSK_Gap(eDPCSide.esSideF)
    End If
  ElseIf RPL_SpcDe = eDPCSpacerDelivery.sdInstalled Then
    If IsSpacerOn(eDPCSide.esSideE) Then
      ld_Length = ld_Length + GSK_Gap2(eDPCSide.esSideE)
    End If
    If IsSpacerOn(eDPCSide.esSideF) Then
      ld_Length = ld_Length + GSK_Gap2(eDPCSide.esSideF)
    End If
  End If
  GetTotalLength = ld_Length
  Exit Function
ErrHandler:
  Call ErrorHandler("GetTotalLength")
End Function

Public Property Get PanelAPerMod() As Long
On Error GoTo ErrHandler

  PanelAPerMod = 0
  If PanelSurface > 0 Then
    PanelAPerMod = Int(RPL_ModA / RPL_PanA)
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelAPerMod.Get")
End Property

Public Property Get PanelBPerMod() As Long
On Error GoTo ErrHandler

  PanelBPerMod = 0
  If RPL_PanB > 0 Then
    PanelBPerMod = Int(RPL_ModB / RPL_PanB)
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelBPerMod.Get")
End Property

Public Property Get PanelPerMod() As Long
On Error GoTo ErrHandler

  PanelPerMod = PanelAPerMod * PanelBPerMod
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelPerMod.Get")
End Property

Public Property Get PanelSurface() As Double
On Error GoTo ErrHandler
  
  PanelSurface = (RPL_PanA * RPL_PanB) / 1000000
  Exit Sub
ErrHandler:
  Call ErrorHandler("PanelSurface.Get")
End Property

Public Property Get ModuleSurface() As Double
On Error GoTo ErrHandler
  
  ModuleSurface = (RPL_ModA * RPL_ModB) / 1000000
  Exit Property
ErrHandler:
  Call ErrorHandler("ModuleSurface.Get")
End Property

Public Property Let RPL_ModA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  md_RPL_ModA = ad_Value
  Call RecalcPanelSize
  Call ResetPanelQtyPrice(PanelQty, QtyType)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_ModA.Let")
End Property

Public Property Get RPL_ModA() As Double
On Error GoTo ErrHandler

  RPL_ModA = md_RPL_ModA
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_ModA.Get")
End Property

Public Property Let RPL_ModB(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  md_RPL_ModB = ad_Value
  Call RecalcPanelSize
  Call ResetPanelQtyPrice(PanelQty, QtyType)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_ModB.Let")
End Property

Public Property Get RPL_ModB() As Double
On Error GoTo ErrHandler

  RPL_ModB = md_RPL_ModB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_ModB.Get")
End Property

Public Property Let RPL_PanA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  md_RPL_PanA = ad_Value
  Call RecalcInlaySize
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_PanA.Let")
End Property

Public Property Get RPL_PanA() As Double
On Error GoTo ErrHandler

  RPL_PanA = md_RPL_PanA
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_PanA.Get")
End Property

Public Property Let RPL_PanB(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  md_RPL_PanB = ad_Value
  Call RecalcInlaySize
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_PanB.Let")
End Property

Public Property Get RPL_PanB() As Double
On Error GoTo ErrHandler

  RPL_PanB = md_RPL_PanB
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_PanB.Get")
End Property

Public Property Get QtyType() As eDPCQtyType
On Error GoTo ErrHandler
Dim lo_OfferPos As DPC_OfferPos

  Set lo_OfferPos = GetOfferPos(eDPCOfferDetail.odPosition)
  QtyType = mo_Tools.ConvertUM_CodeToDPCQtyType(lo_OfferPos.UM_Code)
  Exit Property
ErrHandler:
  Call ErrorHandler("QtyType.Get")
End Property

Public Property Get PanelQtyPU() As Double
On Error GoTo ErrHandler
  
Dim lo_OfferPos As DPC_OfferPos

  Set lo_OfferPos = GetOfferPos(eDPCOfferDetail.odPosition)
  PanelQtyPU = lo_OfferPos.OFD_QtyPU
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQtyPU.Get")
End Property

Public Property Let PanelQtyPCS(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call ResetPanelQtyPrice(ad_Value, eDPCQtyType.qtPCS)
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQtyPCS.Let")
End Property

Public Property Get PanelQtyPCS() As Double
On Error GoTo ErrHandler
  
Dim lo_OfferPos As DPC_OfferPos

  Set lo_OfferPos = GetOfferPos(eDPCOfferDetail.odPosition)
  PanelQtyPCS = lo_OfferPos.OFD_QtyPCS
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQtyPCS.Get")
End Property

Public Property Let PanelQtyM2(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call ResetPanelQtyPrice(ad_Value, eDPCQtyType.qtM2)
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQtyM2.Let")
End Property

Public Property Get PanelQtyM2() As Double
On Error GoTo ErrHandler
  
Dim lo_OfferPos As DPC_OfferPos

  Set lo_OfferPos = GetOfferPos(eDPCOfferDetail.odPosition)
  PanelQtyM2 = lo_OfferPos.OFD_QtyM2
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQtyM2.Get")
End Property

Public Property Get PanelQty() As Double
On Error GoTo ErrHandler
  
  If QtyType = eDPCQtyType.qtM2 Then
    PanelQty = PanelQtyM2
  ElseIf QtyType = eDPCQtyType.qtPCS Then
    PanelQty = PanelQtyPCS
  ElseIf QtyType = eDPCQtyType.qtPU Then
    PanelQty = PanelQtyPU
  Else
    PanelQty = 0
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelQty.Get")
End Property

Private Sub RecalcPanelSize()
On Error GoTo ErrHandler

  md_RPL_PanA = RPL_ModA - GapB
  md_RPL_PanB = RPL_ModB - GapA
  Call RecalcInlaySize
  Call CalculateCoWMinMax
  Call CalculateCutAB
  Exit Sub
ErrHandler:
  Call ErrorHandler("RecalcPanelSize")
End Sub

Public Sub RecalcInlaySize()
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay

  For Each lo_Inlay In Inlays
    If lo_Inlay.PIN_Std Then
      Call lo_Inlay.CalcInlaySize(Me)
      Call InlayUpdate(lo_Inlay)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("RecalcInlaySize")
End Sub

Private Sub ResetPanelQtyPrice(ByVal ad_Qty As Double, ByVal ae_QtyType As eDPCQtyType)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay

  For Each lo_Offer In OfferPrice
    Call lo_Offer.Init(ad_Qty, ad_Qty, ae_QtyType, RPL_PU, ModuleSurface)
  Next
  For Each lo_Cutout In Cutouts
    For Each lo_Offer In lo_Cutout.OfferPrice
      Call lo_Offer.Init(ad_Qty, ad_Qty, ae_QtyType, RPL_PU, ModuleSurface)
    Next
  Next
  For Each lo_Inlay In Inlays
    For Each lo_Offer In lo_Inlay.OfferPrice
      Call lo_Offer.Init(ad_Qty, ad_Qty, ae_QtyType, RPL_PU, ModuleSurface)
    Next
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPanelQtyPrice")
End Sub

Public Sub LoadPrd(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_req As String
Dim ll_SideIdx As Long

  ls_req = "exec DPC_RectPanel_sel $PRD_Id$,$Language_Code$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req, 1)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    PRD_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
    CAT_Id = mo_Db.GetFields(ll_Cursor, "CAT_Id")
    PRD_IdPar = mo_Db.GetFields(ll_Cursor, "PRD_IdPar")
    PRD_Child = mo_Db.GetFields(ll_Cursor, "PRD_Child")
    PRD_Code = mo_Db.GetFields(ll_Cursor, "PRD_Code")
    PRD_CodeC = mo_Db.GetFields(ll_Cursor, "PRD_CodeC")
    Vendor_Id = mo_Db.GetFields(ll_Cursor, "Vendor_Id")
    Vendor_Name = mo_Db.GetFields(ll_Cursor, "VEN_Name")
    CURR_Code = mo_Db.GetFields(ll_Cursor, "CURR_Code")
    LEV_Id = mo_Db.GetFields(ll_Cursor, "LEV_Id")
    ERR_Type = mo_Db.GetFields(ll_Cursor, "Err_Type")
    IMG_Id = mo_Db.GetFields(ll_Cursor, "IMG_Id")
    STA_Id = mo_Db.GetFields(ll_Cursor, "STA_Id")
    ml_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
    CLS_Id1 = mo_Db.GetFields(ll_Cursor, "CLS_Id1")
    CLS_Name1 = mo_Db.GetFields(ll_Cursor, "CLS_Name1")
    CLS_Id2 = mo_Db.GetFields(ll_Cursor, "CLS_Id2")
    CLS_Name2 = mo_Db.GetFields(ll_Cursor, "CLS_Name2")
    CLS_Id3 = mo_Db.GetFields(ll_Cursor, "CLS_Id3")
    CLS_Name3 = mo_Db.GetFields(ll_Cursor, "CLS_Name3")
    CLS_Id4 = mo_Db.GetFields(ll_Cursor, "CLS_Id4")
    CLS_Name4 = mo_Db.GetFields(ll_Cursor, "CLS_Name4")
    CLS_Id5 = mo_Db.GetFields(ll_Cursor, "CLS_Id5")
    CLS_Name5 = mo_Db.GetFields(ll_Cursor, "CLS_Name5")
    CLS_Id6 = mo_Db.GetFields(ll_Cursor, "CLS_Id6")
    CLS_Name6 = mo_Db.GetFields(ll_Cursor, "CLS_Name6")
    CLS_Id7 = mo_Db.GetFields(ll_Cursor, "CLS_Id7")
    CLS_Name7 = mo_Db.GetFields(ll_Cursor, "CLS_Name7")
    CLS_Id8 = mo_Db.GetFields(ll_Cursor, "CLS_Id8")
    CLS_Name8 = mo_Db.GetFields(ll_Cursor, "CLS_Name8")
    
    SYS_Id = mo_Db.GetFields(ll_Cursor, "SYS_Id")
    RPL_Type = mo_Db.GetFields(ll_Cursor, "RPL_Type")
    md_RPL_ModA = Round(mo_Db.GetFields(ll_Cursor, "RPL_ModA"), 2)
    md_RPL_ModB = Round(mo_Db.GetFields(ll_Cursor, "RPL_ModB"), 2)
    md_RPL_PanA = Round(mo_Db.GetFields(ll_Cursor, "RPL_PanA"), 2)
    md_RPL_PanB = Round(mo_Db.GetFields(ll_Cursor, "RPL_PanB"), 2)
    RPL_Thick = Round(mo_Db.GetFields(ll_Cursor, "RPL_Thick"), 2)
    RPL_SBndA = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_SBndA"), "X", vbTextCompare) = 0)
    RPL_SBndB = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_SBndB"), "X", vbTextCompare) = 0)
    RPL_SUZA = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_SUZA"), "X", vbTextCompare) = 0)
    RPL_SUZB = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_SUZB"), "X", vbTextCompare) = 0)
    RPL_StdGa = IIf(StrComp(mo_Db.GetFields(ll_Cursor, "RPL_StdGa"), "X", vbTextCompare) = 0, True, False)
    RPL_BevA = Round(mo_Db.GetFields(ll_Cursor, "RPL_BevA"), 2)
    RPL_BevB = Round(mo_Db.GetFields(ll_Cursor, "RPL_BevB"), 2)
    RPL_CorW = Round(mo_Db.GetFields(ll_Cursor, "RPL_CorW"), 2)
    RPL_StdMa = IIf(StrComp(mo_Db.GetFields(ll_Cursor, "RPL_StdMa"), "X", vbTextCompare) = 0, True, False)
    MAT_Id = mo_Db.GetFields(ll_Cursor, "MAT_Id")
    MAT_CE = mo_Db.GetFields(ll_Cursor, "MAT_CE")
    RPL_CustDim = mo_Db.GetFields(ll_Cursor, "RPL_CustDim")
    RPL_CoilW = Round(mo_Db.GetFields(ll_Cursor, "RPL_CoilW"), 2)
    RPL_CoWMin = Round(mo_Db.GetFields(ll_Cursor, "RPL_CoWMin"), 2)
    RPL_CoWMax = Round(mo_Db.GetFields(ll_Cursor, "RPL_CoWMax"), 2)
    RPL_CutA = Round(mo_Db.GetFields(ll_Cursor, "RPL_CutA"), 2)
    RPL_CutB = Round(mo_Db.GetFields(ll_Cursor, "RPL_CutB"), 2)
    ParentRPL_CoilW = Round(mo_Db.GetFields(ll_Cursor, "ParentRPL_CoilW"), 2)
    ParentRPL_CoWMin = Round(mo_Db.GetFields(ll_Cursor, "ParentRPL_CoWMin"), 2)
    ParentRPL_CoWMax = Round(mo_Db.GetFields(ll_Cursor, "ParentRPL_CoWMax"), 2)
    ParentRPL_CutA = Round(mo_Db.GetFields(ll_Cursor, "ParentRPL_CutA"), 2)
    ParentRPL_CutB = Round(mo_Db.GetFields(ll_Cursor, "ParentRPL_CutB"), 2)
    
    RPL_MatTyp = mo_Db.GetFields(ll_Cursor, "RPL_MatTyp")
    COI_Code = mo_Db.GetFields(ll_Cursor, "COI_Code")
    COI_SpcWgh = mo_Db.GetFields(ll_Cursor, "COI_SpcWgh")
    COI_WasteFact = mo_Db.GetFields(ll_Cursor, "COI_WasteFact")
    COI_WasteQty = mo_Db.GetFields(ll_Cursor, "COI_WasteQty")
    COI_IsStock = (StrComp(mo_Db.GetFields(ll_Cursor, "COI_IsStock"), "X", vbTextCompare) = 0)
    
    PKG_Id = mo_Db.GetFields(ll_Cursor, "PKG_Id")
    LAB_Id = mo_Db.GetFields(ll_Cursor, "LAB_Id")
    RPL_LabLng = mo_Db.GetFields(ll_Cursor, "RPL_LabLng")
    RPL_LabLngDesc = mo_Db.GetFields(ll_Cursor, "RPL_LabLngDesc")
    'RPL_NWgh = mo_Db.GetFields(ll_Cursor, "RPL_NWgh")
    
    RPL_PU = mo_Db.GetFields(ll_Cursor, "RPL_PU")
    RPL_MQty = mo_Db.GetFields(ll_Cursor, "RPL_MQty")
    PRF_Id = mo_Db.GetFields(ll_Cursor, "PRF_Id")
    RPL_PBord = mo_Db.GetFields(ll_Cursor, "RPL_PBord")
    RPL_PBordDesc = mo_Db.GetFields(ll_Cursor, "RPL_PBordDesc")
    COA_Id = mo_Db.GetFields(ll_Cursor, "COA_Id")
    COA_Code = mo_Db.GetFields(ll_Cursor, "COA_Code")
    RPL_CoSid = mo_Db.GetFields(ll_Cursor, "RPL_CoSid")
    COA_CE = mo_Db.GetFields(ll_Cursor, "COA_CE")
    
    RPL_GskDe = mo_Db.GetFields(ll_Cursor, "RPL_GskDe")
    RPL_GskDeDesc = mo_Db.GetFields(ll_Cursor, "RPL_GskDeDesc")
    RPL_SpcDe = mo_Db.GetFields(ll_Cursor, "RPL_SpcDe")
    RPL_SpcDeDesc = mo_Db.GetFields(ll_Cursor, "RPL_SpcDeDesc")
    RPL_SpcNt = StrComp(mo_Db.GetFields(ll_Cursor, "RPL_SpcNt"), "X", vbTextCompare) = 0
    RPL_PerDe = mo_Db.GetFields(ll_Cursor, "RPL_PerDe")
    RPL_SwGap = mo_Db.GetFields(ll_Cursor, "RPL_SwGap")
    RPL_Plate = mo_Db.GetFields(ll_Cursor, "RPL_Plate")
    RPL_PlCnt = mo_Db.GetFields(ll_Cursor, "RPL_PlCnt")
    RPL_IsOut = mo_Db.GetFields(ll_Cursor, "RPL_IsOut")
    
    RPL_DrwNr = mo_Db.GetFields(ll_Cursor, "RPL_DrwNr")
    RPL_SpcPkg = mo_Db.GetFields(ll_Cursor, "RPL_SpcPkg")
    RPL_WghPnt = mo_Db.GetFields(ll_Cursor, "RPL_WghPnt")
    RPL_OGroup = mo_Db.GetFields(ll_Cursor, "RPL_OGroup")
    RPL_PGroup = mo_Db.GetFields(ll_Cursor, "RPL_PGroup")
    RPL_AGroup = mo_Db.GetFields(ll_Cursor, "RPL_AGroup")
    RPL_MGroup = mo_Db.GetFields(ll_Cursor, "RPL_MGroup")
    RPL_AdminFact = mo_Db.GetFields(ll_Cursor, "RPL_AdminFact")
    RPL_ICTPFact = mo_Db.GetFields(ll_Cursor, "RPL_ICTPFact")
    RPL_MPE2Fact = mo_Db.GetFields(ll_Cursor, "RPL_MPE2Fact")
    RPL_BOMRejectFact = mo_Db.GetFields(ll_Cursor, "RPL_BOMRejectFact")
    RPL_BORWasteFact = mo_Db.GetFields(ll_Cursor, "RPL_BORWasteFact")
    RPL_RejectOtherFact = mo_Db.GetFields(ll_Cursor, "RPL_RejectOtherFact")
    
    RPL_SCorr = 0
    
    For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
      mda_RPL_Gap(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_Gap" & mv_Edge(ll_SideIdx)), 2)
      SYS_UnperfBorder(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "SYS_UnperfBorder" & mv_Edge(ll_SideIdx)), 2)
      SYS_GapMin(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "SYS_G" & mv_Edge(ll_SideIdx) & "Min"), 2)
      SYS_GapMax(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "SYS_G" & mv_Edge(ll_SideIdx) & "Max"), 2)
      SYS_AllowG(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "SYS_AllowG" & mv_Edge(ll_SideIdx))
      RPL_UBor(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_UBor" & mv_Edge(ll_SideIdx)), 2)
      RPL_UBoW(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_UBoW" & mv_Edge(ll_SideIdx)), 2)
      IMG_IdGSK(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdGSK" & mv_Edge(ll_SideIdx))
      GSK_Id(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Id" & mv_Edge(ll_SideIdx))
      GSK_Code(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Code" & mv_Edge(ll_SideIdx))
      GSK_Name(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Name" & mv_Edge(ll_SideIdx))
      GSK_Desc(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Desc" & mv_Edge(ll_SideIdx))
      GSK_Gap(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "GSK_Gap" & mv_Edge(ll_SideIdx)), 2)
      GSK_ExName(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_ExName" & mv_Edge(ll_SideIdx))
      GTT_Selected(ll_SideIdx) = IsGasketOn(ll_SideIdx)
      
      IMG_Id2GSK(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id2GSK" & mv_Edge(ll_SideIdx))
      GSK_Id2(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Id2" & mv_Edge(ll_SideIdx))
      GSK_Code2(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Code2" & mv_Edge(ll_SideIdx))
      GSK_Name2(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Name2" & mv_Edge(ll_SideIdx))
      GSK_Desc2(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Desc2" & mv_Edge(ll_SideIdx))
      GSK_Gap2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "GSK_Gap2" & mv_Edge(ll_SideIdx)), 2)
      GSK_ExName2(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_ExName2" & mv_Edge(ll_SideIdx))
      GTT_Selected2(ll_SideIdx) = GSK_Id2(ll_SideIdx) <> ""
      
      msa_BND_Id(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_Id" & mv_Edge(ll_SideIdx))
      msa_BND_Name(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_Name" & mv_Edge(ll_SideIdx))
      msa_BND_Desc(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_Desc" & mv_Edge(ll_SideIdx))
      mla_IMG_IdBND(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdBND" & mv_Edge(ll_SideIdx))
      mla_IMG_Id2BND(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id2BNDl" & mv_Edge(ll_SideIdx))
      mla_IMG_IdVBND(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdVBND" & mv_Edge(ll_SideIdx))
      mla_IMG_IdV2BND(ll_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdV2BND" & mv_Edge(ll_SideIdx))
      mba_RPL_BVis(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_BVis" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      mba_RPL_NClo(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "RPL_NClo" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      
      mba_BND_CanVi(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "BND_CanVi" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      mba_BND_IsCus(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "BND_IsCus" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      mba_BND_HasH(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasH" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      mba_BND_HasU(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasU" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      mba_BND_HasS(ll_SideIdx) = (StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasS" & mv_Edge(ll_SideIdx)), "X", vbTextCompare) = 0)
      
      mda_BND_S(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_S" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_H(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_H" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMin(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMin" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMax(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMax" & mv_Edge(ll_SideIdx)), 2)
      
      mda_BND_HMin1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_HMin1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_HMax1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_HMax1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMin1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMin1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMax1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMax1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_SMin1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_SMin1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_SMax1(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_SMax1" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_HMin2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_HMin2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_HMax2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_HMax2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMin2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMin2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_UMax2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_UMax2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_SMin2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_SMin2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_SMax2(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_SMax2" & mv_Edge(ll_SideIdx)), 2)
      mda_BND_MatFct(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "BND_MatFct" & mv_Edge(ll_SideIdx)), 2)
      
      mda_RPL_H(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_H" & mv_Edge(ll_SideIdx)), 2)
      mda_RPL_UMin(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_UMin" & mv_Edge(ll_SideIdx)), 2)
      mda_RPL_UMax(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_UMax" & mv_Edge(ll_SideIdx)), 2)
      mda_RPL_U(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_U" & mv_Edge(ll_SideIdx)), 2)
      mda_RPL_S(ll_SideIdx) = Round(mo_Db.GetFields(ll_Cursor, "RPL_S" & mv_Edge(ll_SideIdx)), 2)
    Next
    
    COA_Name = mo_Db.GetFields(ll_Cursor, "COA_Name")
    COA_Desc = mo_Db.GetFields(ll_Cursor, "COA_Desc")
    COA_Type = mo_Db.GetFields(ll_Cursor, "COA_Type")
    COA_Mat = mo_Db.GetFields(ll_Cursor, "COA_Mat")
    COA_Norm = mo_Db.GetFields(ll_Cursor, "COA_Other")
    COA_App = mo_Db.GetFields(ll_Cursor, "COA_App")
    COA_IsCus = StrComp(mo_Db.GetFields(ll_Cursor, "COA_IsCus"), "X", vbTextCompare) = 0
    RPL_CoSidDesc = mo_Db.GetFields(ll_Cursor, "RPL_CoSidDesc")
    COA_TypeDesc = mo_Db.GetFields(ll_Cursor, "COA_TypeDesc")
    COA_MatDesc = mo_Db.GetFields(ll_Cursor, "COA_MatDesc")
    COA_NormDesc = mo_Db.GetFields(ll_Cursor, "COA_OtherDesc")
    COA_AppDesc = mo_Db.GetFields(ll_Cursor, "COA_AppDesc")
    COA_ExName = mo_Db.GetFields(ll_Cursor, "COA_ExName")
    PRD_Desc = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    PRD_Name = mo_Db.GetFields(ll_Cursor, "PRD_Name")
    MAT_Name = mo_Db.GetFields(ll_Cursor, "MAT_Name")
    MAT_Desc = mo_Db.GetFields(ll_Cursor, "MAT_Desc")
    MAT_CE = mo_Db.GetFields(ll_Cursor, "MAT_CE")
    CAT_Desc = mo_Db.GetFields(ll_Cursor, "CAT_Desc")
    CAT_Name = mo_Db.GetFields(ll_Cursor, "CAT_Name")
    SYS_Desc = mo_Db.GetFields(ll_Cursor, "SYS_Desc")
    SYS_Name = mo_Db.GetFields(ll_Cursor, "SYS_Name")
    SYS_Frame = mo_Db.GetFields(ll_Cursor, "SYS_Frame")
    SYS_AMin = Round(mo_Db.GetFields(ll_Cursor, "SYS_AMin"), 2)
    SYS_AMax = Round(mo_Db.GetFields(ll_Cursor, "SYS_AMax"), 2)
    SYS_BMin = Round(mo_Db.GetFields(ll_Cursor, "SYS_BMin"), 2)
    SYS_BMax = Round(mo_Db.GetFields(ll_Cursor, "SYS_BMax"), 2)
    IMG_IdSYS = mo_Db.GetFields(ll_Cursor, "IMG_IdSYS")
    SYS_Exec = mo_Db.GetFields(ll_Cursor, "SYS_Exec")
    SYS_InlayDec1 = mo_Db.GetFields(ll_Cursor, "SYS_InlayDec1")
    SYS_InlayDec2 = mo_Db.GetFields(ll_Cursor, "SYS_InlayDec2")
    PKG_Code = mo_Db.GetFields(ll_Cursor, "PKG_Code")
    PKG_Name = mo_Db.GetFields(ll_Cursor, "PKG_Name")
    PKG_Desc = mo_Db.GetFields(ll_Cursor, "PKG_Desc")
    
    LAB_Code = mo_Db.GetFields(ll_Cursor, "LAB_Code")
    LAB_Name = mo_Db.GetFields(ll_Cursor, "LAB_Name")
    LAB_Desc = mo_Db.GetFields(ll_Cursor, "LAB_Desc")
    
    PRF_Code = mo_Db.GetFields(ll_Cursor, "PRF_Code")
    PRF_Name = mo_Db.GetFields(ll_Cursor, "PRF_Name")
    PRF_Desc = mo_Db.GetFields(ll_Cursor, "PRF_Desc")
    PRF_Class = mo_Db.GetFields(ll_Cursor, "PRF_Class")
    PRF_FSC = Round(mo_Db.GetFields(ll_Cursor, "PRF_FSC"), 2)
    PRF_MaxPW = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxPW"), 2)
    PRF_MaxTW = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxTW"), 2)
    PRF_MaxST = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxST"), 2)
    PRF_MaxAT = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxAT"), 2)
    IMG_IdPRF = mo_Db.GetFields(ll_Cursor, "IMG_IdPRF")
    PRF_HoleA = Round(mo_Db.GetFields(ll_Cursor, "PRF_HoleA"), 2)
    PRF_HoleB = Round(mo_Db.GetFields(ll_Cursor, "PRF_HoleB"), 2)
    PRF_DivA = Round(mo_Db.GetFields(ll_Cursor, "PRF_DivA"), 5)
    PRF_DivB = Round(mo_Db.GetFields(ll_Cursor, "PRF_DivB"), 5)
    PRF_Step = Round(mo_Db.GetFields(ll_Cursor, "PRF_Step"), 5)
    PRF_StLim = Round(mo_Db.GetFields(ll_Cursor, "PRF_StLim"), 5)
    PRF_SAMin = Round(mo_Db.GetFields(ll_Cursor, "PRF_SAMin"), 5)
    PRF_SAMax = Round(mo_Db.GetFields(ll_Cursor, "PRF_SAMax"), 5)
    PRF_SBMin = Round(mo_Db.GetFields(ll_Cursor, "PRF_SBMin"), 5)
  End If
  Call mo_Db.Close(ll_Cursor)
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrd")
End Sub

Public Sub ResetMaterial()
On Error GoTo ErrHandler

  MAT_Id = 0
  MAT_Name = ""
  MAT_Desc = ""
  MAT_CE = 0
  COI_Code = ""
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetMaterial")
End Sub

Public Sub LoadMaterial(ByVal al_MAT_Id As Long)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetMaterial
  ls_req = "exec DPC_Material_sel $MAT_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlInt(al_MAT_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    MAT_Id = mo_Db.GetFields(ll_Cursor, "MAT_Id")
    MAT_Name = mo_Db.GetFields(ll_Cursor, "MAT_Name")
    MAT_Desc = mo_Db.GetFields(ll_Cursor, "MAT_Desc")
    MAT_CE = mo_Db.GetFields(ll_Cursor, "MAT_CE")
  End If
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadMaterial")
End Sub

Public Sub ResetPerforation()
On Error GoTo ErrHandler

  PRF_Id = ""
  PRF_Code = ""
  PRF_Name = ""
  PRF_Desc = ""
  IMG_IdPRF = 0
  LEV_IdPRF = 0
  PRF_HoleA = 0
  PRF_HoleB = 0
  PRF_DivA = 0
  PRF_DivB = 0
  PRF_Step = 0
  PRF_StLim = 0
  PRF_SAMin = 0
  PRF_SAMax = 0
  PRF_SBMin = 0
  PRF_MaxPW = 0
  PRF_MaxTW = 0
  PRF_MaxST = 0
  PRF_MaxAT = 0
  PRF_FSC = 0
  Call ResetPerforationBorder
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPerforation")
End Sub

Public Sub LoadPerforation(ByVal as_PRF_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetPerforation
  ls_req = "exec DPC_Perforation_sel $PRF_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$PRF_Id$", mo_Tools.SQLStr(as_PRF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    PRF_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
    PRF_Code = mo_Db.GetFields(ll_Cursor, "PRD_Code")
    PRF_Name = mo_Db.GetFields(ll_Cursor, "PRD_Name")
    PRF_Desc = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    PRF_Class = mo_Db.GetFields(ll_Cursor, "PRF_Class")
    IMG_IdPRF = mo_Db.GetFields(ll_Cursor, "IMG_Id")
    LEV_IdPRF = mo_Db.GetFields(ll_Cursor, "LEV_Id")
    PRF_HoleA = Round(mo_Db.GetFields(ll_Cursor, "PRF_HoleA"), 2)
    PRF_HoleB = Round(mo_Db.GetFields(ll_Cursor, "PRF_HoleB"), 2)
    PRF_DivA = Round(mo_Db.GetFields(ll_Cursor, "PRF_DivA"), 2)
    PRF_DivB = Round(mo_Db.GetFields(ll_Cursor, "PRF_DivB"), 2)
    PRF_Step = Round(mo_Db.GetFields(ll_Cursor, "PRF_Step"), 2)
    PRF_StLim = Round(mo_Db.GetFields(ll_Cursor, "PRF_StLim"), 2)
    PRF_SAMin = Round(mo_Db.GetFields(ll_Cursor, "PRF_SAMin"), 2)
    PRF_SAMax = Round(mo_Db.GetFields(ll_Cursor, "PRF_SAMax"), 2)
    PRF_SBMin = Round(mo_Db.GetFields(ll_Cursor, "PRF_SBMin"), 2)
    PRF_MaxPW = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxPW"), 2)
    PRF_MaxTW = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxTW"), 2)
    PRF_MaxST = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxST"), 2)
    PRF_MaxAT = Round(mo_Db.GetFields(ll_Cursor, "PRF_MaxAT"), 2)
    PRF_FSC = Round(mo_Db.GetFields(ll_Cursor, "PRF_FSC"), 2)
  End If
  Call mo_Db.Close(ll_Cursor)
  Call RecalcInlaySize
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPerforation")
End Sub

Public Sub ResetPerforationBorder()
On Error GoTo ErrHandler

  Dim ll_Idx As Long
  
  PRF_IsCorrStep = False
  PRF_IsStandard = True
  RPL_PBord = eDPCPerforationBorderType.pbUndef
  For ll_Idx = eDPCSide.esSideC To eDPCSide.esSideF
    RPL_UBoW(ll_Idx) = -1
    RPL_UBor(ll_Idx) = -1
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPerforationBorder")
End Sub

Public Sub LoadPerforationBorder(ByVal ae_PBord As eDPCPerforationBorderType)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetPerforationBorder

  ls_req = "exec A_References_ML_Sel $GR_Code$, $RF_Code$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$GR_Code$", mo_Tools.SqlInt(eDPCReferenceML.rfPerforationBorderType), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RF_Code$", mo_Tools.SqlInt(ae_PBord), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    RPL_PBord = mo_Db.GetFields(ll_Cursor, "RF_Code")
    RPL_PBordDesc = mo_Db.GetFields(ll_Cursor, "RF_Desc")
  Else
    RPL_PBord = eDPCPerforationBorderType.pbUndef
    RPL_PBordDesc = ""
  End If
  Call RecalcInlaySize
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPerforationBorder")
End Sub

Public Sub ResetCoating()
On Error GoTo ErrHandler

  COA_Id = ""
  COA_Code = ""
  COA_Name = ""
  COA_Desc = ""
  COA_ExName = ""
  COA_CE = 0
  Call RemoveError(eDPCError.erCoatingName, Nothing)
  Call RemoveError(eDPCError.erCoatingDesc, Nothing)
  
  COA_Type = eDPCCoatingType.ctUndef
  COA_Mat = eDPCCoatingMaterial.cmUndef
  COA_App = eDPCCoatingApplication.caUndef
  COA_Norm = eDPCColorNorm.cnUndef

  COA_TypeDesc = ""
  COA_MatDesc = ""
  COA_AppDesc = ""
  COA_NormDesc = ""
  
  COA_IsCus = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetCoating")
End Sub

Public Sub LoadCoatingBOM(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

Dim ls_req As String
  
  If StrComp(ao_BOM.Norm, DPC_BAEURER_COLOR_NORM_RAL, vbTextCompare) = 0 Then
    COA_Norm = eDPCColorNorm.cnRAL
  ElseIf StrComp(ao_BOM.Norm, DPC_BAEURER_COLOR_NORM_NCS, vbTextCompare) = 0 Then
    COA_Norm = eDPCColorNorm.cnNCS
  Else
    COA_Norm = eDPCColorNorm.cnOther
  End If
    
  If StrComp(ao_BOM.Klasse, DPC_BAEURER_COATING_APP_INSIDE, vbTextCompare) = 0 Then
    COA_App = eDPCCoatingApplication.ceInside
  ElseIf StrComp(ao_BOM.Klasse, DPC_BAEURER_COATING_APP_OUTSIDE, vbTextCompare) = 0 Then
    COA_App = eDPCCoatingApplication.ceOutside
  Else
    COA_App = eDPCCoatingApplication.caUndef
  End If
  
  If StrComp(ao_BOM.Agr, "210", vbTextCompare) = 0 Then
    COA_Mat = eDPCCoatingMaterial.cmPowder
  ElseIf StrComp(ao_BOM.Agr, "220", vbTextCompare) = 0 Then
    COA_Mat = eDPCCoatingMaterial.cmPaint
  Else
    COA_Mat = eDPCCoatingMaterial.cmOther
  End If
  
  COA_Type = eDPCCoatingType.ctOtherRALNCS
  COA_Code = ao_BOM.BOM_IdentNr
  COA_Name = ao_BOM.BOM_Name
  COA_ExName = ao_BOM.BOM_Name
  COA_Desc = ao_BOM.Ben1
  COA_IsCus = True
  Call SetErrorText(eDPCError.erCoatingName, COA_Name, Nothing)
  Call SetErrorText(eDPCError.erCoatingDesc, COA_Desc, Nothing)
  
  ls_req = "exec DPC_Coating_grd $Language_Code$, $COA_App$, $COA_Mat$, $COA_Type$, $COA_Norm$, $PCR_CoSid$, $RPL_PanA$, $RPL_PanB$, $Qty$, $UM_Code$, $CURR_Code$, $CT_Code$, $SCH_Id$, $PRD_IdPar$, $COA_IsCus$"
  ls_req = Replace(ls_req, "$COA_App$", mo_Tools.SqlInt(COA_App), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Mat$", mo_Tools.SqlInt(COA_Mat), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Type$", mo_Tools.SqlInt(COA_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Other$", mo_Tools.SqlInt(COA_Norm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Norm$", mo_Tools.SqlInt(COA_Norm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCR_CoSid$", mo_Tools.SqlInt(RPL_CoSid), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(PanelQtyM2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_Code$", mo_Tools.SQLStr(DPC_UOM_M2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SCH_Id$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SQLStr(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_IsCus$", mo_Tools.SqlBool(True), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  COA_Id = mo_Tools.SelectValue(mo_Db, ls_req, "COA_Id")
  If COA_Id = "" Then
    COA_Id = mo_Tools.GetAConfigData("DPC_Custom_COA")
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCoatingBOM")
End Sub

Public Sub LoadInlayIdentNr(ByVal ao_Db As Object, ByVal as_IdentNr As String, ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM

  Set lo_BOM = New DPC_BOM
  Call InitBOM(lo_BOM, eDPCRowStatus.rsNone)
  Call lo_BOM.LoadBOMFromBaeurer(mo_Db, ao_Db, ms_Language_Code, as_IdentNr)
  Call LoadInlayBOM(lo_BOM, ao_Inlay)
  Set lo_BOM = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadInlayIdentNr")
End Sub

Public Sub LoadInlayBOM(ByVal ao_BOM As DPC_BOM, ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim ls_req As String
  
  ao_Inlay.INL_Code = ao_BOM.BOM_IdentNr
  ao_Inlay.INL_Name = ao_BOM.BOM_Name
  ao_Inlay.INL_Desc = ao_BOM.Ben1
  ao_Inlay.INL_Vend = ""
  ao_Inlay.INL_IsCus = True
  ao_Inlay.PIN_Code = ao_BOM.BOM_IdentNr
  
  Call SetErrorText(eDPCError.erInlayName, ao_Inlay.INL_Name, Me)
  Call SetErrorText(eDPCError.erInlayDesc, ao_Inlay.INL_Desc, Me)
  
  ls_req = "exec DPC_Inlay_grd $COF_Lang$, $INL_Type$, $INL_Vend$, $RPL_PanA$, $RPL_PanB$, $Qty$, $CT_Code$, $CURR_Code$, $SCH_Id$, $PRD_IdPar$, $INL_IsCus$"
  ls_req = Replace(ls_req, "$INL_Type$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_Vend$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(PanelQtyM2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SCH_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SQLStr(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_IsCus$", mo_Tools.SqlBool(True), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ao_Inlay.INL_Id = mo_Tools.SelectValue(mo_Db, ls_req, "INL_Id")
  If ao_Inlay.INL_Id = "" Then
    ao_Inlay.INL_Id = mo_Tools.GetAConfigData("DPC_Custom_INL")
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadInlayBOM")
End Sub


Public Sub LoadCoating(ByVal as_COA_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetCoating
  ls_req = "exec DPC_Coating_sel $COA_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$COA_Id$", mo_Tools.SQLStr(as_COA_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    COA_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
    COA_Code = mo_Db.GetFields(ll_Cursor, "PRD_Code")
    COA_Name = mo_Db.GetFields(ll_Cursor, "PRD_Name")
    COA_Desc = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    
    COA_Type = mo_Db.GetFields(ll_Cursor, "COA_Type")
    COA_Mat = mo_Db.GetFields(ll_Cursor, "COA_Mat")
    COA_App = mo_Db.GetFields(ll_Cursor, "COA_App")
    COA_Norm = mo_Db.GetFields(ll_Cursor, "COA_Other")
    COA_CE = mo_Db.GetFields(ll_Cursor, "COA_CE")
  
    COA_TypeDesc = mo_Db.GetFields(ll_Cursor, "COA_Type_Desc")
    COA_MatDesc = mo_Db.GetFields(ll_Cursor, "COA_Mat_Desc")
    COA_AppDesc = mo_Db.GetFields(ll_Cursor, "COA_App_Desc")
    COA_NormDesc = mo_Db.GetFields(ll_Cursor, "COA_Other_Desc")
    
    COA_IsCus = StrComp(mo_Db.GetFields(ll_Cursor, "COA_IsCus"), "X", vbTextCompare) = 0
  End If
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCoating")
End Sub

Public Sub LoadCoatingSide(ByVal al_RPL_CoSid As Long)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  ls_req = "exec A_References_ML_Sel $GR_Code$, $RF_Code$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$GR_Code$", mo_Tools.SqlInt(eDPCReferenceML.rfCoatingSideApp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RF_Code$", mo_Tools.SqlInt(al_RPL_CoSid), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    RPL_CoSid = mo_Db.GetFields(ll_Cursor, "RF_Code")
    RPL_CoSidDesc = mo_Db.GetFields(ll_Cursor, "RF_Desc")
  Else
    RPL_CoSid = 0
    RPL_CoSidDesc = ""
  End If
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCoatingSide")
End Sub

Public Sub ResetGasket(ByVal ae_GSK_Type As eDPCGasketType, ByVal al_SideIdx As Long)
On Error GoTo ErrHandler

  If ae_GSK_Type = eDPCGasketType.gtGasket Then
    GSK_Id(al_SideIdx) = ""
    GSK_Code(al_SideIdx) = ""
    GSK_Name(al_SideIdx) = ""
    GSK_Desc(al_SideIdx) = ""
    IMG_IdGSK(al_SideIdx) = 0
    GSK_Gap(al_SideIdx) = 0
    GSK_ExName(al_SideIdx) = ""
    GTT_Selected(al_SideIdx) = False
  ElseIf ae_GSK_Type = eDPCGasketType.gtSpacer Then
    GSK_Id2(al_SideIdx) = ""
    GSK_Code2(al_SideIdx) = ""
    GSK_Name2(al_SideIdx) = ""
    GSK_Desc2(al_SideIdx) = ""
    IMG_Id2GSK(al_SideIdx) = 0
    GSK_Gap2(al_SideIdx) = 0
    GSK_ExName2(al_SideIdx) = ""
    GTT_Selected2(al_SideIdx) = False
  Else
    Err.Raise ArmErr.InvalidArgument, "ae_GSK_Type", "Invalid value: " & ae_GSK_Type
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetGasket")
End Sub

Public Sub InitGasketSpacer()
On Error GoTo ErrHandler

Dim lb_GasketPossible As Boolean
Dim le_Idx As eDPCSide


  If Not IsGasketAllowed Then
    'RPL_GskDe = eDPCGasketDelivery.gdNoneGasket
    Call LoadGasketDelivery(eDPCGasketDelivery.gdNoneGasket)
  End If
  If Not IsSpacerAllowed Then
    'RPL_SpcDe = eDPCSpacerDelivery.sdNoneSpacer
    Call LoadSpacerDelivery(eDPCSpacerDelivery.sdNoneSpacer)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitGasketSpacer")
End Sub

Public Sub LoadGasketDelivery(ByVal ae_RPL_GskDe As eDPCGasketDelivery)
On Error GoTo ErrHandler

  RPL_GskDe = ae_RPL_GskDe
  If RPL_GskDe = eDPCGasketDelivery.gdUndef Then
    RPL_GskDeDesc = ""
  Else
    RPL_GskDeDesc = mo_Tools.GetAReferenceData(eDPCReferenceML.rfGasketDeliveryKind, ae_RPL_GskDe, Language_Code)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadGasketDelivery")
End Sub

Public Sub LoadSpacerDelivery(ByVal ae_RPL_SpcDe As eDPCSpacerDelivery)
On Error GoTo ErrHandler

  RPL_SpcDe = ae_RPL_SpcDe
  If ae_RPL_SpcDe = eDPCSpacerDelivery.sdUndef Then
    RPL_SpcDeDesc = ""
  Else
    RPL_SpcDeDesc = mo_Tools.GetAReferenceData(eDPCReferenceML.rfSpacerDeliveryKind, ae_RPL_SpcDe, Language_Code)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSpacerDelivery")
End Sub

Public Sub LoadGasket(ByVal ae_GSK_Type As eDPCGasketType, ByVal al_SideIdx As Long, ByVal as_GSK_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetGasket(ae_GSK_Type, al_SideIdx)
  If as_GSK_Id <> "" Then
    ls_req = "exec DPC_Gasket_sel $GSK_Id$, $Language_Code$"
    
    ls_req = Replace(ls_req, "$GSK_Id$", mo_Tools.SqlStrKey(as_GSK_Id), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(ll_Cursor) = 1 Then
      If ae_GSK_Type = eDPCGasketType.gtGasket Then
        GSK_Id(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Id")
        GSK_Code(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Code")
        GSK_Name(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Name")
        GSK_Desc(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
        IMG_IdGSK(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id")
        GSK_Gap(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Gap")
        GSK_IsCus(al_SideIdx) = IIf(mo_Db.GetFields(ll_Cursor, "GSK_IsCus") = "X", True, False)
        GSK_ExName(al_SideIdx) = ""
        GTT_Selected(al_SideIdx) = True
      ElseIf ae_GSK_Type = eDPCGasketType.gtSpacer Then
        GSK_Id2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Id")
        GSK_Code2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Code")
        GSK_Name2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Name")
        GSK_Desc2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
        IMG_Id2GSK(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id")
        GSK_Gap2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "GSK_Gap")
        GSK_ExName2(al_SideIdx) = ""
        GSK_IsCus2(al_SideIdx) = IIf(mo_Db.GetFields(ll_Cursor, "GSK_IsCus") = "X", True, False)
        GTT_Selected2(al_SideIdx) = True
      Else
        Err.Raise ArmErr.InvalidArgument, "ae_GSK_Type", "Invalid value: " & ae_GSK_Type
      End If
    End If
    Call mo_Db.Close(ll_Cursor)
  End If
  Exit Sub
ErrHandler:
  Call mo_Db.Close(ll_Cursor)
  Call ErrorHandler("LoadGasket")
End Sub

Public Sub ResetPacking()
On Error GoTo ErrHandler

  PKG_Id = ""
  PKG_Code = ""
  PKG_Name = ""
  PKG_Desc = ""
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPacking")
End Sub

Public Sub ResetLabeling()
On Error GoTo ErrHandler

  LAB_Id = ""
  LAB_Code = ""
  LAB_Name = ""
  LAB_Desc = ""
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetLabeling")
End Sub

Public Sub LoadPacking(ByVal as_PKG_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetPacking
  If as_PKG_Id <> "" Then
    ls_req = "exec DPC_Packing_sel $PKG_Id$, $Language_Code$"
    ls_req = Replace(ls_req, "$PKG_Id$", mo_Tools.SqlStrKey(as_PKG_Id), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(ll_Cursor) = 1 Then
      PKG_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
      PKG_Code = mo_Db.GetFields(ll_Cursor, "PRD_Code")
      PKG_Name = mo_Db.GetFields(ll_Cursor, "PRD_Name")
      PKG_Desc = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    End If
    Call mo_Db.Close(ll_Cursor)
  End If
  Exit Sub
ErrHandler:
  Call mo_Db.Close(ll_Cursor)
  Call ErrorHandler("LoadPacking")
End Sub

Public Sub LoadLabeling(ByVal as_LAB_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetLabeling
  If as_LAB_Id <> "" Then
    ls_req = "exec DPC_Labeling_sel $LAB_Id$, $Language_Code$"
    ls_req = Replace(ls_req, "$LAB_Id$", mo_Tools.SqlStrKey(as_LAB_Id), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(ll_Cursor) = 1 Then
      LAB_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
      LAB_Code = mo_Db.GetFields(ll_Cursor, "PRD_Code")
      LAB_Name = mo_Db.GetFields(ll_Cursor, "PRD_Name")
      LAB_Desc = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    End If
    Call mo_Db.Close(ll_Cursor)
  End If
  Exit Sub
ErrHandler:
  Call mo_Db.Close(ll_Cursor)
  Call ErrorHandler("LoadLabeling")
End Sub

Public Sub ResetBending(ByVal al_SideIdx As Long)
On Error GoTo ErrHandler

  BND_Id(al_SideIdx) = ""
  BND_Name(al_SideIdx) = ""
  BND_Desc(al_SideIdx) = ""
  IMG_IdBND(al_SideIdx) = 0
  IMG_Id2BND(al_SideIdx) = 0
  IMG_IdVBND(al_SideIdx) = 0
  IMG_IdV2BND(al_SideIdx) = 0
  BND_CanVi(al_SideIdx) = False
  BND_IsCus(al_SideIdx) = False
  BND_HasH(al_SideIdx) = False
  BND_HasU(al_SideIdx) = False
  BND_HasS(al_SideIdx) = False
  BND_S(al_SideIdx) = 0
  BND_H(al_SideIdx) = 0
  BND_HMin1(al_SideIdx) = 0
  BND_HMax1(al_SideIdx) = 0
  BND_UMin1(al_SideIdx) = 0
  BND_UMax1(al_SideIdx) = 0
  BND_SMin1(al_SideIdx) = 0
  BND_SMax1(al_SideIdx) = 0

  BND_HMin2(al_SideIdx) = 0
  BND_HMax2(al_SideIdx) = 0
  BND_UMin2(al_SideIdx) = 0
  BND_UMax2(al_SideIdx) = 0
  BND_SMin2(al_SideIdx) = 0
  BND_SMax2(al_SideIdx) = 0
  BND_MatFct(al_SideIdx) = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetBending")
End Sub

Public Sub ResetPanelUZS(ByVal al_SideIdx As Long)
On Error GoTo ErrHandler

  
  RPL_U(al_SideIdx) = 0
  RPL_UMin(al_SideIdx) = 0
  RPL_UMax(al_SideIdx) = 0
  RPL_S(al_SideIdx) = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPanelUZS")
End Sub

Public Sub ResetPanelHeight(ByVal al_SideIdx As Long)
On Error GoTo ErrHandler
  
  RPL_H(al_SideIdx) = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetPanelHeight")
End Sub

Public Sub LoadOptionalSystemConfig()
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long
Dim ll_Cursor2 As Long
Dim lv_PRD_Id As Variant
Dim lv_PRD_Name As Variant
Dim lv_Value As Variant
Dim ll_Count As Long
Dim ll_Idx As Long
  
  ls_req = "exec DPC_SysDefault_lst2 $SYS_Id$, $SYD_Type$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYD_Type$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  
  ll_Cursor2 = mo_Db.Filter(ll_Cursor, "SYD_Type", "=", eDPCSystemDefaultType.sdBending, 0, False)
  ll_Count = mo_Db.RowCount(ll_Cursor2)
  If ll_Count = 0 Then
    ReDim ma_OptionalBND_Id(-1 To -1)
    ReDim ma_OptionalBND_Name(-1 To -1)
  Else
    ReDim lv_PRD_Id(eDPCSide.esSideF)
    ReDim lv_PRD_Name(eDPCSide.esSideF)
    ReDim ma_OptionalBND_Id(ll_Count - 1)
    ReDim ma_OptionalBND_Name(ll_Count - 1)
    For ll_Idx = 0 To ll_Count - 1
      lv_PRD_Id(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdC")
      lv_PRD_Id(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdD")
      lv_PRD_Id(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdE")
      lv_PRD_Id(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdF")
      lv_PRD_Name(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_NameC")
      lv_PRD_Name(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_NameD")
      lv_PRD_Name(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_NameE")
      lv_PRD_Name(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_NameF")
      ma_OptionalBND_Id(ll_Idx) = lv_PRD_Id
      ma_OptionalBND_Name(ll_Idx) = lv_PRD_Name
    Next
  End If
  Call mo_Db.Close(ll_Cursor2)
  
  ll_Cursor2 = mo_Db.Filter(ll_Cursor, "SYD_Type", "=", eDPCSystemDefaultType.sdGasket, 0, False)
  ll_Count = mo_Db.RowCount(ll_Cursor2)
  If ll_Count = 0 Then
    ReDim ma_OptionalGSK_Id(-1 To -1)
    ReDim ma_OptionalGskGap(-1 To -1)
  Else
    ReDim lv_PRD_Id(eDPCSide.esSideF)
    ReDim lv_Value(eDPCSide.esSideF)
    ReDim ma_OptionalGSK_Id(ll_Count - 1)
    ReDim ma_OptionalGskGap(ll_Count - 1)
    For ll_Idx = 0 To ll_Count - 1
      lv_PRD_Id(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdC")
      lv_PRD_Id(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdD")
      lv_PRD_Id(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdE")
      lv_PRD_Id(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdF")
      lv_Value(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueC")
      lv_Value(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueD")
      lv_Value(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueE")
      lv_Value(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueF")
      ma_OptionalGSK_Id(ll_Idx) = lv_PRD_Id
      ma_OptionalGskGap(ll_Idx) = lv_Value
    Next
  End If
  Call mo_Db.Close(ll_Cursor2)
  
  ll_Cursor2 = mo_Db.Filter(ll_Cursor, "SYD_Type", "=", eDPCSystemDefaultType.sdSpacer, 0, False)
  ll_Count = mo_Db.RowCount(ll_Cursor2)
  If ll_Count = 0 Then
    ReDim ma_OptionalGSK_Id2(-1 To -1)
    ReDim ma_OptionalGskGap2(-1 To -1)
  Else
    ReDim lv_PRD_Id(eDPCSide.esSideF)
    ReDim lv_Value(eDPCSide.esSideF)
    ReDim ma_OptionalGSK_Id2(ll_Count - 1)
    ReDim ma_OptionalGskGap2(ll_Count - 1)
    For ll_Idx = 0 To ll_Count - 1
      lv_PRD_Id(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdC")
      lv_PRD_Id(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdD")
      lv_PRD_Id(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdE")
      lv_PRD_Id(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdF")
      lv_Value(eDPCSide.esSideC) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueC")
      lv_Value(eDPCSide.esSideD) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueD")
      lv_Value(eDPCSide.esSideE) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueE")
      lv_Value(eDPCSide.esSideF) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueF")
      ma_OptionalGSK_Id2(ll_Idx) = lv_PRD_Id
      ma_OptionalGskGap2(ll_Idx) = lv_Value
    Next
  End If
  Call mo_Db.Close(ll_Cursor2)
  
  ll_Cursor2 = mo_Db.Filter(ll_Cursor, "SYD_Type", "=", eDPCSystemDefaultType.sdInlay, 0, False)
  ll_Count = mo_Db.RowCount(ll_Cursor2)
  If ll_Count = 0 Then
    ReDim ma_DefaultInlayPerfDec(-1 To -1)
  Else
    ReDim ma_DefaultInlayPerfDec(ll_Count - 1)
    ReDim lv_Value(2)
    For ll_Idx = 0 To ll_Count - 1
      lv_Value(0) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "PRD_IdC")
      lv_Value(1) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_ValueC")
      lv_Value(2) = mo_Db.GetFieldsAt(ll_Cursor2, ll_Idx, "SYD_Value2C")
      ma_DefaultInlayPerfDec(ll_Idx) = lv_Value
    Next
  End If
  Call mo_Db.Close(ll_Cursor2)
  
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call mo_Db.Close(ll_Cursor2)
  Call mo_Db.Close(ll_Cursor)
  Call ErrorHandler("LoadOptionalSystemConfig")
End Sub

Public Sub LoadBending(ByVal al_SideIdx As Long, ByVal as_BND_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Cursor As Long

  Call ResetBending(al_SideIdx)
  ls_req = "exec DPC_Bending_sel $BND_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$BND_Id$", mo_Tools.SQLStr(as_BND_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(ll_Cursor) = 1 Then
    BND_Id(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_Id")
    BND_Name(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Name")
    BND_Desc(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "PRD_Desc")
    IMG_IdBND(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id")
    IMG_Id2BND(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_Id2")
    IMG_IdVBND(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdV")
    IMG_IdV2BND(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "IMG_IdV2")
    BND_CanVi(al_SideIdx) = StrComp(mo_Db.GetFields(ll_Cursor, "BND_CanVi"), "X", vbTextCompare) = 0
    BND_IsCus(al_SideIdx) = StrComp(mo_Db.GetFields(ll_Cursor, "BND_IsCus"), "X", vbTextCompare) = 0
    BND_HasH(al_SideIdx) = StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasH"), "X", vbTextCompare) = 0
    BND_HasU(al_SideIdx) = StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasU"), "X", vbTextCompare) = 0
    BND_HasS(al_SideIdx) = StrComp(mo_Db.GetFields(ll_Cursor, "BND_HasS"), "X", vbTextCompare) = 0
  
    BND_UMin(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMin")
    BND_UMax(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMax")
    BND_S(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_S")
    BND_H(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_H")
    
    BND_HMin1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_HMin1")
    BND_HMax1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_HMax1")
    BND_UMin1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMin1")
    BND_UMax1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMax1")
    BND_SMin1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_SMin1")
    BND_SMax1(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_SMax1")
  
    BND_HMin2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_HMin2")
    BND_HMax2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_HMax2")
    BND_UMin2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMin2")
    BND_UMax2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_UMax2")
    BND_SMin2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_SMin2")
    BND_SMax2(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_SMax2")
    BND_MatFct(al_SideIdx) = mo_Db.GetFields(ll_Cursor, "BND_MatFct")
  End If
  Call mo_Db.Close(ll_Cursor)
  Exit Sub
ErrHandler:
  Call mo_Db.Close(ll_Cursor)
  Call ErrorHandler("LoadBending")
End Sub

Public Sub CalcNotchRivet()
On Error GoTo ErrHandler

  If RPL_Plate = eDPCPlateType.bpNone Then
    RPL_PlCnt = 0
  Else
    RPL_PlCnt = 2 * CLng(RPL_PanA / 400 + 1)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalcNotchRivet")
End Sub

Public Sub CalcPerfBorder()
On Error GoTo ErrHandler

Dim ld_WantPrfL As Double
Dim ld_WantPrfW As Double
Dim ld_PrfL As Double
Dim ld_PrfW As Double
Dim ll_StampRowBCount As Long
Dim ll_Hub As Long
Dim ld_SMax As Double, ld_SMin As Double
Dim ld_StepCorrectedNoCheck As Double, ld_StepCorrected As Double

  RPL_SCorr = 0
  If (RPL_UBoW(eDPCSide.esSideC) >= 0) And (RPL_UBoW(eDPCSide.esSideD) >= 0) Then
    ' calculation of real perforation width
    ld_WantPrfW = RPL_PanB - (RPL_UBoW(eDPCSide.esSideC) + RPL_UBoW(eDPCSide.esSideD))
    If (ld_WantPrfW > 0) And (PRF_DivB * PRF_SBMin > 0) Then
      ll_StampRowBCount = Int((ld_WantPrfW - PRF_HoleB + PRF_DivB) / (PRF_DivB * PRF_SBMin))
      ld_PrfW = ll_StampRowBCount * (PRF_DivB * PRF_SBMin) + PRF_HoleB - PRF_DivB
      RPL_UBor(eDPCSide.esSideC) = Round((ld_WantPrfW - ld_PrfW) / 2 + RPL_UBoW(eDPCSide.esSideC), 2)
      RPL_UBor(eDPCSide.esSideD) = Round((ld_WantPrfW - ld_PrfW) / 2 + RPL_UBoW(eDPCSide.esSideD), 2)
    Else
      RPL_UBor(eDPCSide.esSideC) = 0
      RPL_UBor(eDPCSide.esSideD) = 0
    End If
  Else
    RPL_UBor(eDPCSide.esSideC) = RPL_UBoW(eDPCSide.esSideC)
    RPL_UBor(eDPCSide.esSideD) = RPL_UBoW(eDPCSide.esSideD)
  End If
  
  If (RPL_UBoW(eDPCSide.esSideE) >= 0) And (RPL_UBoW(eDPCSide.esSideF) >= 0) Then
    ' calculation of real perforation length
    ld_WantPrfL = RPL_PanA - (RPL_UBoW(eDPCSide.esSideE) + RPL_UBoW(eDPCSide.esSideF))
    If (ld_WantPrfL > 0) And (PRF_Step > 0) And (PRF_SAMax > 0) And (PRF_SAMin > 0) Then
      ll_Hub = Int((ld_WantPrfL - PRF_HoleA + PRF_DivA) / (PRF_Step / (PRF_SAMax / PRF_SAMin)))
      If PRF_IsCorrStep Then
        ld_SMax = PRF_Step + PRF_StLim
        ld_SMin = PRF_Step - PRF_StLim
        ld_StepCorrectedNoCheck = Int(((ld_WantPrfL - PRF_HoleA + PRF_DivA) / ll_Hub) * (PRF_SAMax / PRF_SAMin) * 100) / 100
        If ld_StepCorrectedNoCheck < ld_SMin Then
          ld_StepCorrected = PRF_Step + PRF_StLim
          ll_Hub = ll_Hub - 1
        ElseIf ld_StepCorrectedNoCheck > ld_SMax Then
          ld_StepCorrected = PRF_Step + PRF_StLim
        Else
          ld_StepCorrected = ld_StepCorrectedNoCheck
        End If
        ld_PrfL = Int((ll_Hub * (ld_StepCorrected / (PRF_SAMax / PRF_SAMin)) - (ld_StepCorrected / PRF_SAMax) + PRF_HoleA) * 100) / 100
      Else
        ld_PrfL = ll_Hub * (PRF_Step / (PRF_SAMax / PRF_SAMin)) - PRF_DivA + PRF_HoleA
      End If
      RPL_SCorr = ld_StepCorrected
      RPL_UBor(eDPCSide.esSideE) = Round((ld_WantPrfL - ld_PrfL) / 2 + RPL_UBoW(eDPCSide.esSideE), 2)
      RPL_UBor(eDPCSide.esSideF) = Round((ld_WantPrfL - ld_PrfL) / 2 + RPL_UBoW(eDPCSide.esSideF), 2)
    Else
      RPL_UBor(eDPCSide.esSideE) = RPL_UBoW(eDPCSide.esSideE)
      RPL_UBor(eDPCSide.esSideF) = RPL_UBoW(eDPCSide.esSideF)
    End If
  Else
    RPL_UBor(eDPCSide.esSideE) = RPL_UBoW(eDPCSide.esSideE)
    RPL_UBor(eDPCSide.esSideF) = RPL_UBoW(eDPCSide.esSideF)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalcPerfBorder")
End Sub

Private Function GetCoilBendSubValue(ByVal ae_SideIdx As eDPCSide) As Double
On Error GoTo ErrHandler

Dim ld_Size As Double
Dim ld_SubValue As Double

  Select Case Round(RPL_Thick, 2)
  Case 0.5
    ld_SubValue = 1
  Case 0.6
    ld_SubValue = 1.2
  Case 0.7
    ld_SubValue = 1.4
  Case 0.75
    ld_SubValue = 1.5
  Case 0.8
    ld_SubValue = 1.6
  Case 1
    ld_SubValue = 1.8
  Case 1.2
    ld_SubValue = 2.2
  Case 1.25
    ld_SubValue = 2.2
  Case Else
    ld_SubValue = 2 * RPL_Thick
  End Select
  ld_Size = 0
  If RPL_H(ae_SideIdx) > 0 Then
    ld_Size = ld_Size + ld_SubValue
  End If
  If (RPL_UMin(ae_SideIdx) > 0) Or (RPL_U(ae_SideIdx) > 0) Then
    ld_Size = ld_Size + ld_SubValue
  End If
  If RPL_S(ae_SideIdx) > 0 Then
    ld_Size = ld_Size + ld_SubValue
  End If
  GetCoilBendSubValue = ld_Size
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCoilBendSubValue")
End Function

Public Sub CalcBendSizeU(ByVal ad_CutB As Double)
On Error GoTo ErrHandler

  If (RPL_CustDim And eDPCCoilLock.clBendingUZA) <> 0 Then
    Exit Sub
  End If
  
  If (RPL_CoilW >= ad_CutB) And (RPL_H(eDPCSide.esSideC) > 0) And (RPL_H(eDPCSide.esSideD) > 0) Then
    RPL_U(eDPCSide.esSideC) = (ad_CutB - RPL_PanB - RPL_H(eDPCSide.esSideC) - RPL_H(eDPCSide.esSideD) - RPL_S(eDPCSide.esSideC) - RPL_S(eDPCSide.esSideD) + GetCoilBendSubValue(eDPCSide.esSideC) + GetCoilBendSubValue(eDPCSide.esSideD)) / 2
    RPL_U(eDPCSide.esSideD) = RPL_U(eDPCSide.esSideC)
  Else
    RPL_U(eDPCSide.esSideC) = 0
    RPL_U(eDPCSide.esSideD) = 0
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalcBendSizeU")
End Sub

Public Sub CalculateCoWMinMax()
On Error GoTo ErrHandler

Dim ld_Size As Double
  
  If ((RPL_CustDim And eDPCCoilLock.clCoilMinMax) <> 0) Or IsTemplate Then
    Exit Sub
  End If
  
  If mo_TempProduct Is Nothing Then
    If (ParentRPL_CoWMin > 0) And (ParentRPL_CoWMax > 0) Then
      RPL_CoWMin = ParentRPL_CoWMin
      RPL_CoWMax = ParentRPL_CoWMax
      Exit Sub
    End If
  Else
    If (mo_TempProduct.RPL_CoWMin > 0) And (mo_TempProduct.RPL_CoWMax > 0) Then
      RPL_CoWMin = mo_TempProduct.RPL_CoWMin
      RPL_CoWMax = mo_TempProduct.RPL_CoWMax
      Exit Sub
    End If
  End If
  
  ld_Size = RPL_PanB
  
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideD)
  
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideC) + RPL_UMin(eDPCSide.esSideC) + RPL_H(eDPCSide.esSideC)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideD) + RPL_UMin(eDPCSide.esSideD) + RPL_H(eDPCSide.esSideD)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideD)
  RPL_CoWMin = mo_Tools.RoundUp(ld_Size)
  
  ld_Size = RPL_PanB
  
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideD)
  
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideC) + RPL_UMax(eDPCSide.esSideC) + RPL_H(eDPCSide.esSideC)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideD) + RPL_UMax(eDPCSide.esSideD) + RPL_H(eDPCSide.esSideD)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideD)
  RPL_CoWMax = mo_Tools.RoundDown(ld_Size)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalculateCoWMinMax")
End Sub

Public Function GetCutA() As Double
On Error GoTo ErrHandler

  Dim ld_Size As Double

  ld_Size = RPL_PanA
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideE)
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideF)
  
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideE) + RPL_U(eDPCSide.esSideE) + RPL_H(eDPCSide.esSideE)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideE)
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideF) + RPL_U(eDPCSide.esSideF) + RPL_H(eDPCSide.esSideF)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideF)
  GetCutA = Round(ld_Size, 1)
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutA")
End Function

Public Function GetCutB() As Double
On Error GoTo ErrHandler

  Dim ld_Size As Double

  ld_Size = RPL_PanB
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_Thick * BND_MatFct(eDPCSide.esSideD)
  
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideC) + RPL_U(eDPCSide.esSideC) + RPL_H(eDPCSide.esSideC)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideC)
  ld_Size = ld_Size + RPL_S(eDPCSide.esSideD) + RPL_U(eDPCSide.esSideD) + RPL_H(eDPCSide.esSideD)
  ld_Size = ld_Size - GetCoilBendSubValue(eDPCSide.esSideD)
  GetCutB = Round(ld_Size, 1)
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutB")
End Function

Public Sub CalculateCutAB()
On Error GoTo ErrHandler

  If ((RPL_CustDim And eDPCCoilLock.clCutAB) <> 0) Or IsTemplate Then
    Exit Sub
  End If
  
  If mo_TempProduct Is Nothing Then
    If (ParentRPL_CutA > 0) And (ParentRPL_CutB > 0) Then
      RPL_CutA = ParentRPL_CutA
      RPL_CutB = ParentRPL_CutB
      Exit Sub
    End If
  Else
    If (mo_TempProduct.RPL_CutA > 0) And (mo_TempProduct.RPL_CutB > 0) Then
      RPL_CutA = mo_TempProduct.RPL_CutA
      RPL_CutB = mo_TempProduct.RPL_CutB
      Exit Sub
    End If
  End If
  
  If (RPL_U(eDPCSide.esSideC) >= RPL_UMin(eDPCSide.esSideC)) And (RPL_U(eDPCSide.esSideC) <= RPL_UMax(eDPCSide.esSideC)) And _
     (RPL_U(eDPCSide.esSideD) >= RPL_UMin(eDPCSide.esSideD)) And (RPL_U(eDPCSide.esSideD) <= RPL_UMax(eDPCSide.esSideD)) Then
    RPL_CutA = GetCutA
    RPL_CutB = GetCutB
  Else
    RPL_CutA = 0
    RPL_CutB = 0
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalculateCutAB")
End Sub

Public Property Get RPL_NWgh() As Double
On Error GoTo ErrHandler

  RPL_NWgh = ((RPL_CutA / 1000) * (RPL_CutB / 1000) * RPL_Thick * COI_SpcWgh) / (PRF_FSC / 100 + 1)
  Exit Property
ErrHandler:
  Call ErrorHandler("RPL_NWgh.Get")
End Property

Private Sub InsertPrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_ins $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, NULL, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlIntKey(CAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(PRD_Child), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(LEV_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(ERR_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", mo_Tools.SqlIntKey(IMG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", mo_Tools.SqlIntKey(STA_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdCommon")
End Sub

Private Sub UpdatePrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_upd $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, NULL, $Z_Last_Upd_User$, $iConcurrency$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlIntKey(CAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(PRD_Child), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(LEV_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(ERR_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", mo_Tools.SqlIntKey(IMG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", mo_Tools.SqlIntKey(STA_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdCommon")
End Sub

Private Sub DropPrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_del $PRD_Id$,$Z_Last_Upd_User$,$iConcurrency$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdCommon")
End Sub

Private Sub InsertPrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_ins $PRD_Id$, $Language_Code$, $PRD_Name$, $PRD_Desc$, $Z_Creator$, $PRD_IdPar$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Name$", mo_Tools.SQLStr(PRD_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Desc$", mo_Tools.SQLStr(PRD_Desc), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(PRD_IdPar), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdDesc")
End Sub

Private Sub UpdatePrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_upd $PRD_Id$, $Language_Code$, $PRD_Name$, $PRD_Desc$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Name$", mo_Tools.SQLStr(PRD_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Desc$", mo_Tools.SQLStr(PRD_Desc), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdDesc")
End Sub

Private Sub DropPrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_del $PRD_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdDesc")
End Sub

Private Sub InsertPrdRectPanel()
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_SideIdx As Long

  ls_req = "exec DPC_RectPanel_ins $RPL_Id$, $SYS_Id$, $RPL_Type$, $RPL_ModA$, $RPL_ModB$, $RPL_PanA$, $RPL_PanB$, $RPL_CutA$, $RPL_CutB$,"
  ls_req = ls_req & "$RPL_Thick$, $RPL_HC$, $RPL_HD$, $RPL_HE$, $RPL_HF$,"
  ls_req = ls_req & "$RPL_SBndA$, $RPL_SBndB$, $RPL_SUZA$, $RPL_SUZA$,"
  ls_req = ls_req & "$RPL_UMinC$, $RPL_UMaxC$, $RPL_UC$, $RPL_SC$, $RPL_UMinD$, $RPL_UMaxD$, $RPL_UD$, $RPL_SD$, $RPL_UE$, $RPL_SE$, $RPL_UF$, $RPL_SF$,"
  ls_req = ls_req & "$RPL_StdGa$, $RPL_GapC$, $RPL_GapD$, $RPL_GapE$, $RPL_GapF$, $RPL_BevA$, $RPL_BevB$,"
  ls_req = ls_req & "$RPL_CorW$, $RPL_StdMa$, $MAT_Id$, $RPL_CoWMin$, $RPL_CoWMax$, $RPL_CoilW$, $RPL_CustDim$, $RPL_MatTyp$,"
  ls_req = ls_req & "$COI_Code$, $COI_SpcWgh$, $COI_WasteFact$, $COI_WasteQty$, $COI_IsStock$, $PKG_Id$, $LAB_Id$, $RPL_PU$, $RPL_MQty$, "
  ls_req = ls_req & "$BND_IdC$, $BND_IdD$, $BND_IdE$, $BND_IdF$,"
  ls_req = ls_req & "$RPL_BVisC$, $RPL_BVisD$, $RPL_BVisE$, $RPL_BVisF$,"
  ls_req = ls_req & "$RPL_NCloC$, $RPL_NCloD$, $RPL_NCloE$, $RPL_NCloF$,"
  ls_req = ls_req & "$PRF_Id$,$RPL_PBord$,$RPL_UBorC$, $RPL_UBorD$, $RPL_UBorE$, $RPL_UBorF$,"
  ls_req = ls_req & "$RPL_UBoWC$, $RPL_UBoWD$, $RPL_UBoWE$, $RPL_UBoWF$,"
  ls_req = ls_req & "$COA_Id$, $COA_Code$, $COA_Type$, $COA_App$, $COA_Norm$, $COA_Mat$, $COA_IsCus$, $COA_ExName$, $RPL_CoSid$, $COA_CE$,"
  ls_req = ls_req & "$GSK_IdC$, $GSK_IdD$, $GSK_IdE$, $GSK_IdF$,"
  ls_req = ls_req & "$GSK_CodeC$, $GSK_CodeD$, $GSK_CodeE$, $GSK_CodeF$,"
  ls_req = ls_req & "$GSK_ExNameC$, $GSK_ExNameD$, $GSK_ExNameE$, $GSK_ExNameF$,"
  ls_req = ls_req & "$GSK_Id2C$, $GSK_Id2D$, $GSK_Id2E$, $GSK_Id2F$,"
  ls_req = ls_req & "$GSK_Code2C$, $GSK_Code2D$, $GSK_Code2E$, $GSK_Code2F$,"
  ls_req = ls_req & "$GSK_ExName2C$, $GSK_ExName2D$, $GSK_ExName2E$, $GSK_ExName2F$,"
  ls_req = ls_req & "$RPL_GskDe$,$RPL_SpcDe$,$RPL_SpcNt$,$RPL_PerDe$,$RPL_SwGap$,$RPL_Plate$,$RPL_PlCnt$,$RPL_IsOut$,$RPL_DrwNr$,$RPL_SpcPkg$,"
  ls_req = ls_req & "$RPL_WghPnt$,  $RPL_OGroup$,  $RPL_PGroup$,  $RPL_AGroup$,  $RPL_MGroup$, $RPL_LabLng$, $RPL_NWgh$,"
  ls_req = ls_req & "$RPL_AdminFact$, $RPL_ICTPFact$, $RPL_MPE2Fact$, $RPL_BOMRejectFact$, $RPL_BORWasteFact$, $RPL_RejectOtherFact$,"
  ls_req = ls_req & "$Z_Creator$"
  
  ls_req = Replace(ls_req, "$RPL_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Type$", mo_Tools.SqlInt(RPL_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ModA$", mo_Tools.SqlDbl(RPL_ModA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ModB$", mo_Tools.SqlDbl(RPL_ModB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CutA$", mo_Tools.SqlDbl(RPL_CutA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CutB$", mo_Tools.SqlDbl(RPL_CutB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Thick$", mo_Tools.SqlDbl(RPL_Thick), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SBndA$", mo_Tools.SqlBool(RPL_SBndA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SBndB$", mo_Tools.SqlBool(RPL_SBndB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SUZA$", mo_Tools.SqlBool(RPL_SUZA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SUZB$", mo_Tools.SqlBool(RPL_SUZB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_StdGa$", mo_Tools.SqlBool(RPL_StdGa), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BevA$", mo_Tools.SqlDbl(RPL_BevA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BevB$", mo_Tools.SqlDbl(RPL_BevB), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_CorW$", mo_Tools.SqlDbl(RPL_CorW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_StdMa$", mo_Tools.SqlBool(RPL_StdMa), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlIntKey(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoWMin$", mo_Tools.SqlDbl(RPL_CoWMin), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoWMax$", mo_Tools.SqlDbl(RPL_CoWMax), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoilW$", mo_Tools.SqlDbl(RPL_CoilW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CustDim$", mo_Tools.SqlInt(RPL_CustDim), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MatTyp$", mo_Tools.SQLStr(RPL_MatTyp), , , vbTextCompare)
    
  ls_req = Replace(ls_req, "$COI_Code$", mo_Tools.SQLStr(COI_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_SpcWgh$", mo_Tools.SqlDbl(COI_SpcWgh), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_WasteFact$", mo_Tools.SqlDbl(COI_WasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_WasteQty$", mo_Tools.SqlDbl(COI_WasteQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_IsStock$", mo_Tools.SqlBool(COI_IsStock), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$PKG_Id$", mo_Tools.SqlStrKey(PKG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LAB_Id$", mo_Tools.SqlStrKey(LAB_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PU$", mo_Tools.SqlInt(RPL_PU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MQty$", mo_Tools.SqlDbl(RPL_MQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRF_Id$", mo_Tools.SqlStrKey(PRF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PBord$", mo_Tools.SqlInt(RPL_PBord), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Id$", mo_Tools.SqlStrKey(COA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Code$", mo_Tools.SQLStr(COA_Code), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$COA_Type$", mo_Tools.SqlInt(COA_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_App$", mo_Tools.SqlInt(COA_App), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Norm$", mo_Tools.SqlInt(COA_Norm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Mat$", mo_Tools.SqlInt(COA_Mat), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_ExName$", mo_Tools.SQLStr(COA_ExName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_IsCus$", mo_Tools.SqlBool(COA_IsCus), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoSid$", mo_Tools.SqlInt(RPL_CoSid), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_CE$", mo_Tools.SqlInt(COA_CE), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_GskDe$", mo_Tools.SqlInt(RPL_GskDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcDe$", mo_Tools.SqlInt(RPL_SpcDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcNt$", mo_Tools.SqlBool(RPL_SpcNt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PerDe$", mo_Tools.SqlInt(RPL_PerDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SwGap$", mo_Tools.SqlDbl(RPL_SwGap), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Plate$", mo_Tools.SqlInt(RPL_Plate), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PlCnt$", mo_Tools.SqlInt(RPL_PlCnt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_IsOut$", mo_Tools.SqlInt(RPL_IsOut), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_DrwNr$", mo_Tools.SQLStr(RPL_DrwNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcPkg$", mo_Tools.SqlInt(RPL_SpcPkg), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_WghPnt$", mo_Tools.SqlInt(RPL_WghPnt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_OGroup$", mo_Tools.SQLStr(RPL_OGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PGroup$", mo_Tools.SQLStr(RPL_PGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_AGroup$", mo_Tools.SQLStr(RPL_AGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MGroup$", mo_Tools.SQLStr(RPL_MGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_LabLng$", mo_Tools.SQLStr(RPL_LabLng), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_NWgh$", mo_Tools.SqlDbl(RPL_NWgh), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_AdminFact$", mo_Tools.SqlDbl(RPL_AdminFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ICTPFact$", mo_Tools.SqlDbl(RPL_ICTPFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MPE2Fact$", mo_Tools.SqlDbl(RPL_MPE2Fact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BOMRejectFact$", mo_Tools.SqlDbl(RPL_BOMRejectFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BORWasteFact$", mo_Tools.SqlDbl(RPL_BORWasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_RejectOtherFact$", mo_Tools.SqlDbl(RPL_RejectOtherFact), , , vbTextCompare)
  
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    ls_req = Replace(ls_req, "$RPL_H" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_H(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UMin" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UMin(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UMax" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UMax(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_U" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_U(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_S" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_S(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BND_Id" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(BND_Id(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Id" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(GSK_Id(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Code" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_Code(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_ExName" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_ExName(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Id2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(GSK_Id2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Code2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_Code2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_ExName2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_ExName2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UBor" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UBor(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UBoW" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UBoW(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_Gap" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_Gap(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_BVis" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlBool(RPL_BVis(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_NClo" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlBool(RPL_NClo(ll_SideIdx)), , , vbTextCompare)
  Next
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdRectPanel")
End Sub

Public Sub UpdatePrdRectPanel()
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_SideIdx As Long

  ls_req = "exec DPC_RectPanel_upd $RPL_Id$, $SYS_Id$, $RPL_Type$, $RPL_ModA$, $RPL_ModB$, $RPL_PanA$, $RPL_PanB$, $RPL_CutA$, $RPL_CutB$,"
  ls_req = ls_req & "$RPL_Thick$, $RPL_HC$, $RPL_HD$, $RPL_HE$, $RPL_HF$,"
  ls_req = ls_req & "$RPL_SBndA$, $RPL_SBndB$, $RPL_SUZA$, $RPL_SUZA$,"
  ls_req = ls_req & "$RPL_UMinC$, $RPL_UMaxC$, $RPL_UC$, $RPL_SC$, $RPL_UMinD$, $RPL_UMaxD$, $RPL_UD$, $RPL_SD$, $RPL_UE$, $RPL_SE$, $RPL_UF$, $RPL_SF$,"
  ls_req = ls_req & "$RPL_StdGa$, $RPL_GapC$, $RPL_GapD$, $RPL_GapE$, $RPL_GapF$, $RPL_BevA$, $RPL_BevB$,"
  ls_req = ls_req & "$RPL_CorW$, $RPL_StdMa$, $MAT_Id$, $RPL_CoWMin$, $RPL_CoWMax$, $RPL_CoilW$, $RPL_CustDim$, $RPL_MatTyp$,"
  ls_req = ls_req & "$COI_Code$, $COI_SpcWgh$, $COI_WasteFact$, $COI_WasteQty$, $COI_IsStock$, $PKG_Id$, $LAB_Id$, $RPL_PU$, $RPL_MQty$, "
  ls_req = ls_req & "$BND_IdC$, $BND_IdD$, $BND_IdE$, $BND_IdF$,"
  ls_req = ls_req & "$RPL_BVisC$, $RPL_BVisD$, $RPL_BVisE$, $RPL_BVisF$,"
  ls_req = ls_req & "$RPL_NCloC$, $RPL_NCloD$, $RPL_NCloE$, $RPL_NCloF$,"
  ls_req = ls_req & "$PRF_Id$,$RPL_PBord$,$RPL_UBorC$, $RPL_UBorD$, $RPL_UBorE$, $RPL_UBorF$,"
  ls_req = ls_req & "$RPL_UBoWC$, $RPL_UBoWD$, $RPL_UBoWE$, $RPL_UBoWF$,"
  ls_req = ls_req & "$COA_Id$, $COA_Code$, $COA_Type$, $COA_App$,  $COA_Norm$, $COA_Mat$, $COA_IsCus$, $COA_ExName$, $RPL_CoSid$, $COA_CE$,"
  ls_req = ls_req & "$GSK_IdC$, $GSK_IdD$, $GSK_IdE$, $GSK_IdF$,"
  ls_req = ls_req & "$GSK_CodeC$, $GSK_CodeD$, $GSK_CodeE$, $GSK_CodeF$,"
  ls_req = ls_req & "$GSK_ExNameC$, $GSK_ExNameD$, $GSK_ExNameE$, $GSK_ExNameF$,"
  ls_req = ls_req & "$GSK_Id2C$, $GSK_Id2D$, $GSK_Id2E$, $GSK_Id2F$,"
  ls_req = ls_req & "$GSK_Code2C$, $GSK_Code2D$, $GSK_Code2E$, $GSK_Code2F$,"
  ls_req = ls_req & "$GSK_ExName2C$, $GSK_ExName2D$, $GSK_ExName2E$, $GSK_ExName2F$,"
  ls_req = ls_req & "$RPL_GskDe$,$RPL_SpcDe$,$RPL_SpcNt$,$RPL_PerDe$,$RPL_SwGap$, $RPL_Plate$,$RPL_PlCnt$,$RPL_IsOut$,$RPL_DrwNr$,$RPL_SpcPkg$,"
  ls_req = ls_req & "$RPL_WghPnt$,  $RPL_OGroup$,  $RPL_PGroup$,  $RPL_AGroup$, $RPL_MGroup$, $RPL_LabLng$, $RPL_NWgh$,"
  ls_req = ls_req & "$RPL_AdminFact$, $RPL_ICTPFact$, $RPL_MPE2Fact$, $RPL_BOMRejectFact$, $RPL_BORWasteFact$, $RPL_RejectOtherFact$,"
  ls_req = ls_req & "$Z_Last_Upd_User$"

  ls_req = Replace(ls_req, "$RPL_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Type$", mo_Tools.SqlInt(RPL_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ModA$", mo_Tools.SqlDbl(RPL_ModA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ModB$", mo_Tools.SqlDbl(RPL_ModB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanA$", mo_Tools.SqlDbl(RPL_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PanB$", mo_Tools.SqlDbl(RPL_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CutA$", mo_Tools.SqlDbl(RPL_CutA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CutB$", mo_Tools.SqlDbl(RPL_CutB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Thick$", mo_Tools.SqlDbl(RPL_Thick), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SBndA$", mo_Tools.SqlBool(RPL_SBndA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SBndB$", mo_Tools.SqlBool(RPL_SBndB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SUZA$", mo_Tools.SqlBool(RPL_SUZA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SUZB$", mo_Tools.SqlBool(RPL_SUZB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_StdGa$", mo_Tools.SqlBool(RPL_StdGa), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BevA$", mo_Tools.SqlDbl(RPL_BevA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BevB$", mo_Tools.SqlDbl(RPL_BevB), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_CorW$", mo_Tools.SqlDbl(RPL_CorW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_StdMa$", mo_Tools.SqlBool(RPL_StdMa), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlIntKey(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoWMin$", mo_Tools.SqlDbl(RPL_CoWMin), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoWMax$", mo_Tools.SqlDbl(RPL_CoWMax), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoilW$", mo_Tools.SqlDbl(RPL_CoilW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CustDim$", mo_Tools.SqlInt(RPL_CustDim), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MatTyp$", mo_Tools.SQLStr(RPL_MatTyp), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$COI_Code$", mo_Tools.SQLStr(COI_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_SpcWgh$", mo_Tools.SqlDbl(COI_SpcWgh), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_WasteFact$", mo_Tools.SqlDbl(COI_WasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_WasteQty$", mo_Tools.SqlDbl(COI_WasteQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COI_IsStock$", mo_Tools.SqlBool(COI_IsStock), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PKG_Id$", mo_Tools.SqlStrKey(PKG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LAB_Id$", mo_Tools.SqlStrKey(LAB_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PU$", mo_Tools.SqlInt(RPL_PU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MQty$", mo_Tools.SqlDbl(RPL_MQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRF_Id$", mo_Tools.SqlStrKey(PRF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PBord$", mo_Tools.SqlInt(RPL_PBord), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Id$", mo_Tools.SqlStrKey(COA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Code$", mo_Tools.SQLStr(COA_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Type$", mo_Tools.SqlInt(COA_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_App$", mo_Tools.SqlInt(COA_App), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Norm$", mo_Tools.SqlInt(COA_Norm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_Mat$", mo_Tools.SqlInt(COA_Mat), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_ExName$", mo_Tools.SQLStr(COA_ExName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_IsCus$", mo_Tools.SqlBool(COA_IsCus), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_CoSid$", mo_Tools.SqlInt(RPL_CoSid), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COA_CE$", mo_Tools.SqlInt(COA_CE), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_GskDe$", mo_Tools.SqlInt(RPL_GskDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcDe$", mo_Tools.SqlInt(RPL_SpcDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcNt$", mo_Tools.SqlBool(RPL_SpcNt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PerDe$", mo_Tools.SqlInt(RPL_PerDe), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SwGap$", mo_Tools.SqlDbl(RPL_SwGap), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_Plate$", mo_Tools.SqlInt(RPL_Plate), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PlCnt$", mo_Tools.SqlInt(RPL_PlCnt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_IsOut$", mo_Tools.SqlInt(RPL_IsOut), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_DrwNr$", mo_Tools.SQLStr(RPL_DrwNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_SpcPkg$", mo_Tools.SqlInt(RPL_SpcPkg), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_WghPnt$", mo_Tools.SqlInt(RPL_WghPnt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_OGroup$", mo_Tools.SQLStr(RPL_OGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_PGroup$", mo_Tools.SQLStr(RPL_PGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_AGroup$", mo_Tools.SQLStr(RPL_AGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MGroup$", mo_Tools.SQLStr(RPL_MGroup), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_LabLng$", mo_Tools.SQLStr(RPL_LabLng), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_NWgh$", mo_Tools.SqlDbl(RPL_NWgh), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$RPL_AdminFact$", mo_Tools.SqlDbl(RPL_AdminFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_ICTPFact$", mo_Tools.SqlDbl(RPL_ICTPFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_MPE2Fact$", mo_Tools.SqlDbl(RPL_MPE2Fact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BOMRejectFact$", mo_Tools.SqlDbl(RPL_BOMRejectFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_BORWasteFact$", mo_Tools.SqlDbl(RPL_BORWasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$RPL_RejectOtherFact$", mo_Tools.SqlDbl(RPL_RejectOtherFact), , , vbTextCompare)
  
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    ls_req = Replace(ls_req, "$RPL_H" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_H(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UMin" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UMin(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UMax" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UMax(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_U" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_U(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_S" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_S(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BND_Id" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(BND_Id(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Id" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(GSK_Id(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Code" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_Code(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_ExName" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_ExName(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Id2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlStrKey(GSK_Id2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_Code2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_Code2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$GSK_ExName2" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SQLStr(GSK_ExName2(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UBor" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UBor(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_UBoW" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_UBoW(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_Gap" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(RPL_Gap(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_BVis" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlBool(RPL_BVis(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$RPL_NClo" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlBool(RPL_NClo(ll_SideIdx)), , , vbTextCompare)
  Next
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdRectPanel")
End Sub

Private Sub DropPrdRectPanel()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_RectPanel_del $RPL_Id$, $Z_Last_Upd_User$"
'  ls_Req = "UPDATE DPC_RectPanel "
'  ls_Req = ls_Req & "SET "
'  ls_Req = ls_Req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
'  ls_Req = ls_Req & "Z_Last_Upd=getdate(),"
'  ls_Req = ls_Req & "iConcurrency=iConcurrency+1,"
'  ls_Req = ls_Req & "drop_flag='X',"
'  ls_Req = ls_Req & "drop_date=getdate() "
'  ls_Req = ls_Req & "WHERE RPL_Id=$RPL_Id$"
  ls_req = Replace(ls_req, "$RPL_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdRectPanel")
End Sub

Public Sub InsertPrdCE()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCE_ins1 $PRD_Id$, $CLS_Id1$, $CLS_Name1$, $CLS_Id2$, $CLS_Name2$, $CLS_Id3$, $CLS_Name3$, $CLS_Id4$, $CLS_Name4$,"
  ls_req = ls_req & "$CLS_Id5$, $CLS_Name5$, $CLS_Id6$, $CLS_Name6$, $CLS_Id7$, $CLS_Name7$, $CLS_Id8$, $CLS_Name8$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id1$", mo_Tools.SqlIntKey(CLS_Id1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name1$", mo_Tools.SQLStr(CLS_Name1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id2$", mo_Tools.SqlIntKey(CLS_Id2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name2$", mo_Tools.SQLStr(CLS_Name2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id3$", mo_Tools.SqlIntKey(CLS_Id3), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name3$", mo_Tools.SQLStr(CLS_Name3), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id4$", mo_Tools.SqlIntKey(CLS_Id4), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name4$", mo_Tools.SQLStr(CLS_Name4), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id5$", mo_Tools.SqlIntKey(CLS_Id5), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name5$", mo_Tools.SQLStr(CLS_Name5), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id6$", mo_Tools.SqlIntKey(CLS_Id6), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name6$", mo_Tools.SQLStr(CLS_Name6), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id7$", mo_Tools.SqlIntKey(CLS_Id7), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name7$", mo_Tools.SQLStr(CLS_Name7), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id8$", mo_Tools.SqlIntKey(CLS_Id8), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name8$", mo_Tools.SQLStr(CLS_Name8), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdCE")
End Sub

Public Sub UpdatePrdCE()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCE_upd1 $PRD_Id$, $CLS_Id1$, $CLS_Name1$, $CLS_Id2$, $CLS_Name2$, $CLS_Id3$, $CLS_Name3$, $CLS_Id4$, $CLS_Name4$,"
  ls_req = ls_req & "$CLS_Id5$, $CLS_Name5$, $CLS_Id6$, $CLS_Name6$, $CLS_Id7$, $CLS_Name7$, $CLS_Id8$, $CLS_Name8$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id1$", mo_Tools.SqlIntKey(CLS_Id1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name1$", mo_Tools.SQLStr(CLS_Name1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id2$", mo_Tools.SqlIntKey(CLS_Id2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name2$", mo_Tools.SQLStr(CLS_Name2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id3$", mo_Tools.SqlIntKey(CLS_Id3), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name3$", mo_Tools.SQLStr(CLS_Name3), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id4$", mo_Tools.SqlIntKey(CLS_Id4), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name4$", mo_Tools.SQLStr(CLS_Name4), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id5$", mo_Tools.SqlIntKey(CLS_Id5), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name5$", mo_Tools.SQLStr(CLS_Name5), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id6$", mo_Tools.SqlIntKey(CLS_Id6), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name6$", mo_Tools.SQLStr(CLS_Name6), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id7$", mo_Tools.SqlIntKey(CLS_Id7), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name7$", mo_Tools.SQLStr(CLS_Name7), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Id8$", mo_Tools.SqlIntKey(CLS_Id8), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CLS_Name8$", mo_Tools.SQLStr(CLS_Name8), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdCE")
End Sub

Private Sub DropPrdCE()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCE_Del $PRD_Id$,$Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdCE")
End Sub

Private Sub InsertPrdBaeurer()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdBaeurer_ins $PRD_Id$,$Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdBaeurer")
End Sub

Public Sub Insert()
On Error GoTo ErrHandler
  
  If (CAT_Id <> eDPCCategory.cgMetalPanelSKU) Or IsTemplate Then
    PRD_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdCommon")
    Call InsertPrdCommon
    Call InsertPrdDesc
    Call InsertPrdRectPanel
    Call InsertPrdCE
    Call InsertPrdBaeurer
    Call SaveCutout
    Call SaveInlays
    Call SaveFile
    Call SaveBOM
    Call SaveBOR
    Call SaveCostCalculation
  End If
  'Call SaveOfferOptions
  Call SaveText
  Exit Sub
ErrHandler:
  Call ErrorHandler("Insert")
End Sub

Public Sub Update()
On Error GoTo ErrHandler
  
  If (Not IsStandard) Or IsTemplate Then
    Call UpdatePrdCommon
    Call UpdatePrdDesc
    Call UpdatePrdRectPanel
    Call UpdatePrdCE
    Call SaveCutout
    Call SaveInlays
    Call SaveFile
    Call SaveBOM
    Call SaveBOR
    Call SaveCostCalculation
  End If
  'Call SaveOfferOptions
  Call SaveText
  Exit Sub
ErrHandler:
  Call ErrorHandler("Update")
End Sub

Public Sub Drop()
On Error GoTo ErrHandler
  
  If (CAT_Id <> eDPCCategory.cgMetalPanelSKU) Or IsTemplate Then
    Call DropPrdCommon
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("Drop")
End Sub

Public Sub SetRowStatus(ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay
Dim lo_Option As DPC_Option
Dim lo_Error As DPC_Error

  For Each lo_Cutout In Cutouts
    If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
      lo_Cutout.RowStatus = ae_RowStatus
    End If
  Next

  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
      lo_Inlay.RowStatus = ae_RowStatus
    End If
  Next

'  For Each lo_Option In Options
'    If lo_Option.RowStatus <> eDPCRowStatus.rsDrop <> 0 Then
'      lo_Option.RowStatus = ae_RowStatus
'    End If
'  Next

  'For Each lo_Error In Errors
  '  If StrComp(lo_Error.RowStatus, eDPCRowStatus.rsDrop, vbTextCompare) <> 0 Then
  '    lo_Error.RowStatus = as_RowStatus
  '  End If
  'Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetRowStatus")
End Sub

Private Sub ResetInterfaceInfo(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
  
  For Each lo_Offer In ao_Collection
    lo_Offer.OFD_SAPAct = ""
    lo_Offer.OFD_SAPInfo = ""
    lo_Offer.OFD_SAPSta = 0
    lo_Offer.OFD_PosSAP = 0
    
    lo_Offer.OFD_B7Sta = 0
    lo_Offer.OFD_PosB7 = 0
    lo_Offer.OFD_OrdNrB7 = ""
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetInterfaceInfo")
End Sub

Public Sub Copy()
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay
Dim lo_Cutout As DPC_Cutout

  Call ResetInterfaceInfo(OfferPrice)
  For Each lo_Inlay In Inlays
    Call ResetInterfaceInfo(lo_Inlay.OfferPrice)
  Next
  For Each lo_Cutout In Cutouts
    Call ResetInterfaceInfo(lo_Cutout.OfferPrice)
  Next
  
  Call SetRowStatus(eDPCRowStatus.rsAdd)
  Call CreateCode
  Exit Sub
ErrHandler:
  Call ErrorHandler("Copy")
End Sub

Public Sub CreateCode()
On Error GoTo ErrHandler

Dim lc_Cursor As Long
'Dim ls_PRD_Code As String
'Dim lsa_Config() As String
'Dim ls_Prefix As String, ll_SeqSize As Long, ls_Code As String

  If (CAT_Id <> eDPCCategory.cgMetalPanelSKU) Then
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, "exec DPC_PRD_Child_Next " & mo_Tools.SQLStr(PRD_IdPar))
    PRD_Child = mo_Db.GetFields(lc_Cursor, "PRD_Child")
    'ls_PRD_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
    'PRD_Code = ls_PRD_Code & "\" & PRD_Child
    Call mo_Db.Close(lc_Cursor)
'    lsa_Config = Split(mo_Tools.GetAConfigData("DPC_PRD_Code"), SEP)
'    If UBound(lsa_Config) = 1 Then
'      ls_Prefix = lsa_Config(0)
'      ll_SeqSize = lsa_Config(1)
'    End If
    PRD_Code = mo_Tools.GetNextID(mo_Db, "DPC_PRD_Code")
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CreateCode")
End Sub

Public Sub SaveCutout()
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Order As Long

  ll_Order = 1
  For Each lo_Cutout In Cutouts
    If lo_Cutout.RowStatus = eDPCRowStatus.rsDrop Then
      lo_Cutout.PCT_Order = 0
    Else
      If lo_Cutout.PCT_Order <> ll_Order Then
        lo_Cutout.PCT_Order = ll_Order
        If lo_Cutout.RowStatus = eDPCRowStatus.rsNone Then
          lo_Cutout.RowStatus = rsUpdate
        End If
      End If
      ll_Order = ll_Order + 1
    End If
  Next

  For Each lo_Cutout In Cutouts
    Select Case lo_Cutout.RowStatus
    Case eDPCRowStatus.rsAdd
      Call InsertPrdCutout(lo_Cutout)
    Case eDPCRowStatus.rsUpdate
      Call UpdatePrdCutout(lo_Cutout)
    Case eDPCRowStatus.rsDrop
      Call DropPrdCutout(lo_Cutout)
    End Select
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveCutout")
End Sub

Public Sub SaveInlays()
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay
Dim ll_Order As Long

  ll_Order = 1
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus = eDPCRowStatus.rsDrop Then
      lo_Inlay.PIN_Order = 0
    Else
      If lo_Inlay.PIN_Order <> ll_Order Then
        lo_Inlay.PIN_Order = ll_Order
        If lo_Inlay.RowStatus = eDPCRowStatus.rsNone Then
          lo_Inlay.RowStatus = rsUpdate
        End If
      End If
      ll_Order = ll_Order + 1
    End If
  Next
  
  'first delete items to avoid add the same unique key
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus = eDPCRowStatus.rsDrop Then
      Call DropPrdInlay(lo_Inlay)
    End If
  Next
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus = eDPCRowStatus.rsUpdate Then
      Call UpdatePrdInlay(lo_Inlay)
    End If
  Next
  For Each lo_Inlay In Inlays
    If lo_Inlay.RowStatus = eDPCRowStatus.rsAdd Then
      Call InsertPrdInlay(lo_Inlay)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveInlays")
End Sub

Private Function GenerateOfferOptions(ByVal ao_Collection As Collection) As Collection
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim ll_Order As Long

  ll_Order = 1
  For Each lo_Offer In OfferOptions
    If lo_Offer.RowStatus = eDPCRowStatus.rsDrop Then
      lo_Offer.OFD_Order = 0
    Else
      If lo_Offer.OFD_Order <> ll_Order Then
        lo_Offer.OFD_Order = ll_Order
        If lo_Offer.RowStatus = eDPCRowStatus.rsNone Then
          lo_Offer.RowStatus = rsUpdate
        End If
      End If
      ll_Order = ll_Order + 1
    End If
  Next

  'first delete items to avoid add the same unique key
  For Each lo_Offer In OfferOptions
    If lo_Offer.RowStatus <> eDPCRowStatus.rsDrop Then
      Call ao_Collection.Add(lo_Offer)
    End If
  Next
  Set GenerateOfferOptions = ao_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("GenerateOfferOptions")
End Function

Private Sub SaveText()
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  'first delete items
  Call DeletePrdText
  For Each lo_Error In Errors
    Call InsertPrdText(lo_Error)
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveText")
End Sub

Private Sub SaveFile()
On Error GoTo ErrHandler

Dim lo_File As DPC_File

  'first delete items to avoid add the same unique key
  For Each lo_File In Files
    If lo_File.RowStatus = eDPCRowStatus.rsDrop Then
      Call DropPrdFile(lo_File)
    End If
  Next
  For Each lo_File In Files
    If lo_File.RowStatus = eDPCRowStatus.rsUpdate Then
      Call UpdatePrdFile(lo_File)
    End If
  Next
  For Each lo_File In Files
    If lo_File.RowStatus = eDPCRowStatus.rsAdd Then
      Call InsertPrdFile(lo_File)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveFile")
End Sub

Public Sub SaveBOM()
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM

  'first delete items to avoid add the same unique key
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus = eDPCRowStatus.rsDrop Then
      Call DropBOM(lo_BOM)
    End If
  Next
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus = eDPCRowStatus.rsUpdate Then
      Call UpdateBOM(lo_BOM)
    End If
  Next
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus = eDPCRowStatus.rsAdd Then
      Call InsertBOM(lo_BOM)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveBOM")
End Sub

Public Sub SaveBOR()
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR

  'first delete items to avoid add the same unique key
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus = eDPCRowStatus.rsDrop Then
      Call DropBOR(lo_BOR)
    End If
  Next
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus = eDPCRowStatus.rsUpdate Then
      Call UpdateBOR(lo_BOR)
    End If
  Next
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus = eDPCRowStatus.rsAdd Then
      Call InsertBOR(lo_BOR)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveBOR")
End Sub

Private Sub InsertPrdCutout(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_SideIdx As Long

  ao_Cutout.PCT_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdCut")
  
  ls_req = "exec DPC_PrdCommon_ins $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, NULL, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(ao_Cutout.PCT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlInt(eDPCCategory.cgLinkedCutout), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(0), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(ao_Cutout.CUT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(eDPCErrorType.etNone), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  
  ls_req = "exec DPC_PrdCut_ins $PCT_Id$, $PRD_Id$, $PCT_Type$, $PCT_Std$, $CUT_Id$,"
  ls_req = ls_req & "$PCT_SizeJ$, $PCT_SizeK$, $PCT_SizeD$, $PCT_SizeL$, $PCT_SizeM$, $PCT_PBord$,"
  ls_req = ls_req & "$PCT_UBorC$, $PCT_UBorD$, $PCT_UBorE$, $PCT_UBorF$,"
  ls_req = ls_req & "$PCT_UBoWC$, $PCT_UBoWD$, $PCT_UBoWE$, $PCT_UBoWF$, $PCT_Order$,"
  ls_req = ls_req & "$Z_Creator$"
  
  ls_req = Replace(ls_req, "$PCT_Id$", mo_Tools.SQLStr(ao_Cutout.PCT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Type$", mo_Tools.SqlInt(ao_Cutout.PCT_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Std$", mo_Tools.SqlBool(ao_Cutout.PCT_Std), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CUT_Id$", mo_Tools.SqlStrKey(ao_Cutout.CUT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeJ$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeJ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeK$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeK), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeD$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeD), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeL$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeL), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeM$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeM), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Order$", mo_Tools.SqlInt(ao_Cutout.PCT_Order), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_PBord$", mo_Tools.SqlDbl(ao_Cutout.PCT_PBord), , , vbTextCompare)
  
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    ls_req = Replace(ls_req, "$PCT_UBor" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(ao_Cutout.PCT_UBor(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$PCT_UBoW" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(ao_Cutout.PCT_UBoW(ll_SideIdx)), , , vbTextCompare)
  Next
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdCutout")
End Sub

Private Sub UpdatePrdCutout(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_SideIdx As Long

  ls_req = "exec DPC_PrdCut_upd $PCT_Id$, $PRD_Id$, $PCT_Type$, $PCT_Std$, $CUT_Id$,"
  ls_req = ls_req & "$PCT_SizeJ$, $PCT_SizeK$, $PCT_SizeD$, $PCT_SizeL$, $PCT_SizeM$, $PCT_PBord$,"
  ls_req = ls_req & "$PCT_UBorC$, $PCT_UBorD$, $PCT_UBorE$, $PCT_UBorF$,"
  ls_req = ls_req & "$PCT_UBoWC$, $PCT_UBoWD$, $PCT_UBoWE$, $PCT_UBoWF$, $PCT_Order$,"
  ls_req = ls_req & "$Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PCT_Id$", mo_Tools.SQLStr(ao_Cutout.PCT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Type$", mo_Tools.SqlInt(ao_Cutout.PCT_Type), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Std$", mo_Tools.SqlBool(ao_Cutout.PCT_Std), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CUT_Id$", mo_Tools.SqlStrKey(ao_Cutout.CUT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeJ$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeJ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeK$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeK), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeD$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeD), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeL$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeL), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_SizeM$", mo_Tools.SqlDbl(ao_Cutout.PCT_SizeM), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_PBord$", mo_Tools.SqlDbl(ao_Cutout.PCT_PBord), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PCT_Order$", mo_Tools.SqlInt(ao_Cutout.PCT_Order), , , vbTextCompare)
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    ls_req = Replace(ls_req, "$PCT_UBor" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(ao_Cutout.PCT_UBor(ll_SideIdx)), , , vbTextCompare)
    ls_req = Replace(ls_req, "$PCT_UBoW" & mv_Edge(ll_SideIdx) & "$", mo_Tools.SqlDbl(ao_Cutout.PCT_UBoW(ll_SideIdx)), , , vbTextCompare)
  Next
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdCutout")
End Sub

Private Sub DropPrdCutout(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdCutout", "DropPrdCutout"
  End If
  
  ls_req = "exec DPC_PrdCut_del $PCT_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PCT_Id$", mo_Tools.SQLStr(ao_Cutout.PCT_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdCutout")
End Sub

Private Sub InsertPrdInlay(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim ls_req As String

  ao_Inlay.PIN_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdInlay")
  
  ls_req = "exec DPC_PrdCommon_ins2 $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$, $PRD_CodeAMC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, NULL, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(ao_Inlay.PIN_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlInt(eDPCCategory.cgLinkedInlay), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(0), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(ao_Inlay.INL_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeAMC$", mo_Tools.SQLStr(ao_Inlay.PIN_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(eDPCErrorType.etNone), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  
  ls_req = "exec DPC_PrdInlay_ins1 $PIN_Id$, $PRD_Id$, $INL_Id$, $INL_Code$, $PIN_Code$, $PIN_Std$, $PIN_SizeA$, $PIN_SizeB$, $PIN_Purch$, $PIN_Deliv$, $PIN_Order$, $PIN_ExName$, $PIN_CE$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PIN_Id$", mo_Tools.SQLStr(ao_Inlay.PIN_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_Id$", mo_Tools.SqlStrKey(ao_Inlay.INL_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_Code$", mo_Tools.SQLStr(ao_Inlay.INL_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Code$", mo_Tools.SQLStr(ao_Inlay.PIN_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Std$", mo_Tools.SqlBool(ao_Inlay.PIN_Std), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_SizeA$", mo_Tools.SqlDbl(ao_Inlay.PIN_SizeA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_SizeB$", mo_Tools.SqlDbl(ao_Inlay.PIN_SizeB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Purch$", mo_Tools.SqlInt(ao_Inlay.PIN_Purch), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Deliv$", mo_Tools.SqlInt(ao_Inlay.PIN_Deliv), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Order$", mo_Tools.SqlInt(ao_Inlay.PIN_Order), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_ExName$", mo_Tools.SQLStr(ao_Inlay.PIN_ExName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_CE$", mo_Tools.SqlInt(ao_Inlay.PIN_CE), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdInlay")
End Sub

Private Sub UpdatePrdInlay(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdInlay_upd1 $PIN_Id$, $PRD_Id$, $INL_Id$, $INL_Code$, $PIN_Code$, $PIN_Std$, $PIN_SizeA$, $PIN_SizeB$, $PIN_Purch$, $PIN_Deliv$, $PIN_Order$, $PIN_ExName$, $PIN_CE$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PIN_Id$", mo_Tools.SQLStr(ao_Inlay.PIN_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_Id$", mo_Tools.SqlStrKey(ao_Inlay.INL_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$INL_Code$", mo_Tools.SQLStr(ao_Inlay.INL_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Code$", mo_Tools.SQLStr(ao_Inlay.PIN_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Std$", mo_Tools.SqlBool(ao_Inlay.PIN_Std), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_SizeA$", mo_Tools.SqlDbl(ao_Inlay.PIN_SizeA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_SizeB$", mo_Tools.SqlDbl(ao_Inlay.PIN_SizeB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Purch$", mo_Tools.SqlInt(ao_Inlay.PIN_Purch), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Deliv$", mo_Tools.SqlInt(ao_Inlay.PIN_Deliv), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_Order$", mo_Tools.SqlInt(ao_Inlay.PIN_Order), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_ExName$", mo_Tools.SQLStr(ao_Inlay.PIN_ExName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PIN_CE$", mo_Tools.SqlInt(ao_Inlay.PIN_CE), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdInlay")
End Sub

Private Sub DropPrdInlay(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdInlay", "DropPrdInlay"
  End If
  
  ls_req = "exec DPC_PrdInlay_del $PIN_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PIN_Id$", mo_Tools.SQLStr(ao_Inlay.PIN_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdInlay")
End Sub

'Private Sub InsertPrdOfferOption(ByVal ao_OfferPos As DPC_OfferPos)
'On Error GoTo ErrHandler
'
''Dim ls_req As String
''
''  ao_Option.POP_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdOption")
''
''  ls_req = "exec DPC_PrdOption_ins $POP_Id$, $PRD_Id$, $SYS_Id$, $OPT_Id$, $COF_Id$, $POP_Qty$, $POP_QMin$, $POP_QMax$,"
''  ls_req = ls_req & "$UM_Code$, $POP_Cost$, $CURR_Code$, $Z_Creator$"
''
''  ls_req = Replace(ls_req, "$POP_Id$", mo_Tools.SqlStr(ao_Option.POP_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStr(PRD_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(ao_Option.SYS_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$OPT_Id$", mo_Tools.SqlStrKey(ao_Option.OPT_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SqlStr(COF_Id), , , vbTextCompare)
''
''  ls_req = Replace(ls_req, "$POP_Qty$", mo_Tools.SqlDbl(ao_Option.POP_Qty), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_QMin$", mo_Tools.SqlDbl(ao_Option.POP_QMin), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_QMax$", mo_Tools.SqlDbl(ao_Option.POP_QMax), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_Cost$", mo_Tools.SqlDbl(ao_Option.POP_Cost), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$UM_Code$", mo_Tools.SqlStr(ao_Option.UM_CodeC), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SqlStr(ao_Option.CURR_Code), , , vbTextCompare)
''
''  ls_req = ReplaceCommonPlaceholders(ls_req)
''  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
'  ao_OfferPos.COF_Id = COF_Id
'  ao_OfferPos.OFD_Id = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
'  ao_OfferPos.OFD_IdPar = ao_OfferPos.OFD_Id
'  Call ao_OfferPos.Insert(mo_Db, ml_U_Code)
'  Exit Sub
'ErrHandler:
'  Call errorHandler("InsertPrdOfferOption")
'End Sub
'
'Private Sub UpdatePrdOfferOption(ByVal ao_OfferPos As DPC_OfferPos)
'On Error GoTo ErrHandler
'
''Dim ls_req As String
'
''  ls_req = "exec DPC_PrdOption_upd $POP_Id$, $PRD_Id$, $SYS_Id$, $OPT_Id$, $COF_Id$, $POP_Qty$, $POP_QMin$, $POP_QMax$,"
''  ls_req = ls_req & "$UM_Code$, $POP_Cost$, $CURR_Code$, $Z_Last_Upd_User$"
''
''  ls_req = Replace(ls_req, "$POP_Id$", mo_Tools.SqlStr(ao_Option.POP_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStr(PRD_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(ao_Option.SYS_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$OPT_Id$", mo_Tools.SqlStrKey(ao_Option.OPT_Id), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SqlStr(COF_Id), , , vbTextCompare)
''
''  ls_req = Replace(ls_req, "$POP_Qty$", mo_Tools.SqlDbl(ao_Option.POP_Qty), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_QMin$", mo_Tools.SqlDbl(ao_Option.POP_QMin), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_QMax$", mo_Tools.SqlDbl(ao_Option.POP_QMax), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$POP_Cost$", mo_Tools.SqlDbl(ao_Option.POP_Cost), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$UM_Code$", mo_Tools.SqlStr(ao_Option.UM_CodeC), , , vbTextCompare)
''  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SqlStr(ao_Option.CURR_Code), , , vbTextCompare)
''
''  ls_req = ReplaceCommonPlaceholders(ls_req)
''  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
'  Call ao_OfferPos.Update(mo_Db, ml_U_Code)
'  Exit Sub
'ErrHandler:
'  Call errorHandler("UpdatePrdOfferOption")
'End Sub
'
'Private Sub DropPrdOfferOption(ByVal ao_OfferPos As DPC_OfferPos)
'On Error GoTo ErrHandler
'
'Dim ls_req As String
'
'  If ao_OfferPos.RowStatus <> eDPCRowStatus.rsDrop Then
'    Err.Raise 0, "DropPrdOption", "DropPrdOption"
'  End If
'
'  Call ao_OfferPos.Drop(mo_Db, ml_U_Code)
''  ls_req = "exec DPC_PrdOption_del $POP_Id$, $Z_Last_Upd_User$"
''
''  ls_req = Replace(ls_req, "$POP_Id$", mo_Tools.SqlStr(ao_Option.POP_Id), , , vbTextCompare)
''  ls_req = ReplaceCommonPlaceholders(ls_req)
''  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
'  Exit Sub
'ErrHandler:
'  Call errorHandler("DropPrdOfferOption")
'End Sub

Private Sub InsertPrdFile(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler

Dim ls_req As String

  ao_File.PFI_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdFile")
  
  ls_req = "exec DPC_PrdFile_ins $PFI_Id$, $PRD_Id$, $FIL_Id$, $PFI_Order$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PFI_Id$", mo_Tools.SQLStr(ao_File.PFI_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$FIL_Id$", mo_Tools.SqlIntKey(ao_File.FIL_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PFI_Order$", mo_Tools.SqlInt(ao_File.PFI_Order), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdFile")
End Sub

Private Sub UpdatePrdFile(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdFile_upd $PFI_Id$, $PRD_Id$, $FIL_Id$, $PFI_Order$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PFI_Id$", mo_Tools.SQLStr(ao_File.PFI_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$FIL_Id$", mo_Tools.SqlIntKey(ao_File.FIL_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PFI_Order$", mo_Tools.SqlInt(ao_File.PFI_Order), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdFile")
End Sub

Private Sub DropPrdFile(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_File.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdFile", "DropPrdFile"
  End If
  
  ls_req = "exec DPC_PrdFile_del $PFI_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PFI_Id$", mo_Tools.SQLStr(ao_File.PFI_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdFile")
End Sub

Private Sub DeletePrdText()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_Text_del $PRD_Id$, $COF_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SqlStrKey(COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeletePrdText")
End Sub

Private Sub InsertPrdText(ByVal ao_Error As DPC_Error)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_Error.Tag Is Nothing Then
    If ao_Error.ERR_Offer Then
      ao_Error.TXT_Tag = COF_Id
    Else
      ao_Error.TXT_Tag = ""
    End If
  ElseIf TypeOf ao_Error.Tag Is DPC_Inlay Then
    ao_Error.TXT_Tag = ao_Error.Tag.PIN_Id
  ElseIf TypeOf ao_Error.Tag Is DPC_Cutout Then
    ao_Error.TXT_Tag = ao_Error.Tag.PCT_Id
  End If

  ls_req = "exec DPC_Text_ins $PRD_Id$, $ERR_Id$, $TXT_Tag$, $Language_Code$, $COF_Id$, $TXT_Text$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  If ao_Error.ERR_Offer Then
    ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SqlStrKey(COF_Id), , , vbTextCompare)
  Else
    ls_req = Replace(ls_req, "$COF_Id$", "NULL", , , vbTextCompare)
  End If
  ls_req = Replace(ls_req, "$ERR_Id$", mo_Tools.SqlIntKey(ao_Error.ERR_ID), , , vbTextCompare)
  ls_req = Replace(ls_req, "$TXT_Tag$", mo_Tools.SQLStr(ao_Error.TXT_Tag), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$TXT_Text$", mo_Tools.SQLStr(ao_Error.TXT_Text), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdText")
End Sub

Private Sub InsertBOM(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

Dim ls_req As String

  ao_BOM.BOM_Id = mo_Tools.GetNextID(mo_Db, "DPC_BOM")
  
  ls_req = "exec DPC_BOM_ins1 $BOM_Id$, $PRD_Id$, $BOM_StlIdentNr$, $BOM_Pos$, $BOM_BOR_Pos$, $BOM_Categ$, $BOM_IdentNr$, $BOM_Name$,$BOM_Material$,$BOM_SalesPriceUnit$,$BOM_SpecWeight$,"
  ls_req = ls_req & "$BOM_Productivity$, $BOM_CutLength$, $BOM_CutWidth$, $BOM_Qty$, $UM_Code$, $BOM_DirectCost$, $BOM_TotDirectCost$, $BOM_WasteFactor$, $BOM_WasteQty$, $BOM_WasteCost$,"
  ls_req = ls_req & "$BOM_RejectFactor$, $BOM_RejectQty$, $BOM_RejectCost$, $BOM_InflFactor$, $BOM_InflCost$, $BOM_Cost$, $CURR_Code$, $BOM_Status$, $BOM_Manual$, $BOM_IdentNrTmp$, $BOM_DatVon$, $BOM_Menge_Ab$,"
  ls_req = ls_req & "$Z_Creator$"
  
  ls_req = Replace(ls_req, "$BOM_Id$", mo_Tools.SqlIntKey(ao_BOM.BOM_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_StlIdentNr$", mo_Tools.SQLStr(ao_BOM.BOM_StlIdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Pos$", mo_Tools.SqlInt(ao_BOM.BOM_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_BOR_Pos$", mo_Tools.SqlInt(ao_BOM.BOM_BOR_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Categ$", mo_Tools.SqlInt(ao_BOM.BOM_Categ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNr$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Qty$", mo_Tools.SqlDbl(ao_BOM.BOM_Qty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Name$", mo_Tools.SQLStr(ao_BOM.BOM_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Material$", mo_Tools.SQLStr(ao_BOM.BOM_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_SalesPriceUnit$", mo_Tools.SqlDbl(ao_BOM.BOM_SalesPriceUnit), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_SpecWeight$", mo_Tools.SqlDbl(ao_BOM.BOM_SpecWeight), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Productivity$", mo_Tools.SqlDbl(ao_BOM.BOM_Productivity), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_CutLength$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_CutWidth$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Qty$", mo_Tools.SqlDbl(ao_BOM.BOM_Qty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_Code$", mo_Tools.SQLStr(ao_BOM.UM_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_DirectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_DirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_TotDirectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_TotDirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteQty$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteCost$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectQty$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_InflFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_InflFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_InflCost$", mo_Tools.SqlDbl(ao_BOM.BOM_InflCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Cost$", mo_Tools.SqlDbl(ao_BOM.BOM_Cost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(ao_BOM.CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Status$", mo_Tools.SqlInt(ao_BOM.BOM_Status), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Manual$", mo_Tools.SqlBool(ao_BOM.BOM_Manual), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNrTmp$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_DatVon$", mo_Tools.SqlDate(ao_BOM.BOM_DatVon), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Menge_Ab$", mo_Tools.SqlDbl(ao_BOM.BOM_Menge_Ab), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertBOM")
End Sub

Private Sub UpdateBOM(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_BOM_upd1 $BOM_Id$, $PRD_Id$, $BOM_StlIdentNr$, $BOM_Pos$, $BOM_BOR_Pos$, $BOM_Categ$, $BOM_IdentNr$, $BOM_Name$,$BOM_Material$,$BOM_SalesPriceUnit$,$BOM_SpecWeight$,"
  ls_req = ls_req & "$BOM_Productivity$, $BOM_CutLength$, $BOM_CutWidth$, $BOM_Qty$, $UM_Code$, $BOM_DirectCost$, $BOM_TotDirectCost$, $BOM_WasteFactor$, $BOM_WasteQty$, $BOM_WasteCost$,"
  ls_req = ls_req & "$BOM_RejectFactor$, $BOM_RejectQty$, $BOM_RejectCost$, $BOM_InflFactor$, $BOM_InflCost$, $BOM_Cost$, $CURR_Code$, $BOM_Status$, $BOM_Manual$, $BOM_IdentNrTmp$, $BOM_DatVon$, $BOM_Menge_Ab$,"
  ls_req = ls_req & "$Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$BOM_Id$", mo_Tools.SqlIntKey(ao_BOM.BOM_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_StlIdentNr$", mo_Tools.SQLStr(ao_BOM.BOM_StlIdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Pos$", mo_Tools.SqlInt(ao_BOM.BOM_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_BOR_Pos$", mo_Tools.SqlInt(ao_BOM.BOM_BOR_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Categ$", mo_Tools.SqlInt(ao_BOM.BOM_Categ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNr$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Qty$", mo_Tools.SqlDbl(ao_BOM.BOM_Qty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Name$", mo_Tools.SQLStr(ao_BOM.BOM_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Material$", mo_Tools.SQLStr(ao_BOM.BOM_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_SalesPriceUnit$", mo_Tools.SqlDbl(ao_BOM.BOM_SalesPriceUnit), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_SpecWeight$", mo_Tools.SqlDbl(ao_BOM.BOM_SpecWeight), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Productivity$", mo_Tools.SqlDbl(ao_BOM.BOM_Productivity), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_CutLength$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_CutWidth$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Qty$", mo_Tools.SqlDbl(ao_BOM.BOM_Qty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_Code$", mo_Tools.SQLStr(ao_BOM.UM_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_DirectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_DirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_TotDirectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_TotDirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteQty$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_WasteCost$", mo_Tools.SqlDbl(ao_BOM.BOM_WasteCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectQty$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectQty), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_RejectCost$", mo_Tools.SqlDbl(ao_BOM.BOM_RejectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_InflFactor$", mo_Tools.SqlDbl(ao_BOM.BOM_InflFactor), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_InflCost$", mo_Tools.SqlDbl(ao_BOM.BOM_InflCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Cost$", mo_Tools.SqlDbl(ao_BOM.BOM_Cost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(ao_BOM.CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Status$", mo_Tools.SqlInt(ao_BOM.BOM_Status), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Manual$", mo_Tools.SqlBool(ao_BOM.BOM_Manual), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNrTmp$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_DatVon$", mo_Tools.SqlDate(ao_BOM.BOM_DatVon), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Menge_Ab$", mo_Tools.SqlDbl(ao_BOM.BOM_Menge_Ab), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdateBOM")
End Sub

Public Function UpdateBOMExport(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrorHandler
  
Dim ls_req As String

  ls_req = "exec DPC_BOM_upd2 $BOM_Id$, $BOM_IdentNr$, $BOM_Name$, $BOM_Material$, $BOM_IdentNrTmp$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$BOM_Id$", mo_Tools.SqlIntKey(ao_BOM.BOM_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNr$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Name$", mo_Tools.SQLStr(ao_BOM.BOM_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Material$", mo_Tools.SQLStr(ao_BOM.BOM_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_IdentNrTmp$", mo_Tools.SQLStr(ao_BOM.BOM_IdentNrTmp), , , vbTextCompare)
  
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Function
ErrorHandler:
  Call ErrorHandler("UpdateBOMExport")
End Function

Private Sub DropBOM(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_BOM.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdBOM", "DropPrdBOM"
  End If
  
  ls_req = "exec DPC_BOM_del $PRD_Id$, $BOM_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOM_Id$", mo_Tools.SqlIntKey(ao_BOM.BOM_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropBOM")
End Sub

Private Sub InsertBOR(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

Dim ls_req As String

  ao_BOR.BOR_Id = mo_Tools.GetNextID(mo_Db, "DPC_BOR")
  
  ls_req = "exec DPC_BOR_ins $BOR_Id$, $PRD_Id$, $BOR_AplIdentnr$, $BOR_Pos$, $BOR_Categ$, $BOR_StAgNr$, $BOR_Agid$, $BOR_Name$, $BOR_KostSt$, $BOR_Mate$, $BOR_Te$, $BOR_Matr$, $BOR_Tr$,"
  ls_req = ls_req & "$BOR_BrTr$, $BOR_LgTr$, $BOR_Lgrp$, $BOR_La$, $BOR_ArbPlatz$, $BOR_Agbs$, $BOR_Konto$, $BOR_Agben_Fremd$, $BOR_Kurzben$, $BOR_Anz_Bedien$, $BOR_Genau$, $BOR_Mauez$, $BOR_Lhs$,"
  ls_req = ls_req & "$BOR_Mehrm$, $BOR_Trko$, $BOR_Teko$, $BOR_Frzeit$, $BOR_Mind_Gut$, $BOR_Kz_kannag$, $BOR_Agmenge$, $BOR_VarPerFact$, $BOR_VarMasFact$, $BOR_VarPerCost$,"
  ls_req = ls_req & "$BOR_VarMasCost$, $BOR_OutsrcCost$, $BOR_DirectCost$, $BOR_FixMasFact$, $BOR_FixMasCost$, $BOR_WasteFact$, $BOR_WasteCost$,"
  ls_req = ls_req & "$BOR_CostCalcMPE2$, $BOR_VarSetupFact$, $BOR_FixSetupFact$, $BOR_DirectSetupCost$, $BOR_SubtotalSetupCost$, $BOR_TotSetupCost$, $BOR_DirectWidSetupCost$,"
  ls_req = ls_req & "$BOR_SubtotalWidSetupCost$, $BOR_TotWidSetupCost$, $BOR_DirectLenSetupCost$, $BOR_SubtotalLenSetupCost$, $BOR_TotLenSetupCost$, $BOR_Cost$,"
  ls_req = ls_req & "$CURR_Code$, $BOR_Speed$, $BOR_Status$,$BOR_Manual$,$BOR_WghPnt$,"
  ls_req = ls_req & "$Z_Creator$"
  
  ls_req = Replace(ls_req, "$BOR_Id$", mo_Tools.SqlInt(ao_BOR.BOR_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_AplIdentnr$", mo_Tools.SQLStr(ao_BOR.BOR_AplIdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Pos$", mo_Tools.SqlInt(ao_BOR.BOR_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Categ$", mo_Tools.SqlInt(ao_BOR.BOR_Categ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_StAgNr$", mo_Tools.SQLStr(ao_BOR.BOR_StagNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agid$", mo_Tools.SqlInt(ao_BOR.BOR_AgId), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Name$", mo_Tools.SQLStr(ao_BOR.BOR_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_KostSt$", mo_Tools.SqlInt(ao_BOR.BOR_KostSt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mate$", mo_Tools.SQLStr(ao_BOR.BOR_Mate), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Te$", mo_Tools.SqlDbl(ao_BOR.BOR_Te), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Matr$", mo_Tools.SQLStr(ao_BOR.BOR_Matr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Tr$", mo_Tools.SqlDbl(ao_BOR.BOR_Tr), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_BrTr$", mo_Tools.SqlDbl(ao_BOR.BOR_Brtr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_LgTr$", mo_Tools.SqlDbl(ao_BOR.BOR_Lgtr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Lgrp$", mo_Tools.SqlInt(ao_BOR.BOR_Lgrp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_La$", mo_Tools.SqlInt(ao_BOR.BOR_La), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_ArbPlatz$", mo_Tools.SQLStr(ao_BOR.BOR_ArbPlatz), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agbs$", mo_Tools.SQLStr(ao_BOR.BOR_Agbs), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Konto$", mo_Tools.SqlInt(ao_BOR.BOR_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agben_Fremd$", mo_Tools.SQLStr(ao_BOR.BOR_Agben_Fremd), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Kurzben$", mo_Tools.SQLStr(ao_BOR.BOR_Kurzben), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Anz_Bedien$", mo_Tools.SqlInt(ao_BOR.BOR_Anz_Bedien), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Genau$", mo_Tools.SQLStr(ao_BOR.BOR_Genau), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mauez$", mo_Tools.SQLStr(ao_BOR.BOR_Mauez), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Lhs$", mo_Tools.SqlInt(ao_BOR.BOR_Lhs), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_Mehrm$", mo_Tools.SqlDbl(ao_BOR.BOR_Mehrm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Trko$", mo_Tools.SqlDbl(ao_BOR.BOR_Trko), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Teko$", mo_Tools.SqlDbl(ao_BOR.BOR_Teko), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Frzeit$", mo_Tools.SqlInt(ao_BOR.BOR_Frzeit), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mind_Gut$", mo_Tools.SqlDbl(ao_BOR.BOR_Mind_Gut), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Kz_kannag$", mo_Tools.SQLStr(ao_BOR.BOR_Kz_kannag), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agmenge$", mo_Tools.SqlDbl(ao_BOR.BOR_Agmenge), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarPerFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarPerFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarMasFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarMasFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarPerCost$", mo_Tools.SqlDbl(ao_BOR.BOR_VarPerCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_VarMasCost$", mo_Tools.SqlDbl(ao_BOR.BOR_VarMasCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_OutsrcCost$", mo_Tools.SqlDbl(ao_BOR.BOR_OutsrcCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixMasFact$", mo_Tools.SqlDbl(ao_BOR.BOR_FixMasFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixMasCost$", mo_Tools.SqlDbl(ao_BOR.BOR_FixMasCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WasteFact$", mo_Tools.SqlDbl(ao_BOR.BOR_WasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WasteCost$", mo_Tools.SqlDbl(ao_BOR.BOR_WasteCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_CostCalcMPE2$", mo_Tools.SqlDbl(ao_BOR.BOR_CostCalcMPE2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarSetupFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarSetupFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixSetupFact$", mo_Tools.SqlDbl(ao_BOR.BOR_FixSetupFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectLenSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalLenSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotLenSetupCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_Cost$", mo_Tools.SqlDbl(ao_BOR.BOR_Cost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(ao_BOR.CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Speed$", mo_Tools.SqlInt(ao_BOR.BOR_Speed), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Status$", mo_Tools.SqlInt(ao_BOR.BOR_Status), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Manual$", mo_Tools.SqlBool(ao_BOR.BOR_Manual), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WghPnt$", mo_Tools.SqlInt(ao_BOR.BOR_WghPnt), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertBOR")
End Sub

Private Sub UpdateBOR(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_BOR_upd $BOR_Id$, $PRD_Id$, $BOR_AplIdentnr$, $BOR_Pos$, $BOR_Categ$, $BOR_StAgNr$, $BOR_Agid$, $BOR_Name$, $BOR_KostSt$, $BOR_Mate$, $BOR_Te$, $BOR_Matr$, $BOR_Tr$,"
  ls_req = ls_req & "$BOR_BrTr$, $BOR_LgTr$, $BOR_Lgrp$, $BOR_La$, $BOR_ArbPlatz$, $BOR_Agbs$, $BOR_Konto$, $BOR_Agben_Fremd$, $BOR_Kurzben$, $BOR_Anz_Bedien$, $BOR_Genau$, $BOR_Mauez$, $BOR_Lhs$,"
  ls_req = ls_req & "$BOR_Mehrm$, $BOR_Trko$, $BOR_Teko$, $BOR_Frzeit$, $BOR_Mind_Gut$, $BOR_Kz_kannag$, $BOR_Agmenge$, $BOR_VarPerFact$, $BOR_VarMasFact$, $BOR_VarPerCost$,"
  ls_req = ls_req & "$BOR_VarMasCost$, $BOR_OutsrcCost$, $BOR_DirectCost$, $BOR_FixMasFact$, $BOR_FixMasCost$, $BOR_WasteFact$, $BOR_WasteCost$,"
  ls_req = ls_req & "$BOR_CostCalcMPE2$, $BOR_VarSetupFact$, $BOR_FixSetupFact$, $BOR_DirectSetupCost$, $BOR_SubtotalSetupCost$, $BOR_TotSetupCost$, $BOR_DirectWidSetupCost$,"
  ls_req = ls_req & "$BOR_SubtotalWidSetupCost$, $BOR_TotWidSetupCost$, $BOR_DirectLenSetupCost$, $BOR_SubtotalLenSetupCost$, $BOR_TotLenSetupCost$, $BOR_Cost$,"
  ls_req = ls_req & "$CURR_Code$, $BOR_Speed$, $BOR_Status$,$BOR_Manual$,$BOR_WghPnt$,"
  ls_req = ls_req & "$Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$BOR_Id$", mo_Tools.SqlInt(ao_BOR.BOR_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_AplIdentnr$", mo_Tools.SQLStr(ao_BOR.BOR_AplIdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Pos$", mo_Tools.SqlInt(ao_BOR.BOR_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Categ$", mo_Tools.SqlInt(ao_BOR.BOR_Categ), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_StAgNr$", mo_Tools.SQLStr(ao_BOR.BOR_StagNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agid$", mo_Tools.SqlInt(ao_BOR.BOR_AgId), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Name$", mo_Tools.SQLStr(ao_BOR.BOR_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_KostSt$", mo_Tools.SqlInt(ao_BOR.BOR_KostSt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mate$", mo_Tools.SQLStr(ao_BOR.BOR_Mate), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Te$", mo_Tools.SqlDbl(ao_BOR.BOR_Te), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Matr$", mo_Tools.SQLStr(ao_BOR.BOR_Matr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Tr$", mo_Tools.SqlDbl(ao_BOR.BOR_Tr), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_BrTr$", mo_Tools.SqlDbl(ao_BOR.BOR_Brtr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_LgTr$", mo_Tools.SqlDbl(ao_BOR.BOR_Lgtr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Lgrp$", mo_Tools.SqlInt(ao_BOR.BOR_Lgrp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_La$", mo_Tools.SqlInt(ao_BOR.BOR_La), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_ArbPlatz$", mo_Tools.SQLStr(ao_BOR.BOR_ArbPlatz), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agbs$", mo_Tools.SQLStr(ao_BOR.BOR_Agbs), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Konto$", mo_Tools.SqlInt(ao_BOR.BOR_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agben_Fremd$", mo_Tools.SQLStr(ao_BOR.BOR_Agben_Fremd), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Kurzben$", mo_Tools.SQLStr(ao_BOR.BOR_Kurzben), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Anz_Bedien$", mo_Tools.SqlInt(ao_BOR.BOR_Anz_Bedien), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Genau$", mo_Tools.SQLStr(ao_BOR.BOR_Genau), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mauez$", mo_Tools.SQLStr(ao_BOR.BOR_Mauez), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Lhs$", mo_Tools.SqlInt(ao_BOR.BOR_Lhs), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_Mehrm$", mo_Tools.SqlDbl(ao_BOR.BOR_Mehrm), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Trko$", mo_Tools.SqlDbl(ao_BOR.BOR_Trko), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Teko$", mo_Tools.SqlDbl(ao_BOR.BOR_Teko), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Frzeit$", mo_Tools.SqlInt(ao_BOR.BOR_Frzeit), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Mind_Gut$", mo_Tools.SqlDbl(ao_BOR.BOR_Mind_Gut), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Kz_kannag$", mo_Tools.SQLStr(ao_BOR.BOR_Kz_kannag), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Agmenge$", mo_Tools.SqlDbl(ao_BOR.BOR_Agmenge), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarPerFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarPerFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarMasFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarMasFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarPerCost$", mo_Tools.SqlDbl(ao_BOR.BOR_VarPerCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_VarMasCost$", mo_Tools.SqlDbl(ao_BOR.BOR_VarMasCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_OutsrcCost$", mo_Tools.SqlDbl(ao_BOR.BOR_OutsrcCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixMasFact$", mo_Tools.SqlDbl(ao_BOR.BOR_FixMasFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixMasCost$", mo_Tools.SqlDbl(ao_BOR.BOR_FixMasCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WasteFact$", mo_Tools.SqlDbl(ao_BOR.BOR_WasteFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WasteCost$", mo_Tools.SqlDbl(ao_BOR.BOR_WasteCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_CostCalcMPE2$", mo_Tools.SqlDbl(ao_BOR.BOR_CostCalcMPE2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_VarSetupFact$", mo_Tools.SqlDbl(ao_BOR.BOR_VarSetupFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_FixSetupFact$", mo_Tools.SqlDbl(ao_BOR.BOR_FixSetupFact), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotWidSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotWidSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_DirectLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_DirectLenSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_SubtotalLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_SubtotalLenSetupCost), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_TotLenSetupCost$", mo_Tools.SqlDbl(ao_BOR.BOR_TotLenSetupCost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$BOR_Cost$", mo_Tools.SqlDbl(ao_BOR.BOR_Cost), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(ao_BOR.CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Speed$", mo_Tools.SqlInt(ao_BOR.BOR_Speed), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Status$", mo_Tools.SqlInt(ao_BOR.BOR_Status), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Manual$", mo_Tools.SqlBool(ao_BOR.BOR_Manual), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_WghPnt$", mo_Tools.SqlInt(ao_BOR.BOR_WghPnt), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdateBOR")
End Sub

Private Sub DropBOR(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_BOR.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdBOR", "DropPrdBOR"
  End If
  
  ls_req = "exec DPC_BOR_del $PRD_Id$, $BOR_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BOR_Id$", mo_Tools.SqlIntKey(ao_BOR.BOR_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropBOR")
End Sub

Public Sub DeleteBOM()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_BOM_del $PRD_Id$, NULL, $Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id))
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Call mo_Tools.ClearCollection(BOMs)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeleteBOM")
End Sub

Public Sub DeleteBOR()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_BOR_del $PRD_Id$, NULL, $Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id))
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Call mo_Tools.ClearCollection(BORs)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeleteBOR")
End Sub

Private Sub ResetCoilW()
On Error GoTo ErrHandler

  If (RPL_CustDim And eDPCCoilLock.clCoilWidth) = 0 Then
    If mo_TempProduct Is Nothing Then
      RPL_CoilW = ParentRPL_CoilW
    Else
      RPL_CoilW = mo_TempProduct.RPL_CoilW
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetCoilW")
End Sub

Private Sub ResetBendingUZA()
On Error GoTo ErrHandler

  If (RPL_CustDim And eDPCCoilLock.clBendingUZA) = 0 Then
    RPL_U(eDPCSide.esSideC) = 0
    RPL_U(eDPCSide.esSideD) = 0
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetBendingUZA")
End Sub

Public Sub ClearCoilCalculation()
On Error GoTo ErrHandler

'Dim ls_req As String
'Dim lc_Cursor As Long

  If Not IsStandard Then
    
    Call ResetBendingUZA
    Call ResetCoilW
    Call CalculateCoWMinMax
    Call CalculateCutAB
    
'    If (RPL_CustDim And eDPCCoilLock.clCutAB) = 0 Then
'      RPL_CutA = 0
'      RPL_CutB = 0
'    End If
'
'    If PRD_IdPar <> "" Then
'      ls_req = "SELECT RPL_CoWMin, RPL_CoWMax, RPL_CoilW, RPL_CutA, RPL_CutB FROM DPC_RectPanel WHERE RPL_Id=$RPL_Id$"
'      ls_req = Replace(ls_req, "$RPL_Id$", mo_Tools.SQLStr(PRD_IdPar), , , vbTextCompare)
'      lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
'
'      If ((mo_Db.GetFields(lc_Cursor, "RPL_CoWMin") > 0) And (mo_Db.GetFields(lc_Cursor, "RPL_CoWMax") > 0)) And ((RPL_CustDim And eDPCCoilLock.clCoilMinMax) = 0) Then
'        RPL_CoWMin = mo_Db.GetFields(lc_Cursor, "RPL_CoWMin")
'        RPL_CoWMax = mo_Db.GetFields(lc_Cursor, "RPL_CoWMax")
'      End If
'
'      If (mo_Db.GetFields(lc_Cursor, "RPL_CoilW") > 0) And ((RPL_CustDim And eDPCCoilLock.clCoilWidth) = 0) Then
'        RPL_CoilW = mo_Db.GetFields(lc_Cursor, "RPL_CoilW")
'      End If
'
'      If (mo_Db.GetFields(lc_Cursor, "RPL_CutA") > 0) And (mo_Db.GetFields(lc_Cursor, "RPL_CutB") > 0) And ((RPL_CustDim And eDPCCoilLock.clCutAB) = 0) Then
'        RPL_CutA = mo_Db.GetFields(lc_Cursor, "RPL_CutA")
'        RPL_CutB = mo_Db.GetFields(lc_Cursor, "RPL_CutB")
'      End If
'      Call mo_Db.Close(lc_Cursor)
'    End If
  End If
  RPL_MatTyp = ""
  MAT_Prefx = ""
  MAT_OrdQty = 0
  MAT_WiStep = 0
  MAT_MaxCut = 0
  MAT_CoilTypeIdx = -1
  COI_SpcWgh = 0
  COI_WasteFact = 0
  COI_WasteQty = 0
  COI_Code = ""
  COI_CodeTmp = ""
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearCoilCalculation")
End Sub

Public Sub ClearInlayCalculation()
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay

  For Each lo_Inlay In Inlays
    lo_Inlay.INL_IdentNr = ""
    lo_Inlay.INL_IdentNrTmp = ""
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearInlayCalculation")
End Sub

Public Sub ClearPackingCalculation()
On Error GoTo ErrHandler

  If Not IsStandard Then
    RPL_PU = 0
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearPackingCalculation")
End Sub

Public Sub ClearGroupCEWghPnt()
On Error GoTo ErrHandler

  RPL_PGroup = ""
  RPL_MGroup = 0
  RPL_OGroup = ""
  RPL_AGroup = 0
  RPL_WghPnt = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearGroupCEWghPnt")
End Sub

Public Sub DeleteBOMBOR()
On Error GoTo ErrHandler

  Call DeleteBOM
  Call DeleteBOR
  Call DeleteCostCalculation
  Call ClearCoilCalculation
  Call ClearInlayCalculation
  Call ClearPackingCalculation
  Call ClearGroupCEWghPnt
  Call UpdatePrdRectPanel
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeleteBOMBOR")
End Sub

Public Function FindBOR(ByVal as_CostCentre As String) As DPC_BOR
On Error GoTo ErrHandler

Dim lsa_CostCentre() As String
Dim ll_Idx As Long
Dim lo_BOR  As DPC_BOR
Dim lo_LinkBOR As DPC_BOR
Dim lo_LastBOR As DPC_BOR
    
  Set lo_LinkBOR = Nothing
  Set lo_LastBOR = Nothing
  lsa_CostCentre = Split(as_CostCentre, ",")
  For Each lo_BOR In BORs
    For ll_Idx = 0 To UBound(lsa_CostCentre)
      If Val(lsa_CostCentre(ll_Idx)) = lo_BOR.BOR_KostSt Then
        Set lo_LinkBOR = lo_BOR
        Exit For
      End If
    Next
    If Not lo_LinkBOR Is Nothing Then
      Exit For
    End If
    Set lo_LastBOR = lo_BOR
  Next
  If lo_LinkBOR Is Nothing Then
    Set FindBOR = lo_LastBOR
  Else
    Set FindBOR = lo_LinkBOR
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("FindBOR")
End Function

Public Function CrossLinkBOMBOR() As Boolean
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim lo_BOR As DPC_BOR
Dim ls_req As String
Dim lc_Cursor As Long

  CrossLinkBOMBOR = True
  ls_req = "exec DPC_RawMaterial_lst $Language_Code$"
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  For Each lo_BOM In BOMs
    If mo_Db.Find(lc_Cursor, "RWM_Id", lo_BOM.BOM_Categ) >= 0 Then
      Set lo_BOR = FindBOR(mo_Db.GetFields(lc_Cursor, "RWM_BOR_Pos"))
      If lo_BOR Is Nothing Then
        lo_BOM.BOM_BOR_Pos = 0
      Else
        lo_BOM.BOM_BOR_Pos = lo_BOR.BOR_Pos
      End If
    Else
      CrossLinkBOMBOR = False
    End If
  Next
  Call mo_Db.Close(lc_Cursor)
  Set lo_BOM = Nothing
  Set lo_BOR = Nothing
  Exit Function
ErrHandler:
  Call ErrorHandler("CrossLinkBOMBOR")
End Function

Private Function GetCategory(ByVal al_DOF_Id As Long) As eDPCCategory
On Error GoTo ErrHandler
    
    GetCategory = eDPCCategory.cgNone
    If mo_Db.Find(mc_OfferTemplate, "DOF_Id", al_DOF_Id) >= 0 Then
      GetCategory = mo_Db.GetFields(mc_OfferTemplate, "CAT_Id")
    End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCategory")
End Function

Public Function GetCutout(ByVal al_Idx As Long) As DPC_Cutout
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout

  Set GetCutout = Nothing
  For Each lo_Cutout In Cutouts
    If lo_Cutout.Idx = al_Idx Then
      Set GetCutout = lo_Cutout
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutout")
End Function

Public Function GetCutoutByIndex(ByVal al_Index As Long) As DPC_Cutout
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Counter As Long

  If GetAnyCutoutCount > al_Index Then
    ll_Counter = 0
    For Each lo_Cutout In Cutouts
      If lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop Then
        If ll_Counter = al_Index Then
'          Call CutoutUpdate(lo_Cutout)
          Set GetCutoutByIndex = lo_Cutout
          Exit Function
        End If
        ll_Counter = ll_Counter + 1
      End If
    Next
    Set lo_Cutout = Nothing
  Else
    Set lo_Cutout = Nothing
  End If
  Set GetCutoutByIndex = lo_Cutout
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutoutByIndex")
End Function

Public Function GetInlayByIndex(ByVal al_Index As Long) As DPC_Inlay
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay
Dim ll_Counter As Long

  If GetInlayCount > al_Index Then
    ll_Counter = 0
    For Each lo_Inlay In Inlays
      If lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop Then
        If ll_Counter = al_Index Then
          Set GetInlayByIndex = lo_Inlay
          Exit Function
        End If
        ll_Counter = ll_Counter + 1
      End If
    Next
    Set lo_Inlay = Nothing
  Else
    Set lo_Inlay = Nothing
  End If
  Set GetInlayByIndex = lo_Inlay
  Exit Function
ErrHandler:
  Call ErrorHandler("GetInlayByIndex")
End Function

Public Function GetBOM(ByVal al_Idx As Long) As DPC_BOM
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM

  Set GetBOM = Nothing
  For Each lo_BOM In BOMs
    If lo_BOM.Idx = al_Idx Then
      Set GetBOM = lo_BOM
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOM")
End Function

Public Sub BOMAdd(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

  ao_BOM.RowStatus = eDPCRowStatus.rsAdd
  Call BOMs.Add(ao_BOM)
  Exit Sub
ErrHandler:
  Call ErrorHandler("BOMAdd")
End Sub

Public Sub BOMUpdate(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler
  
  If ao_BOM.RowStatus = eDPCRowStatus.rsNone Then
    ao_BOM.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("BOMUpdate")
End Sub

Public Sub BOMDrop(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_BOM As DPC_BOM

  For ll_Idx = 1 To BOMs.Count
    Set lo_BOM = BOMs(ll_Idx)
    If lo_BOM.Idx = ao_BOM.Idx Then
      If lo_BOM.RowStatus = eDPCRowStatus.rsAdd Then
        Call BOMs.Remove(ll_Idx)
      Else
        lo_BOM.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("BOMDrop")
End Sub

Public Function GetBOR(ByVal al_Idx As Long) As DPC_BOR
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR

  Set GetBOR = Nothing
  For Each lo_BOR In BORs
    If lo_BOR.Idx = al_Idx Then
      Set GetBOR = lo_BOR
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOR")
End Function

Public Sub BORAdd(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

  ao_BOR.RowStatus = eDPCRowStatus.rsAdd
  Call BORs.Add(ao_BOR)
  Exit Sub
ErrHandler:
  Call ErrorHandler("BORAdd")
End Sub

Public Sub BORUpdate(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler
  
  If ao_BOR.RowStatus = eDPCRowStatus.rsNone Then
    ao_BOR.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("BORUpdate")
End Sub

Public Sub BORDrop(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_BOR As DPC_BOR

  For ll_Idx = 1 To BORs.Count
    Set lo_BOR = BORs(ll_Idx)
    If lo_BOR.Idx = ao_BOR.Idx Then
      If lo_BOR.RowStatus = eDPCRowStatus.rsAdd Then
        Call BORs.Remove(ll_Idx)
      Else
        lo_BOR.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("BORDrop")
End Sub

Public Function HasBOMError() As Boolean
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
  
  HasBOMError = False
  For Each lo_BOM In BOMs
    If (lo_BOM.RowStatus <> eDPCRowStatus.rsDrop) And (lo_BOM.BOM_Status <> eDPCBOMBORStatus.boGeneratedOK) Then
      HasBOMError = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasBOMError")
End Function

Public Function IsBOMChanged() As Boolean
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
  
  IsBOMChanged = False
  For Each lo_BOM In BOMs
    If (lo_BOM.RowStatus <> eDPCRowStatus.rsNone) Then
      IsBOMChanged = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("IsBOMChanged")
End Function

Public Function HasBORError() As Boolean
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
  
  HasBORError = False
  For Each lo_BOR In BORs
    If (lo_BOR.RowStatus <> eDPCRowStatus.rsDrop) And (lo_BOR.BOR_Status <> eDPCBOMBORStatus.boGeneratedOK) Then
      HasBORError = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasBORError")
End Function

Public Function IsBORChanged() As Boolean
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
  
  IsBORChanged = False
  For Each lo_BOR In BORs
    If (lo_BOR.RowStatus <> eDPCRowStatus.rsNone) Then
      IsBORChanged = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("IsBORChanged")
End Function

Public Function HasAnyCutoutShape(ByVal ae_CutoutShape As eDPCCutoutShape) As Boolean
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout

  HasAnyCutoutShape = False
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) And (lo_Cutout.CUT_Shape = ae_CutoutShape) Then
      HasAnyCutoutShape = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasAnyCutoutShape")
End Function

Public Function GetAnyCutoutCount() As Long
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Count As Long

  ll_Count = 0
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetAnyCutoutCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetAnyCutoutCount")
End Function

Public Function GetVentilationCount() As Long
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Count As Long

  ll_Count = 0
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) And (lo_Cutout.PCT_Type = eDPCCutoutType.eVentilation) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetVentilationCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetVentilationCount")
End Function

Public Function GetLoudspeakerCount() As Long
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Count As Long

  ll_Count = 0
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) And (lo_Cutout.PCT_Type = eDPCCutoutType.eLoudspeaker) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetLoudspeakerCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetLoudspeakerCount")
End Function

Public Function GetCutoutCount() As Long
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Count As Long

  ll_Count = 0
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) And (lo_Cutout.PCT_Type = eDPCCutoutType.eCutout) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetCutoutCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutoutCount")
End Function

Public Function GetCutoutMinOutEdge() As Double
On Error GoTo ErrHandler

Dim lo_Cutout As DPC_Cutout
Dim ll_Count As Long
Dim ld_CutMinOutEdge As Double

  ll_Count = 0
  ld_CutMinOutEdge = 99999
  For Each lo_Cutout In Cutouts
    If (lo_Cutout.RowStatus <> eDPCRowStatus.rsDrop) And (lo_Cutout.PCT_Type = eDPCCutoutType.eCutout) Then
      If ld_CutMinOutEdge > lo_Cutout.PCT_SizeL Then ld_CutMinOutEdge = lo_Cutout.PCT_SizeL
      If ld_CutMinOutEdge > lo_Cutout.PCT_SizeM Then ld_CutMinOutEdge = lo_Cutout.PCT_SizeM
    End If
  Next
  GetCutoutMinOutEdge = ld_CutMinOutEdge
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCutoutMinOutEdge")
End Function

Public Sub CutoutAdd(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

  ao_Cutout.RowStatus = eDPCRowStatus.rsAdd
  Call Cutouts.Add(ao_Cutout)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CutoutAdd")
End Sub

Public Sub CutoutUpdate(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler
  
  If ao_Cutout.RowStatus = eDPCRowStatus.rsNone Then
    ao_Cutout.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CutoutUpdate")
End Sub

Public Sub CutoutDrop(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Cutout As DPC_Cutout

  For ll_Idx = 1 To Cutouts.Count
    Set lo_Cutout = Cutouts(ll_Idx)
    If lo_Cutout.Idx = ao_Cutout.Idx Then
      If lo_Cutout.RowStatus = eDPCRowStatus.rsAdd Then
        Call Cutouts.Remove(ll_Idx)
      Else
        lo_Cutout.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CutoutDrop")
End Sub

Public Function GetInlay(ByVal al_InlayIdx As Long) As DPC_Inlay
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Inlay As DPC_Inlay

  Set GetInlay = Nothing
  For Each lo_Inlay In Inlays
    If lo_Inlay.Idx = al_InlayIdx Then
      Set GetInlay = lo_Inlay
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetInlay")
End Function

Public Function GetOfferOption(ByVal as_OPT_Id As String) As DPC_OfferPos
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Offer As DPC_OfferPos

  Set GetOfferOption = Nothing
  For Each lo_Offer In OfferOptions
    If lo_Offer.PRD_Id = as_OPT_Id Then
      Set GetOfferOption = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferOption")
End Function

Public Function GetFile(ByVal al_Idx_Id As Long) As DPC_File
On Error GoTo ErrHandler

Dim lo_DPC_File As DPC_File

  Set GetFile = Nothing
  For Each lo_DPC_File In Files
    If lo_DPC_File.Idx = al_Idx_Id Then
      Set GetFile = lo_DPC_File
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetFile")
End Function

Public Sub InlayAdd(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

  ao_Inlay.RowStatus = eDPCRowStatus.rsAdd
  Call Inlays.Add(ao_Inlay)
  If ao_Inlay.INL_IsCus Then
    Call SetErrorText(eDPCError.erInlayName, ao_Inlay.INL_Name, ao_Inlay)
    Call SetErrorText(eDPCError.erInlayDesc, ao_Inlay.INL_Desc, ao_Inlay)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InlayAdd")
End Sub

Public Sub InlayUpdate(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler
  
  If ao_Inlay.RowStatus = eDPCRowStatus.rsNone Then
    ao_Inlay.RowStatus = eDPCRowStatus.rsUpdate
  End If
  If ao_Inlay.INL_IsCus Then
    Call SetErrorText(eDPCError.erInlayName, ao_Inlay.INL_Name, ao_Inlay)
    Call SetErrorText(eDPCError.erInlayDesc, ao_Inlay.INL_Desc, ao_Inlay)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InlayUpdate")
End Sub

Public Sub InlayDrop(ByVal ao_Inlay As DPC_Inlay)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Inlay As DPC_Inlay

  For ll_Idx = 1 To Inlays.Count
    Set lo_Inlay = Inlays(ll_Idx)
    If lo_Inlay.Idx = ao_Inlay.Idx Then
      If lo_Inlay.RowStatus = eDPCRowStatus.rsAdd Then
        Call Inlays.Remove(ll_Idx)
      Else
        lo_Inlay.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit For
    End If
  Next
  If ao_Inlay.INL_IsCus Then
    Call RemoveError(eDPCError.erInlayName, ao_Inlay)
    Call RemoveError(eDPCError.erInlayDesc, ao_Inlay)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InlayDrop")
End Sub

Public Function GetInlayCount() As Long
On Error GoTo ErrHandler

Dim lo_Inlay As DPC_Inlay
Dim ll_Count As Long

  ll_Count = 0
  For Each lo_Inlay In Inlays
    If (lo_Inlay.RowStatus <> eDPCRowStatus.rsDrop) Then
      ll_Count = ll_Count + 1
    End If
  Next
  GetInlayCount = ll_Count
  Exit Function
ErrHandler:
  Call ErrorHandler("GetInlayCount")
End Function

Public Sub OfferOptionAdd(ByVal ao_OfferPos As DPC_OfferPos)
On Error GoTo ErrHandler

  ao_OfferPos.RowStatus = eDPCRowStatus.rsAdd
  ao_OfferPos.COF_Id = COF_Id
  ao_OfferPos.OFD_Type = eDPCPriceBookType.eCustomMetal
  ao_OfferPos.CAT_Id = eDPCCategory.cgOption
  ao_OfferPos.DOF_Id = eDPCOfferDetail.odOption
  ao_OfferPos.OFD_Main = eDPCOfferDetailMain.odMain
  ao_OfferPos.OFD_IsAlt = eDPCOfferDetailIsAlt.maOption
  ao_OfferPos.OFD_Valid = True
  ao_OfferPos.OFD_Found = 1
  ao_OfferPos.LEV_Id = eDPCLevel.lvCustom
  ao_OfferPos.OFD_Pos = 0
  ao_OfferPos.OFD_Order = 0
  ao_OfferPos.OFD_HasPrice = True
  ao_OfferPos.OFD_HasTotal = True
  ao_OfferPos.OFD_HasQty = True
  Call OfferOptions.Add(ao_OfferPos)
  Exit Sub
ErrHandler:
  Call ErrorHandler("OfferOptionAdd")
End Sub

Public Sub OfferOptionUpdate(ByVal ao_OfferPos As DPC_OfferPos)
On Error GoTo ErrHandler
  
  If (ao_OfferPos.RowStatus = eDPCRowStatus.rsNone) Or (ao_OfferPos.RowStatus = eDPCRowStatus.rsDrop) Then
    ao_OfferPos.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("OfferOptionUpdate")
End Sub

Public Sub OfferOptionDrop(ByVal ao_OfferPos As DPC_OfferPos)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_OfferPos As DPC_OfferPos

  For ll_Idx = 1 To OfferOptions.Count
    Set lo_OfferPos = OfferOptions(ll_Idx)
    If ao_OfferPos.PRD_Id = lo_OfferPos.PRD_Id Then
      If lo_OfferPos.RowStatus = eDPCRowStatus.rsAdd Then
        Call OfferOptions.Remove(ll_Idx)
      Else
        lo_OfferPos.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("OfferOptionDrop")
End Sub

Public Sub FileAdd(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler

  ao_File.RowStatus = eDPCRowStatus.rsAdd
  Call Files.Add(ao_File)
  Exit Sub
ErrHandler:
  Call ErrorHandler("FileAdd")
End Sub

Public Sub FileUpdate(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler
  
  If ao_File.RowStatus = eDPCRowStatus.rsNone Then
    ao_File.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("FileUpdate")
End Sub

Public Sub FileDrop(ByVal ao_File As DPC_File)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_File As DPC_File

  For ll_Idx = 1 To Files.Count
    Set lo_File = Files(ll_Idx)
    If lo_File.Idx = ao_File.Idx Then
      If lo_File.RowStatus = eDPCRowStatus.rsAdd Then
        Call Files.Remove(ll_Idx)
      Else
        lo_File.RowStatus = eDPCRowStatus.rsDrop
      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("FileDrop")
End Sub

Private Function CheckGroupOperator(ByVal al_GPP_Id As Long, ByRef asa_ParamValue() As String, ByVal as_DataType As String, ByVal ae_Operator As eDPCGroupParamOperator, ByVal as_Value As String) As Boolean
On Error GoTo ErrHandler

Dim ll_Idx As Long

  If ae_Operator <> eDPCGroupParamOperator.gtIn Then
    If UBound(asa_ParamValue) <> 0 Then
      Err.Raise ArmErr.InvalidArgument, "asa_ParamValue()", "Invalid param/operator combination: " & al_GPP_Id
    End If
  End If
  CheckGroupOperator = False
  Select Case ae_Operator
  Case eDPCGroupParamOperator.goEqual
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) = 0
  Case eDPCGroupParamOperator.gtNotEqual
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) <> 0
  Case eDPCGroupParamOperator.gtGreaterEqual
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) >= 0
  Case eDPCGroupParamOperator.gtGreater
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) > 0
  Case eDPCGroupParamOperator.gtLessEqual
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) <= 0
  Case eDPCGroupParamOperator.gtLess
    CheckGroupOperator = StrComp(asa_ParamValue(0), as_Value, vbBinaryCompare) < 0
  Case eDPCGroupParamOperator.gtIn
    as_Value = "," & as_Value & ","
    For ll_Idx = 0 To UBound(asa_ParamValue)
      If InStr(1, as_Value, "," & asa_ParamValue(ll_Idx) & ",", vbTextCompare) > 0 Then
        CheckGroupOperator = True
        Exit Function
      End If
    Next
  Case Else
    Err.Raise ArmErr.InvalidArgument, "as_Operator", "Unknown operator: " & ae_Operator & " GPP_Id: " & al_GPP_Id
  End Select
  Exit Function
ErrHandler:
  Call ErrorHandler("CheckGroupOperator")
End Function

Private Function CheckGroupCondition(ByVal ac_Cursor As Long, ByVal al_Idx As Long) As Boolean
On Error GoTo ErrHandler

  Dim ls_Param As String, ls_DataType As String, ls_value As String
  Dim lb_Result As Boolean
  Dim lsa_ParamValue() As String
  Dim ll_Idx As Long, al_GPP_Id As Long
  Dim le_Operator As eDPCGroupParamOperator
  
  ls_Param = Trim(mo_Db.GetFields(ac_Cursor, "PAR_Id" & al_Idx))
  ls_DataType = Trim(mo_Db.GetFields(ac_Cursor, "PAR_DataType" & al_Idx))
  le_Operator = mo_Db.GetFields(ac_Cursor, "GPP_Operator" & al_Idx)
  ls_value = mo_Db.GetFields(ac_Cursor, "GPP_Value" & al_Idx)
  al_GPP_Id = mo_Db.GetFields(ac_Cursor, "GPP_Id")
  
  ReDim lsa_ParamValue(0)
  If ls_Param = "" Then
    CheckGroupCondition = True
    Exit Function
  ElseIf StrComp(ls_Param, "Level", vbTextCompare) = 0 Then
    lsa_ParamValue(0) = LEV_Id
  ElseIf StrComp(ls_Param, "ProdGroup", vbTextCompare) = 0 Then
    lsa_ParamValue(0) = RPL_PGroup
  ElseIf StrComp(ls_Param, "PerfClass", vbTextCompare) = 0 Then
    lsa_ParamValue(0) = PRF_Class
  ElseIf StrComp(ls_Param, "BOR_KostSt", vbTextCompare) = 0 Then
    If BORs.Count = 0 Then
      ReDim lsa_ParamValue(-1 To -1)
    Else
      ReDim lsa_ParamValue(BORs.Count - 1)
      For ll_Idx = 0 To BORs.Count - 1
        lsa_ParamValue(ll_Idx) = BORs(ll_Idx + 1).BOR_KostSt
      Next
    End If
  Else
    Err.Raise ArmErr.InvalidArgument, "ls_Param", "Unknown parameter: " & ls_Param
  End If
  CheckGroupCondition = CheckGroupOperator(al_GPP_Id, lsa_ParamValue, ls_DataType, le_Operator, ls_value)
  Exit Function
ErrHandler:
  Call ErrorHandler("CheckGroupCondition")
End Function

Private Function GetGroup(ByVal ae_GroupType As eDPCGroupType, ByVal ac_Cursor As Long) As String
On Error GoTo ErrHandler

Dim ls_Group As String
Dim lc_Cursor As Long
Dim ll_Idx As Long
Dim lb_Found As Boolean

  Select Case ae_GroupType
  Case eDPCGroupType.gtArticleGroup
  Case eDPCGroupType.gtGoodsGroup
  Case eDPCGroupType.gtProductGroup
  Case eDPCGroupType.gtObjectGroup
  Case Else
    Err.Raise ArmErr.InvalidArgument, "ae_GroupType", "Unknown ae_GroupType=" & ae_GroupType
  End Select
  
  lc_Cursor = mo_Db.Filter(ac_Cursor, "GRP_Type", "=", ae_GroupType)
  mo_Db.SortFields(lc_Cursor) = Array("GRP_Priority", "GPP_Order")
  ls_Group = ""
  Call mo_Db.First(lc_Cursor)
  Do While Not mo_Db.EOF(lc_Cursor)
    lb_Found = True
    For ll_Idx = 0 To 9
      If Not CheckGroupCondition(lc_Cursor, ll_Idx) Then
        lb_Found = False
        Exit For
      End If
    Next
    If lb_Found Then
      ls_Group = mo_Db.GetFields(lc_Cursor, "GRP_Group")
      Exit Do
    End If
    Call mo_Db.Next(lc_Cursor)
  Loop
  Call mo_Db.Close(lc_Cursor)
  GetGroup = ls_Group
  Exit Function
ErrHandler:
  Call ErrorHandler("GetGroup")
End Function

Public Function CalculateWeightPoints(ByVal ao_ErrCol As Collection) As Boolean
On Error GoTo ErrHandler

Dim ll_WeightPoints As Long
Dim lo_BOR As DPC_BOR

  ll_WeightPoints = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then
      ll_WeightPoints = ll_WeightPoints + lo_BOR.BOR_WghPnt
    End If
  Next
  If ll_WeightPoints = 0 Then
    Call AddCheckError(eDPCError.erWghPointsZero, ao_ErrCol)
  End If
  RPL_WghPnt = ll_WeightPoints
  Exit Function
ErrHandler:
  Call ErrorHandler("CalculateWeightPoints")
End Function

Public Function CalculateCEValues(ByVal ao_ErrCol As Collection) As Boolean
On Error GoTo ErrHandler

Dim lo_CEBE As DPC_CEBE
Dim ll_INL_CE As Long
Dim lo_Inlay As DPC_Inlay

  CLS_Id1 = 0
  CLS_Id2 = 0
  CLS_Id3 = 0
  CLS_Id4 = 0
  CLS_Id5 = 0
  CLS_Id6 = 0
  CLS_Id7 = 0
  CLS_Id8 = 0
  Set lo_CEBE = New DPC_CEBE
  lo_CEBE.ProductCategory = 1
  lo_CEBE.Material = MAT_CE
  lo_CEBE.Coated = RPL_CoSid
  lo_CEBE.Surface = COA_CE
  lo_CEBE.Perforated = IIf(HasPerforation, 1, 0)
  lo_CEBE.Perforation = Replace(PRF_Name, " ", "")
  lo_CEBE.Holediameter = IIf(PRF_HoleA > PRF_HoleB, PRF_HoleA, PRF_HoleB)
  lo_CEBE.DammingMaterial = 0
  For Each lo_Inlay In Inlays
    If lo_Inlay.PIN_CE > lo_CEBE.DammingMaterial Then
      lo_CEBE.DammingMaterial = lo_Inlay.PIN_CE
    End If
  Next
  lo_CEBE.Jointstrip = IIf(HasGasket, 1, 0)
  lo_CEBE.IdentNr = IIf(IsStandard, 1, 2)
  If lo_CEBE.MAINCE Then
    CLS_Name1 = lo_CEBE.CENumber
    CLS_Name2 = lo_CEBE.PrfzertifikatsNummer
    CLS_Name3 = lo_CEBE.Produkttyp
    CLS_Name4 = lo_CEBE.Leistungserklrung
    CLS_Name5 = lo_CEBE.Schallabsorption
    CLS_Name6 = lo_CEBE.Wrmeleitfhigkeit
    CLS_Name7 = lo_CEBE.Haltbarkeit
    CLS_Name8 = lo_CEBE.Emission
    CalculateCEValues = True
  Else
    CLS_Name1 = ""
    CLS_Name2 = ""
    CLS_Name3 = ""
    CLS_Name4 = ""
    CLS_Name5 = ""
    CLS_Name6 = ""
    CLS_Name7 = ""
    CLS_Name8 = ""
    Call mo_Tools.AddCheckError(eDPCError.erCEValueError, ms_Language_Code, ao_ErrCol, Me, , "$CEError$", lo_CEBE.CEError)
    CalculateCEValues = False
  End If
  Set lo_CEBE = Nothing
  Exit Function
ErrHandler:
  Call ErrorHandler("CalculateCEValues")
End Function

Public Function CalculateGroup(ByVal ao_ErrCol As Collection) As Boolean
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
  
  ls_req = "exec DPC_GroupParam_lst $SYS_Id$,$Language_Code$"

  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  RPL_PGroup = GetGroup(eDPCGroupType.gtProductGroup, lc_Cursor)
  If RPL_PGroup = "" Then
    Call AddCheckError(eDPCError.erGroupProductUnknown, ao_ErrCol)
  End If
  RPL_AGroup = Val(GetGroup(eDPCGroupType.gtArticleGroup, lc_Cursor))
  If RPL_AGroup = 0 Then
    Call AddCheckError(eDPCError.erGroupArticleUnknown, ao_ErrCol)
  End If
  RPL_MGroup = Val(GetGroup(eDPCGroupType.gtGoodsGroup, lc_Cursor))
  If RPL_MGroup = 0 Then
    Call AddCheckError(eDPCError.erGroupGoodsUnknown, ao_ErrCol)
  End If
  RPL_OGroup = GetGroup(eDPCGroupType.gtObjectGroup, lc_Cursor)
  If RPL_OGroup = "" Then
    Call AddCheckError(eDPCError.erGroupObjectUnknown, ao_ErrCol)
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call mo_Db.Close(lc_Cursor)
  Call ErrorHandler("CalculateGroup")
End Function

Private Function GetBOMSumDirectCost() As Double
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOM.BOM_DirectCost
  Next
  GetBOMSumDirectCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOMSumDirectCost")
End Function

Private Function GetBOMSumWasteCost() As Double
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOM.BOM_WasteCost
  Next
  GetBOMSumWasteCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOMSumWasteCost")
End Function

Private Function GetBOMSumRejectCost() As Double
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOM.BOM_RejectCost
  Next
  GetBOMSumRejectCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOMSumRejectCost")
End Function

Private Function GetBOMSumInlaftionCost() As Double
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOM In BOMs
    If lo_BOM.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOM.BOM_InflCost
  Next
  GetBOMSumInlaftionCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBOMSumInlaftionCost")
End Function

Private Function GetBORSumVarPerCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_VarPerCost
  Next
  GetBORSumVarPerCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumVarPerCost")
End Function

Private Function GetBORSumVarMasCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_VarMasCost
  Next
  GetBORSumVarMasCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumVarMasCost")
End Function

Private Function GetBORSumTekoCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_Teko
  Next
  GetBORSumTekoCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumTekoCost")
End Function

Private Function GetBORSumDirectCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_DirectCost
  Next
  GetBORSumDirectCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumDirectCost")
End Function

Private Function GetBORSumFixMasCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_FixMasCost
  Next
  GetBORSumFixMasCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumFixMasCost")
End Function

Private Function GetBORSumRejectTimeCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_WasteCost
  Next
  GetBORSumRejectTimeCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumRejectTimeCost")
End Function

Private Function GetBORSumDirectSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_DirectSetupCost
  Next
  GetBORSumDirectSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumDirectSetupCost")
End Function

Private Function GetBORSumSubSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_SubtotalSetupCost
  Next
  GetBORSumSubSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumSubSetupCost")
End Function
      
Private Function GetBORSumTotSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_TotSetupCost
  Next
  GetBORSumTotSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumTotSetupCost")
End Function
      
Private Function GetBORSumDirectLenSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_DirectLenSetupCost
  Next
  GetBORSumDirectLenSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumDirectLenSetupCost")
End Function

Private Function GetBORSumSubLenSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_SubtotalLenSetupCost
  Next
  GetBORSumSubLenSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumSubLenSetupCost")
End Function
      
Private Function GetBORSumTotLenSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_TotLenSetupCost
  Next
  GetBORSumTotLenSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumTotLenSetupCost")
End Function

Private Function GetBORSumDirectWidSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_DirectWidSetupCost
  Next
  GetBORSumDirectWidSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumDirectWidSetupCost")
End Function

Private Function GetBORSumSubWidSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_SubtotalWidSetupCost
  Next
  GetBORSumSubWidSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumSubWidSetupCost")
End Function
      
Private Function GetBORSumTotWidSetupCost() As Double
On Error GoTo ErrHandler

Dim lo_BOR As DPC_BOR
Dim ld_Sum As Double

  ld_Sum = 0
  For Each lo_BOR In BORs
    If lo_BOR.RowStatus <> eDPCRowStatus.rsDrop Then ld_Sum = ld_Sum + lo_BOR.BOR_TotWidSetupCost
  Next
  GetBORSumTotWidSetupCost = ld_Sum
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBORSumTotWidSetupCost")
End Function

Private Sub DeleteCostCalculation()
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "exec DPC_PrdCostCalc_Del $PRD_Id$, $U_Code$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeleteCostCalculation")
End Sub

Public Sub SaveCostCalculation()
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim ls_req As String

  If IsCostCalcChanged Then
    Call DeleteCostCalculation
    For ll_Idx = 0 To UBound(ma_CostCalc)
      ls_req = "exec DPC_PrdCostCalc_Ins $PRD_Id$, $PCC_Code$, $PCC_CostPCS$, $PCC_CostM2$, $PCC_DirectSetupCost$, $PCC_SubSetupCost$, $PCC_TotSetupCost$, $CURR_Code$, $U_Code$"
      ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
      ls_req = Replace(ls_req, "$PCC_Code$", mo_Tools.SqlIntKey(ma_CostCalc(ll_Idx).Code), , , vbTextCompare)
      ls_req = Replace(ls_req, "$PCC_CostPCS$", mo_Tools.SqlDbl(ma_CostCalc(ll_Idx).CostPCS), , , vbTextCompare)
      ls_req = Replace(ls_req, "$PCC_CostM2$", mo_Tools.SqlDbl(ma_CostCalc(ll_Idx).CostM2), , , vbTextCompare)
      
      ls_req = Replace(ls_req, "$PCC_DirectSetupCost$", mo_Tools.SqlDbl(ma_CostCalc(ll_Idx).DirectSetupCost), , , vbTextCompare)
      ls_req = Replace(ls_req, "$PCC_SubSetupCost$", mo_Tools.SqlDbl(ma_CostCalc(ll_Idx).SubSetupCost), , , vbTextCompare)
      ls_req = Replace(ls_req, "$PCC_TotSetupCost$", mo_Tools.SqlDbl(ma_CostCalc(ll_Idx).TotSetupCost), , , vbTextCompare)
      
      ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SqlStrKey(ma_CostCalc(ll_Idx).CURR_Code), , , vbTextCompare)
      ls_req = ReplaceCommonPlaceholders(ls_req)
      Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
    Next
  End If
  IsCostCalcChanged = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveCostCalculation")
End Sub

Public Sub UpdateCostCalcOffer()
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
  
  For Each lo_Offer In OfferPrice
    If lo_Offer.RowStatus = eDPCRowStatus.rsUpdate Then
      Call lo_Offer.Update(mo_Db, ml_U_Code)
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdateCostCalcOffer")
End Sub

Public Function GetCostCalcCount() As Long
On Error GoTo ErrHandler

  GetCostCalcCount = UBound(ma_CostCalc) + 1
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCostCalcCount")
End Function

Public Sub CostCalcObjToGrid(ByVal al_Idx As Long, ao_grid As ArmGrid)
On Error GoTo ErrHandler

  If al_Idx <= UBound(ma_CostCalc) Then
    ao_grid.Data(al_Idx, "PCC_Code") = ma_CostCalc(al_Idx).Code
    ao_grid.Data(al_Idx, "RF_Desc") = ma_CostCalc(al_Idx).Desc
    ao_grid.Data(al_Idx, "PCC_CostPCS") = ma_CostCalc(al_Idx).CostPCS
    ao_grid.Data(al_Idx, "PCC_CostM2") = ma_CostCalc(al_Idx).CostM2
    ao_grid.Data(al_Idx, "PCC_DirectSetupCost") = ma_CostCalc(al_Idx).DirectSetupCost
    ao_grid.Data(al_Idx, "PCC_SubSetupCost") = ma_CostCalc(al_Idx).SubSetupCost
    ao_grid.Data(al_Idx, "PCC_TotSetupCost") = ma_CostCalc(al_Idx).TotSetupCost
    ao_grid.Data(al_Idx, "CURR_Code") = ma_CostCalc(al_Idx).CURR_Code
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CostCalcObjToGrid")
End Sub

Private Sub SetCostCalc(ByVal ae_Code As eDPCCostCalculation, ByVal ad_CostPCS As Double, _
  ByVal ad_DirectSetupCost As Double, ByVal ad_SubSetupCost As Double, ByVal ad_TotSetupCost As Double)
On Error GoTo ErrHandler

Dim ll_Idx As Long

  For ll_Idx = 0 To UBound(ma_CostCalc)
    If ma_CostCalc(ll_Idx).Code = ae_Code Then
      ma_CostCalc(ll_Idx).CostPCS = ad_CostPCS
      If PanelSurface > 0 Then
        ma_CostCalc(ll_Idx).CostM2 = ad_CostPCS / PanelSurface
      Else
        ma_CostCalc(ll_Idx).CostM2 = 0
      End If
      ma_CostCalc(ll_Idx).DirectSetupCost = ad_DirectSetupCost
      ma_CostCalc(ll_Idx).SubSetupCost = ad_SubSetupCost
      ma_CostCalc(ll_Idx).TotSetupCost = ad_TotSetupCost
      Exit Sub
    End If
  Next
  Err.Raise ArmErr.InvalidArgument, "ae_Code", "Invalid cost calculation code: " & ae_Code
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetCostCalc")
End Sub

Public Sub InitCostCalc()
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lc_Cursor As Long
Dim ls_req As String

  ls_req = "exec A_References_ML_lst $GR_Code$,$Language_Code$"
  ls_req = Replace(ls_req, "$GR_Code$", mo_Tools.SqlInt(eDPCReferenceML.rfPanelCostCalc), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  mo_Db.SortFields(lc_Cursor) = "RF_Code"
  
  If mo_Db.RowCount(lc_Cursor) > 0 Then
    ReDim ma_CostCalc(mo_Db.RowCount(lc_Cursor) - 1)
  Else
    Err.Raise ArmErr.InvalidArgument, "lc_Cursor", "No cost calculation records found"
  End If
  ll_Idx = 0
  
  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)
    ma_CostCalc(ll_Idx).Code = mo_Db.GetFields(lc_Cursor, "RF_Code")
    ma_CostCalc(ll_Idx).Desc = mo_Db.GetFields(lc_Cursor, "RF_Desc")
    ma_CostCalc(ll_Idx).CostM2 = 0
    ma_CostCalc(ll_Idx).CostPCS = 0
    ma_CostCalc(ll_Idx).DirectSetupCost = 0
    ma_CostCalc(ll_Idx).SubSetupCost = 0
    ma_CostCalc(ll_Idx).TotSetupCost = 0
    ma_CostCalc(ll_Idx).CURR_Code = CURR_Code
    Call mo_Db.Next(lc_Cursor)
    ll_Idx = ll_Idx + 1
  Wend
  Call mo_Db.Close(lc_Cursor)
  IsCostCalcChanged = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitCostCalc")
End Sub

Public Sub CalculateCost()
On Error GoTo ErrHandler

Dim le_CostCalc As eDPCCostCalculation
Dim ld_CostPCS As Double
Dim ld_CostM2 As Double
Dim lo_Offer As DPC_OfferPos

Dim ld_RawMaterialCost As Double
Dim ld_MachineEnergyCost As Double
Dim ld_PersonDirectCost As Double
Dim ld_WasteMaterialCost As Double
Dim ld_RejectMaterialCost As Double
Dim ld_WorkTimeRejectCost As Double
Dim ld_DirectCost As Double
Dim ld_MPE1Cost As Double
Dim ld_MPE2Cost As Double
Dim ld_RawMaterialInflationCost As Double
Dim ld_ManufacturingCost As Double
Dim ld_PlantCost As Double
'Dim ld_CostMPE2Factor As Double
'Dim ld_CostAdminFactor As Double
'Dim ld_CostICTPFactor As Double
Dim ld_DirectSetupCost As Double, ld_SubSetupCost As Double, ld_TotSetupCost As Double
Dim ll_Idx As Long

  If HasBOMError Or HasBORError Then Exit Sub

  ld_RawMaterialCost = GetBOMSumDirectCost
  ld_MachineEnergyCost = GetBORSumVarMasCost + GetBORSumTekoCost
  ld_PersonDirectCost = GetBORSumVarPerCost
  ld_WasteMaterialCost = GetBOMSumWasteCost
  ld_RejectMaterialCost = GetBOMSumRejectCost
  ld_WorkTimeRejectCost = GetBORSumRejectTimeCost
  ld_DirectCost = (ld_RawMaterialCost + ld_MachineEnergyCost + ld_PersonDirectCost + ld_WasteMaterialCost + ld_RejectMaterialCost + ld_WorkTimeRejectCost)
  ld_MPE1Cost = GetBORSumFixMasCost
  ld_MPE2Cost = ld_DirectCost * RPL_MPE2Fact
  ld_RawMaterialInflationCost = GetBOMSumInlaftionCost
  ld_ManufacturingCost = ld_DirectCost + ld_MPE1Cost + ld_MPE2Cost
  ld_PlantCost = ld_ManufacturingCost + (ld_ManufacturingCost * RPL_AdminFact)
  
  For ll_Idx = 0 To UBound(ma_CostCalc)
    ld_CostPCS = 0
    ld_DirectSetupCost = 0
    ld_SubSetupCost = 0
    ld_TotSetupCost = 0
    le_CostCalc = ma_CostCalc(ll_Idx).Code
    Select Case le_CostCalc
    Case eDPCCostCalculation.ccRawmaterial
      ld_CostPCS = ld_RawMaterialCost
    Case eDPCCostCalculation.ccMachineEnergy
      ld_CostPCS = ld_MachineEnergyCost
    Case eDPCCostCalculation.ccPersonDirect
      ld_CostPCS = ld_PersonDirectCost
    Case eDPCCostCalculation.ccSubTotal
      ld_CostPCS = ld_RawMaterialCost + ld_MachineEnergyCost + ld_PersonDirectCost
    Case eDPCCostCalculation.ccWasteMaterial
      ld_CostPCS = ld_WasteMaterialCost
    Case eDPCCostCalculation.ccRejectMaterial
      ld_CostPCS = ld_RejectMaterialCost
    Case eDPCCostCalculation.ccWorkTimeReject
      ld_CostPCS = ld_WorkTimeRejectCost
    Case eDPCCostCalculation.ccDirectCosts
      ld_CostPCS = ld_DirectCost
    Case eDPCCostCalculation.ccMPE1
      ld_CostPCS = ld_MPE1Cost
    Case eDPCCostCalculation.ccMPE2
      ld_CostPCS = ld_MPE2Cost
    Case eDPCCostCalculation.ccManufacturingCosts
      ld_CostPCS = ld_ManufacturingCost
    Case eDPCCostCalculation.ccAdminCosts
      ld_CostPCS = ld_ManufacturingCost * RPL_AdminFact
    Case eDPCCostCalculation.ccPlantCosts
      ld_CostPCS = ld_PlantCost
    Case eDPCCostCalculation.ccRawmaterialInflation
      ld_CostPCS = ld_RawMaterialInflationCost
    Case eDPCCostCalculation.ccFullCost
      ld_CostPCS = ld_PlantCost + ld_RawMaterialInflationCost
    Case eDPCCostCalculation.ccICTPRate
      ld_CostPCS = RPL_ICTPFact * (ld_PlantCost + ld_RawMaterialInflationCost)
    Case eDPCCostCalculation.ccICTPPrice
      ld_CostPCS = (ld_PlantCost + ld_RawMaterialInflationCost) + RPL_ICTPFact * (ld_PlantCost + ld_RawMaterialInflationCost)
      Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPosition)
      If Not (lo_Offer Is Nothing) Then
        Call lo_Offer.SetCost(DPC_UOM_PCS, ld_CostPCS)
        lo_Offer.RowStatus = eDPCRowStatus.rsUpdate
      End If
    Case eDPCCostCalculation.ccSetupCost
      ld_DirectSetupCost = GetBORSumDirectSetupCost
      ld_SubSetupCost = GetBORSumSubSetupCost
      ld_TotSetupCost = GetBORSumTotSetupCost
      If HasPerforation Then
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelSetupChargePrf)
      Else
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelSetupChargeUnp)
      End If
      If Not (lo_Offer Is Nothing) Then
        Call lo_Offer.SetCost(DPC_UOM_PCS, ld_TotSetupCost)
        lo_Offer.RowStatus = eDPCRowStatus.rsUpdate
      End If
    Case eDPCCostCalculation.ccSetupLengthCost
      ld_DirectSetupCost = GetBORSumDirectLenSetupCost
      ld_SubSetupCost = GetBORSumSubLenSetupCost
      ld_TotSetupCost = GetBORSumTotLenSetupCost
      If HasPerforation Then
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelChangeLengthCostPrf)
      Else
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelChangeLengthCostUnp)
      End If
      If Not (lo_Offer Is Nothing) Then
        Call lo_Offer.SetCost(DPC_UOM_PCS, ld_TotSetupCost)
        lo_Offer.RowStatus = eDPCRowStatus.rsUpdate
      End If
    Case eDPCCostCalculation.ccSetupWidthCost
      ld_DirectSetupCost = GetBORSumDirectWidSetupCost
      ld_SubSetupCost = GetBORSumSubWidSetupCost
      ld_TotSetupCost = GetBORSumTotWidSetupCost
      If HasPerforation Then
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelChangeWidthCostPrf)
      Else
        Set lo_Offer = GetOfferPos(eDPCOfferDetail.odPanelChangeWidthCostUnp)
      End If
      If Not (lo_Offer Is Nothing) Then
        Call lo_Offer.SetCost(DPC_UOM_PCS, ld_TotSetupCost)
        lo_Offer.RowStatus = eDPCRowStatus.rsUpdate
      End If
    Case Else
      Err.Raise ArmErr.InvalidArgument, "le_CostCalc", "Unknown cost calculation id: " & le_CostCalc
    End Select
    Call SetCostCalc(le_CostCalc, ld_CostPCS, ld_DirectSetupCost, ld_SubSetupCost, ld_TotSetupCost)
  Next
  IsCostCalcChanged = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalculateCost")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$COF_Lang$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$iConcurrency$", mo_Tools.SqlInt(ml_iConcurrency), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

