VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_OfferPos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private mo_Tools As DPC_Tools

Public COF_Id As String
Public OFD_Id As String
Public Language_Code As String
Public OFD_Order As Long
Public OFD_Type As eDPCPriceBookType
Public OFD_TypeDesc As String
Public CAT_Id  As eDPCCategory
Public CAT_Name As String
Public DOF_Id As eDPCOfferDetail
Public PRD_Id As String
Public SPA_Id As Long
Public S_Code As String
Public OFD_Pos As Long
Public PRD_Code As String
Public PRD_CodeC As String
Public PRD_Name As String
Public PRD_Desc As String
Public LEV_Id As eDPCLevel

'Public OFD_QtyPCS As Double
'Public OFD_QtyM2 As Double
'Public OFD_QtyPU As Double
'
'Public OFD_QtyAPCS As Double
'Public OFD_QtyAM2 As Double
'Public OFD_QtyAPU As Double

Private md_OFD_QtyPCS As Double
Private md_OFD_QtyM2 As Double
Private md_OFD_QtyPU As Double

Private md_OFD_QtyAPCS As Double
Private md_OFD_QtyAM2 As Double
Private md_OFD_QtyAPU As Double


Private md_OFD_QtyA As Double
Private md_OFD_Qty As Double
Private md_OFD_Cost As Double
Private md_OFD_CostA As Double
Private md_OFD_Price As Double
Private md_OFD_PriceA As Double
Private md_OFD_PriceAPCS As Double
Private md_OFD_PriceAM2 As Double
Private md_OFD_PricePCS As Double
Private md_OFD_PriceM2 As Double

Private md_OFD_CostAPCS As Double
Private md_OFD_CostAM2 As Double
Private md_OFD_CostPCS As Double
Private md_OFD_CostM2 As Double

Public OFD_PU As Long

'Public OFD_CostAPCS As Double
'Public OFD_CostAM2 As Double
'Public OFD_CostAPU As Double property

'Public OFD_CostPCS As Double
'Public OFD_CostM2 As Double
'Public OFD_CostPU As Double property
'Public OFD_TotalC As Double property

'Public OFD_PriceAPCS As Double property
'Public OFD_PriceAM2 As Double property
'Public OFD_PriceAPU As Double property

'Public OFD_PricePCS As Double property
'Public OFD_PriceM2 As Double property
'Public OFD_PricePU As Double property
'Public OFD_TotalP As Double

'Public OFD_TotalI As Double property
'Public OFD_Margin As Double property
'Public OFD_MarginA As Double property
'Public OFD_Deviation As Double property

Public OFD_HPrice As Double
Public OFD_IctpPCS As Double
Public OFD_Ictp As Double
Public OFD_MarginS As Double
Public OFD_GTN As Double
Public OFD_MarginMin As Double
Public CURR_Code As String
Public CURR_CodeCOF As String
Public OFD_Rate As Double
Private md_OFD_Disco As Double
Public UM_Code As String
Public UM_Name As String

Public OFD_Main As eDPCOfferDetailMain
Public OFD_IdPar As String
Public OFD_Valid As Boolean
Public OFD_Found As Long
Public ERR_Type As eDPCErrorType
Public OFD_AppBy As Long
Public OFD_ApDat As Date
Public OFD_IsAlt As Long
Public OFD_AltPa As String
Public OFD_WshDat As Date
Public OFD_ShpDat As Date
Public OFD_DelDat As Date

Public OFD_PlaDat As Date
Public OFD_PlaUsr As String
Public OFD_B7Sta As Long
Public OFD_Split As Long
Public OFD_InfoB7 As String
Public OFD_OrdNrB7 As String
Public OFD_PosB7 As Long
Public SAE_Id As Long
Public SHP_Id As Long
Public VEN_Id As String
Public OFD_IsFree As Boolean
Public OFD_PosCus As String
Public OFD_IsAsItem As Boolean
Public OFD_HasQty As Boolean
Public OFD_HasPrice As Boolean
Public OFD_HasTotal As Boolean

Public OFD_SAPSta As Long
Public OFD_SAPAct  As String
Public OFD_SAPInfo  As String
Public OFD_PosSAP As String
Public COF_IdOff As String
Public OFD_IdOff As String

Public OFD_AltPaName As String
Public SAE_Name As String
Public SHP_Name As String
Public VEN_Name As String

Public SCR_Id As Long
Public DOF_Tag As String
Public DOF_Name As String
Public DOF_Desc As String
Public DOF_Order As Long
Public DOF_NTemp As String
Public DOF_DTemp As String
Public DOF_IsVal As Boolean
Public DOF_IsVal0 As Boolean
Public DOF_IsTxt As Boolean
Public DOF_IsSchg As Boolean
Public DOF_IsStp As Boolean
Public DOF_CanInv As Boolean

Public SCH_Id As String
Public SCH_Code As String
Public SCH_Name As String
Public SCH_Desc As String

Public UM_CodeQ As String

Public AlternateParent As DPC_OfferPos
Public ValidManual As eDPCOfferPosValidManual
Public RowStatus As eDPCRowStatus
Private md_ModuleSurface As Double

Public Sub CopyFrom(ByVal ao_Offer As DPC_OfferPos)
On Error GoTo ErrHandler
  
  COF_Id = ao_Offer.COF_Id
  OFD_Id = ao_Offer.OFD_Id
  Language_Code = ao_Offer.Language_Code
  OFD_Order = ao_Offer.OFD_Order
  OFD_Type = ao_Offer.OFD_Type
  OFD_TypeDesc = ao_Offer.OFD_TypeDesc
  CAT_Id = ao_Offer.CAT_Id
  CAT_Name = ao_Offer.CAT_Name
  DOF_Id = ao_Offer.DOF_Id
  PRD_Id = ao_Offer.PRD_Id
  SPA_Id = ao_Offer.SPA_Id
  S_Code = ao_Offer.S_Code
  OFD_Pos = ao_Offer.OFD_Pos
  PRD_Code = ao_Offer.PRD_Code
  PRD_CodeC = ao_Offer.PRD_CodeC
  PRD_Name = ao_Offer.PRD_Name
  PRD_Desc = ao_Offer.PRD_Desc
  LEV_Id = ao_Offer.LEV_Id
  
  OFD_HPrice = ao_Offer.OFD_HPrice
  OFD_IctpPCS = ao_Offer.OFD_IctpPCS
  OFD_Ictp = ao_Offer.OFD_Ictp
  OFD_MarginS = ao_Offer.OFD_MarginS
  OFD_GTN = ao_Offer.OFD_GTN
  OFD_MarginMin = ao_Offer.OFD_MarginMin
  CURR_Code = ao_Offer.CURR_Code
  CURR_CodeCOF = ao_Offer.CURR_CodeCOF
  OFD_Rate = ao_Offer.OFD_Rate
  md_OFD_Disco = ao_Offer.OFD_Disco
  
  UM_Code = ao_Offer.UM_Code
  UM_Name = ao_Offer.UM_Name
  OFD_PU = ao_Offer.OFD_PU
  OFD_Qty = ao_Offer.OFD_Qty
  OFD_QtyA = ao_Offer.OFD_QtyA
  OFD_Cost = ao_Offer.OFD_Cost
  OFD_CostA = ao_Offer.OFD_CostA
  OFD_Price = ao_Offer.OFD_Price
  OFD_PriceA = ao_Offer.OFD_PriceA
  
  OFD_Main = ao_Offer.OFD_Main
  OFD_IdPar = ao_Offer.OFD_IdPar
  OFD_Valid = ao_Offer.OFD_Valid
  OFD_Found = ao_Offer.OFD_Found
  ERR_Type = ao_Offer.ERR_Type
  OFD_AppBy = ao_Offer.OFD_AppBy
  OFD_ApDat = ao_Offer.OFD_ApDat
  OFD_IsAlt = ao_Offer.OFD_IsAlt
  OFD_AltPa = ao_Offer.OFD_AltPa
  OFD_WshDat = ao_Offer.OFD_WshDat
  OFD_ShpDat = ao_Offer.OFD_ShpDat
  OFD_DelDat = ao_Offer.OFD_DelDat
  
  OFD_PlaDat = ao_Offer.OFD_PlaDat
  OFD_PlaUsr = ao_Offer.OFD_PlaUsr
  OFD_B7Sta = ao_Offer.OFD_B7Sta
  OFD_Split = ao_Offer.OFD_Split
  OFD_InfoB7 = ao_Offer.OFD_InfoB7
  OFD_OrdNrB7 = ao_Offer.OFD_OrdNrB7
  OFD_PosB7 = ao_Offer.OFD_PosB7
  SAE_Id = ao_Offer.SAE_Id
  SHP_Id = ao_Offer.SHP_Id
  VEN_Id = ao_Offer.VEN_Id
  OFD_IsFree = ao_Offer.OFD_IsFree
  OFD_PosCus = ao_Offer.OFD_PosCus
  OFD_IsAsItem = ao_Offer.OFD_IsAsItem
  OFD_HasQty = ao_Offer.OFD_HasQty
  OFD_HasPrice = ao_Offer.OFD_HasPrice
  OFD_HasTotal = ao_Offer.OFD_HasTotal
  OFD_SAPSta = ao_Offer.OFD_SAPSta
  OFD_SAPAct = ao_Offer.OFD_SAPAct
  OFD_SAPInfo = ao_Offer.OFD_SAPInfo
    
  OFD_PosSAP = ao_Offer.OFD_PosSAP
  COF_IdOff = ao_Offer.COF_IdOff
  OFD_IdOff = ao_Offer.OFD_IdOff
    
  OFD_AltPaName = ao_Offer.OFD_AltPaName
  SAE_Name = ao_Offer.SAE_Name
  SHP_Name = ao_Offer.SHP_Name
  VEN_Name = ao_Offer.VEN_Name
  
  SCR_Id = ao_Offer.SCR_Id
  DOF_Tag = ao_Offer.DOF_Tag
  DOF_Name = ao_Offer.DOF_Name
  DOF_Desc = ao_Offer.DOF_Desc
  DOF_Order = ao_Offer.DOF_Order
  DOF_NTemp = ao_Offer.DOF_NTemp
  DOF_DTemp = ao_Offer.DOF_DTemp
  DOF_IsVal = ao_Offer.DOF_IsVal
  DOF_IsVal0 = ao_Offer.DOF_IsVal0
  DOF_IsTxt = ao_Offer.DOF_IsTxt
  DOF_IsSchg = ao_Offer.DOF_IsSchg
  DOF_IsStp = ao_Offer.DOF_IsStp
  DOF_CanInv = ao_Offer.DOF_CanInv
  
  SCH_Id = ao_Offer.SCH_Id
  SCH_Code = ao_Offer.SCH_Code
  SCH_Name = ao_Offer.SCH_Name
  SCH_Desc = ao_Offer.SCH_Desc
  UM_CodeQ = ao_Offer.UM_CodeQ
  
  ValidManual = ao_Offer.ValidManual
  Exit Sub
ErrHandler:
  Call errorHandler("CopyFrom")
End Sub

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo errorHandler

  Set mo_Tools = ao_Tools
  Exit Property
errorHandler:
  Call errorHandler("Tools.Set")
End Property

Public Property Get ModuleSurface() As Double
On Error GoTo ErrHandler

  ModuleSurface = md_ModuleSurface
  Exit Property
ErrHandler:
  Call errorHandler("ModuleSurface.Get")
End Property

Public Property Let OFD_Qty(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetQty(UM_Code, ad_Value)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Qty.Let")
End Property

Public Property Get OFD_Qty() As Double
On Error GoTo ErrHandler
  'OFD_QtyPU,
  OFD_Qty = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_QtyM2, OFD_QtyPCS, md_OFD_Qty))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Qty.Get")
End Property

Public Property Let OFD_QtyA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetQtyA(UM_Code, ad_Value)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyA.Let")
End Property

Public Property Get OFD_QtyA() As Double
On Error GoTo ErrHandler
  ', OFD_QtyAPU
  OFD_QtyA = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_QtyAM2, OFD_QtyAPCS, md_OFD_QtyA))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyA.Get")
End Property

Public Property Let OFD_Cost(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetCost(UM_Code, ad_Value)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Cost.Let")
End Property

Public Property Get OFD_Cost() As Double
On Error GoTo ErrHandler
  ', OFD_CostPU
  OFD_Cost = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_CostM2, OFD_CostPCS, md_OFD_Cost))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Cost.Get")
End Property

Public Property Let OFD_CostA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetCostA(UM_Code, ad_Value)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostA.Let")
End Property

Public Property Get OFD_CostA() As Double
On Error GoTo ErrHandler
  ', OFD_CostAPU
  OFD_CostA = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_CostAM2, OFD_CostAPCS, md_OFD_CostA))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostA.Get")
End Property

Public Property Let OFD_Disco(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  md_OFD_Disco = ad_Value
  OFD_Price = CalculateMarginDiscount(OFD_PriceA, ad_Value)
  'OFD_Price = OFD_PriceA + (OFD_PriceA * ad_Value / 100)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostA.Let")
End Property

Public Property Get OFD_Disco() As Double
On Error GoTo ErrHandler

  OFD_Disco = md_OFD_Disco
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Disco.Get")
End Property

Public Property Let OFD_Price(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetPrice(UM_Code, ad_Value)
  md_OFD_Disco = GetDiscountMargin(OFD_PriceA, OFD_Price)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Price.Let")
End Property

Public Property Get OFD_Price() As Double
On Error GoTo ErrHandler
  ', OFD_PricePU
  OFD_Price = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_PriceM2, OFD_PricePCS, md_OFD_Price))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Price.Get")
End Property

Public Property Let OFD_PriceA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  Call SetPriceA(UM_Code, ad_Value)
  md_OFD_Disco = GetDiscountMargin(OFD_PriceA, OFD_Price)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceA.Let")
End Property

Public Property Get OFD_PriceA() As Double
On Error GoTo ErrHandler
  ', OFD_PriceAPU
  OFD_PriceA = mo_Tools.RoundTo(SelectFigure(UM_Code, OFD_PriceAM2, OFD_PriceAPCS, md_OFD_PriceA))
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceA.Get")
End Property

Public Property Let OFD_PriceR(ByVal ad_Value As Double)
On Error GoTo ErrHandler

  If Round(OFD_Rate, 3) = 0 Then
    Call SetPrice(UM_Code, 0)
  Else
    Call SetPrice(UM_Code, mo_Tools.RoundTo(ad_Value / OFD_Rate))
  End If
  md_OFD_Disco = GetDiscountMargin(OFD_PriceA, OFD_Price)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceA.Let")
End Property

Public Property Get OFD_PriceR() As Double
On Error GoTo ErrHandler

  OFD_PriceR = mo_Tools.RoundTo(OFD_Price * OFD_Rate)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceR.Get")
End Property

Private Function IsDefaultUM(ByVal as_UM_Code As String) As Boolean
On Error GoTo ErrHandler

  IsDefaultUM = StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Or _
                StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Or _
                StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0
  Exit Function
ErrHandler:
  Call errorHandler("IsDefaultUM")
End Function

'ByVal ad_FigurePU As Double,
Private Function SelectFigure(ByVal as_UM_Code As String, ByVal ad_FigureM2 As Double, ByVal ad_FigurePCS As Double, ByVal ad_FigureOther As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    SelectFigure = ad_FigureM2
  ElseIf StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    SelectFigure = ad_FigurePCS
'  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
'    SelectFigure = ad_FigurePU
  ElseIf StrComp(as_UM_Code, UM_Code, vbTextCompare) = 0 Then
    SelectFigure = ad_FigureOther
  Else
    Err.Raise ArmErr.InvalidArgument, "as_UM_Code", "Unknown unit of measure: " & as_UM_Code
  End If
  Exit Function
ErrHandler:
  Call errorHandler("SelectFigure")
End Function

Public Sub SetQtyA(ByVal as_UM_Code As String, ByVal ad_Value As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_QtyAM2 = ad_Value
    md_OFD_QtyAPCS = mo_Tools.ToQtyPCS(ad_Value, ModuleSurface)
    md_OFD_QtyAPU = mo_Tools.ToQtyPU(OFD_QtyAPCS, OFD_PU)
  ElseIf (StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0) Then
    md_OFD_QtyAPCS = ad_Value
    md_OFD_QtyAM2 = mo_Tools.ToQtyM2(ad_Value, ModuleSurface)
    md_OFD_QtyAPU = mo_Tools.ToQtyPU(ad_Value, OFD_PU)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_QtyAPU = ad_Value
    md_OFD_QtyAPCS = ad_Value * OFD_PU
    md_OFD_QtyAM2 = mo_Tools.ToQtyM2(OFD_QtyAPCS, ModuleSurface)
  Else
    md_OFD_QtyAPU = 0
    md_OFD_QtyAPCS = 0
    md_OFD_QtyAM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  ', OFD_QtyAPU
  md_OFD_QtyA = SelectFigure(UM_Code, OFD_QtyAM2, OFD_QtyAPCS, ad_Value)
  Exit Sub
ErrHandler:
  Call errorHandler("SetQtyA")
End Sub

Public Sub SetQty(ByVal as_UM_Code As String, ByVal ad_Value As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_QtyM2 = ad_Value
    md_OFD_QtyPCS = mo_Tools.ToQtyPCS(ad_Value, ModuleSurface)
    md_OFD_QtyPU = mo_Tools.ToQtyPU(OFD_QtyPCS, OFD_PU)
  ElseIf (StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0) Then
    md_OFD_QtyPCS = ad_Value
    md_OFD_QtyM2 = mo_Tools.ToQtyM2(ad_Value, ModuleSurface)
    md_OFD_QtyPU = mo_Tools.ToQtyPU(ad_Value, OFD_PU)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_QtyPU = ad_Value
    md_OFD_QtyPCS = ad_Value * OFD_PU
    md_OFD_QtyM2 = mo_Tools.ToQtyM2(OFD_QtyPCS, ModuleSurface)
  Else
    md_OFD_QtyPU = 0
    md_OFD_QtyPCS = 0
    md_OFD_QtyM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  ', OFD_QtyPU
  md_OFD_Qty = SelectFigure(UM_Code, OFD_QtyM2, OFD_QtyPCS, ad_Value)
  Exit Sub
ErrHandler:
  Call errorHandler("SetQtyA")
End Sub

Public Sub SetCostA(ByVal as_UM_Code As String, ByVal ad_Cost As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_CostAM2 = ad_Cost
    md_OFD_CostAPCS = mo_Tools.FromPriceM2toPCS(ad_Cost, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    md_OFD_CostAPCS = ad_Cost
    md_OFD_CostAM2 = mo_Tools.FromPricePCStoM2(ad_Cost, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_CostAPCS = mo_Tools.FromPricePUtoPCS(ad_Cost, OFD_PU)
    md_OFD_CostAM2 = mo_Tools.FromPricePCStoM2(OFD_CostAPCS, ModuleSurface)
  Else
    md_OFD_CostAPCS = 0
    md_OFD_CostAM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  ', OFD_CostAPU
  md_OFD_CostA = SelectFigure(UM_Code, OFD_CostAM2, OFD_CostAPCS, ad_Cost)
  Exit Sub
ErrHandler:
  Call errorHandler("SetCostA")
End Sub

Public Sub SetCost(ByVal as_UM_Code As String, ByVal ad_Cost As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_CostM2 = ad_Cost
    md_OFD_CostPCS = mo_Tools.FromPriceM2toPCS(ad_Cost, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    md_OFD_CostPCS = ad_Cost
    md_OFD_CostM2 = mo_Tools.FromPricePCStoM2(ad_Cost, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_CostPCS = mo_Tools.FromPricePUtoPCS(ad_Cost, OFD_PU)
    md_OFD_CostM2 = mo_Tools.FromPricePCStoM2(OFD_CostPCS, ModuleSurface)
  Else
    md_OFD_CostPCS = 0
    md_OFD_CostM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  'changed as_UM_Code to UM_Code, do not work because other is prefered !!! need to check what it affect if enter cost/price for unknown um_Code
  ', OFD_CostPU
  md_OFD_Cost = SelectFigure(UM_Code, OFD_CostM2, OFD_CostPCS, ad_Cost)
  OFD_Ictp = OFD_Cost
  OFD_IctpPCS = OFD_CostPCS
  Exit Sub
ErrHandler:
  Call errorHandler("SetCost")
End Sub

Public Sub SetPriceA(ByVal as_UM_Code As String, ByVal ad_PriceA As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_PriceAM2 = ad_PriceA
    md_OFD_PriceAPCS = mo_Tools.FromPriceM2toPCS(ad_PriceA, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    md_OFD_PriceAPCS = ad_PriceA
    md_OFD_PriceAM2 = mo_Tools.FromPricePCStoM2(ad_PriceA, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_PriceAPCS = mo_Tools.FromPricePUtoPCS(ad_PriceA, OFD_PU)
    md_OFD_PriceAM2 = mo_Tools.FromPricePCStoM2(OFD_PriceAPCS, ModuleSurface)
  Else
    md_OFD_PriceAPCS = 0
    md_OFD_PriceAM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  ', OFD_PriceAPU
  md_OFD_PriceA = SelectFigure(UM_Code, OFD_PriceAM2, OFD_PriceAPCS, ad_PriceA)
  Exit Sub
ErrHandler:
  Call errorHandler("SetPriceA")
End Sub

Public Sub SetPrice(ByVal as_UM_Code As String, ByVal ad_Price As Double)
On Error GoTo ErrHandler

  If StrComp(as_UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    md_OFD_PriceM2 = ad_Price
    md_OFD_PricePCS = mo_Tools.FromPriceM2toPCS(ad_Price, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    md_OFD_PricePCS = ad_Price
    md_OFD_PriceM2 = mo_Tools.FromPricePCStoM2(ad_Price, ModuleSurface)
  ElseIf StrComp(as_UM_Code, DPC_UOM_PU, vbTextCompare) = 0 Then
    md_OFD_PricePCS = mo_Tools.FromPricePUtoPCS(ad_Price, OFD_PU)
    md_OFD_PriceM2 = mo_Tools.FromPricePCStoM2(OFD_PricePCS, ModuleSurface)
  Else
    md_OFD_PricePCS = 0
    md_OFD_PriceM2 = 0
    Debug.Assert as_UM_Code = UM_Code
  End If
  ', OFD_PricePU
  md_OFD_Price = SelectFigure(UM_Code, OFD_PriceM2, OFD_PricePCS, ad_Price)
  Exit Sub
ErrHandler:
  Call errorHandler("SetPrice")
End Sub

Public Sub Init(ByVal ad_Qty As Double, ByVal ad_QtyA As Double, ByVal ae_QtyType As eDPCQtyType, ByVal al_PU As Long, ByVal ad_ModuleSurface As Double)
On Error GoTo ErrHandler

  md_ModuleSurface = ad_ModuleSurface
  OFD_PU = al_PU
  If DOF_IsStp Then
    UM_Code = DPC_UOM_PCS
    OFD_Qty = 1
    OFD_QtyA = 1
  ElseIf DOF_IsTxt Then
    UM_Code = ""
    OFD_Qty = 0
    OFD_QtyA = 0
  Else
    Select Case ae_QtyType
    Case eDPCQtyType.qtM2
      UM_Code = DPC_UOM_M2
    Case eDPCQtyType.qtPCS
      UM_Code = DPC_UOM_PCS
    Case eDPCQtyType.qtPU
      UM_Code = DPC_UOM_PU
    Case eDPCQtyType.qtUnknown
      UM_Code = DPC_UOM_UNKNOWN
    Case Else
      Err.Raise 0, "al_QtyType", "Invalid quantity type: " & ae_QtyType
    End Select
    
    OFD_Qty = ad_Qty
    OFD_QtyA = ad_QtyA
  End If
  
  OFD_Cost = 0
  OFD_CostA = 0
  OFD_Price = 0
  OFD_PriceA = 0
  OFD_HPrice = 0
  OFD_Found = 0
  
  LEV_Id = eDPCLevel.lvStandard
  Language_Code = "E"
  Exit Sub
ErrHandler:
  Call errorHandler("Init")
End Sub

'Public Function CalculateReverseMargin(ByVal ad_Value As Double, ByVal ad_MarginDiscount As Double) As Double
'On Error GoTo ErrHandler
'
'  If ad_MarginDiscount = 100 Then
'    CalculateMarginDiscount = ad_Value
'  ElseIf ad_MarginDiscount < 0 Then
'    CalculateMarginDiscount = ad_Value + (ad_Value * ad_MarginDiscount / 100)
'  Else
'    CalculateMarginDiscount = (ad_Value / (1 - (ad_MarginDiscount / 100)))
'  End If
'  Exit Function
'ErrHandler:
'  Call ErrorHandler("CalculateMarginDiscount")
'End Function

Public Function CalculateMarginDiscount(ByVal ad_Value As Double, ByVal ad_MarginDiscount As Double) As Double
On Error GoTo ErrHandler

  If ad_MarginDiscount = 100 Then
    CalculateMarginDiscount = ad_Value
  ElseIf ad_MarginDiscount < 0 Then
    CalculateMarginDiscount = ad_Value + (ad_Value * ad_MarginDiscount / 100)
  Else
    CalculateMarginDiscount = (ad_Value / (1 - (ad_MarginDiscount / 100)))
  End If
  Exit Function
ErrHandler:
  Call errorHandler("CalculateMarginDiscount")
End Function

Public Function GetDiscountMargin(ByVal ad_Value1 As Double, ByVal ad_Value2 As Double) As Double
On Error GoTo ErrHandler

  If ad_Value1 >= ad_Value2 Then
    If Round(ad_Value1, 3) <= 0 Then
      GetDiscountMargin = 0
    Else
      GetDiscountMargin = 100 * (ad_Value2 / ad_Value1 - 1)
    End If
  Else
    If Round(ad_Value2, 3) <= 0 Then
      GetDiscountMargin = 0
    Else
      GetDiscountMargin = (1 - (ad_Value1 / ad_Value2)) * 100
    End If
  End If
  Exit Function
ErrHandler:
  Call errorHandler("GetDiscountMargin")
End Function

Public Function GetMarginWithoutGTN(ByVal ad_Value1 As Double, ByVal ad_Value2 As Double) As Double
On Error GoTo ErrHandler

  If ad_Value1 >= ad_Value2 Then
    If Round(ad_Value1, 3) <= 0 Then
      GetMarginWithoutGTN = 0
    Else
      GetMarginWithoutGTN = 100 * (ad_Value2 / ad_Value1 - 1)
    End If
  Else
    If Round(ad_Value2, 3) <= 0 Then
      GetMarginWithoutGTN = 0
    Else
      GetMarginWithoutGTN = (1 - (ad_Value1 / (1 - OFD_GTN / 100) / ad_Value2)) * 100
    End If
  End If
  Exit Function
ErrHandler:
  Call errorHandler("GetMarginWithoutGTN")
End Function

Public Sub CalculateGrossSellingPrice()
On Error GoTo ErrHandler

  Dim ld_Price As Double
  
  ld_Price = CalculateMarginDiscount(OFD_Cost, OFD_MarginS)
  ld_Price = CalculateMarginDiscount(ld_Price, OFD_GTN)
  OFD_Price = ld_Price
  OFD_PriceA = ld_Price
'  OFD_MarginS = ad_MarginS
'  OFD_GTN = ad_GTN
  Exit Sub
ErrHandler:
  Call errorHandler("CalculateGrossSellingPrice")
End Sub

'Public Sub CalculatePriceAMargin(ByVal ad_Margin As Double)
'On Error GoTo ErrHandler
'
'  OFD_PriceA = CalculateMargin(OFD_CostA, ad_Margin)
'  Exit Sub
'ErrHandler:
'  Call ErrorHandler("CalculatePriceAMargin")
'End Sub

Public Sub ReadOfferPosTemp(ByVal ao_Db As Object, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  DOF_Id = ao_Db.GetFields(ac_Cursor, "DOF_Id")
  CAT_Id = ao_Db.GetFields(ac_Cursor, "CAT_Id")
  CAT_Name = ao_Db.GetFields(ac_Cursor, "CAT_Name")
  SCR_Id = ao_Db.GetFields(ac_Cursor, "SCR_Id")
  DOF_IsVal = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsVal"), "X", vbTextCompare) = 0
  DOF_IsVal0 = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsVal0"), "X", vbTextCompare) = 0
  DOF_IsTxt = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsTxt"), "X", vbTextCompare) = 0
  DOF_IsSchg = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsSchg"), "X", vbTextCompare) = 0
  DOF_IsStp = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsStp"), "X", vbTextCompare) = 0
  DOF_CanInv = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_CanInv"), "X", vbTextCompare) = 0
  DOF_Tag = ao_Db.GetFields(ac_Cursor, "DOF_Tag")
  DOF_Name = ao_Db.GetFields(ac_Cursor, "DOF_Name")
  DOF_Desc = ao_Db.GetFields(ac_Cursor, "DOF_Desc")
  DOF_Order = ao_Db.GetFields(ac_Cursor, "DOF_Order")
  DOF_NTemp = ao_Db.GetFields(ac_Cursor, "DOF_NTemp")
  DOF_DTemp = ao_Db.GetFields(ac_Cursor, "DOF_DTemp")
  UM_CodeQ = ao_Db.GetFields(ac_Cursor, "UM_CodeQ")
  SCH_Id = ao_Db.GetFields(ac_Cursor, "SCH_Id")
  SCH_Code = ao_Db.GetFields(ac_Cursor, "SCH_Code")
  SCH_Name = ao_Db.GetFields(ac_Cursor, "SCH_Name")
  SCH_Desc = ao_Db.GetFields(ac_Cursor, "SCH_Desc")
  LEV_Id = eDPCLevel.lvStandard
  PRD_Id = ""
  PRD_Code = ""
  PRD_CodeC = ""
  PRD_Name = ""
  PRD_Desc = ""
  UM_Code = ""
  UM_Name = ""
  OFD_Qty = 0
  OFD_QtyA = 0
  OFD_Price = 0
  OFD_PriceA = 0
  OFD_Found = 0
  OFD_Type = eDPCPriceBookType.eUnknown
  If DOF_IsVal And DOF_IsVal0 Then
    OFD_Valid = True
  Else
    OFD_Valid = False
  End If
  Exit Sub
ErrHandler:
  Call errorHandler("ReadOfferPosTemp")
End Sub

Public Sub Load(ByVal ao_Db As Object, ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByVal as_Language_Code As String)
On Error GoTo ErrHandler

Dim ls_Req As String
Dim lc_Cursor As Long

  ls_Req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SqlStrKey(as_COF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Language_code$", mo_Tools.SQLStr(as_Language_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SqlStrKey(as_OFD_Id), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(ao_Db, ls_Req, 1)
  Call ReadOfferPos(ao_Db, lc_Cursor)
  Call ao_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call errorHandler("Load")
End Sub

Public Sub ReadOfferPos(ByVal ao_Db As Object, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  COF_Id = ao_Db.GetFields(ac_Cursor, "COF_Id")
  OFD_Id = ao_Db.GetFields(ac_Cursor, "OFD_Id")
  Language_Code = ao_Db.GetFields(ac_Cursor, "Language_Code")
  OFD_Order = ao_Db.GetFields(ac_Cursor, "OFD_Order")
  OFD_Type = ao_Db.GetFields(ac_Cursor, "OFD_Type")
  OFD_TypeDesc = ao_Db.GetFields(ac_Cursor, "OFD_TypeDesc")
  CAT_Id = ao_Db.GetFields(ac_Cursor, "CAT_Id")
  CAT_Name = ao_Db.GetFields(ac_Cursor, "CAT_Name")
  DOF_Id = ao_Db.GetFields(ac_Cursor, "DOF_Id")
  PRD_Id = ao_Db.GetFields(ac_Cursor, "PRD_Id")
  SPA_Id = ao_Db.GetFields(ac_Cursor, "SPA_Id")
  S_Code = ao_Db.GetFields(ac_Cursor, "S_Code")
  OFD_Pos = ao_Db.GetFields(ac_Cursor, "OFD_Pos")
  PRD_Code = ao_Db.GetFields(ac_Cursor, "PRD_Code")
  PRD_CodeC = ao_Db.GetFields(ac_Cursor, "PRD_CodeC")
  PRD_Name = ao_Db.GetFields(ac_Cursor, "PRD_Name")
  PRD_Desc = ao_Db.GetFields(ac_Cursor, "PRD_Desc")
  LEV_Id = ao_Db.GetFields(ac_Cursor, "LEV_Id")
  
  md_ModuleSurface = ao_Db.GetFields(ac_Cursor, "ModuleSurface")
  UM_Code = ao_Db.GetFields(ac_Cursor, "UM_Code")
  UM_Name = ao_Db.GetFields(ac_Cursor, "UM_Name")
  OFD_PU = ao_Db.GetFields(ac_Cursor, "OFD_PU")
  OFD_Qty = ao_Db.GetFields(ac_Cursor, "OFD_Qty")
  OFD_QtyA = ao_Db.GetFields(ac_Cursor, "OFD_QtyA")
  OFD_Cost = ao_Db.GetFields(ac_Cursor, "OFD_Cost")
  OFD_CostA = ao_Db.GetFields(ac_Cursor, "OFD_CostA")
  OFD_Price = ao_Db.GetFields(ac_Cursor, "OFD_Price")
  OFD_PriceA = ao_Db.GetFields(ac_Cursor, "OFD_PriceA")
  
  OFD_HPrice = ao_Db.GetFields(ac_Cursor, "OFD_HPrice")
  OFD_IctpPCS = ao_Db.GetFields(ac_Cursor, "OFD_IctpPCS")
  OFD_Ictp = ao_Db.GetFields(ac_Cursor, "OFD_Ictp")
  OFD_MarginS = ao_Db.GetFields(ac_Cursor, "OFD_MarginS")
  OFD_GTN = ao_Db.GetFields(ac_Cursor, "OFD_GTN")
  OFD_MarginMin = ao_Db.GetFields(ac_Cursor, "OFD_MarginMin")
  CURR_Code = ao_Db.GetFields(ac_Cursor, "CURR_Code")
  CURR_CodeCOF = ao_Db.GetFields(ac_Cursor, "CURR_CodeCOF")
  OFD_Rate = ao_Db.GetFields(ac_Cursor, "OFD_Rate")
  md_OFD_Disco = ao_Db.GetFields(ac_Cursor, "OFD_Disco")
  
  OFD_Main = ao_Db.GetFields(ac_Cursor, "OFD_Main")
  OFD_IdPar = ao_Db.GetFields(ac_Cursor, "OFD_IdPar")
  OFD_Valid = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_Valid"), "X", vbTextCompare) = 0
  OFD_Found = ao_Db.GetFields(ac_Cursor, "OFD_Found")
  ERR_Type = ao_Db.GetFields(ac_Cursor, "ERR_Type")
  OFD_AppBy = ao_Db.GetFields(ac_Cursor, "OFD_AppBy")
  OFD_ApDat = ao_Db.GetFields(ac_Cursor, "OFD_ApDat")
  OFD_IsAlt = ao_Db.GetFields(ac_Cursor, "OFD_IsAlt")
  OFD_AltPa = ao_Db.GetFields(ac_Cursor, "OFD_AltPa")
  OFD_WshDat = ao_Db.GetFields(ac_Cursor, "OFD_WshDat")
  OFD_ShpDat = ao_Db.GetFields(ac_Cursor, "OFD_ShpDat")
  OFD_DelDat = ao_Db.GetFields(ac_Cursor, "OFD_DelDat")
  OFD_PlaDat = ao_Db.GetFields(ac_Cursor, "OFD_PlaDat")
  OFD_PlaUsr = ao_Db.GetFields(ac_Cursor, "OFD_PlaUsr")
  OFD_B7Sta = ao_Db.GetFields(ac_Cursor, "OFD_B7Sta")
  OFD_Split = ao_Db.GetFields(ac_Cursor, "OFD_Split")
  OFD_InfoB7 = ao_Db.GetFields(ac_Cursor, "OFD_InfoB7")
  OFD_OrdNrB7 = ao_Db.GetFields(ac_Cursor, "OFD_OrdNrB7")
  OFD_PosB7 = ao_Db.GetFields(ac_Cursor, "OFD_PosB7")
  SAE_Id = ao_Db.GetFields(ac_Cursor, "SAE_Id")
  SHP_Id = ao_Db.GetFields(ac_Cursor, "SHP_Id")
  VEN_Id = ao_Db.GetFields(ac_Cursor, "VEN_Id")
  
  OFD_IsFree = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_IsFree"), "X", vbTextCompare) = 0
  OFD_PosCus = ao_Db.GetFields(ac_Cursor, "OFD_PosCus")
  OFD_IsAsItem = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_IsAsItem"), "X", vbTextCompare) = 0
  OFD_HasQty = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_HasQty"), "X", vbTextCompare) = 0
  OFD_HasPrice = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_HasPrice"), "X", vbTextCompare) = 0
  OFD_HasTotal = StrComp(ao_Db.GetFields(ac_Cursor, "OFD_HasTotal"), "X", vbTextCompare) = 0
  
  OFD_SAPSta = ao_Db.GetFields(ac_Cursor, "OFD_SAPSta")
  OFD_SAPAct = ao_Db.GetFields(ac_Cursor, "OFD_SAPAct")
  OFD_SAPInfo = ao_Db.GetFields(ac_Cursor, "OFD_SAPInfo")
  OFD_PosSAP = ao_Db.GetFields(ac_Cursor, "OFD_PosSAP")
  COF_IdOff = ao_Db.GetFields(ac_Cursor, "COF_IdOff")
  OFD_IdOff = ao_Db.GetFields(ac_Cursor, "OFD_IdOff")


  SAE_Name = ao_Db.GetFields(ac_Cursor, "SAE_Name")
  SHP_Name = ao_Db.GetFields(ac_Cursor, "SHP_Name")
  VEN_Name = ao_Db.GetFields(ac_Cursor, "VEN_Name")
  OFD_AltPaName = ao_Db.GetFields(ac_Cursor, "OFD_AltPaName")
  
  SCR_Id = ao_Db.GetFields(ac_Cursor, "SCR_Id")
  DOF_IsVal = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsVal"), "X", vbTextCompare) = 0
  DOF_IsVal0 = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsVal0"), "X", vbTextCompare) = 0
  DOF_IsTxt = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsTxt"), "X", vbTextCompare) = 0
  DOF_IsSchg = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsSchg"), "X", vbTextCompare) = 0
  DOF_IsStp = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_IsStp"), "X", vbTextCompare) = 0
  DOF_CanInv = StrComp(ao_Db.GetFields(ac_Cursor, "DOF_CanInv"), "X", vbTextCompare) = 0
  DOF_Tag = ao_Db.GetFields(ac_Cursor, "DOF_Tag")
  DOF_Name = ao_Db.GetFields(ac_Cursor, "DOF_Name")
  DOF_Desc = ao_Db.GetFields(ac_Cursor, "DOF_Desc")
  DOF_Order = ao_Db.GetFields(ac_Cursor, "DOF_Order")
  DOF_NTemp = ao_Db.GetFields(ac_Cursor, "DOF_NTemp")
  DOF_DTemp = ao_Db.GetFields(ac_Cursor, "DOF_DTemp")

  Exit Sub
ErrHandler:
  Call errorHandler("ReadOfferPos")
End Sub

Public Sub Insert(ByVal ao_Db As Object, ByVal al_U_Code As Long)
On Error GoTo ErrHandler

Dim ls_Req As String

  ls_Req = "exec Cap_OfferDetail_ins1 "
  ls_Req = ls_Req & "$COF_Id$, $OFD_Id$, $Language_Code$, $OFD_Order$, $OFD_Type$, $CAT_Id$, $DOF_Id$, $PRD_Id$, $SPA_Id$, $S_Code$, $OFD_Pos$, $PRD_Code$, $PRD_CodeC$,"
  ls_Req = ls_Req & "$PRD_Name$, $PRD_Desc$, $LEV_Id$, $OFD_QtyA$, $OFD_Qty$, $OFD_QtyPCS$, $OFD_PU$, $OFD_Cost$, $OFD_CostPCS$, $OFD_CostA$, $OFD_TotalC$, $OFD_TotalCA$, $OFD_HPrice$,"
  ls_Req = ls_Req & "$OFD_Price$, $OFD_PricePCS$, $OFD_PriceA$, $OFD_TotalP$, $OFD_TotalPA$, $OFD_IctpPCS$, $OFD_Ictp$, $OFD_TotalI$, $OFD_MarginS$, $OFD_GTN$, $OFD_MarginMin$,"
  ls_Req = ls_Req & "$OFD_Margin$, $OFD_MarginA$, $OFD_Deviation$, $CURR_Code$, $OFD_Rate$, $OFD_Disco$, $OFD_PriceR$, $OFD_TotalR$, $UM_Code$, $OFD_Main$,"
  ls_Req = ls_Req & "$OFD_IdPar$, $OFD_Valid$, $OFD_Found$, $ERR_Type$, $OFD_AppBy$, $OFD_ApDat$, $OFD_IsAlt$, $OFD_AltPa$, $OFD_WshDat$, $OFD_ShpDat$, $OFD_DelDat$,"
  ls_Req = ls_Req & "$OFD_PlaDat$, $OFD_PlaUsr$, $OFD_B7Sta$, $OFD_Split$, $OFD_InfoB7$, $OFD_OrdNrB7$, $OFD_PosB7$, $SAE_Id$, $SHP_Id$, $VEN_Id$, $OFD_IsFree$, $OFD_PosCus$, $OFD_IsAsItem$,"
  ls_Req = ls_Req & "$OFD_HasQty$, $OFD_HasPrice$, $OFD_HasTotal$, $OFD_SAPSta$, $OFD_SAPAct$, $OFD_SAPInfo$, $OFD_PosSAP$, $COF_IdOff$, $OFD_IdOff$,"
  ls_Req = ls_Req & "$Z_Creator$"
  
  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SqlStrKey(COF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SqlStrKey(OFD_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Language_code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Order$", mo_Tools.SqlInt(OFD_Order), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Type$", mo_Tools.SqlInt(OFD_Type), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$CAT_Id$", mo_Tools.SqlIntKey(CAT_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$DOF_Id$", mo_Tools.SqlIntKey(DOF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SPA_Id$", mo_Tools.SqlIntKey(SPA_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$S_Code$", mo_Tools.SqlStrKey(S_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Pos$", mo_Tools.SqlInt(OFD_Pos), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Name$", mo_Tools.SQLStr(PRD_Name), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Desc$", mo_Tools.SQLStr(PRD_Desc), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$LEV_Id$", mo_Tools.SqlIntKey(LEV_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_QtyA$", mo_Tools.SqlDbl(OFD_QtyA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Qty$", mo_Tools.SqlDbl(OFD_Qty), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_QtyPCS$", mo_Tools.SqlInt(OFD_QtyPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PU$", mo_Tools.SqlInt(OFD_PU), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Cost$", mo_Tools.SqlDbl(OFD_Cost), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_CostPCS$", mo_Tools.SqlDbl(OFD_CostPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_CostA$", mo_Tools.SqlDbl(OFD_CostA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalC$", mo_Tools.SqlDbl(OFD_TotalC), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalCA$", mo_Tools.SqlDbl(OFD_TotalCA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HPrice$", mo_Tools.SqlDbl(OFD_HPrice), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Price$", mo_Tools.SqlDbl(OFD_Price), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PricePCS$", mo_Tools.SqlDbl(OFD_PricePCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PriceA$", mo_Tools.SqlDbl(OFD_PriceA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalP$", mo_Tools.SqlDbl(OFD_TotalP), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalPA$", mo_Tools.SqlDbl(OFD_TotalPA), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_IctpPCS$", mo_Tools.SqlDbl(OFD_IctpPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Ictp$", mo_Tools.SqlDbl(OFD_Ictp), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalI$", mo_Tools.SqlDbl(OFD_TotalI), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginS$", mo_Tools.SqlDbl(OFD_MarginS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_GTN$", mo_Tools.SqlDbl(OFD_GTN), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginMin$", mo_Tools.SqlDbl(OFD_MarginMin), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_Margin$", mo_Tools.SqlDbl(OFD_Margin), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginA$", mo_Tools.SqlDbl(OFD_MarginA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Deviation$", mo_Tools.SqlDbl(OFD_Deviation), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Rate$", mo_Tools.SqlDbl(OFD_Rate), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Disco$", mo_Tools.SqlDbl(OFD_Disco), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PriceR$", mo_Tools.SqlDbl(OFD_PriceR), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalR$", mo_Tools.SqlDbl(OFD_TotalR), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$UM_Code$", mo_Tools.SQLStr(UM_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Main$", mo_Tools.SqlInt(OFD_Main), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdPar$", mo_Tools.SqlStrKey(OFD_IdPar), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Valid$", mo_Tools.SqlBool(OFD_Valid), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Found$", mo_Tools.SqlInt(OFD_Found), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$ERR_Type$", mo_Tools.SqlInt(ERR_Type), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_AppBy$", mo_Tools.SQLStr(OFD_AppBy), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_ApDat$", mo_Tools.SqlDate(OFD_ApDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IsAlt$", mo_Tools.SqlInt(OFD_IsAlt), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_AltPa$", mo_Tools.SqlStrKey(OFD_AltPa), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_WshDat$", mo_Tools.SqlDate(OFD_WshDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_ShpDat$", mo_Tools.SqlDate(OFD_ShpDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_DelDat$", mo_Tools.SqlDate(OFD_DelDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PlaDat$", mo_Tools.SqlDate(OFD_PlaDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PlaUsr$", mo_Tools.SQLStr(OFD_PlaUsr), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_B7Sta$", mo_Tools.SqlInt(OFD_B7Sta), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Split$", mo_Tools.SqlInt(OFD_Split), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_InfoB7$", mo_Tools.SQLStr(OFD_InfoB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_OrdNrB7$", mo_Tools.SQLStr(OFD_OrdNrB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PosB7$", mo_Tools.SqlInt(OFD_PosB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SAE_Id$", mo_Tools.SqlIntKey(SAE_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SHP_Id$", mo_Tools.SqlIntKey(SHP_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$VEN_Id$", mo_Tools.SqlStrKey(VEN_Id), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_IsFree$", mo_Tools.SqlBool(OFD_IsFree), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PosCus$", mo_Tools.SQLStr(OFD_PosCus), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IsAsItem$", mo_Tools.SqlBool(OFD_IsAsItem), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasQty$", mo_Tools.SqlBool(OFD_HasQty), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasPrice$", mo_Tools.SqlBool(OFD_HasPrice), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasTotal$", mo_Tools.SqlBool(OFD_HasTotal), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPSta$", mo_Tools.SqlInt(OFD_SAPSta), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPAct$", mo_Tools.SQLStr(OFD_SAPAct), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPInfo$", mo_Tools.SQLStr(OFD_SAPInfo), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_PosSAP$", mo_Tools.SQLStr(OFD_PosSAP), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$COF_IdOff$", mo_Tools.SqlStrKey(COF_IdOff), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdOff$", mo_Tools.SqlStrKey(OFD_IdOff), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$Z_Creator$", mo_Tools.SqlInt(al_U_Code), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Req)
  Exit Sub
ErrHandler:
  Call errorHandler("Insert")
End Sub

Public Sub Update(ByVal ao_Db As Object, ByVal al_U_Code As Long)
On Error GoTo ErrHandler

Dim ls_Req As String

  ls_Req = "exec Cap_OfferDetail_upd1 "
  ls_Req = ls_Req & "$COF_Id$, $OFD_Id$, $Language_Code$, $OFD_Order$, $OFD_Type$, $CAT_Id$, $DOF_Id$, $PRD_Id$, $SPA_Id$, $S_Code$, $OFD_Pos$, $PRD_Code$, $PRD_CodeC$,"
  ls_Req = ls_Req & "$PRD_Name$, $PRD_Desc$, $LEV_Id$, $OFD_QtyA$, $OFD_Qty$, $OFD_QtyPCS$, $OFD_PU$, $OFD_Cost$, $OFD_CostPCS$, $OFD_CostA$, $OFD_TotalC$, $OFD_TotalCA$, $OFD_HPrice$,"
  ls_Req = ls_Req & "$OFD_Price$, $OFD_PricePCS$, $OFD_PriceA$, $OFD_TotalP$, $OFD_TotalPA$, $OFD_IctpPCS$, $OFD_Ictp$, $OFD_TotalI$, $OFD_MarginS$, $OFD_GTN$, $OFD_MarginMin$,"
  ls_Req = ls_Req & "$OFD_Margin$, $OFD_MarginA$, $OFD_Deviation$, $CURR_Code$, $OFD_Rate$, $OFD_Disco$, $OFD_PriceR$, $OFD_TotalR$, $UM_Code$, $OFD_Main$,"
  ls_Req = ls_Req & "$OFD_IdPar$, $OFD_Valid$, $OFD_Found$, $ERR_Type$, $OFD_AppBy$, $OFD_ApDat$, $OFD_IsAlt$, $OFD_AltPa$, $OFD_WshDat$, $OFD_ShpDat$, $OFD_DelDat$,"
  ls_Req = ls_Req & "$OFD_PlaDat$, $OFD_PlaUsr$, $OFD_B7Sta$, $OFD_Split$, $OFD_InfoB7$, $OFD_OrdNrB7$, $OFD_PosB7$, $SAE_Id$, $SHP_Id$, $VEN_Id$, $OFD_IsFree$, $OFD_PosCus$, $OFD_IsAsItem$,"
  ls_Req = ls_Req & "$OFD_HasQty$, $OFD_HasPrice$, $OFD_HasTotal$, $OFD_SAPSta$, $OFD_SAPAct$, $OFD_SAPInfo$, $OFD_PosSAP$, $COF_IdOff$, $OFD_IdOff$,"
  ls_Req = ls_Req & "$Z_Last_Upd_User$"
  
  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SqlStrKey(COF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SqlStrKey(OFD_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Language_code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Order$", mo_Tools.SqlInt(OFD_Order), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Type$", mo_Tools.SqlInt(OFD_Type), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$CAT_Id$", mo_Tools.SqlIntKey(CAT_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$DOF_Id$", mo_Tools.SqlIntKey(DOF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SPA_Id$", mo_Tools.SqlIntKey(SPA_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$S_Code$", mo_Tools.SqlStrKey(S_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Pos$", mo_Tools.SqlInt(OFD_Pos), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Name$", mo_Tools.SQLStr(PRD_Name), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$PRD_Desc$", mo_Tools.SQLStr(PRD_Desc), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$LEV_Id$", mo_Tools.SqlIntKey(LEV_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_QtyA$", mo_Tools.SqlDbl(OFD_QtyA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Qty$", mo_Tools.SqlDbl(OFD_Qty), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_QtyPCS$", mo_Tools.SqlInt(OFD_QtyPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PU$", mo_Tools.SqlInt(OFD_PU), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Cost$", mo_Tools.SqlDbl(OFD_Cost), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_CostPCS$", mo_Tools.SqlDbl(OFD_CostPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_CostA$", mo_Tools.SqlDbl(OFD_CostA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalC$", mo_Tools.SqlDbl(OFD_TotalC), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalCA$", mo_Tools.SqlDbl(OFD_TotalCA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HPrice$", mo_Tools.SqlDbl(OFD_HPrice), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Price$", mo_Tools.SqlDbl(OFD_Price), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PricePCS$", mo_Tools.SqlDbl(OFD_PricePCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PriceA$", mo_Tools.SqlDbl(OFD_PriceA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalP$", mo_Tools.SqlDbl(OFD_TotalP), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalPA$", mo_Tools.SqlDbl(OFD_TotalPA), , , vbTextCompare)
  'ls_Req = Replace(ls_Req, "$OFD_Total$", mo_Tools.SqlDbl(0), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_IctpPCS$", mo_Tools.SqlDbl(OFD_IctpPCS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Ictp$", mo_Tools.SqlDbl(OFD_Ictp), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalI$", mo_Tools.SqlDbl(OFD_TotalI), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginS$", mo_Tools.SqlDbl(OFD_MarginS), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_GTN$", mo_Tools.SqlDbl(OFD_GTN), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginMin$", mo_Tools.SqlDbl(OFD_MarginMin), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Margin$", mo_Tools.SqlDbl(OFD_Margin), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_MarginA$", mo_Tools.SqlDbl(OFD_MarginA), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Deviation$", mo_Tools.SqlDbl(OFD_Deviation), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Rate$", mo_Tools.SqlDbl(OFD_Rate), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Disco$", mo_Tools.SqlDbl(OFD_Disco), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PriceR$", mo_Tools.SqlDbl(OFD_PriceR), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_TotalR$", mo_Tools.SqlDbl(OFD_TotalR), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$UM_Code$", mo_Tools.SQLStr(UM_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Main$", mo_Tools.SqlInt(OFD_Main), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdPar$", mo_Tools.SqlStrKey(OFD_IdPar), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Valid$", mo_Tools.SqlBool(OFD_Valid), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Found$", mo_Tools.SqlInt(OFD_Found), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$ERR_Type$", mo_Tools.SqlInt(ERR_Type), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_AppBy$", mo_Tools.SQLStr(OFD_AppBy), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_ApDat$", mo_Tools.SqlDate(OFD_ApDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IsAlt$", mo_Tools.SqlInt(OFD_IsAlt), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_AltPa$", mo_Tools.SqlStrKey(OFD_AltPa), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_WshDat$", mo_Tools.SqlDate(OFD_WshDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_ShpDat$", mo_Tools.SqlDate(OFD_ShpDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_DelDat$", mo_Tools.SqlDate(OFD_DelDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PlaDat$", mo_Tools.SqlDate(OFD_PlaDat), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PlaUsr$", mo_Tools.SQLStr(OFD_PlaUsr), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_B7Sta$", mo_Tools.SqlInt(OFD_B7Sta), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Split$", mo_Tools.SqlInt(OFD_Split), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_InfoB7$", mo_Tools.SQLStr(OFD_InfoB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_OrdNrB7$", mo_Tools.SQLStr(OFD_OrdNrB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PosB7$", mo_Tools.SqlInt(OFD_PosB7), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SAE_Id$", mo_Tools.SqlIntKey(SAE_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$SHP_Id$", mo_Tools.SqlIntKey(SHP_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$VEN_Id$", mo_Tools.SqlStrKey(VEN_Id), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$OFD_IsFree$", mo_Tools.SqlBool(OFD_IsFree), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PosCus$", mo_Tools.SQLStr(OFD_PosCus), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IsAsItem$", mo_Tools.SqlBool(OFD_IsAsItem), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasQty$", mo_Tools.SqlBool(OFD_HasQty), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasPrice$", mo_Tools.SqlBool(OFD_HasPrice), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_HasTotal$", mo_Tools.SqlBool(OFD_HasTotal), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPSta$", mo_Tools.SqlInt(OFD_SAPSta), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPAct$", mo_Tools.SQLStr(OFD_SAPAct), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_SAPInfo$", mo_Tools.SQLStr(OFD_SAPInfo), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_PosSAP$", mo_Tools.SQLStr(OFD_PosSAP), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$COF_IdOff$", mo_Tools.SqlStrKey(COF_IdOff), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdOff$", mo_Tools.SqlStrKey(OFD_IdOff), , , vbTextCompare)
  
  ls_Req = Replace(ls_Req, "$Z_Last_Upd_User$", mo_Tools.SqlInt(al_U_Code), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Req, 1)
  Exit Sub
ErrHandler:
  Call errorHandler("Update")
End Sub

Public Sub Drop(ByVal ao_Db As Object, ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
Dim ls_Req As String

  ls_Req = "exec Cap_OfferDetail_del2 $COF_ID$, $OFD_IdPar$, $OFD_Id$, $Z_Last_Upd_User$"
  
  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(COF_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_IdPar$", mo_Tools.SQLStr(OFD_IdPar), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SQLStr(OFD_Id), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Z_Last_Upd_User$", mo_Tools.SqlInt(al_U_Code), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Req)
  Exit Sub
ErrHandler:
  Call errorHandler("Drop")
End Sub

Public Function LoadVendor(ByVal ao_Db As Object, ByVal as_CT_Code As String)
On Error GoTo ErrHandler

Dim ls_Req As String
Dim lc_Cursor As Long

  ls_Req = "exec DPC_VendorCountry_sel2 $CT_Code$, $Language_Code$"
  ls_Req = Replace(ls_Req, "$CT_Code$", mo_Tools.SQLStr(as_CT_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(ao_Db, ls_Req)
  VEN_Id = ao_Db.GetFields(lc_Cursor, "VEN_Id")
  VEN_Name = ao_Db.GetFields(lc_Cursor, "VEN_Name")
  Call ao_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call errorHandler("LoadVendor")
End Function

Public Function LoadShipPoint(ByVal ao_Db As Object, ByVal as_CT_Code As String)
On Error GoTo ErrHandler

Dim ls_Req As String
Dim lc_Cursor As Long

  ls_Req = "exec DPC_ShipPointCountry_sel2 $CT_Code$, $Language_Code$"
  ls_Req = Replace(ls_Req, "$CT_Code$", mo_Tools.SQLStr(as_CT_Code), , , vbTextCompare)
  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(ao_Db, ls_Req)
  SHP_Id = ao_Db.GetFields(lc_Cursor, "SHP_Id")
  SHP_Name = ao_Db.GetFields(lc_Cursor, "SHP_Name")
  Call ao_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call errorHandler("LoadShipPoint")
End Function

Public Property Get OFD_TotalC() As Double
On Error GoTo ErrHandler
  
  OFD_TotalC = mo_Tools.RoundTo(OFD_Qty * OFD_Cost)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalC.Get")
End Property

Public Property Get OFD_TotalCA() As Double
On Error GoTo ErrHandler
  
  OFD_TotalCA = mo_Tools.RoundTo(OFD_QtyA * OFD_CostA)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalA.Get")
End Property

Public Property Get OFD_TotalP() As Double
On Error GoTo ErrHandler
  
  OFD_TotalP = mo_Tools.RoundTo(OFD_Qty * OFD_Price)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalP.Get")
End Property

Public Property Get OFD_TotalR() As Double
On Error GoTo ErrHandler
  
  OFD_TotalR = mo_Tools.RoundTo(OFD_Qty * OFD_PriceR)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalR.Get")
End Property

Public Property Get OFD_TotalPA() As Double
On Error GoTo ErrHandler
  
  OFD_TotalPA = mo_Tools.RoundTo(OFD_QtyA * OFD_PriceA)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalPA.Get")
End Property

Public Property Get OFD_TotalI() As Double
On Error GoTo ErrHandler
  
  OFD_TotalI = mo_Tools.RoundTo(OFD_Qty * OFD_Ictp)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_TotalI.Get")
End Property

Public Property Get OFD_Deviation() As Double
On Error GoTo ErrHandler
  
  OFD_Deviation = OFD_Price - OFD_HPrice
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Deviation.Get")
End Property

Public Property Get OFD_Margin() As Double
On Error GoTo ErrHandler
  
  
  OFD_Margin = GetMarginWithoutGTN(OFD_Cost, OFD_Price)
'  If OFD_Cost <= 0 Then
'    OFD_Margin = 0
'  ElseIf OFD_Cost >= OFD_Price Then
'    OFD_Margin = ((OFD_Price / OFD_Cost) - 1) * 100
'  Else
'    OFD_Margin = (1 - (OFD_Cost / OFD_Price)) * 100
'  End If
  Exit Property
ErrHandler:
  Call errorHandler("OFD_Margin.Get")
End Property

Public Property Get OFD_MarginA() As Double
On Error GoTo ErrHandler
  
  OFD_MarginA = GetMarginWithoutGTN(OFD_Cost, OFD_PriceA)
'  If OFD_Cost <= 0 Then
'    OFD_MarginA = 0
'  ElseIf OFD_Cost >= OFD_PriceA Then
'    OFD_MarginA = ((OFD_PriceA / OFD_Cost) - 1) * 100
'  Else
'    OFD_MarginA = (1 - (OFD_Cost / OFD_PriceA)) * 100
'  End If
  Exit Property
ErrHandler:
  Call errorHandler("OFD_MarginA.Get")
End Property

Public Property Get OFD_CostPU() As Double
On Error GoTo ErrHandler

  OFD_CostPU = mo_Tools.RoundTo(OFD_CostPCS * OFD_PU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostPU.Get")
End Property

Public Property Get OFD_CostAPU() As Double
On Error GoTo ErrHandler

  OFD_CostAPU = mo_Tools.RoundTo(OFD_CostAPCS * OFD_PU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostAPU.Get")
End Property

Public Property Get OFD_PricePU() As Double
On Error GoTo ErrHandler

  OFD_PricePU = mo_Tools.RoundTo(OFD_PricePCS * OFD_PU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PricePU.Get")
End Property

Public Property Get OFD_PriceAPU() As Double
On Error GoTo ErrHandler

  OFD_PriceAPU = mo_Tools.RoundTo(OFD_PriceAPCS * OFD_PU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceAPU.Get")
End Property

Public Property Get OFD_PriceAPCS() As Double
On Error GoTo ErrHandler

  OFD_PriceAPCS = mo_Tools.RoundTo(md_OFD_PriceAPCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceAPCS.Get")
End Property

Public Property Get OFD_PriceAM2() As Double
On Error GoTo ErrHandler

  OFD_PriceAM2 = mo_Tools.RoundTo(md_OFD_PriceAM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceAM2.Get")
End Property

Public Property Get OFD_PricePCS() As Double
On Error GoTo ErrHandler

  OFD_PricePCS = mo_Tools.RoundTo(md_OFD_PricePCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PricePCS.Get")
End Property

Public Property Get OFD_PriceM2() As Double
On Error GoTo ErrHandler

  OFD_PriceM2 = mo_Tools.RoundTo(md_OFD_PriceM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_PriceM2.Get")
End Property

Public Property Get OFD_CostAPCS() As Double
On Error GoTo ErrHandler

  OFD_CostAPCS = mo_Tools.RoundTo(md_OFD_CostAPCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostAPCS.Get")
End Property

Public Property Get OFD_CostAM2() As Double
On Error GoTo ErrHandler

  OFD_CostAM2 = mo_Tools.RoundTo(md_OFD_CostAM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostAM2.Get")
End Property

Public Property Get OFD_CostPCS() As Double
On Error GoTo ErrHandler

  OFD_CostPCS = mo_Tools.RoundTo(md_OFD_CostPCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostPCS.Get")
End Property

Public Property Get OFD_CostM2() As Double
On Error GoTo ErrHandler

  OFD_CostM2 = mo_Tools.RoundTo(md_OFD_CostM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_CostM2.Get")
End Property

Public Property Get OFD_QtyPCS() As Double
On Error GoTo ErrHandler

  OFD_QtyPCS = mo_Tools.RoundTo(md_OFD_QtyPCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyPCS.Get")
End Property

Public Property Get OFD_QtyM2() As Double
On Error GoTo ErrHandler

  OFD_QtyM2 = mo_Tools.RoundTo(md_OFD_QtyM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyM2.Get")
End Property

Public Property Get OFD_QtyPU() As Double
On Error GoTo ErrHandler

  OFD_QtyPU = mo_Tools.RoundTo(md_OFD_QtyPU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyPU.Get")
End Property

Public Property Get OFD_QtyAPCS() As Double
On Error GoTo ErrHandler

  OFD_QtyAPCS = mo_Tools.RoundTo(md_OFD_QtyAPCS)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyAPCS.Get")
End Property

Public Property Get OFD_QtyAM2() As Double
On Error GoTo ErrHandler

  OFD_QtyAM2 = mo_Tools.RoundTo(md_OFD_QtyAM2)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyAM2.Get")
End Property

Public Property Get OFD_QtyAPU() As Double
On Error GoTo ErrHandler

  OFD_QtyAPU = mo_Tools.RoundTo(md_OFD_QtyAPU)
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyAPU.Get")
End Property

Public Property Get IsPriceFound() As Boolean
On Error GoTo ErrHandler

  IsPriceFound = (OFD_Found = 1)
  Exit Property
ErrHandler:
  Call errorHandler("IsPriceFound")
End Property

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler
  
  as_Text = Replace(as_Text, "$SCH_Name$", SCH_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SCH_Desc$", SCH_Desc, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call errorHandler("ReplaceValuePlaceholder")
End Function
' Standard error handler
Private Sub errorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

